// Copyright (C) 2009 - Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Containing Verilog Model for the Atoms:                                   //
//                                                                           //
//                         cycloneiv_hssi_rx_pma                              //
//                         cycloneiv_hssi_tx_pma                              //
//                         cycloneiv_hssi_tx_pcs                              //
//                         cycloneiv_hssi_rx_pcs                              //
//                         cycloneiv_hssi_cmu                                 //
//                         cycloneiv_hssi_calibration_block                   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_reg
//
// Description : Simulation model for a simple DFF.
//               This is used for registering the enable inputs.
//               No timing, powers upto 0.
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1ps / 1ps
module cycloneiv_hssi_tx_pma_sub_reg (
        input wire clk,
        input tri1 ena,
        input wire d,
        input tri1 clrn,
        input tri1 prn,
	output wire q
);

// BUFFER INPUTS

// INTERNAL VARIABLES
reg q_tmp;
wire q_wire;

// TIMING PATHS
specify
	$setuphold(posedge clk, d, 0, 0);
       	(posedge clk => (q +: q_tmp)) = (0, 0);
       	(negedge clrn => (q +: q_tmp)) = (0, 0);
       	(negedge prn => (q +: q_tmp)) = (0, 0);
endspecify

initial q_tmp = 0;

always @ (posedge clk or negedge clrn or negedge prn )
begin
	if (prn == 1'b0)
        	q_tmp <= 1;
        else if (clrn == 1'b0)
            	q_tmp <= 0;
        else if ((clk == 1) & (ena == 1'b1))
            	q_tmp <= d;
end

assign q_wire = q_tmp;

and (q, q_wire, 1'b1);

endmodule // cycloneiv_hssi_tx_pma_sub_reg

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_out_block
//
// Description : Negative edge triggered register on the Tx output.
//               Also, optionally generates an identical/inverted output clock
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps
module cycloneiv_hssi_tx_pma_sub_out_block 
#(
	parameter bypass_serializer = "false",
	parameter invert_clock = "false",
	parameter use_falling_clock_edge = "false"
)
(
	input wire clk,
        input wire datain,
        input wire devclrn,
        input wire devpor,
	output wire dataout
);

// INTERNAL VARIABLES AND NETS
reg dataout_tmp;
reg clk_last_value;

reg bypass_mode;
reg invert_mode;
reg falling_clk_out;

// BUFFER INPUTS

// TEST PARAMETER VALUES
initial
begin
	falling_clk_out = (use_falling_clock_edge == "true")	? 1'b1 : 1'b0;
	bypass_mode = (bypass_serializer == "true")		? 1'b1 : 1'b0;
	invert_mode = (invert_clock == "true")			? 1'b1 : 1'b0;
end

// TIMING PATHS
specify
	if (bypass_mode == 1'b1)
        	(clk => dataout) = (0, 0);

        if (bypass_mode == 1'b0 && falling_clk_out == 1'b1)
            	(negedge clk => (dataout +: dataout_tmp)) = (0, 0);

        if (bypass_mode == 1'b0 && falling_clk_out == 1'b0)
            	(datain => (dataout +: dataout_tmp)) = (0, 0);
endspecify

initial
begin
	clk_last_value = 0;
        dataout_tmp = 0;
end

always @(clk or datain or devclrn or devpor)
begin
	if ((devpor === 1'b0) || (devclrn === 1'b0))
        begin
        	dataout_tmp <= 0;
        end
        else 
	begin
        	if (bypass_serializer == "false")
            	begin
                	if (use_falling_clock_edge == "false")
                    		dataout_tmp <= datain;

                	if ((clk === 1'b0) && (clk_last_value !== clk))
                	begin
                    		if (use_falling_clock_edge == "true")
                        		dataout_tmp <= datain;
                	end
            	end // bypass is off
       		else 
       		begin
       			// generate clk_out
                	if (invert_clock == "false")
                		dataout_tmp <= clk;
                	else
                    		dataout_tmp <= !clk;
       		end // clk output
       end
        	clk_last_value <= clk;
end // always

and (dataout, dataout_tmp, 1'b1);

endmodule //cycloneiv_hssi_tx_pma_sub_out_block

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_parallel_register
//
// Description : Register for the 10 data input channels of the Cyclone IV GX 
//               LVDS Tx
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps
module cycloneiv_hssi_tx_pma_sub_parallel_register 
#( 	
	parameter channel_width = 4
)
(
	input wire clk,
	input wire enable,
	input wire [channel_width - 1:0] datain,
	input wire devclrn,
	input wire devpor,
	output wire [channel_width - 1:0] dataout
);

    // INTERNAL VARIABLES AND NETS
reg clk_last_value;
reg [channel_width - 1:0] dataout_tmp;

// TIMING PATHS
specify
	(posedge clk => (dataout +: dataout_tmp)) = (0, 0);
        $setuphold(posedge clk, datain, 0, 0);
endspecify

initial
begin
        clk_last_value = 0;
        dataout_tmp = 'b0;
end

always @(clk or enable or devpor or devclrn)
begin
        if ((devpor === 1'b0) || (devclrn === 1'b0))
        begin
        	dataout_tmp <= 'b0;
        end
        else 
	begin
		if ((clk === 1'b1) && (clk_last_value !== clk))
            	begin
                	if (enable === 1'b1)
                	begin
                    		dataout_tmp <= datain;
                	end
            	end
        end
        clk_last_value <= clk;

end // always

assign dataout = dataout_tmp; 

endmodule //cycloneiv_hssi_tx_pma_sub_parallel_register

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_ser
//
// Description : Timing simulation model for the Cyclone IV GX LVDS Tx WYSIWYG.
//               It instantiates the following sub-modules :
//               1) primitive DFFE
//               2) cycloneiv_hssi_tx_pma_sub_parallel_register and
//               3) cycloneiv_hssi_tx_pma_sub_out_block
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps
module cycloneiv_hssi_tx_pma_sub_ser 
#(
	parameter channel_width                  	= 8,
	parameter bypass_serializer              	= "false",
    	parameter invert_clock                   	= "false",
    	parameter use_falling_clock_edge         	= "false", 
    	parameter use_serial_data_input          	= "false",
    	parameter use_post_dpa_serial_data_input 	= "false",
    	parameter is_used_as_outclk            		= "false",
    	parameter tx_output_path_delay_engineering_bits = -1,
    	parameter enable_dpaclk_to_lvdsout   		= "off",
    	parameter preemphasis_setting            	= 0,
    	parameter vod_setting                    	= 0,
    	parameter differential_drive             	= 0,
	parameter lpm_type                       	= "cycloneiv_hssi_tx_pma_sub_ser"
)
(	// INPUT PORTS
	input wire [9:0] datain,
    	input wire clk0,
	input wire cgb_pdb,
    	input wire enable0,
    	input wire serialdatain,
    	input wire postdpaserialdatain,
    	input tri1 devclrn,
    	input tri1 devpor,
    	input tri1 dpaclkin,
    	// OUTPUT PORTS
    	output wire dataout,
    	output wire serialfdbkout
);

// INTERNAL VARIABLES AND NETS
integer i;
wire dataout_tmp;
wire deven;
wire dodd;
wire dataout_wire;
wire shift_out_even;
wire shift_out_odd;
reg clk0_last_value;
wire [(channel_width)/2 - 1:0] input_data_even;
wire [(channel_width)/2 - 1:0] input_data_odd;
reg [(channel_width)/2 - 1:0] shift_data_even;
reg [(channel_width)/2 - 1:0] shift_data_odd;
wire txload0;

reg clk0_dly;
wire [(channel_width/2) - 1:0] datain_even; 
wire [(channel_width/2) - 1:0] datain_odd; 
wire [4:0] datain_even_x10;
wire [3:0] datain_even_x8;

wire [4:0] datain_odd_x10;
wire [3:0] datain_odd_x8;

wire dataout_buf;

wire bypass_mode;

reg serial_din_mode;
reg postdpa_serial_din_mode;
reg enable_dpaclk_to_lvdsout_signal;

// TEST PARAMETER VALUES
initial
begin
	serial_din_mode = (use_serial_data_input == "true") ? 1'b1 : 1'b0;
	postdpa_serial_din_mode = (use_post_dpa_serial_data_input == "true") ? 1'b1 : 1'b0;
	enable_dpaclk_to_lvdsout_signal = (enable_dpaclk_to_lvdsout == "on") ? 1'b1 : 1'b0;
end

assign datain_even_x10 = {datain[0], datain[2], datain[4], datain[6], datain[8]};
assign datain_even_x8  = {datain[0], datain[2], datain[4], datain[6]};
assign datain_odd_x10  = {datain[1], datain[3], datain[5], datain[7], datain[9]}; 
assign datain_odd_x8   = {datain[1], datain[3], datain[5], datain[7]};

assign datain_even = (channel_width == 10) ? datain_even_x10 : datain_even_x8 ;
assign datain_odd = (channel_width == 10) ? datain_odd_x10 : datain_odd_x8;
    
// TIMING PATHS
specify
	if (serial_din_mode == 1'b1)
        	(serialdatain => dataout) = (0, 0);

        if (postdpa_serial_din_mode == 1'b1)
            	(postdpaserialdatain => dataout) = (0, 0);

        if (enable_dpaclk_to_lvdsout_signal   == 1'b1)
               	(dpaclkin => dataout) = (0, 0);
endspecify

initial
begin
        i = 0;
        clk0_last_value = 0;
        shift_data_even = 'b0;
	shift_data_odd = 'b0;
end

cycloneiv_hssi_tx_pma_sub_reg txload0_reg (
	.d(enable0),
	.clrn(1'b1),
        .prn(1'b1),
        .ena(1'b1),
        .clk(clk0),
        .q(txload0)
 );
   
// *** tx out
cycloneiv_hssi_tx_pma_sub_out_block output_module_even (
	.clk(clk0),
        .datain(shift_out_even),
        .dataout(deven),
        .devclrn(devclrn),
        .devpor(devpor)
);
defparam 
	output_module_even.bypass_serializer      = bypass_serializer,
    	output_module_even.invert_clock           = invert_clock,
    	output_module_even.use_falling_clock_edge = use_falling_clock_edge;

cycloneiv_hssi_tx_pma_sub_out_block output_module_odd (
	.clk(clk0),
        .datain(shift_out_odd),
        .dataout(dodd),
        .devclrn(devclrn),
        .devpor(devpor)
);
defparam 
	output_module_odd.bypass_serializer      = bypass_serializer,
	output_module_odd.invert_clock           = invert_clock,
	output_module_odd.use_falling_clock_edge = use_falling_clock_edge;
	
    // **** parallel register
cycloneiv_hssi_tx_pma_sub_parallel_register input_reg_even (
	.clk(txload0),
        .enable(1'b1),
        .datain(datain_even),
        .dataout(input_data_even),
        .devclrn(devclrn),
        .devpor(devpor)
);
defparam
	input_reg_even.channel_width = (channel_width/2);

cycloneiv_hssi_tx_pma_sub_parallel_register input_reg_odd (
	.clk(txload0),
        .enable(1'b1),
        .datain(datain_odd),
        .dataout(input_data_odd),
        .devclrn(devclrn),
        .devpor(devpor)
);
defparam 
    input_reg_odd.channel_width = (channel_width/2);
    // ****

always @(clk0)
    begin
	clk0_dly <= clk0;
    end

    assign shift_out_even = shift_data_even[(channel_width)/2 - 1];
    assign shift_out_odd = shift_data_odd[(channel_width)/2 - 1];

always @(clk0 or devclrn or devpor)
begin
        if ((devpor === 1'b0) || (devclrn === 1'b0))
        begin
        	shift_data_even <= 'b0;
	    	shift_data_odd <= 'b0;
        end
        else 
	begin
        	if (bypass_serializer == "false")
            	begin
                	if ((clk0 === 1'b1) && (clk0_last_value !== clk0))
                	begin
                    		if (txload0 === 1'b1)
                    		begin
                        		for (i = 0; i < channel_width; i = i + 1)
					begin
                            			shift_data_even[i] <= input_data_even[i];
		    	    			shift_data_odd[i] <= input_data_odd[i];
					end
                    		end
                    		else 
				begin
                        		for (i = (channel_width - 1); i > 0; i = i - 1 )
					begin
                             			shift_data_even[i] <= shift_data_even[i-1];
			     			shift_data_odd[i] <= shift_data_odd[i-1];
					end
                    		end
                	end
            	end // bypass is off
        end // devpor

        clk0_last_value <= clk0;
end // always

assign #1 dataout_tmp 	= 	(clk0_dly == 1'b1) ? deven : dodd;
assign dataout_wire 	=	(use_serial_data_input == "true") ? 		serialdatain :
                          	(use_post_dpa_serial_data_input == "true") ? 	postdpaserialdatain :
                           	(enable_dpaclk_to_lvdsout == "on") ? 		dpaclkin:
                           	dataout_tmp;

assign dataout_buf 	=	(cgb_pdb == 1'b0) ? 1'b0 : dataout_wire;
			
and (dataout, dataout_buf, 1'b1);
and (serialfdbkout, dataout_buf, 1'b1);

endmodule // cycloneiv_hssi_tx_pma_sub_ser

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2
//
// Description : Module to halve the frequency or double the period of the 
// 		 input clock by 2.                
// 
///////////////////////////////////////////////////////////////////////////////

module cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2 (
	input wire clk, 
	input wire reset_n, 
	output reg clkout
); 

wire 	next_val;
   
// state definition
always@ (posedge clk or negedge reset_n)
begin
	if (!reset_n)
		clkout <= 1'b0;
     	else
        	clkout <= next_val;
end

assign   next_val = ~clkout;

endmodule // div_by_2

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen
//
// Description : Network of byn clock generators; where n = 2, 4, 8    
//               Instantiates tx_rx_det_div_by_2            
// 
///////////////////////////////////////////////////////////////////////////////

module cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen (
	input wire clk, 
	input wire reset_n, 
	output wire clkout
);

wire 	 clk8m, clk4m, clk2m;
 	 
cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2         div_1(.clk(clk), .reset_n(reset_n), .clkout(clk8m));
cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2         div_2(.clk(clk8m), .reset_n(reset_n), .clkout(clk4m));
cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2         div_3(.clk(clk4m), .reset_n(reset_n), .clkout(clk2m));
cycloneiv_hssi_tx_pma_sub_tx_rx_det_div_by_2         div_4(.clk(clk2m), .reset_n(reset_n), .clkout(clkout));

endmodule // clk_gen

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync
//
// Description : Delays input data by 1 clock cycle            
// 
///////////////////////////////////////////////////////////////////////////////

module cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync (
	input wire clk, 
	input wire reset_n, 
	input wire rcv_det, 
	output reg rcv_det_out
); // synthesis syn_black_box

reg 		 rcv_det_mid; 	 

always @ (posedge clk or negedge reset_n)
begin
	if (!reset_n)
       	begin
	  	rcv_det_out <= 1'b0;
	  	rcv_det_mid <= 1'b0;
       	end
     	else
       	begin
          	rcv_det_out <= rcv_det_mid;
	  	rcv_det_mid <= rcv_det;
       	end
end

endmodule // rcv_det_sync

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm
//
// Description : State machine to generate signals/ indications for 
// 		 rcv_found, next_rcv_found and detect_valid       
// 
///////////////////////////////////////////////////////////////////////////////

module cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm (
	input wire clk, 
	input wire reset_n, 
	input wire com_pass, 
	input wire probe_pass, 
	output reg det_on, 
	output reg detect_valid, 
	output reg rcv_found
); // synthesis syn_black_box

reg [2:0] 	 STATE;
reg [2:0] 	 NEXTSTATE;
reg 		 next_rcv_found;
   
reg		fake_rcv_present;
   
// state definition
parameter RESET   = 3'b000;
parameter WAKE    = 3'b001;
parameter STATE_1 = 3'b011;
parameter STATE_2 = 3'b101;
parameter HOLD    = 3'b100;
   
initial
begin
	fake_rcv_present = 1'b1;
end

// State logic and FSM
always @ (posedge clk or negedge reset_n)
begin
	if (!reset_n)
       		STATE <= RESET;
     	else
       		STATE <= NEXTSTATE;
end

always @ (STATE or com_pass)
begin
	case (STATE)
		RESET: NEXTSTATE = WAKE; // after reset; then next state is wake
	  	WAKE: 
		begin
	     		if (com_pass) 
	     			NEXTSTATE = STATE_1; // if com_pass is true; go to state_1 else stay at wake state
	     		else NEXTSTATE = WAKE;
	  	end
	  	STATE_1: NEXTSTATE = STATE_2; // state_1; next state is state_2
	  	STATE_2: NEXTSTATE = HOLD;    // state_2; next state is hold
	  	HOLD: NEXTSTATE = HOLD;	// hold;    stays at hold state 
	  	default: NEXTSTATE = RESET;
	endcase // case(state)
end // always @ (state or com_pass)

// Output logic
always @ (posedge clk or negedge reset_n)
begin
	if (!reset_n)
		rcv_found <= 1'b0;
     	else
          	rcv_found <= next_rcv_found;
end

always @ (NEXTSTATE or probe_pass or fake_rcv_present)
begin
	if ((NEXTSTATE == STATE_2) && (!probe_pass) && fake_rcv_present)  // probe pass goes up slow -> there is rx 
		next_rcv_found = 1'b1;
	else if ((NEXTSTATE == HOLD) && fake_rcv_present)
	   	next_rcv_found = rcv_found;
	else    // probe pass goes up fast -> no rx
	   	next_rcv_found = 1'b0;
end
      
// there is no rcv_det_syn
always @ (STATE)
begin
	if (STATE == RESET)
       		det_on = 1'b0;
     	else
       		det_on = 1'b1;
end
   	
always @ (STATE)
begin
	if (STATE == HOLD)
       		detect_valid = 1'b1;
     	else
       		detect_valid = 1'b0;
end
   
endmodule // rcv_det_fsm

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control
//
// Description : Module to hook up the FSM and detect sync block      
// 
///////////////////////////////////////////////////////////////////////////////

module cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control (
	input wire clk, 
	input wire rcv_det_en, 
	input wire rcv_det_pdb, 
	input wire com_pass, 
	input wire probe_pass, 
	output wire det_on, 
	output wire detect_valid, 
	output wire rcv_found
);

wire 	 rcv_det_syn;
   
cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_sync  xrcv_det_sync (
	clk, 
	rcv_det_pdb, 
	rcv_det_en, 
	rcv_det_syn
);

cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_fsm   xrcv_det_fsm (
	clk, 
	rcv_det_syn, 
	com_pass, 
	probe_pass,
       	det_on, 
	detect_valid, 
	rcv_found
);

endmodule // rcv_det_control

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital
//
// Description : Digital part of the receiver detection  
// 
///////////////////////////////////////////////////////////////////////////////

module cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital (
	input wire oscclk, 
	input wire rcv_det_pdb, 
	input wire rcv_det_en, 
	input wire com_pass, 
	input wire probe_pass, 
	output wire det_on, 
	output wire detect_valid, 
	output wire rcv_found
);

wire   clk;

cycloneiv_hssi_tx_pma_sub_tx_rx_det_clk_gen         xclk_gen (
	oscclk, 
	rcv_det_pdb, 
	clk
);

cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_control xrcv_det_ctrl(
	clk, 
	rcv_det_en, 
	rcv_det_pdb, 
	com_pass, 
	probe_pass, 
	det_on, 
	detect_valid, 
	rcv_found
);
   
endmodule // rcv_det_digital
// This module is the behavior model for rx_det block
// If there is rx -  set parameter RX_EXIST to 1, set to 0 otherwise

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_tx_pma_sub_tx_rx_det
//
// Description : Receiver detect
// 
///////////////////////////////////////////////////////////////////////////////

`timescale 1ps / 1ps

module  cycloneiv_hssi_tx_pma_sub_tx_rx_det (
	input wire rx_det_pdb, 
	input wire clk15m, 
	input wire tx_det_rx, 
	output wire rx_found, 
	output wire rx_det_valid
);

wire 	        com_pass, probe_pass, det_on;
   
parameter 	RX_EXIST = 1'b1;

assign #100000	com_pass = det_on;
assign #100000 	probe_pass = ~RX_EXIST;
   
cycloneiv_hssi_tx_pma_sub_tx_rx_det_rcv_det_digital xrcv_det_digital (
	.oscclk (clk15m), 
	.rcv_det_pdb (rx_det_pdb), 
	.rcv_det_en (tx_det_rx), 
	.com_pass (com_pass), 
	.probe_pass (probe_pass), 
	.det_on (det_on),
	.detect_valid (rx_det_valid),
	.rcv_found (rx_found)
);

endmodule // RX_DET

// ***********************************************************
// This WYSIWYG atom header was automatically generated by the
// Atmgen build tool. To change it, alter data stored in the 
// corresponding WYS file(s) in the tools/atmgen subdirectory.
// ***********************************************************

// *** Section 1 -- Header ***

// -----------------------------------------------------------
//
// Module Name : cycloneiv_hssi_tx_pma
//
// Description : DEV_FAMILY_CYCLONEIV cycloneiv_hssi_tx_pma Verilog simulation model
//
// -----------------------------------------------------------

`timescale 1 ps/1 ps

// *** End of Section 1 ***

// *** Section 3 -- Module declaration ***

module cycloneiv_hssi_tx_pma(
			cgbpowerdn,
			datain,
			detectrxpowerdown,
			diagnosticlpbkin,
			fastrefclk0in,
			forceelecidle,
			powerdn,
			refclk0in,
			refclk0inpulse,
			reverselpbkin,
			rxdetectclk,
			rxdetecten,
			txpmareset,

			clockout,
			dataout,
			rxdetectvalidout,
			rxfoundout,
		        seriallpbkout 	
		);

// *** End of Section 3 ***

// *** Section 4 -- Parameter declarations and default values ***

parameter lpm_type = "cycloneiv_hssi_tx_pma";
parameter channel_number =  0 ;
parameter common_mode = "0.65V";
parameter enable_diagnostic_loopback = "false";
parameter enable_reverse_serial_loopback = "false";
parameter enable_txclkout_loopback = "false";
parameter preemp_tap_1 =  0 ;
parameter protocol_hint = "basic";
parameter rx_detect =  0 ;
parameter serialization_factor =  8 ;
parameter slew_rate = "low";
parameter termination = "OCT 100 Ohms";
parameter use_external_termination = "false";
parameter use_rx_detect = "false";
parameter vod_selection =  0 ;

// LOCAL_PARAMETERS_END
`define CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH 25

// *** End of Section 4 ***

// *** Section 5 -- Port declarations ***

input		      cgbpowerdn;
input  [9 : 0]        datain;
input                 detectrxpowerdown;
input                 diagnosticlpbkin;
input                 fastrefclk0in;
input                 forceelecidle;
input                 powerdn;
input                 refclk0in;
input                 refclk0inpulse;
input                 reverselpbkin;
input                 rxdetectclk;
input                 rxdetecten;
input                 txpmareset;
output                clockout;
output                dataout;
output                rxdetectvalidout;
output                rxfoundout;
output                seriallpbkout;

// *** End of Section 5 ***

// -----------------------------------
// Initial CRAM ---------------------- 
// -----------------------------------

// PMA Per Channel TX Control Register 1 for Channel 0
reg [2:0] init_rvod_sel_non_pcie;

// PMA Per Channel TX Control Register 2 for Channel 0
reg [4:0] init_rpre_em_1t_no_pcie;

// PMA Per Channel TX Control Register 4 for Channel 0
reg [1:0] init_rrx_det;
reg [1:0] init_rslew;
reg [2:0] init_rtx_term_sel;
reg [1:0] init_rtx_vtt;

// PMA Per Channel TX Control Register 6 for Channel 0
reg init_rs_lpbk;

// ---------------------------------------------
// Port declarations with defaults, if any -----
// ---------------------------------------------

// Buffers
wire dataout_buf;

// Resets
tri0 cgbpowerdn;
wire txpma_rstb;
wire cgb_pdb;
wire tx_pdb;

// Serializer
wire ser_dataout;

// RX Detect
reg rxdet_fixclk_reg;
wire rxdet_in_rx_det_pdb; 
wire rxdet_in_clk15m; 
wire rxdet_in_tx_det_rx;
wire rxdet_out_rx_found;
wire rxdet_out_rx_det_valid;

// --------------------------------
// Assign Statements --------------
// --------------------------------

// Resets
assign txpma_rstb	= (txpmareset === 1'b1) ? 1'b0 : 1'b1; // active low	
assign cgb_pdb 		= (cgbpowerdn == 1'b1) ? 1'b0 : 1'b1; // active low // not in wys yet
assign tx_pdb		= (powerdn == 1'b1) ? 1'b0 : 1'b1; // active low

// Serializer
assign clockout 	= refclk0in;
assign seriallpbkout 	= ser_dataout;

assign dataout = (tx_pdb == 1'b0) ? 1'b0 : dataout_buf;	 

assign dataout_buf = 	(enable_reverse_serial_loopback == "true") ? reverselpbkin :
	 	 	(enable_diagnostic_loopback == "true") ? diagnosticlpbkin : 
		 	(enable_txclkout_loopback == "true") ? refclk0in : ser_dataout;

// RX Detect
assign rxdet_in_rx_det_pdb 	= (detectrxpowerdown === 1'b1) ? 1'b0 : 1'b1 ;  // active low
assign rxdet_in_tx_det_rx 	= (rxdetecten === 1'b1) ? 1'b1 : 1'b0;
assign rxdet_in_clk15m 		= rxdet_fixclk_reg; 
assign rxfoundout 		= rxdet_out_rx_found;
assign rxdetectvalidout 	= rxdet_out_rx_det_valid;

// --------------------------------
// CRAM bits ----------------------
// --------------------------------
initial begin
	// TX PMA control register 1
	init_rvod_sel_non_pcie =	(vod_selection == 4) ? 3'b001 : 
					(vod_selection == 6) ? 3'b010 : 
					(vod_selection == 8) ? 3'b011 :
				        (vod_selection == 9) ? 3'b111 : 	
					(vod_selection == 10) ? 3'b100 : 
					(vod_selection == 12) ? 3'b101 : 3'bxxx;
	
	// TX PMA control register 2 
	init_rpre_em_1t_no_pcie	= 	(preemp_tap_1 == 1) ? 5'b00001 : 
					(preemp_tap_1 == 5) ? 5'b00101 : 
					(preemp_tap_1 == 9) ? 5'b01001 :
				        (preemp_tap_1 == 13) ? 5'b01101 : 	
					(preemp_tap_1 == 16) ? 5'b10000 : 
					(preemp_tap_1 == 17) ? 5'b10001 :
				        (preemp_tap_1 == 18) ? 5'b10010 :
					(preemp_tap_1 == 19) ? 5'b10011 :
					(preemp_tap_1 == 20) ? 5'b10100 :
					(preemp_tap_1 == 21) ? 5'b10101 : 5'bxxxxx;

	// TX PMA control register 4
	init_rrx_det		= 	(rx_detect == 1) ? 2'b01 :
					(rx_detect == 2) ? 2'b10 :
					(rx_detect == 3) ? 2'b11 : 2'b00;

	init_rslew 		= 	(alpha_tolower(slew_rate) == "low") 	? 2'b01 : 
					(alpha_tolower(slew_rate) == "medium") 	? 2'b10 : 
					(alpha_tolower(slew_rate) == "high") 	? 2'b11 : 2'b00;
	
	init_rtx_term_sel 	=	(alpha_tolower(termination) == "oct_150_ohms") ? 3'b100 : 
					(alpha_tolower(termination) == "oct_100_ohms") ? 3'b110 : 3'b0xx; 
	
	init_rtx_vtt		=	(alpha_tolower(common_mode) == "tristate") 	? 2'b00 : 
					(alpha_tolower(common_mode) == "0.65v") 	? 2'b11 : 2'bxx;
	
	// TX PMA Control Register 6
	init_rs_lpbk		=	(enable_reverse_serial_loopback == "true") ? 1'b1 : 1'b0;    
end


// -------------------------------
// Instantiations ----------------
// -------------------------------

// Serializer
cycloneiv_hssi_tx_pma_sub_ser tx_pma_ser (
	.clk0(fastrefclk0in),
	.cgb_pdb(cgb_pdb), // not in wys
        .enable0(refclk0inpulse),
        .datain(datain),
        .serialdatain(1'b0),
        .postdpaserialdatain(1'b0),
        .dataout(ser_dataout),
        .serialfdbkout(),
        .dpaclkin(1'b0),
        .devclrn(txpma_rstb),
        .devpor(1'b1)
);
defparam tx_pma_ser.channel_width = serialization_factor;

// RX Detect
cycloneiv_hssi_tx_pma_sub_tx_rx_det m_rxdet(
	.rx_det_pdb    (rxdet_in_rx_det_pdb), 
	.clk15m        (rxdet_in_clk15m), 
	.tx_det_rx     (rxdet_in_tx_det_rx), 
	.rx_found      (rxdet_out_rx_found),
	.rx_det_valid  (rxdet_out_rx_det_valid)
);

// ---------------------------------------
// TX PMA Level Behaviour ----------------
// ---------------------------------------

// RX Detect
// Generates a 125Mhz clock for RX detect
initial 
begin
    rxdet_fixclk_reg = 1'b0;
    forever
    begin
        #4000 rxdet_fixclk_reg = ~rxdet_fixclk_reg;
    end
end

// ---------------------------------------
// Function ------------------------------
// ---------------------------------------

function [8*`CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] alpha_tolower;
input [8*`CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] input_string;

reg [8*`CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] return_string;
reg [8*`CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] reg_string;
reg [8:1] tmp;
reg [8:1] conv_char;
integer byte_count;

begin
	reg_string = input_string;
	for (byte_count = `CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
	begin
    		tmp = reg_string[8*`CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:(8*(`CYCLONEIV_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH-1)+1)];
    		reg_string = reg_string << 8;
    		if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
    		begin
			conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
			return_string = {return_string, conv_char};
    		end
    	else
		return_string = {return_string, tmp};
	end

	alpha_tolower = return_string;
end
endfunction

endmodule
///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_rx_pma_sub_deser
//
// Description : Timing simulation model for the cycloneiv RX PMA
//               Deserializer. This module receives serial data and outputs
//               parallel data word of width = channel_width
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps
module cycloneiv_hssi_rx_pma_sub_deser 
#(
    parameter channel_width = 8
)
(
    input wire fclk,
    input wire deven,
    input wire dodd,
    input wire loaden,
    input wire clr,
    output reg [9:0] rxdat
);

    // INTERNAL VARIABLES AND NETS
    reg [9:0] rxdat_tmp;
    reg [9:0] rxdat_output;
    
    reg [3:0] i;
    reg clr_edge;

initial
    begin
        i = 4'b0;
        clr_edge = 1'b0;
        rxdat_tmp = 10'b0;
        rxdat_output = 10'b0;
    end

always @(loaden or clr)
    begin
    if (clr == 1'b1)
    begin
        rxdat_output <= 1'b0;
        rxdat <= 1'b0;
    end
    else
        if (loaden == 1'b1)
            rxdat_output <= rxdat_tmp;      
        
        else if (loaden == 1'b0)   
            rxdat <= rxdat_output;  
    end

always @(fclk or clr)
begin
    if (clr == 1'b1)
    begin
        rxdat_tmp <= 10'b0;
        i <= 4'b0;
        clr_edge <= 1'b1;
    end
    
    else
    begin
        if (clr_edge == 1'b1)
            clr_edge <= 1'b0;
            
        else if (fclk == 1'b1)
        begin
            rxdat_tmp[7:0] <= rxdat_tmp[9:2];
            rxdat_tmp[8] <= deven;
            rxdat_tmp[9] <= dodd;  
        end         
    end 
end   
        
endmodule //cycloneiv_hssi_rx_pma_sub_deser

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : cycloneiv_hssi_rx_pma_sub_clkdiv
//
// Description : Cyclone IV GX RX PMA Clock divider
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps
module cycloneiv_hssi_rx_pma_sub_clkdiv 
#(
    parameter channel_width = 8
)
(
    input wire rxfclk,
    input wire clr,
    output reg loaden,
    output reg clkdivrx
);

integer clk_count;
reg first_clkcount;
reg clkdivrx_prev;
reg rxloaden;

initial
begin
    first_clkcount = 1'b0;
    clkdivrx_prev = 1'b0;
    clkdivrx = 1'b1;
    clk_count = 1;
    rxloaden = 1'b0;
    loaden = 1'b0;
end

always @(negedge rxfclk)
begin
    if (clkdivrx == 1'b0 || first_clkcount == 1'b0)
    begin
        rxloaden <= 1'b0;
    end
    
    else if (rxfclk === 1'b0 && clkdivrx == 1'b1)
    begin
        begin
            rxloaden <= ~rxloaden;
        end
    end
end

always @(rxfclk or clr)
begin
    if (clr === 1'b1)
    begin
        clkdivrx <= 1'b1;
        loaden <= 1'b0;
        clkdivrx_prev = 1'b1;
        clk_count <= 1;
        first_clkcount <= 1'b0;
    end
    
    else if (clr === 1'b0)
    begin
        // clockout
        if (first_clkcount === 1'b0 && rxfclk === 1'b1)
        begin
            first_clkcount <= 1'b1;
            clk_count <= 1;
            clkdivrx <= 1'b0;
        end
         
        else if (clk_count === channel_width/2)
        begin
            clk_count <= 1;
            clkdivrx <= ~clkdivrx_prev;
        end
        
        else
        begin
            clk_count <= clk_count + 1;
        end
        clkdivrx_prev <= clkdivrx; 
        
        // loaden
        if (rxfclk == 1'b1)
        begin
            if (rxloaden == 1'b1)
            begin
                loaden <= 1'b1;
            end
            else if (rxloaden == 1'b0)
            begin
                loaden <= 1'b0;
            end
        end
    end
end

endmodule //cycloneiv_hssi_rx_pma_sub_clkdiv 
// ***********************************************************
// This WYSIWYG atom header was automatically generated by the
// Atmgen build tool. To change it, alter data stored in the 
// corresponding WYS file(s) in the tools/atmgen subdirectory.
// ***********************************************************

// *** Section 1 -- Header ***

// -----------------------------------------------------------
//
// Module Name : cycloneiv_hssi_rx_pma
//
// Description : DEV_FAMILY_cycloneiv cycloneiv_hssi_rx_pma Verilog simulation model
//
// -----------------------------------------------------------

`timescale 1 ps/1 ps

// *** End of Section 1 ***

// *** Section 3 -- Module declaration ***

module cycloneiv_hssi_rx_pma(
            crupowerdn,
			datain,
			deserclock,
			dpashift,
			locktodata,
			locktoref,
			powerdn,
			ppmdetectrefclk,
			rxpmareset,
			seriallpbkin,
			testbussel,

			analogtestbus,
			clockout,
			datastrobeout,
			diagnosticlpbkout,
			freqlocked,
			locktorefout,
			recoverdataout,
			reverselpbkout,
			signaldetect 
		);

// *** End of Section 3 ***

// *** Section 4 -- Parameter declarations and default values ***

parameter lpm_type = "cycloneiv_hssi_rx_pma";
parameter allow_serial_loopback = "false";
parameter channel_number =  0 ;
parameter common_mode = "0.82V";
parameter deserialization_factor =  8 ;
parameter enable_dpa_shift = "false";
parameter enable_initial_phase_selection = "false";
parameter enable_pd_counter_accumulate_mode = "false";
parameter eq_dc_gain =  0 ;
parameter eq_setting =  1 ;
parameter force_signal_detect = "true";
parameter initial_phase_value =  0 ;
parameter pd1_counter_setting =  5 ;
parameter pd2_counter_setting =  5 ;
parameter pd_rising_edge_only = "false";
parameter phase_step_add_setting =  2 ;
parameter phase_step_sub_setting =  1 ;
parameter ppmselect =  0 ;
parameter protocol_hint = "basic";
parameter send_reverse_serial_loopback_data = "false";
parameter send_reverse_serial_loopback_recovered_clk = "false";
parameter signal_detect_hysteresis =  4 ;
parameter signal_detect_hysteresis_valid_threshold =  1 ;
parameter signal_detect_loss_threshold =  1 ;
parameter termination = "OCT 100 Ohms";
parameter use_external_termination = "false";

// *** End of Section 4 ***

// *** Section 5 -- Port declarations ***

input                 crupowerdn;
input                 datain;
input                 deserclock;
input                 dpashift;
input                 locktodata;
input                 locktoref;
input                 powerdn;
input                 ppmdetectrefclk;
input                 rxpmareset;
input                 seriallpbkin;
input  [3 : 0]        testbussel;
output [7 : 0]        analogtestbus;
output                clockout;
output                datastrobeout;
output                diagnosticlpbkout;
output                freqlocked;
output                locktorefout;
output [9 : 0]        recoverdataout;
output                reverselpbkout;
output                signaldetect;

// *** End of Section 5 ***

// --------------------------------------------------------------------------
// Behavior model starting here ---------------------------------------------
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
//  Model / Submodule Instantiations                                        -
// --------------------------------------------------------------------------

// enable_dpa_shift is turned on
reg rshift_en;
reg dpashift_on;
reg deserclock_dly;
real deserclock_period;
real deserclock_delay;
time prev_posedge;

initial
begin
    rshift_en = (enable_dpa_shift == "true") ? 1'b1 : 1'b0;
    deserclock_period = 0.0;
    deserclock_delay = 0.0;
    prev_posedge = 0.0;
    dpashift_on = 1'b0;
end

// for shifting 0.25 UI of deserclock if enable_dpa_shift==true
always @(dpashift)
begin    
    if (rshift_en == 1'b1)
    begin                                      
        if (dpashift == 1'b1)
        begin
            dpashift_on <= ~dpashift_on;
        end
    end
end

always @(deserclock)
begin    
    deserclock_period   = $time - prev_posedge;
    deserclock_delay    = deserclock_period / 4;
    prev_posedge = $time;

    if (dpashift_on == 1'b1 && dpashift == 1'b0)
    begin
        #(deserclock_delay) deserclock_dly <= deserclock; 
    end
    else
    begin
        deserclock_dly <= deserclock; 
    end            
end

// Deserializer
reg deven;
reg dodd;
reg deven_prev;
reg dodd_prev;
reg init_rrx_s_lpbk;
wire rxdatain;
wire [9:0] rxdata;
wire loaden;
wire clr;
wire datain_in;

reg first_edge;

assign datain_in = (datain === 1'b1 || datain === 1'b0) ? datain : 1'b0; //prevent x/z propagate to gate netlist

assign clr = ((rxpmareset === 1'b1) || (crupowerdn === 1'b1)) ? 1'b1 : 1'b0;
assign rxdatain = (clr === 1'b1) ? 1'b0 : 
                  (init_rrx_s_lpbk === 1'b1) ? seriallpbkin : datain_in;

initial 
begin
    deven = 1'b0;
    dodd = 1'b0;
    deven_prev = 1'b0;
    dodd_prev = 1'b0;    
    first_edge = 1'b1;
    init_rrx_s_lpbk = (allow_serial_loopback == "true") ? 1'b1 : 1'b0;     
end

// generate deven
always @(posedge deserclock_dly or posedge clr)
begin
    deven_prev <= rxdatain;
    if (first_edge == 1'b1)
    begin
        deven <= 1'b0;
        dodd <= 1'b0;
        first_edge <= 1'b0;
    end
    else
    begin
        deven <= deven_prev;
        dodd <= dodd_prev;
    end    
end

// generate dodd
always @(negedge deserclock_dly or posedge clr)
begin
    dodd_prev <= rxdatain;
end

cycloneiv_hssi_rx_pma_sub_deser rx_pma_deser
(
    .fclk(deserclock_dly),
    .deven(deven),
    .dodd(dodd),
    .loaden(loaden),
    .clr(clr),
    .rxdat(rxdata)
);

defparam
    rx_pma_deser.channel_width = deserialization_factor;
    
assign recoverdataout = rxdata;

// CLKDIVRX
wire clkdivrx;
    
cycloneiv_hssi_rx_pma_sub_clkdiv rx_pma_clkdiv
(
    .rxfclk(deserclock_dly),
    .loaden(loaden),
    .clr(clr),
    .clkdivrx(clkdivrx)
);

defparam
    rx_pma_clkdiv.channel_width = deserialization_factor;

assign clockout = clkdivrx;

// signal detect
reg signaldetect_reg;
wire sd_reset;

assign sd_reset = (powerdn === 1'b1 || rxpmareset === 1'b1) ? 1'b1 : 1'b0;

initial 
begin
    signaldetect_reg = 1'b0;
end

always @ (sd_reset or rxdatain)
begin
    if (sd_reset === 1'b1)
        signaldetect_reg <= 1'b0;
    else if (rxdatain === 1'b0 || rxdatain === 1'b1)
        signaldetect_reg <= 1'b1;
    else
        signaldetect_reg <= 1'b0;    
end

assign signaldetect = signaldetect_reg;

// Lock to Ref Out

// simplified freqlock behavior:
//  (1). Responding to rising edge of rxpll_lock with small counter;
//  (2). Responding to analogreset
//  (3). Not responding to loss of rxpll_lock

// freqlock
reg chn_rrx_sd_force;
reg mfreqlocked_reg;
reg [3:0] mfreqlocked_cnt;

wire signal_detect_reg_n;
wire sd_cdr;

assign signal_detect_reg_n = ~signaldetect_reg;

initial
begin
    mfreqlocked_reg = 1'b0;
    mfreqlocked_cnt = 4'b000;
    chn_rrx_sd_force = (force_signal_detect == "false") ? 1'b0 : 1'b1;
end

always @ (posedge ppmdetectrefclk or posedge rxpmareset)
begin
    if (rxpmareset === 1'b1)
        mfreqlocked_reg <= 1'b0;
    else if (mfreqlocked_cnt === 4'b1111)
        mfreqlocked_reg <= 1'b1;
    else
        mfreqlocked_reg <= 1'b0;
end

always @ (posedge ppmdetectrefclk or posedge signal_detect_reg_n)
begin
    if (signal_detect_reg_n === 1'b1)
        mfreqlocked_cnt <= 4'b0000;
    else if (mfreqlocked_cnt !== 4'b1111)
        mfreqlocked_cnt <= mfreqlocked_cnt + 4'b0001;
end

assign sd_cdr = chn_rrx_sd_force | init_rrx_s_lpbk | signaldetect_reg;

assign locktorefout = (clr == 1'b1) ? 1'b0 :
                      (locktodata === 1'b1) ? 1'b1 :
                      (locktoref === 1'b1) ? 1'b0 :
                      ~sd_cdr ? 1'b0 :
                      (sd_cdr & mfreqlocked_reg & ~locktoref) ? 1'b1 : 1'b0;

// loopback
reg rlpbk_data;
reg rlpbk_clk;

initial
begin
    rlpbk_data = (send_reverse_serial_loopback_data == "true") ? 1'b1 : 1'b0;
    rlpbk_clk = (send_reverse_serial_loopback_recovered_clk == "true") ? 1'b1 : 1'b0;
end

assign diagnosticlpbkout = datain_in;
assign reverselpbkout = (rlpbk_clk == 1'b1) ? deserclock_dly :
                        (rlpbk_data == 1'b0) ? 1'b0 : rxdatain;

// drive 0 on analogtestbus
assign analogtestbus = 8'b0;

// freqlocked
wire locktorefout_freqlock;
assign locktorefout_freqlock = (clr == 1'b1) ? 1'b0 :
                      ~sd_cdr ? 1'b0 :
                      (sd_cdr & mfreqlocked_reg) ? 1'b1 : 1'b0;
assign freqlocked = (locktorefout_freqlock === 1'b1) ? 1'b1 : 1'b0;

// datastrobeout
assign datastrobeout = 1'b0;

endmodule

`timescale 1 ns / 1 ps

module cycloneiv_hssi_pcs_reset (hard_reset, clk_2_b, refclk_b_in, scan_mode, rxpcs_rst, txpcs_rst,
                  rxrst_int, txrst_int);

input   hard_reset;
input   clk_2_b;
input   refclk_b_in;
input   scan_mode;
input   rxpcs_rst;
input   txpcs_rst;

output  rxrst_int;
output  txrst_int;

reg 	txrst_sync1, txrst_sync2;
reg     rxrst_sync1, rxrst_sync2;
wire    txrst_int, rxrst_int;

initial begin
    txrst_sync1 = 1'b0;
    txrst_sync2 = 1'b0;
    rxrst_sync1 = 1'b0;
    rxrst_sync2 = 1'b0;
end

always @(posedge hard_reset or posedge clk_2_b)
begin
	if (hard_reset)
		begin
		 rxrst_sync2	<= 1'b1;
		 rxrst_sync1 	<= 1'b1;
		end
	else
		begin
		 rxrst_sync2	<= #1 rxrst_sync1;
		 rxrst_sync1	<= rxpcs_rst;
		end
end

always @(posedge hard_reset or posedge refclk_b_in)
begin
	if (hard_reset)
		begin
		 txrst_sync2	<= 1'b1;
		 txrst_sync1 	<= 1'b1;
		end
	else
		begin
		 txrst_sync2	<= #1 txrst_sync1;
		 txrst_sync1	<= txpcs_rst;
		end
end

// 06-14-02 BT Changed SCAN_SHIFT signal to SCAN_MODE
//assign rxrst_int = !SCAN_SHIFT & rxrst_sync2;
//assign txrst_int = !SCAN_SHIFT & txrst_sync2;
assign rxrst_int = !scan_mode & rxrst_sync2;
assign txrst_int = !scan_mode & txrst_sync2;

endmodule

`timescale 1 ps / 1 ps
module cycloneiv_hssi_digi_chnl_hip_spt (
	rhip_ena,

	pcs_rxd_ch,
	pcs_rxvalid,
	pcs_rxelecidle,
	pcs_rxstatus_ch,
	pcs_phystatus,
	txpma_local_clk,
	txd_ch,
	hip_txd_ch,
	txdetectrxloopback,
	hip_txdetectrxloopback,
	rxpolarity,
	hip_rxpolarity,
	powerdown_ch,
	hip_powerdown_ch,
	txdeemph,
	hip_txdeemph,
	txmargin_ch,
	hip_txmargin_ch,
	eidleinfersel_ch,
	hip_eidleinfersel_ch,
	rate,
	hip_rate,
	hip_txelecidle,

	rxd_ch,
	hip_rxd_ch,
	rxvalid,
	hip_rxvalid,
	rxelecidle,
	hip_rxelecidle,
	rxstatus_ch,
	hip_rxstatus_ch,
	phystatus,
	hip_phystatus,
	hip_tx_clk,
	pcs_txd_ch,
	pcs_txdetectrxloopback,
	pcs_rxpolarity,
	pcs_powerdown_ch,
	pcs_txdeemph,
	pcs_txmargin_ch,
	pcs_eidleinfersel_ch,
	pcs_rate
);

input		rhip_ena;

input	[8:0]	pcs_rxd_ch;
input		pcs_rxvalid;
input		pcs_rxelecidle;
input	[2:0]	pcs_rxstatus_ch;
input		pcs_phystatus;
input		txpma_local_clk;
input	[10:0]	txd_ch;
input	[9:0]	hip_txd_ch;
input		txdetectrxloopback;
input		hip_txdetectrxloopback;
input		rxpolarity;
input		hip_rxpolarity;
input	[1:0]	powerdown_ch;
input	[1:0]	hip_powerdown_ch;
input		txdeemph;
input		hip_txdeemph;
input	[2:0]	txmargin_ch;
input	[2:0]	hip_txmargin_ch;
input	[2:0]	eidleinfersel_ch;
input	[2:0]	hip_eidleinfersel_ch;
input		rate;
input		hip_rate;
input		hip_txelecidle;

output	[8:0]	rxd_ch;
output	[8:0]	hip_rxd_ch;
output		rxvalid;
output		hip_rxvalid;
output		rxelecidle;
output		hip_rxelecidle;
output	[2:0]	rxstatus_ch;
output	[2:0]	hip_rxstatus_ch;
output		phystatus;
output		hip_phystatus;
output		hip_tx_clk;
output	[10:0]	pcs_txd_ch;
output		pcs_txdetectrxloopback;
output		pcs_rxpolarity;
output	[1:0]	pcs_powerdown_ch;
output		pcs_txdeemph;
output	[2:0]	pcs_txmargin_ch;
output	[2:0]	pcs_eidleinfersel_ch;
output	     	pcs_rate;


wire 	[8:0]	pcs_rxd_ch;
wire 	[2:0]	pcs_rxstatus_ch;
wire 	[10:0]	txd_ch;
wire 	[9:0]	hip_txd_ch;
wire 	[1:0]	powerdown_ch;
wire 	[1:0]	hip_powerdown_ch;
wire 	[2:0]	txmargin_ch;
wire 	[2:0]	hip_txmargin_ch;
wire 	[2:0]	eidleinfersel_ch;
wire 	[2:0]	hip_eidleinfersel_ch;
wire  	[8:0]	rxd_ch;
wire  	[8:0]	hip_rxd_ch;
wire  	[2:0]	rxstatus_ch;
wire  	[2:0]	hip_rxstatus_ch;
wire  	[10:0]	pcs_txd_ch;
wire  	[1:0]	pcs_powerdown_ch;
wire  	[2:0]	pcs_txmargin_ch;
wire  	[2:0]	pcs_eidleinfersel_ch;

//// SECTION for SPLIT signals
//// ===============================
////
// MUX/SPLIT #5,6,7,8 in Excel spreadsheet
assign rxd_ch     = pcs_rxd_ch;
assign hip_rxd_ch = rhip_ena ? pcs_rxd_ch : 9'b000000000;

// MUX/SPLIT #16 in Excel spreadsheet
assign rxvalid     = pcs_rxvalid;
assign hip_rxvalid = rhip_ena ? pcs_rxvalid : 1'b0;

// MUX/SPLIT #17 in Excel spreadsheet
assign rxelecidle     = pcs_rxelecidle;
assign hip_rxelecidle = rhip_ena ? pcs_rxelecidle : 1'b1;

// MUX/SPLIT #18,19,20,21 in Excel spreadsheet
assign rxstatus_ch     = pcs_rxstatus_ch;
assign hip_rxstatus_ch = rhip_ena ? pcs_rxstatus_ch : 3'b000;

// MUX/SPLIT #22 in Excel spreadsheet
assign phystatus     = pcs_phystatus;
assign hip_phystatus = rhip_ena ? pcs_phystatus : 1'b0;


   assign hip_tx_clk = txpma_local_clk;
   


//// SECTION for MUX signals
//// ===============================
////
// MUX/SPLIT #1,2,3,4 in Excel spreadsheet
assign pcs_txd_ch = rhip_ena ? {hip_txelecidle, hip_txd_ch} : txd_ch;

// MUX/SPLIT #10 in Excel spreadsheet
assign pcs_txdetectrxloopback = rhip_ena ? hip_txdetectrxloopback : txdetectrxloopback;

// MUX/SPLIT #11 in Excel spreadsheet
assign pcs_rxpolarity = rhip_ena ? hip_rxpolarity : rxpolarity;

// MUX/SPLIT #12,13,14,15 in Excel spreadsheet
assign pcs_powerdown_ch = rhip_ena ? hip_powerdown_ch : powerdown_ch;

// MUX/SPLIT #23 in Excel spreadsheet
assign pcs_txdeemph = rhip_ena ? hip_txdeemph : txdeemph;

// MUX/SPLIT #24,25,26,27 in Excel spreadsheet
assign pcs_txmargin_ch = rhip_ena ? hip_txmargin_ch : txmargin_ch;

// MUX/SPLIT #28,29,30,31 in Excel spreadsheet
assign pcs_eidleinfersel_ch = rhip_ena ? hip_eidleinfersel_ch : eidleinfersel_ch;

// MUX/SPLIT #32 in Excel spreadsheet
assign pcs_rate = rhip_ena ? hip_rate : rate;


endmodule



`timescale 1 ns / 1 ps

module cycloneiv_hssi_phystatus_generator_fsm (
				
				// General signals
				clk,
				reset_n,
				
				//CRAM
				phystat_ena,					// OR of rtx_pipe_enable and rrx_pipe_enable
				rphystatus_rst_toggle,			// no toggle (gen 2) = 0, toggle (option for gen 1) = 1
				
				// PLD Interface
				powerdown,					// power state control
				phystatus,					// communicate completion of power state transitions, receiver 
				// detection, rate change

				rindv_rx,
				rmaster_rx,
				rmaster_up_rx,
				
				// Auto Negotiation Module
				speed_change,					// asserted when signaling rate change between Gen 1 and Gen 2
				speed_change_centrl,				
				speed_change_quad_up,				
				speed_change_quad_down,				
				
				// RX PIPE Interface
				//	p1_sync,
				
				// PMA interface
				// TX PMA
				rx_detect_valid,				// rx_detect_bypass = 0 : Validation of rx_found: 
				// 					synchronized at pipe_interface_top level
				// rx_detect_bypass = 1 : delayed version of txdetectrx
				
				// RX PMA
				power_state_transition_done,		// asserted when successful power state transition occurs
				power_state_transition_done_ena,	// validates power_state_transition_done, currently tied to 0
				
				// Latched Power State Signals
				p1,							// P1 power state from TX PIPE interface
				
				// Internal Power State Done Generator
				internal_done					// faked successful power state transition generated by internal	
				// power state transition done module
				
				);
   
   
   //********************************************************************************
   // INCLUDE STATEMENTS
   //********************************************************************************
   
   //********************************************************************************
   // I/O SIGNALS
   //********************************************************************************
   // General signals
   input	   clk;
   input 	   reset_n;
   
   // CRAM
   input 	   phystat_ena;
   input 	   rphystatus_rst_toggle;
   
   // PLD Interface
   input [1:0] 	   powerdown;
   output 	   phystatus;

   input 	   rindv_rx;               // Select between XAUI mode or indiv  channel mode
   input 	   rmaster_rx;             // New bundle mode MDIO, selects master quad
   input 	   rmaster_up_rx;          // New bundle mode MDIO, selects master quad
   
   // Auto Negotiation Module
   input 	   speed_change;
   input 	   speed_change_centrl;
   input 	   speed_change_quad_up;
   input 	   speed_change_quad_down;
   
   // RX PIPE Interface
   //output			p1_sync;
   
   // PMA interface
   // TX PMA
   input 	   rx_detect_valid;
   
   // RX PMA
   input 	   power_state_transition_done;
   input 	   power_state_transition_done_ena;
   
   
   // Latched Power state signals
   input 	   p1;		// longer recovery time (64 us max) latency
   
   
   // Internal Power State Done Generator
   input 	   internal_done;
   
   //********************************************************************************
   // PARAMETERS
   //********************************************************************************
   
   //********************************************************************************
   // DECLARATIONS
   //********************************************************************************
   //reg		phystatus;
   
   // select between PMA done and internally generated done
   wire 	   done;
   reg 		   pre_power_state_transition_done_sync;
   reg 		   power_state_transition_done_sync;
   reg 		   power_state_transition_done_sync_reg;
   
   // Reset condition
   reg 		   reset_phystatus;
   
   // State transition
   reg 		   state_transition_phystatus;
   
   // Speed Negotiation
   reg 		   speed_change_reg;
   reg 		   speed_change_sync;
   reg 		   speed_change_sync_reg;
   reg 		   speed_change_phystatus;
   
   // Receiver Detection
   //reg		p1_reg;				// synchronize from tx clk domain to rx clk domain
   //reg		p1_sync;
   
   reg 		   rx_detect_valid_reg;		// Edge detection of receiver detection status signal
   reg 		   rx_detect_valid_phystatus;
   
	// P2 exit detection
   wire 	   decode_p2;
   reg 		   decode_p2_reg;
   reg 		   decode_p2_reg1;
   reg 		   phystatus_high_sel;
   reg 		   phystatus_high_sel_reg;
   
   // Reset
   reg 		   phystatus_toggle_sel;
   reg 		   phystatus_toggle_sel_reg;
   
   reg 		   pre_phystatus;
   
   wire 	   speed_change_local;
   
   reg 		   speed_change_centrl_del1;
   reg 		   speed_change_centrl_del2;
   
   
   //********************************************************************************
   // ASSIGN STATEMENTS
   //********************************************************************************
   // Move to PLD interface
   assign 	   phystatus = (~decode_p2 && decode_p2_reg1)? 1'b1: pre_phystatus;
   //assign phystatus= pre_phystatus;
   
   assign 	   done = power_state_transition_done_ena? (power_state_transition_done_sync && ! power_state_transition_done_sync_reg): internal_done;
   
   assign 	   decode_p2 = (powerdown == 2'b11)? phystat_ena: 1'b0;
   
   //********************************************************************************
   // SUBMODULE INSTANTIATIONS
   //********************************************************************************
   
   //********************************************************************************
   // MAIN CODE
   //********************************************************************************
   // Reset phystatus generation
   
   // Phystatus is asserted during reset and then the successful 'transition' into P1 is signal by the assertion
   // phystatus for 1 cycle.  Unlike regular operation, the first entry into P1 is not indicated by a 'done' signal
   // The assertion of phystatus occurs 4 cycles after reset is released
   always @ (reset_n)
     begin
	if (~reset_n)
	  reset_phystatus	= 1'b1;
	else
	  reset_phystatus	= 1'b0;
     end
   
   always @ (reset_n or rphystatus_rst_toggle or done or phystatus_toggle_sel_reg)
     begin
	if (~reset_n)
	  phystatus_toggle_sel 	= 1'b1;
	else if (rphystatus_rst_toggle | done)
	  phystatus_toggle_sel	= 1'b0;
	else
	  phystatus_toggle_sel	= phystatus_toggle_sel_reg;
     end
   
   
   always @ (posedge clk or negedge reset_n)
     begin
	if (~reset_n)
	  begin
	     phystatus_toggle_sel_reg	<= #1 1'b1;
	     phystatus_high_sel_reg	<= #1 1'b1;
	  end
	else
	  begin
	     phystatus_toggle_sel_reg	<= #1 phystatus_toggle_sel;
	     phystatus_high_sel_reg	<= #1 phystatus_high_sel;
	  end
     end
   // State transition: sync PMA signal to local clk.  Currently not being used
   // State transition: Internal done generator indicates that there was a successful state transition.  
   // Illegal transitions have been taken into account by the previous module.
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     pre_power_state_transition_done_sync	<= #1 1'b0;
	     power_state_transition_done_sync		<= #1 1'b0;
	     power_state_transition_done_sync_reg	<= #1 1'b0;
	     
	  end
	else
	  begin
	     pre_power_state_transition_done_sync	<= #1 power_state_transition_done;
	     power_state_transition_done_sync		<= #1 pre_power_state_transition_done_sync;
	     power_state_transition_done_sync_reg	<= #1 power_state_transition_done_sync;
	     
	  end
     end
   
   always @ (reset_n or done)
     begin
	if (~reset_n)
	  state_transition_phystatus	= 1'b0;
	else if (done)
	  state_transition_phystatus	= 1'b1;
	else
	  state_transition_phystatus	= 1'b0;
     end
   
   
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     speed_change_centrl_del1 <= #1 1'b0;
	     speed_change_centrl_del2 <= #1 1'b0;
	     
	  end
	else
	  begin
	     speed_change_centrl_del1 <= #1 speed_change_centrl;
	     speed_change_centrl_del2 <= #1 speed_change_centrl_del1;
	  end
     end // always @ (posedge clk or negedge reset_n)
      
   assign speed_change_local =   rmaster_rx ? (rindv_rx ? speed_change : speed_change_centrl_del2) : (rmaster_up_rx ? speed_change_quad_up : speed_change_quad_down);  
   
   // Speed Negotiation
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     speed_change_reg		<= #1 1'b0;
	     speed_change_sync		<= #1 1'b0;
	     speed_change_sync_reg	<= #1 1'b0;
	     
	  end
	else
	  begin
	     speed_change_reg		<= #1 speed_change_local;
	     speed_change_sync		<= #1 speed_change_reg;
	     speed_change_sync_reg	<= #1 speed_change_sync;
	  end
     end
   
   
   always @ (reset_n or speed_change_sync or speed_change_sync_reg)
     begin
	if (~reset_n)
	  speed_change_phystatus	= 1'b0;
	else if (~speed_change_sync & speed_change_sync_reg)
	  speed_change_phystatus	= 1'b1;
	else
	  speed_change_phystatus	= 1'b0;
     end
   
   // Receiver Detection
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     //		p1_reg					<= 1'b0;
	     //		p1_sync					<= 1'b0;
	     rx_detect_valid_reg			<= #1 1'b0;
	     
	     //		rx_detect_valid_phystatus	<= 1'b0;
	  end
	else
	  begin
	     //		p1_reg					<= p1;
	     //		p1_sync					<= p1_reg;
	     rx_detect_valid_reg			<= #1 rx_detect_valid;
	     
	     //		rx_detect_valid_phystatus	<= p1_sync && rx_detect_valid && !rx_detect_valid_reg;
	  end
     end
   
   always  @ (reset_n or /*p1_sync*/ p1 or rx_detect_valid or rx_detect_valid_reg)
     begin
	if (~reset_n)
	  rx_detect_valid_phystatus	= 1'b0;
	//	else if (p1_sync && rx_detect_valid && !rx_detect_valid_reg)
	else if (p1 && rx_detect_valid && !rx_detect_valid_reg)
	  rx_detect_valid_phystatus 	= 1'b1;
	else
	  rx_detect_valid_phystatus	= 1'b0;
	
     end
   
   // P2 state exit Detection
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     decode_p2_reg			<= #1 1'b0;
	     decode_p2_reg1			<= #1 1'b0;
	  end
	else
	  begin
	     decode_p2_reg		<= #1 decode_p2;
	     decode_p2_reg1		<= #1 decode_p2_reg;
	  end
     end
   
   always @ (reset_n or decode_p2 or decode_p2_reg or phystatus_high_sel_reg or done)
     begin
	if (~reset_n)
	  phystatus_high_sel	= 1'b0;
	else if (~decode_p2 && decode_p2_reg)
	  phystatus_high_sel	= 1'b1;
	else if (done)
	  phystatus_high_sel	= 1'b0;
	else
	  phystatus_high_sel	= phystatus_high_sel_reg;
     end
   

   
   always @ (reset_n or phystatus_high_sel or reset_phystatus or state_transition_phystatus or rx_detect_valid_phystatus
	     or phystatus_toggle_sel or speed_change_phystatus)
     begin
	if (~reset_n)
	  begin
	     pre_phystatus	= 1'b1;
	  end
	else
	  begin
	     if (phystatus_high_sel || reset_phystatus || state_transition_phystatus || rx_detect_valid_phystatus || phystatus_toggle_sel
                 || speed_change_phystatus)
	       pre_phystatus	= 1'b1;
	     else
	       pre_phystatus	= 1'b0;
	  end
     end // always @ (reset_n or phystatus_high_sel or reset_phystatus or state_transition_phystatus or rx_detect_valid_phystatus...
   
endmodule // phystatus_generator_fsm



//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 53 oper_mux 1 cycloneiv_hssi_phystatus_generator_fsm 1 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_phystatus_generator
	( 
	clk,
	latched_p0,
	latched_p0s,
	latched_p1,
	latched_p2,
	phystat_ena,
	phystatus,
	power_state_transition_done,
	power_state_transition_done_ena,
	powerdown,
	reset_n,
	rindv_rx,
	rmaster_rx,
	rmaster_up_rx,
	rphystatus_delay,
	rphystatus_rst_toggle,
	rx_detect_valid,
	speed_change,
	speed_change_centrl,
	speed_change_quad_down,
	speed_change_quad_up) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p0;
	input   latched_p0s;
	input   latched_p1;
	input   latched_p2;
	input   phystat_ena;
	output   phystatus;
	input   power_state_transition_done;
	input   power_state_transition_done_ena;
	input   [1:0]  powerdown;
	input   reset_n;
	input   rindv_rx;
	input   rmaster_rx;
	input   rmaster_up_rx;
	input   [2:0]  rphystatus_delay;
	input   rphystatus_rst_toggle;
	input   rx_detect_valid;
	input   speed_change;
	input   speed_change_centrl;
	input   speed_change_quad_down;
	input   speed_change_quad_up;

	reg	nllOi21;
	reg	nllOi22;
	reg	nllOl19;
	reg	nllOl20;
	reg	nllOO17;
	reg	nllOO18;
	reg	nlO0l11;
	reg	nlO0l12;
	reg	nlO1i15;
	reg	nlO1i16;
	reg	nlO1O13;
	reg	nlO1O14;
	reg	nlOii10;
	reg	nlOii9;
	reg	nlOil7;
	reg	nlOil8;
	reg	nlOli5;
	reg	nlOli6;
	reg	nlOlO3;
	reg	nlOlO4;
	reg	nlOOl1;
	reg	nlOOl2;
	reg	ni0i;
	reg	ni0l;
	reg	ni1O;
	reg	niii;
	wire	wire_ni0O_CLRN;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n01i;
	reg	n01l;
	reg	n01O;
	reg	n0ii;
	reg	n0il;
	reg	n0iO;
	reg	n0li;
	reg	n0ll;
	reg	n0lO;
	reg	n0Ol;
	reg	n0OO;
	reg	n1lO;
	reg	n1Ol;
	reg	n1OO;
	reg	ni1i;
	reg	ni1l;
	reg	niil;
	reg	niiO;
	reg	nili;
	reg	nill;
	reg	nilO;
	reg	niOi;
	reg	niOl;
	reg	nl1i;
	reg	niOO_clk_prev;
	wire	wire_niOO_CLRN;
	wire	wire_niOO_PRN;
	wire  wire_n1Oi_o;
	wire  wire_nl0O_phystatus;
	wire  nlO0O;
	wire  nlOiO;

	initial
		nllOi21 = 0;
	always @ ( posedge clk)
		  nllOi21 <= nllOi22;
	event nllOi21_event;
	initial
		#1 ->nllOi21_event;
	always @(nllOi21_event)
		nllOi21 <= {1{1'b1}};
	initial
		nllOi22 = 0;
	always @ ( posedge clk)
		  nllOi22 <= nllOi21;
	initial
		nllOl19 = 0;
	always @ ( posedge clk)
		  nllOl19 <= nllOl20;
	event nllOl19_event;
	initial
		#1 ->nllOl19_event;
	always @(nllOl19_event)
		nllOl19 <= {1{1'b1}};
	initial
		nllOl20 = 0;
	always @ ( posedge clk)
		  nllOl20 <= nllOl19;
	initial
		nllOO17 = 0;
	always @ ( posedge clk)
		  nllOO17 <= nllOO18;
	event nllOO17_event;
	initial
		#1 ->nllOO17_event;
	always @(nllOO17_event)
		nllOO17 <= {1{1'b1}};
	initial
		nllOO18 = 0;
	always @ ( posedge clk)
		  nllOO18 <= nllOO17;
	initial
		nlO0l11 = 0;
	always @ ( posedge clk)
		  nlO0l11 <= nlO0l12;
	event nlO0l11_event;
	initial
		#1 ->nlO0l11_event;
	always @(nlO0l11_event)
		nlO0l11 <= {1{1'b1}};
	initial
		nlO0l12 = 0;
	always @ ( posedge clk)
		  nlO0l12 <= nlO0l11;
	initial
		nlO1i15 = 0;
	always @ ( posedge clk)
		  nlO1i15 <= nlO1i16;
	event nlO1i15_event;
	initial
		#1 ->nlO1i15_event;
	always @(nlO1i15_event)
		nlO1i15 <= {1{1'b1}};
	initial
		nlO1i16 = 0;
	always @ ( posedge clk)
		  nlO1i16 <= nlO1i15;
	initial
		nlO1O13 = 0;
	always @ ( posedge clk)
		  nlO1O13 <= nlO1O14;
	event nlO1O13_event;
	initial
		#1 ->nlO1O13_event;
	always @(nlO1O13_event)
		nlO1O13 <= {1{1'b1}};
	initial
		nlO1O14 = 0;
	always @ ( posedge clk)
		  nlO1O14 <= nlO1O13;
	initial
		nlOii10 = 0;
	always @ ( posedge clk)
		  nlOii10 <= nlOii9;
	initial
		nlOii9 = 0;
	always @ ( posedge clk)
		  nlOii9 <= nlOii10;
	event nlOii9_event;
	initial
		#1 ->nlOii9_event;
	always @(nlOii9_event)
		nlOii9 <= {1{1'b1}};
	initial
		nlOil7 = 0;
	always @ ( posedge clk)
		  nlOil7 <= nlOil8;
	event nlOil7_event;
	initial
		#1 ->nlOil7_event;
	always @(nlOil7_event)
		nlOil7 <= {1{1'b1}};
	initial
		nlOil8 = 0;
	always @ ( posedge clk)
		  nlOil8 <= nlOil7;
	initial
		nlOli5 = 0;
	always @ ( posedge clk)
		  nlOli5 <= nlOli6;
	event nlOli5_event;
	initial
		#1 ->nlOli5_event;
	always @(nlOli5_event)
		nlOli5 <= {1{1'b1}};
	initial
		nlOli6 = 0;
	always @ ( posedge clk)
		  nlOli6 <= nlOli5;
	initial
		nlOlO3 = 0;
	always @ ( posedge clk)
		  nlOlO3 <= nlOlO4;
	event nlOlO3_event;
	initial
		#1 ->nlOlO3_event;
	always @(nlOlO3_event)
		nlOlO3 <= {1{1'b1}};
	initial
		nlOlO4 = 0;
	always @ ( posedge clk)
		  nlOlO4 <= nlOlO3;
	initial
		nlOOl1 = 0;
	always @ ( posedge clk)
		  nlOOl1 <= nlOOl2;
	event nlOOl1_event;
	initial
		#1 ->nlOOl1_event;
	always @(nlOOl1_event)
		nlOOl1 <= {1{1'b1}};
	initial
		nlOOl2 = 0;
	always @ ( posedge clk)
		  nlOOl2 <= nlOOl1;
	initial
	begin
		ni0i = 0;
		ni0l = 0;
		ni1O = 0;
		niii = 0;
	end
	always @ ( posedge clk or  negedge wire_ni0O_CLRN)
	begin
		if (wire_ni0O_CLRN == 1'b0) 
		begin
			ni0i <= 0;
			ni0l <= 0;
			ni1O <= 0;
			niii <= 0;
		end
		else if  (nlOiO == 1'b1) 
		begin
			ni0i <= niiO;
			ni0l <= nili;
			ni1O <= niil;
			niii <= nill;
		end
	end
	assign
		wire_ni0O_CLRN = ((nlO0l12 ^ nlO0l11) & reset_n);
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n01i = 0;
		n01l = 0;
		n01O = 0;
		n0ii = 0;
		n0il = 0;
		n0iO = 0;
		n0li = 0;
		n0ll = 0;
		n0lO = 0;
		n0Ol = 0;
		n0OO = 0;
		n1lO = 0;
		n1Ol = 0;
		n1OO = 0;
		ni1i = 0;
		ni1l = 0;
		niil = 0;
		niiO = 0;
		nili = 0;
		nill = 0;
		nilO = 0;
		niOi = 0;
		niOl = 0;
		nl1i = 0;
	end
	always @ (clk or wire_niOO_PRN or wire_niOO_CLRN)
	begin
		if (wire_niOO_PRN == 1'b0) 
		begin
			n00i <= 1;
			n00l <= 1;
			n00O <= 1;
			n01i <= 1;
			n01l <= 1;
			n01O <= 1;
			n0ii <= 1;
			n0il <= 1;
			n0iO <= 1;
			n0li <= 1;
			n0ll <= 1;
			n0lO <= 1;
			n0Ol <= 1;
			n0OO <= 1;
			n1lO <= 1;
			n1Ol <= 1;
			n1OO <= 1;
			ni1i <= 1;
			ni1l <= 1;
			niil <= 1;
			niiO <= 1;
			nili <= 1;
			nill <= 1;
			nilO <= 1;
			niOi <= 1;
			niOl <= 1;
			nl1i <= 1;
		end
		else if  (wire_niOO_CLRN == 1'b0) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n01i <= 0;
			n01l <= 0;
			n01O <= 0;
			n0ii <= 0;
			n0il <= 0;
			n0iO <= 0;
			n0li <= 0;
			n0ll <= 0;
			n0lO <= 0;
			n0Ol <= 0;
			n0OO <= 0;
			n1lO <= 0;
			n1Ol <= 0;
			n1OO <= 0;
			ni1i <= 0;
			ni1l <= 0;
			niil <= 0;
			niiO <= 0;
			nili <= 0;
			nill <= 0;
			nilO <= 0;
			niOi <= 0;
			niOl <= 0;
			nl1i <= 0;
		end
		else 
		if (clk != niOO_clk_prev && clk == 1'b1) 
		begin
			n00i <= n00l;
			n00l <= n0ii;
			n00O <= wire_n1Oi_o;
			n01i <= n01l;
			n01l <= n01O;
			n01O <= n00i;
			n0ii <= n0il;
			n0il <= n0iO;
			n0iO <= n0li;
			n0li <= n0ll;
			n0ll <= ((phystat_ena & (~ power_state_transition_done_ena)) & n0lO);
			n0lO <= (~ (((((~ ((ni1O ^ n0Ol) ^ (~ (nlO1O14 ^ nlO1O13)))) & (~ (ni0i ^ n0OO))) & (~ (ni0l ^ ni1i))) & (~ (niii ^ ni1l))) & (nlO1i16 ^ nlO1i15)));
			n0Ol <= ni1O;
			n0OO <= ni0i;
			n1lO <= n1Ol;
			n1Ol <= n1OO;
			n1OO <= n01i;
			ni1i <= ni0l;
			ni1l <= niii;
			niil <= nilO;
			niiO <= niOi;
			nili <= niOl;
			nill <= nl1i;
			nilO <= latched_p0;
			niOi <= latched_p0s;
			niOl <= latched_p1;
			nl1i <= latched_p2;
		end
		niOO_clk_prev <= clk;
	end
	assign
		wire_niOO_CLRN = ((nlOil8 ^ nlOil7) & reset_n),
		wire_niOO_PRN = (nlOii10 ^ nlOii9);
	oper_mux   n1Oi
	( 
	.data({n1lO, n1Ol, ((nllOi22 ^ nllOi21) & n1OO), ((nllOl20 ^ nllOl19) & n01i), n01l, n01O, n00i, ((nllOO18 ^ nllOO17) & n00l)}),
	.o(wire_n1Oi_o),
	.sel({rphystatus_delay[2:0]}));
	defparam
		n1Oi.width_data = 8,
		n1Oi.width_sel = 3;
	cycloneiv_hssi_phystatus_generator_fsm   nl0O
	( 
	.clk(clk),
	.internal_done(n00O),
	.p1(latched_p1),
	.phystat_ena(phystat_ena),
	.phystatus(wire_nl0O_phystatus),
	.power_state_transition_done(power_state_transition_done),
	.power_state_transition_done_ena(power_state_transition_done_ena),
	.powerdown({powerdown[1:0]}),
	.reset_n(reset_n),
	.rindv_rx(rindv_rx),
	.rmaster_rx(rmaster_rx),
	.rmaster_up_rx(rmaster_up_rx),
	.rphystatus_rst_toggle(rphystatus_rst_toggle),
	.rx_detect_valid(rx_detect_valid),
	.speed_change(speed_change),
	.speed_change_centrl(speed_change_centrl),
	.speed_change_quad_down(speed_change_quad_down),
	.speed_change_quad_up(speed_change_quad_up));
	assign
		nlO0O = 1'b1,
		nlOiO = ((((((((((~ nill) & (~ nili)) & (~ niiO)) & niil) & (nlOOl2 ^ nlOOl1)) | ((((~ nill) & (~ nili)) & niiO) & (~ niil))) | (~ (nlOlO4 ^ nlOlO3))) | ((((~ nill) & nili) & (~ niiO)) & (~ niil))) | (~ (nlOli6 ^ nlOli5))) | (((nill & (~ nili)) & (~ niiO)) & (~ niil))),
		phystatus = wire_nl0O_phystatus;
endmodule //cycloneiv_hssi_phystatus_generator
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 50 mux21 146 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_rx_pipe_interface
	( 
	clk,
	latched_p1,
	polinv_rx,
	polinv_rx_int,
	rclkcmpinsertpad,
	reset_n,
	rind_error_reporting,
	rrdwidth_rx,
	rrx_pipe_enable,
	rx_detect_valid,
	rx_detect_valid_sync,
	rx_found,
	rx_found_sync,
	rxd,
	rxd_ch,
	rxelecidle,
	rxelectricalidle,
	rxpolarity,
	rxstatus,
	rxvalid,
	sigdetni,
	txdetectrx) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p1;
	input   polinv_rx;
	output   polinv_rx_int;
	input   rclkcmpinsertpad;
	input   reset_n;
	input   rind_error_reporting;
	input   rrdwidth_rx;
	input   rrx_pipe_enable;
	input   rx_detect_valid;
	input   rx_detect_valid_sync;
	input   rx_found;
	input   rx_found_sync;
	input   [63:0]  rxd;
	output   [63:0]  rxd_ch;
	output   rxelecidle;
	input   rxelectricalidle;
	input   rxpolarity;
	output   [2:0]  rxstatus;
	output   rxvalid;
	input   sigdetni;
	input   txdetectrx;

	reg	n110l7;
	reg	n110l8;
	reg	n111i11;
	reg	n111i12;
	reg	n111O10;
	reg	n111O9;
	reg	n11ii5;
	reg	n11ii6;
	reg	n11iO3;
	reg	n11iO4;
	reg	n11Ol1;
	reg	n11Ol2;
	reg	nlO0ll41;
	reg	nlO0ll42;
	reg	nlO0Oi39;
	reg	nlO0Oi40;
	reg	nlO0OO37;
	reg	nlO0OO38;
	reg	nlOi0l35;
	reg	nlOi0l36;
	reg	nlOiil33;
	reg	nlOiil34;
	reg	nlOilO31;
	reg	nlOilO32;
	reg	nlOiOl29;
	reg	nlOiOl30;
	reg	nlOl1l27;
	reg	nlOl1l28;
	reg	nlOlii25;
	reg	nlOlii26;
	reg	nlOlli23;
	reg	nlOlli24;
	reg	nlOlOi21;
	reg	nlOlOi22;
	reg	nlOO0i17;
	reg	nlOO0i18;
	reg	nlOO1i19;
	reg	nlOO1i20;
	reg	nlOOiO15;
	reg	nlOOiO16;
	reg	nlOOOl13;
	reg	nlOOOl14;
	reg	n00ii;
	reg	n0ill;
	reg	n0iOi;
	reg	n1l1l;
	reg	n1O0i;
	reg	n1O1O;
	reg	nlOOO;
	reg	nO;
	reg	nl_clk_prev;
	wire	wire_nl_CLRN;
	wire	wire_n000i_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOOl_dataout;
	wire  n11lO;
	wire  nlO00i;
	wire  nlO00l;
	wire  nlO00O;
	wire  nlO01i;
	wire  nlO01l;
	wire  nlO01O;
	wire  nlO0ii;
	wire  nlO0il;
	wire  nlO0iO;
	wire  nlO0li;
	wire  nlOi0i;
	wire  nlOi1l;
	wire  nlOi1O;
	wire  nlOiii;
	wire  nlOili;
	wire  nlOill;
	wire  nlOl0i;
	wire  nlOl0l;
	wire  nlOl0O;
	wire  nlOl1i;
	wire  nlOliO;
	wire  nlOllO;
	wire  nlOlOO;
	wire  nlOO0O;
	wire  nlOO1O;
	wire  nlOOii;
	wire  nlOOil;
	wire  nlOOll;
	wire  nlOOlO;
	wire  nlOOOi;

	initial
		n110l7 = 0;
	always @ ( posedge clk)
		  n110l7 <= n110l8;
	event n110l7_event;
	initial
		#1 ->n110l7_event;
	always @(n110l7_event)
		n110l7 <= {1{1'b1}};
	initial
		n110l8 = 0;
	always @ ( posedge clk)
		  n110l8 <= n110l7;
	initial
		n111i11 = 0;
	always @ ( posedge clk)
		  n111i11 <= n111i12;
	event n111i11_event;
	initial
		#1 ->n111i11_event;
	always @(n111i11_event)
		n111i11 <= {1{1'b1}};
	initial
		n111i12 = 0;
	always @ ( posedge clk)
		  n111i12 <= n111i11;
	initial
		n111O10 = 0;
	always @ ( posedge clk)
		  n111O10 <= n111O9;
	initial
		n111O9 = 0;
	always @ ( posedge clk)
		  n111O9 <= n111O10;
	event n111O9_event;
	initial
		#1 ->n111O9_event;
	always @(n111O9_event)
		n111O9 <= {1{1'b1}};
	initial
		n11ii5 = 0;
	always @ ( posedge clk)
		  n11ii5 <= n11ii6;
	event n11ii5_event;
	initial
		#1 ->n11ii5_event;
	always @(n11ii5_event)
		n11ii5 <= {1{1'b1}};
	initial
		n11ii6 = 0;
	always @ ( posedge clk)
		  n11ii6 <= n11ii5;
	initial
		n11iO3 = 0;
	always @ ( posedge clk)
		  n11iO3 <= n11iO4;
	event n11iO3_event;
	initial
		#1 ->n11iO3_event;
	always @(n11iO3_event)
		n11iO3 <= {1{1'b1}};
	initial
		n11iO4 = 0;
	always @ ( posedge clk)
		  n11iO4 <= n11iO3;
	initial
		n11Ol1 = 0;
	always @ ( posedge clk)
		  n11Ol1 <= n11Ol2;
	event n11Ol1_event;
	initial
		#1 ->n11Ol1_event;
	always @(n11Ol1_event)
		n11Ol1 <= {1{1'b1}};
	initial
		n11Ol2 = 0;
	always @ ( posedge clk)
		  n11Ol2 <= n11Ol1;
	initial
		nlO0ll41 = 0;
	always @ ( posedge clk)
		  nlO0ll41 <= nlO0ll42;
	event nlO0ll41_event;
	initial
		#1 ->nlO0ll41_event;
	always @(nlO0ll41_event)
		nlO0ll41 <= {1{1'b1}};
	initial
		nlO0ll42 = 0;
	always @ ( posedge clk)
		  nlO0ll42 <= nlO0ll41;
	initial
		nlO0Oi39 = 0;
	always @ ( posedge clk)
		  nlO0Oi39 <= nlO0Oi40;
	event nlO0Oi39_event;
	initial
		#1 ->nlO0Oi39_event;
	always @(nlO0Oi39_event)
		nlO0Oi39 <= {1{1'b1}};
	initial
		nlO0Oi40 = 0;
	always @ ( posedge clk)
		  nlO0Oi40 <= nlO0Oi39;
	initial
		nlO0OO37 = 0;
	always @ ( posedge clk)
		  nlO0OO37 <= nlO0OO38;
	event nlO0OO37_event;
	initial
		#1 ->nlO0OO37_event;
	always @(nlO0OO37_event)
		nlO0OO37 <= {1{1'b1}};
	initial
		nlO0OO38 = 0;
	always @ ( posedge clk)
		  nlO0OO38 <= nlO0OO37;
	initial
		nlOi0l35 = 0;
	always @ ( posedge clk)
		  nlOi0l35 <= nlOi0l36;
	event nlOi0l35_event;
	initial
		#1 ->nlOi0l35_event;
	always @(nlOi0l35_event)
		nlOi0l35 <= {1{1'b1}};
	initial
		nlOi0l36 = 0;
	always @ ( posedge clk)
		  nlOi0l36 <= nlOi0l35;
	initial
		nlOiil33 = 0;
	always @ ( posedge clk)
		  nlOiil33 <= nlOiil34;
	event nlOiil33_event;
	initial
		#1 ->nlOiil33_event;
	always @(nlOiil33_event)
		nlOiil33 <= {1{1'b1}};
	initial
		nlOiil34 = 0;
	always @ ( posedge clk)
		  nlOiil34 <= nlOiil33;
	initial
		nlOilO31 = 0;
	always @ ( posedge clk)
		  nlOilO31 <= nlOilO32;
	event nlOilO31_event;
	initial
		#1 ->nlOilO31_event;
	always @(nlOilO31_event)
		nlOilO31 <= {1{1'b1}};
	initial
		nlOilO32 = 0;
	always @ ( posedge clk)
		  nlOilO32 <= nlOilO31;
	initial
		nlOiOl29 = 0;
	always @ ( posedge clk)
		  nlOiOl29 <= nlOiOl30;
	event nlOiOl29_event;
	initial
		#1 ->nlOiOl29_event;
	always @(nlOiOl29_event)
		nlOiOl29 <= {1{1'b1}};
	initial
		nlOiOl30 = 0;
	always @ ( posedge clk)
		  nlOiOl30 <= nlOiOl29;
	initial
		nlOl1l27 = 0;
	always @ ( posedge clk)
		  nlOl1l27 <= nlOl1l28;
	event nlOl1l27_event;
	initial
		#1 ->nlOl1l27_event;
	always @(nlOl1l27_event)
		nlOl1l27 <= {1{1'b1}};
	initial
		nlOl1l28 = 0;
	always @ ( posedge clk)
		  nlOl1l28 <= nlOl1l27;
	initial
		nlOlii25 = 0;
	always @ ( posedge clk)
		  nlOlii25 <= nlOlii26;
	event nlOlii25_event;
	initial
		#1 ->nlOlii25_event;
	always @(nlOlii25_event)
		nlOlii25 <= {1{1'b1}};
	initial
		nlOlii26 = 0;
	always @ ( posedge clk)
		  nlOlii26 <= nlOlii25;
	initial
		nlOlli23 = 0;
	always @ ( posedge clk)
		  nlOlli23 <= nlOlli24;
	event nlOlli23_event;
	initial
		#1 ->nlOlli23_event;
	always @(nlOlli23_event)
		nlOlli23 <= {1{1'b1}};
	initial
		nlOlli24 = 0;
	always @ ( posedge clk)
		  nlOlli24 <= nlOlli23;
	initial
		nlOlOi21 = 0;
	always @ ( posedge clk)
		  nlOlOi21 <= nlOlOi22;
	event nlOlOi21_event;
	initial
		#1 ->nlOlOi21_event;
	always @(nlOlOi21_event)
		nlOlOi21 <= {1{1'b1}};
	initial
		nlOlOi22 = 0;
	always @ ( posedge clk)
		  nlOlOi22 <= nlOlOi21;
	initial
		nlOO0i17 = 0;
	always @ ( posedge clk)
		  nlOO0i17 <= nlOO0i18;
	event nlOO0i17_event;
	initial
		#1 ->nlOO0i17_event;
	always @(nlOO0i17_event)
		nlOO0i17 <= {1{1'b1}};
	initial
		nlOO0i18 = 0;
	always @ ( posedge clk)
		  nlOO0i18 <= nlOO0i17;
	initial
		nlOO1i19 = 0;
	always @ ( posedge clk)
		  nlOO1i19 <= nlOO1i20;
	event nlOO1i19_event;
	initial
		#1 ->nlOO1i19_event;
	always @(nlOO1i19_event)
		nlOO1i19 <= {1{1'b1}};
	initial
		nlOO1i20 = 0;
	always @ ( posedge clk)
		  nlOO1i20 <= nlOO1i19;
	initial
		nlOOiO15 = 0;
	always @ ( posedge clk)
		  nlOOiO15 <= nlOOiO16;
	event nlOOiO15_event;
	initial
		#1 ->nlOOiO15_event;
	always @(nlOOiO15_event)
		nlOOiO15 <= {1{1'b1}};
	initial
		nlOOiO16 = 0;
	always @ ( posedge clk)
		  nlOOiO16 <= nlOOiO15;
	initial
		nlOOOl13 = 0;
	always @ ( posedge clk)
		  nlOOOl13 <= nlOOOl14;
	event nlOOOl13_event;
	initial
		#1 ->nlOOOl13_event;
	always @(nlOOOl13_event)
		nlOOOl13 <= {1{1'b1}};
	initial
		nlOOOl14 = 0;
	always @ ( posedge clk)
		  nlOOOl14 <= nlOOOl13;
	initial
	begin
		n00ii = 0;
		n0ill = 0;
		n0iOi = 0;
		n1l1l = 0;
		n1O0i = 0;
		n1O1O = 0;
	end
	always @ ( posedge clk or  negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			n00ii <= 0;
			n0ill <= 0;
			n0iOi <= 0;
			n1l1l <= 0;
			n1O0i <= 0;
			n1O1O <= 0;
		end
		else 
		begin
			n00ii <= n0ill;
			n0ill <= txdetectrx;
			n0iOi <= rx_detect_valid_sync;
			n1l1l <= n1O1O;
			n1O0i <= rx_detect_valid_sync;
			n1O1O <= txdetectrx;
		end
	end
	initial
	begin
		nlOOO = 0;
		nO = 0;
	end
	always @ (clk or reset_n or wire_nl_CLRN)
	begin
		if (reset_n == 1'b0) 
		begin
			nlOOO <= 1;
			nO <= 1;
		end
		else if  (wire_nl_CLRN == 1'b0) 
		begin
			nlOOO <= 0;
			nO <= 0;
		end
		else 
		if (clk != nl_clk_prev && clk == 1'b1) 
		begin
			nlOOO <= rxelectricalidle;
			nO <= nlOOO;
		end
		nl_clk_prev <= clk;
	end
	assign
		wire_nl_CLRN = (n11Ol2 ^ n11Ol1);
	and(wire_n000i_dataout, (rxd[45] & rxd[46]), ~(nlOi0i));
	and(wire_n001i_dataout, wire_n001O_dataout, ~(nlOill));
	and(wire_n001l_dataout, nlOi0i, ~(nlOiii));
	and(wire_n001O_dataout, wire_n000i_dataout, ~(nlOiii));
	and(wire_n00i_dataout, rxd[9], rrx_pipe_enable);
	and(wire_n00l_dataout, rxd[10], rrx_pipe_enable);
	and(wire_n00O_dataout, rxd[11], rrx_pipe_enable);
	and(wire_n00OO_dataout, rxd[43], (nlOllO & (~ nlOliO)));
	and(wire_n010i_dataout, wire_n01il_dataout, ~(nlOi1l));
	and(wire_n010l_dataout, nlOi1O, ~(nlOi1l));
	and(wire_n010O_dataout, wire_n01iO_dataout, ~(nlOi1l));
	and(wire_n011i_dataout, wire_n010l_dataout, ~(nlOliO));
	and(wire_n011l_dataout, wire_n010O_dataout, ~(nlOliO));
	and(wire_n011O_dataout, wire_n01ii_dataout, ~(nlOliO));
	and(wire_n01i_dataout, rxd[6], rrx_pipe_enable);
	and(wire_n01ii_dataout, wire_n01li_dataout, ~(nlOi1l));
	and(wire_n01il_dataout, wire_n01ll_dataout, ~(nlOi1O));
	and(wire_n01iO_dataout, wire_n01lO_dataout, ~(nlOi1O));
	and(wire_n01l_dataout, rxd[7], rrx_pipe_enable);
	and(wire_n01li_dataout, wire_n01Oi_dataout, ~(nlOi1O));
	and(wire_n01ll_dataout, wire_n01Ol_dataout, ~(nlOl1i));
	or(wire_n01lO_dataout, wire_n01OO_dataout, nlOl1i);
	and(wire_n01O_dataout, rxd[8], rrx_pipe_enable);
	and(wire_n01Oi_dataout, wire_n001i_dataout, ~(nlOl1i));
	or(wire_n01Ol_dataout, wire_n001l_dataout, nlOill);
	and(wire_n01OO_dataout, nlOiii, ~(nlOill));
	and(wire_n0i_dataout, rxd[54], rrx_pipe_enable);
	and(wire_n0i1l_dataout, rxd[41], (nlOllO & (~ nlOliO)));
	and(wire_n0ii_dataout, rxd[12], rrx_pipe_enable);
	and(wire_n0il_dataout, rxd[13], rrx_pipe_enable);
	and(wire_n0iO_dataout, rxd[14], rrx_pipe_enable);
	and(wire_n0l_dataout, rxd[55], rrx_pipe_enable);
	and(wire_n0li_dataout, rxd[15], rrx_pipe_enable);
	and(wire_n0ll_dataout, rxd[16], rrx_pipe_enable);
	and(wire_n0lO_dataout, rxd[17], rrx_pipe_enable);
	and(wire_n0O_dataout, rxd[56], rrx_pipe_enable);
	and(wire_n0Oi_dataout, rxd[18], rrx_pipe_enable);
	and(wire_n0Ol_dataout, rxd[19], rrx_pipe_enable);
	and(wire_n0OO_dataout, rxd[20], rrx_pipe_enable);
	and(wire_n100O_dataout, wire_n10li_dataout, ~((~ reset_n)));
	assign		wire_n10i_dataout = (rrx_pipe_enable === 1'b1) ? wire_nliOl_dataout : rx_found;
	and(wire_n10ii_dataout, wire_n10ll_dataout, ~((~ reset_n)));
	and(wire_n10il_dataout, wire_n10lO_dataout, ~((~ reset_n)));
	and(wire_n10iO_dataout, wire_n10Oi_dataout, ~((~ reset_n)));
	assign		wire_n10l_dataout = (rrx_pipe_enable === 1'b1) ? wire_nliOO_dataout : rx_detect_valid;
	and(wire_n10li_dataout, wire_n10Ol_dataout, ~(nlO0li));
	and(wire_n10ll_dataout, wire_n10OO_dataout, ~(nlO0li));
	and(wire_n10lO_dataout, wire_n1i1i_dataout, ~(nlO0li));
	and(wire_n10O_dataout, wire_nll1i_dataout, rrx_pipe_enable);
	and(wire_n10Oi_dataout, wire_n1i1l_dataout, ~(nlO0li));
	and(wire_n10Ol_dataout, wire_n1i1O_dataout, ~(nlO01i));
	and(wire_n10OO_dataout, nlO01l, ~(nlO01i));
	and(wire_n11i_dataout, wire_n11l_dataout, ~((~ reset_n)));
	assign		wire_n11l_dataout = (rrdwidth_rx === 1'b1) ? ((rxd[10] | rxd[42]) | (~ (n11iO4 ^ n11iO3))) : rxd[10];
	and(wire_n1i_dataout, rxd[51], rrx_pipe_enable);
	and(wire_n1i0i_dataout, wire_n1iii_dataout, ~(nlO01l));
	and(wire_n1i0l_dataout, wire_n1iil_dataout, ~(nlO01l));
	and(wire_n1i0O_dataout, wire_n1iiO_dataout, ~(nlO0ii));
	and(wire_n1i1i_dataout, wire_n1i0i_dataout, ~(nlO01i));
	and(wire_n1i1l_dataout, wire_n1i0l_dataout, ~(nlO01i));
	and(wire_n1i1O_dataout, wire_n1i0O_dataout, ~(nlO01l));
	assign		wire_n1ii_dataout = (rrx_pipe_enable === 1'b1) ? wire_nlOOl_dataout : (~ sigdetni);
	or(wire_n1iii_dataout, wire_n1ili_dataout, nlO0ii);
	and(wire_n1iil_dataout, wire_n1ill_dataout, ~(nlO0ii));
	or(wire_n1iiO_dataout, wire_n1ilO_dataout, nlO00O);
	and(wire_n1il_dataout, wire_n11i_dataout, rrx_pipe_enable);
	and(wire_n1ili_dataout, nlO00i, ~(nlO00O));
	and(wire_n1ill_dataout, wire_n1iOi_dataout, ~(nlO00O));
	and(wire_n1ilO_dataout, nlO01O, ~(nlO00i));
	assign		wire_n1iO_dataout = (rrx_pipe_enable === 1'b1) ? rxpolarity : polinv_rx;
	and(wire_n1iOi_dataout, wire_n1iOl_dataout, ~(nlO00i));
	and(wire_n1iOl_dataout, (rxd[13] & rxd[14]), ~(nlO01O));
	and(wire_n1l_dataout, rxd[52], rrx_pipe_enable);
	and(wire_n1li_dataout, rxd[0], rrx_pipe_enable);
	and(wire_n1liO_dataout, rxd[11], (reset_n & (~ nlO0li)));
	and(wire_n1ll_dataout, rxd[1], rrx_pipe_enable);
	and(wire_n1lll_dataout, rxd[9], (reset_n & (~ nlO0li)));
	and(wire_n1lO_dataout, rxd[2], rrx_pipe_enable);
	and(wire_n1O_dataout, rxd[53], rrx_pipe_enable);
	and(wire_n1Oi_dataout, rxd[3], rrx_pipe_enable);
	and(wire_n1Ol_dataout, rxd[4], rrx_pipe_enable);
	and(wire_n1Oll_dataout, wire_n1OOO_dataout, ~(nlOl0O));
	and(wire_n1OlO_dataout, wire_n011i_dataout, ~(nlOl0O));
	and(wire_n1OO_dataout, rxd[5], rrx_pipe_enable);
	and(wire_n1OOi_dataout, wire_n011l_dataout, ~(nlOl0O));
	and(wire_n1OOl_dataout, wire_n011O_dataout, ~(nlOl0O));
	and(wire_n1OOO_dataout, wire_n010i_dataout, ~(nlOliO));
	and(wire_ni_dataout, rxd[63], rrx_pipe_enable);
	and(wire_ni0i_dataout, rxd[24], rrx_pipe_enable);
	and(wire_ni0l_dataout, rxd[25], rrx_pipe_enable);
	and(wire_ni0O_dataout, rxd[26], rrx_pipe_enable);
	and(wire_ni1i_dataout, rxd[21], rrx_pipe_enable);
	and(wire_ni1l_dataout, rxd[22], rrx_pipe_enable);
	and(wire_ni1O_dataout, rxd[23], rrx_pipe_enable);
	and(wire_nii_dataout, rxd[57], rrx_pipe_enable);
	and(wire_niii_dataout, rxd[27], rrx_pipe_enable);
	and(wire_niil_dataout, rxd[28], rrx_pipe_enable);
	and(wire_niiO_dataout, rxd[29], rrx_pipe_enable);
	and(wire_nil_dataout, rxd[58], rrx_pipe_enable);
	and(wire_nili_dataout, rxd[30], rrx_pipe_enable);
	and(wire_nill_dataout, rxd[31], rrx_pipe_enable);
	and(wire_nilO_dataout, rxd[32], rrx_pipe_enable);
	and(wire_niO_dataout, rxd[59], rrx_pipe_enable);
	and(wire_niOi_dataout, rxd[33], rrx_pipe_enable);
	and(wire_niOl_dataout, rxd[34], rrx_pipe_enable);
	and(wire_niOO_dataout, rxd[35], rrx_pipe_enable);
	and(wire_nl0i_dataout, rxd[39], rrx_pipe_enable);
	and(wire_nl0l_dataout, rxd[40], rrx_pipe_enable);
	and(wire_nl0O_dataout, rxd[41], rrx_pipe_enable);
	and(wire_nl1i_dataout, rxd[36], rrx_pipe_enable);
	and(wire_nl1l_dataout, rxd[37], rrx_pipe_enable);
	and(wire_nl1O_dataout, rxd[38], rrx_pipe_enable);
	and(wire_nli_dataout, rxd[60], rrx_pipe_enable);
	and(wire_nlii_dataout, rxd[42], rrx_pipe_enable);
	and(wire_nlil_dataout, rxd[43], rrx_pipe_enable);
	and(wire_nliO_dataout, rxd[44], rrx_pipe_enable);
	and(wire_nliOl_dataout, wire_nll1l_dataout, ~((~ reset_n)));
	and(wire_nliOO_dataout, wire_nll1O_dataout, ~((~ reset_n)));
	and(wire_nll_dataout, rxd[61], rrx_pipe_enable);
	and(wire_nll0i_dataout, wire_nllii_dataout, ~(nlOOOi));
	and(wire_nll0l_dataout, wire_nllil_dataout, ~(nlOOlO));
	and(wire_nll0O_dataout, wire_nlliO_dataout, ~(nlOOlO));
	and(wire_nll1i_dataout, wire_nll0i_dataout, ~((~ reset_n)));
	or(wire_nll1l_dataout, wire_nll0l_dataout, nlOOOi);
	or(wire_nll1O_dataout, wire_nll0O_dataout, nlOOOi);
	and(wire_nlli_dataout, rxd[45], rrx_pipe_enable);
	or(wire_nllii_dataout, wire_nllli_dataout, nlOOlO);
	or(wire_nllil_dataout, wire_nllll_dataout, nlOOll);
	and(wire_nlliO_dataout, wire_nlllO_dataout, ~(nlOOll));
	and(wire_nlll_dataout, rxd[46], rrx_pipe_enable);
	or(wire_nllli_dataout, wire_nllOi_dataout, nlOOll);
	and(wire_nllll_dataout, wire_nllOl_dataout, ~(nlOOil));
	or(wire_nlllO_dataout, wire_nllOO_dataout, nlOOil);
	and(wire_nllO_dataout, rxd[47], rrx_pipe_enable);
	or(wire_nllOi_dataout, wire_nlO1i_dataout, nlOOil);
	or(wire_nllOl_dataout, wire_nlO1l_dataout, nlOO0O);
	or(wire_nllOO_dataout, wire_nlO1O_dataout, nlOO0O);
	and(wire_nlO_dataout, rxd[62], rrx_pipe_enable);
	and(wire_nlO0i_dataout, (wire_n100O_dataout | wire_n1Oll_dataout), ~(nlOlOO));
	or(wire_nlO1i_dataout, nlOO1O, nlOO0O);
	and(wire_nlO1l_dataout, wire_nlO0i_dataout, ~(nlOO1O));
	and(wire_nlO1O_dataout, nlOlOO, ~(nlOO1O));
	and(wire_nlOi_dataout, rxd[48], rrx_pipe_enable);
	and(wire_nlOl_dataout, rxd[49], rrx_pipe_enable);
	and(wire_nlOO_dataout, rxd[50], rrx_pipe_enable);
	or(wire_nlOOl_dataout, nO, (~ reset_n));
	assign
		n11lO = 1'b1,
		nlO00i = (rclkcmpinsertpad & (nlO0il & nlO00l)),
		nlO00l = (((((((rxd[0] & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		nlO00O = ((~ rclkcmpinsertpad) & ((~ nlO0iO) & nlO0il)),
		nlO01i = ((~ rxd[13]) & (~ rxd[14])),
		nlO01l = (rxd[13] & (~ rxd[14])),
		nlO01O = (rclkcmpinsertpad & (nlO0il & (~ nlO00l))),
		nlO0ii = ((~ rclkcmpinsertpad) & (nlO0iO & nlO0il)),
		nlO0il = ((~ rxd[13]) & rxd[14]),
		nlO0iO = ((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		nlO0li = ((rx_detect_valid_sync & (~ n1O0i)) & (nlO0ll42 ^ nlO0ll41)),
		nlOi0i = ((rclkcmpinsertpad & (nlOl0i & (~ nlOili))) & (nlOi0l36 ^ nlOi0l35)),
		nlOi1l = ((~ rxd[45]) & (~ rxd[46])),
		nlOi1O = ((rxd[45] & (~ rxd[46])) & (nlO0OO38 ^ nlO0OO37)),
		nlOiii = ((rclkcmpinsertpad & (nlOl0i & nlOili)) & (nlOiil34 ^ nlOiil33)),
		nlOili = ((((((((rxd[32] & rxd[33]) & rxd[34]) & (~ rxd[35])) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]) & (nlO0Oi40 ^ nlO0Oi39)),
		nlOill = (((~ rclkcmpinsertpad) & (((~ nlOl0l) & nlOl0i) & (nlOiOl30 ^ nlOiOl29))) & (nlOilO32 ^ nlOilO31)),
		nlOl0i = ((~ rxd[45]) & rxd[46]),
		nlOl0l = ((((((((~ rxd[32]) & rxd[33]) & rxd[34]) & rxd[35]) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]),
		nlOl0O = (((~ reset_n) | (~ rrdwidth_rx)) | (~ (nlOlii26 ^ nlOlii25))),
		nlOl1i = (((~ rclkcmpinsertpad) & (nlOl0l & nlOl0i)) & (nlOl1l28 ^ nlOl1l27)),
		nlOliO = ((rx_detect_valid_sync & (~ n0iOi)) & (nlOlli24 ^ nlOlli23)),
		nlOllO = ((reset_n & rrdwidth_rx) & (nlOlOi22 ^ nlOlOi21)),
		nlOlOO = ((wire_n10ii_dataout | wire_n1OlO_dataout) | (~ (nlOO1i20 ^ nlOO1i19))),
		nlOO0O = (nlOOii & rind_error_reporting),
		nlOO1O = ((nlOOii & (~ rind_error_reporting)) & (nlOO0i18 ^ nlOO0i17)),
		nlOOii = (wire_n1liO_dataout | wire_n00OO_dataout),
		nlOOil = ((wire_n10il_dataout | wire_n1OOi_dataout) | (~ (nlOOiO16 ^ nlOOiO15))),
		nlOOll = (wire_n10iO_dataout | wire_n1OOl_dataout),
		nlOOlO = (wire_n1lll_dataout | wire_n0i1l_dataout),
		nlOOOi = ((((~ n1O0i) & ((rx_detect_valid_sync & (latched_p1 & rx_found_sync)) & (n11ii6 ^ n11ii5))) & n1l1l) | ((((~ n0iOi) & ((rx_detect_valid_sync & ((rx_found_sync & ((rrdwidth_rx & latched_p1) & (n110l8 ^ n110l7))) & (n111O10 ^ n111O9))) & (n111i12 ^ n111i11))) & n00ii) & (nlOOOl14 ^ nlOOOl13))),
		polinv_rx_int = wire_n1iO_dataout,
		rxd_ch = {wire_ni_dataout, wire_nlO_dataout, wire_nll_dataout, wire_nli_dataout, wire_niO_dataout, wire_nil_dataout, wire_nii_dataout, wire_n0O_dataout, wire_n0l_dataout, wire_n0i_dataout, wire_n1O_dataout, wire_n1l_dataout, wire_n1i_dataout, wire_nlOO_dataout, wire_nlOl_dataout, wire_nlOi_dataout, wire_nllO_dataout, wire_nlll_dataout, wire_nlli_dataout, wire_nliO_dataout, wire_nlil_dataout, wire_nlii_dataout, wire_nl0O_dataout, wire_nl0l_dataout, wire_nl0i_dataout, wire_nl1O_dataout, wire_nl1l_dataout, wire_nl1i_dataout, wire_niOO_dataout, wire_niOl_dataout, wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout, wire_n1li_dataout},
		rxelecidle = wire_n1ii_dataout,
		rxstatus = {wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout},
		rxvalid = wire_n1il_dataout;
endmodule //cycloneiv_hssi_rx_pipe_interface
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 36 mux21 13 oper_mux 1 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_tx_pipe_interface
	( 
	clk,
	powerdown,
	powerstate,
	refclk_b,
	refclk_b_reset_n,
	reset_n,
	rev_loopbk,
	revloopback,
	rtx_elec_idle_delay,
	rtx_pipe_enable,
	rtxswing_sel_ena,
	tx_elec_idle,
	tx_elec_idle_comp,
	txd,
	txd_ch,
	txdeemph,
	txdeemph_int,
	txdetectrx,
	txdetectrxloopback,
	txelecidle,
	txmargin,
	txmargin_int,
	txswing,
	txswing_int) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   [1:0]  powerdown;
	output   [3:0]  powerstate;
	input   refclk_b;
	input   refclk_b_reset_n;
	input   reset_n;
	output   rev_loopbk;
	input   revloopback;
	input   [2:0]  rtx_elec_idle_delay;
	input   rtx_pipe_enable;
	input   rtxswing_sel_ena;
	output   tx_elec_idle;
	input   tx_elec_idle_comp;
	output   [43:0]  txd;
	input   [43:0]  txd_ch;
	input   txdeemph;
	output   txdeemph_int;
	output   txdetectrx;
	input   txdetectrxloopback;
	input   txelecidle;
	input   [2:0]  txmargin;
	output   [2:0]  txmargin_int;
	input   txswing;
	output   txswing_int;

	reg	niiOl23;
	reg	niiOl24;
	reg	nil0i19;
	reg	nil0i20;
	reg	nil0l17;
	reg	nil0l18;
	reg	nil0O15;
	reg	nil0O16;
	reg	nil1i21;
	reg	nil1i22;
	reg	nilii13;
	reg	nilii14;
	reg	niliO11;
	reg	niliO12;
	reg	nilli10;
	reg	nilli9;
	reg	nilOi7;
	reg	nilOi8;
	reg	nilOl5;
	reg	nilOl6;
	reg	niO1i3;
	reg	niO1i4;
	reg	niO1O1;
	reg	niO1O2;
	reg	nl00i;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl01O_clk_prev;
	wire	wire_nl01O_CLRN;
	wire	wire_nl01O_PRN;
	reg	nl1lO;
	reg	nl1ll_clk_prev;
	wire	wire_nl1ll_CLRN;
	wire	wire_nl1ll_PRN;
	wire	wire_nl1ll_ENA;
	reg	nl1Oi;
	reg	nl1OO;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl11i_dataout;
	wire  wire_nl11l_o;
	wire  nil1O;
	wire  nilll;
	wire  nillO;
	wire  nilOO;

	initial
		niiOl23 = 0;
	always @ ( posedge refclk_b)
		  niiOl23 <= niiOl24;
	event niiOl23_event;
	initial
		#1 ->niiOl23_event;
	always @(niiOl23_event)
		niiOl23 <= {1{1'b1}};
	initial
		niiOl24 = 0;
	always @ ( posedge refclk_b)
		  niiOl24 <= niiOl23;
	initial
		nil0i19 = 0;
	always @ ( posedge refclk_b)
		  nil0i19 <= nil0i20;
	event nil0i19_event;
	initial
		#1 ->nil0i19_event;
	always @(nil0i19_event)
		nil0i19 <= {1{1'b1}};
	initial
		nil0i20 = 0;
	always @ ( posedge refclk_b)
		  nil0i20 <= nil0i19;
	initial
		nil0l17 = 0;
	always @ ( posedge refclk_b)
		  nil0l17 <= nil0l18;
	event nil0l17_event;
	initial
		#1 ->nil0l17_event;
	always @(nil0l17_event)
		nil0l17 <= {1{1'b1}};
	initial
		nil0l18 = 0;
	always @ ( posedge refclk_b)
		  nil0l18 <= nil0l17;
	initial
		nil0O15 = 0;
	always @ ( posedge refclk_b)
		  nil0O15 <= nil0O16;
	event nil0O15_event;
	initial
		#1 ->nil0O15_event;
	always @(nil0O15_event)
		nil0O15 <= {1{1'b1}};
	initial
		nil0O16 = 0;
	always @ ( posedge refclk_b)
		  nil0O16 <= nil0O15;
	initial
		nil1i21 = 0;
	always @ ( posedge refclk_b)
		  nil1i21 <= nil1i22;
	event nil1i21_event;
	initial
		#1 ->nil1i21_event;
	always @(nil1i21_event)
		nil1i21 <= {1{1'b1}};
	initial
		nil1i22 = 0;
	always @ ( posedge refclk_b)
		  nil1i22 <= nil1i21;
	initial
		nilii13 = 0;
	always @ ( posedge refclk_b)
		  nilii13 <= nilii14;
	event nilii13_event;
	initial
		#1 ->nilii13_event;
	always @(nilii13_event)
		nilii13 <= {1{1'b1}};
	initial
		nilii14 = 0;
	always @ ( posedge refclk_b)
		  nilii14 <= nilii13;
	initial
		niliO11 = 0;
	always @ ( posedge refclk_b)
		  niliO11 <= niliO12;
	event niliO11_event;
	initial
		#1 ->niliO11_event;
	always @(niliO11_event)
		niliO11 <= {1{1'b1}};
	initial
		niliO12 = 0;
	always @ ( posedge refclk_b)
		  niliO12 <= niliO11;
	initial
		nilli10 = 0;
	always @ ( posedge refclk_b)
		  nilli10 <= nilli9;
	initial
		nilli9 = 0;
	always @ ( posedge refclk_b)
		  nilli9 <= nilli10;
	event nilli9_event;
	initial
		#1 ->nilli9_event;
	always @(nilli9_event)
		nilli9 <= {1{1'b1}};
	initial
		nilOi7 = 0;
	always @ ( posedge refclk_b)
		  nilOi7 <= nilOi8;
	event nilOi7_event;
	initial
		#1 ->nilOi7_event;
	always @(nilOi7_event)
		nilOi7 <= {1{1'b1}};
	initial
		nilOi8 = 0;
	always @ ( posedge refclk_b)
		  nilOi8 <= nilOi7;
	initial
		nilOl5 = 0;
	always @ ( posedge refclk_b)
		  nilOl5 <= nilOl6;
	event nilOl5_event;
	initial
		#1 ->nilOl5_event;
	always @(nilOl5_event)
		nilOl5 <= {1{1'b1}};
	initial
		nilOl6 = 0;
	always @ ( posedge refclk_b)
		  nilOl6 <= nilOl5;
	initial
		niO1i3 = 0;
	always @ ( posedge refclk_b)
		  niO1i3 <= niO1i4;
	event niO1i3_event;
	initial
		#1 ->niO1i3_event;
	always @(niO1i3_event)
		niO1i3 <= {1{1'b1}};
	initial
		niO1i4 = 0;
	always @ ( posedge refclk_b)
		  niO1i4 <= niO1i3;
	initial
		niO1O1 = 0;
	always @ ( posedge refclk_b)
		  niO1O1 <= niO1O2;
	event niO1O1_event;
	initial
		#1 ->niO1O1_event;
	always @(niO1O1_event)
		niO1O1 <= {1{1'b1}};
	initial
		niO1O2 = 0;
	always @ ( posedge refclk_b)
		  niO1O2 <= niO1O1;
	initial
	begin
		nl00i = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
	end
	always @ (refclk_b or wire_nl01O_PRN or wire_nl01O_CLRN)
	begin
		if (wire_nl01O_PRN == 1'b0) 
		begin
			nl00i <= 1;
			nl10i <= 1;
			nl10l <= 1;
			nl10O <= 1;
			nl11O <= 1;
			nl1ii <= 1;
			nl1il <= 1;
			nl1iO <= 1;
			nl1li <= 1;
		end
		else if  (wire_nl01O_CLRN == 1'b0) 
		begin
			nl00i <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
		end
		else 
		if (refclk_b != nl01O_clk_prev && refclk_b == 1'b1) 
		begin
			nl00i <= nl11O;
			nl10i <= nl10l;
			nl10l <= nl10O;
			nl10O <= nl1ii;
			nl11O <= nl10i;
			nl1ii <= nl1il;
			nl1il <= nl1iO;
			nl1iO <= nl1li;
			nl1li <= nilOO;
		end
		nl01O_clk_prev <= refclk_b;
	end
	assign
		wire_nl01O_CLRN = (nilOl6 ^ nilOl5),
		wire_nl01O_PRN = ((nilOi8 ^ nilOi7) & refclk_b_reset_n);
	initial
	begin
		nl1lO = 0;
	end
	always @ (refclk_b or wire_nl1ll_PRN or wire_nl1ll_CLRN)
	begin
		if (wire_nl1ll_PRN == 1'b0) 
		begin
			nl1lO <= 1;
		end
		else if  (wire_nl1ll_CLRN == 1'b0) 
		begin
			nl1lO <= 0;
		end
		else if  (wire_nl1ll_ENA == 1'b1) 
		if (refclk_b != nl1ll_clk_prev && refclk_b == 1'b1) 
		begin
			nl1lO <= nilll;
		end
		nl1ll_clk_prev <= refclk_b;
	end
	assign
		wire_nl1ll_ENA = (((nl1OO & nl1lO) & (nilii14 ^ nilii13)) & (~ nl1Oi)),
		wire_nl1ll_CLRN = (nilli10 ^ nilli9),
		wire_nl1ll_PRN = ((niliO12 ^ niliO11) & refclk_b_reset_n);
	initial
	begin
		nl1Oi = 0;
		nl1OO = 0;
	end
	always @ ( posedge refclk_b or  negedge refclk_b_reset_n)
	begin
		if (refclk_b_reset_n == 1'b0) 
		begin
			nl1Oi <= 0;
			nl1OO <= 0;
		end
		else 
		begin
			nl1Oi <= nl1OO;
			nl1OO <= tx_elec_idle_comp;
		end
	end
	and(wire_niOll_dataout, (powerdown[0] & powerdown[1]), ~(nil1O));
	and(wire_niOlO_dataout, ((~ powerdown[0]) & powerdown[1]), ~(nil1O));
	and(wire_niOOi_dataout, ((powerdown[0] & (~ powerdown[1])) & (niiOl24 ^ niiOl23)), ~(nil1O));
	and(wire_niOOl_dataout, (((~ powerdown[0]) & (~ powerdown[1])) & (nil1i22 ^ nil1i21)), ~(nil1O));
	assign		wire_nl00O_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txdetectrxloopback : (txdetectrxloopback & wire_niOlO_dataout);
	assign		wire_nl0il_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txelecidle : wire_nl11i_dataout;
	assign		wire_nl0iO_dataout = ((~ rtx_pipe_enable) === 1'b1) ? revloopback : ((txdetectrxloopback & wire_niOOl_dataout) & (niO1O2 ^ niO1O1));
	and(wire_nl0ll_dataout, txswing, rtxswing_sel_ena);
	and(wire_nl0lO_dataout, wire_niOOl_dataout, rtx_pipe_enable);
	and(wire_nl0Oi_dataout, wire_niOOi_dataout, rtx_pipe_enable);
	and(wire_nl0Ol_dataout, wire_niOlO_dataout, rtx_pipe_enable);
	and(wire_nl0OO_dataout, wire_niOll_dataout, rtx_pipe_enable);
	assign		wire_nl11i_dataout = ((~ nilOO) === 1'b1) ? nl1li : wire_nl11l_o;
	oper_mux   nl11l
	( 
	.data({((nil0i20 ^ nil0i19) & nl00i), nl11O, nl10i, nl10l, ((nil0l18 ^ nil0l17) & nl10O), nl1ii, nl1il, nl1iO}),
	.o(wire_nl11l_o),
	.sel({rtx_elec_idle_delay[2:1], ((nil0O16 ^ nil0O15) & rtx_elec_idle_delay[0])}));
	defparam
		nl11l.width_data = 8,
		nl11l.width_sel = 3;
	assign
		nil1O = ((~ reset_n) | (~ rtx_pipe_enable)),
		nilll = 1'b0,
		nillO = 1'b1,
		nilOO = ((tx_elec_idle_comp | nl1lO) | (~ (niO1i4 ^ niO1i3))),
		powerstate = {wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout},
		rev_loopbk = wire_nl0iO_dataout,
		tx_elec_idle = wire_nl0il_dataout,
		txd = {txd_ch[43:0]},
		txdeemph_int = txdeemph,
		txdetectrx = wire_nl00O_dataout,
		txmargin_int = {txmargin[2:0]},
		txswing_int = wire_nl0ll_dataout;
endmodule //cycloneiv_hssi_tx_pipe_interface
//synopsys translate_on
//VALID FILE


`timescale 1 ns / 1 ps

module cycloneiv_hssi_q_pipe_interface_top (
			   
			   // General signals
			   pipe_tx_clk,				// TX PIPE interface clock == TX Phase Comp write clock
			   pipe_rx_clk,				// RX PIPE interface clock == RX Phase Comp read clock
			   refclk_b,					// TX Phase Comp FIFO read clock
			   tx_pipe_reset,				// synchronized reset i.e TX Phase Comp write clock
			   rx_pipe_reset,				// synchronized reset i.e.RX Phase Comp read clock
			   refclk_b_reset,			// synchronized reset i.e.TX Phase Comp read clock
			   
			   // CRAM 
			   rtx_pipe_enable,			// enable tx pipe interface
			   rrx_pipe_enable,			// enable rx pipe interface
			   rrdwidth_rx,				// Single width = 0, double width = 1
			   rtx_elec_idle_delay,		// programmable delay for controlling output buffer
			   rtxswing_sel_ena,			// Enables control of voltage swing level.  Implementation 
			   // is optional under PIPE 1.87.  When this CRAM is not set, full swing is the default mode
			   rrx_detect_bypass,			// normal = 0, bypass = 1
			   rclkcmpinsertpad,			// recognize EDB = 0, PAD = 1 insertion for 8b/10b decode errors
			   rind_error_reporting,		// Combined reporting = 0 i.e. 8b/10b error|disparity error=> rxstatus=3'b100
			   // individual reporting = 1 i.e. 8b/10b error => rxstatus = 3'b111;
			   // disparity error => rxstatus = 3'b100
			   rphystatus_rst_toggle,		// no toggle (gen 2) = 0, toggle (option for gen 1) = 1
			   
			   rphystatus_delay,			// programmable delay for the emulation circuitry of successfull power state
			   // transition.  Default delay between the change of power state and the assertion
			   // of ~ 13 parallel cycles.  Setting of this CRAM to 3'b000 will result in a delay
			   // of ~ 13 parallel cycles.
			   
			   // PLD - PIPE Interface
			   // TX PIPE Interface: Command 
			   txdetectrxloopback,			// P0 ==> loopback, P1 ==> RX detection
			   txelecidle,				// output buffer control
//			   txcompliance,				// compliance pattern command
			   powerdown,				// power state control
			   
			   txdeemph,					// Selects transmitter de-emphasis under Gen 2 speeds
			   txmargin,					// Selects transmitter voltage levels 
			   txswing,					// Selects transmitter voltage swing levels
			   
			   // TX PIPE Interface: Data
			   txd_ch,					// TX data path	
			   
			   // RX PIPE Interface: Command/Status
			   rxpolarity,				// polarity inversion command
			   
			   rxvalid,					// indicates symbol lock and valid data
			   rxelecidle,				// indicates receiver detection of electrical idle.  
			   rxstatus,					// encodes receiver status and error codes when receiving data
			   // encodes compliance pattern speed when doing receiver detection
			   
			   // RX PIPE Interface: Data
			   rxd_ch,					// RX data path
			   
			   // PHYStatus Generator
			   phystatus,				// communicate completion of power state transitions, receiver 
			   // detection, rate change
			   
			   // Commands
			   revloopback,				// enables reverse parallel loopback when in PIPE bypass mode
			   polinv_rx,				// enables polarity inversion when in PIPE bypass mode
			   
			   // PIPE - PCS Inteface
			   // TX PIPE Interface
			   txd,						// TX data path to TX Phase Comp FIFO
			   rev_loopbk,				// reverse parallel loopback control to MUX after the encoder
			   tx_elec_idle_comp,			// compensated txelecidle from the TX Phase Comp FIFO
			   // synchronous to refclk_b
			   
			   // Auto Speed Negotiation
			   rindv_rx,
			   rmaster_rx,
			   rmaster_up_rx,
			   
			   // Auto Negotiation Module
			   speed_change,				// asserted when signaling rate change between Gen 1 and Gen 2 is in process.  Sychronization occurs within PIPE module
			   speed_change_centrl,				
			   speed_change_quad_up,				
			   speed_change_quad_down,	
			   
			   // RX PIPE Interface
			   rxd,						// RX data path from the RX Phase comp FIFO
			   polinv_rx_int,				// polarity inversion control; sychronization occurs at 8b/10b decoder
			   
			   // PIPE - PMA Interface
			   // TX PIPE Interface
			   tx_elec_idle,				// command to the output buffer
			   txdetectrx,				// command to the PMA module for receiver detection
			   powerstate,				// decoded power state: used internally to the PIPE interface
			   sigdetni,				// ww25_2008
			   
			   // RX PIPE Interface
			   rx_found,					// PMA indication of receiver being detected
			   rx_detect_valid,			// Validation of rx_found
			   rxelectricalidle,			// electrical idle detection from Rx Electrical Idle inference module
			   
	txdetectrxin, //shawn
	powerstatein, //shawn
	use_powerstatein, //shawn

			   // PHYStatus Generator
			   power_state_transition_done,	// asserted when successful power state transition occurs
			   power_state_transition_done_ena,	// validates power_state_transition_done, currently tied to 0
			   
			   // PIPE-DPRIO interface
			   txdeemph_int,				// Selects transmitter de-emphasis under Gen 2 speeds
			   txmargin_int,				// Selects transmitter voltage levels 
			   txswing_int				// Selects transmitter voltage swing levels
			   
			   );
   
   //********************************************************************************
   // INCLUDE STATEMENTS
   //********************************************************************************
   
   //********************************************************************************
   // I/O SIGNALS
   //********************************************************************************
   // General signals
input           txdetectrxin; //shawn
input [3:0]     powerstatein; //shawn
input           use_powerstatein; //shawn

   input	pipe_tx_clk;
   input 	pipe_rx_clk;
   input 	refclk_b;
   input 	tx_pipe_reset;
   input 	rx_pipe_reset;
   input 	refclk_b_reset;
   
   // CRAM 
   input 	rtx_pipe_enable;
   input 	rrx_pipe_enable;
   input 	rrdwidth_rx;
   input [2:0] 	rtx_elec_idle_delay;
   input 	rtxswing_sel_ena;
   input 	rrx_detect_bypass;
   input 	rclkcmpinsertpad;
   input 	rind_error_reporting;
   input 	rphystatus_rst_toggle;
   input [2:0] 	rphystatus_delay;
   
   // PLD - PIPE Interface
   // TX PIPE Interface: Command 
   input 	txdetectrxloopback;
   input 	txelecidle;
   input [1:0] 	powerdown;
   
   input 	txdeemph;
   input [2:0] 	txmargin;
   input 	txswing;
   
   // TX PIPE Interface: Data
   input [43:0] txd_ch;
   
   // RX PIPE Interface: Command/Status
   input 	rxpolarity;
   
   // ww25_2008 - Bringing in signal detect from PMA
   // PMA - PIPE interface
   input 	sigdetni;

   output 	rxvalid;
   output 	rxelecidle;
   output [2:0] rxstatus;
   
   // RX PIPE Interface: Data
   output [63:0] rxd_ch;
   
   // PHYStatus Generator
   output 	 phystatus;
   
   // Commands
   input 	 revloopback;
   input 	 polinv_rx;
   
   // PIPE - PCS Inteface
   // TX PIPE Interface
   output [43:0] txd;
   output 	 rev_loopbk;
   input 	 tx_elec_idle_comp;
   
   input 	 rindv_rx;
   input 	 rmaster_rx;             // New bundle mode MDIO, selects master quad
   input 	 rmaster_up_rx;          // New bundle mode MDIO, selects master quad
   
   // Auto Negotiation Module
   input 	speed_change;
   input 	speed_change_centrl;
   input 	speed_change_quad_up;
   input 	speed_change_quad_down;
   
   // RX PIPE Interface
   input [63:0]  rxd;
   output 	 polinv_rx_int;
   
   // PIPE - PMA Interface
   // TX PIPE Interface
   output 	 tx_elec_idle;
   output 	 txdetectrx;
   output [3:0]  powerstate;

   // RX PIPE Interface
   input 	 rx_found;
   input 	 rx_detect_valid;
   input 	 rxelectricalidle;
   
   // PHYStatus Generator
   input 	 power_state_transition_done;
   input 	 power_state_transition_done_ena;
   
   // PIPE-DPRIO interface
   output 	 txdeemph_int;
   output [2:0]  txmargin_int;
   output 	 txswing_int;
   
   
   //********************************************************************************
   // PARAMETERS
   //********************************************************************************
   
   //********************************************************************************
   // DECLARATIONS
   //********************************************************************************
   
   wire 	 phystat_ena;
   
   reg 		 rx_found_reg_0;
   reg 		 rx_found_reg_1;
   
   reg 		 rx_detect_valid_reg_0;
   reg 		 rx_detect_valid_reg_1;
   
   wire 	 tx_pipe_reset_n;
   wire 	 rx_pipe_reset_n;
   wire 	 refclk_b_reset_n;	// reset for txelecidle_d_generator
   
// ww25_2008 - New wire for signal detect
   wire          sigdetni;
   
   reg 		 txdetectrx_reg_0;
   reg 		 txdetectrx_reg_1;
   reg 		 txdetectrx_reg_2;
   reg 		 txdetectrx_reg_3;
   reg 		 txdetectrx_reg_4;
   reg 		 txdetectrx_reg_5;
   reg 		 txdetectrx_reg_6;
   
   reg 		 bypass_rx_found;
   reg 		 bypass_rx_detect_valid;
   
   wire 	 rx_found_int;
   wire 	 rx_detect_valid_int;
   
   wire 	 latched_p0;
   wire 	 latched_p0s;
   wire 	 latched_p1;
   wire 	 latched_p2;
   
   wire 	 p1_sync;
   
wire            tmp_txdetectrxin;   //shawn

   //********************************************************************************
   // ASSIGN STATEMENTS
   //********************************************************************************
   assign 	 phystat_ena = rtx_pipe_enable || rrx_pipe_enable;
   
   assign 	 tx_pipe_reset_n = ~tx_pipe_reset;
   assign 	 rx_pipe_reset_n = ~rx_pipe_reset;
   assign 	 refclk_b_reset_n = ~refclk_b_reset;
   
   assign 	 rx_found_int = rrx_detect_bypass? bypass_rx_found: rx_found_reg_1;
   assign 	 rx_detect_valid_int = rrx_detect_bypass? bypass_rx_detect_valid: rx_detect_valid_reg_1;
   
assign tmp_txdetectrxin = (use_powerstatein == 1'b1) ? txdetectrxin : txdetectrx;  //shawn

assign latched_p0 = (use_powerstatein == 1'b1) ? powerstatein[0] : powerstate [0]; //shawn
assign latched_p0s = (use_powerstatein == 1'b1) ? powerstatein[1] : powerstate [1]; //shawn;
assign latched_p1 = (use_powerstatein == 1'b1) ? powerstatein[2] : powerstate [2]; //shawn;
assign latched_p2 = (use_powerstatein == 1'b1) ? powerstatein[3] : powerstate [3]; //shawn;
  

   //********************************************************************************
   // SUBMODULE INSTANTIATIONS
   //********************************************************************************
   
cycloneiv_hssi_tx_pipe_interface tx_pipe_interface_inst (
					     
					     // General signals
					     .clk							(pipe_tx_clk),
					     .refclk_b						(refclk_b),
					     .reset_n						(tx_pipe_reset_n),
					     .refclk_b_reset_n				(refclk_b_reset_n),
					     
					     // CRAM 
					     .rtx_pipe_enable				(rtx_pipe_enable),
					     .rtx_elec_idle_delay			(rtx_elec_idle_delay),
					     
					     .rtxswing_sel_ena				(rtxswing_sel_ena),
					     
					     // PLD - PIPE Interface
					     // TX PIPE Interface: Command
					     .txdetectrxloopback				(txdetectrxloopback),
					     .txelecidle					(txelecidle),
//					     .txcompliance					(txcompliance),
					     .powerdown					(powerdown),
					     
					     .txdeemph						(txdeemph),
					     .txmargin						(txmargin),
					     .txswing						(txswing),
					     
					     // TX PIPE Interface: Data
					     .txd_ch						(txd_ch),
					     
					     // Commands
					     .revloopback					(revloopback),
					     
					     // PIPE - PCS Inteface
					     // TX PIPE Interface
					     .txd							(txd),
					     .rev_loopbk					(rev_loopbk),
					     .tx_elec_idle_comp				(tx_elec_idle_comp),
					     
					     
					     // PIPE - PMA Interface
					     .tx_elec_idle					(tx_elec_idle),
					     .txdetectrx					(txdetectrx),
					     
					     // Central PCS
					     .powerstate					(powerstate),
					     
					     // PIPE - DPRIO
					     .txdeemph_int					(txdeemph_int),
					     .txmargin_int					(txmargin_int),
					     .txswing_int					(txswing_int)
					     
					     );
      
   
cycloneiv_hssi_rx_pipe_interface rx_pipe_interface_inst (
					     
					     // General signals
					     .clk							(pipe_rx_clk),
					     .reset_n						(rx_pipe_reset_n),
					     
					     // CRAM 
					     .rrx_pipe_enable				(rrx_pipe_enable),
					     .rrdwidth_rx					(rrdwidth_rx),
					     .rclkcmpinsertpad				(rclkcmpinsertpad),
					     .rind_error_reporting			(rind_error_reporting),
					     
					     // PLD - PIPE Interface
					     // RX PIPE Interface: Command/Status
					     .rxpolarity					(rxpolarity),
					     
					     .rxvalid						(rxvalid),
					     .rxelecidle					(rxelecidle),
					     .rxstatus						(rxstatus),
					     
					     // RX PIPE Interface: Data
					     .rxd_ch						(rxd_ch),
					     
					     // Commands
					     .polinv_rx					(polinv_rx),
					     
					     // PIPE - PCS Inteface
					     // RX PIPE Interface
					     .rxd							(rxd),
					     .polinv_rx_int					(polinv_rx_int),
					     
					     // TX PIPE Interface
					     // Latched Power State Signals
					     .latched_p1					(latched_p1),
					     
	.txdetectrx					(tmp_txdetectrxin), //shawn (txdetectrx),
					     
					     // PIPE - PMA Interface
					     // TX PIPE Interface
					     .rx_found						(rx_found),
					     .rx_found_sync					(rx_found_int),
					     .rx_detect_valid				(rx_detect_valid),
					     .rx_detect_valid_sync			(rx_detect_valid_int),	
                                             // ww25_2008 - Bringing in signal detect
					     .sigdetni			(sigdetni),	
					     
					     // RX PIPE Interface
					     .rxelectricalidle				(rxelectricalidle)					     
					     );
   
cycloneiv_hssi_phystatus_generator phystatus_generator_inst (
						 
						 // General signals
						 .clk							(pipe_rx_clk),
						 .reset_n						(rx_pipe_reset_n),
						 
						 //CRAM
						 .phystat_ena					(phystat_ena),
						 .rphystatus_rst_toggle			(rphystatus_rst_toggle),
						 .rphystatus_delay				(rphystatus_delay),
						 
						 // PLD Interface
						 .powerdown					(powerdown),
						 .phystatus					(phystatus),
						 
						 // Latched Power State Signals
						 .latched_p0					(latched_p0),
						 .latched_p0s					(latched_p0s),
						 .latched_p1					(latched_p1),
						 .latched_p2					(latched_p2),
						 
						 .rindv_rx(rindv_rx),
						 .rmaster_rx(rmaster_rx),
						 .rmaster_up_rx(rmaster_up_rx),
						 
						 // Auto Negotiation Module
						 .speed_change(speed_change),	
						 .speed_change_centrl(speed_change_centrl),				
						 .speed_change_quad_up(speed_change_quad_up),				
						 .speed_change_quad_down(speed_change_quad_down),
					      	 
						 // TX PMA Interface
						 .rx_detect_valid				(rx_detect_valid_int),
						 
						 // RX PMA Interface
						 .power_state_transition_done		(power_state_transition_done),
						 .power_state_transition_done_ena	(power_state_transition_done_ena)
						 
						 );
  
 
   //********************************************************************************
   // MAIN CODE 
   //********************************************************************************
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     rx_detect_valid_reg_0	<= #1 1'b0;
	     rx_found_reg_0			<= #1 1'b0;
	  end
	else
	  begin
	     rx_detect_valid_reg_0	<= #1 rx_detect_valid;
	     rx_found_reg_0			<= #1 rx_found;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     rx_detect_valid_reg_1	<= #1 1'b0;
	     rx_found_reg_1			<= #1 1'b0;
	  end
	else
	  begin
	     rx_detect_valid_reg_1	<= #1 rx_detect_valid_reg_0;
	     rx_found_reg_1			<= #1 rx_found_reg_0;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_0	<= #1 1'b0;
	  end
	else
	  begin
		txdetectrx_reg_0 <= #1 tmp_txdetectrxin;      // txdetectrx; shawn
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_1	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_1	<= #1 txdetectrx_reg_0;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_2	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_2	<= #1 txdetectrx_reg_1;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_3	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_3	<= #1 txdetectrx_reg_2;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_4	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_4	<= #1 txdetectrx_reg_3;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_5	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_5	<= #1 txdetectrx_reg_4;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_6	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_6	<= #1 txdetectrx_reg_5;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     bypass_rx_found		<= #1 1'b0;
	     bypass_rx_detect_valid	<= #1 1'b0;
	  end
	else
	  begin
	     bypass_rx_found		<= #1 txdetectrx_reg_6;
	     bypass_rx_detect_valid	<= #1 txdetectrx_reg_6;
	  end
     end
   
endmodule // pipe_interface_top


`timescale 1 ps / 1 ps

module cycloneiv_hssi_tx_digis_txclk_gating (
		     select_n,
		     clk1,
		     clk2,
		     clk1out_n,
		     clk2out_n
		     );
   
   input select_n;
   input clk1;
   input clk2;
   output clk1out_n;
   output clk2out_n;
   
   assign clk1out_n = ~(select_n | clk1);
   assign clk2out_n = ~(~select_n | clk2);
		     
endmodule // txclk_gating




   


`timescale 1 ns / 1 ps

module cycloneiv_hssi_tx_digi_txclk_ctl (pld_tx_clk,
		  refclk_pma,             
		  txpma_local_clk,        
		  txrst,                  
		  scan_mode,              
		  gen2ngen1,              
    		  gen2ngen1_bundle,       
    		  tx_div2_sync_centrl,    
    		  tx_div2_sync_quad_up,   
    		  tx_div2_sync_quad_down, 
    		  rindv_tx,               
		  rtxwrclksel,            
		  rtxrdclksel,            
    		  rdwidth_tx,             
		  rfreerun_tx,            
    		  rauto_speed_ena,        
    		  rfreq_sel,              
    		  rtxpcsclkpwdn,          
    		  rmaster_tx,             
    		  rmaster_up_tx,          
		  rself_sw_en_tx,         
		  refclk_b,               
		  wr_clk_pos,             
		  fifo_rd_clk,            
		  tx_clk_out,             
		  refclk_b_raw,           
		  wr_clk_pos_raw,         
		  fifo_rd_clk_raw,        
		  tx_div2_sync_out  
                  );
   

   // Clock Inputs
   input        pld_tx_clk;             // PLD clock from PLD clock trees, the transmit clock from XGMII.
   input        refclk_pma;             // Quad based clk from TXPLL
   input        txpma_local_clk;        // Local channel TX PMA clock.

   // Control Inputs
   input        txrst;                  // reset for the tx_pcs
   input        scan_mode;              // Scan mode enable signal for selecting scan_clk from refclk_pma
   
   // New Control Inputs
   input        gen2ngen1;              // from PMA for PCIexp Gen1/Gen2 datawidth scaling
   input 	gen2ngen1_bundle;       // from PMA for PCIexp Gen1/Gen2 datawidth scaling in x4 and x8
   input 	tx_div2_sync_centrl;    // divided clock from the central channel (x2, x4 mode)
   input 	tx_div2_sync_quad_up;   // divided clock from quad above (> x4 mode)
   input 	tx_div2_sync_quad_down; // divided clock from quad below (> x4 mode)
   
   // MDIO Inputs
   input 	rindv_tx;               // Selects between indiv chan. mode and bundled mode
   input        rtxwrclksel;            // Selects which clock writes into FIFO
   input        rtxrdclksel;            // Selects which clock reads from FIFO and also clocks reest of TX logic
   input 	rdwidth_tx;             // divide by 1 or 2 before feeding to FIFO read clock
   input        rfreerun_tx;            // Select whether divider is permamently enabled (free -running) or  divider should be enabled / reset by TX PCS reset  

   // New MDIO Inputs
   input 	  rauto_speed_ena;        // auto speed negotiation enable
   input 	  rfreq_sel;              // freq scaling or data width scaling
   input 	  rtxpcsclkpwdn;          // TX clocking power down enable
   input 	  rmaster_tx;             // New bundle mode MDIO, selects master quad
   input 	  rmaster_up_tx;          // New bundle mode MDIO, selects master quad
   input          rself_sw_en_tx;         // enables self-switch to have correct /2 clock in all quads in bundle mode
   
   // Removed Inputs
   // input        tx_div2_sync_in_ch0;    // from the channel zero tx_div2_sync_out
   // input        tx_div2_sync_in_q0_ch0; // From channel0 of Master Quad
   // input        rphfifo_master_sel_tx;  // TX Phase comp. FIFO tx_div2_sync selection CRAM


   // Clock Outputs wtih CTS
   output       refclk_b;               // Drives the tx channel clock
   output       wr_clk_pos;             // Drives tx phase comp fifo write side
   output       fifo_rd_clk;            // Drives tx phase comp fifo read side

   // Clock Outputs to PLD, w/o CTS
   output       tx_clk_out;             // Drives to the PLD clock tree -- unconnected

   // New Clock Outputs with CTS
   output       refclk_b_raw;            // same as refclk_b, but with no clock gating
   output       wr_clk_pos_raw;          // same as wr_clk_pos, but with no clock gating
   output       fifo_rd_clk_raw;         // same as fifo_rd_clk, but with no clock gating

   // Control Outputs
   output       tx_div2_sync_out;       // Synchronizes the divided by two clock
   

   reg 		fifo_rd_clk_by2;
   reg 		gen2ngen1_local_sync;
   reg [1:0] 	counter;  
   
   wire 	tx_rst_n;
   wire 	tx_div2_sync;
   wire 	dynamic_div2ndiv1;
   wire 	gen2ngen1_local;
   wire 	tx_div2_this_quad;
   wire 	tx_div2_this_channel;
   wire 	tx_div2_other_quad;
   wire 	force_master;
   wire 	rtxpcsclkpwdn_nscan;
   
// shawn initial begin ------
initial begin
    fifo_rd_clk_by2 = 1'b0;
end             
// shawn initial end   ------

   wire 	  select_div1_n;
   wire 	  clk1out_n;
   wire 	  clk2out_n;
   
   // Old bundle logic:   
   // Select between the local synchronization signal or the global synchronization signal (either from Channel0 or 
   // Channel0 of Master Quad
   //assign tx_div2_sync = rindv_tx ? tx_div2_sync_out : tx_div2_sync_in;
   // assign 	tx_div2_sync = (rphfifo_master_sel_tx == 1'b0) ? tx_div2_sync_in_q0_ch0 :
   //                            (rindv_tx == 1'b0) ? tx_div2_sync_in_ch0 : 
   //                            (rauto_speed_ena & ~rfreq_sel) ? (tx_div2_sync_out | ~gen2ngen1_local_sync) : tx_div2_sync_out;

   always @(posedge txrst or posedge refclk_b_raw)
     begin
	if (txrst)
	  counter <= #1 2'b00;
	else if ((rauto_speed_ena & ~rfreq_sel & rself_sw_en_tx) & ~force_master)
	  counter <= #1 counter + 1'b1;
     end

   assign force_master = ((counter == 2'b11) && (rauto_speed_ena & ~rfreq_sel & rself_sw_en_tx)) ? 1'b1 : 1'b0;
      
   assign tx_div2_sync = (rmaster_tx || force_master) ? tx_div2_this_quad : tx_div2_other_quad;
   assign tx_div2_this_quad = (rindv_tx || force_master) ? tx_div2_this_channel : tx_div2_sync_centrl;
   assign tx_div2_this_channel = (rauto_speed_ena && ~rfreq_sel) ? (tx_div2_sync_out | ~gen2ngen1_local_sync) : tx_div2_sync_out;
   assign tx_div2_other_quad = rmaster_up_tx ? tx_div2_sync_quad_up : tx_div2_sync_quad_down;

   assign gen2ngen1_local = (rindv_tx == 1'b0) ? gen2ngen1_bundle : gen2ngen1;
   
   always @(posedge txrst or posedge refclk_b_raw)
     begin
	if (txrst)
	  gen2ngen1_local_sync <= #1 1'b0;
	else 
	  gen2ngen1_local_sync <= #1 gen2ngen1_local;
     end

   assign dynamic_div2ndiv1 = rdwidth_tx | (gen2ngen1_local_sync & rauto_speed_ena & ~rfreq_sel);   


   // Reset for Divide-by-2 FF
   assign tx_rst_n = (rfreerun_tx) ? 1'b1 : ~txrst;


   assign rtxpcsclkpwdn_nscan = rtxpcsclkpwdn & ~scan_mode;

   
   // Full speed clock for TX PCS
   assign refclk_b_raw = (scan_mode || rtxrdclksel) ?  refclk_pma : txpma_local_clk; 

   assign refclk_b = rtxpcsclkpwdn_nscan ? 1'b1 : refclk_b_raw;
   
   
   // Divide-by-2 FF
   always @(negedge tx_rst_n or posedge refclk_b_raw)
     begin
	if (~tx_rst_n)
	  fifo_rd_clk_by2 <= 1'b1;
	else
	  fifo_rd_clk_by2 <= tx_div2_sync; // local divided clock
     end
   
   assign tx_div2_sync_out = ~fifo_rd_clk_by2;   

   
   // TX FIFO read clock: could be fast or divided by 2
   // old code:
   // assign fifo_rd_clk = ((rdwidth_tx == 1'b0) || scan_mode) ? refclk_b_raw : fifo_rd_clk_by2;

   assign select_div1_n = ~(scan_mode | ~dynamic_div2ndiv1);
   
   cycloneiv_hssi_tx_digis_txclk_gating txclk_gating (
			      .select_n(select_div1_n),
			      .clk1(refclk_b_raw),
			      .clk2(fifo_rd_clk_by2),
			      .clk1out_n(clk1out_n),
			      .clk2out_n(clk2out_n)
			      );
   
   assign fifo_rd_clk_raw = ~(clk1out_n | clk2out_n);

   
   assign fifo_rd_clk = rtxpcsclkpwdn_nscan ? 1'b1 : fifo_rd_clk_raw;

   
   // TX FIFO write clock: used internal clock when in BIST or scan or HIP
   assign wr_clk_pos_raw = (scan_mode || rtxwrclksel) ?  fifo_rd_clk_raw : pld_tx_clk;
   assign wr_clk_pos = rtxpcsclkpwdn_nscan ? 1'b1 : wr_clk_pos_raw;
   
   
   // TX Clock Out
   assign tx_clk_out = fifo_rd_clk; // drives PLD clock tree
   
   
endmodule // txclk_ctl



`timescale 1ps / 1ps

module cycloneiv_hssi_tx_digis_ram8x49_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re,
    data_out
    );

input 		clk;
input 		rst_l;
input 	[7:0]	fifo_wr;
input 	[7:0] 	fifo_re;
input 	[53:0] 	data_in;
output 	[53:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 54;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 54'h21000000000000 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase
end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 54'h21000000000000;
	ram_array_q_1 <= #write_access_time 54'h21000000000000;
	ram_array_q_2 <= #write_access_time 54'h21000000000000;
	ram_array_q_3 <= #write_access_time 54'h21000000000000;
        ram_array_q_4 <= #write_access_time 54'h21000000000000;
        ram_array_q_5 <= #write_access_time 54'h21000000000000;
        ram_array_q_6 <= #write_access_time 54'h21000000000000;
        ram_array_q_7 <= #write_access_time 54'h21000000000000;
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 =  data_reg_0;
	ram_array_d_1 =  data_reg_1;
	ram_array_d_2 =  data_reg_2;
	ram_array_d_3 =  data_reg_3;
        ram_array_d_4 =  data_reg_4;
        ram_array_d_5 =  data_reg_5;
        ram_array_d_6 =  data_reg_6;
        ram_array_d_7 =  data_reg_7; 
    end
    else begin
	ram_array_d_0 =  ram_array_q_0;
	ram_array_d_1 =  ram_array_q_1;
	ram_array_d_2 =  ram_array_q_2;
	ram_array_d_3 =  ram_array_q_3;
        ram_array_d_4 =  ram_array_q_4;
        ram_array_d_5 =  ram_array_q_5;
        ram_array_d_6 =  ram_array_q_6;
        ram_array_d_7 =  ram_array_q_7;
    end
end

endmodule

`timescale 1ps / 1ps

module cycloneiv_hssi_tx_digis_ph_fifo (
		   // inputs
		   rst_wclk,
		   rst_rclk,
		   wr_clk,
		   rd_clk,
		   bypass_en,
		   //en,
		   lowlatency_en,
		   we,
		   re,
		   din,
		   rphfifo_regmode_tx,
		   rindv_tx,
		   rauto_speed_ena,
		   reset_pc_ptrs,
		   reset_pc_ptrs_centrl,
		   reset_pc_ptrs_quad_up,
		   reset_pc_ptrs_quad_down,	
		   rmaster_tx,
		   rmaster_up_tx,	   
		   // outputs
		   data_out,
		   ph_fifo_full,
		   ph_fifo_empty,
		   wptr_bin,
		   rptr_bin
		   );
   
   // =======
   // inputs
   // =======
   input         rst_wclk;		// wr clk rst
   input         rst_rclk;		// rd clk rst
   input         wr_clk;		// Write Clock
   input         rd_clk;		// Read Clock
   input         bypass_en;	// FIFO bypass enable - only for Altera internal debug
   //input         en;		// Disable FIFO, reset wptr and rptr 
   // only for Altera internal debug
   input         lowlatency_en;	// Enable low latency option 
   input         we;		// PLD dynamic write pointer enable  
   input         re;		// PLD dynamic read pointer enable  
   input [53:0]  din;		// 10-bit code-group bus from deskew module.
   
   input 	 rphfifo_regmode_tx;
   input 	 rindv_tx;
   input 	 rmaster_tx;
   input 	 rmaster_up_tx;
   input 	 rauto_speed_ena;
   input 	 reset_pc_ptrs;
   input 	 reset_pc_ptrs_centrl;
   input 	 reset_pc_ptrs_quad_up;
   input 	 reset_pc_ptrs_quad_down;
   
   // =======
   // outputs
   // =======
   output        ph_fifo_full;	// Indicates overflow (rd_clk)
   output        ph_fifo_empty;	// FIFO empty (rd_clk)
   output [53:0] data_out;		// output data (rd_clk synchronous if not FIFO bypass)
   output [2:0]  wptr_bin;		// wptr test bus
   output [2:0]  rptr_bin;		// rptr test bus
   
   // ===================
   // signal declaration
   // ===================
   reg [ 7:0] 	 wptr, rptr;
   reg [ 7:0] 	 wptr0_pre;
   reg [ 7:0] 	 wptr0;
   reg [ 7:0] 	 wptr1;
   reg [ 2:0] 	 rptr_gray;
   reg [ 2:0] 	 rptr_gray0;
   reg [ 2:0] 	 rptr0;
   reg [ 2:0] 	 rptr1;
   reg [ 7:0] 	 rptr1_onehot;
   reg [ 2:0] 	 wptr_bin;		// wptr test bus
   reg [ 2:0] 	 rptr_bin;		// rptr test bus
   reg 		 first_rd;		// first read after reset
   reg [53:0] 	 ram_data_out;
   wire [53:0] 	 ram_data_out_pre;
   
   reg 		 ph_fifo_full, ph_fifo_empty;
   reg 		 ph_fifo_full_pre;
   
   // Invert rst for new FIFO     
   wire 	 rst_n;
   
   wire [3:0] 	 fifo_cnt;
   reg [3:0] 	 fifo_cnt_pre;
   reg [2:0] 	 wptr1_bin;
   reg [2:0] 	 rptr1_bin_wclk;

   wire 	 reset_ptrs_local;

   reg 		 reset_ptrs_local_sync1;
   reg 		 reset_ptrs_local_sync2;

   
   // =============
   // functionality
   // =============
   assign 	 rst_n = ~rst_wclk;
   
   assign 	 data_out[53:0] = (bypass_en)? din : ram_data_out;

   assign 	 reset_ptrs_local = rauto_speed_ena & (rmaster_tx ? (rindv_tx ? reset_pc_ptrs : reset_pc_ptrs_centrl) : (rmaster_up_tx ? reset_pc_ptrs_quad_up : reset_pc_ptrs_quad_down));
   
   //newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use
   assign 	 fifo_cnt = (wptr1_bin == rptr1_bin_wclk) ?
                              ((rst_wclk != 1'b1) ? ((fifo_cnt_pre==4'd7 || fifo_cnt_pre==4'd6 || fifo_cnt_pre==4'd8)?4'd8:4'd0) : 4'd0) :
				((wptr1_bin > rptr1_bin_wclk) ?
				 (wptr1_bin - rptr1_bin_wclk) :
				 (4'd8 - {1'b0,(rptr1_bin_wclk - wptr1_bin)} ));  // ww25.2008

   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end 
	else if (rphfifo_regmode_tx)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end
	else 
	  begin
	     reset_ptrs_local_sync1 <= #1 reset_ptrs_local;
	     reset_ptrs_local_sync2 <= #1 reset_ptrs_local_sync1;
	  end
     end // always @ (posedge rst_wclk or posedge wr_clk)
   
   
//ECO for S4GX to fix metastability issue
// replace the 1st FF with new flop w/o reset
// replace the 2nd FF with an enhanced flop
always @ (posedge wr_clk)
begin
  if (reset_ptrs_local_sync2 || rphfifo_regmode_tx)
    rptr0 <= #1 3'h0;
  else
    rptr0 <= #1 rptr_gray;
end // always @ (posedge rst_wclk or posedge wr_clk)
      
always @ (posedge rst_wclk or posedge wr_clk)
begin
  if (rst_wclk == 1'b1)
    rptr1 <= #1 3'h0;
  else if (reset_ptrs_local_sync2 || rphfifo_regmode_tx)
    rptr1 <= #1 3'h0;
  else
    rptr1 <= #1 rptr0;
end // always @ (posedge rst_wclk or posedge wr_clk)
      
   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
	  begin
	     wptr  <= #1 8'h01;
	     wptr0_pre <= #1 8'h01;
	     wptr0 <= #1 8'h01;
	     wptr1 <= #1 8'h01;
	     ph_fifo_full_pre <= #1 1'b0;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (rst_wclk == 1'b1)
	else if (reset_ptrs_local_sync2 || rphfifo_regmode_tx)
	  begin
	     wptr  <= #1 8'h01;
	     wptr0_pre <= #1 8'h01;
	     wptr0 <= #1 8'h01;
	     wptr1 <= #1 8'h01;
	     ph_fifo_full_pre <= #1 1'b0;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (reset_ptrs_local_sync2)
	else
	  begin
	     fifo_cnt_pre <= #1 fifo_cnt;
	     
	     ph_fifo_full <= #1 ph_fifo_full_pre;
	     wptr0_pre <= #1 wptr;
	     wptr0 <= #1 wptr0_pre;
	     wptr1 <= #1 wptr0;
	     
	     // wptr operation
	     if (we == 1'b1)
               wptr <= #1 {wptr[6:0],wptr[7]};
	     
	     // full condition
	     //$if ({wptr1[6:0],wptr1[7]} == rptr1_onehot)
	     //new full flag requirement
             if ((fifo_cnt==4'd8) && (!ph_fifo_empty))
               ph_fifo_full_pre <= #1 1'b1;
	     //else if (ph_fifo_full_pre == 1'b1 & (wptr1 != rptr1_onehot)) //now become sticky flag until reset
               //ph_fifo_full_pre <= #1 1'b0;
	     
	     // empty condition
	     //$if ({rptr1_onehot[6:0],rptr1_onehot[7]} == wptr1)
	     //new empty flag requirement
             if (({wptr1[6:0],wptr1[7]} == rptr1_onehot) && (fifo_cnt_pre==4'd1 || fifo_cnt_pre==4'd0) && (!ph_fifo_full_pre)) //==1 to cover if wptr not moving
               ph_fifo_empty <= #1 1'b1;
	     //else if (ph_fifo_empty == 1'b1 & ({wptr1[6:0],wptr1[7]} != rptr1_onehot)) //now become sticky flag until reset
               //ph_fifo_empty <= #1 1'b0;
	  end
     end // always @ (posedge rst_wclk or posedge wr_clk)
// End of ECO
      
   
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
	  begin
	     first_rd <= #1 1'b1;
	     rptr  <= #1 8'h20;
	  end
	else if (reset_ptrs_local || rphfifo_regmode_tx)
	  begin
	     first_rd <= #1 1'b1;
	     rptr  <= #1 8'h20;
	  end
	else
	  begin
	     
	     if (first_rd == 1'b1 && re == 1'b1)
               first_rd <= #1 1'b0;
	     
	     // read pointer operation
	     if (re == 1'b1)
               // low latency option, advance 2 on the first read 
               if (first_rd == 1'b1 && lowlatency_en == 1'b1)
		 rptr <= #1 {rptr[5:0],rptr[7:6]};	
               else
		 rptr <= #1 {rptr[6:0],rptr[7]};
	  end
     end // always @ (posedge rst_rclk or posedge rd_clk)
   
   
   // Instantiate FIFO CORE Module. Fifo 8 words deep, 44 bits wide
   /*ram8x44_syn   ram8x44_syn_1 (
    .rst_l (rst_n),
    .clk (wr_clk),
    .fifo_wr (wptr),
    .data_in (din),
    .fifo_re (rptr),
    .data_out (ram_data_out_pre)
    );
    */
   
   cycloneiv_hssi_tx_digis_ram8x49_syn   ram8x49_syn_1 (
                                .rst_l (rst_n),
                                .clk (wr_clk),
                                .fifo_wr (wptr),
                                .data_in (din),
                                .fifo_re (rptr),
                                .data_out (ram_data_out_pre)
                                );
   
   
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk)
	  begin
	     ram_data_out <= #1 54'h20000000000000;
	  end
	else if (rphfifo_regmode_tx)
	  begin
	     ram_data_out <= #1 din;
	  end
	else
	  begin
             ram_data_out <= #1 ram_data_out_pre;
	  end
     end // always @ (posedge rst_rclk or posedge rd_clk)
         
   always@(wptr)
     begin
	case(wptr)
	  8'h01: wptr_bin = 3'h0;
	  8'h02: wptr_bin = 3'h1;
	  8'h04: wptr_bin = 3'h2;
	  8'h08: wptr_bin = 3'h3;
	  8'h10: wptr_bin = 3'h4;
	  8'h20: wptr_bin = 3'h5;
	  8'h40: wptr_bin = 3'h6;
	  8'h80: wptr_bin = 3'h7;
	  default: wptr_bin = 3'h7;
	endcase // case(wptr)
     end // always@ (wptr)
      
   always@(wptr1)
     begin
	case(wptr1)
	  8'h01: wptr1_bin = 3'h0;
	  8'h02: wptr1_bin = 3'h1;
	  8'h04: wptr1_bin = 3'h2;
	  8'h08: wptr1_bin = 3'h3;
	  8'h10: wptr1_bin = 3'h4;
	  8'h20: wptr1_bin = 3'h5;
	  8'h40: wptr1_bin = 3'h6;
	  8'h80: wptr1_bin = 3'h7;
	  default: wptr1_bin = 3'h7;
	endcase // case(wptr1)
     end // always@ (wptr1)
   
   always@(rptr)
     begin
	case(rptr)
	  8'h01: rptr_bin = 3'h0;
	  8'h02: rptr_bin = 3'h1;
	  8'h04: rptr_bin = 3'h2;
	  8'h08: rptr_bin = 3'h3;
	  8'h10: rptr_bin = 3'h4;
	  8'h20: rptr_bin = 3'h5;
	  8'h40: rptr_bin = 3'h6;
	  8'h80: rptr_bin = 3'h7;
	  default: rptr_bin = 3'h7;
	endcase // case(rptr)
     end // always@ (rptr)
      
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
          rptr_gray <= #1 3'h0;
        else
          rptr_gray <= #1 rptr_gray0;
     end

   always@(rptr)
     begin
	case(rptr)
	  8'h01: rptr_gray0 = 3'h0;
	  8'h02: rptr_gray0 = 3'h1;
	  8'h04: rptr_gray0 = 3'h3;
	  8'h08: rptr_gray0 = 3'h2;
	  8'h10: rptr_gray0 = 3'h6;
	  8'h20: rptr_gray0 = 3'h7;
	  8'h40: rptr_gray0 = 3'h5;
	  8'h80: rptr_gray0 = 3'h4;
	  default: rptr_gray0 = 3'h0;
	endcase // case(rptr)
     end // always@ (rptr)
      
   always@(rptr1)
     begin
	case(rptr1)
	  3'h0: rptr1_onehot = 8'h01;
	  3'h1: rptr1_onehot = 8'h02;
	  3'h3: rptr1_onehot = 8'h04;
	  3'h2: rptr1_onehot = 8'h08;
	  3'h6: rptr1_onehot = 8'h10;
	  3'h7: rptr1_onehot = 8'h20;
	  3'h5: rptr1_onehot = 8'h40;
	  3'h4: rptr1_onehot = 8'h80;
	  default: rptr1_onehot = 8'h01;
	endcase // case(rptr1)
     end // always@ (rptr1)
      
   always@(rptr1)
     begin
	case(rptr1)
	  3'h0: rptr1_bin_wclk = 3'h0;
	  3'h1: rptr1_bin_wclk = 3'h1;
	  3'h3: rptr1_bin_wclk = 3'h2;
	  3'h2: rptr1_bin_wclk = 3'h3;
	  3'h6: rptr1_bin_wclk = 3'h4;
	  3'h7: rptr1_bin_wclk = 3'h5;
	  3'h5: rptr1_bin_wclk = 3'h6;
	  3'h4: rptr1_bin_wclk = 3'h7;
	  default: rptr1_bin_wclk = 3'h0;
	endcase // case(rptr1)
     end // always@ (rptr1)
   
   
endmodule // ph_fifo_tx

`timescale 1 ps / 1ps

module cycloneiv_hssi_tx_digi_tx_ctrl (
		// inputs
		soft_reset, 
		fifo_wr_clk, 
		fifo_rd_clk,
		refclk_b_in, 
		scan_mode,
		rindv_tx, 
		//is_lane0,
		p_rlpbk, 
		selftest_en, 
		rdwidth_tx,
		txfifo_dis,
		rtxfifo_urst_en,
		txfifo_urst,
		rtxfifo_lowlatency_en,
		rtxphfifopldctl_en,
		rtx_pipe_enable,
		pld_we,
		pld_rd_dis,
		txd,
		txd_extend,
		rforce_disp,	
		tx_data_sg,
		tx_control_sg,	
		rxd_lpbk,
		redund_ctl,
		txd_redun,
		rforce_kchar,
		rforce_echar,
		// PCS bypass
		rtxpcsbypass_en,
		
		// TX PIPE signals
		txdetectrxloopback,
		powerdown,
		
		revloopback,
		txswing,
		txdeemph,
		txmargin,
		
		// RX PIPE signals
		rxpolarity,
		polinv_rx,
		eidleinfersel,
		
		// New inputs for new bundling scheme and new PCIE features like autospeed
    		reset_pc_ptrs,
    		reset_pc_ptrs_centrl,
    		reset_pc_ptrs_quad_up,
    		reset_pc_ptrs_quad_down,
    		gen2ngen1,
    		gen2ngen1_bundle,
    		dis_pc_byte,
    		wr_enable_centrl,
    		wr_enable_quad_up,
    		wr_enable_quad_down,
    		rd_enable_centrl,
    		rd_enable_quad_up,
    		rd_enable_quad_down,
		fifo_select_in_centrl,
    		fifo_select_in_quad_up,
    		fifo_select_in_quad_down,
		
		// New MDIO for new bundling scheme and new PCIE features like autospeed
    		rauto_speed_ena,
    		rfreq_sel,
    		rphfifo_regmode_tx,
    		rmaster_tx,
    		rmaster_up_tx,
		
		// outputs
		txd_extend_tc,
		tx_data_tc,
		tx_ctl_tc,
		tx_data_9_tc,
		rd_enable_sync,
		k_det,
		d21_5_eq_n,
		d2_2_eq_n,
		wr_enable_out,
		rd_enable_out,
		fifo_select_out,
		ph_fifo_full,
		ph_fifo_empty,
		soft_reset_wclk1,
		soft_reset_rclk1,
		pipe_electric_idle,
		
		// TX PIPE signals
		txdetectrxloopback_int,
		powerdown_int,
		
		revloopback_int,
		
		phfifo_txswing,
		phfifo_txdeemph,
		phfifo_txmargin,
		
		// RX PIPE signals
		rxpolarity_int,
		polinv_rx_int,
		gray_eidleinfersel,
		
		// test bus
		// fifo_select_out	// test_bus[8], bit re-used in test bus
		wr_enable2,		// test_bus[7]
		wptr_bin,		// test_bus[6:4]
		rd_enable2,		// test_bus[3]
		rptr_bin		// test_bus[2:0]
		);
   // *_xgmii = from XGMII interface
   // *_sg    = from selftest_gen
   // *_rc    = from rx_ctrl
   
   // ======
   // inputs
   // ======
   input	    soft_reset;	// Reset
   input 	    fifo_wr_clk;	// Used to be wr_clk_pos
   input 	    fifo_rd_clk;	// Coming from txclk_xg_ctl 
   input 	    refclk_b_in;	// The local reference clock used by the internal
   // transmit logic. Used to be tx_clk.
   input 	    scan_mode;	// scan enable
   input 	    p_rlpbk;	// Control bit/pin to enable parallel loop back at XGMII
   input 	    selftest_en;	// To select XGMII signals from selftest_gen (*_sg)
   input 	    rdwidth_tx;		// Control bit to support double-width data bus on xgmii.
   // When set, fifo_wr_clk is running at half frequency
   // as refclk_b_in and 2-byte/code-group of data should be sampled
   // at the rising edge of fifo_wr_clk. When DWIDTH=1'b0, the
   // fifo_wr_clk is running at the same frequency as refclk_b_in.
   input 	    rindv_tx; 
   //input		is_lane0; 	// lane 0 of the quad
   input [39:0]     rxd_lpbk; 	// rx data from rx_ctrl.
   input 	    txfifo_dis;
   
   input [39:0]     txd; 		// Tx data 
   // These extension bits may be used to force disparity or other uses.
   input [3:0] 	    txd_extend; 	// Extend txd by 2 bits. Used to force disparity.
   input [31:0]     tx_data_sg; 	// The xgmii data from selftest_gen..
   input [3:0] 	    tx_control_sg; 	// The xgmii control from selftest_gen.
   input [39:0]     txd_redun; 	// redundant Tx data , unused
   input [3:0] 	    redund_ctl;	// redundant Tx data select, unused
   input 	    rforce_disp; 	// Acting with {txd_extend, TXD[9]	forces current disparity to 1 or 0
   input 	    rforce_kchar;
   input 	    rforce_echar;
   
   input 	    rtxfifo_urst_en;	// user reset CRAM enable
   input 	    txfifo_urst;		// user reset 
   input 	    rtxfifo_lowlatency_en;	// low latency enable
   input 	    rtxphfifopldctl_en;	// CRAM to enable PLD controlled write/read enable
   input 	    rtx_pipe_enable;	// enable pipe
   input 	    pld_we;			// PLD phase comp. fifo we, level active
   input 	    pld_rd_dis;		// PLD phase comp. fifo rd dis, edge active
   // PCS Bypass mode
   input 	    rtxpcsbypass_en;
   
   // TX PIPE interface signals
   input 	    txdetectrxloopback;
   //input			txelecidle; 	txd[9]
   //input			txcompliance;	txd[10] and txd[32]
   input [1:0] 	    powerdown;
   
   input 	    revloopback;
   
   input		txswing;
   input		txdeemph;
   input	[2:0] txmargin;
   
   // RX PIPE interface signals
   input 	    rxpolarity;
   input 	    polinv_rx;
   input	[2:0]	eidleinfersel;
   
   // New Inputs for new bundling scheme and new PCIE features like autospeed
   input 	 reset_pc_ptrs;
   input 	 reset_pc_ptrs_centrl;
   input 	 reset_pc_ptrs_quad_up;
   input 	 reset_pc_ptrs_quad_down;
   input 	 gen2ngen1;
   input 	 gen2ngen1_bundle;
   input 	 dis_pc_byte;
   input 	 wr_enable_centrl;
   input 	 wr_enable_quad_up;
   input 	 wr_enable_quad_down;
   input 	 rd_enable_centrl;
   input 	 rd_enable_quad_up;
   input 	 rd_enable_quad_down;
   input 	 fifo_select_in_centrl;
   input 	 fifo_select_in_quad_up;
   input 	 fifo_select_in_quad_down;
   
   // New MDIO for new bundling scheme and new PCIE features like autospeed
   input 	 rauto_speed_ena;
   input 	 rfreq_sel;
   input 	 rphfifo_regmode_tx;
   input 	 rmaster_tx;
   input 	 rmaster_up_tx;
   
   
   // =======
   // outputs
   // =======
   output [1:0]     txd_extend_tc; 	// This will go to the encoder. This is serialized (muxed) txd_extend_int. But 
   // txd_extend_int has to go through the FIFOs first to be serialized. 
   output 	    wr_enable_out;	// ch0 wr_enable1 output for X4/X8 mode
   output 	    rd_enable_out;	// ch0 rd_enable1 output for X4/X8 mode
   output [15:0]    tx_data_tc; 	// 8-bit data passed onto the internal transmit logic.
   output [1:0]     tx_ctl_tc; 	// Control passed onto the internal transmit logic.
   // Can be bit 8 of the 10-bit code group.
   output [1:0]     tx_data_9_tc;	// Bit 9 of the 10-bit code group passed onto the internal transmit logic.
   output 	    rd_enable_sync;
   output [1:0]     k_det;
   output [1:0]     d21_5_eq_n;
   output [1:0]     d2_2_eq_n;
   output 	    fifo_select_out;	// New output for Rev.B 
   output 	    ph_fifo_full;		// fifo full flag
   output 	    ph_fifo_empty;		// fifo empty flag
   output 	    soft_reset_wclk1;	// synchronized reset for BIST;
   output 	    soft_reset_rclk1;	// syncrhonized reset for PIPE
   output 	    pipe_electric_idle;	// PIPE electric idle bit
   
   // TX PIPE interface signals
   output 	    txdetectrxloopback_int;
   //output			txelecidle; 	txd[9]
   //output			txcompliance;	txd[10] and txd[32]
   output [1:0]     powerdown_int;
   
   output 	    revloopback_int;
   
   output			phfifo_txswing;
   output			phfifo_txdeemph;
   output		[2:0]	phfifo_txmargin;
   
	
   // RX PIPE interface signals
   output 	    rxpolarity_int;
   output 	    polinv_rx_int;
   output	[2:0]	gray_eidleinfersel;
   
   // test bus
   // testbus[8]   = fifo_select_out
   // testbus[7]   = wr_enable2
   // testbus[6:4] = wptr_bin
   // testbus[3]   = rd_enable2
   // testbus[2:0] = rptr_bin
   output 	    wr_enable2;
   output [2:0]     wptr_bin;
   output 	    rd_enable2;
   output [2:0]     rptr_bin;
   
   // ================
   // internal signals
   // ================
   reg 		    rd_enable_sync;		
   
   // Begin: 22 Bits output of this module (44 to 22 / 22 to 22)
   wire [15:0] 	    tx_data_tc;
   wire [1:0] 	    tx_ctl_tc;
   wire [1:0] 	    tx_data_9_tc;
   wire [1:0] 	    txd_extend_tc;
   reg [15:0] 	    tx_data_tc_mux; //temp holder for non PCS bypass data branch before mux
   reg [1:0] 	    tx_ctl_tc_mux; //temp holder for non PCS bypass branch before mux
   reg [1:0] 	    tx_data_9_tc_mux; //temp holder for non PCS bypass branch before mux
   reg [1:0] 	    txd_extend_tc_mux; //temp holder for non PCS bypass branch before mux
   // End:   22 bits output of this module
   
   reg [19:0] 	    tx_data_lt;
   
   wire [39:0] 	    tx_data;
   wire [53:0] 	    din0;
   wire [39:0] 	    fifo_data_out;
   wire [1:0] 	    tx_data_9_tc_d;
   wire [1:0] 	    tx_data_9_tc_d_others;
   wire [1:0] 	    tx_ctl_tc_d;
   wire [1:0] 	    tx_ctl_tc_d_others;
   wire [15:0] 	    tx_data_tc_d;
   wire [17:0] 	    tx_data_tc_d_others;
   wire [1:0] 	    d21_5_eq_n_d;
   wire [1:0] 	    d2_2_eq_n_d;
   reg [1:0] 	    d21_5_eq_n;
   reg [1:0] 	    d2_2_eq_n;
   reg [1:0] 	    k_det; 
   reg [1:0] 	    k_det_sync1;
   reg 		    fifo_select_out;
   
   reg 		    txfifo_en_refclk0;
   reg 		    txfifo_en_refclk1;
   
   reg 		    wr_enable0;
   reg 		    wr_enable0p5;
   reg 		    wr_enable1;
   reg 		    wr_enable2;
   reg 		    rd_enable0;
   reg 		    rd_enable0p5;
   reg 		    rd_enable1;
   reg 		    rd_enable2;
   
   wire [3:0] 	    txd_extend_int;
   wire [1:0] 	    txd_extend_tc_d;// This is registered and sent out to the encoder as txd_extend_tc. 
   // This is serialized (muxed) txd_extend_int. But 
   // txd_extend_int has to go through the FIFOs first to be serialized. 
   wire [1:0] 	    txd_extend_low, txd_extend_high;
   wire [17:0] txd_data_extend_tmp;
   
   reg 		    txfifo_en_rclk0;
   reg 		    txfifo_en_rclk1;
   wire 	    txfifo_en;
   
   wire 	    soft_reset_local;
   reg 		    soft_reset_wclk0;
   reg 		    soft_reset_wclk1_b4scan;
   wire 	    soft_reset_wclk1_wire;
   reg 		    soft_reset_rclk0;
   reg 		    soft_reset_rclk1_b4scan;
   wire 	    soft_reset_rclk1_wire;
   wire [53:0] data_out_temp;
   
   reg 		    pld_rd_dis0, pld_rd_dis1, pld_rd_dis2, pld_rd_dis_edge;
   
   wire [2:0] 	    wptr_bin,rptr_bin;
   reg 		    pipe_electric_idle;	// PIPE electric idle bit
   
   // register rd_enable_sync to fast clock domain. Necessary to send out low 
   // byte first after soft_reset.
   reg 		    rd_enable_sync_refclk_b_in; 
   
   
   // PIPE command signals
   wire [4:0] 	    pipe_cmd;
   wire [4:0] 	    pipe_cmd_out;
   
   wire 	    rxpolarity_int;
   wire 	    polinv_rx_int;

   wire 	    rdwidth_or_auto;
   wire 	    gen2ngen1_int;
   reg 		    gen2ngen1_reg;
   reg 		    gen2ngen1_sync;
   
   wire	[4:0]	pipe_tx_trans;			// PIPE transmitter settings
   									// {txswing, txdeemph, txmargin}
   wire	[4:0]	pipe_tx_trans_out;
   
   reg	[2:0]	gray_eidleinfersel;
   // =============
   // functionality
   // =============
   assign soft_reset_wclk1 = soft_reset_wclk1_wire;
   assign soft_reset_rclk1 = soft_reset_rclk1_wire;
   assign 	    txd_extend_int = rforce_disp ? txd_extend : 4'b0000;
   
   // GiGE Idle Detection, replaced in 8b10b encoder
   assign 	    d21_5_eq_n_d[0] = ({tx_ctl_tc_d[0], tx_data_tc_d[7:0]}  !=  {9'b010110101});
   assign 	    d21_5_eq_n_d[1] = ({tx_ctl_tc_d[1], tx_data_tc_d[15:8]} !=  {9'b010110101});
   assign 	    d2_2_eq_n_d[0]  = ({tx_ctl_tc_d[0], tx_data_tc_d[7:0]}  !=  {9'b001000010});
   assign 	    d2_2_eq_n_d[1]  = ({tx_ctl_tc_d[1], tx_data_tc_d[15:8]} !=  {9'b001000010});
   
   assign 	    wr_enable_out = wr_enable1;
   assign 	    rd_enable_out = rd_enable1;
   
   // 2-17-04 BT: Tied the tx_data[9] to 1'b0 in selftest mode since it effects the 
   //             disparity input in the 8B/10B encoder
   assign 	    tx_data[19:0]  = (p_rlpbk)     ? rxd_lpbk[19:0] :
                    (selftest_en) ? {1'b0, tx_control_sg[1], tx_data_sg[15:8], 1'b0, tx_control_sg[0], tx_data_sg[7:0]} : 
                    (redund_ctl)  ? txd_redun[19:0] : txd[19:0];
   
   // enable 3G double-width BIST by mapping tx_data_sg[15:8] & tx_control_sg[1] to the 3rd symbol location
   assign 	    tx_data[39:20] = (p_rlpbk)     ? rxd_lpbk[39:20] :
                    (selftest_en) ? {1'b0, tx_control_sg[3], tx_data_sg[31:24], 1'b0, tx_control_sg[1], tx_data_sg[15:8]} : 
                    (redund_ctl)  ? txd_redun[39:20] : txd[39:20];	
   
   assign 	    txfifo_en = (rtxfifo_urst_en)? ~txfifo_urst : 1'b1;
   
   // PIPE electric idle is on txd[10]
   //assign pipe_electric_idle = txd_extend_tc_d[0];
   
   assign 	    soft_reset_local = soft_reset | (rtxfifo_urst_en && txfifo_urst);
   
   // PIPE cmd
   assign 	    pipe_cmd = {powerdown, txdetectrxloopback, revloopback, 1'b0};
   
   assign 	    revloopback_int = txfifo_dis? pipe_cmd[1] : pipe_cmd_out[1];
   assign 	    txdetectrxloopback_int = txfifo_dis? pipe_cmd[2] : pipe_cmd_out[2];
   assign 	    powerdown_int = txfifo_dis? pipe_cmd[4:3]: pipe_cmd_out[4:3];
   
   assign 	    rxpolarity_int = rxpolarity;
   assign 	    polinv_rx_int = polinv_rx;


   assign 	    gen2ngen1_int = rindv_tx ? gen2ngen1: gen2ngen1_bundle;
   
   //************************************
   // Synchronization of gen2ngen1
   //************************************
   always @ (posedge soft_reset or posedge refclk_b_in)
     begin
	if(soft_reset)
	  begin
	     gen2ngen1_reg <= 1'b0;
	     gen2ngen1_sync <= 1'b0;
	  end
	else
	  begin
	     gen2ngen1_reg <= gen2ngen1_int;
	     gen2ngen1_sync <= gen2ngen1_reg;
	  end
     end // always @ (posedge soft_reset or posedge refclk_b_in)
      
   assign 	    rdwidth_or_auto = (rdwidth_tx | (rauto_speed_ena & ~rfreq_sel & gen2ngen1_sync));
   
   assign 		pipe_tx_trans = {txswing, txdeemph, txmargin};
   
   assign 		phfifo_txswing = txfifo_dis? pipe_tx_trans[4]: pipe_tx_trans_out[4];
   assign			phfifo_txdeemph = txfifo_dis? pipe_tx_trans[3]: pipe_tx_trans_out[3];
   assign 		phfifo_txmargin = txfifo_dis? pipe_tx_trans [2:0]: pipe_tx_trans_out[2:0];
   
   
   // synchronize reset input (in refclk_b domain)
   always @(posedge soft_reset_local or posedge fifo_wr_clk)
     begin
	if (soft_reset_local)
	  begin
	     soft_reset_wclk0 <= #1 1'b1;
	     soft_reset_wclk1_b4scan <= #1 1'b1;
	  end
	else
	  begin
	     soft_reset_wclk0 <= #1 1'b0;
	     soft_reset_wclk1_b4scan <= #1 soft_reset_wclk0;
	  end
     end // always @ (posedge soft_reset_local or posedge fifo_wr_clk)
      
   assign soft_reset_wclk1_wire = (scan_mode)? 1'b0 : soft_reset_wclk1_b4scan;
   
   // synchronize reset input (in refclk_b domain) and balance it with fifo_wr_clk reset
   always @(posedge soft_reset_local or posedge fifo_rd_clk)
     begin
	if (soft_reset_local)
	  begin
	     soft_reset_rclk0 <= #1 1'b1;
	     soft_reset_rclk1_b4scan <= #1 1'b1;
	  end
	else
	  begin
	     soft_reset_rclk0 <= #1 1'b0;
	     soft_reset_rclk1_b4scan <= #1 soft_reset_rclk0;
	  end
     end // always @ (posedge soft_reset_local or posedge fifo_rd_clk)
      
   assign soft_reset_rclk1_wire = (scan_mode)? 1'b0 : soft_reset_rclk1_b4scan;
   
   // write enable
   always @ (posedge soft_reset_wclk1_wire or posedge fifo_wr_clk)
     begin
	if (soft_reset_wclk1_wire)
	  begin
	     wr_enable0   <= #1 1'b0;
	     wr_enable0p5 <= #1 1'b0;
	     wr_enable1   <= #1 1'b0;
	     wr_enable2   <= #1 1'b0;
	  end
	else
	  begin
	     //wr_enable0   <= txfifo_en;
	     //wr_enable0   <= 1'b1;
	     wr_enable0   <= #1 ~(rauto_speed_ena & dis_pc_byte);
	     wr_enable0p5 <= #1 wr_enable0;
	     wr_enable1   <= #1 (rtxphfifopldctl_en)? (wr_enable0p5 && pld_we) : wr_enable0p5;
	     wr_enable2   <= #1 rmaster_tx ? (rindv_tx ? wr_enable1 : wr_enable_centrl) : (rmaster_up_tx ? wr_enable_quad_up : wr_enable_quad_down);
	  end
     end // always @ (posedge soft_reset_wclk1 or posedge fifo_wr_clk)
      
   assign din0 = {pipe_tx_trans,pipe_cmd,txd_extend_int[3:2], tx_data[39:20], txd_extend_int[1:0], tx_data[19:0]};
   
   // Instantiate new FIFO
   cycloneiv_hssi_tx_digis_ph_fifo ph_fifo_tx_1 (	.rst_wclk(soft_reset_wclk1_wire),
				.rst_rclk(soft_reset_rclk1_wire),
				.wr_clk(fifo_wr_clk),
				.rd_clk(fifo_rd_clk),
				.bypass_en(txfifo_dis),
				//.en(1'b1),
				.lowlatency_en(rtxfifo_lowlatency_en),
				.we(wr_enable2),
				.re(rd_enable2),
				.din(din0),
				.data_out(data_out_temp),
				.ph_fifo_full(ph_fifo_full),
				.ph_fifo_empty(ph_fifo_empty),
				.wptr_bin(wptr_bin),
				.rptr_bin(rptr_bin),
				.rphfifo_regmode_tx(rphfifo_regmode_tx),
				.rindv_tx(rindv_tx),
				.rmaster_tx(rmaster_tx),
				.rmaster_up_tx(rmaster_up_tx),
				.rauto_speed_ena(rauto_speed_ena), 
				.reset_pc_ptrs(reset_pc_ptrs),
				.reset_pc_ptrs_centrl(reset_pc_ptrs_centrl),
				.reset_pc_ptrs_quad_up(reset_pc_ptrs_quad_up),
				.reset_pc_ptrs_quad_down(reset_pc_ptrs_quad_down)
				);
assign pipe_tx_trans_out = data_out_temp[53:49];
assign pipe_cmd_out = data_out_temp[48: 44];
assign txd_extend_high = data_out_temp[43: 42];
assign fifo_data_out[39:20] = data_out_temp[41: 22];
assign txd_extend_low = data_out_temp[21: 20];
assign fifo_data_out[19:0]= data_out_temp[19: 0];

   // Modified Byte Serializer logic to use fifo_select_out to ping-pong between 
   // low and high banks of FIFO during normal mode
   // Toggle between {19,9} and {39,29} when DWIDTH is set, else fixed to {19,9}
   assign tx_data_9_tc_d = (~txfifo_dis & rd_enable_sync & (~rdwidth_or_auto | fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
			     {fifo_data_out[19], fifo_data_out[9]} :
	  (~txfifo_dis & rd_enable_sync & (rdwidth_or_auto & ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {fifo_data_out[39], fifo_data_out[29]} :
          (txfifo_dis & (~rdwidth_or_auto | ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {tx_data[19], tx_data[9]}  :  tx_data_9_tc_d_others ;
   
   assign tx_data_9_tc_d_others = (~rforce_kchar & rforce_echar) ? 2'b00 : 
          (txfifo_dis & rdwidth_or_auto & fifo_select_out & ~rforce_kchar & ~rforce_echar) ? 
	    {tx_data_lt[19], tx_data_lt[9]} :  2'b00;
   
   // 8th bit in each word. Toggle between {18,8} and {38,28} when DWIDTH is set, else fixed to {18,8}
   assign tx_ctl_tc_d   =  (~txfifo_dis & rd_enable_sync & (~rdwidth_or_auto | fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
			     {fifo_data_out[18], fifo_data_out[8]}  :
	  (~txfifo_dis & rd_enable_sync & (rdwidth_or_auto & ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {fifo_data_out[38], fifo_data_out[28]} :
          (txfifo_dis & (~rdwidth_or_auto | ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? {tx_data[18], tx_data[8]} :
          tx_ctl_tc_d_others ;
   
   // When transmitting Error(FE) or bypassing FIFO, transmit 11 in the former case and transmit bypassed data/ctl in the latter
   assign tx_ctl_tc_d_others = (~rforce_kchar & rforce_echar) ? 2'b11 : 
          (txfifo_dis & rdwidth_or_auto & fifo_select_out & ~rforce_kchar & ~rforce_echar) ? 
	    {tx_data_lt[18], tx_data_lt[8]} :   2'b11;
   
   // After rd_enable_sync goes high, start transmitting. Initially, fifo_select_out is zero, so MSByte transmitted first.
   // Transmit data if not forced Error or K-char.
   assign txd_extend_tc_d =  txd_data_extend_tmp[17:16];
   assign tx_data_tc_d = txd_data_extend_tmp[15:0];
   assign txd_data_extend_tmp = 
	  (~txfifo_dis & rd_enable_sync & (~rdwidth_or_auto | fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	    {txd_extend_low, fifo_data_out[17:10], fifo_data_out[7:0]} : 
	  (~txfifo_dis & rd_enable_sync & (rdwidth_or_auto & ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {txd_extend_high, fifo_data_out[37:30], fifo_data_out[27:20]} :
	  (txfifo_dis & (~rdwidth_or_auto | ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {txd_extend_int[1:0], tx_data[17:10], tx_data[7:0]} : tx_data_tc_d_others;
   
   // When transmitting Error(FE) or bypassing FIFO, transmit FE in the former case and transmit bypassed data/ctl in the latter
   assign tx_data_tc_d_others = (~rforce_kchar & rforce_echar) ? {2'h0,8'b11111110, 8'b11111110} :
          (txfifo_dis & rdwidth_or_auto & fifo_select_out & ~rforce_kchar & ~rforce_echar) ? {txd_extend_int[3:2],tx_data_lt[17:10],tx_data_lt[7:0]} :
          (~rindv_tx)    ?       {2'h0,8'b00000111, 8'b00000111} :      {2'h0,8'b10111100, 8'b10111100} ;
   
   // read enable & 
   // read enable sync (for byte serializer output enable)
   always @(posedge soft_reset_rclk1_wire or posedge fifo_rd_clk)
     begin
	if (soft_reset_rclk1_wire)
	  begin
	     pld_rd_dis0 <= #1 1'b0;
	     pld_rd_dis1 <= #1 1'b0;
	     pld_rd_dis2 <= #1 1'b0;
	     pld_rd_dis_edge <= #1 1'b0;
	     rd_enable0   <= #1 1'b0;
	     rd_enable0p5 <= #1 1'b0;
	     rd_enable1   <= #1 1'b0;
	     rd_enable2   <= #1 1'b0;
	     txfifo_en_rclk0 <= #1 1'b0;
	     txfifo_en_rclk1 <= #1 1'b0;
	     rd_enable_sync  <= #1 1'b0;
	  end
	else
	  begin
	     pld_rd_dis0 <= #1 pld_rd_dis;
	     pld_rd_dis1 <= #1 pld_rd_dis0;
	     pld_rd_dis2 <= #1 pld_rd_dis1;
	     pld_rd_dis_edge <= #1 (pld_rd_dis2 != pld_rd_dis1);
	     
	     
	     //rd_enable0   <= txfifo_en;
	     // rd_enable0   <= 1'b1;
	     rd_enable0   <= #1 ~(rauto_speed_ena & dis_pc_byte);
	     rd_enable0p5 <= #1 rd_enable0;
	     rd_enable1   <= #1 (rtxphfifopldctl_en)? (rd_enable0p5 && !pld_rd_dis_edge) : rd_enable0p5;
	     rd_enable2   <= #1 rmaster_tx ? (rindv_tx ? rd_enable1 : rd_enable_centrl) : (rmaster_up_tx ? rd_enable_quad_up : rd_enable_quad_down);
	     
	     //txfifo_en_rclk0 <= txfifo_en;
	     txfifo_en_rclk0 <= #1 1'b1;
	     txfifo_en_rclk1 <= #1 txfifo_en_rclk0;
	     
	     // start with valid data, so rd_enable_sync serves as dout valid
	     // ideally should be "rptr_bin == 3'd7", 
	     // but fifo_data_out is registered (1 clk delay). rd_enable_sync is
	     // used in high/low byte selection enable
	     if (rphfifo_regmode_tx)
	       rd_enable_sync  <= #1 1'b1;
	     else if (rd_enable_sync == 1'b0 && rptr_bin == 3'd0) 	
	       rd_enable_sync <= #1 rmaster_tx ? (rindv_tx ? rd_enable1 : rd_enable_centrl) : (rmaster_up_tx ? rd_enable_quad_up : rd_enable_quad_down);
	     else if (txfifo_en_rclk1 == 1'b0)
	       rd_enable_sync <= #1 1'b0;
	  end
     end // always @ (posedge soft_reset_rclk1 or posedge fifo_rd_clk)
      
   always @(posedge soft_reset or posedge refclk_b_in)
     begin
	if (soft_reset)
	  begin
	     tx_data_9_tc_mux     <= #1 2'b00;
	     tx_ctl_tc_mux        <= #1 2'b00;
	     tx_data_tc_mux       <= #1 16'h0000;
	     txd_extend_tc_mux    <= #1 2'b00;
	     tx_data_lt       <= #1 20'h00000;
	     d21_5_eq_n  	<= #1 2'b11;
	     d2_2_eq_n   	<= #1 2'b11;
	     k_det_sync1 	<= #1 2'b00;
	     k_det 		<= #1 2'b00;       
	     pipe_electric_idle <= #1 1'b0;
	  end
	else
	  begin
	     tx_data_9_tc_mux     <= #1 tx_data_9_tc_d;
	     tx_ctl_tc_mux        <= #1 tx_ctl_tc_d;
	     tx_data_tc_mux       <= #1 tx_data_tc_d;
	     
	     // PIPE enabled, txd[21] & txd[10] are used as PIPE electric idle
	     // hence in PIPE mode, txd[21] & txd[10](crd_enforce_value) are forced to txd[20] & txd[9] 
	     // (crd_enforce_enable) to have crd negative enable.
	     // crd positive enable is not provided in PIPE mode
	     txd_extend_tc_mux    <= #1 (rtx_pipe_enable) ? {txd_extend_tc_d[1], tx_data_9_tc_d[0]} : txd_extend_tc_d;
	     pipe_electric_idle <= #1 txd_extend_tc_d[0];
	     
	     d21_5_eq_n      	<= #1 d21_5_eq_n_d;
	     d2_2_eq_n       	<= #1 d2_2_eq_n_d;
	     k_det          	<= #1 k_det_sync1;
	     
	     if (rdwidth_or_auto && ~fifo_select_out)
       	       tx_data_lt       <= #1 tx_data[39:20];
	     
	     if ({tx_ctl_tc_d[0], tx_data_tc_d[7:0]} == 9'b110111100)
       	       k_det_sync1[0] <= #1 1'b1;
	     else 
       	       k_det_sync1[0] <= #1 1'b0;
	     
	     if ({tx_ctl_tc_d[1], tx_data_tc_d[15:8]} == 9'b110111100)
       	       k_det_sync1[1] <= #1 1'b1;
	     else 
       	       k_det_sync1[1] <= #1 1'b0;
	  end
     end // always @ (posedge soft_reset or posedge refclk_b_in)
      
   // byte serializer high/low select
   always @(posedge soft_reset or posedge refclk_b_in)
     begin
	if (soft_reset)
	  begin
	     rd_enable_sync_refclk_b_in <= #1 1'b0;
             txfifo_en_refclk0 <= #1 1'b0;
             txfifo_en_refclk1 <= #1 1'b0;
	     fifo_select_out  <= #1 1'b0;
	  end
	else 
	  begin
             //txfifo_en_refclk0 <= txfifo_en;
             // txfifo_en_refclk0 <= 1'b1;
	     txfifo_en_refclk0 <= #1 ~(rauto_speed_ena & dis_pc_byte);
	     txfifo_en_refclk1 <= #1 txfifo_en_refclk0;
	     
             if (txfifo_en_refclk1 ==1'b0)
	       rd_enable_sync_refclk_b_in <= #1 1'b0;
             else if (rd_enable_sync_refclk_b_in == 1'b0)
	       rd_enable_sync_refclk_b_in <= #1 rd_enable2;
	     
             // was ~fifo_select_in, it allows 1 cycle to send the signal across x4, x8 channels
       	     if (rd_enable_sync_refclk_b_in == 1'b1)
	       fifo_select_out  <= #1 rmaster_tx ? (rindv_tx ? ~fifo_select_out : ~fifo_select_in_centrl) : (rmaster_up_tx ? ~fifo_select_in_quad_up : ~fifo_select_in_quad_down);
             else
	       fifo_select_out  <= #1 1'b0;
	  end
     end // always @ (posedge soft_reset or posedge refclk_b_in)
      
   assign tx_data_9_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? tx_data_9_tc_d : tx_data_9_tc_mux;
   assign tx_ctl_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? tx_ctl_tc_d : tx_ctl_tc_mux;
   assign tx_data_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? tx_data_tc_d : tx_data_tc_mux;
   assign txd_extend_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? txd_extend_tc_d : txd_extend_tc_mux;

// LMC bin to gray for eidlinfersel

always @ (posedge fifo_wr_clk or posedge soft_reset_wclk1_wire)
begin
	if (soft_reset_wclk1_wire)
	begin
		gray_eidleinfersel	<= 3'b000;
	end
	else
	begin
		case (eidleinfersel)
		3'b000:
			gray_eidleinfersel	<= 3'b000;
		3'b001:
			gray_eidleinfersel	<= 3'b001;
		3'b010:
			gray_eidleinfersel	<= 3'b011;
		3'b011:
			gray_eidleinfersel	<= 3'b010;
		3'b100:
			gray_eidleinfersel	<= 3'b110;
		3'b101:
			gray_eidleinfersel	<= 3'b111;
		3'b110:
			gray_eidleinfersel	<= 3'b101;
		3'b111:
			gray_eidleinfersel	<= 3'b100;
		default:
			gray_eidleinfersel	<= 3'b000;
		endcase
	end
end

endmodule // tx_ctrl


//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 211 mux21 446 oper_add 10 oper_selector 88 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_tx_digi_bist_gen
	( 
	bist_ctl_sg,
	bist_data_sg,
	rbist_sel,
	rbisten_tx,
	rcxpat_chnl_sel,
	rdwidth_tx,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	output   [1:0]  bist_ctl_sg;
	output   [15:0]  bist_data_sg;
	input   [1:0]  rbist_sel;
	input   rbisten_tx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_tx;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   soft_reset;
	input   tx_clk;

	reg	ni001l45;
	reg	ni001l46;
	reg	nii00O39;
	reg	nii00O40;
	reg	nii01O41;
	reg	nii01O42;
	reg	nii0il37;
	reg	nii0il38;
	reg	nii0li35;
	reg	nii0li36;
	reg	nii0lO33;
	reg	nii0lO34;
	reg	nii0OO31;
	reg	nii0OO32;
	reg	nii1OO43;
	reg	nii1OO44;
	reg	niii0i23;
	reg	niii0i24;
	reg	niii0O21;
	reg	niii0O22;
	reg	niii1i29;
	reg	niii1i30;
	reg	niii1l27;
	reg	niii1l28;
	reg	niii1O25;
	reg	niii1O26;
	reg	niillO19;
	reg	niillO20;
	reg	niilOi17;
	reg	niilOi18;
	reg	niilOO15;
	reg	niilOO16;
	reg	niiO0i10;
	reg	niiO0i9;
	reg	niiO0O7;
	reg	niiO0O8;
	reg	niiO1i13;
	reg	niiO1i14;
	reg	niiO1l11;
	reg	niiO1l12;
	reg	niiOll5;
	reg	niiOll6;
	reg	niiOOl3;
	reg	niiOOl4;
	reg	nil11i1;
	reg	nil11i2;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n101i;
	reg	n101l;
	reg	n101O;
	reg	n10ii;
	reg	n10il;
	reg	n10iO;
	reg	n10li;
	reg	n10ll;
	reg	n10lO;
	reg	n10Oi;
	reg	n10Ol;
	reg	n10OO;
	reg	n110i;
	reg	n110l;
	reg	n110O;
	reg	n111i;
	reg	n111l;
	reg	n111O;
	reg	n11ii;
	reg	n11il;
	reg	n11iO;
	reg	n11li;
	reg	n11ll;
	reg	n11lO;
	reg	n11Oi;
	reg	n11Ol;
	reg	n11OO;
	reg	n1i0i;
	reg	n1i0l;
	reg	n1i0O;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1i1O;
	reg	n1iii;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l0i;
	reg	n1l0l;
	reg	n1l1i;
	reg	n1l1l;
	reg	n1l1O;
	reg	n1lii;
	reg	nliliO;
	reg	nlOOil;
	reg	nlOOiO;
	reg	nlOOli;
	reg	nlOOll;
	reg	nlOOlO;
	reg	nlOOOi;
	reg	nlOOOl;
	reg	nlOOOO;
	reg	n1liO;
	reg	nl00il;
	reg	nl00iO;
	reg	nl00li;
	reg	nl00ll;
	reg	nl00lO;
	reg	nl00Oi;
	reg	nl00Ol;
	reg	nl00OO;
	reg	nl0i0i;
	reg	nl0i0l;
	reg	nl0i0O;
	reg	nl0i1i;
	reg	nl0i1l;
	reg	nl0i1O;
	reg	nl0iii;
	reg	nl0iil;
	reg	nl0iiO;
	reg	nl0ili;
	reg	nl0ill;
	reg	nl0ilO;
	reg	nl0iOi;
	reg	nl0iOl;
	reg	nl0iOO;
	reg	nl0l0i;
	reg	nl0l0l;
	reg	nl0l0O;
	reg	nl0l1i;
	reg	nl0l1l;
	reg	nl0l1O;
	reg	nl0lii;
	reg	nl0lil;
	reg	nl0liO;
	reg	nl0lli;
	reg	nl0lll;
	reg	nl0llO;
	reg	nl0lOi;
	reg	nl0lOl;
	reg	nl0lOO;
	reg	nl0O0i;
	reg	nl0O0l;
	reg	nl0O0O;
	reg	nl0O1i;
	reg	nl0O1l;
	reg	nl0O1O;
	reg	nl0Oii;
	reg	nl0Oil;
	reg	nl0OiO;
	reg	nl0Oli;
	reg	nl0Oll;
	reg	nl0OlO;
	reg	nl0OOi;
	reg	nl0OOl;
	reg	nli11i;
	reg	nl0OOO_clk_prev;
	wire	wire_nl0OOO_PRN;
	reg	nli11O;
	reg	n0lOi;
	reg	niO0l;
	reg	niO0O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl00i;
	reg	nl00l;
	reg	nl00O;
	reg	nl01i;
	reg	nl01l;
	reg	nl01O;
	reg	nl0ii;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nli0i;
	reg	nli0l;
	reg	nli0O;
	reg	nli1i;
	reg	nli1l;
	reg	nli1O;
	reg	nliil;
	reg	nlili;
	reg	nliiO_clk_prev;
	wire	wire_nliiO_CLRN;
	wire	wire_nliiO_PRN;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO0OO_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1i_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOlil_dataout;
	wire	wire_niOliO_dataout;
	wire	wire_niOlli_dataout;
	wire	wire_niOlll_dataout;
	wire	wire_niOllO_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOlOl_dataout;
	wire	wire_niOlOO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOO0i_dataout;
	wire	wire_niOO0l_dataout;
	wire	wire_niOO0O_dataout;
	wire	wire_niOO1i_dataout;
	wire	wire_niOO1l_dataout;
	wire	wire_niOO1O_dataout;
	wire	wire_niOOii_dataout;
	wire	wire_niOOil_dataout;
	wire	wire_niOOiO_dataout;
	wire	wire_niOOli_dataout;
	wire	wire_niOOll_dataout;
	wire	wire_niOOlO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl100i_dataout;
	wire	wire_nl100l_dataout;
	wire	wire_nl100O_dataout;
	wire	wire_nl101i_dataout;
	wire	wire_nl101l_dataout;
	wire	wire_nl101O_dataout;
	wire	wire_nl10ii_dataout;
	wire	wire_nl10il_dataout;
	wire	wire_nl10iO_dataout;
	wire	wire_nl10li_dataout;
	wire	wire_nl10ll_dataout;
	wire	wire_nl10lO_dataout;
	wire	wire_nl10Oi_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl110i_dataout;
	wire	wire_nl110l_dataout;
	wire	wire_nl110O_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl11ii_dataout;
	wire	wire_nl11il_dataout;
	wire	wire_nl11iO_dataout;
	wire	wire_nl11li_dataout;
	wire	wire_nl11ll_dataout;
	wire	wire_nl11lO_dataout;
	wire	wire_nl11Oi_dataout;
	wire	wire_nl11Ol_dataout;
	wire	wire_nl11OO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0i_dataout;
	wire	wire_nl1i0l_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1i1i_dataout;
	wire	wire_nl1i1l_dataout;
	wire	wire_nl1i1O_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1iil_dataout;
	wire	wire_nl1iiO_dataout;
	wire	wire_nl1ili_dataout;
	wire	wire_nl1ill_dataout;
	wire	wire_nl1ilO_dataout;
	wire	wire_nl1iOi_dataout;
	wire	wire_nl1iOl_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0i_dataout;
	wire	wire_nl1l0l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1l1l_dataout;
	wire	wire_nl1l1O_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O0i_dataout;
	wire	wire_nl1O0l_dataout;
	wire	wire_nl1O0O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0i_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO00O_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO0ii_dataout;
	wire	wire_nlO0il_dataout;
	wire	wire_nlO0iO_dataout;
	wire	wire_nlO0li_dataout;
	wire	wire_nlO0ll_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO0Ol_dataout;
	wire	wire_nlO0OO_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi0i_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1i_dataout;
	wire	wire_nlOi1l_dataout;
	wire	wire_nlOi1O_dataout;
	wire	wire_nlOiii_dataout;
	wire	wire_nlOiil_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO0i_dataout;
	wire	wire_nlOO0l_dataout;
	wire	wire_nlOO0O_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire  [8:0]   wire_n00Oi_o;
	wire  [3:0]   wire_n01iO_o;
	wire  [2:0]   wire_n1lOi_o;
	wire  [5:0]   wire_n1Oll_o;
	wire  [2:0]   wire_n1OOO_o;
	wire  [6:0]   wire_nli0ll_o;
	wire  [6:0]   wire_nli0lO_o;
	wire  [7:0]   wire_nli0Oi_o;
	wire  [2:0]   wire_nliOl_o;
	wire  [4:0]   wire_nllli_o;
	wire  wire_n0iii_o;
	wire  wire_n0iil_o;
	wire  wire_n0iiO_o;
	wire  wire_n0ilO_o;
	wire  wire_n0iOl_o;
	wire  wire_n0l1i_o;
	wire  wire_n0l1O_o;
	wire  wire_n0lii_o;
	wire  wire_n0lil_o;
	wire  wire_n0liO_o;
	wire  wire_n0lli_o;
	wire  wire_n0lOl_o;
	wire  wire_n0O0l_o;
	wire  wire_n0O1l_o;
	wire  wire_n0Oil_o;
	wire  wire_n0Oll_o;
	wire  wire_n0OOl_o;
	wire  wire_ni00l_o;
	wire  wire_ni01i_o;
	wire  wire_ni01O_o;
	wire  wire_ni0ii_o;
	wire  wire_ni0iO_o;
	wire  wire_ni0ll_o;
	wire  wire_ni0Oi_o;
	wire  wire_ni10i_o;
	wire  wire_ni11l_o;
	wire  wire_ni1Ol_o;
	wire  wire_nil00l_o;
	wire  wire_nil01O_o;
	wire  wire_nil0il_o;
	wire  wire_nil0li_o;
	wire  wire_nil0Oi_o;
	wire  wire_nil1li_o;
	wire  wire_nil1lO_o;
	wire  wire_nil1OO_o;
	wire  wire_nili0i_o;
	wire  wire_nili0O_o;
	wire  wire_nili1i_o;
	wire  wire_niliil_o;
	wire  wire_nilili_o;
	wire  wire_nililO_o;
	wire  wire_niliOl_o;
	wire  wire_nill0O_o;
	wire  wire_nill1i_o;
	wire  wire_nill1O_o;
	wire  wire_nillil_o;
	wire  wire_nillli_o;
	wire  wire_nilllO_o;
	wire  wire_nillOl_o;
	wire  wire_nilO0l_o;
	wire  wire_nilO1i_o;
	wire  wire_nilO1O_o;
	wire  wire_nilOii_o;
	wire  wire_nilOiO_o;
	wire  wire_nilOli_o;
	wire  wire_nilOlO_o;
	wire  wire_nilOOl_o;
	wire  wire_niO11i_o;
	wire  wire_nlilOi_o;
	wire  wire_nliO0l_o;
	wire  wire_nliO1i_o;
	wire  wire_nliO1O_o;
	wire  wire_nliOii_o;
	wire  wire_nliOli_o;
	wire  wire_nliOlO_o;
	wire  wire_nliOOi_o;
	wire  wire_nliOOl_o;
	wire  wire_nll00O_o;
	wire  wire_nll01i_o;
	wire  wire_nll01O_o;
	wire  wire_nll0iO_o;
	wire  wire_nll0lO_o;
	wire  wire_nll0OO_o;
	wire  wire_nll10i_o;
	wire  wire_nll10O_o;
	wire  wire_nll11l_o;
	wire  wire_nll1il_o;
	wire  wire_nll1ll_o;
	wire  wire_nll1Ol_o;
	wire  wire_nlli0i_o;
	wire  wire_nlliil_o;
	wire  wire_nllili_o;
	wire  wire_nllilO_o;
	wire  wire_nlliOi_o;
	wire  wire_nlliOO_o;
	wire  wire_nlll0i_o;
	wire  wire_nlll0O_o;
	wire  wire_nlll1l_o;
	wire  ni000i;
	wire  ni000l;
	wire  ni000O;
	wire  ni001i;
	wire  ni001O;
	wire  ni00ii;
	wire  ni00il;
	wire  ni00iO;
	wire  ni00li;
	wire  ni00ll;
	wire  ni00lO;
	wire  ni00Oi;
	wire  ni00Ol;
	wire  ni00OO;
	wire  ni010i;
	wire  ni010l;
	wire  ni010O;
	wire  ni011i;
	wire  ni011l;
	wire  ni011O;
	wire  ni01ii;
	wire  ni01il;
	wire  ni01iO;
	wire  ni01li;
	wire  ni01ll;
	wire  ni01lO;
	wire  ni01Oi;
	wire  ni01Ol;
	wire  ni01OO;
	wire  ni0i0i;
	wire  ni0i0l;
	wire  ni0i0O;
	wire  ni0i1i;
	wire  ni0i1l;
	wire  ni0i1O;
	wire  ni0iii;
	wire  ni0iil;
	wire  ni0iiO;
	wire  ni0ili;
	wire  ni0ill;
	wire  ni0ilO;
	wire  ni0iOi;
	wire  ni0iOl;
	wire  ni0iOO;
	wire  ni0l0i;
	wire  ni0l0l;
	wire  ni0l0O;
	wire  ni0l1i;
	wire  ni0l1l;
	wire  ni0l1O;
	wire  ni0lii;
	wire  ni0lil;
	wire  ni0liO;
	wire  ni0lli;
	wire  ni0lll;
	wire  ni0llO;
	wire  ni0lOi;
	wire  ni0lOl;
	wire  ni0lOO;
	wire  ni0O0i;
	wire  ni0O0l;
	wire  ni0O0O;
	wire  ni0O1i;
	wire  ni0O1l;
	wire  ni0O1O;
	wire  ni0Oii;
	wire  ni0Oil;
	wire  ni0OiO;
	wire  ni0Oli;
	wire  ni0Oll;
	wire  ni0OlO;
	wire  ni0OOi;
	wire  ni0OOl;
	wire  ni0OOO;
	wire  ni1lll;
	wire  ni1llO;
	wire  ni1lOi;
	wire  ni1lOl;
	wire  ni1lOO;
	wire  ni1O0i;
	wire  ni1O0l;
	wire  ni1O0O;
	wire  ni1O1i;
	wire  ni1O1l;
	wire  ni1O1O;
	wire  ni1Oii;
	wire  ni1Oil;
	wire  ni1OiO;
	wire  ni1Oli;
	wire  ni1Oll;
	wire  ni1OlO;
	wire  ni1OOi;
	wire  ni1OOl;
	wire  ni1OOO;
	wire  nii00l;
	wire  nii01i;
	wire  nii01l;
	wire  nii0ii;
	wire  nii0ll;
	wire  nii0Ol;
	wire  nii10i;
	wire  nii10l;
	wire  nii10O;
	wire  nii11i;
	wire  nii11l;
	wire  nii11O;
	wire  nii1ii;
	wire  nii1il;
	wire  nii1iO;
	wire  nii1li;
	wire  nii1ll;
	wire  nii1lO;
	wire  nii1Oi;
	wire  nii1Ol;
	wire  niii0l;
	wire  niiiil;
	wire  niiiiO;
	wire  niiili;
	wire  niiill;
	wire  niiilO;
	wire  niiiOi;
	wire  niiiOl;
	wire  niiiOO;
	wire  niil0i;
	wire  niil0l;
	wire  niil0O;
	wire  niil1i;
	wire  niil1l;
	wire  niil1O;
	wire  niilii;
	wire  niilil;
	wire  niiliO;
	wire  niilli;
	wire  niilll;
	wire  niilOl;
	wire  niiOil;
	wire  niiOiO;
	wire  niiOli;
	wire  niiOOi;

	initial
		ni001l45 = 0;
	always @ ( posedge tx_clk)
		  ni001l45 <= ni001l46;
	event ni001l45_event;
	initial
		#1 ->ni001l45_event;
	always @(ni001l45_event)
		ni001l45 <= {1{1'b1}};
	initial
		ni001l46 = 0;
	always @ ( posedge tx_clk)
		  ni001l46 <= ni001l45;
	initial
		nii00O39 = 0;
	always @ ( posedge tx_clk)
		  nii00O39 <= nii00O40;
	event nii00O39_event;
	initial
		#1 ->nii00O39_event;
	always @(nii00O39_event)
		nii00O39 <= {1{1'b1}};
	initial
		nii00O40 = 0;
	always @ ( posedge tx_clk)
		  nii00O40 <= nii00O39;
	initial
		nii01O41 = 0;
	always @ ( posedge tx_clk)
		  nii01O41 <= nii01O42;
	event nii01O41_event;
	initial
		#1 ->nii01O41_event;
	always @(nii01O41_event)
		nii01O41 <= {1{1'b1}};
	initial
		nii01O42 = 0;
	always @ ( posedge tx_clk)
		  nii01O42 <= nii01O41;
	initial
		nii0il37 = 0;
	always @ ( posedge tx_clk)
		  nii0il37 <= nii0il38;
	event nii0il37_event;
	initial
		#1 ->nii0il37_event;
	always @(nii0il37_event)
		nii0il37 <= {1{1'b1}};
	initial
		nii0il38 = 0;
	always @ ( posedge tx_clk)
		  nii0il38 <= nii0il37;
	initial
		nii0li35 = 0;
	always @ ( posedge tx_clk)
		  nii0li35 <= nii0li36;
	event nii0li35_event;
	initial
		#1 ->nii0li35_event;
	always @(nii0li35_event)
		nii0li35 <= {1{1'b1}};
	initial
		nii0li36 = 0;
	always @ ( posedge tx_clk)
		  nii0li36 <= nii0li35;
	initial
		nii0lO33 = 0;
	always @ ( posedge tx_clk)
		  nii0lO33 <= nii0lO34;
	event nii0lO33_event;
	initial
		#1 ->nii0lO33_event;
	always @(nii0lO33_event)
		nii0lO33 <= {1{1'b1}};
	initial
		nii0lO34 = 0;
	always @ ( posedge tx_clk)
		  nii0lO34 <= nii0lO33;
	initial
		nii0OO31 = 0;
	always @ ( posedge tx_clk)
		  nii0OO31 <= nii0OO32;
	event nii0OO31_event;
	initial
		#1 ->nii0OO31_event;
	always @(nii0OO31_event)
		nii0OO31 <= {1{1'b1}};
	initial
		nii0OO32 = 0;
	always @ ( posedge tx_clk)
		  nii0OO32 <= nii0OO31;
	initial
		nii1OO43 = 0;
	always @ ( posedge tx_clk)
		  nii1OO43 <= nii1OO44;
	event nii1OO43_event;
	initial
		#1 ->nii1OO43_event;
	always @(nii1OO43_event)
		nii1OO43 <= {1{1'b1}};
	initial
		nii1OO44 = 0;
	always @ ( posedge tx_clk)
		  nii1OO44 <= nii1OO43;
	initial
		niii0i23 = 0;
	always @ ( posedge tx_clk)
		  niii0i23 <= niii0i24;
	event niii0i23_event;
	initial
		#1 ->niii0i23_event;
	always @(niii0i23_event)
		niii0i23 <= {1{1'b1}};
	initial
		niii0i24 = 0;
	always @ ( posedge tx_clk)
		  niii0i24 <= niii0i23;
	initial
		niii0O21 = 0;
	always @ ( posedge tx_clk)
		  niii0O21 <= niii0O22;
	event niii0O21_event;
	initial
		#1 ->niii0O21_event;
	always @(niii0O21_event)
		niii0O21 <= {1{1'b1}};
	initial
		niii0O22 = 0;
	always @ ( posedge tx_clk)
		  niii0O22 <= niii0O21;
	initial
		niii1i29 = 0;
	always @ ( posedge tx_clk)
		  niii1i29 <= niii1i30;
	event niii1i29_event;
	initial
		#1 ->niii1i29_event;
	always @(niii1i29_event)
		niii1i29 <= {1{1'b1}};
	initial
		niii1i30 = 0;
	always @ ( posedge tx_clk)
		  niii1i30 <= niii1i29;
	initial
		niii1l27 = 0;
	always @ ( posedge tx_clk)
		  niii1l27 <= niii1l28;
	event niii1l27_event;
	initial
		#1 ->niii1l27_event;
	always @(niii1l27_event)
		niii1l27 <= {1{1'b1}};
	initial
		niii1l28 = 0;
	always @ ( posedge tx_clk)
		  niii1l28 <= niii1l27;
	initial
		niii1O25 = 0;
	always @ ( posedge tx_clk)
		  niii1O25 <= niii1O26;
	event niii1O25_event;
	initial
		#1 ->niii1O25_event;
	always @(niii1O25_event)
		niii1O25 <= {1{1'b1}};
	initial
		niii1O26 = 0;
	always @ ( posedge tx_clk)
		  niii1O26 <= niii1O25;
	initial
		niillO19 = 0;
	always @ ( posedge tx_clk)
		  niillO19 <= niillO20;
	event niillO19_event;
	initial
		#1 ->niillO19_event;
	always @(niillO19_event)
		niillO19 <= {1{1'b1}};
	initial
		niillO20 = 0;
	always @ ( posedge tx_clk)
		  niillO20 <= niillO19;
	initial
		niilOi17 = 0;
	always @ ( posedge tx_clk)
		  niilOi17 <= niilOi18;
	event niilOi17_event;
	initial
		#1 ->niilOi17_event;
	always @(niilOi17_event)
		niilOi17 <= {1{1'b1}};
	initial
		niilOi18 = 0;
	always @ ( posedge tx_clk)
		  niilOi18 <= niilOi17;
	initial
		niilOO15 = 0;
	always @ ( posedge tx_clk)
		  niilOO15 <= niilOO16;
	event niilOO15_event;
	initial
		#1 ->niilOO15_event;
	always @(niilOO15_event)
		niilOO15 <= {1{1'b1}};
	initial
		niilOO16 = 0;
	always @ ( posedge tx_clk)
		  niilOO16 <= niilOO15;
	initial
		niiO0i10 = 0;
	always @ ( posedge tx_clk)
		  niiO0i10 <= niiO0i9;
	initial
		niiO0i9 = 0;
	always @ ( posedge tx_clk)
		  niiO0i9 <= niiO0i10;
	event niiO0i9_event;
	initial
		#1 ->niiO0i9_event;
	always @(niiO0i9_event)
		niiO0i9 <= {1{1'b1}};
	initial
		niiO0O7 = 0;
	always @ ( posedge tx_clk)
		  niiO0O7 <= niiO0O8;
	event niiO0O7_event;
	initial
		#1 ->niiO0O7_event;
	always @(niiO0O7_event)
		niiO0O7 <= {1{1'b1}};
	initial
		niiO0O8 = 0;
	always @ ( posedge tx_clk)
		  niiO0O8 <= niiO0O7;
	initial
		niiO1i13 = 0;
	always @ ( posedge tx_clk)
		  niiO1i13 <= niiO1i14;
	event niiO1i13_event;
	initial
		#1 ->niiO1i13_event;
	always @(niiO1i13_event)
		niiO1i13 <= {1{1'b1}};
	initial
		niiO1i14 = 0;
	always @ ( posedge tx_clk)
		  niiO1i14 <= niiO1i13;
	initial
		niiO1l11 = 0;
	always @ ( posedge tx_clk)
		  niiO1l11 <= niiO1l12;
	event niiO1l11_event;
	initial
		#1 ->niiO1l11_event;
	always @(niiO1l11_event)
		niiO1l11 <= {1{1'b1}};
	initial
		niiO1l12 = 0;
	always @ ( posedge tx_clk)
		  niiO1l12 <= niiO1l11;
	initial
		niiOll5 = 0;
	always @ ( posedge tx_clk)
		  niiOll5 <= niiOll6;
	event niiOll5_event;
	initial
		#1 ->niiOll5_event;
	always @(niiOll5_event)
		niiOll5 <= {1{1'b1}};
	initial
		niiOll6 = 0;
	always @ ( posedge tx_clk)
		  niiOll6 <= niiOll5;
	initial
		niiOOl3 = 0;
	always @ ( posedge tx_clk)
		  niiOOl3 <= niiOOl4;
	event niiOOl3_event;
	initial
		#1 ->niiOOl3_event;
	always @(niiOOl3_event)
		niiOOl3 <= {1{1'b1}};
	initial
		niiOOl4 = 0;
	always @ ( posedge tx_clk)
		  niiOOl4 <= niiOOl3;
	initial
		nil11i1 = 0;
	always @ ( posedge tx_clk)
		  nil11i1 <= nil11i2;
	event nil11i1_event;
	initial
		#1 ->nil11i1_event;
	always @(nil11i1_event)
		nil11i1 <= {1{1'b1}};
	initial
		nil11i2 = 0;
	always @ ( posedge tx_clk)
		  nil11i2 <= nil11i1;
	initial
	begin
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n101i = 0;
		n101l = 0;
		n101O = 0;
		n10ii = 0;
		n10il = 0;
		n10iO = 0;
		n10li = 0;
		n10ll = 0;
		n10lO = 0;
		n10Oi = 0;
		n10Ol = 0;
		n10OO = 0;
		n110i = 0;
		n110l = 0;
		n110O = 0;
		n111i = 0;
		n111l = 0;
		n111O = 0;
		n11ii = 0;
		n11il = 0;
		n11iO = 0;
		n11li = 0;
		n11ll = 0;
		n11lO = 0;
		n11Oi = 0;
		n11Ol = 0;
		n11OO = 0;
		n1i0i = 0;
		n1i0l = 0;
		n1i0O = 0;
		n1i1i = 0;
		n1i1l = 0;
		n1i1O = 0;
		n1iii = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1iOl = 0;
		n1iOO = 0;
		n1l0i = 0;
		n1l0l = 0;
		n1l1i = 0;
		n1l1l = 0;
		n1l1O = 0;
		n1lii = 0;
		nliliO = 0;
		nlOOil = 0;
		nlOOiO = 0;
		nlOOli = 0;
		nlOOll = 0;
		nlOOlO = 0;
		nlOOOi = 0;
		nlOOOl = 0;
		nlOOOO = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n101i <= 0;
			n101l <= 0;
			n101O <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10iO <= 0;
			n10li <= 0;
			n10ll <= 0;
			n10lO <= 0;
			n10Oi <= 0;
			n10Ol <= 0;
			n10OO <= 0;
			n110i <= 0;
			n110l <= 0;
			n110O <= 0;
			n111i <= 0;
			n111l <= 0;
			n111O <= 0;
			n11ii <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11li <= 0;
			n11ll <= 0;
			n11lO <= 0;
			n11Oi <= 0;
			n11Ol <= 0;
			n11OO <= 0;
			n1i0i <= 0;
			n1i0l <= 0;
			n1i0O <= 0;
			n1i1i <= 0;
			n1i1l <= 0;
			n1i1O <= 0;
			n1iii <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1iOl <= 0;
			n1iOO <= 0;
			n1l0i <= 0;
			n1l0l <= 0;
			n1l1i <= 0;
			n1l1l <= 0;
			n1l1O <= 0;
			n1lii <= 0;
			nliliO <= 0;
			nlOOil <= 0;
			nlOOiO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
			nlOOlO <= 0;
			nlOOOi <= 0;
			nlOOOl <= 0;
			nlOOOO <= 0;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			n100i <= wire_nll01O_o;
			n100l <= wire_nll00O_o;
			n100O <= wire_nll0iO_o;
			n101i <= wire_n001O_dataout;
			n101l <= ni0OlO;
			n101O <= wire_nliO1i_o;
			n10ii <= wire_nll0lO_o;
			n10il <= wire_nll0OO_o;
			n10iO <= (~ ni0OOi);
			n10li <= wire_nlli0i_o;
			n10ll <= (~ ni0OOl);
			n10lO <= wire_nlliil_o;
			n10Oi <= wire_nllili_o;
			n10Ol <= wire_nllilO_o;
			n10OO <= wire_nlliOi_o;
			n110i <= wire_n011i_dataout;
			n110l <= wire_n011l_dataout;
			n110O <= wire_n011O_dataout;
			n111i <= wire_n1OlO_dataout;
			n111l <= wire_n1OOi_dataout;
			n111O <= wire_n1OOl_dataout;
			n11ii <= wire_n010i_dataout;
			n11il <= wire_n01li_dataout;
			n11iO <= wire_n01ll_dataout;
			n11li <= wire_n01lO_dataout;
			n11ll <= wire_n01Oi_dataout;
			n11lO <= wire_n01Ol_dataout;
			n11Oi <= wire_n01OO_dataout;
			n11Ol <= wire_n001i_dataout;
			n11OO <= wire_n001l_dataout;
			n1i0i <= wire_nlll0O_o;
			n1i0l <= wire_nliO1O_o;
			n1i0O <= wire_nliO0l_o;
			n1i1i <= wire_nlliOO_o;
			n1i1l <= wire_nlll1l_o;
			n1i1O <= wire_nlll0i_o;
			n1iii <= wire_nliOii_o;
			n1iil <= wire_nliOli_o;
			n1iiO <= wire_nliOll_dataout;
			n1ili <= wire_nliOlO_o;
			n1ill <= wire_nliOOi_o;
			n1ilO <= wire_nliOOl_o;
			n1iOi <= wire_nll11i_dataout;
			n1iOl <= wire_nll11l_o;
			n1iOO <= wire_nll10i_o;
			n1l0i <= wire_nll1Oi_dataout;
			n1l0l <= wire_nll1Ol_o;
			n1l1i <= wire_nll10O_o;
			n1l1l <= wire_nll1il_o;
			n1l1O <= wire_nll1ll_o;
			n1lii <= wire_nll01i_o;
			nliliO <= wire_n1lli_dataout;
			nlOOil <= wire_n1lll_dataout;
			nlOOiO <= wire_n1llO_dataout;
			nlOOli <= wire_n1lOl_dataout;
			nlOOll <= wire_n1lOO_dataout;
			nlOOlO <= wire_n1O1i_dataout;
			nlOOOi <= wire_n1O1l_dataout;
			nlOOOl <= wire_n1O1O_dataout;
			nlOOOO <= wire_n1O0i_dataout;
		end
	end
	initial
	begin
		n1liO = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1liO <= 1;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			n1liO <= niilOl;
		end
	end
	initial
	begin
		nl00il = 0;
		nl00iO = 0;
		nl00li = 0;
		nl00ll = 0;
		nl00lO = 0;
		nl00Oi = 0;
		nl00Ol = 0;
		nl00OO = 0;
		nl0i0i = 0;
		nl0i0l = 0;
		nl0i0O = 0;
		nl0i1i = 0;
		nl0i1l = 0;
		nl0i1O = 0;
		nl0iii = 0;
		nl0iil = 0;
		nl0iiO = 0;
		nl0ili = 0;
		nl0ill = 0;
		nl0ilO = 0;
		nl0iOi = 0;
		nl0iOl = 0;
		nl0iOO = 0;
		nl0l0i = 0;
		nl0l0l = 0;
		nl0l0O = 0;
		nl0l1i = 0;
		nl0l1l = 0;
		nl0l1O = 0;
		nl0lii = 0;
		nl0lil = 0;
		nl0liO = 0;
		nl0lli = 0;
		nl0lll = 0;
		nl0llO = 0;
		nl0lOi = 0;
		nl0lOl = 0;
		nl0lOO = 0;
		nl0O0i = 0;
		nl0O0l = 0;
		nl0O0O = 0;
		nl0O1i = 0;
		nl0O1l = 0;
		nl0O1O = 0;
		nl0Oii = 0;
		nl0Oil = 0;
		nl0OiO = 0;
		nl0Oli = 0;
		nl0Oll = 0;
		nl0OlO = 0;
		nl0OOi = 0;
		nl0OOl = 0;
		nli11i = 0;
	end
	always @ (tx_clk or wire_nl0OOO_PRN or soft_reset)
	begin
		if (wire_nl0OOO_PRN == 1'b0) 
		begin
			nl00il <= 1;
			nl00iO <= 1;
			nl00li <= 1;
			nl00ll <= 1;
			nl00lO <= 1;
			nl00Oi <= 1;
			nl00Ol <= 1;
			nl00OO <= 1;
			nl0i0i <= 1;
			nl0i0l <= 1;
			nl0i0O <= 1;
			nl0i1i <= 1;
			nl0i1l <= 1;
			nl0i1O <= 1;
			nl0iii <= 1;
			nl0iil <= 1;
			nl0iiO <= 1;
			nl0ili <= 1;
			nl0ill <= 1;
			nl0ilO <= 1;
			nl0iOi <= 1;
			nl0iOl <= 1;
			nl0iOO <= 1;
			nl0l0i <= 1;
			nl0l0l <= 1;
			nl0l0O <= 1;
			nl0l1i <= 1;
			nl0l1l <= 1;
			nl0l1O <= 1;
			nl0lii <= 1;
			nl0lil <= 1;
			nl0liO <= 1;
			nl0lli <= 1;
			nl0lll <= 1;
			nl0llO <= 1;
			nl0lOi <= 1;
			nl0lOl <= 1;
			nl0lOO <= 1;
			nl0O0i <= 1;
			nl0O0l <= 1;
			nl0O0O <= 1;
			nl0O1i <= 1;
			nl0O1l <= 1;
			nl0O1O <= 1;
			nl0Oii <= 1;
			nl0Oil <= 1;
			nl0OiO <= 1;
			nl0Oli <= 1;
			nl0Oll <= 1;
			nl0OlO <= 1;
			nl0OOi <= 1;
			nl0OOl <= 1;
			nli11i <= 1;
		end
		else if  (soft_reset == 1'b1) 
		begin
			nl00il <= 0;
			nl00iO <= 0;
			nl00li <= 0;
			nl00ll <= 0;
			nl00lO <= 0;
			nl00Oi <= 0;
			nl00Ol <= 0;
			nl00OO <= 0;
			nl0i0i <= 0;
			nl0i0l <= 0;
			nl0i0O <= 0;
			nl0i1i <= 0;
			nl0i1l <= 0;
			nl0i1O <= 0;
			nl0iii <= 0;
			nl0iil <= 0;
			nl0iiO <= 0;
			nl0ili <= 0;
			nl0ill <= 0;
			nl0ilO <= 0;
			nl0iOi <= 0;
			nl0iOl <= 0;
			nl0iOO <= 0;
			nl0l0i <= 0;
			nl0l0l <= 0;
			nl0l0O <= 0;
			nl0l1i <= 0;
			nl0l1l <= 0;
			nl0l1O <= 0;
			nl0lii <= 0;
			nl0lil <= 0;
			nl0liO <= 0;
			nl0lli <= 0;
			nl0lll <= 0;
			nl0llO <= 0;
			nl0lOi <= 0;
			nl0lOl <= 0;
			nl0lOO <= 0;
			nl0O0i <= 0;
			nl0O0l <= 0;
			nl0O0O <= 0;
			nl0O1i <= 0;
			nl0O1l <= 0;
			nl0O1O <= 0;
			nl0Oii <= 0;
			nl0Oil <= 0;
			nl0OiO <= 0;
			nl0Oli <= 0;
			nl0Oll <= 0;
			nl0OlO <= 0;
			nl0OOi <= 0;
			nl0OOl <= 0;
			nli11i <= 0;
		end
		else 
		if (tx_clk != nl0OOO_clk_prev && tx_clk == 1'b1) 
		begin
			nl00il <= wire_nli10i_dataout;
			nl00iO <= wire_nli10l_dataout;
			nl00li <= wire_nli10O_dataout;
			nl00ll <= wire_nli1ii_dataout;
			nl00lO <= wire_nli1il_dataout;
			nl00Oi <= wire_nli1iO_dataout;
			nl00Ol <= wire_nli1li_dataout;
			nl00OO <= wire_nli1ll_dataout;
			nl0i0i <= wire_nli1OO_dataout;
			nl0i0l <= wire_nli01i_dataout;
			nl0i0O <= wire_nli01l_dataout;
			nl0i1i <= wire_nli1lO_dataout;
			nl0i1l <= wire_nli1Oi_dataout;
			nl0i1O <= wire_nli1Ol_dataout;
			nl0iii <= wire_nli01O_dataout;
			nl0iil <= wire_nli00i_dataout;
			nl0iiO <= wire_nli00l_dataout;
			nl0ili <= wire_nli00O_dataout;
			nl0ill <= wire_nli0ii_dataout;
			nl0ilO <= wire_nli0il_dataout;
			nl0iOi <= wire_nli0iO_dataout;
			nl0iOl <= wire_nli0li_dataout;
			nl0iOO <= (~ (nli11O | nl0OOi));
			nl0l0i <= wire_nil01O_o;
			nl0l0l <= wire_nil00l_o;
			nl0l0O <= wire_nil0il_o;
			nl0l1i <= wire_nil1li_o;
			nl0l1l <= wire_nil1lO_o;
			nl0l1O <= wire_nil1OO_o;
			nl0lii <= wire_nil0li_o;
			nl0lil <= wire_nil0Oi_o;
			nl0liO <= wire_nili1i_o;
			nl0lli <= wire_nili0i_o;
			nl0lll <= wire_nili0O_o;
			nl0llO <= wire_niliil_o;
			nl0lOi <= wire_nilili_o;
			nl0lOl <= wire_nililO_o;
			nl0lOO <= wire_niliOl_o;
			nl0O0i <= wire_nillil_o;
			nl0O0l <= wire_nillli_o;
			nl0O0O <= wire_nilllO_o;
			nl0O1i <= wire_nill1i_o;
			nl0O1l <= wire_nill1O_o;
			nl0O1O <= wire_nill0O_o;
			nl0Oii <= wire_nillOl_o;
			nl0Oil <= wire_nilO1i_o;
			nl0OiO <= wire_nilO1O_o;
			nl0Oli <= wire_nilO0l_o;
			nl0Oll <= wire_nilOii_o;
			nl0OlO <= wire_nilOiO_o;
			nl0OOi <= wire_nilOli_o;
			nl0OOl <= wire_nilOlO_o;
			nli11i <= wire_nilOOl_o;
		end
		nl0OOO_clk_prev <= tx_clk;
	end
	assign
		wire_nl0OOO_PRN = (ni001l46 ^ ni001l45);
	initial
	begin
		nli11O = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nli11O <= 1;
		end
		else 
		begin
			nli11O <= wire_niO11i_o;
		end
	end
	initial
	begin
		n0lOi = 0;
		niO0l = 0;
		niO0O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl00i = 0;
		nl00l = 0;
		nl00O = 0;
		nl01i = 0;
		nl01l = 0;
		nl01O = 0;
		nl0ii = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nli0i = 0;
		nli0l = 0;
		nli0O = 0;
		nli1i = 0;
		nli1l = 0;
		nli1O = 0;
		nliil = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n0lOi <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl00i <= 0;
			nl00l <= 0;
			nl00O <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl01O <= 0;
			nl0ii <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nli0i <= 0;
			nli0l <= 0;
			nli0O <= 0;
			nli1i <= 0;
			nli1l <= 0;
			nli1O <= 0;
			nliil <= 0;
		end
		else if  (wire_nli_dataout == 1'b1) 
		begin
			n0lOi <= wire_nlill_dataout;
			niO0l <= wire_nlilO_dataout;
			niO0O <= wire_nliOi_dataout;
			niOii <= wire_nliOO_dataout;
			niOil <= wire_nll1i_dataout;
			niOiO <= wire_nll1l_dataout;
			niOli <= wire_nll1O_dataout;
			niOll <= wire_nll0i_dataout;
			niOlO <= niil1l;
			niOOi <= wire_n0ilO_o;
			niOOl <= (~ niil1O);
			niOOO <= niil0i;
			nl00i <= wire_n0lii_o;
			nl00l <= wire_n0lil_o;
			nl00O <= wire_n0liO_o;
			nl01i <= wire_n0l1i_o;
			nl01l <= wire_n0l1O_o;
			nl01O <= wire_n0l0O_dataout;
			nl0ii <= wire_n0lli_o;
			nl0il <= wire_n0llO_dataout;
			nl0iO <= wire_n0lOl_o;
			nl0li <= wire_n0O1i_dataout;
			nl0ll <= wire_n0O1l_o;
			nl0lO <= wire_n0O0i_dataout;
			nl0Oi <= wire_n0O0l_o;
			nl0Ol <= wire_n0Oii_dataout;
			nl0OO <= wire_n0Oil_o;
			nl10i <= (~ niilil);
			nl10l <= (~ niiliO);
			nl10O <= niilli;
			nl11i <= (~ niil0l);
			nl11l <= (~ niil0O);
			nl11O <= (~ niilii);
			nl1ii <= wire_ni1Ol_o;
			nl1il <= wire_ni01i_o;
			nl1iO <= wire_ni01O_o;
			nl1li <= wire_ni00l_o;
			nl1ll <= wire_ni0ii_o;
			nl1lO <= wire_ni0iO_o;
			nl1Oi <= wire_ni0ll_o;
			nl1Ol <= wire_ni0Oi_o;
			nl1OO <= wire_n0iOl_o;
			nli0i <= wire_n0OOl_o;
			nli0l <= wire_ni11i_dataout;
			nli0O <= wire_ni11l_o;
			nli1i <= wire_n0Oli_dataout;
			nli1l <= wire_n0Oll_o;
			nli1O <= wire_n0OOi_dataout;
			nliil <= wire_ni10i_o;
		end
	end
	initial
	begin
		nlili = 0;
	end
	always @ (tx_clk or wire_nliiO_PRN or wire_nliiO_CLRN)
	begin
		if (wire_nliiO_PRN == 1'b0) 
		begin
			nlili <= 1;
		end
		else if  (wire_nliiO_CLRN == 1'b0) 
		begin
			nlili <= 0;
		end
		else if  (wire_nli_dataout == 1'b1) 
		if (tx_clk != nliiO_clk_prev && tx_clk == 1'b1) 
		begin
			nlili <= niilOl;
		end
		nliiO_clk_prev <= tx_clk;
	end
	assign
		wire_nliiO_CLRN = (niilOi18 ^ niilOi17),
		wire_nliiO_PRN = ((niillO20 ^ niillO19) & (~ soft_reset));
	assign		wire_n000i_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[0] : n11il;
	assign		wire_n000l_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[1] : n11iO;
	assign		wire_n000O_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[2] : n11li;
	and(wire_n001i_dataout, wire_n00li_dataout, ~(wire_nlillO_dataout));
	and(wire_n001l_dataout, wire_n00ll_dataout, ~(wire_nlillO_dataout));
	and(wire_n001O_dataout, wire_n00lO_dataout, ~(wire_nlillO_dataout));
	assign		wire_n00i_dataout = (niiOil === 1'b1) ? nl0l0l : wire_niii_dataout;
	assign		wire_n00ii_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[3] : n11ll;
	assign		wire_n00il_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[4] : n11lO;
	assign		wire_n00iO_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[5] : n11Oi;
	assign		wire_n00l_dataout = (niiOil === 1'b1) ? nl0l0O : wire_niil_dataout;
	assign		wire_n00li_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[6] : n11Ol;
	assign		wire_n00ll_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[7] : n11OO;
	assign		wire_n00lO_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[8] : n101i;
	assign		wire_n00O_dataout = (niiOil === 1'b1) ? nl0lii : wire_niiO_dataout;
	and(wire_n010i_dataout, wire_n01il_dataout, ~(wire_nlilll_dataout));
	assign		wire_n010l_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[0] : n110i;
	assign		wire_n010O_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[1] : n110l;
	and(wire_n011i_dataout, wire_n010l_dataout, ~(wire_nlilll_dataout));
	and(wire_n011l_dataout, wire_n010O_dataout, ~(wire_nlilll_dataout));
	and(wire_n011O_dataout, wire_n01ii_dataout, ~(wire_nlilll_dataout));
	assign		wire_n01i_dataout = (niiOil === 1'b1) ? nl0l1l : wire_ni0i_dataout;
	assign		wire_n01ii_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[2] : n110O;
	assign		wire_n01il_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[3] : n11ii;
	assign		wire_n01l_dataout = (niiOil === 1'b1) ? nl0l1O : wire_ni0l_dataout;
	and(wire_n01li_dataout, wire_n000i_dataout, ~(wire_nlillO_dataout));
	and(wire_n01ll_dataout, wire_n000l_dataout, ~(wire_nlillO_dataout));
	and(wire_n01lO_dataout, wire_n000O_dataout, ~(wire_nlillO_dataout));
	assign		wire_n01O_dataout = (niiOil === 1'b1) ? nl0l0i : wire_ni0O_dataout;
	and(wire_n01Oi_dataout, wire_n00ii_dataout, ~(wire_nlillO_dataout));
	and(wire_n01Ol_dataout, wire_n00il_dataout, ~(wire_nlillO_dataout));
	and(wire_n01OO_dataout, wire_n00iO_dataout, ~(wire_nlillO_dataout));
	and(wire_n0i_dataout, nl1ll, niiOli);
	assign		wire_n0ii_dataout = (niiOil === 1'b1) ? nl0lil : wire_nili_dataout;
	assign		wire_n0il_dataout = (niiOil === 1'b1) ? nl0liO : wire_nill_dataout;
	assign		wire_n0iO_dataout = (niiOil === 1'b1) ? nl0lli : wire_nilO_dataout;
	and(wire_n0l_dataout, nl1lO, niiOli);
	and(wire_n0l0O_dataout, (~ niiOOi), nl0ii);
	assign		wire_n0li_dataout = (niiOil === 1'b1) ? nl0lll : wire_niOi_dataout;
	assign		wire_n0ll_dataout = (niiOil === 1'b1) ? nl0llO : wire_niOl_dataout;
	and(wire_n0llO_dataout, (~ niiOOi), nl0iO);
	assign		wire_n0lO_dataout = (niiOil === 1'b1) ? nl0lOi : wire_niOO_dataout;
	and(wire_n0O_dataout, nl1Oi, niiOli);
	and(wire_n0O0i_dataout, (~ niiOOi), nl0Oi);
	and(wire_n0O1i_dataout, (~ niiOOi), nl0ll);
	assign		wire_n0Oi_dataout = (niiOil === 1'b1) ? nl0lOl : wire_nl1i_dataout;
	and(wire_n0Oii_dataout, (~ niiOOi), nl0OO);
	assign		wire_n0Ol_dataout = (niiOil === 1'b1) ? nl0lOO : wire_nl1l_dataout;
	and(wire_n0Oli_dataout, (~ niiOOi), nli1l);
	assign		wire_n0OO_dataout = (niiOil === 1'b1) ? nl0O1i : wire_nl1O_dataout;
	and(wire_n0OOi_dataout, (~ niiOOi), nli0i);
	and(wire_n1i_dataout, nl1il, niiOli);
	and(wire_n1l_dataout, nl1iO, niiOli);
	and(wire_n1lli_dataout, wire_n1lOi_o[0], wire_nlilOi_o);
	and(wire_n1lll_dataout, wire_n1lOi_o[1], wire_nlilOi_o);
	and(wire_n1llO_dataout, wire_n1lOi_o[2], wire_nlilOi_o);
	assign		wire_n1lOl_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[0] : wire_n1O0l_dataout;
	assign		wire_n1lOO_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[1] : wire_n1O0O_dataout;
	and(wire_n1O_dataout, nl1li, niiOli);
	assign		wire_n1O0i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[5] : wire_n1Oli_dataout;
	and(wire_n1O0l_dataout, nlOOli, ~(wire_nlilii_dataout));
	and(wire_n1O0O_dataout, nlOOll, ~(wire_nlilii_dataout));
	assign		wire_n1O1i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[2] : wire_n1Oii_dataout;
	assign		wire_n1O1l_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[3] : wire_n1Oil_dataout;
	assign		wire_n1O1O_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[4] : wire_n1OiO_dataout;
	and(wire_n1Oii_dataout, nlOOlO, ~(wire_nlilii_dataout));
	and(wire_n1Oil_dataout, nlOOOi, ~(wire_nlilii_dataout));
	and(wire_n1OiO_dataout, nlOOOl, ~(wire_nlilii_dataout));
	and(wire_n1Oli_dataout, nlOOOO, ~(wire_nlilii_dataout));
	assign		wire_n1OlO_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[0] : n111i;
	assign		wire_n1OOi_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[1] : n111l;
	assign		wire_n1OOl_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[2] : n111O;
	assign		wire_ni0i_dataout = (niiOiO === 1'b1) ? n100i : wire_nlii_dataout;
	assign		wire_ni0l_dataout = (niiOiO === 1'b1) ? n100l : wire_nlil_dataout;
	assign		wire_ni0O_dataout = (niiOiO === 1'b1) ? n100O : wire_nliO_dataout;
	and(wire_ni0OO_dataout, niiiil, ~(niiilO));
	and(wire_ni11i_dataout, wire_nillO_dataout, nli0O);
	assign		wire_ni1i_dataout = (niiOil === 1'b1) ? nl0O1l : wire_nl0i_dataout;
	assign		wire_ni1l_dataout = (niiOil === 1'b1) ? nl0iOO : wire_nl0l_dataout;
	assign		wire_ni1O_dataout = (niiOil === 1'b1) ? nl0l1i : wire_nl0O_dataout;
	and(wire_nii_dataout, nl1Ol, niiOli);
	and(wire_nii0i_dataout, wire_niiil_dataout, niiOOi);
	and(wire_nii0l_dataout, wire_niiiO_dataout, niiOOi);
	assign		wire_nii0O_dataout = (niiilO === 1'b1) ? niiiil : niiiiO;
	and(wire_nii1i_dataout, niiiil, niiilO);
	and(wire_nii1l_dataout, wire_nii0O_dataout, ~(niiOOi));
	assign		wire_nii1O_dataout = (niiOOi === 1'b1) ? (~ niiili) : wire_niiii_dataout;
	assign		wire_niii_dataout = (niiOiO === 1'b1) ? n10ii : wire_nlli_dataout;
	assign		wire_niiii_dataout = (niiilO === 1'b1) ? (~ niiiil) : (~ niiiiO);
	and(wire_niiil_dataout, niiili, ~(niiilO));
	and(wire_niiiO_dataout, niiili, niiilO);
	assign		wire_niil_dataout = (niiOiO === 1'b1) ? n10il : wire_nlll_dataout;
	and(wire_niili_dataout, wire_nil1i_dataout, niiOOi);
	and(wire_niill_dataout, wire_nil1l_dataout, niiOOi);
	and(wire_niilO_dataout, wire_nil1O_dataout, niiOOi);
	assign		wire_niiO_dataout = (niiOiO === 1'b1) ? n10iO : wire_nllO_dataout;
	and(wire_niiOi_dataout, wire_nil0i_dataout, niiOOi);
	and(wire_niiOl_dataout, (~ niiill), niiOOi);
	and(wire_niiOO_dataout, niiill, niiOOi);
	and(wire_nil_dataout, niOlO, niiOli);
	and(wire_nil0i_dataout, niiilO, niiill);
	and(wire_nil0l_dataout, wire_nilil_dataout, ~(niiilO));
	and(wire_nil0O_dataout, wire_niliO_dataout, ~(niiilO));
	and(wire_nil1i_dataout, wire_nil0l_dataout, niiill);
	and(wire_nil1l_dataout, wire_nil0O_dataout, niiill);
	and(wire_nil1O_dataout, wire_nilii_dataout, niiill);
	assign		wire_nili_dataout = (niiOiO === 1'b1) ? n10li : wire_nlOi_dataout;
	and(wire_nilii_dataout, niil1i, ~(niiilO));
	and(wire_nilil_dataout, (~ niiiOO), ~(niil1i));
	and(wire_niliO_dataout, niiiOO, ~(niil1i));
	assign		wire_nill_dataout = (niiOiO === 1'b1) ? n10ll : wire_nlOl_dataout;
	and(wire_nilli_dataout, (~ niiiOl), niiOOi);
	or(wire_nilll_dataout, wire_nilOl_dataout, niiOOi);
	and(wire_nillO_dataout, wire_nilOO_dataout, ~(niiOOi));
	assign		wire_nilO_dataout = (niiOiO === 1'b1) ? n10lO : wire_nlOO_dataout;
	and(wire_nilOi_dataout, wire_niO1i_dataout, ~(niiOOi));
	or(wire_nilOl_dataout, wire_niO1l_dataout, niiilO);
	and(wire_nilOO_dataout, (~ niiiOl), ~(niiilO));
	and(wire_niO_dataout, niOOi, niiOli);
	assign		wire_niO00i_dataout = (niiOOi === 1'b1) ? nl00OO : nl0iil;
	assign		wire_niO00l_dataout = (niiOOi === 1'b1) ? nl0i1i : nl0iiO;
	assign		wire_niO00O_dataout = (niiOOi === 1'b1) ? nl0i1l : nl0ili;
	assign		wire_niO01i_dataout = (niiOOi === 1'b1) ? wire_niOOOi_dataout : wire_niOiOO_dataout;
	assign		wire_niO01l_dataout = (niiOOi === 1'b1) ? wire_niOOOl_dataout : wire_niOl1i_dataout;
	and(wire_niO01O_dataout, nl0iii, ~(niiOOi));
	assign		wire_niO0ii_dataout = (niiOOi === 1'b1) ? nl0i1O : nl0ill;
	assign		wire_niO0il_dataout = (niiOOi === 1'b1) ? nl0i0i : nl0ilO;
	assign		wire_niO0iO_dataout = (niiOOi === 1'b1) ? nl0i0l : nl0iOi;
	assign		wire_niO0li_dataout = (niiOOi === 1'b1) ? nl0i0O : nl0iOl;
	and(wire_niO0ll_dataout, nl00il, niiOOi);
	and(wire_niO0lO_dataout, nl00iO, niiOOi);
	and(wire_niO0Oi_dataout, nl00li, niiOOi);
	and(wire_niO0Ol_dataout, nl00ll, niiOOi);
	and(wire_niO0OO_dataout, nl00lO, niiOOi);
	assign		wire_niO10i_dataout = (niiOOi === 1'b1) ? wire_niOO1i_dataout : wire_niOi1O_dataout;
	assign		wire_niO10l_dataout = (niiOOi === 1'b1) ? wire_niOO1l_dataout : wire_niOi0i_dataout;
	assign		wire_niO10O_dataout = (niiOOi === 1'b1) ? wire_niOO1O_dataout : wire_niOi0l_dataout;
	and(wire_niO11l_dataout, wire_nlO_dataout, niiOOi);
	and(wire_niO11O_dataout, wire_nlO_dataout, ~(niiOOi));
	and(wire_niO1i_dataout, wire_niO1O_dataout, ~(niiilO));
	assign		wire_niO1ii_dataout = (niiOOi === 1'b1) ? wire_niOO0i_dataout : wire_niOi0O_dataout;
	assign		wire_niO1il_dataout = (niiOOi === 1'b1) ? wire_niOO0l_dataout : wire_niOiii_dataout;
	assign		wire_niO1iO_dataout = (niiOOi === 1'b1) ? wire_niOO0O_dataout : wire_niOiil_dataout;
	and(wire_niO1l_dataout, niiiOi, niiiOl);
	assign		wire_niO1li_dataout = (niiOOi === 1'b1) ? wire_niOOii_dataout : wire_niOiiO_dataout;
	assign		wire_niO1ll_dataout = (niiOOi === 1'b1) ? wire_niOOil_dataout : wire_niOili_dataout;
	assign		wire_niO1lO_dataout = (niiOOi === 1'b1) ? wire_niOOiO_dataout : wire_niOill_dataout;
	and(wire_niO1O_dataout, (~ niiiOi), niiiOl);
	assign		wire_niO1Oi_dataout = (niiOOi === 1'b1) ? wire_niOOli_dataout : wire_niOilO_dataout;
	assign		wire_niO1Ol_dataout = (niiOOi === 1'b1) ? wire_niOOll_dataout : wire_niOiOi_dataout;
	assign		wire_niO1OO_dataout = (niiOOi === 1'b1) ? wire_niOOlO_dataout : wire_niOiOl_dataout;
	assign		wire_niOi_dataout = (niiOiO === 1'b1) ? n10Oi : wire_n1i_dataout;
	and(wire_niOi0i_dataout, wire_niOl1O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi0l_dataout, wire_niOl0i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi0O_dataout, wire_niOl0l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi1i_dataout, nl00Oi, niiOOi);
	and(wire_niOi1l_dataout, nl00Ol, niiOOi);
	and(wire_niOi1O_dataout, wire_niOl1l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiii_dataout, wire_niOl0O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiil_dataout, wire_niOlii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiiO_dataout, wire_niOlil_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOili_dataout, wire_niOliO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOill_dataout, wire_niOlli_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOilO_dataout, wire_niOlll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOi_dataout, wire_niOllO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOl_dataout, wire_niOlOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOO_dataout, wire_niOlOl_dataout, ~((~ wire_nlO_dataout)));
	assign		wire_niOl_dataout = (niiOiO === 1'b1) ? n10Ol : wire_n1l_dataout;
	and(wire_niOl0i_dataout, nl0O0l, ~(ni01Oi));
	and(wire_niOl0l_dataout, nl0O0O, ~(ni01Oi));
	and(wire_niOl0O_dataout, nl0Oii, ~(ni01Oi));
	or(wire_niOl1i_dataout, wire_niOlOO_dataout, (~ wire_nlO_dataout));
	and(wire_niOl1l_dataout, nl0O1O, ~(ni01Oi));
	and(wire_niOl1O_dataout, nl0O0i, ~(ni01Oi));
	and(wire_niOlii_dataout, nl0Oil, ~(ni01Oi));
	and(wire_niOlil_dataout, nl0OiO, ~(ni01Oi));
	and(wire_niOliO_dataout, nl0Oli, ~(ni01Oi));
	and(wire_niOlli_dataout, nl0Oll, ~(ni01Oi));
	or(wire_niOlll_dataout, nl0OlO, ni01Oi);
	and(wire_niOllO_dataout, nl0OOi, ~(ni01Oi));
	and(wire_niOlOi_dataout, nl0OOl, ~(ni01Oi));
	and(wire_niOlOl_dataout, nli11i, ~(ni01Oi));
	and(wire_niOlOO_dataout, nli11O, ~(ni01Oi));
	assign		wire_niOO_dataout = (niiOiO === 1'b1) ? n10OO : wire_n1O_dataout;
	and(wire_niOO0i_dataout, wire_nl111O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO0l_dataout, wire_nl110i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO0O_dataout, wire_nl110l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1i_dataout, wire_niOOOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1l_dataout, wire_nl111i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1O_dataout, wire_nl111l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOii_dataout, wire_nl110O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOil_dataout, wire_nl11ii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOiO_dataout, wire_nl11il_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOli_dataout, wire_nl11iO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOll_dataout, wire_nl11li_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOlO_dataout, wire_nl11ll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOOi_dataout, wire_nl11lO_dataout, ~((~ wire_nlO_dataout)));
	or(wire_niOOOl_dataout, wire_nl11Oi_dataout, (~ wire_nlO_dataout));
	and(wire_niOOOO_dataout, nl0O1O, ~(ni01Ol));
	and(wire_nl000i_dataout, nl0OOi, ~(wire_nlO_dataout));
	and(wire_nl000l_dataout, nl0OOl, ~(wire_nlO_dataout));
	or(wire_nl000O_dataout, nli11i, wire_nlO_dataout);
	and(wire_nl001i_dataout, nl0Oli, ~(wire_nlO_dataout));
	and(wire_nl001l_dataout, nl0Oll, ~(wire_nlO_dataout));
	and(wire_nl001O_dataout, nl0OlO, ~(wire_nlO_dataout));
	and(wire_nl00ii_dataout, nli11O, ~(wire_nlO_dataout));
	and(wire_nl010i_dataout, nl0OlO, ~(ni001i));
	and(wire_nl010l_dataout, nl0OOi, ~(ni001i));
	or(wire_nl010O_dataout, nl0OOl, ni001i);
	and(wire_nl011i_dataout, nl0OiO, ~(ni001i));
	and(wire_nl011l_dataout, nl0Oli, ~(ni001i));
	and(wire_nl011O_dataout, nl0Oll, ~(ni001i));
	and(wire_nl01ii_dataout, nli11i, ~(ni001i));
	and(wire_nl01il_dataout, nli11O, ~(ni001i));
	and(wire_nl01iO_dataout, nl0O1O, ~(wire_nlO_dataout));
	and(wire_nl01li_dataout, nl0O0i, ~(wire_nlO_dataout));
	and(wire_nl01ll_dataout, nl0O0l, ~(wire_nlO_dataout));
	and(wire_nl01lO_dataout, nl0O0O, ~(wire_nlO_dataout));
	and(wire_nl01Oi_dataout, nl0Oii, ~(wire_nlO_dataout));
	and(wire_nl01Ol_dataout, nl0Oil, ~(wire_nlO_dataout));
	and(wire_nl01OO_dataout, nl0OiO, ~(wire_nlO_dataout));
	assign		wire_nl0i_dataout = (niiOiO === 1'b1) ? n1i0i : wire_nii_dataout;
	assign		wire_nl0l_dataout = (niiOiO === 1'b1) ? n101l : wire_nil_dataout;
	assign		wire_nl0O_dataout = (niiOiO === 1'b1) ? n101O : wire_niO_dataout;
	assign		wire_nl100i_dataout = (niiOOi === 1'b1) ? wire_nl1O1i_dataout : wire_nl1i1O_dataout;
	assign		wire_nl100l_dataout = (niiOOi === 1'b1) ? wire_nl1O1l_dataout : wire_nl1i0i_dataout;
	assign		wire_nl100O_dataout = (niiOOi === 1'b1) ? wire_nl1O1O_dataout : wire_nl1i0l_dataout;
	assign		wire_nl101i_dataout = (niiOOi === 1'b1) ? wire_nl1lOi_dataout : wire_nl10OO_dataout;
	assign		wire_nl101l_dataout = (niiOOi === 1'b1) ? wire_nl1lOl_dataout : wire_nl1i1i_dataout;
	assign		wire_nl101O_dataout = (niiOOi === 1'b1) ? wire_nl1lOO_dataout : wire_nl1i1l_dataout;
	assign		wire_nl10ii_dataout = (niiOOi === 1'b1) ? wire_nl1O0i_dataout : wire_nl1i0O_dataout;
	assign		wire_nl10il_dataout = (niiOOi === 1'b1) ? wire_nl1O0l_dataout : wire_nl1iii_dataout;
	assign		wire_nl10iO_dataout = (niiOOi === 1'b1) ? wire_nl1O0O_dataout : wire_nl1iil_dataout;
	assign		wire_nl10li_dataout = (niiOOi === 1'b1) ? wire_nl1Oii_dataout : wire_nl1iiO_dataout;
	assign		wire_nl10ll_dataout = (niiOOi === 1'b1) ? wire_nl1Oil_dataout : wire_nl1ili_dataout;
	assign		wire_nl10lO_dataout = (niiOOi === 1'b1) ? wire_nl1OiO_dataout : wire_nl1ill_dataout;
	and(wire_nl10Oi_dataout, wire_nl1ilO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl10Ol_dataout, wire_nl1iOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl10OO_dataout, wire_nl1iOl_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl110i_dataout, nl0Oii, ~(ni01Ol));
	and(wire_nl110l_dataout, nl0Oil, ~(ni01Ol));
	and(wire_nl110O_dataout, nl0OiO, ~(ni01Ol));
	and(wire_nl111i_dataout, nl0O0i, ~(ni01Ol));
	and(wire_nl111l_dataout, nl0O0l, ~(ni01Ol));
	and(wire_nl111O_dataout, nl0O0O, ~(ni01Ol));
	and(wire_nl11ii_dataout, nl0Oli, ~(ni01Ol));
	and(wire_nl11il_dataout, nl0Oll, ~(ni01Ol));
	or(wire_nl11iO_dataout, nl0OlO, ni01Ol);
	and(wire_nl11li_dataout, nl0OOi, ~(ni01Ol));
	and(wire_nl11ll_dataout, nl0OOl, ~(ni01Ol));
	and(wire_nl11lO_dataout, nli11i, ~(ni01Ol));
	and(wire_nl11Oi_dataout, nli11O, ~(ni01Ol));
	assign		wire_nl11Ol_dataout = (niiOOi === 1'b1) ? wire_nl1lll_dataout : wire_nl10Oi_dataout;
	assign		wire_nl11OO_dataout = (niiOOi === 1'b1) ? wire_nl1llO_dataout : wire_nl10Ol_dataout;
	assign		wire_nl1i_dataout = (niiOiO === 1'b1) ? n1i1i : wire_n0i_dataout;
	and(wire_nl1i0i_dataout, wire_nl1l1O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i0l_dataout, wire_nl1l0i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i0O_dataout, wire_nl1l0l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1i_dataout, wire_nl1iOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1l_dataout, wire_nl1l1i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1O_dataout, wire_nl1l1l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iii_dataout, wire_nl1l0O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iil_dataout, wire_nl1lii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iiO_dataout, wire_nl1lil_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1ili_dataout, wire_nl1liO_dataout, ~((~ wire_nlO_dataout)));
	or(wire_nl1ill_dataout, wire_nl1lli_dataout, (~ wire_nlO_dataout));
	and(wire_nl1ilO_dataout, nl0O1O, ~(ni01OO));
	and(wire_nl1iOi_dataout, nl0O0i, ~(ni01OO));
	and(wire_nl1iOl_dataout, nl0O0l, ~(ni01OO));
	and(wire_nl1iOO_dataout, nl0O0O, ~(ni01OO));
	assign		wire_nl1l_dataout = (niiOiO === 1'b1) ? n1i1l : wire_n0l_dataout;
	and(wire_nl1l0i_dataout, nl0Oli, ~(ni01OO));
	and(wire_nl1l0l_dataout, nl0Oll, ~(ni01OO));
	and(wire_nl1l0O_dataout, nl0OlO, ~(ni01OO));
	and(wire_nl1l1i_dataout, nl0Oii, ~(ni01OO));
	and(wire_nl1l1l_dataout, nl0Oil, ~(ni01OO));
	and(wire_nl1l1O_dataout, nl0OiO, ~(ni01OO));
	and(wire_nl1lii_dataout, nl0OOi, ~(ni01OO));
	or(wire_nl1lil_dataout, nl0OOl, ni01OO);
	and(wire_nl1liO_dataout, nli11i, ~(ni01OO));
	and(wire_nl1lli_dataout, nli11O, ~(ni01OO));
	and(wire_nl1lll_dataout, wire_nl1Oli_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1llO_dataout, wire_nl1Oll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOi_dataout, wire_nl1OlO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOl_dataout, wire_nl1OOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOO_dataout, wire_nl1OOl_dataout, ~((~ wire_nlO_dataout)));
	assign		wire_nl1O_dataout = (niiOiO === 1'b1) ? n1i1O : wire_n0O_dataout;
	and(wire_nl1O0i_dataout, wire_nl011O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O0l_dataout, wire_nl010i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O0O_dataout, wire_nl010l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1i_dataout, wire_nl1OOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1l_dataout, wire_nl011i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1O_dataout, wire_nl011l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1Oii_dataout, wire_nl010O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1Oil_dataout, wire_nl01ii_dataout, ~((~ wire_nlO_dataout)));
	or(wire_nl1OiO_dataout, wire_nl01il_dataout, (~ wire_nlO_dataout));
	and(wire_nl1Oli_dataout, nl0O1O, ~(ni001i));
	and(wire_nl1Oll_dataout, nl0O0i, ~(ni001i));
	and(wire_nl1OlO_dataout, nl0O0l, ~(ni001i));
	and(wire_nl1OOi_dataout, nl0O0O, ~(ni001i));
	and(wire_nl1OOl_dataout, nl0Oii, ~(ni001i));
	and(wire_nl1OOO_dataout, nl0Oil, ~(ni001i));
	and(wire_nli_dataout, rbisten_tx, ((~ rbist_sel[0]) & rbist_sel[1]));
	and(wire_nli00i_dataout, wire_nli0Oi_o[1], ni001O);
	and(wire_nli00l_dataout, wire_nli0Oi_o[2], ni001O);
	and(wire_nli00O_dataout, wire_nli0Oi_o[3], ni001O);
	and(wire_nli01i_dataout, wire_nli0lO_o[5], ni001O);
	and(wire_nli01l_dataout, wire_nli0lO_o[6], ni001O);
	and(wire_nli01O_dataout, wire_nli0Oi_o[0], ni001O);
	and(wire_nli0ii_dataout, wire_nli0Oi_o[4], ni001O);
	and(wire_nli0il_dataout, wire_nli0Oi_o[5], ni001O);
	and(wire_nli0iO_dataout, wire_nli0Oi_o[6], ni001O);
	and(wire_nli0li_dataout, wire_nli0Oi_o[7], ni001O);
	and(wire_nli10i_dataout, wire_nli0ll_o[0], ni001O);
	and(wire_nli10l_dataout, wire_nli0ll_o[1], ni001O);
	and(wire_nli10O_dataout, wire_nli0ll_o[2], ni001O);
	and(wire_nli1ii_dataout, wire_nli0ll_o[3], ni001O);
	and(wire_nli1il_dataout, wire_nli0ll_o[4], ni001O);
	and(wire_nli1iO_dataout, wire_nli0ll_o[5], ni001O);
	and(wire_nli1li_dataout, wire_nli0ll_o[6], ni001O);
	and(wire_nli1ll_dataout, wire_nli0lO_o[0], ni001O);
	and(wire_nli1lO_dataout, wire_nli0lO_o[1], ni001O);
	and(wire_nli1Oi_dataout, wire_nli0lO_o[2], ni001O);
	and(wire_nli1Ol_dataout, wire_nli0lO_o[3], ni001O);
	and(wire_nli1OO_dataout, wire_nli0lO_o[4], ni001O);
	and(wire_nlii_dataout, niOOl, niiOli);
	and(wire_nlil_dataout, niOOO, niiOli);
	and(wire_nlil0O_dataout, wire_nllO1O_dataout, n1iOl);
	and(wire_nlilii_dataout, wire_nllO0i_dataout, n1iOl);
	and(wire_nlilil_dataout, niiOOi, n1iOO);
	and(wire_nlill_dataout, wire_nliOl_o[0], wire_n0iiO_o);
	and(wire_nlilli_dataout, wire_nlO10l_dataout, n1l1i);
	and(wire_nlilll_dataout, wire_nlO10O_dataout, n1l1i);
	and(wire_nlillO_dataout, wire_nlOi0O_dataout, n1l1l);
	and(wire_nlilO_dataout, wire_nliOl_o[1], wire_n0iiO_o);
	and(wire_nliO_dataout, nl11i, niiOli);
	and(wire_nliOi_dataout, wire_nliOl_o[2], wire_n0iiO_o);
	and(wire_nliOll_dataout, (~ niiOOi), n1ilO);
	assign		wire_nliOO_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[0] : wire_nll0l_dataout;
	and(wire_nll_dataout, rbisten_tx, (rbist_sel[0] & (~ rbist_sel[1])));
	assign		wire_nll0i_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[4] : wire_nlliO_dataout;
	and(wire_nll0l_dataout, niOii, ~(wire_n0iil_o));
	and(wire_nll0O_dataout, niOil, ~(wire_n0iil_o));
	and(wire_nll11i_dataout, wire_nlO1ll_dataout, n1l1i);
	assign		wire_nll1i_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[1] : wire_nll0O_dataout;
	assign		wire_nll1l_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[2] : wire_nllii_dataout;
	assign		wire_nll1O_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[3] : wire_nllil_dataout;
	and(wire_nll1Oi_dataout, wire_nlOlOO_dataout, n1l0l);
	and(wire_nlli_dataout, nl11l, niiOli);
	and(wire_nllii_dataout, niOiO, ~(wire_n0iil_o));
	and(wire_nllil_dataout, niOli, ~(wire_n0iil_o));
	and(wire_nlliO_dataout, niOll, ~(wire_n0iil_o));
	and(wire_nlll_dataout, nl11O, niiOli);
	and(wire_nlllil_dataout, ni0l0l, ~(ni0Oii));
	and(wire_nllliO_dataout, ni0l0l, ni0Oii);
	and(wire_nlllli_dataout, wire_nlllOl_dataout, ~(niiOOi));
	assign		wire_nlllll_dataout = (niiOOi === 1'b1) ? (~ ni0lii) : wire_nlllOO_dataout;
	and(wire_nllllO_dataout, wire_nllO1i_dataout, niiOOi);
	and(wire_nlllOi_dataout, wire_nllO1l_dataout, niiOOi);
	assign		wire_nlllOl_dataout = (ni0Oii === 1'b1) ? ni0l0l : ni0l0O;
	assign		wire_nlllOO_dataout = (ni0Oii === 1'b1) ? (~ ni0l0l) : (~ ni0l0O);
	and(wire_nllO_dataout, nl10i, niiOli);
	assign		wire_nllO0i_dataout = (niiOOi === 1'b1) ? ni0lil : ni0liO;
	and(wire_nllO0l_dataout, wire_nllOll_dataout, niiOOi);
	and(wire_nllO0O_dataout, wire_nllOlO_dataout, niiOOi);
	and(wire_nllO1i_dataout, ni0lii, ~(ni0Oii));
	and(wire_nllO1l_dataout, ni0lii, ni0Oii);
	assign		wire_nllO1O_dataout = (niiOOi === 1'b1) ? (~ ni0lil) : (~ ni0liO);
	and(wire_nllOii_dataout, wire_nllOOi_dataout, niiOOi);
	and(wire_nllOil_dataout, wire_nllOOl_dataout, niiOOi);
	and(wire_nllOiO_dataout, wire_nllOOO_dataout, niiOOi);
	and(wire_nllOli_dataout, ni0lli, niiOOi);
	and(wire_nllOll_dataout, wire_nlO11i_dataout, ~(ni0lli));
	and(wire_nllOlO_dataout, wire_nlO11l_dataout, ~(ni0lli));
	and(wire_nllOOi_dataout, wire_nlO11O_dataout, ~(ni0lli));
	and(wire_nllOOl_dataout, wire_nlO10i_dataout, ~(ni0lli));
	and(wire_nllOOO_dataout, (~ ni0lll), ~(ni0lli));
	and(wire_nlO_dataout, rbisten_tx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (niiOll6 ^ niiOll5)));
	and(wire_nlO00i_dataout, wire_nlO0li_dataout, ~(ni0lOO));
	and(wire_nlO00l_dataout, ni0lOi, ~(ni0lOO));
	and(wire_nlO00O_dataout, wire_nlO0ll_dataout, ~(ni0lOi));
	and(wire_nlO01i_dataout, wire_nlO0ii_dataout, ~(ni0lOO));
	and(wire_nlO01l_dataout, wire_nlO0il_dataout, ~(ni0lOO));
	and(wire_nlO01O_dataout, wire_nlO0iO_dataout, ~(ni0lOO));
	and(wire_nlO0ii_dataout, wire_nlO0lO_dataout, ~(ni0lOi));
	and(wire_nlO0il_dataout, wire_nlO0Oi_dataout, ~(ni0lOi));
	and(wire_nlO0iO_dataout, wire_nlO0Ol_dataout, ~(ni0lOi));
	and(wire_nlO0li_dataout, (~ ni0lOl), ~(ni0lOi));
	and(wire_nlO0ll_dataout, wire_nlO0OO_dataout, ni0lOl);
	and(wire_nlO0lO_dataout, wire_nlOi1i_dataout, ni0lOl);
	and(wire_nlO0Oi_dataout, wire_nlOi1l_dataout, ni0lOl);
	and(wire_nlO0Ol_dataout, ni0Oii, ni0lOl);
	and(wire_nlO0OO_dataout, wire_nlOi1O_dataout, ~(ni0Oii));
	and(wire_nlO10i_dataout, ni0Oii, ni0lll);
	or(wire_nlO10l_dataout, (~ ni0llO), ~(niiOOi));
	and(wire_nlO10O_dataout, ni0llO, niiOOi);
	and(wire_nlO11i_dataout, wire_nlO0OO_dataout, ni0lll);
	and(wire_nlO11l_dataout, wire_nlOi1i_dataout, ni0lll);
	and(wire_nlO11O_dataout, wire_nlOi1l_dataout, ni0lll);
	and(wire_nlO1ii_dataout, wire_nlO1OO_dataout, ~(niiOOi));
	and(wire_nlO1il_dataout, wire_nlO01i_dataout, ~(niiOOi));
	and(wire_nlO1iO_dataout, wire_nlO01l_dataout, ~(niiOOi));
	and(wire_nlO1li_dataout, wire_nlO01O_dataout, ~(niiOOi));
	assign		wire_nlO1ll_dataout = (niiOOi === 1'b1) ? ni0llO : ni0lOO;
	and(wire_nlO1lO_dataout, wire_nlO00i_dataout, ~(niiOOi));
	and(wire_nlO1Oi_dataout, (~ ni0llO), niiOOi);
	and(wire_nlO1Ol_dataout, wire_nlO00l_dataout, ~(niiOOi));
	and(wire_nlO1OO_dataout, wire_nlO00O_dataout, ~(ni0lOO));
	and(wire_nlOi_dataout, nl10l, niiOli);
	and(wire_nlOi0i_dataout, ni0Oli, ~(ni0Oll));
	assign		wire_nlOi0O_dataout = (niiOOi === 1'b1) ? wire_nlOl1O_dataout : wire_nlOiiO_dataout;
	and(wire_nlOi1i_dataout, wire_nlOi0i_dataout, ~(ni0Oii));
	and(wire_nlOi1l_dataout, ni0Oll, ~(ni0Oii));
	and(wire_nlOi1O_dataout, (~ ni0Oli), ~(ni0Oll));
	assign		wire_nlOiii_dataout = (niiOOi === 1'b1) ? wire_nlOl0i_dataout : wire_nlOili_dataout;
	assign		wire_nlOiil_dataout = (niiOOi === 1'b1) ? wire_nlOl0l_dataout : wire_nlOill_dataout;
	assign		wire_nlOiiO_dataout = (ni0Oii === 1'b1) ? wire_nlOiOO_dataout : wire_nlOilO_dataout;
	assign		wire_nlOili_dataout = (ni0Oii === 1'b1) ? wire_nlOl1i_dataout : wire_nlOiOi_dataout;
	assign		wire_nlOill_dataout = (ni0Oii === 1'b1) ? wire_nlOl1l_dataout : wire_nlOiOl_dataout;
	and(wire_nlOilO_dataout, ni0O1i, ~(ni0O0i));
	or(wire_nlOiOi_dataout, ni0O1i, ni0O0i);
	and(wire_nlOiOl_dataout, (~ ni0O1i), ~(ni0O0i));
	and(wire_nlOiOO_dataout, ni0O1l, ~(ni0O0O));
	and(wire_nlOl_dataout, nl10O, niiOli);
	assign		wire_nlOl0i_dataout = (ni0Oii === 1'b1) ? wire_nlOlli_dataout : wire_nlOlii_dataout;
	assign		wire_nlOl0l_dataout = (ni0Oii === 1'b1) ? wire_nlOlll_dataout : wire_nlOlil_dataout;
	and(wire_nlOl0O_dataout, ni0O0i, ~(ni0O1O));
	or(wire_nlOl1i_dataout, ni0O1l, ni0O0O);
	and(wire_nlOl1l_dataout, (~ ni0O1l), ~(ni0O0O));
	assign		wire_nlOl1O_dataout = (ni0Oii === 1'b1) ? wire_nlOliO_dataout : wire_nlOl0O_dataout;
	or(wire_nlOlii_dataout, ni0O0i, ni0O1O);
	and(wire_nlOlil_dataout, (~ ni0O0i), ~(ni0O1O));
	and(wire_nlOliO_dataout, ni0O0O, ~(ni0O0l));
	or(wire_nlOlli_dataout, ni0O0O, ni0O0l);
	and(wire_nlOlll_dataout, (~ ni0O0O), ~(ni0O0l));
	and(wire_nlOllO_dataout, (~ ni0OiO), niiOOi);
	or(wire_nlOlOi_dataout, wire_nlOO1l_dataout, niiOOi);
	and(wire_nlOlOl_dataout, ni0Oii, ~(niiOOi));
	and(wire_nlOlOO_dataout, wire_nlOO1O_dataout, ~(niiOOi));
	and(wire_nlOO_dataout, nl1ii, niiOli);
	and(wire_nlOO0i_dataout, wire_nlOO0O_dataout, ~(ni0Oii));
	and(wire_nlOO0l_dataout, ni0Oil, ni0OiO);
	and(wire_nlOO0O_dataout, (~ ni0Oil), ni0OiO);
	and(wire_nlOO1i_dataout, wire_nlOO0i_dataout, ~(niiOOi));
	and(wire_nlOO1l_dataout, wire_nlOO0l_dataout, ~(ni0Oii));
	and(wire_nlOO1O_dataout, (~ ni0OiO), ~(ni0Oii));
	oper_add   n00Oi
	( 
	.a({n101i, n11OO, n11Ol, n11Oi, n11lO, n11ll, n11li, n11iO, n11il}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n00Oi_o));
	defparam
		n00Oi.sgate_representation = 0,
		n00Oi.width_a = 9,
		n00Oi.width_b = 9,
		n00Oi.width_o = 9;
	oper_add   n01iO
	( 
	.a({n11ii, n110O, n110l, n110i}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n01iO_o));
	defparam
		n01iO.sgate_representation = 0,
		n01iO.width_a = 4,
		n01iO.width_b = 4,
		n01iO.width_o = 4;
	oper_add   n1lOi
	( 
	.a({nlOOiO, nlOOil, nliliO}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1lOi_o));
	defparam
		n1lOi.sgate_representation = 0,
		n1lOi.width_a = 3,
		n1lOi.width_b = 3,
		n1lOi.width_o = 3;
	oper_add   n1Oll
	( 
	.a({nlOOOO, nlOOOl, nlOOOi, nlOOlO, nlOOll, nlOOli}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1Oll_o));
	defparam
		n1Oll.sgate_representation = 0,
		n1Oll.width_a = 6,
		n1Oll.width_b = 6,
		n1Oll.width_o = 6;
	oper_add   n1OOO
	( 
	.a({n111O, n111l, n111i}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1OOO_o));
	defparam
		n1OOO.sgate_representation = 0,
		n1OOO.width_a = 3,
		n1OOO.width_b = 3,
		n1OOO.width_o = 3;
	oper_add   nli0ll
	( 
	.a({nl00Ol, nl00Oi, nl00lO, nl00ll, nl00li, nl00iO, nl00il}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0ll_o));
	defparam
		nli0ll.sgate_representation = 0,
		nli0ll.width_a = 7,
		nli0ll.width_b = 7,
		nli0ll.width_o = 7;
	oper_add   nli0lO
	( 
	.a({nl0i0O, nl0i0l, nl0i0i, nl0i1O, nl0i1l, nl0i1i, nl00OO}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0lO_o));
	defparam
		nli0lO.sgate_representation = 0,
		nli0lO.width_a = 7,
		nli0lO.width_b = 7,
		nli0lO.width_o = 7;
	oper_add   nli0Oi
	( 
	.a({nl0iOl, nl0iOi, nl0ilO, nl0ill, nl0ili, nl0iiO, nl0iil, nl0iii}),
	.b({{7{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0Oi_o));
	defparam
		nli0Oi.sgate_representation = 0,
		nli0Oi.width_a = 8,
		nli0Oi.width_b = 8,
		nli0Oi.width_o = 8;
	oper_add   nliOl
	( 
	.a({((niilOO16 ^ niilOO15) & niO0O), niO0l, n0lOi}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nliOl_o));
	defparam
		nliOl.sgate_representation = 0,
		nliOl.width_a = 3,
		nliOl.width_b = 3,
		nliOl.width_o = 3;
	oper_add   nllli
	( 
	.a({niOll, niOli, niOiO, ((niiO1i14 ^ niiO1i13) & niOil), niOii}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllli_o));
	defparam
		nllli.sgate_representation = 0,
		nllli.width_a = 5,
		nllli.width_b = 5,
		nllli.width_o = 5;
	oper_selector   n0iii
	( 
	.data({1'b0, wire_niiOl_dataout, (~ niiill)}),
	.o(wire_n0iii_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0iii.width_data = 3,
		n0iii.width_sel = 3;
	oper_selector   n0iil
	( 
	.data({1'b0, wire_niiOO_dataout, niiill}),
	.o(wire_n0iil_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0iil.width_data = 3,
		n0iil.width_sel = 3;
	oper_selector   n0iiO
	( 
	.data({1'b0, wire_nilOi_dataout, wire_nii1O_dataout, {2{(~ niiiil)}}}),
	.o(wire_n0iiO_o),
	.sel({ni0OOO, nli0O, nl01l, nl01i, nl1OO}));
	defparam
		n0iiO.width_data = 5,
		n0iiO.width_sel = 5;
	oper_selector   n0ilO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_n0ilO_o),
	.sel({nii11i, (~ nii11i)}));
	defparam
		n0ilO.width_data = 2,
		n0ilO.width_sel = 2;
	oper_selector   n0iOl
	( 
	.data({1'b0, niiiil, (~ niiiil)}),
	.o(wire_n0iOl_o),
	.sel({nii11l, nl01i, nl1OO}));
	defparam
		n0iOl.width_data = 3,
		n0iOl.width_sel = 3;
	oper_selector   n0l1i
	( 
	.data({1'b0, wire_nii1l_dataout, (~ niiiil)}),
	.o(wire_n0l1i_o),
	.sel({nii11O, nl01l, nl01i}));
	defparam
		n0l1i.width_data = 3,
		n0l1i.width_sel = 3;
	oper_selector   n0l1O
	( 
	.data({1'b0, niiOOi, 1'b1, wire_nii1O_dataout}),
	.o(wire_n0l1O_o),
	.sel({nii10i, nl0ii, (((nl00O | nl00l) | nl00i) | nl01O), nl01l}));
	defparam
		n0l1O.width_data = 4,
		n0l1O.width_sel = 4;
	oper_selector   n0lii
	( 
	.data({1'b0, wire_niili_dataout, wire_nil1i_dataout}),
	.o(wire_n0lii_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lii.width_data = 3,
		n0lii.width_sel = 3;
	oper_selector   n0lil
	( 
	.data({1'b0, wire_niill_dataout, wire_nil1l_dataout}),
	.o(wire_n0lil_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lil.width_data = 3,
		n0lil.width_sel = 3;
	oper_selector   n0liO
	( 
	.data({1'b0, wire_niilO_dataout, wire_nil1O_dataout}),
	.o(wire_n0liO_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0liO.width_data = 3,
		n0liO.width_sel = 3;
	oper_selector   n0lli
	( 
	.data({1'b0, wire_niiOi_dataout, wire_nil0i_dataout}),
	.o(wire_n0lli_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lli.width_data = 3,
		n0lli.width_sel = 3;
	oper_selector   n0lOl
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0lOl_o),
	.sel({nii10O, nl0ll, nl0li}));
	defparam
		n0lOl.width_data = 3,
		n0lOl.width_sel = 3;
	oper_selector   n0O0l
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0O0l_o),
	.sel({nii1il, nl0OO, nl0Ol}));
	defparam
		n0O0l.width_data = 3,
		n0O0l.width_sel = 3;
	oper_selector   n0O1l
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0O1l_o),
	.sel({nii1ii, nl0Oi, nl0lO}));
	defparam
		n0O1l.width_data = 3,
		n0O1l.width_sel = 3;
	oper_selector   n0Oil
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0Oil_o),
	.sel({nii1iO, nli1l, nli1i}));
	defparam
		n0Oil.width_data = 3,
		n0Oil.width_sel = 3;
	oper_selector   n0Oll
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0Oll_o),
	.sel({nii1li, nli0i, nli1O}));
	defparam
		n0Oll.width_data = 3,
		n0Oll.width_sel = 3;
	oper_selector   n0OOl
	( 
	.data({1'b0, niiOOi, wire_nilll_dataout, 1'b1, wire_niiOl_dataout, (~ niiill)}),
	.o(wire_n0OOl_o),
	.sel({nii1ll, nliil, nli0O, nli0l, nl0iO, nl0il}));
	defparam
		n0OOl.width_data = 6,
		n0OOl.width_sel = 6;
	oper_selector   ni00l
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni00l_o),
	.sel({nii00l, (~ nii00l)}));
	defparam
		ni00l.width_data = 2,
		ni00l.width_sel = 2;
	oper_selector   ni01i
	( 
	.data({1'b0, ((nii1OO44 ^ nii1OO43) & niiOOi)}),
	.o(wire_ni01i_o),
	.sel({nii01i, (~ nii01i)}));
	defparam
		ni01i.width_data = 2,
		ni01i.width_sel = 2;
	oper_selector   ni01O
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni01O_o),
	.sel({nii01l, (~ nii01l)}));
	defparam
		ni01O.width_data = 2,
		ni01O.width_sel = 2;
	oper_selector   ni0ii
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0ii_o),
	.sel({nii0ii, ((nii00O40 ^ nii00O39) & (~ nii0ii))}));
	defparam
		ni0ii.width_data = 2,
		ni0ii.width_sel = 2;
	oper_selector   ni0iO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0iO_o),
	.sel({((nii0li36 ^ nii0li35) & nii0ll), (~ nii0ll)}));
	defparam
		ni0iO.width_data = 2,
		ni0iO.width_sel = 2;
	oper_selector   ni0ll
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0ll_o),
	.sel({nii0Ol, (~ nii0Ol)}));
	defparam
		ni0ll.width_data = 2,
		ni0ll.width_sel = 2;
	oper_selector   ni0Oi
	( 
	.data({1'b0, ((nii0OO32 ^ nii0OO31) & wire_nilli_dataout), ((niii1i30 ^ niii1i29) & niiOOi), {7{niiOOi}}}),
	.o(wire_ni0Oi_o),
	.sel({((niii1l28 ^ niii1l27) & niii0l), nli0O, nli0i, nl0OO, nl0ll, nl0ii, nl00O, ((niii1O26 ^ niii1O25) & nl00l), ((niii0i24 ^ niii0i23) & nl00i), nl01l}));
	defparam
		ni0Oi.width_data = 10,
		ni0Oi.width_sel = 10;
	oper_selector   ni10i
	( 
	.data({niiilO, 1'b0, wire_nii0l_dataout, wire_nii1i_dataout}),
	.o(wire_ni10i_o),
	.sel({nlili, nii1Oi, nl01l, nl1OO}));
	defparam
		ni10i.width_data = 4,
		ni10i.width_sel = 4;
	oper_selector   ni11l
	( 
	.data({(~ niiilO), (~ niiOOi), wire_nilOi_dataout, 1'b0, wire_nii0i_dataout, wire_ni0OO_dataout}),
	.o(wire_ni11l_o),
	.sel({nlili, nliil, nli0O, nii1lO, nl01l, nl1OO}));
	defparam
		ni11l.width_data = 6,
		ni11l.width_sel = 6;
	oper_selector   ni1Ol
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni1Ol_o),
	.sel({nii1Ol, (~ nii1Ol)}));
	defparam
		ni1Ol.width_data = 2,
		ni1Ol.width_sel = 2;
	oper_selector   nil00l
	( 
	.data({1'b0, 1'b1, wire_niO00O_dataout}),
	.o(wire_nil00l_o),
	.sel({(nli11O | nl0O0l), ni1lOO, nl0OOi}));
	defparam
		nil00l.width_data = 3,
		nil00l.width_sel = 3;
	oper_selector   nil01O
	( 
	.data({1'b0, 1'b1, niiOOi, wire_niO00l_dataout}),
	.o(wire_nil01O_o),
	.sel({nli11O, ni1lOl, nl0OOl, nl0OOi}));
	defparam
		nil01O.width_data = 4,
		nil01O.width_sel = 4;
	oper_selector   nil0il
	( 
	.data({1'b0, 1'b1, wire_niO0ii_dataout}),
	.o(wire_nil0il_o),
	.sel({nli11O, ni1O1i, nl0OOi}));
	defparam
		nil0il.width_data = 3,
		nil0il.width_sel = 3;
	oper_selector   nil0li
	( 
	.data({1'b0, 1'b1, wire_niO0il_dataout}),
	.o(wire_nil0li_o),
	.sel({ni1O1O, ni1O1l, nl0OOi}));
	defparam
		nil0li.width_data = 3,
		nil0li.width_sel = 3;
	oper_selector   nil0Oi
	( 
	.data({1'b0, (~ niiOOi), wire_niO0iO_dataout, 1'b1}),
	.o(wire_nil0Oi_o),
	.sel({ni1O0l, nl0OOl, nl0OOi, ni1O0i}));
	defparam
		nil0Oi.width_data = 4,
		nil0Oi.width_sel = 4;
	oper_selector   nil1li
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nil1li_o),
	.sel({ni1lll, (~ ni1lll)}));
	defparam
		nil1li.width_data = 2,
		nil1li.width_sel = 2;
	oper_selector   nil1lO
	( 
	.data({1'b0, (~ niiOOi), wire_niO01O_dataout, 1'b1}),
	.o(wire_nil1lO_o),
	.sel({ni1llO, nl0OOl, nl0OOi, (nl0O0l | nl0O1O)}));
	defparam
		nil1lO.width_data = 4,
		nil1lO.width_sel = 4;
	oper_selector   nil1OO
	( 
	.data({1'b0, (~ niiOOi), wire_niO00i_dataout, 1'b1}),
	.o(wire_nil1OO_o),
	.sel({ni1lOi, nl0OOl, nl0OOi, (nl0O0l | nl0O0i)}));
	defparam
		nil1OO.width_data = 4,
		nil1OO.width_sel = 4;
	oper_selector   nili0i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nili0i_o),
	.sel({ni1Oil, (~ ni1Oil)}));
	defparam
		nili0i.width_data = 2,
		nili0i.width_sel = 2;
	oper_selector   nili0O
	( 
	.data({1'b0, niiOOi, wire_niO0ll_dataout, niiOOi}),
	.o(wire_nili0O_o),
	.sel({ni1OiO, nl0OOl, nl0OOi, nl0O0O}));
	defparam
		nili0O.width_data = 4,
		nili0O.width_sel = 4;
	oper_selector   nili1i
	( 
	.data({1'b0, 1'b1, wire_niO0li_dataout}),
	.o(wire_nili1i_o),
	.sel({ni1Oii, ni1O0O, nl0OOi}));
	defparam
		nili1i.width_data = 3,
		nili1i.width_sel = 3;
	oper_selector   niliil
	( 
	.data({1'b0, niiOOi, wire_niO0lO_dataout, {5{niiOOi}}}),
	.o(wire_niliil_o),
	.sel({ni1Oli, nli11i, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		niliil.width_data = 8,
		niliil.width_sel = 8;
	oper_selector   nilili
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0Oi_dataout, {4{niiOOi}}}),
	.o(wire_nilili_o),
	.sel({ni1Oll, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0i}));
	defparam
		nilili.width_data = 8,
		nilili.width_sel = 8;
	oper_selector   nililO
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0Ol_dataout, {5{niiOOi}}}),
	.o(wire_nililO_o),
	.sel({ni1OlO, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nililO.width_data = 9,
		nililO.width_sel = 9;
	oper_selector   niliOl
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0OO_dataout, {4{niiOOi}}}),
	.o(wire_niliOl_o),
	.sel({ni1OOi, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0O0O, nl0O0i}));
	defparam
		niliOl.width_data = 8,
		niliOl.width_sel = 8;
	oper_selector   nill0O
	( 
	.data({wire_nl01iO_dataout, wire_nl11Ol_dataout, 1'b0, wire_niO10i_dataout, wire_niO11O_dataout}),
	.o(wire_nill0O_o),
	.sel({nli11O, nli11i, ni011i, nl0OOi, nl0O0i}));
	defparam
		nill0O.width_data = 5,
		nill0O.width_sel = 5;
	oper_selector   nill1i
	( 
	.data({1'b0, niiOOi, wire_niOi1i_dataout, {4{niiOOi}}}),
	.o(wire_nill1i_o),
	.sel({ni1OOl, nl0OOl, nl0OOi, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nill1i.width_data = 7,
		nill1i.width_sel = 7;
	oper_selector   nill1O
	( 
	.data({1'b0, {2{niiOOi}}, wire_niOi1l_dataout, {3{niiOOi}}}),
	.o(wire_nill1O_o),
	.sel({ni1OOO, nli11i, nl0OOl, nl0OOi, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nill1O.width_data = 7,
		nill1O.width_sel = 7;
	oper_selector   nillil
	( 
	.data({wire_nl01li_dataout, wire_nl11OO_dataout, 1'b0, wire_niO10l_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nillil_o),
	.sel({nli11O, nli11i, ni011l, nl0OOi, nl0O0O, nl0O0l}));
	defparam
		nillil.width_data = 6,
		nillil.width_sel = 6;
	oper_selector   nillli
	( 
	.data({wire_nl01ll_dataout, wire_nl101i_dataout, 1'b0, wire_niO10O_dataout, wire_niO11O_dataout}),
	.o(wire_nillli_o),
	.sel({nli11O, nli11i, ni011O, nl0OOi, nl0O0O}));
	defparam
		nillli.width_data = 5,
		nillli.width_sel = 5;
	oper_selector   nilllO
	( 
	.data({wire_nl01lO_dataout, wire_nl101l_dataout, 1'b0, wire_niO1ii_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilllO_o),
	.sel({nli11O, nli11i, ni010i, nl0OOi, nl0Oil, nl0Oii}));
	defparam
		nilllO.width_data = 6,
		nilllO.width_sel = 6;
	oper_selector   nillOl
	( 
	.data({wire_nl01Oi_dataout, wire_nl101O_dataout, 1'b0, wire_niO1il_dataout, wire_niO11O_dataout}),
	.o(wire_nillOl_o),
	.sel({nli11O, nli11i, ni010l, nl0OOi, nl0Oil}));
	defparam
		nillOl.width_data = 5,
		nillOl.width_sel = 5;
	oper_selector   nilO0l
	( 
	.data({wire_nl001i_dataout, wire_nl100O_dataout, 1'b0, wire_niO1ll_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilO0l_o),
	.sel({nli11O, nli11i, ni01il, nl0OOi, nl0OlO, nl0Oll}));
	defparam
		nilO0l.width_data = 6,
		nilO0l.width_sel = 6;
	oper_selector   nilO1i
	( 
	.data({wire_nl01Ol_dataout, wire_nl100i_dataout, 1'b0, wire_niO1iO_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilO1i_o),
	.sel({nli11O, nli11i, ni010O, nl0OOi, nl0Oli, nl0OiO}));
	defparam
		nilO1i.width_data = 6,
		nilO1i.width_sel = 6;
	oper_selector   nilO1O
	( 
	.data({wire_nl01OO_dataout, wire_nl100l_dataout, 1'b0, wire_niO1li_dataout, wire_niO11O_dataout}),
	.o(wire_nilO1O_o),
	.sel({nli11O, nli11i, ni01ii, nl0OOi, nl0Oli}));
	defparam
		nilO1O.width_data = 5,
		nilO1O.width_sel = 5;
	oper_selector   nilOii
	( 
	.data({wire_nl001l_dataout, wire_nl10ii_dataout, 1'b0, wire_niO1lO_dataout, wire_niO11O_dataout}),
	.o(wire_nilOii_o),
	.sel({nli11O, nli11i, ni01iO, nl0OOi, nl0OlO}));
	defparam
		nilOii.width_data = 5,
		nilOii.width_sel = 5;
	oper_selector   nilOiO
	( 
	.data({wire_nl001O_dataout, wire_nl10il_dataout, 1'b0, wire_niO1Oi_dataout}),
	.o(wire_nilOiO_o),
	.sel({nli11O, nli11i, ni01ll, nl0OOi}));
	defparam
		nilOiO.width_data = 4,
		nilOiO.width_sel = 4;
	oper_selector   nilOli
	( 
	.data({wire_nl000i_dataout, wire_nl10iO_dataout, wire_nlO_dataout, wire_niO1Ol_dataout, 1'b0}),
	.o(wire_nilOli_o),
	.sel({nli11O, nli11i, nl0OOl, nl0OOi, ni01li}));
	defparam
		nilOli.width_data = 5,
		nilOli.width_sel = 5;
	oper_selector   nilOlO
	( 
	.data({wire_nl000l_dataout, wire_nl10li_dataout, 1'b0, wire_niO1OO_dataout}),
	.o(wire_nilOlO_o),
	.sel({nli11O, nli11i, ni01ll, nl0OOi}));
	defparam
		nilOlO.width_data = 4,
		nilOlO.width_sel = 4;
	oper_selector   nilOOl
	( 
	.data({wire_nl000O_dataout, wire_nl10ll_dataout, 1'b0, wire_niO01i_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilOOl_o),
	.sel({nli11O, nli11i, ni01lO, nl0OOi, nl0O0i, nl0O1O}));
	defparam
		nilOOl.width_data = 6,
		nilOOl.width_sel = 6;
	oper_selector   niO11i
	( 
	.data({wire_nl00ii_dataout, wire_nl10lO_dataout, (~ wire_nlO_dataout), wire_niO01l_dataout, {10{(~ wire_nlO_dataout)}}}),
	.o(wire_niO11i_o),
	.sel({nli11O, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oll, nl0Oli, nl0OiO, nl0Oil, nl0Oii, nl0O0O, nl0O0l, nl0O0i, nl0O1O}));
	defparam
		niO11i.width_data = 14,
		niO11i.width_sel = 14;
	oper_selector   nlilOi
	( 
	.data({1'b0, wire_nlOO1i_dataout, wire_nlllll_dataout, {2{(~ ni0l0l)}}}),
	.o(wire_nlilOi_o),
	.sel({ni000i, n1l0l, n1iii, n1i0O, n1i0l}));
	defparam
		nlilOi.width_data = 5,
		nlilOi.width_sel = 5;
	oper_selector   nliO0l
	( 
	.data({1'b0, wire_nlllli_dataout, (~ ni0l0l)}),
	.o(wire_nliO0l_o),
	.sel({ni00ii, n1iii, n1i0O}));
	defparam
		nliO0l.width_data = 3,
		nliO0l.width_sel = 3;
	oper_selector   nliO1i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nliO1i_o),
	.sel({ni000l, (~ ni000l)}));
	defparam
		nliO1i.width_data = 2,
		nliO1i.width_sel = 2;
	oper_selector   nliO1O
	( 
	.data({1'b0, ni0l0l, (~ ni0l0l)}),
	.o(wire_nliO1O_o),
	.sel({ni000O, n1i0O, n1i0l}));
	defparam
		nliO1O.width_data = 3,
		nliO1O.width_sel = 3;
	oper_selector   nliOii
	( 
	.data({1'b0, niiOOi, 1'b1, wire_nlllll_dataout}),
	.o(wire_nliOii_o),
	.sel({ni00il, n1ilO, (((n1ill | n1ili) | n1iiO) | n1iil), n1iii}));
	defparam
		nliOii.width_data = 4,
		nliOii.width_sel = 4;
	oper_selector   nliOli
	( 
	.data({1'b0, wire_nlO1ii_dataout, wire_nllO0l_dataout}),
	.o(wire_nliOli_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOli.width_data = 3,
		nliOli.width_sel = 3;
	oper_selector   nliOlO
	( 
	.data({1'b0, wire_nlO1il_dataout, wire_nllO0O_dataout}),
	.o(wire_nliOlO_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOlO.width_data = 3,
		nliOlO.width_sel = 3;
	oper_selector   nliOOi
	( 
	.data({1'b0, wire_nlO1iO_dataout, wire_nllOii_dataout}),
	.o(wire_nliOOi_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOOi.width_data = 3,
		nliOOi.width_sel = 3;
	oper_selector   nliOOl
	( 
	.data({1'b0, wire_nlO1li_dataout, wire_nllOil_dataout}),
	.o(wire_nliOOl_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOOl.width_data = 3,
		nliOOl.width_sel = 3;
	oper_selector   nll00O
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll00O_o),
	.sel({ni0i0l, ni0i0i, n1iOi}));
	defparam
		nll00O.width_data = 3,
		nll00O.width_sel = 3;
	oper_selector   nll01i
	( 
	.data({ni0Oii, 1'b0, wire_nlllOi_dataout, wire_nllliO_dataout}),
	.o(wire_nll01i_o),
	.sel({n1liO, ni0i1i, n1iii, n1i0l}));
	defparam
		nll01i.width_data = 4,
		nll01i.width_sel = 4;
	oper_selector   nll01O
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll01O_o),
	.sel({ni0i1O, ni0i1l, n1iOi}));
	defparam
		nll01O.width_data = 3,
		nll01O.width_sel = 3;
	oper_selector   nll0iO
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nll0iO_o),
	.sel({ni0iii, ni0i0O, n1iOi}));
	defparam
		nll0iO.width_data = 3,
		nll0iO.width_sel = 3;
	oper_selector   nll0lO
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll0lO_o),
	.sel({ni0iiO, ni0iil, n1iOi}));
	defparam
		nll0lO.width_data = 3,
		nll0lO.width_sel = 3;
	oper_selector   nll0OO
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nll0OO_o),
	.sel({(((n1liO | n1l1O) | n1iOO) | n1iil), ni0ili, n1iOi}));
	defparam
		nll0OO.width_data = 3,
		nll0OO.width_sel = 3;
	oper_selector   nll10i
	( 
	.data({1'b0, wire_nlO1lO_dataout, wire_nllOiO_dataout, wire_nllO0i_dataout}),
	.o(wire_nll10i_o),
	.sel({ni00ll, n1l1i, n1iOO, n1iOl}));
	defparam
		nll10i.width_data = 4,
		nll10i.width_sel = 4;
	oper_selector   nll10O
	( 
	.data({1'b0, wire_nlOiii_dataout, wire_nlO1Oi_dataout, (~ niiOOi)}),
	.o(wire_nll10O_o),
	.sel({ni00lO, n1l1l, n1l1i, n1iOO}));
	defparam
		nll10O.width_data = 4,
		nll10O.width_sel = 4;
	oper_selector   nll11l
	( 
	.data({1'b0, 1'b1, wire_nllO1O_dataout}),
	.o(wire_nll11l_o),
	.sel({ni00li, n1iOi, n1iOl}));
	defparam
		nll11l.width_data = 3,
		nll11l.width_sel = 3;
	oper_selector   nll1il
	( 
	.data({1'b0, wire_nlOlOi_dataout, 1'b1, wire_nlOiil_dataout, wire_nlO1Ol_dataout, wire_nllOli_dataout}),
	.o(wire_nll1il_o),
	.sel({ni00Oi, n1l0l, (n1l0i | n1l1O), n1l1l, n1l1i, n1iOO}));
	defparam
		nll1il.width_data = 6,
		nll1il.width_sel = 6;
	oper_selector   nll1ll
	( 
	.data({1'b0, niiOOi, wire_nlOlOl_dataout}),
	.o(wire_nll1ll_o),
	.sel({ni00Ol, n1lii, n1l0l}));
	defparam
		nll1ll.width_data = 3,
		nll1ll.width_sel = 3;
	oper_selector   nll1Ol
	( 
	.data({(~ ni0Oii), (~ niiOOi), wire_nlOO1i_dataout, 1'b0, wire_nllllO_dataout, wire_nlllil_dataout}),
	.o(wire_nll1Ol_o),
	.sel({n1liO, n1lii, n1l0l, ni00OO, n1iii, n1i0l}));
	defparam
		nll1Ol.width_data = 6,
		nll1Ol.width_sel = 6;
	oper_selector   nlli0i
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nlli0i_o),
	.sel({ni0ilO, ni0ill, n1iOi}));
	defparam
		nlli0i.width_data = 3,
		nlli0i.width_sel = 3;
	oper_selector   nlliil
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliil_o),
	.sel({ni0iOi, (~ ni0iOi)}));
	defparam
		nlliil.width_data = 2,
		nlliil.width_sel = 2;
	oper_selector   nllili
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nllili_o),
	.sel({ni0iOl, (~ ni0iOl)}));
	defparam
		nllili.width_data = 2,
		nllili.width_sel = 2;
	oper_selector   nllilO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nllilO_o),
	.sel({ni0l1i, (~ ni0l1i)}));
	defparam
		nllilO.width_data = 2,
		nllilO.width_sel = 2;
	oper_selector   nlliOi
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliOi_o),
	.sel({ni0iOO, (~ ni0iOO)}));
	defparam
		nlliOi.width_data = 2,
		nlliOi.width_sel = 2;
	oper_selector   nlliOO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliOO_o),
	.sel({ni0l1i, (~ ni0l1i)}));
	defparam
		nlliOO.width_data = 2,
		nlliOO.width_sel = 2;
	oper_selector   nlll0i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlll0i_o),
	.sel({ni0l1O, (~ ni0l1O)}));
	defparam
		nlll0i.width_data = 2,
		nlll0i.width_sel = 2;
	oper_selector   nlll0O
	( 
	.data({1'b0, wire_nlOllO_dataout, {9{niiOOi}}}),
	.o(wire_nlll0O_o),
	.sel({ni0l0i, n1l0l, n1l1i, n1iOO, n1iOi, n1iOl, n1ilO, n1ill, n1ili, n1iil, n1iii}));
	defparam
		nlll0O.width_data = 11,
		nlll0O.width_sel = 11;
	oper_selector   nlll1l
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlll1l_o),
	.sel({ni0l1l, (~ ni0l1l)}));
	defparam
		nlll1l.width_data = 2,
		nlll1l.width_sel = 2;
	assign
		bist_ctl_sg = {wire_ni1O_dataout, wire_ni1l_dataout},
		bist_data_sg = {wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout},
		ni000i = (((((((((((((n1liO | n1lii) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil),
		ni000l = ((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1iiO) | n1i0O) | n1i0l),
		ni000O = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii),
		ni001i = ((((((((~ nl0iOl) & (~ nl0iOi)) & (~ nl0ilO)) & (~ nl0ill)) & (~ nl0ili)) & nl0iiO) & nl0iil) & nl0iii),
		ni001O = (nli11i | nl0OOi),
		ni00ii = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0l),
		ni00il = (((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1i0O) | n1i0l),
		ni00iO = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00li = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00ll = ((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00lO = ((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00Oi = (((((((((((n1liO | n1lii) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00Ol = (((((((((((((((n1liO | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00OO = ((((((((((((n1l0i | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0O),
		ni010i = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni010l = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni010O = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni011i = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O1O),
		ni011l = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0i) | nl0O1O),
		ni011O = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01ii = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01il = ((((((((nl0OOl | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01iO = (((((((((nl0OOl | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01li = (((((((((nl0OlO | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01ll = ((((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01lO = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l),
		ni01Oi = (((((((nl0iOl & nl0iOi) & nl0ilO) & nl0ill) & nl0ili) & nl0iiO) & nl0iil) & nl0iii),
		ni01Ol = ((((((nl00Ol & nl00Oi) & nl00lO) & nl00ll) & nl00li) & nl00iO) & nl00il),
		ni01OO = ((((((((~ nl0iOl) & (~ nl0iOi)) & (~ nl0ilO)) & nl0ill) & (~ nl0ili)) & (~ nl0iiO)) & (~ nl0iil)) & (~ nl0iii)),
		ni0i0i = ((((((n1lii | n1l1O) | n1l1l) | n1iOO) | n1ill) | n1ili) | n1iil),
		ni0i0l = (((((((((n1liO | n1l0l) | n1l0i) | n1l1i) | n1iOl) | n1ilO) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0i0O = (((((((((((n1l0l | n1l0i) | n1l1l) | n1l1i) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0i1i = ((((((((((((((n1lii | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0O),
		ni0i1l = (((((((((n1lii | n1l0l) | n1l0i) | n1l1O) | n1iOO) | n1iOl) | n1ilO) | n1ill) | n1iiO) | n1iil),
		ni0i1O = ((((((n1liO | n1l1l) | n1l1i) | n1ili) | n1iii) | n1i0O) | n1i0l),
		ni0iii = ((((n1liO | n1lii) | n1l1O) | n1iOO) | n1iil),
		ni0iil = (((((((((((n1lii | n1l1O) | n1l1l) | n1iOO) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iiO = ((((n1liO | n1l0l) | n1l0i) | n1l1i) | n1iOl),
		ni0ili = ((((((((((((n1lii | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0ill = (((((((n1lii | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOO) | n1iiO) | n1i0O),
		ni0ilO = ((((((((n1liO | n1l1O) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iil) | n1iii) | n1i0l),
		ni0iOi = (((((((((((n1liO | n1l0i) | n1l1O) | n1l1l) | n1iOO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iOl = (((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iOO) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iOO = ((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iOO) | n1iOl) | n1iiO) | n1i0O) | n1i0l),
		ni0l0i = (((((((n1liO | n1lii) | n1l0i) | n1l1O) | n1l1l) | n1iiO) | n1i0O) | n1i0l),
		ni0l0l = ((nlOOiO & (~ nlOOil)) & nliliO),
		ni0l0O = ((nlOOiO & nlOOil) & (~ nliliO)),
		ni0l1i = ((((((n1liO | n1l0i) | n1l1i) | n1iOi) | n1iiO) | n1i0O) | n1i0l),
		ni0l1l = ((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iiO) | n1i0O) | n1i0l),
		ni0l1O = ((((((((((n1liO | n1l0i) | n1iOl) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0lii = (((~ nlOOiO) & nlOOil) & (~ nliliO)),
		ni0lil = ((((((~ nlOOOO) & nlOOOl) & (~ nlOOOi)) & (~ nlOOlO)) & nlOOll) & nlOOli),
		ni0liO = (((((nlOOOO & (~ nlOOOl)) & (~ nlOOOi)) & nlOOlO) & nlOOll) & nlOOli),
		ni0lli = (((~ n111O) & n111l) & n111i),
		ni0lll = ((n111O & n111l) & n111i),
		ni0llO = ((((~ n11ii) & (~ n110O)) & n110l) & (~ n110i)),
		ni0lOi = ((((~ n11ii) & n110O) & n110l) & n110i),
		ni0lOl = (((n11ii & n110O) & n110l) & n110i),
		ni0lOO = (((((~ n11ii) & (~ n110O)) & n110l) & n110i) | (((n11ii & (~ n110O)) & n110l) & n110i)),
		ni0O0i = (((((((((~ n101i) & n11OO) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & n11iO) & n11il),
		ni0O0l = (((((((((~ n101i) & (~ n11OO)) & n11Ol) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & (~ n11iO)) & (~ n11il)),
		ni0O0O = (((((((((~ n101i) & n11OO) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & n11iO) & (~ n11il)),
		ni0O1i = ((((((((n101i & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & n11li) & n11iO) & n11il),
		ni0O1l = ((((((((n101i & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & n11li) & n11iO) & (~ n11il)),
		ni0O1O = (((((((((~ n101i) & (~ n11OO)) & n11Ol) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & (~ n11iO)) & n11il),
		ni0Oii = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		ni0Oil = (((~ nlOOiO) & (~ nlOOil)) & nliliO),
		ni0OiO = (ni0Oll | ni0Oli),
		ni0Oli = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		ni0Oll = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		ni0OlO = ((((n1lii | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0OOi = ((((((n1liO | n1l0l) | n1l0i) | n1l1O) | n1ill) | n1ili) | n1i0l),
		ni0OOl = ((((((n1liO | n1l0l) | n1l1O) | n1l1l) | n1ili) | n1i0O) | n1i0l),
		ni0OOO = (((((((((((((((((((nlili | nliil) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O),
		ni1lll = ((((((nli11O | nl0OOi) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1llO = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0i),
		ni1lOi = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O1O),
		ni1lOl = ((((((((((nli11i | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1lOO = ((((((((((nli11i | nl0OOl) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0i) | nl0O1O),
		ni1O0i = ((((((nl0Oli | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O0l = ((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oil),
		ni1O0O = (((((((nli11i | nl0OOl) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1i = (((((((((((nli11i | nl0OOl) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1l = (((((((nli11i | nl0OOl) | nl0Oll) | nl0OiO) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1O = ((((nli11O | nl0OlO) | nl0Oli) | nl0Oil) | nl0Oii),
		ni1Oii = ((((nli11O | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO),
		ni1Oil = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OiO = ((((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1Oli = ((((((nli11O | nl0OOl) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1Oll = ((((((nli11O | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O1O),
		ni1OlO = (((((nli11O | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOi = ((((((nli11O | nl0Oll) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOl = (((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOO = (((((((nli11O | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		nii00l = (((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl01O) | nl01i) | nl1OO),
		nii01i = (((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii01l = (((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii01O42 ^ nii01O41))),
		nii0ii = (((((((((((((nlili | nli0l) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0lO) | nl0li) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii0il38 ^ nii0il37))),
		nii0ll = ((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii0lO34 ^ nii0lO33))),
		nii0Ol = ((((((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii10i = (((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01i) | nl1OO),
		nii10l = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii10O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii11i = ((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO),
		nii11l = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l),
		nii11O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl1OO),
		nii1ii = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1il = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1iO = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1li = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1ll = ((((((((((((((((((nlili | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1lO = ((((((((((((((((((nli0l | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01i),
		nii1Oi = ((((((((((((((((((((nliil | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01i),
		nii1Ol = (((((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		niii0l = (((((((((((((((nlili | nliil) | nli0l) | nli1O) | nli1l) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (niii0O22 ^ niii0O21))),
		niiiil = ((niO0O & (~ niO0l)) & n0lOi),
		niiiiO = ((niO0O & niO0l) & (~ n0lOi)),
		niiili = (((~ niO0O) & niO0l) & (~ n0lOi)),
		niiill = ((((niOll & niOli) & niOiO) & niOil) & (~ niOii)),
		niiilO = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		niiiOi = (((~ niO0O) & (~ niO0l)) & n0lOi),
		niiiOl = (niil1i | niiiOO),
		niiiOO = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		niil0i = (((((((((nliil | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0ll) | nl0li),
		niil0l = (((((((((nlili | nliil) | nli1l) | nl0OO) | nl0Oi) | nl0li) | nl0il) | nl0ii) | nl00O) | nl00i),
		niil0O = (((((((((nlili | nli0O) | nli0l) | nli1O) | nli1l) | nli1i) | nl0Oi) | nl0lO) | nl0iO) | nl00l),
		niil1i = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		niil1l = ((((nliil | nl01O) | nl01l) | nl01i) | nl1OO),
		niil1O = (((((((nlili | nli0i) | nl0lO) | nl0ll) | nl0ii) | nl01l) | nl01i) | nl1OO),
		niilii = (((((nlili | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl00l),
		niilil = (((((((((((nlili | nli0O) | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0lO) | nl0ll) | nl0il) | nl00l) | nl00i) | nl1OO),
		niiliO = (((((((((nlili | nli0i) | nli1l) | nl0Ol) | nl0Oi) | nl0lO) | nl0iO) | nl00l) | nl01l) | nl1OO),
		niilli = (((((((((nliil | nli0l) | nli0i) | nli1O) | nl0Ol) | nl0Oi) | nl0li) | nl0ii) | nl01O) | nl01l),
		niilll = 1'b1,
		niilOl = 1'b0,
		niiOil = (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (niiO0O8 ^ niiO0O7)),
		niiOiO = ((rbist_sel[0] & (~ rbist_sel[1])) & (niiO0i10 ^ niiO0i9)),
		niiOli = (((~ rbist_sel[0]) & rbist_sel[1]) & (niiO1l12 ^ niiO1l11)),
		niiOOi = ((((rpmadwidth_tx & (~ rpma_doublewidth_tx)) & (nil11i2 ^ nil11i1)) & rdwidth_tx) | ((rpmadwidth_tx & rpma_doublewidth_tx) & (niiOOl4 ^ niiOOl3)));
endmodule //cycloneiv_hssi_tx_digi_bist_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 106 mux21 189 oper_add 1 oper_decoder 1 oper_mux 23 oper_selector 23 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_tx_digi_prbs_gen
	( 
	cid_en,
	prbs_out,
	rcid_len,
	rcid_pattern,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	rprbs_en_tx,
	rprbs_sel,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	input   cid_en;
	output   [19:0]  prbs_out;
	input   [7:0]  rcid_len;
	input   rcid_pattern;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   rprbs_en_tx;
	input   [2:0]  rprbs_sel;
	input   soft_reset;
	input   tx_clk;

	reg	nll00l33;
	reg	nll00l34;
	reg	nll01i37;
	reg	nll01i38;
	reg	nll01O35;
	reg	nll01O36;
	reg	nll0ii31;
	reg	nll0ii32;
	reg	nll0iO29;
	reg	nll0iO30;
	reg	nll0Ol27;
	reg	nll0Ol28;
	reg	nll1ii45;
	reg	nll1ii46;
	reg	nll1li43;
	reg	nll1li44;
	reg	nll1lO41;
	reg	nll1lO42;
	reg	nll1Ol39;
	reg	nll1Ol40;
	reg	nlli0l23;
	reg	nlli0l24;
	reg	nlli1O25;
	reg	nlli1O26;
	reg	nlliil21;
	reg	nlliil22;
	reg	nlliiO19;
	reg	nlliiO20;
	reg	nllill17;
	reg	nllill18;
	reg	nlliOi15;
	reg	nlliOi16;
	reg	nlll0O11;
	reg	nlll0O12;
	reg	nlll1i13;
	reg	nlll1i14;
	reg	nlllil10;
	reg	nlllil9;
	reg	nllliO7;
	reg	nllliO8;
	reg	nlllli5;
	reg	nlllli6;
	reg	nlllll3;
	reg	nlllll4;
	reg	nlllOl1;
	reg	nlllOl2;
	reg	ni0O;
	reg	nlO0Ol;
	reg	nlO0OO;
	reg	nlOi0i;
	reg	nlOi0l;
	reg	nlOi0O;
	reg	nlOi1i;
	reg	nlOi1l;
	reg	nlOi1O;
	reg	nlOiii;
	reg	nlOiil;
	reg	nlOiiO;
	reg	nlOili;
	reg	nlOill;
	reg	nlOilO;
	reg	nlOiOi;
	reg	nlOiOl;
	reg	nlOiOO;
	reg	nlOl1i;
	reg	nlOl1l;
	reg	nlOl1O;
	reg	ni0l_clk_prev;
	wire	wire_ni0l_PRN;
	reg	n0i;
	reg	n1i;
	reg	n1l;
	reg	n1O;
	reg	nili;
	reg	nill;
	reg	nlll;
	reg	nllO;
	reg	nlOi;
	reg	nlOl;
	reg	nlOl0i;
	reg	nlOl0l;
	reg	nlOl0O;
	reg	nlOlii;
	reg	nlOlil;
	reg	nlOliO;
	reg	nlOlli;
	reg	nlOlll;
	reg	nlOllO;
	reg	nlOlOi;
	reg	nlOlOl;
	reg	nlOlOO;
	reg	nlOO;
	reg	nlOO0i;
	reg	nlOO0l;
	reg	nlOO0O;
	reg	nlOO1i;
	reg	nlOO1l;
	reg	nlOO1O;
	reg	nlOOii;
	reg	nlOOil;
	reg	nlOOiO;
	reg	nlOOli;
	reg	nlOOll;
	reg	nlOOlO;
	reg	nO;
	wire	wire_nl_CLRN;
	reg	nilO;
	reg	nlil;
	reg	nlli;
	wire	wire_nliO_PRN;
	wire	wire_n0l_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n100i_dataout;
	wire	wire_n100l_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n101i_dataout;
	wire	wire_n101l_dataout;
	wire	wire_n101O_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n110i_dataout;
	wire	wire_n110l_dataout;
	wire	wire_n110O_dataout;
	wire	wire_n111i_dataout;
	wire	wire_n111l_dataout;
	wire	wire_n111O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11ii_dataout;
	wire	wire_n11il_dataout;
	wire	wire_n11iO_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11li_dataout;
	wire	wire_n11ll_dataout;
	wire	wire_n11lO_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n11Oi_dataout;
	wire	wire_n11Ol_dataout;
	wire	wire_n11OO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nlOOOi_dataout;
	wire	wire_nlOOOl_dataout;
	wire	wire_nlOOOO_dataout;
	wire  [8:0]   wire_ni_o;
	wire  [31:0]   wire_n00ii_o;
	wire  wire_n00il_o;
	wire  wire_n00iO_o;
	wire  wire_n00li_o;
	wire  wire_n00ll_o;
	wire  wire_n00lO_o;
	wire  wire_n00Oi_o;
	wire  wire_n00Ol_o;
	wire  wire_n00OO_o;
	wire  wire_n0i0i_o;
	wire  wire_n0i0l_o;
	wire  wire_n0i0O_o;
	wire  wire_n0i1i_o;
	wire  wire_n0i1l_o;
	wire  wire_n0i1O_o;
	wire  wire_n0iii_o;
	wire  wire_n0iil_o;
	wire  wire_n0iiO_o;
	wire  wire_n0ili_o;
	wire  wire_n0ill_o;
	wire  wire_n0ilO_o;
	wire  wire_n0iOi_o;
	wire  wire_n0iOl_o;
	wire  wire_n0iOO_o;
	wire  wire_n000i_o;
	wire  wire_n001O_o;
	wire  wire_n010i_o;
	wire  wire_n010O_o;
	wire  wire_n011i_o;
	wire  wire_n011l_o;
	wire  wire_n011O_o;
	wire  wire_n01iO_o;
	wire  wire_n01ll_o;
	wire  wire_n01lO_o;
	wire  wire_n01Oi_o;
	wire  wire_n01Ol_o;
	wire  wire_n1O0O_o;
	wire  wire_n1Oii_o;
	wire  wire_n1Oil_o;
	wire  wire_n1OiO_o;
	wire  wire_n1Oli_o;
	wire  wire_n1Oll_o;
	wire  wire_n1OlO_o;
	wire  wire_n1OOi_o;
	wire  wire_niOO_o;
	wire  wire_nl1i_o;
	wire  wire_nl1l_o;
	wire  nliiOO;
	wire  nlil0i;
	wire  nlil0l;
	wire  nlil0O;
	wire  nlil1i;
	wire  nlil1l;
	wire  nlil1O;
	wire  nlilii;
	wire  nlilil;
	wire  nliliO;
	wire  nlilli;
	wire  nlilll;
	wire  nlillO;
	wire  nlilOi;
	wire  nlilOl;
	wire  nlilOO;
	wire  nliO0i;
	wire  nliO0l;
	wire  nliO0O;
	wire  nliO1i;
	wire  nliO1l;
	wire  nliO1O;
	wire  nliOii;
	wire  nliOil;
	wire  nliOiO;
	wire  nliOli;
	wire  nliOll;
	wire  nliOlO;
	wire  nliOOi;
	wire  nliOOl;
	wire  nliOOO;
	wire  nll0ll;
	wire  nll0lO;
	wire  nll0Oi;
	wire  nll10i;
	wire  nll10l;
	wire  nll10O;
	wire  nll11i;
	wire  nll11l;
	wire  nll11O;
	wire  nll1iO;
	wire  nlli0i;
	wire  nlli1i;
	wire  nlli1l;
	wire  nlliii;
	wire  nllili;
	wire  nllilO;
	wire  nlliOl;
	wire  nlliOO;
	wire  nlll0i;
	wire  nlll0l;
	wire  nlll1O;
	wire  nllllO;

	initial
		nll00l33 = 0;
	always @ ( posedge tx_clk)
		  nll00l33 <= nll00l34;
	event nll00l33_event;
	initial
		#1 ->nll00l33_event;
	always @(nll00l33_event)
		nll00l33 <= {1{1'b1}};
	initial
		nll00l34 = 0;
	always @ ( posedge tx_clk)
		  nll00l34 <= nll00l33;
	initial
		nll01i37 = 0;
	always @ ( posedge tx_clk)
		  nll01i37 <= nll01i38;
	event nll01i37_event;
	initial
		#1 ->nll01i37_event;
	always @(nll01i37_event)
		nll01i37 <= {1{1'b1}};
	initial
		nll01i38 = 0;
	always @ ( posedge tx_clk)
		  nll01i38 <= nll01i37;
	initial
		nll01O35 = 0;
	always @ ( posedge tx_clk)
		  nll01O35 <= nll01O36;
	event nll01O35_event;
	initial
		#1 ->nll01O35_event;
	always @(nll01O35_event)
		nll01O35 <= {1{1'b1}};
	initial
		nll01O36 = 0;
	always @ ( posedge tx_clk)
		  nll01O36 <= nll01O35;
	initial
		nll0ii31 = 0;
	always @ ( posedge tx_clk)
		  nll0ii31 <= nll0ii32;
	event nll0ii31_event;
	initial
		#1 ->nll0ii31_event;
	always @(nll0ii31_event)
		nll0ii31 <= {1{1'b1}};
	initial
		nll0ii32 = 0;
	always @ ( posedge tx_clk)
		  nll0ii32 <= nll0ii31;
	initial
		nll0iO29 = 0;
	always @ ( posedge tx_clk)
		  nll0iO29 <= nll0iO30;
	event nll0iO29_event;
	initial
		#1 ->nll0iO29_event;
	always @(nll0iO29_event)
		nll0iO29 <= {1{1'b1}};
	initial
		nll0iO30 = 0;
	always @ ( posedge tx_clk)
		  nll0iO30 <= nll0iO29;
	initial
		nll0Ol27 = 0;
	always @ ( posedge tx_clk)
		  nll0Ol27 <= nll0Ol28;
	event nll0Ol27_event;
	initial
		#1 ->nll0Ol27_event;
	always @(nll0Ol27_event)
		nll0Ol27 <= {1{1'b1}};
	initial
		nll0Ol28 = 0;
	always @ ( posedge tx_clk)
		  nll0Ol28 <= nll0Ol27;
	initial
		nll1ii45 = 0;
	always @ ( posedge tx_clk)
		  nll1ii45 <= nll1ii46;
	event nll1ii45_event;
	initial
		#1 ->nll1ii45_event;
	always @(nll1ii45_event)
		nll1ii45 <= {1{1'b1}};
	initial
		nll1ii46 = 0;
	always @ ( posedge tx_clk)
		  nll1ii46 <= nll1ii45;
	initial
		nll1li43 = 0;
	always @ ( posedge tx_clk)
		  nll1li43 <= nll1li44;
	event nll1li43_event;
	initial
		#1 ->nll1li43_event;
	always @(nll1li43_event)
		nll1li43 <= {1{1'b1}};
	initial
		nll1li44 = 0;
	always @ ( posedge tx_clk)
		  nll1li44 <= nll1li43;
	initial
		nll1lO41 = 0;
	always @ ( posedge tx_clk)
		  nll1lO41 <= nll1lO42;
	event nll1lO41_event;
	initial
		#1 ->nll1lO41_event;
	always @(nll1lO41_event)
		nll1lO41 <= {1{1'b1}};
	initial
		nll1lO42 = 0;
	always @ ( posedge tx_clk)
		  nll1lO42 <= nll1lO41;
	initial
		nll1Ol39 = 0;
	always @ ( posedge tx_clk)
		  nll1Ol39 <= nll1Ol40;
	event nll1Ol39_event;
	initial
		#1 ->nll1Ol39_event;
	always @(nll1Ol39_event)
		nll1Ol39 <= {1{1'b1}};
	initial
		nll1Ol40 = 0;
	always @ ( posedge tx_clk)
		  nll1Ol40 <= nll1Ol39;
	initial
		nlli0l23 = 0;
	always @ ( posedge tx_clk)
		  nlli0l23 <= nlli0l24;
	event nlli0l23_event;
	initial
		#1 ->nlli0l23_event;
	always @(nlli0l23_event)
		nlli0l23 <= {1{1'b1}};
	initial
		nlli0l24 = 0;
	always @ ( posedge tx_clk)
		  nlli0l24 <= nlli0l23;
	initial
		nlli1O25 = 0;
	always @ ( posedge tx_clk)
		  nlli1O25 <= nlli1O26;
	event nlli1O25_event;
	initial
		#1 ->nlli1O25_event;
	always @(nlli1O25_event)
		nlli1O25 <= {1{1'b1}};
	initial
		nlli1O26 = 0;
	always @ ( posedge tx_clk)
		  nlli1O26 <= nlli1O25;
	initial
		nlliil21 = 0;
	always @ ( posedge tx_clk)
		  nlliil21 <= nlliil22;
	event nlliil21_event;
	initial
		#1 ->nlliil21_event;
	always @(nlliil21_event)
		nlliil21 <= {1{1'b1}};
	initial
		nlliil22 = 0;
	always @ ( posedge tx_clk)
		  nlliil22 <= nlliil21;
	initial
		nlliiO19 = 0;
	always @ ( posedge tx_clk)
		  nlliiO19 <= nlliiO20;
	event nlliiO19_event;
	initial
		#1 ->nlliiO19_event;
	always @(nlliiO19_event)
		nlliiO19 <= {1{1'b1}};
	initial
		nlliiO20 = 0;
	always @ ( posedge tx_clk)
		  nlliiO20 <= nlliiO19;
	initial
		nllill17 = 0;
	always @ ( posedge tx_clk)
		  nllill17 <= nllill18;
	event nllill17_event;
	initial
		#1 ->nllill17_event;
	always @(nllill17_event)
		nllill17 <= {1{1'b1}};
	initial
		nllill18 = 0;
	always @ ( posedge tx_clk)
		  nllill18 <= nllill17;
	initial
		nlliOi15 = 0;
	always @ ( posedge tx_clk)
		  nlliOi15 <= nlliOi16;
	event nlliOi15_event;
	initial
		#1 ->nlliOi15_event;
	always @(nlliOi15_event)
		nlliOi15 <= {1{1'b1}};
	initial
		nlliOi16 = 0;
	always @ ( posedge tx_clk)
		  nlliOi16 <= nlliOi15;
	initial
		nlll0O11 = 0;
	always @ ( posedge tx_clk)
		  nlll0O11 <= nlll0O12;
	event nlll0O11_event;
	initial
		#1 ->nlll0O11_event;
	always @(nlll0O11_event)
		nlll0O11 <= {1{1'b1}};
	initial
		nlll0O12 = 0;
	always @ ( posedge tx_clk)
		  nlll0O12 <= nlll0O11;
	initial
		nlll1i13 = 0;
	always @ ( posedge tx_clk)
		  nlll1i13 <= nlll1i14;
	event nlll1i13_event;
	initial
		#1 ->nlll1i13_event;
	always @(nlll1i13_event)
		nlll1i13 <= {1{1'b1}};
	initial
		nlll1i14 = 0;
	always @ ( posedge tx_clk)
		  nlll1i14 <= nlll1i13;
	initial
		nlllil10 = 0;
	always @ ( posedge tx_clk)
		  nlllil10 <= nlllil9;
	initial
		nlllil9 = 0;
	always @ ( posedge tx_clk)
		  nlllil9 <= nlllil10;
	event nlllil9_event;
	initial
		#1 ->nlllil9_event;
	always @(nlllil9_event)
		nlllil9 <= {1{1'b1}};
	initial
		nllliO7 = 0;
	always @ ( posedge tx_clk)
		  nllliO7 <= nllliO8;
	event nllliO7_event;
	initial
		#1 ->nllliO7_event;
	always @(nllliO7_event)
		nllliO7 <= {1{1'b1}};
	initial
		nllliO8 = 0;
	always @ ( posedge tx_clk)
		  nllliO8 <= nllliO7;
	initial
		nlllli5 = 0;
	always @ ( posedge tx_clk)
		  nlllli5 <= nlllli6;
	event nlllli5_event;
	initial
		#1 ->nlllli5_event;
	always @(nlllli5_event)
		nlllli5 <= {1{1'b1}};
	initial
		nlllli6 = 0;
	always @ ( posedge tx_clk)
		  nlllli6 <= nlllli5;
	initial
		nlllll3 = 0;
	always @ ( posedge tx_clk)
		  nlllll3 <= nlllll4;
	event nlllll3_event;
	initial
		#1 ->nlllll3_event;
	always @(nlllll3_event)
		nlllll3 <= {1{1'b1}};
	initial
		nlllll4 = 0;
	always @ ( posedge tx_clk)
		  nlllll4 <= nlllll3;
	initial
		nlllOl1 = 0;
	always @ ( posedge tx_clk)
		  nlllOl1 <= nlllOl2;
	event nlllOl1_event;
	initial
		#1 ->nlllOl1_event;
	always @(nlllOl1_event)
		nlllOl1 <= {1{1'b1}};
	initial
		nlllOl2 = 0;
	always @ ( posedge tx_clk)
		  nlllOl2 <= nlllOl1;
	initial
	begin
		ni0O = 0;
		nlO0Ol = 0;
		nlO0OO = 0;
		nlOi0i = 0;
		nlOi0l = 0;
		nlOi0O = 0;
		nlOi1i = 0;
		nlOi1l = 0;
		nlOi1O = 0;
		nlOiii = 0;
		nlOiil = 0;
		nlOiiO = 0;
		nlOili = 0;
		nlOill = 0;
		nlOilO = 0;
		nlOiOi = 0;
		nlOiOl = 0;
		nlOiOO = 0;
		nlOl1i = 0;
		nlOl1l = 0;
		nlOl1O = 0;
	end
	always @ (tx_clk or wire_ni0l_PRN or soft_reset)
	begin
		if (wire_ni0l_PRN == 1'b0) 
		begin
			ni0O <= 1;
			nlO0Ol <= 1;
			nlO0OO <= 1;
			nlOi0i <= 1;
			nlOi0l <= 1;
			nlOi0O <= 1;
			nlOi1i <= 1;
			nlOi1l <= 1;
			nlOi1O <= 1;
			nlOiii <= 1;
			nlOiil <= 1;
			nlOiiO <= 1;
			nlOili <= 1;
			nlOill <= 1;
			nlOilO <= 1;
			nlOiOi <= 1;
			nlOiOl <= 1;
			nlOiOO <= 1;
			nlOl1i <= 1;
			nlOl1l <= 1;
			nlOl1O <= 1;
		end
		else if  (soft_reset == 1'b1) 
		begin
			ni0O <= 0;
			nlO0Ol <= 0;
			nlO0OO <= 0;
			nlOi0i <= 0;
			nlOi0l <= 0;
			nlOi0O <= 0;
			nlOi1i <= 0;
			nlOi1l <= 0;
			nlOi1O <= 0;
			nlOiii <= 0;
			nlOiil <= 0;
			nlOiiO <= 0;
			nlOili <= 0;
			nlOill <= 0;
			nlOilO <= 0;
			nlOiOi <= 0;
			nlOiOl <= 0;
			nlOiOO <= 0;
			nlOl1i <= 0;
			nlOl1l <= 0;
			nlOl1O <= 0;
		end
		else if  (nlliii == 1'b0) 
		if (tx_clk != ni0l_clk_prev && tx_clk == 1'b1) 
		begin
			ni0O <= wire_n100O_dataout;
			nlO0Ol <= wire_n10ii_dataout;
			nlO0OO <= wire_n10il_dataout;
			nlOi0i <= wire_n10lO_dataout;
			nlOi0l <= wire_n10Oi_dataout;
			nlOi0O <= wire_n10Ol_dataout;
			nlOi1i <= wire_n10iO_dataout;
			nlOi1l <= wire_n10li_dataout;
			nlOi1O <= wire_n10ll_dataout;
			nlOiii <= wire_n10OO_dataout;
			nlOiil <= wire_n1i1i_dataout;
			nlOiiO <= wire_n1i1l_dataout;
			nlOili <= wire_n1i1O_dataout;
			nlOill <= wire_n1i0i_dataout;
			nlOilO <= wire_n1i0l_dataout;
			nlOiOi <= wire_n1i0O_dataout;
			nlOiOl <= wire_n1iii_dataout;
			nlOiOO <= wire_n1iil_dataout;
			nlOl1i <= wire_n1iiO_dataout;
			nlOl1l <= wire_n1ili_dataout;
			nlOl1O <= wire_n1ill_dataout;
		end
		ni0l_clk_prev <= tx_clk;
	end
	assign
		wire_ni0l_PRN = (nlli1O26 ^ nlli1O25);
	initial
	begin
		n0i = 0;
		n1i = 0;
		n1l = 0;
		n1O = 0;
		nili = 0;
		nill = 0;
		nlll = 0;
		nllO = 0;
		nlOi = 0;
		nlOl = 0;
		nlOl0i = 0;
		nlOl0l = 0;
		nlOl0O = 0;
		nlOlii = 0;
		nlOlil = 0;
		nlOliO = 0;
		nlOlli = 0;
		nlOlll = 0;
		nlOllO = 0;
		nlOlOi = 0;
		nlOlOl = 0;
		nlOlOO = 0;
		nlOO = 0;
		nlOO0i = 0;
		nlOO0l = 0;
		nlOO0O = 0;
		nlOO1i = 0;
		nlOO1l = 0;
		nlOO1O = 0;
		nlOOii = 0;
		nlOOil = 0;
		nlOOiO = 0;
		nlOOli = 0;
		nlOOll = 0;
		nlOOlO = 0;
		nO = 0;
	end
	always @ ( posedge tx_clk or  negedge wire_nl_CLRN)
	begin
		if (wire_nl_CLRN == 1'b0) 
		begin
			n0i <= 0;
			n1i <= 0;
			n1l <= 0;
			n1O <= 0;
			nili <= 0;
			nill <= 0;
			nlll <= 0;
			nllO <= 0;
			nlOi <= 0;
			nlOl <= 0;
			nlOl0i <= 0;
			nlOl0l <= 0;
			nlOl0O <= 0;
			nlOlii <= 0;
			nlOlil <= 0;
			nlOliO <= 0;
			nlOlli <= 0;
			nlOlll <= 0;
			nlOllO <= 0;
			nlOlOi <= 0;
			nlOlOl <= 0;
			nlOlOO <= 0;
			nlOO <= 0;
			nlOO0i <= 0;
			nlOO0l <= 0;
			nlOO0O <= 0;
			nlOO1i <= 0;
			nlOO1l <= 0;
			nlOO1O <= 0;
			nlOOii <= 0;
			nlOOil <= 0;
			nlOOiO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
			nlOOlO <= 0;
			nO <= 0;
		end
		else 
		begin
			n0i <= nO;
			n1i <= wire_nli_dataout;
			n1l <= wire_nll_dataout;
			n1O <= wire_nlO_dataout;
			nili <= nill;
			nill <= rprbs_en_tx;
			nlll <= wire_n0l_dataout;
			nllO <= wire_n0O_dataout;
			nlOi <= wire_nii_dataout;
			nlOl <= wire_nil_dataout;
			nlOl0i <= wire_nlOOOi_dataout;
			nlOl0l <= wire_nlOOOl_dataout;
			nlOl0O <= wire_nlOOOO_dataout;
			nlOlii <= wire_n111i_dataout;
			nlOlil <= wire_n111l_dataout;
			nlOliO <= wire_n111O_dataout;
			nlOlli <= wire_n110i_dataout;
			nlOlll <= wire_n110l_dataout;
			nlOllO <= wire_n110O_dataout;
			nlOlOi <= wire_n11ii_dataout;
			nlOlOl <= wire_n11il_dataout;
			nlOlOO <= wire_n11iO_dataout;
			nlOO <= wire_niO_dataout;
			nlOO0i <= wire_n11Oi_dataout;
			nlOO0l <= wire_n11Ol_dataout;
			nlOO0O <= wire_n11OO_dataout;
			nlOO1i <= wire_n11li_dataout;
			nlOO1l <= wire_n11ll_dataout;
			nlOO1O <= wire_n11lO_dataout;
			nlOOii <= wire_n101i_dataout;
			nlOOil <= wire_n101l_dataout;
			nlOOiO <= wire_n101O_dataout;
			nlOOli <= wire_n100i_dataout;
			nlOOll <= wire_n100l_dataout;
			nlOOlO <= nili;
			nO <= cid_en;
		end
	end
	assign
		wire_nl_CLRN = ((nlllOl2 ^ nlllOl1) & (~ soft_reset));
	initial
	begin
		nilO = 0;
		nlil = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nilO <= 0;
			nlil <= 0;
		end
		else if  (nlll0l == 1'b1) 
		begin
			nilO <= wire_niOO_o;
			nlil <= wire_nl1i_o;
		end
	end
	initial
	begin
		nlli = 0;
	end
	always @ ( posedge tx_clk or  negedge wire_nliO_PRN)
	begin
		if (wire_nliO_PRN == 1'b0) 
		begin
			nlli <= 1;
		end
		else if  (nlll0l == 1'b1) 
		begin
			nlli <= wire_nl1l_o;
		end
	end
	assign
		wire_nliO_PRN = ((nlll0O12 ^ nlll0O11) & (~ soft_reset));
	assign		wire_n0l_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[1] : rcid_len[0];
	assign		wire_n0O_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[2] : rcid_len[1];
	assign		wire_n100i_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O1O_dataout;
	assign		wire_n100l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O0i_dataout;
	assign		wire_n100O_dataout = (nlOOlO === 1'b1) ? wire_n1O0l_dataout : ni0O;
	assign		wire_n101i_dataout = (nlliii === 1'b1) ? (~ (wire_n00ii_o[16] | wire_n00ii_o[2])) : wire_n1lOO_dataout;
	assign		wire_n101l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O1i_dataout;
	assign		wire_n101O_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O1l_dataout;
	and(wire_n10i_dataout, nlOO0i, nlli1l);
	assign		wire_n10ii_dataout = (nlOOlO === 1'b1) ? wire_n1O0O_o : nlO0Ol;
	assign		wire_n10il_dataout = (nlOOlO === 1'b1) ? wire_n1Oii_o : nlO0OO;
	assign		wire_n10iO_dataout = (nlOOlO === 1'b1) ? wire_n1Oil_o : nlOi1i;
	and(wire_n10l_dataout, nlOO0l, nlli1l);
	assign		wire_n10li_dataout = (nlOOlO === 1'b1) ? wire_n1OiO_o : nlOi1l;
	assign		wire_n10ll_dataout = (nlOOlO === 1'b1) ? wire_n1Oli_o : nlOi1O;
	assign		wire_n10lO_dataout = (nlOOlO === 1'b1) ? wire_n1Oll_o : nlOi0i;
	and(wire_n10O_dataout, nlOO0O, nlli1l);
	assign		wire_n10Oi_dataout = (nlOOlO === 1'b1) ? wire_n1OlO_o : nlOi0l;
	assign		wire_n10Ol_dataout = (nlOOlO === 1'b1) ? wire_n1OOi_o : nlOi0O;
	assign		wire_n10OO_dataout = (nlOOlO === 1'b1) ? wire_n011i_o : nlOiii;
	or(wire_n110i_dataout, wire_n1l1O_dataout, nlliii);
	assign		wire_n110l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l0i_dataout;
	assign		wire_n110O_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l0l_dataout;
	assign		wire_n111i_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1iOO_dataout;
	assign		wire_n111l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l1i_dataout;
	assign		wire_n111O_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l1l_dataout;
	and(wire_n11i_dataout, nlOO1i, nlli1l);
	assign		wire_n11ii_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l0O_dataout;
	assign		wire_n11il_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lii_dataout;
	assign		wire_n11iO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lil_dataout;
	and(wire_n11l_dataout, nlOO1l, nlli1l);
	assign		wire_n11li_dataout = (nlliii === 1'b1) ? (~ wire_n00ii_o[2]) : wire_n1liO_dataout;
	assign		wire_n11ll_dataout = (nlliii === 1'b1) ? (~ wire_n00ii_o[2]) : wire_n1lli_dataout;
	assign		wire_n11lO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lll_dataout;
	and(wire_n11O_dataout, nlOO1O, nlli1l);
	assign		wire_n11Oi_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1llO_dataout;
	assign		wire_n11Ol_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lOi_dataout;
	assign		wire_n11OO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lOl_dataout;
	assign		wire_n1i0i_dataout = (nlOOlO === 1'b1) ? wire_n010O_o : nlOill;
	assign		wire_n1i0l_dataout = (nlOOlO === 1'b1) ? wire_n01iO_o : nlOilO;
	assign		wire_n1i0O_dataout = (nlOOlO === 1'b1) ? wire_n01ll_o : nlOiOi;
	assign		wire_n1i1i_dataout = (nlOOlO === 1'b1) ? wire_n011l_o : nlOiil;
	assign		wire_n1i1l_dataout = (nlOOlO === 1'b1) ? wire_n011O_o : nlOiiO;
	assign		wire_n1i1O_dataout = (nlOOlO === 1'b1) ? wire_n010i_o : nlOili;
	and(wire_n1ii_dataout, nlOOii, nlli1l);
	assign		wire_n1iii_dataout = (nlOOlO === 1'b1) ? wire_n01lO_o : nlOiOl;
	assign		wire_n1iil_dataout = (nlOOlO === 1'b1) ? wire_n01Oi_o : nlOiOO;
	assign		wire_n1iiO_dataout = (nlOOlO === 1'b1) ? wire_n01Ol_o : nlOl1i;
	and(wire_n1il_dataout, nlOOil, nlli1l);
	assign		wire_n1ili_dataout = (nlOOlO === 1'b1) ? wire_n001O_o : nlOl1l;
	assign		wire_n1ill_dataout = (nlOOlO === 1'b1) ? wire_n000i_o : nlOl1O;
	assign		wire_n1ilO_dataout = (nlOOlO === 1'b1) ? wire_n00il_o : nlOl0i;
	and(wire_n1iO_dataout, nlOOiO, nlli1l);
	assign		wire_n1iOi_dataout = (nlOOlO === 1'b1) ? wire_n00iO_o : nlOl0l;
	assign		wire_n1iOl_dataout = (nlOOlO === 1'b1) ? wire_n00li_o : nlOl0O;
	assign		wire_n1iOO_dataout = (nlOOlO === 1'b1) ? wire_n00ll_o : nlOlii;
	assign		wire_n1l0i_dataout = (nlOOlO === 1'b1) ? wire_n00OO_o : nlOlll;
	assign		wire_n1l0l_dataout = (nlOOlO === 1'b1) ? wire_n0i1i_o : nlOllO;
	assign		wire_n1l0O_dataout = (nlOOlO === 1'b1) ? wire_n0i1l_o : nlOlOi;
	assign		wire_n1l1i_dataout = (nlOOlO === 1'b1) ? wire_n00lO_o : nlOlil;
	assign		wire_n1l1l_dataout = (nlOOlO === 1'b1) ? wire_n00Oi_o : nlOliO;
	assign		wire_n1l1O_dataout = (nlOOlO === 1'b1) ? wire_n00Ol_o : nlOlli;
	and(wire_n1li_dataout, nlOOli, nlli1l);
	assign		wire_n1lii_dataout = (nlOOlO === 1'b1) ? wire_n0i1O_o : nlOlOl;
	assign		wire_n1lil_dataout = (nlOOlO === 1'b1) ? wire_n0i0i_o : nlOlOO;
	assign		wire_n1liO_dataout = (nlOOlO === 1'b1) ? wire_n0i0l_o : nlOO1i;
	and(wire_n1ll_dataout, nlOOll, nlli1l);
	assign		wire_n1lli_dataout = (nlOOlO === 1'b1) ? wire_n0i0O_o : nlOO1l;
	assign		wire_n1lll_dataout = (nlOOlO === 1'b1) ? wire_n0iii_o : nlOO1O;
	assign		wire_n1llO_dataout = (nlOOlO === 1'b1) ? wire_n0iil_o : nlOO0i;
	assign		wire_n1lOi_dataout = (nlOOlO === 1'b1) ? wire_n0iiO_o : nlOO0l;
	assign		wire_n1lOl_dataout = (nlOOlO === 1'b1) ? wire_n0ili_o : nlOO0O;
	assign		wire_n1lOO_dataout = (nlOOlO === 1'b1) ? wire_n0ill_o : nlOOii;
	assign		wire_n1O0i_dataout = (nlOOlO === 1'b1) ? wire_n0iOO_o : nlOOll;
	assign		wire_n1O0l_dataout = (wire_n00ii_o[11] === 1'b1) ? (~ ni0O) : ni0O;
	assign		wire_n1O1i_dataout = (nlOOlO === 1'b1) ? wire_n0ilO_o : nlOOil;
	assign		wire_n1O1l_dataout = (nlOOlO === 1'b1) ? wire_n0iOi_o : nlOOiO;
	assign		wire_n1O1O_dataout = (nlOOlO === 1'b1) ? wire_n0iOl_o : nlOOli;
	assign		wire_nii_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[3] : rcid_len[2];
	or(wire_niiil_dataout, wire_niO1i_dataout, (~ ni0O));
	or(wire_niiiO_dataout, wire_niO1l_dataout, (~ ni0O));
	or(wire_niili_dataout, wire_niO1O_dataout, (~ ni0O));
	or(wire_niill_dataout, wire_niO0i_dataout, (~ ni0O));
	or(wire_niilO_dataout, wire_niO0l_dataout, (~ ni0O));
	and(wire_niiOi_dataout, wire_niO0O_dataout, ~((~ ni0O)));
	or(wire_niiOl_dataout, wire_niOii_dataout, (~ ni0O));
	and(wire_niiOO_dataout, wire_niOil_dataout, ~((~ ni0O)));
	assign		wire_nil_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[4] : rcid_len[3];
	and(wire_nil0i_dataout, wire_niOlO_dataout, ~((~ ni0O)));
	and(wire_nil0l_dataout, wire_niOOi_dataout, ~((~ ni0O)));
	and(wire_nil0O_dataout, wire_niOOl_dataout, ~((~ ni0O)));
	or(wire_nil1i_dataout, wire_niOiO_dataout, (~ ni0O));
	or(wire_nil1l_dataout, wire_niOli_dataout, (~ ni0O));
	and(wire_nil1O_dataout, wire_niOll_dataout, ~((~ ni0O)));
	and(wire_nilii_dataout, wire_niOOO_dataout, ~((~ ni0O)));
	and(wire_nilil_dataout, wire_nl11i_dataout, ~((~ ni0O)));
	and(wire_niliO_dataout, wire_nl11l_dataout, ~((~ ni0O)));
	and(wire_nilli_dataout, wire_nl11O_dataout, ~((~ ni0O)));
	and(wire_nilll_dataout, wire_nl10i_dataout, ~((~ ni0O)));
	and(wire_nillO_dataout, wire_nl10l_dataout, ~((~ ni0O)));
	and(wire_nilOi_dataout, wire_nl10O_dataout, ~((~ ni0O)));
	and(wire_nilOl_dataout, wire_nl1ii_dataout, ~((~ ni0O)));
	and(wire_nilOO_dataout, wire_nl1il_dataout, ~((~ ni0O)));
	assign		wire_niO_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[5] : rcid_len[4];
	and(wire_niO0i_dataout, nlOlii, ~(ni0O));
	and(wire_niO0l_dataout, nlOlil, ~(ni0O));
	or(wire_niO0O_dataout, nlOliO, ni0O);
	and(wire_niO1i_dataout, nlOl0i, ~(ni0O));
	and(wire_niO1l_dataout, nlOl0l, ~(ni0O));
	and(wire_niO1O_dataout, nlOl0O, ~(ni0O));
	and(wire_niOi_dataout, nlil, nlll0l);
	and(wire_niOii_dataout, nlOlli, ~(ni0O));
	or(wire_niOil_dataout, nlOlll, ni0O);
	and(wire_niOiO_dataout, nlOllO, ~(ni0O));
	and(wire_niOl_dataout, nlli, nlll0l);
	and(wire_niOli_dataout, nlOlOi, ~(ni0O));
	and(wire_niOll_dataout, nlOlOl, ~(ni0O));
	and(wire_niOlO_dataout, nlOlOO, ~(ni0O));
	and(wire_niOOi_dataout, nlOO1i, ~(ni0O));
	and(wire_niOOl_dataout, nlOO1l, ~(ni0O));
	and(wire_niOOO_dataout, nlOO1O, ~(ni0O));
	and(wire_nl0i_dataout, nlliOl, ~(nlliOO));
	and(wire_nl0iO_dataout, wire_nliOl_dataout, ~(wire_niOl_dataout));
	or(wire_nl0li_dataout, wire_nliOO_dataout, wire_niOl_dataout);
	and(wire_nl0ll_dataout, wire_nll1i_dataout, ~(wire_niOl_dataout));
	or(wire_nl0lO_dataout, wire_nll1l_dataout, wire_niOl_dataout);
	or(wire_nl0Oi_dataout, wire_nll1O_dataout, wire_niOl_dataout);
	and(wire_nl0Ol_dataout, wire_nll0i_dataout, ~(wire_niOl_dataout));
	or(wire_nl0OO_dataout, wire_nll0l_dataout, wire_niOl_dataout);
	and(wire_nl10i_dataout, nlOOii, ~(ni0O));
	and(wire_nl10l_dataout, nlOOil, ~(ni0O));
	and(wire_nl10O_dataout, nlOOiO, ~(ni0O));
	and(wire_nl11i_dataout, nlOO0i, ~(ni0O));
	and(wire_nl11l_dataout, nlOO0l, ~(ni0O));
	and(wire_nl11O_dataout, nlOO0O, ~(ni0O));
	and(wire_nl1ii_dataout, nlOOli, ~(ni0O));
	and(wire_nl1il_dataout, nlOOll, ~(ni0O));
	and(wire_nl1O_dataout, (~ nlliOl), ~(nlliOO));
	assign		wire_nli_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[6] : rcid_len[5];
	and(wire_nli0i_dataout, wire_nlliO_dataout, ~(wire_niOl_dataout));
	and(wire_nli0l_dataout, wire_nllli_dataout, ~(wire_niOl_dataout));
	and(wire_nli0O_dataout, wire_nllll_dataout, ~(wire_niOl_dataout));
	and(wire_nli1i_dataout, wire_nll0O_dataout, ~(wire_niOl_dataout));
	and(wire_nli1l_dataout, wire_nllii_dataout, ~(wire_niOl_dataout));
	and(wire_nli1O_dataout, wire_nllil_dataout, ~(wire_niOl_dataout));
	and(wire_nliii_dataout, wire_nlllO_dataout, ~(wire_niOl_dataout));
	and(wire_nliil_dataout, wire_nllOi_dataout, ~(wire_niOl_dataout));
	and(wire_nliiO_dataout, wire_nllOl_dataout, ~(wire_niOl_dataout));
	and(wire_nlili_dataout, wire_nllOO_dataout, ~(wire_niOl_dataout));
	and(wire_nlill_dataout, wire_nlO1i_dataout, ~(wire_niOl_dataout));
	and(wire_nlilO_dataout, wire_nlO1l_dataout, ~(wire_niOl_dataout));
	and(wire_nliOi_dataout, wire_nlO1O_dataout, ~(wire_niOl_dataout));
	assign		wire_nliOl_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOl0i;
	assign		wire_nliOO_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOl0l;
	assign		wire_nll_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[7] : rcid_len[6];
	assign		wire_nll0i_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOliO;
	assign		wire_nll0l_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlli;
	assign		wire_nll0O_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlll;
	assign		wire_nll1i_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOl0O;
	assign		wire_nll1l_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlii;
	assign		wire_nll1O_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlil;
	and(wire_nllii_dataout, nlOllO, ~(wire_niOi_dataout));
	and(wire_nllil_dataout, nlOlOi, ~(wire_niOi_dataout));
	and(wire_nlliO_dataout, nlOlOl, ~(wire_niOi_dataout));
	and(wire_nllli_dataout, nlOlOO, ~(wire_niOi_dataout));
	and(wire_nllll_dataout, nlOO1i, ~(wire_niOi_dataout));
	and(wire_nlllO_dataout, nlOO1l, ~(wire_niOi_dataout));
	and(wire_nllOi_dataout, nlOO1O, ~(wire_niOi_dataout));
	and(wire_nllOl_dataout, nlOO0i, ~(wire_niOi_dataout));
	and(wire_nllOO_dataout, nlOO0l, ~(wire_niOi_dataout));
	assign		wire_nlO_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[8] : rcid_len[7];
	assign		wire_nlO0i_dataout = (nlli1l === 1'b1) ? nlOl0i : ((nll0Oi ^ nlOl0l) ^ nlOl0i);
	assign		wire_nlO0l_dataout = (nlli1l === 1'b1) ? nlOl0l : ((nlli1i ^ nlOl0O) ^ nlOl0l);
	assign		wire_nlO0O_dataout = (nlli1l === 1'b1) ? nlOl0O : ((((((((nlli1i ^ nlOliO) ^ (~ (nll01i38 ^ nll01i37))) ^ nlOlii) ^ (~ (nll1Ol40 ^ nll1Ol39))) ^ nlOl0O) ^ nlOl0l) ^ nlOl0i) ^ (~ (nll1lO42 ^ nll1lO41)));
	and(wire_nlO1i_dataout, nlOO0O, ~(wire_niOi_dataout));
	and(wire_nlO1l_dataout, nlOOii, ~(wire_niOi_dataout));
	and(wire_nlO1O_dataout, nlOOil, ~(wire_niOi_dataout));
	assign		wire_nlOii_dataout = (nlli1l === 1'b1) ? nlOlii : (((((((nlOlll ^ nlOliO) ^ nlOlil) ^ nlOlii) ^ (~ (nll00l34 ^ nll00l33))) ^ nlOl0O) ^ nlOl0i) ^ (~ (nll01O36 ^ nll01O35)));
	assign		wire_nlOil_dataout = (nlli1l === 1'b1) ? nlOlil : (nll0ll ^ nlOl0i);
	assign		wire_nlOiO_dataout = (nlli1l === 1'b1) ? nlOliO : (nll0lO ^ nlOl0l);
	assign		wire_nlOli_dataout = (nlli1l === 1'b1) ? nlOlli : ((nll0Oi ^ nlOl0O) ^ (~ (nll0ii32 ^ nll0ii31)));
	assign		wire_nlOll_dataout = (nlli1l === 1'b1) ? nlOlll : ((nlli1i ^ nlOlii) ^ (~ (nll0iO30 ^ nll0iO29)));
	and(wire_nlOlO_dataout, nlOllO, nlli1l);
	and(wire_nlOOi_dataout, nlOlOi, nlli1l);
	and(wire_nlOOl_dataout, nlOlOl, nlli1l);
	and(wire_nlOOO_dataout, nlOlOO, nlli1l);
	assign		wire_nlOOOi_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1ilO_dataout;
	assign		wire_nlOOOl_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1iOi_dataout;
	assign		wire_nlOOOO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1iOl_dataout;
	oper_add   ni
	( 
	.a({((nlllil10 ^ nlllil9) & n1O), ((nllliO8 ^ nllliO7) & n1l), n1i, nlOO, ((nlllli6 ^ nlllli5) & nlOl), nlOi, nllO, ((nlllll4 ^ nlllll3) & nlll), 1'b1}),
	.b({{7{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni_o));
	defparam
		ni.sgate_representation = 0,
		ni.width_a = 9,
		ni.width_b = 9,
		ni.width_o = 9;
	oper_decoder   n00ii
	( 
	.i({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}),
	.o(wire_n00ii_o));
	defparam
		n00ii.width_i = 5,
		n00ii.width_o = 32;
	oper_mux   n00il
	( 
	.data({{3{1'b0}}, {3{1'b1}}, ((nlOO0l ^ nlOlii) ^ nlOOli), nliOOO, {5{1'b0}}, 1'b1, nliliO, (nlOlOl ^ nlOlOi), {4{1'b0}}, wire_niiil_dataout, {2{1'b1}}, nll1iO, {3{1'b0}}, nliO1l, 1'b0, (nlOl0O ^ nlOl0l), 1'b1, wire_nlO0i_dataout}),
	.o(wire_n00il_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00il.width_data = 32,
		n00il.width_sel = 5;
	oper_mux   n00iO
	( 
	.data({{3{1'b0}}, {2{1'b1}}, 1'b0, ((nlOO0O ^ nlOlil) ^ nlOOll), nll11i, {6{1'b0}}, nlilli, (nlOlOO ^ nlOlOl), {4{1'b0}}, wire_niiiO_dataout, 1'b1, 1'b0, nll10O, {3{1'b0}}, nliO1O, 1'b0, (nlOlii ^ nlOl0O), 1'b0, wire_nlO0l_dataout}),
	.o(wire_n00iO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00iO.width_data = 32,
		n00iO.width_sel = 5;
	oper_mux   n00li
	( 
	.data({{3{1'b0}}, {3{1'b1}}, (nlOliO ^ nlOl0i), nliOli, {5{1'b0}}, 1'b1, nlilll, nll11O, {4{1'b0}}, wire_niili_dataout, {2{1'b1}}, nll10l, {3{1'b0}}, nliO0i, 1'b0, nll0ll, 1'b1, wire_nlO0O_dataout}),
	.o(wire_n00li_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00li.width_data = 32,
		n00li.width_sel = 5;
	oper_mux   n00ll
	( 
	.data({{3{1'b0}}, {2{1'b1}}, 1'b0, (nlOlli ^ nlOl0l), nliOll, {6{1'b0}}, nlillO, nll10i, {4{1'b0}}, wire_niill_dataout, 1'b1, 1'b0, (nlOlli ^ nlOlii), {3{1'b0}}, nliO0l, 1'b0, nll0lO, 1'b0, wire_nlOii_dataout}),
	.o(wire_n00ll_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00ll.width_data = 32,
		n00ll.width_sel = 5;
	oper_mux   n00lO
	( 
	.data({{3{1'b0}}, {3{1'b1}}, nliliO, nliOlO, {5{1'b0}}, 1'b1, nlilOi, nliOOO, {4{1'b0}}, wire_niilO_dataout, {2{1'b1}}, (nlOlll ^ nlOlil), {3{1'b0}}, nliO0O, 1'b0, nll0Oi, 1'b1, wire_nlOil_dataout}),
	.o(wire_n00lO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00lO.width_data = 32,
		n00lO.width_sel = 5;
	oper_mux   n00Oi
	( 
	.data({{6{1'b0}}, nlilli, nliOOl, {6{1'b0}}, nlilOl, nll11i, {4{1'b0}}, wire_niiOi_dataout, {2{1'b0}}, (nlOllO ^ nlOliO), {3{1'b0}}, nliOii, 1'b0, nlli1i, 1'b0, wire_nlOiO_dataout}),
	.o(wire_n00Oi_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00Oi.width_data = 32,
		n00Oi.width_sel = 5;
	oper_mux   n00Ol
	( 
	.data({{3{1'b0}}, 1'b1, 1'b0, 1'b1, nlilll, (nliO0O ^ nlOO1l), {5{1'b0}}, 1'b1, nlilOO, (nliO1l ^ nlOlOi), {4{1'b0}}, wire_niiOl_dataout, 1'b0, 1'b1, (nlOlOi ^ nlOlli), {3{1'b0}}, nliOil, 1'b0, ((nlOlll ^ nlOl0l) ^ nlOl0O), 1'b1, wire_nlOli_dataout}),
	.o(wire_n00Ol_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00Ol.width_data = 32,
		n00Ol.width_sel = 5;
	oper_mux   n00OO
	( 
	.data({{6{1'b0}}, nlillO, nll11l, {6{1'b0}}, nliO1i, (nlOlOO ^ nlOlOi), {4{1'b0}}, wire_niiOO_dataout, {2{1'b0}}, (nll1iO ^ nlOlll), {3{1'b0}}, nliOiO, 1'b0, (nlOlii ^ nlOl0l), 1'b0, wire_nlOll_dataout}),
	.o(wire_n00OO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00OO.width_data = 32,
		n00OO.width_sel = 5;
	oper_mux   n0i0i
	( 
	.data({{4{1'b0}}, 1'b1, 1'b0, nliO1i, (nlOOil ^ nlOO0O), {6{1'b0}}, nliO0l, nll11l, {4{1'b0}}, wire_nil0i_dataout, {6{1'b0}}, nlOlii, {3{1'b0}}, wire_nlOOO_dataout}),
	.o(wire_n0i0i_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i0i.width_data = 32,
		n0i0i.width_sel = 5;
	oper_mux   n0i0l
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nliO1l, ((nlOOii ^ nlOO1O) ^ nlOO1l), {5{1'b0}}, 1'b1, nliO0O, ((nlOO1O ^ nlOlOl) ^ nlOlOi), {4{1'b0}}, wire_nil0l_dataout, {6{1'b0}}, nlOlil, {3{1'b0}}, wire_n11i_dataout}),
	.o(wire_n0i0l_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i0l.width_data = 32,
		n0i0l.width_sel = 5;
	oper_mux   n0i0O
	( 
	.data({{4{1'b0}}, 1'b1, 1'b0, nliO1O, ((nlOOil ^ nlOO0i) ^ nlOO1O), {6{1'b0}}, nliOii, ((nlOO0i ^ nlOlOO) ^ nlOlOl), {4{1'b0}}, wire_nil0O_dataout, {6{1'b0}}, nlOliO, {3{1'b0}}, wire_n11l_dataout}),
	.o(wire_n0i0O_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i0O.width_data = 32,
		n0i0O.width_sel = 5;
	oper_mux   n0i1i
	( 
	.data({{3{1'b0}}, 1'b1, 1'b0, 1'b1, nlilOi, (nlOO0l ^ nlOO1O), {5{1'b0}}, 1'b1, nliO1l, (nlOO1i ^ nlOlOl), {4{1'b0}}, wire_nil1i_dataout, 1'b0, 1'b1, (nll10O ^ nlOllO), {3{1'b0}}, nlOl0i, {3{1'b0}}, wire_nlOlO_dataout}),
	.o(wire_n0i1i_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i1i.width_data = 32,
		n0i1i.width_sel = 5;
	oper_mux   n0i1l
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nlilOl, (nlOO0O ^ nlOO0i), {6{1'b0}}, nliO1O, (nlOO1l ^ nlOlOO), {4{1'b0}}, wire_nil1l_dataout, {2{1'b0}}, (nll10l ^ nlOlOi), {3{1'b0}}, nlOl0l, {3{1'b0}}, wire_nlOOi_dataout}),
	.o(wire_n0i1l_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i1l.width_data = 32,
		n0i1l.width_sel = 5;
	oper_mux   n0i1O
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nlilOO, (nlOOii ^ nlOO0l), {5{1'b0}}, 1'b1, nliO0i, (nlOO1O ^ nlOO1i), {4{1'b0}}, wire_nil1O_dataout, {6{1'b0}}, nlOl0O, {3{1'b0}}, wire_nlOOl_dataout}),
	.o(wire_n0i1O_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i1O.width_data = 32,
		n0i1O.width_sel = 5;
	oper_mux   n0iii
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nliO0i, ((nliOli ^ nlOO1O) ^ nlOO1l), {5{1'b0}}, 1'b1, nliOil, ((nll11O ^ nlOlOl) ^ nlOlOi), {4{1'b0}}, wire_nilii_dataout, {6{1'b0}}, nlOlli, {3{1'b0}}, wire_n11O_dataout}),
	.o(wire_n0iii_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iii.width_data = 32,
		n0iii.width_sel = 5;
	oper_mux   n0iil
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nliO0l, ((nliOll ^ nlOO0i) ^ nlOO1O), {6{1'b0}}, nliOiO, ((nll10i ^ nlOlOO) ^ nlOlOl), {4{1'b0}}, wire_nilil_dataout, {6{1'b0}}, nlOlll, {3{1'b0}}, wire_n10i_dataout}),
	.o(wire_n0iil_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iil.width_data = 32,
		n0iil.width_sel = 5;
	oper_mux   n0iiO
	( 
	.data({{5{1'b0}}, 1'b1, nliO0O, ((nliOlO ^ nlOO0l) ^ nlOO0i), {6{1'b0}}, nlOl0i, {5{1'b0}}, wire_niliO_dataout, {6{1'b0}}, nlOllO, {3{1'b0}}, wire_n10l_dataout}),
	.o(wire_n0iiO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iiO.width_data = 32,
		n0iiO.width_sel = 5;
	oper_mux   n0ili
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nliOii, (nliOOi ^ nlOO0l), {6{1'b0}}, nlOl0l, {5{1'b0}}, wire_nilli_dataout, {6{1'b0}}, nlOlOi, {3{1'b0}}, wire_n10O_dataout}),
	.o(wire_n0ili_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0ili.width_data = 32,
		n0ili.width_sel = 5;
	oper_mux   n0ill
	( 
	.data({{5{1'b0}}, 1'b1, nliOil, ((nliOOi ^ nlOO1O) ^ nlOO1l), {6{1'b0}}, nlOl0O, {5{1'b0}}, wire_nilll_dataout, {6{1'b0}}, nlOlOl, {3{1'b0}}, wire_n1ii_dataout}),
	.o(wire_n0ill_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0ill.width_data = 32,
		n0ill.width_sel = 5;
	oper_mux   n0ilO
	( 
	.data({{6{1'b0}}, nliOiO, ((nliOOl ^ nlOO0i) ^ nlOO1l), {6{1'b0}}, nlOlii, {5{1'b0}}, wire_nillO_dataout, {6{1'b0}}, nlOlOO, {3{1'b0}}, wire_n1il_dataout}),
	.o(wire_n0ilO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0ilO.width_data = 32,
		n0ilO.width_sel = 5;
	oper_mux   n0iOi
	( 
	.data({{6{1'b0}}, nlOl0i, {7{1'b0}}, nlOlil, {5{1'b0}}, wire_nilOi_dataout, {6{1'b0}}, nlOO1i, {3{1'b0}}, wire_n1iO_dataout}),
	.o(wire_n0iOi_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iOi.width_data = 32,
		n0iOi.width_sel = 5;
	oper_mux   n0iOl
	( 
	.data({{6{1'b0}}, nlOl0l, {7{1'b0}}, nlOliO, {5{1'b0}}, wire_nilOl_dataout, {6{1'b0}}, nlOO1l, {3{1'b0}}, wire_n1li_dataout}),
	.o(wire_n0iOl_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iOl.width_data = 32,
		n0iOl.width_sel = 5;
	oper_mux   n0iOO
	( 
	.data({{6{1'b0}}, nlOl0O, {7{1'b0}}, nlOlli, {5{1'b0}}, wire_nilOO_dataout, {6{1'b0}}, nlOO1O, {3{1'b0}}, wire_n1ll_dataout}),
	.o(wire_n0iOO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iOO.width_data = 32,
		n0iOO.width_sel = 5;
	oper_selector   n000i
	( 
	.data({1'b0, nlOOil, nlOlii, wire_nliOi_dataout}),
	.o(wire_n000i_o),
	.sel({nlilil, nlilii, wire_n00ii_o[25], wire_n00ii_o[0]}));
	defparam
		n000i.width_data = 4,
		n000i.width_sel = 4;
	oper_selector   n001O
	( 
	.data({1'b0, nlOOii, nlOlil, wire_nlilO_dataout}),
	.o(wire_n001O_o),
	.sel({nlilil, nlilii, wire_n00ii_o[25], wire_n00ii_o[0]}));
	defparam
		n001O.width_data = 4,
		n001O.width_sel = 4;
	oper_selector   n010i
	( 
	.data({1'b0, nlOlOO, nlOlOi, nlOO1l, wire_nli0l_dataout}),
	.o(wire_n010i_o),
	.sel({nlil0O, nlil1l, nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n010i.width_data = 5,
		n010i.width_sel = 5;
	oper_selector   n010O
	( 
	.data({1'b0, nlOO1i, nlOlOl, wire_nli0O_dataout}),
	.o(wire_n010O_o),
	.sel({nlil0O, nlil1O, ((wire_n00ii_o[16] | wire_n00ii_o[25]) | wire_n00ii_o[18]), wire_n00ii_o[0]}));
	defparam
		n010O.width_data = 4,
		n010O.width_sel = 4;
	oper_selector   n011i
	( 
	.data({1'b0, nlOllO, nlOO1O, nlOO0l, wire_nli1l_dataout}),
	.o(wire_n011i_o),
	.sel({nlilil, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[0]}));
	defparam
		n011i.width_data = 5,
		n011i.width_sel = 5;
	oper_selector   n011l
	( 
	.data({1'b0, nlOlOi, nlOO1l, nlOO0O, wire_nli1O_dataout}),
	.o(wire_n011l_o),
	.sel({nlilil, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[0]}));
	defparam
		n011l.width_data = 5,
		n011l.width_sel = 5;
	oper_selector   n011O
	( 
	.data({1'b0, nlOlOl, nlOO1i, nlOllO, nlOO1O, wire_nli0i_dataout}),
	.o(wire_n011O_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n011O.width_data = 6,
		n011O.width_sel = 6;
	oper_selector   n01iO
	( 
	.data({1'b0, nlOO1l, nlOlOi, nlOlOO, wire_nliii_dataout}),
	.o(wire_n01iO_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], ((wire_n00ii_o[16] | wire_n00ii_o[18]) | wire_n00ii_o[17]), wire_n00ii_o[0]}));
	defparam
		n01iO.width_data = 5,
		n01iO.width_sel = 5;
	oper_selector   n01ll
	( 
	.data({1'b0, nlOO1O, nlOllO, nlOO1i, nlOlOl, wire_nliil_dataout}),
	.o(wire_n01ll_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01ll.width_data = 6,
		n01ll.width_sel = 6;
	oper_selector   n01lO
	( 
	.data({1'b0, nlOO0i, nlOlll, nlOO1l, nlOlOi, wire_nliiO_dataout}),
	.o(wire_n01lO_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01lO.width_data = 6,
		n01lO.width_sel = 6;
	oper_selector   n01Oi
	( 
	.data({1'b0, nlOO0l, nlOlli, nlOO1O, nlOllO, wire_nlili_dataout}),
	.o(wire_n01Oi_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01Oi.width_data = 6,
		n01Oi.width_sel = 6;
	oper_selector   n01Ol
	( 
	.data({1'b0, nlOO0O, nlOliO, nlOO0i, nlOlll, wire_nlill_dataout}),
	.o(wire_n01Ol_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01Ol.width_data = 6,
		n01Ol.width_sel = 6;
	oper_selector   n1O0O
	( 
	.data({1'b0, nlOl0i, nlOOll, wire_nl0iO_dataout}),
	.o(wire_n1O0O_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1O0O.width_data = 4,
		n1O0O.width_sel = 4;
	oper_selector   n1Oii
	( 
	.data({1'b0, nlOl0l, nlOOli, wire_nl0li_dataout}),
	.o(wire_n1Oii_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oii.width_data = 4,
		n1Oii.width_sel = 4;
	oper_selector   n1Oil
	( 
	.data({1'b0, nlOl0O, nlOOiO, wire_nl0ll_dataout}),
	.o(wire_n1Oil_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oil.width_data = 4,
		n1Oil.width_sel = 4;
	oper_selector   n1OiO
	( 
	.data({1'b0, nlOlii, nlOOil, wire_nl0lO_dataout}),
	.o(wire_n1OiO_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1OiO.width_data = 4,
		n1OiO.width_sel = 4;
	oper_selector   n1Oli
	( 
	.data({1'b0, nlOlil, nlOOii, wire_nl0Oi_dataout}),
	.o(wire_n1Oli_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oli.width_data = 4,
		n1Oli.width_sel = 4;
	oper_selector   n1Oll
	( 
	.data({1'b0, nlOliO, nlOO0O, wire_nl0Ol_dataout}),
	.o(wire_n1Oll_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oll.width_data = 4,
		n1Oll.width_sel = 4;
	oper_selector   n1OlO
	( 
	.data({1'b0, nlOlli, nlOO0l, wire_nl0OO_dataout}),
	.o(wire_n1OlO_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1OlO.width_data = 4,
		n1OlO.width_sel = 4;
	oper_selector   n1OOi
	( 
	.data({1'b0, nlOlll, nlOO0i, wire_nli1i_dataout}),
	.o(wire_n1OOi_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1OOi.width_data = 4,
		n1OOi.width_sel = 4;
	oper_selector   niOO
	( 
	.data({nllilO, wire_nl1O_dataout, nllili}),
	.o(wire_niOO_o),
	.sel({nlli, nilO, ((nlliil22 ^ nlliil21) & nlil)}));
	defparam
		niOO.width_data = 3,
		niOO.width_sel = 3;
	oper_selector   nl1i
	( 
	.data({1'b0, ((nlliiO20 ^ nlliiO19) & nlliOO), (~ nllili)}),
	.o(wire_nl1i_o),
	.sel({nlli, nilO, ((nllill18 ^ nllill17) & nlil)}));
	defparam
		nl1i.width_data = 3,
		nl1i.width_sel = 3;
	oper_selector   nl1l
	( 
	.data({(~ nllilO), wire_nl0i_dataout, 1'b0}),
	.o(wire_nl1l_o),
	.sel({nlli, ((nlliOi16 ^ nlliOi15) & nilO), nlil}));
	defparam
		nl1l.width_data = 3,
		nl1l.width_sel = 3;
	assign
		nliiOO = ((wire_n00ii_o[25] | wire_n00ii_o[17]) | wire_n00ii_o[4]),
		nlil0i = (wire_n00ii_o[16] | wire_n00ii_o[18]),
		nlil0l = (((((((((wire_n00ii_o[24] | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlil0O = ((((((((((((((((wire_n00ii_o[31] | wire_n00ii_o[30]) | wire_n00ii_o[29]) | wire_n00ii_o[23]) | wire_n00ii_o[22]) | wire_n00ii_o[21]) | wire_n00ii_o[20]) | wire_n00ii_o[19]) | wire_n00ii_o[15]) | wire_n00ii_o[14]) | wire_n00ii_o[13]) | wire_n00ii_o[12]) | wire_n00ii_o[7]) | wire_n00ii_o[6]) | wire_n00ii_o[5]) | wire_n00ii_o[4]) | wire_n00ii_o[3]),
		nlil1i = (((((((((((((((wire_n00ii_o[31] | wire_n00ii_o[30]) | wire_n00ii_o[29]) | wire_n00ii_o[23]) | wire_n00ii_o[22]) | wire_n00ii_o[21]) | wire_n00ii_o[20]) | wire_n00ii_o[19]) | wire_n00ii_o[15]) | wire_n00ii_o[14]) | wire_n00ii_o[13]) | wire_n00ii_o[12]) | wire_n00ii_o[7]) | wire_n00ii_o[6]) | wire_n00ii_o[5]) | wire_n00ii_o[3]),
		nlil1l = ((((((((((wire_n00ii_o[24] | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[25]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlil1O = ((((((((((wire_n00ii_o[24] | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[17]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlilii = (((((((((((wire_n00ii_o[24] | wire_n00ii_o[16]) | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[18]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlilil = (((((((((((((((((wire_n00ii_o[31] | wire_n00ii_o[30]) | wire_n00ii_o[29]) | wire_n00ii_o[23]) | wire_n00ii_o[22]) | wire_n00ii_o[21]) | wire_n00ii_o[20]) | wire_n00ii_o[19]) | wire_n00ii_o[17]) | wire_n00ii_o[15]) | wire_n00ii_o[14]) | wire_n00ii_o[13]) | wire_n00ii_o[12]) | wire_n00ii_o[7]) | wire_n00ii_o[6]) | wire_n00ii_o[5]) | wire_n00ii_o[4]) | wire_n00ii_o[3]),
		nliliO = (nlOlll ^ nlOl0O),
		nlilli = (nlOllO ^ nlOlii),
		nlilll = (nlOlOi ^ nlOlil),
		nlillO = (nlOlOl ^ nlOliO),
		nlilOi = (nlOlOO ^ nlOlli),
		nlilOl = (nlOO1i ^ nlOlll),
		nlilOO = (nlOO1l ^ nlOllO),
		nliO0i = (nlOO0O ^ nlOO1i),
		nliO0l = (nlOOii ^ nlOO1l),
		nliO0O = (nlOOil ^ nlOO1O),
		nliO1i = (nlOO1O ^ nlOlOi),
		nliO1l = (nlOO0i ^ nlOlOl),
		nliO1O = (nlOO0l ^ nlOlOO),
		nliOii = (nlOOiO ^ nlOO0i),
		nliOil = (nlOOli ^ nlOO0l),
		nliOiO = (nlOOll ^ nlOO0O),
		nliOli = (nlOO0l ^ nlOO0i),
		nliOll = (nlOO0O ^ nlOO0l),
		nliOlO = (nlOOii ^ nlOO0O),
		nliOOi = (nliOOl ^ nlOO0O),
		nliOOl = (nlOOil ^ nlOOii),
		nliOOO = (nlOO1O ^ nlOO1l),
		nll0ll = (nlOlil ^ nlOlii),
		nll0lO = (nlOliO ^ nlOlil),
		nll0Oi = ((nlOlli ^ nlOliO) ^ (~ (nll0Ol28 ^ nll0Ol27))),
		nll10i = (nlOO1l ^ nlOO1i),
		nll10l = (nlOliO ^ nlOl0O),
		nll10O = ((nlOlil ^ nlOl0l) ^ (~ (nll1ii46 ^ nll1ii45))),
		nll11i = (nlOO0i ^ nlOO1O),
		nll11l = (nlOO0i ^ nlOO1l),
		nll11O = (nlOO1i ^ nlOlOO),
		nll1iO = ((nlOlii ^ nlOl0i) ^ (~ (nll1li44 ^ nll1li43))),
		nlli0i = (((wire_n00ii_o[24] | wire_n00ii_o[16]) | wire_n00ii_o[2]) | (~ (nlli0l24 ^ nlli0l23))),
		nlli1i = (nlOlll ^ nlOlli),
		nlli1l = (wire_niOl_dataout | wire_niOi_dataout),
		nlliii = (nili & (~ nlOOlO)),
		nllili = ((((((((~ n1O) & (~ n1l)) & (~ n1i)) & (~ nlOO)) & (~ nlOl)) & (~ nlOi)) & (~ nllO)) & nlll),
		nllilO = (((((((nlOlll & nlOlli) & nlOliO) & nlOlil) & nlOlii) & nlOl0O) & nlOl0l) & nlOl0i),
		nlliOl = ((((((((~ nlOlll) & nlOlli) & (~ nlOliO)) & nlOlil) & (~ nlOlii)) & (~ nlOl0O)) & (~ nlOl0l)) & (~ nlOl0i)),
		nlliOO = (((n0i & (~ nlll0i)) & nlll1O) & (nlll1i14 ^ nlll1i13)),
		nlll0i = ((((((((~ n1O) & (~ n1l)) & (~ n1i)) & (~ nlOO)) & (~ nlOl)) & (~ nlOi)) & (~ nllO)) & (~ nlll)),
		nlll0l = (((((~ rpmadwidth_tx) & (~ rpma_doublewidth_tx)) & (~ rprbs_sel[0])) & (~ rprbs_sel[1])) & (~ rprbs_sel[2])),
		nlll1O = (((((((nlOlll & nlOlli) & (~ nlOliO)) & nlOlil) & nlOlii) & (~ nlOl0O)) & (~ nlOl0l)) & (~ nlOl0i)),
		nllllO = 1'b1,
		prbs_out = {nlOl1O, nlOl1l, nlOl1i, nlOiOO, nlOiOl, nlOiOi, nlOilO, nlOill, nlOili, nlOiiO, nlOiil, nlOiii, nlOi0O, nlOi0l, nlOi0i, nlOi1O, nlOi1l, nlOi1i, nlO0OO, nlO0Ol};
endmodule //cycloneiv_hssi_tx_digi_prbs_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 139 mux21 168 oper_decoder 2 oper_mux 184 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_tx_digi_enc_chnl_top
	( 
	cascaded_8b10b_en,
	clk,
	d21_5_eq_n,
	d2_2_eq_n,
	disp_out_3b,
	doublewidth,
	dwidth,
	endec,
	enpolinv_tx,
	ge_xaui_sel,
	ib_force_disparity,
	k_det,
	prbs_en,
	pudr,
	r8b10b_enc_ibm_en,
	renbitrev_tx,
	rendec_data_sel_tx,
	renpolinv_tx,
	rensymswap_tx,
	rev_loop_data,
	rev_loopbk,
	rforce_disp,
	rrev_loopbk,
	rst,
	rtxbitslip_en,
	tx_boundary_sel,
	tx_ctl_pre_en,
	tx_ctl_tc,
	tx_ctl_ts,
	tx_data_9_pre_en,
	tx_data_9_tc,
	tx_data_pg,
	tx_data_pre_en,
	tx_data_tc,
	tx_data_ts,
	txd_extend_tc,
	txlp20b) /* synthesis synthesis_clearbox=1 */;
	input   cascaded_8b10b_en;
	input   clk;
	input   d21_5_eq_n;
	input   d2_2_eq_n;
	output   [1:0]  disp_out_3b;
	input   doublewidth;
	input   dwidth;
	input   endec;
	input   enpolinv_tx;
	input   ge_xaui_sel;
	input   ib_force_disparity;
	input   k_det;
	input   prbs_en;
	output   [19:0]  pudr;
	input   r8b10b_enc_ibm_en;
	input   renbitrev_tx;
	input   rendec_data_sel_tx;
	input   renpolinv_tx;
	input   rensymswap_tx;
	input   [19:0]  rev_loop_data;
	input   rev_loopbk;
	input   rforce_disp;
	input   rrev_loopbk;
	input   rst;
	input   rtxbitslip_en;
	input   [4:0]  tx_boundary_sel;
	output   [1:0]  tx_ctl_pre_en;
	input   [1:0]  tx_ctl_tc;
	input   tx_ctl_ts;
	output   [1:0]  tx_data_9_pre_en;
	input   [1:0]  tx_data_9_tc;
	input   [19:0]  tx_data_pg;
	output   [15:0]  tx_data_pre_en;
	input   [15:0]  tx_data_tc;
	input   [7:0]  tx_data_ts;
	input   [1:0]  txd_extend_tc;
	output   [19:0]  txlp20b;

	reg	ni0O0l49;
	reg	ni0O0l50;
	reg	ni0O0O47;
	reg	ni0O0O48;
	reg	ni0Oii45;
	reg	ni0Oii46;
	reg	ni0OiO43;
	reg	ni0OiO44;
	reg	ni0Oli41;
	reg	ni0Oli42;
	reg	ni0Oll39;
	reg	ni0Oll40;
	reg	ni0OlO37;
	reg	ni0OlO38;
	reg	ni0OOi35;
	reg	ni0OOi36;
	reg	ni0OOl33;
	reg	ni0OOl34;
	reg	ni0OOO31;
	reg	ni0OOO32;
	reg	nii00i5;
	reg	nii00i6;
	reg	nii01l7;
	reg	nii01l8;
	reg	nii0ii3;
	reg	nii0ii4;
	reg	nii0iO1;
	reg	nii0iO2;
	reg	nii10i23;
	reg	nii10i24;
	reg	nii10l21;
	reg	nii10l22;
	reg	nii10O19;
	reg	nii10O20;
	reg	nii11i29;
	reg	nii11i30;
	reg	nii11l27;
	reg	nii11l28;
	reg	nii11O25;
	reg	nii11O26;
	reg	nii1ii17;
	reg	nii1ii18;
	reg	nii1il15;
	reg	nii1il16;
	reg	nii1li13;
	reg	nii1li14;
	reg	nii1lO11;
	reg	nii1lO12;
	reg	nii1OO10;
	reg	nii1OO9;
	reg	n01li;
	reg	n01iO_clk_prev;
	wire	wire_n01iO_PRN;
	wire	wire_n01iO_ENA;
	reg	n000i;
	reg	n000l;
	reg	n000O;
	reg	n001i;
	reg	n001l;
	reg	n001O;
	reg	n00ii;
	reg	n00il;
	reg	n00iO;
	reg	n00li;
	reg	n00ll;
	reg	n00lO;
	reg	n00Oi;
	reg	n00Ol;
	reg	n00OO;
	reg	n01ii;
	reg	n01il;
	reg	n01lO;
	reg	n01Oi;
	reg	n01Ol;
	reg	n01OO;
	reg	n0i1i;
	reg	n0i1l;
	reg	n0i1O;
	reg	n0iiO;
	reg	n0ill;
	reg	n0iOl;
	reg	n0iOO;
	reg	n0l0l;
	reg	n0l1i;
	reg	n0l1l;
	reg	n0l1O;
	reg	n0lii;
	reg	n0lil;
	reg	n0liO;
	reg	n0lli;
	reg	n0lll;
	reg	n0llO;
	reg	n0lOi;
	reg	ni00i;
	reg	ni01l;
	reg	ni0ii;
	reg	ni0il;
	reg	ni0iO;
	reg	ni0li;
	reg	ni0ll;
	reg	ni0Ol;
	reg	ni1li;
	reg	ni1ll;
	reg	nii0Oi;
	reg	nii0Ol;
	reg	nii0OO;
	reg	niii0i;
	reg	niii0l;
	reg	niii0O;
	reg	niii1i;
	reg	niii1l;
	reg	niii1O;
	reg	niiiii;
	reg	niiiil;
	reg	niiiiO;
	reg	niiili;
	reg	niiill;
	reg	niiilO;
	reg	niiiOi;
	reg	niiiOl;
	reg	niiiOO;
	reg	niil1i;
	reg	ni0Oi_clk_prev;
	wire	wire_ni0Oi_CLRN;
	wire	wire_ni0Oi_PRN;
	reg	n0i0i;
	reg	n0i0l;
	reg	n0i0O;
	reg	n0iii;
	reg	n0iil;
	reg	n0ili;
	reg	n0ilO;
	reg	n0iOi;
	reg	n0l0i;
	reg	n0l0O;
	reg	ni00l;
	reg	ni00O;
	reg	ni01i;
	reg	ni01O;
	reg	ni0lO;
	reg	ni1lO;
	reg	ni1Oi;
	reg	ni1Ol;
	reg	ni1OO;
	reg	nii1i;
	reg	ni0OO_clk_prev;
	wire	wire_ni0OO_CLRN;
	wire	wire_ni0OO_PRN;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliO1i_dataout;
	wire	wire_nliO1l_dataout;
	wire	wire_nll_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlli0i_dataout;
	wire	wire_nlli0l_dataout;
	wire	wire_nlli1i_dataout;
	wire	wire_nlliiO_dataout;
	wire	wire_nllill_dataout;
	wire	wire_nllilO_dataout;
	wire	wire_nlliOi_dataout;
	wire	wire_nlliOl_dataout;
	wire	wire_nlliOO_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire  [31:0]   wire_nili1O_o;
	wire  [15:0]   wire_nillli_o;
	wire  wire_n010i_o;
	wire  wire_n010l_o;
	wire  wire_n010O_o;
	wire  wire_n011i_o;
	wire  wire_n011l_o;
	wire  wire_n011O_o;
	wire  wire_n1O0i_o;
	wire  wire_n1O0l_o;
	wire  wire_n1O0O_o;
	wire  wire_n1O1l_o;
	wire  wire_n1O1O_o;
	wire  wire_n1Oii_o;
	wire  wire_n1Oil_o;
	wire  wire_n1OiO_o;
	wire  wire_n1Oli_o;
	wire  wire_n1Oll_o;
	wire  wire_n1OlO_o;
	wire  wire_n1OOi_o;
	wire  wire_n1OOl_o;
	wire  wire_n1OOO_o;
	wire  wire_niil0i_o;
	wire  wire_niil0l_o;
	wire  wire_niil0O_o;
	wire  wire_niil1l_o;
	wire  wire_niil1O_o;
	wire  wire_niilii_o;
	wire  wire_niilil_o;
	wire  wire_niiliO_o;
	wire  wire_niilli_o;
	wire  wire_niilll_o;
	wire  wire_niillO_o;
	wire  wire_niilOi_o;
	wire  wire_niilOl_o;
	wire  wire_niilOO_o;
	wire  wire_niiO0i_o;
	wire  wire_niiO0l_o;
	wire  wire_niiO0O_o;
	wire  wire_niiO1i_o;
	wire  wire_niiO1l_o;
	wire  wire_niiO1O_o;
	wire  wire_niiOii_o;
	wire  wire_niiOil_o;
	wire  wire_niiOiO_o;
	wire  wire_niiOli_o;
	wire  wire_niiOll_o;
	wire  wire_niiOlO_o;
	wire  wire_niiOOi_o;
	wire  wire_niiOOl_o;
	wire  wire_niiOOO_o;
	wire  wire_nil00i_o;
	wire  wire_nil01i_o;
	wire  wire_nil01l_o;
	wire  wire_nil01O_o;
	wire  wire_nil0ii_o;
	wire  wire_nil0il_o;
	wire  wire_nil0iO_o;
	wire  wire_nil0li_o;
	wire  wire_nil0ll_o;
	wire  wire_nil0lO_o;
	wire  wire_nil0Oi_o;
	wire  wire_nil0Ol_o;
	wire  wire_nil10i_o;
	wire  wire_nil10l_o;
	wire  wire_nil10O_o;
	wire  wire_nil11i_o;
	wire  wire_nil11l_o;
	wire  wire_nil11O_o;
	wire  wire_nil1ii_o;
	wire  wire_nil1il_o;
	wire  wire_nil1iO_o;
	wire  wire_nil1li_o;
	wire  wire_nil1ll_o;
	wire  wire_nil1lO_o;
	wire  wire_nil1Oi_o;
	wire  wire_nil1Ol_o;
	wire  wire_nil1OO_o;
	wire  wire_nili0i_o;
	wire  wire_nili0l_o;
	wire  wire_nili0O_o;
	wire  wire_nilii_o;
	wire  wire_niliii_o;
	wire  wire_niliil_o;
	wire  wire_niliiO_o;
	wire  wire_nilil_o;
	wire  wire_nilili_o;
	wire  wire_nilill_o;
	wire  wire_nililO_o;
	wire  wire_niliO_o;
	wire  wire_niliOi_o;
	wire  wire_nilli_o;
	wire  wire_nilll_o;
	wire  wire_nillll_o;
	wire  wire_nilllO_o;
	wire  wire_nillO_o;
	wire  wire_nillOi_o;
	wire  wire_nillOl_o;
	wire  wire_nillOO_o;
	wire  wire_nilO1i_o;
	wire  wire_nilO1l_o;
	wire  wire_nilO1O_o;
	wire  wire_nilOi_o;
	wire  wire_nilOl_o;
	wire  wire_nilOO_o;
	wire  wire_niO0i_o;
	wire  wire_niO0l_o;
	wire  wire_niO0O_o;
	wire  wire_niO1i_o;
	wire  wire_niO1l_o;
	wire  wire_niO1O_o;
	wire  wire_niOii_o;
	wire  wire_niOil_o;
	wire  wire_niOiO_o;
	wire  wire_niOli_o;
	wire  wire_niOll_o;
	wire  wire_niOlO_o;
	wire  wire_niOOi_o;
	wire  wire_niOOl_o;
	wire  wire_niOOO_o;
	wire  wire_nl00i_o;
	wire  wire_nl00l_o;
	wire  wire_nl00O_o;
	wire  wire_nl01i_o;
	wire  wire_nl01l_o;
	wire  wire_nl01O_o;
	wire  wire_nl0ii_o;
	wire  wire_nl0il_o;
	wire  wire_nl0iO_o;
	wire  wire_nl0li_o;
	wire  wire_nl0ll_o;
	wire  wire_nl0lO_o;
	wire  wire_nl0Oi_o;
	wire  wire_nl0Ol_o;
	wire  wire_nl0OO_o;
	wire  wire_nl10i_o;
	wire  wire_nl10l_o;
	wire  wire_nl10O_o;
	wire  wire_nl11i_o;
	wire  wire_nl11l_o;
	wire  wire_nl11O_o;
	wire  wire_nl1ii_o;
	wire  wire_nl1il_o;
	wire  wire_nl1iO_o;
	wire  wire_nl1li_o;
	wire  wire_nl1ll_o;
	wire  wire_nl1lO_o;
	wire  wire_nl1Oi_o;
	wire  wire_nl1Ol_o;
	wire  wire_nl1OO_o;
	wire  wire_nli0i_o;
	wire  wire_nli0l_o;
	wire  wire_nli0O_o;
	wire  wire_nli1i_o;
	wire  wire_nli1l_o;
	wire  wire_nli1O_o;
	wire  wire_nliii_o;
	wire  wire_nliil_o;
	wire  wire_nliiO_o;
	wire  wire_nlili_o;
	wire  wire_nlill_o;
	wire  wire_nlilO_o;
	wire  wire_nliOi_o;
	wire  wire_nliOl_o;
	wire  wire_nliOO_o;
	wire  wire_nll0i_o;
	wire  wire_nll0l_o;
	wire  wire_nll0O_o;
	wire  wire_nll1i_o;
	wire  wire_nll1l_o;
	wire  wire_nll1O_o;
	wire  wire_nllii_o;
	wire  wire_nllil_o;
	wire  wire_nlliO_o;
	wire  wire_nllli_o;
	wire  wire_nllll_o;
	wire  wire_nlllO_o;
	wire  wire_nllOi_o;
	wire  wire_nllOl_o;
	wire  wire_nllOO_o;
	wire  wire_nlO0i_o;
	wire  wire_nlO0l_o;
	wire  wire_nlO0O_o;
	wire  wire_nlO1i_o;
	wire  wire_nlO1l_o;
	wire  wire_nlO1O_o;
	wire  ni000i;
	wire  ni000l;
	wire  ni000O;
	wire  ni001i;
	wire  ni001l;
	wire  ni001O;
	wire  ni00ii;
	wire  ni00il;
	wire  ni00iO;
	wire  ni00li;
	wire  ni00ll;
	wire  ni00lO;
	wire  ni00Oi;
	wire  ni00Ol;
	wire  ni00OO;
	wire  ni01il;
	wire  ni01iO;
	wire  ni01li;
	wire  ni01ll;
	wire  ni01lO;
	wire  ni01Oi;
	wire  ni01Ol;
	wire  ni01OO;
	wire  ni0i0i;
	wire  ni0i0l;
	wire  ni0i0O;
	wire  ni0i1i;
	wire  ni0i1l;
	wire  ni0i1O;
	wire  ni0iii;
	wire  ni0iil;
	wire  ni0iiO;
	wire  ni0ili;
	wire  ni0ill;
	wire  ni0ilO;
	wire  ni0iOi;
	wire  ni0iOl;
	wire  ni0iOO;
	wire  ni0l0i;
	wire  ni0l0l;
	wire  ni0l0O;
	wire  ni0l1i;
	wire  ni0l1l;
	wire  ni0l1O;
	wire  ni0lii;
	wire  ni0lil;
	wire  ni0liO;
	wire  ni0lli;
	wire  ni0lll;
	wire  ni0llO;
	wire  ni0lOi;
	wire  ni0lOl;
	wire  ni0lOO;
	wire  ni0O0i;
	wire  ni0O1i;
	wire  ni0O1l;
	wire  ni0O1O;
	wire  ni0Oil;
	wire  nii00O;
	wire  nii1iO;
	wire  nii1Ol;

	initial
		ni0O0l49 = 0;
	always @ ( posedge clk)
		  ni0O0l49 <= ni0O0l50;
	event ni0O0l49_event;
	initial
		#1 ->ni0O0l49_event;
	always @(ni0O0l49_event)
		ni0O0l49 <= {1{1'b1}};
	initial
		ni0O0l50 = 0;
	always @ ( posedge clk)
		  ni0O0l50 <= ni0O0l49;
	initial
		ni0O0O47 = 0;
	always @ ( posedge clk)
		  ni0O0O47 <= ni0O0O48;
	event ni0O0O47_event;
	initial
		#1 ->ni0O0O47_event;
	always @(ni0O0O47_event)
		ni0O0O47 <= {1{1'b1}};
	initial
		ni0O0O48 = 0;
	always @ ( posedge clk)
		  ni0O0O48 <= ni0O0O47;
	initial
		ni0Oii45 = 0;
	always @ ( posedge clk)
		  ni0Oii45 <= ni0Oii46;
	event ni0Oii45_event;
	initial
		#1 ->ni0Oii45_event;
	always @(ni0Oii45_event)
		ni0Oii45 <= {1{1'b1}};
	initial
		ni0Oii46 = 0;
	always @ ( posedge clk)
		  ni0Oii46 <= ni0Oii45;
	initial
		ni0OiO43 = 0;
	always @ ( posedge clk)
		  ni0OiO43 <= ni0OiO44;
	event ni0OiO43_event;
	initial
		#1 ->ni0OiO43_event;
	always @(ni0OiO43_event)
		ni0OiO43 <= {1{1'b1}};
	initial
		ni0OiO44 = 0;
	always @ ( posedge clk)
		  ni0OiO44 <= ni0OiO43;
	initial
		ni0Oli41 = 0;
	always @ ( posedge clk)
		  ni0Oli41 <= ni0Oli42;
	event ni0Oli41_event;
	initial
		#1 ->ni0Oli41_event;
	always @(ni0Oli41_event)
		ni0Oli41 <= {1{1'b1}};
	initial
		ni0Oli42 = 0;
	always @ ( posedge clk)
		  ni0Oli42 <= ni0Oli41;
	initial
		ni0Oll39 = 0;
	always @ ( posedge clk)
		  ni0Oll39 <= ni0Oll40;
	event ni0Oll39_event;
	initial
		#1 ->ni0Oll39_event;
	always @(ni0Oll39_event)
		ni0Oll39 <= {1{1'b1}};
	initial
		ni0Oll40 = 0;
	always @ ( posedge clk)
		  ni0Oll40 <= ni0Oll39;
	initial
		ni0OlO37 = 0;
	always @ ( posedge clk)
		  ni0OlO37 <= ni0OlO38;
	event ni0OlO37_event;
	initial
		#1 ->ni0OlO37_event;
	always @(ni0OlO37_event)
		ni0OlO37 <= {1{1'b1}};
	initial
		ni0OlO38 = 0;
	always @ ( posedge clk)
		  ni0OlO38 <= ni0OlO37;
	initial
		ni0OOi35 = 0;
	always @ ( posedge clk)
		  ni0OOi35 <= ni0OOi36;
	event ni0OOi35_event;
	initial
		#1 ->ni0OOi35_event;
	always @(ni0OOi35_event)
		ni0OOi35 <= {1{1'b1}};
	initial
		ni0OOi36 = 0;
	always @ ( posedge clk)
		  ni0OOi36 <= ni0OOi35;
	initial
		ni0OOl33 = 0;
	always @ ( posedge clk)
		  ni0OOl33 <= ni0OOl34;
	event ni0OOl33_event;
	initial
		#1 ->ni0OOl33_event;
	always @(ni0OOl33_event)
		ni0OOl33 <= {1{1'b1}};
	initial
		ni0OOl34 = 0;
	always @ ( posedge clk)
		  ni0OOl34 <= ni0OOl33;
	initial
		ni0OOO31 = 0;
	always @ ( posedge clk)
		  ni0OOO31 <= ni0OOO32;
	event ni0OOO31_event;
	initial
		#1 ->ni0OOO31_event;
	always @(ni0OOO31_event)
		ni0OOO31 <= {1{1'b1}};
	initial
		ni0OOO32 = 0;
	always @ ( posedge clk)
		  ni0OOO32 <= ni0OOO31;
	initial
		nii00i5 = 0;
	always @ ( posedge clk)
		  nii00i5 <= nii00i6;
	event nii00i5_event;
	initial
		#1 ->nii00i5_event;
	always @(nii00i5_event)
		nii00i5 <= {1{1'b1}};
	initial
		nii00i6 = 0;
	always @ ( posedge clk)
		  nii00i6 <= nii00i5;
	initial
		nii01l7 = 0;
	always @ ( posedge clk)
		  nii01l7 <= nii01l8;
	event nii01l7_event;
	initial
		#1 ->nii01l7_event;
	always @(nii01l7_event)
		nii01l7 <= {1{1'b1}};
	initial
		nii01l8 = 0;
	always @ ( posedge clk)
		  nii01l8 <= nii01l7;
	initial
		nii0ii3 = 0;
	always @ ( posedge clk)
		  nii0ii3 <= nii0ii4;
	event nii0ii3_event;
	initial
		#1 ->nii0ii3_event;
	always @(nii0ii3_event)
		nii0ii3 <= {1{1'b1}};
	initial
		nii0ii4 = 0;
	always @ ( posedge clk)
		  nii0ii4 <= nii0ii3;
	initial
		nii0iO1 = 0;
	always @ ( posedge clk)
		  nii0iO1 <= nii0iO2;
	event nii0iO1_event;
	initial
		#1 ->nii0iO1_event;
	always @(nii0iO1_event)
		nii0iO1 <= {1{1'b1}};
	initial
		nii0iO2 = 0;
	always @ ( posedge clk)
		  nii0iO2 <= nii0iO1;
	initial
		nii10i23 = 0;
	always @ ( posedge clk)
		  nii10i23 <= nii10i24;
	event nii10i23_event;
	initial
		#1 ->nii10i23_event;
	always @(nii10i23_event)
		nii10i23 <= {1{1'b1}};
	initial
		nii10i24 = 0;
	always @ ( posedge clk)
		  nii10i24 <= nii10i23;
	initial
		nii10l21 = 0;
	always @ ( posedge clk)
		  nii10l21 <= nii10l22;
	event nii10l21_event;
	initial
		#1 ->nii10l21_event;
	always @(nii10l21_event)
		nii10l21 <= {1{1'b1}};
	initial
		nii10l22 = 0;
	always @ ( posedge clk)
		  nii10l22 <= nii10l21;
	initial
		nii10O19 = 0;
	always @ ( posedge clk)
		  nii10O19 <= nii10O20;
	event nii10O19_event;
	initial
		#1 ->nii10O19_event;
	always @(nii10O19_event)
		nii10O19 <= {1{1'b1}};
	initial
		nii10O20 = 0;
	always @ ( posedge clk)
		  nii10O20 <= nii10O19;
	initial
		nii11i29 = 0;
	always @ ( posedge clk)
		  nii11i29 <= nii11i30;
	event nii11i29_event;
	initial
		#1 ->nii11i29_event;
	always @(nii11i29_event)
		nii11i29 <= {1{1'b1}};
	initial
		nii11i30 = 0;
	always @ ( posedge clk)
		  nii11i30 <= nii11i29;
	initial
		nii11l27 = 0;
	always @ ( posedge clk)
		  nii11l27 <= nii11l28;
	event nii11l27_event;
	initial
		#1 ->nii11l27_event;
	always @(nii11l27_event)
		nii11l27 <= {1{1'b1}};
	initial
		nii11l28 = 0;
	always @ ( posedge clk)
		  nii11l28 <= nii11l27;
	initial
		nii11O25 = 0;
	always @ ( posedge clk)
		  nii11O25 <= nii11O26;
	event nii11O25_event;
	initial
		#1 ->nii11O25_event;
	always @(nii11O25_event)
		nii11O25 <= {1{1'b1}};
	initial
		nii11O26 = 0;
	always @ ( posedge clk)
		  nii11O26 <= nii11O25;
	initial
		nii1ii17 = 0;
	always @ ( posedge clk)
		  nii1ii17 <= nii1ii18;
	event nii1ii17_event;
	initial
		#1 ->nii1ii17_event;
	always @(nii1ii17_event)
		nii1ii17 <= {1{1'b1}};
	initial
		nii1ii18 = 0;
	always @ ( posedge clk)
		  nii1ii18 <= nii1ii17;
	initial
		nii1il15 = 0;
	always @ ( posedge clk)
		  nii1il15 <= nii1il16;
	event nii1il15_event;
	initial
		#1 ->nii1il15_event;
	always @(nii1il15_event)
		nii1il15 <= {1{1'b1}};
	initial
		nii1il16 = 0;
	always @ ( posedge clk)
		  nii1il16 <= nii1il15;
	initial
		nii1li13 = 0;
	always @ ( posedge clk)
		  nii1li13 <= nii1li14;
	event nii1li13_event;
	initial
		#1 ->nii1li13_event;
	always @(nii1li13_event)
		nii1li13 <= {1{1'b1}};
	initial
		nii1li14 = 0;
	always @ ( posedge clk)
		  nii1li14 <= nii1li13;
	initial
		nii1lO11 = 0;
	always @ ( posedge clk)
		  nii1lO11 <= nii1lO12;
	event nii1lO11_event;
	initial
		#1 ->nii1lO11_event;
	always @(nii1lO11_event)
		nii1lO11 <= {1{1'b1}};
	initial
		nii1lO12 = 0;
	always @ ( posedge clk)
		  nii1lO12 <= nii1lO11;
	initial
		nii1OO10 = 0;
	always @ ( posedge clk)
		  nii1OO10 <= nii1OO9;
	initial
		nii1OO9 = 0;
	always @ ( posedge clk)
		  nii1OO9 <= nii1OO10;
	event nii1OO9_event;
	initial
		#1 ->nii1OO9_event;
	always @(nii1OO9_event)
		nii1OO9 <= {1{1'b1}};
	initial
	begin
		n01li = 0;
	end
	always @ (clk or wire_n01iO_PRN or rst)
	begin
		if (wire_n01iO_PRN == 1'b0) 
		begin
			n01li <= 1;
		end
		else if  (rst == 1'b1) 
		begin
			n01li <= 0;
		end
		else if  (wire_n01iO_ENA == 1'b1) 
		if (clk != n01iO_clk_prev && clk == 1'b1) 
		begin
			n01li <= ni0Oil;
		end
		n01iO_clk_prev <= clk;
	end
	assign
		wire_n01iO_ENA = ((ib_force_disparity & tx_data_9_tc[0]) & (~ n01li)),
		wire_n01iO_PRN = (ni0O0l50 ^ ni0O0l49);
	initial
	begin
		n000i = 0;
		n000l = 0;
		n000O = 0;
		n001i = 0;
		n001l = 0;
		n001O = 0;
		n00ii = 0;
		n00il = 0;
		n00iO = 0;
		n00li = 0;
		n00ll = 0;
		n00lO = 0;
		n00Oi = 0;
		n00Ol = 0;
		n00OO = 0;
		n01ii = 0;
		n01il = 0;
		n01lO = 0;
		n01Oi = 0;
		n01Ol = 0;
		n01OO = 0;
		n0i1i = 0;
		n0i1l = 0;
		n0i1O = 0;
		n0iiO = 0;
		n0ill = 0;
		n0iOl = 0;
		n0iOO = 0;
		n0l0l = 0;
		n0l1i = 0;
		n0l1l = 0;
		n0l1O = 0;
		n0lii = 0;
		n0lil = 0;
		n0liO = 0;
		n0lli = 0;
		n0lll = 0;
		n0llO = 0;
		n0lOi = 0;
		ni00i = 0;
		ni01l = 0;
		ni0ii = 0;
		ni0il = 0;
		ni0iO = 0;
		ni0li = 0;
		ni0ll = 0;
		ni0Ol = 0;
		ni1li = 0;
		ni1ll = 0;
		nii0Oi = 0;
		nii0Ol = 0;
		nii0OO = 0;
		niii0i = 0;
		niii0l = 0;
		niii0O = 0;
		niii1i = 0;
		niii1l = 0;
		niii1O = 0;
		niiiii = 0;
		niiiil = 0;
		niiiiO = 0;
		niiili = 0;
		niiill = 0;
		niiilO = 0;
		niiiOi = 0;
		niiiOl = 0;
		niiiOO = 0;
		niil1i = 0;
	end
	always @ (clk or wire_ni0Oi_PRN or wire_ni0Oi_CLRN)
	begin
		if (wire_ni0Oi_PRN == 1'b0) 
		begin
			n000i <= 1;
			n000l <= 1;
			n000O <= 1;
			n001i <= 1;
			n001l <= 1;
			n001O <= 1;
			n00ii <= 1;
			n00il <= 1;
			n00iO <= 1;
			n00li <= 1;
			n00ll <= 1;
			n00lO <= 1;
			n00Oi <= 1;
			n00Ol <= 1;
			n00OO <= 1;
			n01ii <= 1;
			n01il <= 1;
			n01lO <= 1;
			n01Oi <= 1;
			n01Ol <= 1;
			n01OO <= 1;
			n0i1i <= 1;
			n0i1l <= 1;
			n0i1O <= 1;
			n0iiO <= 1;
			n0ill <= 1;
			n0iOl <= 1;
			n0iOO <= 1;
			n0l0l <= 1;
			n0l1i <= 1;
			n0l1l <= 1;
			n0l1O <= 1;
			n0lii <= 1;
			n0lil <= 1;
			n0liO <= 1;
			n0lli <= 1;
			n0lll <= 1;
			n0llO <= 1;
			n0lOi <= 1;
			ni00i <= 1;
			ni01l <= 1;
			ni0ii <= 1;
			ni0il <= 1;
			ni0iO <= 1;
			ni0li <= 1;
			ni0ll <= 1;
			ni0Ol <= 1;
			ni1li <= 1;
			ni1ll <= 1;
			nii0Oi <= 1;
			nii0Ol <= 1;
			nii0OO <= 1;
			niii0i <= 1;
			niii0l <= 1;
			niii0O <= 1;
			niii1i <= 1;
			niii1l <= 1;
			niii1O <= 1;
			niiiii <= 1;
			niiiil <= 1;
			niiiiO <= 1;
			niiili <= 1;
			niiill <= 1;
			niiilO <= 1;
			niiiOi <= 1;
			niiiOl <= 1;
			niiiOO <= 1;
			niil1i <= 1;
		end
		else if  (wire_ni0Oi_CLRN == 1'b0) 
		begin
			n000i <= 0;
			n000l <= 0;
			n000O <= 0;
			n001i <= 0;
			n001l <= 0;
			n001O <= 0;
			n00ii <= 0;
			n00il <= 0;
			n00iO <= 0;
			n00li <= 0;
			n00ll <= 0;
			n00lO <= 0;
			n00Oi <= 0;
			n00Ol <= 0;
			n00OO <= 0;
			n01ii <= 0;
			n01il <= 0;
			n01lO <= 0;
			n01Oi <= 0;
			n01Ol <= 0;
			n01OO <= 0;
			n0i1i <= 0;
			n0i1l <= 0;
			n0i1O <= 0;
			n0iiO <= 0;
			n0ill <= 0;
			n0iOl <= 0;
			n0iOO <= 0;
			n0l0l <= 0;
			n0l1i <= 0;
			n0l1l <= 0;
			n0l1O <= 0;
			n0lii <= 0;
			n0lil <= 0;
			n0liO <= 0;
			n0lli <= 0;
			n0lll <= 0;
			n0llO <= 0;
			n0lOi <= 0;
			ni00i <= 0;
			ni01l <= 0;
			ni0ii <= 0;
			ni0il <= 0;
			ni0iO <= 0;
			ni0li <= 0;
			ni0ll <= 0;
			ni0Ol <= 0;
			ni1li <= 0;
			ni1ll <= 0;
			nii0Oi <= 0;
			nii0Ol <= 0;
			nii0OO <= 0;
			niii0i <= 0;
			niii0l <= 0;
			niii0O <= 0;
			niii1i <= 0;
			niii1l <= 0;
			niii1O <= 0;
			niiiii <= 0;
			niiiil <= 0;
			niiiiO <= 0;
			niiili <= 0;
			niiill <= 0;
			niiilO <= 0;
			niiiOi <= 0;
			niiiOl <= 0;
			niiiOO <= 0;
			niil1i <= 0;
		end
		else 
		if (clk != ni0Oi_clk_prev && clk == 1'b1) 
		begin
			n000i <= tx_data_tc[3];
			n000l <= tx_data_tc[4];
			n000O <= tx_data_tc[5];
			n001i <= tx_data_tc[0];
			n001l <= tx_data_tc[1];
			n001O <= tx_data_tc[2];
			n00ii <= tx_data_tc[6];
			n00il <= tx_data_tc[7];
			n00iO <= tx_data_tc[8];
			n00li <= tx_data_tc[9];
			n00ll <= tx_data_tc[10];
			n00lO <= tx_data_tc[11];
			n00Oi <= tx_data_tc[12];
			n00Ol <= tx_data_tc[13];
			n00OO <= tx_data_tc[14];
			n01ii <= rev_loopbk;
			n01il <= wire_n01ll_dataout;
			n01lO <= tx_data_9_tc[0];
			n01Oi <= tx_data_9_tc[1];
			n01Ol <= tx_ctl_tc[0];
			n01OO <= tx_ctl_tc[1];
			n0i1i <= tx_data_tc[15];
			n0i1l <= n0lOi;
			n0i1O <= ni1ll;
			n0iiO <= ni01l;
			n0ill <= ni00i;
			n0iOl <= ni0ii;
			n0iOO <= ni0il;
			n0l0l <= ni0Ol;
			n0l1i <= ni0iO;
			n0l1l <= ni0li;
			n0l1O <= ni0ll;
			n0lii <= n0lil;
			n0lil <= rensymswap_tx;
			n0liO <= n0lli;
			n0lli <= renbitrev_tx;
			n0lll <= n0llO;
			n0llO <= (renpolinv_tx & enpolinv_tx);
			n0lOi <= wire_nii1l_dataout;
			ni00i <= wire_niill_dataout;
			ni01l <= wire_niiiO_dataout;
			ni0ii <= wire_niiOl_dataout;
			ni0il <= wire_niiOO_dataout;
			ni0iO <= wire_nil1i_dataout;
			ni0li <= wire_nil1l_dataout;
			ni0ll <= wire_nil1O_dataout;
			ni0Ol <= wire_nil0l_dataout;
			ni1li <= n01ii;
			ni1ll <= wire_nii1O_dataout;
			nii0Oi <= wire_niliO_o;
			nii0Ol <= wire_nilli_o;
			nii0OO <= wire_nilll_o;
			niii0i <= wire_nilOO_o;
			niii0l <= wire_niO1i_o;
			niii0O <= wire_niO1l_o;
			niii1i <= wire_nillO_o;
			niii1l <= wire_nilOi_o;
			niii1O <= wire_nilOl_o;
			niiiii <= wire_niO1O_o;
			niiiil <= wire_niO0i_o;
			niiiiO <= wire_niO0l_o;
			niiili <= wire_niO0O_o;
			niiill <= wire_niOii_o;
			niiilO <= wire_niOil_o;
			niiiOi <= wire_niOiO_o;
			niiiOl <= wire_niOli_o;
			niiiOO <= wire_niOll_o;
			niil1i <= wire_nilil_o;
		end
		ni0Oi_clk_prev <= clk;
	end
	assign
		wire_ni0Oi_CLRN = ((ni0Oii46 ^ ni0Oii45) & (~ rst)),
		wire_ni0Oi_PRN = (ni0O0O48 ^ ni0O0O47);
	initial
	begin
		n0i0i = 0;
		n0i0l = 0;
		n0i0O = 0;
		n0iii = 0;
		n0iil = 0;
		n0ili = 0;
		n0ilO = 0;
		n0iOi = 0;
		n0l0i = 0;
		n0l0O = 0;
		ni00l = 0;
		ni00O = 0;
		ni01i = 0;
		ni01O = 0;
		ni0lO = 0;
		ni1lO = 0;
		ni1Oi = 0;
		ni1Ol = 0;
		ni1OO = 0;
		nii1i = 0;
	end
	always @ (clk or wire_ni0OO_PRN or wire_ni0OO_CLRN)
	begin
		if (wire_ni0OO_PRN == 1'b0) 
		begin
			n0i0i <= 1;
			n0i0l <= 1;
			n0i0O <= 1;
			n0iii <= 1;
			n0iil <= 1;
			n0ili <= 1;
			n0ilO <= 1;
			n0iOi <= 1;
			n0l0i <= 1;
			n0l0O <= 1;
			ni00l <= 1;
			ni00O <= 1;
			ni01i <= 1;
			ni01O <= 1;
			ni0lO <= 1;
			ni1lO <= 1;
			ni1Oi <= 1;
			ni1Ol <= 1;
			ni1OO <= 1;
			nii1i <= 1;
		end
		else if  (wire_ni0OO_CLRN == 1'b0) 
		begin
			n0i0i <= 0;
			n0i0l <= 0;
			n0i0O <= 0;
			n0iii <= 0;
			n0iil <= 0;
			n0ili <= 0;
			n0ilO <= 0;
			n0iOi <= 0;
			n0l0i <= 0;
			n0l0O <= 0;
			ni00l <= 0;
			ni00O <= 0;
			ni01i <= 0;
			ni01O <= 0;
			ni0lO <= 0;
			ni1lO <= 0;
			ni1Oi <= 0;
			ni1Ol <= 0;
			ni1OO <= 0;
			nii1i <= 0;
		end
		else 
		if (clk != ni0OO_clk_prev && clk == 1'b1) 
		begin
			n0i0i <= ni1lO;
			n0i0l <= ni1Oi;
			n0i0O <= ni1Ol;
			n0iii <= ni1OO;
			n0iil <= ni01i;
			n0ili <= ni01O;
			n0ilO <= ni00l;
			n0iOi <= ni00O;
			n0l0i <= ni0lO;
			n0l0O <= nii1i;
			ni00l <= wire_niilO_dataout;
			ni00O <= wire_niiOi_dataout;
			ni01i <= wire_niiil_dataout;
			ni01O <= wire_niili_dataout;
			ni0lO <= wire_nil0i_dataout;
			ni1lO <= wire_nii0i_dataout;
			ni1Oi <= wire_nii0l_dataout;
			ni1Ol <= wire_nii0O_dataout;
			ni1OO <= wire_niiii_dataout;
			nii1i <= wire_nil0O_dataout;
		end
		ni0OO_clk_prev <= clk;
	end
	assign
		wire_ni0OO_CLRN = (ni0Oli42 ^ ni0Oli41),
		wire_ni0OO_PRN = ((ni0OiO44 ^ ni0OiO43) & (~ rst));
	assign		wire_n00i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[11] : wire_ni0l_dataout;
	assign		wire_n00l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[12] : wire_ni0O_dataout;
	assign		wire_n00O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[13] : wire_niii_dataout;
	assign		wire_n01i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[8] : wire_ni1l_dataout;
	assign		wire_n01l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[9] : wire_ni1O_dataout;
	assign		wire_n01ll_dataout = (cascaded_8b10b_en === 1'b1) ? wire_nlli1i_dataout : wire_nl010O_dataout;
	assign		wire_n01O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[10] : wire_ni0i_dataout;
	assign		wire_n0ii_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[14] : wire_niil_dataout;
	assign		wire_n0il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[15] : wire_niiO_dataout;
	and(wire_n0iO_dataout, wire_nili_dataout, ~(nii1Ol));
	and(wire_n0li_dataout, wire_nill_dataout, ~(nii1Ol));
	and(wire_n0ll_dataout, wire_nilO_dataout, ~(nii1Ol));
	and(wire_n0lO_dataout, wire_niOi_dataout, ~(nii1Ol));
	assign		wire_n0O_dataout = (rendec_data_sel_tx === 1'b1) ? tx_ctl_tc[0] : tx_ctl_ts;
	assign		wire_n0O0i_dataout = (ib_force_disparity === 1'b1) ? (((~ n01li) & tx_data_9_tc[0]) | n01il) : wire_n0O0l_dataout;
	or(wire_n0O0l_dataout, wire_n0O0O_dataout, ((rforce_disp & (~ txd_extend_tc[0])) & tx_data_9_tc[0]));
	and(wire_n0O0O_dataout, n01il, ~(((rforce_disp & txd_extend_tc[0]) & tx_data_9_tc[0])));
	assign		wire_n0O1l_dataout = (cascaded_8b10b_en === 1'b1) ? wire_ni10i_dataout : wire_n0O0i_dataout;
	assign		wire_n0O1O_dataout = (cascaded_8b10b_en === 1'b1) ? wire_n0OOi_dataout : wire_nl010O_dataout;
	or(wire_n0Oi_dataout, wire_niOl_dataout, nii1Ol);
	and(wire_n0Ol_dataout, wire_niOO_dataout, ~(nii1Ol));
	or(wire_n0OO_dataout, wire_nl1i_dataout, nii1Ol);
	or(wire_n0OOi_dataout, wire_n0OOl_dataout, ((rforce_disp & (~ txd_extend_tc[1])) & tx_data_9_tc[1]));
	and(wire_n0OOl_dataout, wire_nl010O_dataout, ~(((rforce_disp & txd_extend_tc[1]) & tx_data_9_tc[1])));
	and(wire_n10i_dataout, tx_data_tc[12], rendec_data_sel_tx);
	and(wire_n10l_dataout, tx_data_tc[13], rendec_data_sel_tx);
	and(wire_n10O_dataout, tx_data_tc[14], rendec_data_sel_tx);
	and(wire_n11i_dataout, tx_data_tc[9], rendec_data_sel_tx);
	and(wire_n11l_dataout, tx_data_tc[10], rendec_data_sel_tx);
	and(wire_n11O_dataout, tx_data_tc[11], rendec_data_sel_tx);
	and(wire_n1ii_dataout, tx_data_tc[15], rendec_data_sel_tx);
	assign		wire_n1il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[0] : wire_n0iO_dataout;
	assign		wire_n1iO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[1] : wire_n0li_dataout;
	assign		wire_n1li_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[2] : wire_n0ll_dataout;
	assign		wire_n1ll_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[3] : wire_n0lO_dataout;
	assign		wire_n1lO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[4] : wire_n0Oi_dataout;
	assign		wire_n1Oi_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[5] : wire_n0Ol_dataout;
	assign		wire_n1Ol_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[6] : wire_n0OO_dataout;
	assign		wire_n1OO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[7] : wire_ni1i_dataout;
	and(wire_ni0i_dataout, wire_nl0l_dataout, ~(nii1Ol));
	and(wire_ni0l_dataout, wire_nl0O_dataout, ~(nii1Ol));
	and(wire_ni0O_dataout, wire_nlii_dataout, ~(nii1Ol));
	or(wire_ni10i_dataout, wire_ni10l_dataout, ((rforce_disp & (~ txd_extend_tc[0])) & tx_data_9_tc[0]));
	and(wire_ni10l_dataout, n01il, ~(((rforce_disp & txd_extend_tc[0]) & tx_data_9_tc[0])));
	and(wire_ni1i_dataout, wire_nl1l_dataout, ~(nii1Ol));
	and(wire_ni1l_dataout, wire_nl1O_dataout, ~(nii1Ol));
	and(wire_ni1O_dataout, wire_nl0i_dataout, ~(nii1Ol));
	and(wire_nii_dataout, tx_ctl_tc[1], rendec_data_sel_tx);
	assign		wire_nii0i_dataout = (rtxbitslip_en === 1'b1) ? wire_niil0i_o : wire_niliO_o;
	assign		wire_nii0l_dataout = (rtxbitslip_en === 1'b1) ? wire_niil0l_o : wire_nilli_o;
	assign		wire_nii0O_dataout = (rtxbitslip_en === 1'b1) ? wire_niil0O_o : wire_nilll_o;
	assign		wire_nii1l_dataout = (rtxbitslip_en === 1'b1) ? wire_niil1l_o : wire_nilii_o;
	assign		wire_nii1O_dataout = (rtxbitslip_en === 1'b1) ? wire_niil1O_o : wire_nilil_o;
	and(wire_niii_dataout, wire_nlil_dataout, ~(nii1Ol));
	assign		wire_niiii_dataout = (rtxbitslip_en === 1'b1) ? wire_niilii_o : wire_nillO_o;
	assign		wire_niiil_dataout = (rtxbitslip_en === 1'b1) ? wire_niilil_o : wire_nilOi_o;
	assign		wire_niiiO_dataout = (rtxbitslip_en === 1'b1) ? wire_niiliO_o : wire_nilOl_o;
	and(wire_niil_dataout, wire_nliO_dataout, ~(nii1Ol));
	assign		wire_niili_dataout = (rtxbitslip_en === 1'b1) ? wire_niilli_o : wire_nilOO_o;
	assign		wire_niill_dataout = (rtxbitslip_en === 1'b1) ? wire_niilll_o : wire_niO1i_o;
	assign		wire_niilO_dataout = (rtxbitslip_en === 1'b1) ? wire_niillO_o : wire_niO1l_o;
	and(wire_niiO_dataout, wire_nlli_dataout, ~(nii1Ol));
	assign		wire_niiOi_dataout = (rtxbitslip_en === 1'b1) ? wire_niilOi_o : wire_niO1O_o;
	assign		wire_niiOl_dataout = (rtxbitslip_en === 1'b1) ? wire_niilOl_o : wire_niO0i_o;
	assign		wire_niiOO_dataout = (rtxbitslip_en === 1'b1) ? wire_niilOO_o : wire_niO0l_o;
	assign		wire_nil_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[0] : wire_nli_dataout;
	and(wire_nil00l_dataout, wire_nilOO_o, ~(ni01il));
	and(wire_nil00O_dataout, wire_niO1i_o, ~(ni01il));
	assign		wire_nil0i_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO0i_o : wire_niOiO_o;
	assign		wire_nil0l_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO0l_o : wire_niOli_o;
	assign		wire_nil0O_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO0O_o : wire_niOll_o;
	and(wire_nil0OO_dataout, wire_niOli_o, ~(ni01il));
	assign		wire_nil1i_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO1i_o : wire_niO0O_o;
	assign		wire_nil1l_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO1l_o : wire_niOii_o;
	assign		wire_nil1O_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO1O_o : wire_niOil_o;
	or(wire_nili_dataout, wire_nlOii_dataout, nii1iO);
	and(wire_nili1i_dataout, wire_niOll_o, ~(ni01il));
	and(wire_niliOl_dataout, wire_niO1l_o, ni01iO);
	and(wire_niliOO_dataout, wire_niO1O_o, ni01iO);
	and(wire_nill_dataout, wire_nlOil_dataout, ~(nii1iO));
	and(wire_nill0i_dataout, wire_niOii_o, ni01iO);
	and(wire_nill0l_dataout, wire_niOil_o, ni01iO);
	and(wire_nill0O_dataout, wire_niOiO_o, ni01iO);
	and(wire_nill1i_dataout, wire_niO0i_o, ni01iO);
	and(wire_nill1l_dataout, wire_niO0l_o, ni01iO);
	and(wire_nill1O_dataout, wire_niO0O_o, ni01iO);
	and(wire_nillii_dataout, wire_niOli_o, ni01iO);
	and(wire_nillil_dataout, wire_niOll_o, ni01iO);
	or(wire_nilO_dataout, wire_nlOiO_dataout, nii1iO);
	and(wire_nilO0i_dataout, wire_nilOO_o, ~(ni01li));
	and(wire_nilO0l_dataout, wire_niO1i_o, ~(ni01li));
	and(wire_nilO0O_dataout, wire_niO1l_o, ~(ni01li));
	and(wire_nilOii_dataout, wire_niO1O_o, ~(ni01li));
	and(wire_nilOil_dataout, wire_niO0i_o, ~(ni01li));
	and(wire_nilOiO_dataout, wire_niO0l_o, ~(ni01li));
	and(wire_nilOli_dataout, wire_niO0O_o, ~(ni01li));
	and(wire_nilOll_dataout, wire_niOii_o, ~(ni01li));
	and(wire_nilOlO_dataout, wire_niOil_o, ~(ni01li));
	and(wire_nilOOi_dataout, wire_niOiO_o, ~(ni01li));
	and(wire_nilOOl_dataout, wire_niOli_o, ~(ni01li));
	and(wire_nilOOO_dataout, wire_niOll_o, ~(ni01li));
	assign		wire_niO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[1] : wire_nll_dataout;
	and(wire_niOi_dataout, wire_nlOli_dataout, ~(nii1iO));
	and(wire_niOl_dataout, wire_nlOll_dataout, ~(nii1iO));
	assign		wire_niOlOi_dataout = (((ni00il | ((wire_nl1iii_dataout | ni00ll) | ni00li)) | ni001i) === 1'b1) ? (~ wire_n0O1l_dataout) : wire_n0O1l_dataout;
	and(wire_niOO_dataout, wire_nlOlO_dataout, ~(nii1iO));
	assign		wire_niOOOi_dataout = (ni01OO === 1'b1) ? (~ wire_n1il_dataout) : wire_n1il_dataout;
	assign		wire_niOOOl_dataout = (ni01OO === 1'b1) ? (~ wire_nl1i0O_dataout) : wire_nl1i0O_dataout;
	assign		wire_niOOOO_dataout = (ni01OO === 1'b1) ? (~ wire_nl10OO_dataout) : wire_nl10OO_dataout;
	assign		wire_nl000i_dataout = (ni0i0i === 1'b1) ? (~ wire_n1OO_dataout) : wire_n1OO_dataout;
	assign		wire_nl000l_dataout = (ni0i0i === 1'b1) ? (~ wire_nl01iO_dataout) : wire_nl01iO_dataout;
	and(wire_nl001i_dataout, wire_n1Oi_dataout, ~(ni0i1O));
	assign		wire_nl001l_dataout = (ni0i0i === 1'b1) ? (~ wire_nl001i_dataout) : wire_nl001i_dataout;
	assign		wire_nl001O_dataout = (ni0i0i === 1'b1) ? (~ wire_nl01Ol_dataout) : wire_nl01Ol_dataout;
	assign		wire_nl00ll_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0iii : wire_nil_dataout;
	assign		wire_nl010O_dataout = ((ni0i1i | (wire_n1OO_dataout & ni0i0O)) === 1'b1) ? (~ wire_niOlOi_dataout) : wire_niOlOi_dataout;
	or(wire_nl01iO_dataout, wire_nl01li_dataout, ni0i1O);
	and(wire_nl01li_dataout, (~ ni0i0O), ~(wire_n1OO_dataout));
	assign		wire_nl01Ol_dataout = (ni0i1i === 1'b1) ? (~ wire_n1Ol_dataout) : wire_n1Ol_dataout;
	and(wire_nl0i_dataout, wire_n11i_dataout, ~(nii1iO));
	and(wire_nl0l_dataout, wire_n11l_dataout, ~(nii1iO));
	and(wire_nl0O_dataout, wire_n11O_dataout, ~(nii1iO));
	assign		wire_nl10Ol_dataout = (ni00li === 1'b1) ? (~ wire_n1ll_dataout) : wire_n1ll_dataout;
	assign		wire_nl10OO_dataout = (((wire_n1lO_dataout & (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout))))) | ni00ll) === 1'b1) ? (~ wire_n1li_dataout) : wire_n1li_dataout;
	assign		wire_nl111i_dataout = (ni01OO === 1'b1) ? (~ wire_nl10Ol_dataout) : wire_nl10Ol_dataout;
	assign		wire_nl111l_dataout = (ni01OO === 1'b1) ? (~ ni000O) : ni000O;
	assign		wire_nl111O_dataout = (ni01OO === 1'b1) ? (~ ni001O) : ni001O;
	or(wire_nl1i_dataout, wire_nlOOi_dataout, nii1iO);
	assign		wire_nl1i0O_dataout = (ni00lO === 1'b1) ? (~ wire_n1iO_dataout) : wire_n1iO_dataout;
	assign		wire_nl1iii_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0iii : wire_nil_dataout;
	or(wire_nl1l_dataout, wire_nlOOl_dataout, nii1iO);
	and(wire_nl1O_dataout, wire_nlOOO_dataout, ~(nii1iO));
	and(wire_nli_dataout, wire_n0O_dataout, ~(nii00O));
	assign		wire_nli0il_dataout = (ni0ilO === 1'b1) ? (~ wire_n01i_dataout) : wire_n01i_dataout;
	assign		wire_nli0iO_dataout = (ni0ilO === 1'b1) ? (~ wire_nliO1i_dataout) : wire_nliO1i_dataout;
	assign		wire_nli0li_dataout = (ni0ilO === 1'b1) ? (~ wire_nlilli_dataout) : wire_nlilli_dataout;
	assign		wire_nli0ll_dataout = (ni0ilO === 1'b1) ? (~ wire_nliliO_dataout) : wire_nliliO_dataout;
	assign		wire_nli0lO_dataout = (ni0ilO === 1'b1) ? (~ ni0l1O) : ni0l1O;
	assign		wire_nli0Oi_dataout = (ni0ilO === 1'b1) ? (~ ni0iOO) : ni0iOO;
	assign		wire_nli1il_dataout = (((ni0l0l | ((wire_nliO1l_dataout | ni0lil) | ni0lii)) | ni0iOi) === 1'b1) ? (~ wire_n0O1O_dataout) : wire_n0O1O_dataout;
	and(wire_nlii_dataout, wire_n10i_dataout, ~(nii1iO));
	and(wire_nlil_dataout, wire_n10l_dataout, ~(nii1iO));
	assign		wire_nliliO_dataout = (ni0lii === 1'b1) ? (~ wire_n00i_dataout) : wire_n00i_dataout;
	assign		wire_nlilli_dataout = (((wire_n00l_dataout & (wire_n00i_dataout & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout))))) | ni0lil) === 1'b1) ? (~ wire_n01O_dataout) : wire_n01O_dataout;
	and(wire_nliO_dataout, wire_n10O_dataout, ~(nii1iO));
	assign		wire_nliO1i_dataout = (ni0liO === 1'b1) ? (~ wire_n01l_dataout) : wire_n01l_dataout;
	assign		wire_nliO1l_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0O0i : wire_niO_dataout;
	and(wire_nll_dataout, wire_nii_dataout, ~(nii00O));
	and(wire_nlli_dataout, wire_n1ii_dataout, ~(nii1iO));
	or(wire_nlli0i_dataout, wire_nlli0l_dataout, ni0lOO);
	and(wire_nlli0l_dataout, (~ ni0O1O), ~(wire_n0il_dataout));
	assign		wire_nlli1i_dataout = ((ni0lOi | (wire_n0il_dataout & ni0O1O)) === 1'b1) ? (~ wire_nli1il_dataout) : wire_nli1il_dataout;
	assign		wire_nlliiO_dataout = (ni0lOi === 1'b1) ? (~ wire_n0ii_dataout) : wire_n0ii_dataout;
	and(wire_nllill_dataout, wire_n00O_dataout, ~(ni0lOO));
	assign		wire_nllilO_dataout = (ni0O1i === 1'b1) ? (~ wire_nllill_dataout) : wire_nllill_dataout;
	assign		wire_nlliOi_dataout = (ni0O1i === 1'b1) ? (~ wire_nlliiO_dataout) : wire_nlliiO_dataout;
	assign		wire_nlliOl_dataout = (ni0O1i === 1'b1) ? (~ wire_n0il_dataout) : wire_n0il_dataout;
	assign		wire_nlliOO_dataout = (ni0O1i === 1'b1) ? (~ wire_nlli0i_dataout) : wire_nlli0i_dataout;
	assign		wire_nlll0O_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0O0i : wire_niO_dataout;
	assign		wire_nlOii_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[0] : tx_data_ts[0];
	assign		wire_nlOil_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[1] : tx_data_ts[1];
	assign		wire_nlOiO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[2] : tx_data_ts[2];
	assign		wire_nlOli_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[3] : tx_data_ts[3];
	assign		wire_nlOll_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[4] : tx_data_ts[4];
	assign		wire_nlOlO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[5] : tx_data_ts[5];
	assign		wire_nlOOi_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[6] : tx_data_ts[6];
	assign		wire_nlOOl_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[7] : tx_data_ts[7];
	and(wire_nlOOO_dataout, tx_data_tc[8], rendec_data_sel_tx);
	oper_decoder   nili1O
	( 
	.i({tx_boundary_sel[4:0]}),
	.o(wire_nili1O_o));
	defparam
		nili1O.width_i = 5,
		nili1O.width_o = 32;
	oper_decoder   nillli
	( 
	.i({tx_boundary_sel[3:0]}),
	.o(wire_nillli_o));
	defparam
		nillli.width_i = 4,
		nillli.width_o = 16;
	oper_mux   n010i
	( 
	.data({{4{tx_data_pg[17]}}, rev_loop_data[17], wire_nlliOi_dataout, tx_data_pg[17], wire_nlliOi_dataout, {4{tx_data_pg[17]}}, rev_loop_data[17], tx_data_tc[15], tx_data_pg[17], tx_data_tc[15]}),
	.o(wire_n010i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n010i.width_data = 16,
		n010i.width_sel = 4;
	oper_mux   n010l
	( 
	.data({{4{tx_data_pg[18]}}, rev_loop_data[18], wire_nlliOl_dataout, tx_data_pg[18], wire_nlliOl_dataout, {4{tx_data_pg[18]}}, rev_loop_data[18], tx_ctl_tc[1], tx_data_pg[18], tx_ctl_tc[1]}),
	.o(wire_n010l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n010l.width_data = 16,
		n010l.width_sel = 4;
	oper_mux   n010O
	( 
	.data({{4{tx_data_pg[19]}}, rev_loop_data[19], wire_nlliOO_dataout, tx_data_pg[19], wire_nlliOO_dataout, {4{tx_data_pg[19]}}, rev_loop_data[19], tx_data_9_tc[1], tx_data_pg[19], tx_data_9_tc[1]}),
	.o(wire_n010O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n010O.width_data = 16,
		n010O.width_sel = 4;
	oper_mux   n011i
	( 
	.data({{4{tx_data_pg[14]}}, rev_loop_data[14], wire_nli0lO_dataout, tx_data_pg[14], wire_nli0lO_dataout, {4{tx_data_pg[14]}}, rev_loop_data[14], tx_data_tc[12], tx_data_pg[14], tx_data_tc[12]}),
	.o(wire_n011i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n011i.width_data = 16,
		n011i.width_sel = 4;
	oper_mux   n011l
	( 
	.data({{4{tx_data_pg[15]}}, rev_loop_data[15], wire_nli0Oi_dataout, tx_data_pg[15], wire_nli0Oi_dataout, {4{tx_data_pg[15]}}, rev_loop_data[15], tx_data_tc[13], tx_data_pg[15], tx_data_tc[13]}),
	.o(wire_n011l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n011l.width_data = 16,
		n011l.width_sel = 4;
	oper_mux   n011O
	( 
	.data({{4{tx_data_pg[16]}}, rev_loop_data[16], wire_nllilO_dataout, tx_data_pg[16], wire_nllilO_dataout, {4{tx_data_pg[16]}}, rev_loop_data[16], tx_data_tc[14], tx_data_pg[16], tx_data_tc[14]}),
	.o(wire_n011O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n011O.width_data = 16,
		n011O.width_sel = 4;
	oper_mux   n1O0i
	( 
	.data({{4{tx_data_pg[2]}}, rev_loop_data[2], wire_niOOOO_dataout, tx_data_pg[2], wire_niOOOO_dataout, {4{tx_data_pg[2]}}, rev_loop_data[2], tx_data_tc[2], tx_data_pg[2], tx_data_tc[2]}),
	.o(wire_n1O0i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O0i.width_data = 16,
		n1O0i.width_sel = 4;
	oper_mux   n1O0l
	( 
	.data({{4{tx_data_pg[3]}}, rev_loop_data[3], wire_nl111i_dataout, tx_data_pg[3], wire_nl111i_dataout, {4{tx_data_pg[3]}}, rev_loop_data[3], tx_data_tc[3], tx_data_pg[3], tx_data_tc[3]}),
	.o(wire_n1O0l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O0l.width_data = 16,
		n1O0l.width_sel = 4;
	oper_mux   n1O0O
	( 
	.data({{4{tx_data_pg[4]}}, rev_loop_data[4], wire_nl111l_dataout, tx_data_pg[4], wire_nl111l_dataout, {4{tx_data_pg[4]}}, rev_loop_data[4], tx_data_tc[4], tx_data_pg[4], tx_data_tc[4]}),
	.o(wire_n1O0O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O0O.width_data = 16,
		n1O0O.width_sel = 4;
	oper_mux   n1O1l
	( 
	.data({{4{tx_data_pg[0]}}, rev_loop_data[0], wire_niOOOi_dataout, tx_data_pg[0], wire_niOOOi_dataout, {4{tx_data_pg[0]}}, rev_loop_data[0], tx_data_tc[0], tx_data_pg[0], tx_data_tc[0]}),
	.o(wire_n1O1l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O1l.width_data = 16,
		n1O1l.width_sel = 4;
	oper_mux   n1O1O
	( 
	.data({{4{tx_data_pg[1]}}, rev_loop_data[1], wire_niOOOl_dataout, tx_data_pg[1], wire_niOOOl_dataout, {4{tx_data_pg[1]}}, rev_loop_data[1], tx_data_tc[1], tx_data_pg[1], tx_data_tc[1]}),
	.o(wire_n1O1O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O1O.width_data = 16,
		n1O1O.width_sel = 4;
	oper_mux   n1Oii
	( 
	.data({{4{tx_data_pg[5]}}, rev_loop_data[5], wire_nl111O_dataout, tx_data_pg[5], wire_nl111O_dataout, {4{tx_data_pg[5]}}, rev_loop_data[5], tx_data_tc[5], tx_data_pg[5], tx_data_tc[5]}),
	.o(wire_n1Oii_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oii.width_data = 16,
		n1Oii.width_sel = 4;
	oper_mux   n1Oil
	( 
	.data({{4{tx_data_pg[6]}}, rev_loop_data[6], wire_nl001l_dataout, tx_data_pg[6], wire_nl001l_dataout, {4{tx_data_pg[6]}}, rev_loop_data[6], tx_data_tc[6], tx_data_pg[6], tx_data_tc[6]}),
	.o(wire_n1Oil_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oil.width_data = 16,
		n1Oil.width_sel = 4;
	oper_mux   n1OiO
	( 
	.data({{4{tx_data_pg[7]}}, rev_loop_data[7], wire_nl001O_dataout, tx_data_pg[7], wire_nl001O_dataout, {4{tx_data_pg[7]}}, rev_loop_data[7], tx_data_tc[7], tx_data_pg[7], tx_data_tc[7]}),
	.o(wire_n1OiO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OiO.width_data = 16,
		n1OiO.width_sel = 4;
	oper_mux   n1Oli
	( 
	.data({{4{tx_data_pg[8]}}, rev_loop_data[8], wire_nl000i_dataout, tx_data_pg[8], wire_nl000i_dataout, {4{tx_data_pg[8]}}, rev_loop_data[8], tx_ctl_tc[1], tx_data_pg[8], tx_ctl_tc[0]}),
	.o(wire_n1Oli_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oli.width_data = 16,
		n1Oli.width_sel = 4;
	oper_mux   n1Oll
	( 
	.data({{4{tx_data_pg[9]}}, rev_loop_data[9], wire_nl000l_dataout, tx_data_pg[9], wire_nl000l_dataout, {4{tx_data_pg[9]}}, rev_loop_data[9], tx_data_9_tc[0], tx_data_pg[9], tx_data_9_tc[0]}),
	.o(wire_n1Oll_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oll.width_data = 16,
		n1Oll.width_sel = 4;
	oper_mux   n1OlO
	( 
	.data({{4{tx_data_pg[10]}}, rev_loop_data[10], wire_nli0il_dataout, tx_data_pg[10], wire_nli0il_dataout, {4{tx_data_pg[10]}}, rev_loop_data[10], tx_data_tc[8], tx_data_pg[10], tx_data_tc[8]}),
	.o(wire_n1OlO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OlO.width_data = 16,
		n1OlO.width_sel = 4;
	oper_mux   n1OOi
	( 
	.data({{4{tx_data_pg[11]}}, rev_loop_data[11], wire_nli0iO_dataout, tx_data_pg[11], wire_nli0iO_dataout, {4{tx_data_pg[11]}}, rev_loop_data[11], tx_data_tc[9], tx_data_pg[11], tx_data_tc[9]}),
	.o(wire_n1OOi_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OOi.width_data = 16,
		n1OOi.width_sel = 4;
	oper_mux   n1OOl
	( 
	.data({{4{tx_data_pg[12]}}, rev_loop_data[12], wire_nli0li_dataout, tx_data_pg[12], wire_nli0li_dataout, {4{tx_data_pg[12]}}, rev_loop_data[12], tx_data_tc[10], tx_data_pg[12], tx_data_tc[10]}),
	.o(wire_n1OOl_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OOl.width_data = 16,
		n1OOl.width_sel = 4;
	oper_mux   n1OOO
	( 
	.data({{4{tx_data_pg[13]}}, rev_loop_data[13], wire_nli0ll_dataout, tx_data_pg[13], wire_nli0ll_dataout, {4{tx_data_pg[13]}}, rev_loop_data[13], tx_data_tc[11], tx_data_pg[13], tx_data_tc[11]}),
	.o(wire_n1OOO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OOO.width_data = 16,
		n1OOO.width_sel = 4;
	oper_mux   niil0i
	( 
	.data({wire_niiOiO_o, wire_nil1Ol_o, wire_nili0O_o, wire_nillOi_o}),
	.o(wire_niil0i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil0i.width_data = 4,
		niil0i.width_sel = 2;
	oper_mux   niil0l
	( 
	.data({wire_niiOli_o, wire_nil1OO_o, wire_niliii_o, wire_nillOl_o}),
	.o(wire_niil0l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil0l.width_data = 4,
		niil0l.width_sel = 2;
	oper_mux   niil0O
	( 
	.data({wire_niiOll_o, wire_nil01i_o, wire_niliil_o, wire_nillOO_o}),
	.o(wire_niil0O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil0O.width_data = 4,
		niil0O.width_sel = 2;
	oper_mux   niil1l
	( 
	.data({wire_niiOii_o, wire_nil1lO_o, wire_nili0i_o, wire_nillll_o}),
	.o(wire_niil1l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil1l.width_data = 4,
		niil1l.width_sel = 2;
	oper_mux   niil1O
	( 
	.data({wire_niiOil_o, wire_nil1Oi_o, wire_nili0l_o, wire_nilllO_o}),
	.o(wire_niil1O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil1O.width_data = 4,
		niil1O.width_sel = 2;
	oper_mux   niilii
	( 
	.data({wire_niiOlO_o, wire_nil01l_o, wire_niliiO_o, wire_nilO1i_o}),
	.o(wire_niilii_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilii.width_data = 4,
		niilii.width_sel = 2;
	oper_mux   niilil
	( 
	.data({wire_niiOOi_o, wire_nil01O_o, wire_nilili_o, wire_nilO1l_o}),
	.o(wire_niilil_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilil.width_data = 4,
		niilil.width_sel = 2;
	oper_mux   niiliO
	( 
	.data({wire_niiOOl_o, wire_nil00i_o, wire_nilill_o, wire_nilO1O_o}),
	.o(wire_niiliO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiliO.width_data = 4,
		niiliO.width_sel = 2;
	oper_mux   niilli
	( 
	.data({wire_niiOOO_o, wire_nil00l_dataout, wire_nililO_o, wire_nilO0i_dataout}),
	.o(wire_niilli_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilli.width_data = 4,
		niilli.width_sel = 2;
	oper_mux   niilll
	( 
	.data({wire_nil11i_o, wire_nil00O_dataout, wire_niliOi_o, wire_nilO0l_dataout}),
	.o(wire_niilll_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilll.width_data = 4,
		niilll.width_sel = 2;
	oper_mux   niillO
	( 
	.data({wire_nil11l_o, wire_nil0ii_o, wire_niliOl_dataout, wire_nilO0O_dataout}),
	.o(wire_niillO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niillO.width_data = 4,
		niillO.width_sel = 2;
	oper_mux   niilOi
	( 
	.data({wire_nil11O_o, wire_nil0il_o, wire_niliOO_dataout, wire_nilOii_dataout}),
	.o(wire_niilOi_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilOi.width_data = 4,
		niilOi.width_sel = 2;
	oper_mux   niilOl
	( 
	.data({wire_nil10i_o, wire_nil0iO_o, wire_nill1i_dataout, wire_nilOil_dataout}),
	.o(wire_niilOl_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilOl.width_data = 4,
		niilOl.width_sel = 2;
	oper_mux   niilOO
	( 
	.data({wire_nil10l_o, wire_nil0li_o, wire_nill1l_dataout, wire_nilOiO_dataout}),
	.o(wire_niilOO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilOO.width_data = 4,
		niilOO.width_sel = 2;
	oper_mux   niiO0i
	( 
	.data({wire_nil1iO_o, wire_nil0Ol_o, wire_nill0O_dataout, wire_nilOOi_dataout}),
	.o(wire_niiO0i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO0i.width_data = 4,
		niiO0i.width_sel = 2;
	oper_mux   niiO0l
	( 
	.data({wire_nil1li_o, wire_nil0OO_dataout, wire_nillii_dataout, wire_nilOOl_dataout}),
	.o(wire_niiO0l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO0l.width_data = 4,
		niiO0l.width_sel = 2;
	oper_mux   niiO0O
	( 
	.data({wire_nil1ll_o, wire_nili1i_dataout, wire_nillil_dataout, wire_nilOOO_dataout}),
	.o(wire_niiO0O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO0O.width_data = 4,
		niiO0O.width_sel = 2;
	oper_mux   niiO1i
	( 
	.data({wire_nil10O_o, wire_nil0ll_o, wire_nill1O_dataout, wire_nilOli_dataout}),
	.o(wire_niiO1i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO1i.width_data = 4,
		niiO1i.width_sel = 2;
	oper_mux   niiO1l
	( 
	.data({wire_nil1ii_o, wire_nil0lO_o, wire_nill0i_dataout, wire_nilOll_dataout}),
	.o(wire_niiO1l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO1l.width_data = 4,
		niiO1l.width_sel = 2;
	oper_mux   niiO1O
	( 
	.data({wire_nil1il_o, wire_nil0Oi_o, wire_nill0l_dataout, wire_nilOlO_dataout}),
	.o(wire_niiO1O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO1O.width_data = 4,
		niiO1O.width_sel = 2;
	oper_mux   niiOii
	( 
	.data({{12{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o}),
	.o(wire_niiOii_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOii.width_data = 32,
		niiOii.width_sel = 5;
	oper_mux   niiOil
	( 
	.data({{12{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o}),
	.o(wire_niiOil_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOil.width_data = 32,
		niiOil.width_sel = 5;
	oper_mux   niiOiO
	( 
	.data({{12{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_niiOiO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOiO.width_data = 32,
		niiOiO.width_sel = 5;
	oper_mux   niiOli
	( 
	.data({{12{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_niiOli_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOli.width_data = 32,
		niiOli.width_sel = 5;
	oper_mux   niiOll
	( 
	.data({{12{wire_nilll_o}}, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_niiOll_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOll.width_data = 32,
		niiOll.width_sel = 5;
	oper_mux   niiOlO
	( 
	.data({{12{wire_nillO_o}}, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_niiOlO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOlO.width_data = 32,
		niiOlO.width_sel = 5;
	oper_mux   niiOOi
	( 
	.data({{12{wire_nilOi_o}}, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_niiOOi_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOOi.width_data = 32,
		niiOOi.width_sel = 5;
	oper_mux   niiOOl
	( 
	.data({{12{wire_nilOl_o}}, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_niiOOl_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOOl.width_data = 32,
		niiOOl.width_sel = 5;
	oper_mux   niiOOO
	( 
	.data({{12{wire_nilOO_o}}, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o}),
	.o(wire_niiOOO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOOO.width_data = 32,
		niiOOO.width_sel = 5;
	oper_mux   nil00i
	( 
	.data({{16{wire_nilOl_o}}, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_nil00i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil00i.width_data = 32,
		nil00i.width_sel = 5;
	oper_mux   nil01i
	( 
	.data({{16{wire_nilll_o}}, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_nil01i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil01i.width_data = 32,
		nil01i.width_sel = 5;
	oper_mux   nil01l
	( 
	.data({{16{wire_nillO_o}}, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_nil01l_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil01l.width_data = 32,
		nil01l.width_sel = 5;
	oper_mux   nil01O
	( 
	.data({{16{wire_nilOi_o}}, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_nil01O_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil01O.width_data = 32,
		nil01O.width_sel = 5;
	oper_mux   nil0ii
	( 
	.data({{16{wire_niO1l_o}}, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o}),
	.o(wire_nil0ii_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0ii.width_data = 32,
		nil0ii.width_sel = 5;
	oper_mux   nil0il
	( 
	.data({{16{wire_niO1O_o}}, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o}),
	.o(wire_nil0il_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0il.width_data = 32,
		nil0il.width_sel = 5;
	oper_mux   nil0iO
	( 
	.data({{16{wire_niO0i_o}}, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o}),
	.o(wire_nil0iO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0iO.width_data = 32,
		nil0iO.width_sel = 5;
	oper_mux   nil0li
	( 
	.data({{16{wire_niO0l_o}}, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o}),
	.o(wire_nil0li_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0li.width_data = 32,
		nil0li.width_sel = 5;
	oper_mux   nil0ll
	( 
	.data({{16{wire_niO0O_o}}, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o}),
	.o(wire_nil0ll_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0ll.width_data = 32,
		nil0ll.width_sel = 5;
	oper_mux   nil0lO
	( 
	.data({{16{wire_niOii_o}}, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o}),
	.o(wire_nil0lO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0lO.width_data = 32,
		nil0lO.width_sel = 5;
	oper_mux   nil0Oi
	( 
	.data({{16{wire_niOil_o}}, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o}),
	.o(wire_nil0Oi_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0Oi.width_data = 32,
		nil0Oi.width_sel = 5;
	oper_mux   nil0Ol
	( 
	.data({{16{wire_niOiO_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o}),
	.o(wire_nil0Ol_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0Ol.width_data = 32,
		nil0Ol.width_sel = 5;
	oper_mux   nil10i
	( 
	.data({{12{wire_niO0i_o}}, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o}),
	.o(wire_nil10i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil10i.width_data = 32,
		nil10i.width_sel = 5;
	oper_mux   nil10l
	( 
	.data({{12{wire_niO0l_o}}, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o}),
	.o(wire_nil10l_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil10l.width_data = 32,
		nil10l.width_sel = 5;
	oper_mux   nil10O
	( 
	.data({{12{wire_niO0O_o}}, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o}),
	.o(wire_nil10O_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil10O.width_data = 32,
		nil10O.width_sel = 5;
	oper_mux   nil11i
	( 
	.data({{12{wire_niO1i_o}}, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o}),
	.o(wire_nil11i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil11i.width_data = 32,
		nil11i.width_sel = 5;
	oper_mux   nil11l
	( 
	.data({{12{wire_niO1l_o}}, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o}),
	.o(wire_nil11l_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil11l.width_data = 32,
		nil11l.width_sel = 5;
	oper_mux   nil11O
	( 
	.data({{12{wire_niO1O_o}}, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o}),
	.o(wire_nil11O_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil11O.width_data = 32,
		nil11O.width_sel = 5;
	oper_mux   nil1ii
	( 
	.data({{12{wire_niOii_o}}, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o}),
	.o(wire_nil1ii_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1ii.width_data = 32,
		nil1ii.width_sel = 5;
	oper_mux   nil1il
	( 
	.data({{12{wire_niOil_o}}, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o}),
	.o(wire_nil1il_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1il.width_data = 32,
		nil1il.width_sel = 5;
	oper_mux   nil1iO
	( 
	.data({{12{wire_niOiO_o}}, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o}),
	.o(wire_nil1iO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1iO.width_data = 32,
		nil1iO.width_sel = 5;
	oper_mux   nil1li
	( 
	.data({{12{wire_niOli_o}}, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o, wire_niOli_o}),
	.o(wire_nil1li_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1li.width_data = 32,
		nil1li.width_sel = 5;
	oper_mux   nil1ll
	( 
	.data({{12{wire_niOll_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o, wire_niOli_o, wire_niOll_o}),
	.o(wire_nil1ll_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1ll.width_data = 32,
		nil1ll.width_sel = 5;
	oper_mux   nil1lO
	( 
	.data({{16{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o}),
	.o(wire_nil1lO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1lO.width_data = 32,
		nil1lO.width_sel = 5;
	oper_mux   nil1Oi
	( 
	.data({{16{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o}),
	.o(wire_nil1Oi_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1Oi.width_data = 32,
		nil1Oi.width_sel = 5;
	oper_mux   nil1Ol
	( 
	.data({{16{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_nil1Ol_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1Ol.width_data = 32,
		nil1Ol.width_sel = 5;
	oper_mux   nil1OO
	( 
	.data({{16{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_nil1OO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1OO.width_data = 32,
		nil1OO.width_sel = 5;
	oper_mux   nili0i
	( 
	.data({{6{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o}),
	.o(wire_nili0i_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nili0i.width_data = 16,
		nili0i.width_sel = 4;
	oper_mux   nili0l
	( 
	.data({{6{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o}),
	.o(wire_nili0l_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nili0l.width_data = 16,
		nili0l.width_sel = 4;
	oper_mux   nili0O
	( 
	.data({{6{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_nili0O_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nili0O.width_data = 16,
		nili0O.width_sel = 4;
	oper_mux   nilii
	( 
	.data({wire_niOlO_o, wire_nl01l_o, wire_nliii_o, wire_nlllO_o}),
	.o(wire_nilii_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilii.width_data = 4,
		nilii.width_sel = 2;
	oper_mux   niliii
	( 
	.data({{6{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_niliii_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliii.width_data = 16,
		niliii.width_sel = 4;
	oper_mux   niliil
	( 
	.data({{6{wire_nilll_o}}, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_niliil_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliil.width_data = 16,
		niliil.width_sel = 4;
	oper_mux   niliiO
	( 
	.data({{6{wire_nillO_o}}, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_niliiO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliiO.width_data = 16,
		niliiO.width_sel = 4;
	oper_mux   nilil
	( 
	.data({wire_niOOi_o, wire_nl01O_o, wire_nliil_o, wire_nllOi_o}),
	.o(wire_nilil_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilil.width_data = 4,
		nilil.width_sel = 2;
	oper_mux   nilili
	( 
	.data({{6{wire_nilOi_o}}, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_nilili_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilili.width_data = 16,
		nilili.width_sel = 4;
	oper_mux   nilill
	( 
	.data({{6{wire_nilOl_o}}, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_nilill_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilill.width_data = 16,
		nilill.width_sel = 4;
	oper_mux   nililO
	( 
	.data({{6{wire_nilOO_o}}, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o}),
	.o(wire_nililO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nililO.width_data = 16,
		nililO.width_sel = 4;
	oper_mux   niliO
	( 
	.data({wire_niOOl_o, wire_nl00i_o, wire_nliiO_o, wire_nllOl_o}),
	.o(wire_niliO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niliO.width_data = 4,
		niliO.width_sel = 2;
	oper_mux   niliOi
	( 
	.data({{6{wire_niO1i_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o}),
	.o(wire_niliOi_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliOi.width_data = 16,
		niliOi.width_sel = 4;
	oper_mux   nilli
	( 
	.data({wire_niOOO_o, wire_nl00l_o, wire_nlili_o, wire_nllOO_o}),
	.o(wire_nilli_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilli.width_data = 4,
		nilli.width_sel = 2;
	oper_mux   nilll
	( 
	.data({wire_nl11i_o, wire_nl00O_o, wire_nlill_o, wire_nlO1i_o}),
	.o(wire_nilll_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilll.width_data = 4,
		nilll.width_sel = 2;
	oper_mux   nillll
	( 
	.data({{8{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o}),
	.o(wire_nillll_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillll.width_data = 16,
		nillll.width_sel = 4;
	oper_mux   nilllO
	( 
	.data({{8{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o}),
	.o(wire_nilllO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilllO.width_data = 16,
		nilllO.width_sel = 4;
	oper_mux   nillO
	( 
	.data({wire_nl11l_o, wire_nl0ii_o, wire_nlilO_o, wire_nlO1l_o}),
	.o(wire_nillO_o),
	.sel({doublewidth, dwidth}));
	defparam
		nillO.width_data = 4,
		nillO.width_sel = 2;
	oper_mux   nillOi
	( 
	.data({{8{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_nillOi_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillOi.width_data = 16,
		nillOi.width_sel = 4;
	oper_mux   nillOl
	( 
	.data({{8{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_nillOl_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillOl.width_data = 16,
		nillOl.width_sel = 4;
	oper_mux   nillOO
	( 
	.data({{8{wire_nilll_o}}, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_nillOO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillOO.width_data = 16,
		nillOO.width_sel = 4;
	oper_mux   nilO1i
	( 
	.data({{8{wire_nillO_o}}, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_nilO1i_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilO1i.width_data = 16,
		nilO1i.width_sel = 4;
	oper_mux   nilO1l
	( 
	.data({{8{wire_nilOi_o}}, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_nilO1l_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilO1l.width_data = 16,
		nilO1l.width_sel = 4;
	oper_mux   nilO1O
	( 
	.data({{8{wire_nilOl_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_nilO1O_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilO1O.width_data = 16,
		nilO1O.width_sel = 4;
	oper_mux   nilOi
	( 
	.data({wire_nl11O_o, wire_nl0il_o, wire_nliOi_o, wire_nlO1O_o}),
	.o(wire_nilOi_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOi.width_data = 4,
		nilOi.width_sel = 2;
	oper_mux   nilOl
	( 
	.data({wire_nl10i_o, wire_nl0iO_o, wire_nliOl_o, wire_nlO0i_o}),
	.o(wire_nilOl_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOl.width_data = 4,
		nilOl.width_sel = 2;
	oper_mux   nilOO
	( 
	.data({wire_nl10l_o, wire_nl0li_o, wire_nliOO_o, wire_nlO0l_o}),
	.o(wire_nilOO_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOO.width_data = 4,
		nilOO.width_sel = 2;
	oper_mux   niO0i
	( 
	.data({wire_nl1iO_o, wire_nl0Ol_o, {2{wire_nll0i_o}}}),
	.o(wire_niO0i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0i.width_data = 4,
		niO0i.width_sel = 2;
	oper_mux   niO0l
	( 
	.data({wire_nl1li_o, wire_nl0OO_o, {2{wire_nll0l_o}}}),
	.o(wire_niO0l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0l.width_data = 4,
		niO0l.width_sel = 2;
	oper_mux   niO0O
	( 
	.data({wire_nl1ll_o, wire_nli1i_o, {2{wire_nll0O_o}}}),
	.o(wire_niO0O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0O.width_data = 4,
		niO0O.width_sel = 2;
	oper_mux   niO1i
	( 
	.data({wire_nl10O_o, wire_nl0ll_o, wire_nll1i_o, wire_nlO0O_o}),
	.o(wire_niO1i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1i.width_data = 4,
		niO1i.width_sel = 2;
	oper_mux   niO1l
	( 
	.data({wire_nl1ii_o, wire_nl0lO_o, {2{wire_nll1l_o}}}),
	.o(wire_niO1l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1l.width_data = 4,
		niO1l.width_sel = 2;
	oper_mux   niO1O
	( 
	.data({wire_nl1il_o, wire_nl0Oi_o, {2{wire_nll1O_o}}}),
	.o(wire_niO1O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1O.width_data = 4,
		niO1O.width_sel = 2;
	oper_mux   niOii
	( 
	.data({wire_nl1lO_o, wire_nli1l_o, {2{wire_nllii_o}}}),
	.o(wire_niOii_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOii.width_data = 4,
		niOii.width_sel = 2;
	oper_mux   niOil
	( 
	.data({wire_nl1Oi_o, wire_nli1O_o, {2{wire_nllil_o}}}),
	.o(wire_niOil_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOil.width_data = 4,
		niOil.width_sel = 2;
	oper_mux   niOiO
	( 
	.data({wire_nl1Ol_o, wire_nli0i_o, {2{wire_nlliO_o}}}),
	.o(wire_niOiO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOiO.width_data = 4,
		niOiO.width_sel = 2;
	oper_mux   niOli
	( 
	.data({wire_nl1OO_o, wire_nli0l_o, {2{wire_nllli_o}}}),
	.o(wire_niOli_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOli.width_data = 4,
		niOli.width_sel = 2;
	oper_mux   niOll
	( 
	.data({wire_nl01i_o, wire_nli0O_o, {2{wire_nllll_o}}}),
	.o(wire_niOll_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOll.width_data = 4,
		niOll.width_sel = 2;
	oper_mux   niOlO
	( 
	.data({(~ wire_n1Oll_o), (~ wire_n010O_o), (~ wire_n1OlO_o), (~ wire_n1O1l_o), wire_n1Oll_o, wire_n010O_o, wire_n1OlO_o, wire_n1O1l_o}),
	.o(wire_niOlO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOlO.width_data = 8,
		niOlO.width_sel = 3;
	oper_mux   niOOi
	( 
	.data({(~ wire_n1Oli_o), (~ wire_n010l_o), (~ wire_n1OOi_o), (~ wire_n1O1O_o), wire_n1Oli_o, wire_n010l_o, wire_n1OOi_o, wire_n1O1O_o}),
	.o(wire_niOOi_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOOi.width_data = 8,
		niOOi.width_sel = 3;
	oper_mux   niOOl
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n010i_o), (~ wire_n1OOl_o), (~ wire_n1O0i_o), wire_n1OiO_o, wire_n010i_o, wire_n1OOl_o, wire_n1O0i_o}),
	.o(wire_niOOl_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOOl.width_data = 8,
		niOOl.width_sel = 3;
	oper_mux   niOOO
	( 
	.data({(~ wire_n1Oil_o), (~ wire_n011O_o), (~ wire_n1OOO_o), (~ wire_n1O0l_o), wire_n1Oil_o, wire_n011O_o, wire_n1OOO_o, wire_n1O0l_o}),
	.o(wire_niOOO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOOO.width_data = 8,
		niOOO.width_sel = 3;
	oper_mux   nl00i
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n011l_o), (~ wire_n1OOl_o), (~ wire_n1O0i_o), wire_n1Oii_o, wire_n011l_o, wire_n1OOl_o, wire_n1O0i_o}),
	.o(wire_nl00i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl00i.width_data = 8,
		nl00i.width_sel = 3;
	oper_mux   nl00l
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n011i_o), (~ wire_n1OOO_o), (~ wire_n1O0l_o), wire_n1O0O_o, wire_n011i_o, wire_n1OOO_o, wire_n1O0l_o}),
	.o(wire_nl00l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl00l.width_data = 8,
		nl00l.width_sel = 3;
	oper_mux   nl00O
	( 
	.data({(~ wire_n1O0l_o), (~ wire_n1OOO_o), (~ wire_n011i_o), (~ wire_n1O0O_o), wire_n1O0l_o, wire_n1OOO_o, wire_n011i_o, wire_n1O0O_o}),
	.o(wire_nl00O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl00O.width_data = 8,
		nl00O.width_sel = 3;
	oper_mux   nl01i
	( 
	.data({(~ wire_n1OlO_o), (~ wire_n1O1l_o), (~ wire_n1Oll_o), (~ wire_n010O_o), wire_n1OlO_o, wire_n1O1l_o, wire_n1Oll_o, wire_n010O_o}),
	.o(wire_nl01i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl01i.width_data = 8,
		nl01i.width_sel = 3;
	oper_mux   nl01l
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n010i_o), (~ wire_n1OlO_o), (~ wire_n1O1l_o), wire_n1OiO_o, wire_n010i_o, wire_n1OlO_o, wire_n1O1l_o}),
	.o(wire_nl01l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl01l.width_data = 8,
		nl01l.width_sel = 3;
	oper_mux   nl01O
	( 
	.data({(~ wire_n1Oil_o), (~ wire_n011O_o), (~ wire_n1OOi_o), (~ wire_n1O1O_o), wire_n1Oil_o, wire_n011O_o, wire_n1OOi_o, wire_n1O1O_o}),
	.o(wire_nl01O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl01O.width_data = 8,
		nl01O.width_sel = 3;
	oper_mux   nl0ii
	( 
	.data({(~ wire_n1O0i_o), (~ wire_n1OOl_o), (~ wire_n011l_o), (~ wire_n1Oii_o), wire_n1O0i_o, wire_n1OOl_o, wire_n011l_o, wire_n1Oii_o}),
	.o(wire_nl0ii_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0ii.width_data = 8,
		nl0ii.width_sel = 3;
	oper_mux   nl0il
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1OOi_o), (~ wire_n011O_o), (~ wire_n1Oil_o), wire_n1O1O_o, wire_n1OOi_o, wire_n011O_o, wire_n1Oil_o}),
	.o(wire_nl0il_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0il.width_data = 8,
		nl0il.width_sel = 3;
	oper_mux   nl0iO
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1OlO_o), (~ wire_n010i_o), (~ wire_n1OiO_o), wire_n1O1l_o, wire_n1OlO_o, wire_n010i_o, wire_n1OiO_o}),
	.o(wire_nl0iO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0iO.width_data = 8,
		nl0iO.width_sel = 3;
	oper_mux   nl0li
	( 
	.data({{4{(~ wire_n1Oli_o)}}, {4{wire_n1Oli_o}}}),
	.o(wire_nl0li_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0li.width_data = 8,
		nl0li.width_sel = 3;
	oper_mux   nl0ll
	( 
	.data({{4{(~ wire_n1Oll_o)}}, {4{wire_n1Oll_o}}}),
	.o(wire_nl0ll_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0ll.width_data = 8,
		nl0ll.width_sel = 3;
	oper_mux   nl0lO
	( 
	.data({(~ wire_n010i_o), (~ wire_n1OiO_o), (~ wire_n1O1l_o), (~ wire_n1OlO_o), wire_n010i_o, wire_n1OiO_o, wire_n1O1l_o, wire_n1OlO_o}),
	.o(wire_nl0lO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0lO.width_data = 8,
		nl0lO.width_sel = 3;
	oper_mux   nl0Oi
	( 
	.data({(~ wire_n011O_o), (~ wire_n1Oil_o), (~ wire_n1O1O_o), (~ wire_n1OOi_o), wire_n011O_o, wire_n1Oil_o, wire_n1O1O_o, wire_n1OOi_o}),
	.o(wire_nl0Oi_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0Oi.width_data = 8,
		nl0Oi.width_sel = 3;
	oper_mux   nl0Ol
	( 
	.data({(~ wire_n011l_o), (~ wire_n1Oii_o), (~ wire_n1O0i_o), (~ wire_n1OOl_o), wire_n011l_o, wire_n1Oii_o, wire_n1O0i_o, wire_n1OOl_o}),
	.o(wire_nl0Ol_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0Ol.width_data = 8,
		nl0Ol.width_sel = 3;
	oper_mux   nl0OO
	( 
	.data({(~ wire_n011i_o), (~ wire_n1O0O_o), (~ wire_n1O0l_o), (~ wire_n1OOO_o), wire_n011i_o, wire_n1O0O_o, wire_n1O0l_o, wire_n1OOO_o}),
	.o(wire_nl0OO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0OO.width_data = 8,
		nl0OO.width_sel = 3;
	oper_mux   nl10i
	( 
	.data({(~ wire_n1O0i_o), (~ wire_n1OOl_o), (~ wire_n010i_o), (~ wire_n1OiO_o), wire_n1O0i_o, wire_n1OOl_o, wire_n010i_o, wire_n1OiO_o}),
	.o(wire_nl10i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl10i.width_data = 8,
		nl10i.width_sel = 3;
	oper_mux   nl10l
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1OOi_o), (~ wire_n010l_o), (~ wire_n1Oli_o), wire_n1O1O_o, wire_n1OOi_o, wire_n010l_o, wire_n1Oli_o}),
	.o(wire_nl10l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl10l.width_data = 8,
		nl10l.width_sel = 3;
	oper_mux   nl10O
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1OlO_o), (~ wire_n010O_o), (~ wire_n1Oll_o), wire_n1O1l_o, wire_n1OlO_o, wire_n010O_o, wire_n1Oll_o}),
	.o(wire_nl10O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl10O.width_data = 8,
		nl10O.width_sel = 3;
	oper_mux   nl11i
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n011l_o), (~ wire_n011i_o), (~ wire_n1O0O_o), wire_n1Oii_o, wire_n011l_o, wire_n011i_o, wire_n1O0O_o}),
	.o(wire_nl11i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl11i.width_data = 8,
		nl11i.width_sel = 3;
	oper_mux   nl11l
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n011i_o), (~ wire_n011l_o), (~ wire_n1Oii_o), wire_n1O0O_o, wire_n011i_o, wire_n011l_o, wire_n1Oii_o}),
	.o(wire_nl11l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl11l.width_data = 8,
		nl11l.width_sel = 3;
	oper_mux   nl11O
	( 
	.data({(~ wire_n1O0l_o), (~ wire_n1OOO_o), (~ wire_n011O_o), (~ wire_n1Oil_o), wire_n1O0l_o, wire_n1OOO_o, wire_n011O_o, wire_n1Oil_o}),
	.o(wire_nl11O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl11O.width_data = 8,
		nl11O.width_sel = 3;
	oper_mux   nl1ii
	( 
	.data({(~ wire_n010O_o), (~ wire_n1Oll_o), (~ wire_n1O1l_o), (~ wire_n1OlO_o), wire_n010O_o, wire_n1Oll_o, wire_n1O1l_o, wire_n1OlO_o}),
	.o(wire_nl1ii_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1ii.width_data = 8,
		nl1ii.width_sel = 3;
	oper_mux   nl1il
	( 
	.data({(~ wire_n010l_o), (~ wire_n1Oli_o), (~ wire_n1O1O_o), (~ wire_n1OOi_o), wire_n010l_o, wire_n1Oli_o, wire_n1O1O_o, wire_n1OOi_o}),
	.o(wire_nl1il_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1il.width_data = 8,
		nl1il.width_sel = 3;
	oper_mux   nl1iO
	( 
	.data({(~ wire_n010i_o), (~ wire_n1OiO_o), (~ wire_n1O0i_o), (~ wire_n1OOl_o), wire_n010i_o, wire_n1OiO_o, wire_n1O0i_o, wire_n1OOl_o}),
	.o(wire_nl1iO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1iO.width_data = 8,
		nl1iO.width_sel = 3;
	oper_mux   nl1li
	( 
	.data({(~ wire_n011O_o), (~ wire_n1Oil_o), (~ wire_n1O0l_o), (~ wire_n1OOO_o), wire_n011O_o, wire_n1Oil_o, wire_n1O0l_o, wire_n1OOO_o}),
	.o(wire_nl1li_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1li.width_data = 8,
		nl1li.width_sel = 3;
	oper_mux   nl1ll
	( 
	.data({(~ wire_n011l_o), (~ wire_n1Oii_o), (~ wire_n1O0O_o), (~ wire_n011i_o), wire_n011l_o, wire_n1Oii_o, wire_n1O0O_o, wire_n011i_o}),
	.o(wire_nl1ll_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1ll.width_data = 8,
		nl1ll.width_sel = 3;
	oper_mux   nl1lO
	( 
	.data({(~ wire_n011i_o), (~ wire_n1O0O_o), (~ wire_n1Oii_o), (~ wire_n011l_o), wire_n011i_o, wire_n1O0O_o, wire_n1Oii_o, wire_n011l_o}),
	.o(wire_nl1lO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1lO.width_data = 8,
		nl1lO.width_sel = 3;
	oper_mux   nl1Oi
	( 
	.data({(~ wire_n1OOO_o), (~ wire_n1O0l_o), (~ wire_n1Oil_o), (~ wire_n011O_o), wire_n1OOO_o, wire_n1O0l_o, wire_n1Oil_o, wire_n011O_o}),
	.o(wire_nl1Oi_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1Oi.width_data = 8,
		nl1Oi.width_sel = 3;
	oper_mux   nl1Ol
	( 
	.data({(~ wire_n1OOl_o), (~ wire_n1O0i_o), (~ wire_n1OiO_o), (~ wire_n010i_o), wire_n1OOl_o, wire_n1O0i_o, wire_n1OiO_o, wire_n010i_o}),
	.o(wire_nl1Ol_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1Ol.width_data = 8,
		nl1Ol.width_sel = 3;
	oper_mux   nl1OO
	( 
	.data({(~ wire_n1OOi_o), (~ wire_n1O1O_o), (~ wire_n1Oli_o), (~ wire_n010l_o), wire_n1OOi_o, wire_n1O1O_o, wire_n1Oli_o, wire_n010l_o}),
	.o(wire_nl1OO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1OO.width_data = 8,
		nl1OO.width_sel = 3;
	oper_mux   nli0i
	( 
	.data({(~ wire_n1OlO_o), (~ wire_n1O1l_o), (~ wire_n1OiO_o), (~ wire_n010i_o), wire_n1OlO_o, wire_n1O1l_o, wire_n1OiO_o, wire_n010i_o}),
	.o(wire_nli0i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli0i.width_data = 8,
		nli0i.width_sel = 3;
	oper_mux   nli0l
	( 
	.data({{4{(~ wire_n010l_o)}}, {4{wire_n010l_o}}}),
	.o(wire_nli0l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli0l.width_data = 8,
		nli0l.width_sel = 3;
	oper_mux   nli0O
	( 
	.data({{4{(~ wire_n010O_o)}}, {4{wire_n010O_o}}}),
	.o(wire_nli0O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli0O.width_data = 8,
		nli0O.width_sel = 3;
	oper_mux   nli1i
	( 
	.data({(~ wire_n1OOO_o), (~ wire_n1O0l_o), (~ wire_n1O0O_o), (~ wire_n011i_o), wire_n1OOO_o, wire_n1O0l_o, wire_n1O0O_o, wire_n011i_o}),
	.o(wire_nli1i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli1i.width_data = 8,
		nli1i.width_sel = 3;
	oper_mux   nli1l
	( 
	.data({(~ wire_n1OOl_o), (~ wire_n1O0i_o), (~ wire_n1Oii_o), (~ wire_n011l_o), wire_n1OOl_o, wire_n1O0i_o, wire_n1Oii_o, wire_n011l_o}),
	.o(wire_nli1l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli1l.width_data = 8,
		nli1l.width_sel = 3;
	oper_mux   nli1O
	( 
	.data({(~ wire_n1OOi_o), (~ wire_n1O1O_o), (~ wire_n1Oil_o), (~ wire_n011O_o), wire_n1OOi_o, wire_n1O1O_o, wire_n1Oil_o, wire_n011O_o}),
	.o(wire_nli1O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli1O.width_data = 8,
		nli1O.width_sel = 3;
	oper_mux   nliii
	( 
	.data({(~ wire_n1Oll_o), (~ wire_n1O1l_o), wire_n1Oll_o, wire_n1O1l_o}),
	.o(wire_nliii_o),
	.sel({n0lll, n0liO}));
	defparam
		nliii.width_data = 4,
		nliii.width_sel = 2;
	oper_mux   nliil
	( 
	.data({(~ wire_n1Oli_o), (~ wire_n1O1O_o), wire_n1Oli_o, wire_n1O1O_o}),
	.o(wire_nliil_o),
	.sel({n0lll, n0liO}));
	defparam
		nliil.width_data = 4,
		nliil.width_sel = 2;
	oper_mux   nliiO
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n1O0i_o), wire_n1OiO_o, wire_n1O0i_o}),
	.o(wire_nliiO_o),
	.sel({n0lll, n0liO}));
	defparam
		nliiO.width_data = 4,
		nliiO.width_sel = 2;
	oper_mux   nlili
	( 
	.data({(~ wire_n1Oil_o), (~ wire_n1O0l_o), wire_n1Oil_o, wire_n1O0l_o}),
	.o(wire_nlili_o),
	.sel({n0lll, n0liO}));
	defparam
		nlili.width_data = 4,
		nlili.width_sel = 2;
	oper_mux   nlill
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n1O0O_o), wire_n1Oii_o, wire_n1O0O_o}),
	.o(wire_nlill_o),
	.sel({n0lll, n0liO}));
	defparam
		nlill.width_data = 4,
		nlill.width_sel = 2;
	oper_mux   nlilO
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n1Oii_o), wire_n1O0O_o, wire_n1Oii_o}),
	.o(wire_nlilO_o),
	.sel({n0lll, n0liO}));
	defparam
		nlilO.width_data = 4,
		nlilO.width_sel = 2;
	oper_mux   nliOi
	( 
	.data({(~ wire_n1O0l_o), (~ wire_n1Oil_o), wire_n1O0l_o, wire_n1Oil_o}),
	.o(wire_nliOi_o),
	.sel({n0lll, n0liO}));
	defparam
		nliOi.width_data = 4,
		nliOi.width_sel = 2;
	oper_mux   nliOl
	( 
	.data({(~ wire_n1O0i_o), (~ wire_n1OiO_o), wire_n1O0i_o, wire_n1OiO_o}),
	.o(wire_nliOl_o),
	.sel({n0lll, n0liO}));
	defparam
		nliOl.width_data = 4,
		nliOl.width_sel = 2;
	oper_mux   nliOO
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1Oli_o), wire_n1O1O_o, wire_n1Oli_o}),
	.o(wire_nliOO_o),
	.sel({n0lll, n0liO}));
	defparam
		nliOO.width_data = 4,
		nliOO.width_sel = 2;
	oper_mux   nll0i
	( 
	.data({{2{(~ wire_n1OOl_o)}}, {2{wire_n1OOl_o}}}),
	.o(wire_nll0i_o),
	.sel({n0lll, n0liO}));
	defparam
		nll0i.width_data = 4,
		nll0i.width_sel = 2;
	oper_mux   nll0l
	( 
	.data({{2{(~ wire_n1OOO_o)}}, {2{wire_n1OOO_o}}}),
	.o(wire_nll0l_o),
	.sel({n0lll, n0liO}));
	defparam
		nll0l.width_data = 4,
		nll0l.width_sel = 2;
	oper_mux   nll0O
	( 
	.data({{2{(~ wire_n011i_o)}}, {2{wire_n011i_o}}}),
	.o(wire_nll0O_o),
	.sel({n0lll, n0liO}));
	defparam
		nll0O.width_data = 4,
		nll0O.width_sel = 2;
	oper_mux   nll1i
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1Oll_o), wire_n1O1l_o, wire_n1Oll_o}),
	.o(wire_nll1i_o),
	.sel({n0lll, n0liO}));
	defparam
		nll1i.width_data = 4,
		nll1i.width_sel = 2;
	oper_mux   nll1l
	( 
	.data({{2{(~ wire_n1OlO_o)}}, {2{wire_n1OlO_o}}}),
	.o(wire_nll1l_o),
	.sel({n0lll, n0liO}));
	defparam
		nll1l.width_data = 4,
		nll1l.width_sel = 2;
	oper_mux   nll1O
	( 
	.data({{2{(~ wire_n1OOi_o)}}, {2{wire_n1OOi_o}}}),
	.o(wire_nll1O_o),
	.sel({n0lll, n0liO}));
	defparam
		nll1O.width_data = 4,
		nll1O.width_sel = 2;
	oper_mux   nllii
	( 
	.data({{2{(~ wire_n011l_o)}}, {2{wire_n011l_o}}}),
	.o(wire_nllii_o),
	.sel({n0lll, n0liO}));
	defparam
		nllii.width_data = 4,
		nllii.width_sel = 2;
	oper_mux   nllil
	( 
	.data({{2{(~ wire_n011O_o)}}, {2{wire_n011O_o}}}),
	.o(wire_nllil_o),
	.sel({n0lll, n0liO}));
	defparam
		nllil.width_data = 4,
		nllil.width_sel = 2;
	oper_mux   nlliO
	( 
	.data({((ni0Oll40 ^ ni0Oll39) & (~ wire_n010i_o)), (~ wire_n010i_o), wire_n010i_o, ((ni0OlO38 ^ ni0OlO37) & wire_n010i_o)}),
	.o(wire_nlliO_o),
	.sel({n0lll, n0liO}));
	defparam
		nlliO.width_data = 4,
		nlliO.width_sel = 2;
	oper_mux   nllli
	( 
	.data({(~ wire_n010l_o), ((ni0OOi36 ^ ni0OOi35) & (~ wire_n010l_o)), {2{wire_n010l_o}}}),
	.o(wire_nllli_o),
	.sel({n0lll, n0liO}));
	defparam
		nllli.width_data = 4,
		nllli.width_sel = 2;
	oper_mux   nllll
	( 
	.data({{2{(~ wire_n010O_o)}}, {2{wire_n010O_o}}}),
	.o(wire_nllll_o),
	.sel({n0lll, n0liO}));
	defparam
		nllll.width_data = 4,
		nllll.width_sel = 2;
	oper_mux   nlllO
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n1O1l_o), wire_n1OiO_o, wire_n1O1l_o}),
	.o(wire_nlllO_o),
	.sel({n0lll, n0liO}));
	defparam
		nlllO.width_data = 4,
		nlllO.width_sel = 2;
	oper_mux   nllOi
	( 
	.data({(~ wire_n1Oil_o), ((ni0OOl34 ^ ni0OOl33) & (~ wire_n1O1O_o)), wire_n1Oil_o, wire_n1O1O_o}),
	.o(wire_nllOi_o),
	.sel({n0lll, n0liO}));
	defparam
		nllOi.width_data = 4,
		nllOi.width_sel = 2;
	oper_mux   nllOl
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n1O0i_o), wire_n1Oii_o, wire_n1O0i_o}),
	.o(wire_nllOl_o),
	.sel({n0lll, n0liO}));
	defparam
		nllOl.width_data = 4,
		nllOl.width_sel = 2;
	oper_mux   nllOO
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n1O0l_o), wire_n1O0O_o, ((ni0OOO32 ^ ni0OOO31) & wire_n1O0l_o)}),
	.o(wire_nllOO_o),
	.sel({n0lll, n0liO}));
	defparam
		nllOO.width_data = 4,
		nllOO.width_sel = 2;
	oper_mux   nlO0i
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1OiO_o), wire_n1O1l_o, wire_n1OiO_o}),
	.o(wire_nlO0i_o),
	.sel({n0lll, ((nii10l22 ^ nii10l21) & n0liO)}));
	defparam
		nlO0i.width_data = 4,
		nlO0i.width_sel = 2;
	oper_mux   nlO0l
	( 
	.data({((nii10O20 ^ nii10O19) & (~ wire_n1Oli_o)), (~ wire_n1Oli_o), {2{wire_n1Oli_o}}}),
	.o(wire_nlO0l_o),
	.sel({((nii1ii18 ^ nii1ii17) & n0lll), n0liO}));
	defparam
		nlO0l.width_data = 4,
		nlO0l.width_sel = 2;
	oper_mux   nlO0O
	( 
	.data({{2{(~ wire_n1Oll_o)}}, ((nii1il16 ^ nii1il15) & wire_n1Oll_o), wire_n1Oll_o}),
	.o(wire_nlO0O_o),
	.sel({n0lll, n0liO}));
	defparam
		nlO0O.width_data = 4,
		nlO0O.width_sel = 2;
	oper_mux   nlO1i
	( 
	.data({((nii11i30 ^ nii11i29) & (~ wire_n1O0l_o)), (~ wire_n1O0O_o), wire_n1O0l_o, wire_n1O0O_o}),
	.o(wire_nlO1i_o),
	.sel({n0lll, n0liO}));
	defparam
		nlO1i.width_data = 4,
		nlO1i.width_sel = 2;
	oper_mux   nlO1l
	( 
	.data({(~ wire_n1O0i_o), ((nii11l28 ^ nii11l27) & (~ wire_n1Oii_o)), ((nii11O26 ^ nii11O25) & wire_n1O0i_o), wire_n1Oii_o}),
	.o(wire_nlO1l_o),
	.sel({n0lll, n0liO}));
	defparam
		nlO1l.width_data = 4,
		nlO1l.width_sel = 2;
	oper_mux   nlO1O
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1Oil_o), wire_n1O1O_o, wire_n1Oil_o}),
	.o(wire_nlO1O_o),
	.sel({((nii10i24 ^ nii10i23) & n0lll), n0liO}));
	defparam
		nlO1O.width_data = 4,
		nlO1O.width_sel = 2;
	assign
		disp_out_3b = {wire_nlli1i_dataout, wire_nl010O_dataout},
		ni000i = (((((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01ll)) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01ll))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & wire_n1il_dataout)))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & (~ wire_n1il_dataout))))),
		ni000l = (((((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01Ol))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01Oi))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01Ol))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01Oi))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout))))),
		ni000O = (ni00il | (wire_n1lO_dataout & ni00ii)),
		ni001i = (wire_n1lO_dataout & ((wire_n1ll_dataout & ni00iO) | ni000i)),
		ni001l = (wire_nl1iii_dataout & ni000l),
		ni001O = ((((~ wire_n1lO_dataout) | wire_nl1iii_dataout) & ni000l) | (wire_n1lO_dataout & (((~ ni000i) & (~ ni000l)) & ni00ii))),
		ni00ii = ((~ wire_n1ll_dataout) | (wire_n1li_dataout | (wire_n1iO_dataout | wire_n1il_dataout))),
		ni00il = ((~ wire_n1lO_dataout) & ni00iO),
		ni00iO = (((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & (~ wire_n1il_dataout))))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01lO))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01lO))),
		ni00li = (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & wire_n1il_dataout))),
		ni00ll = ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)))),
		ni00lO = (ni00li | ni00ll),
		ni00Oi = ((((wire_n1lO_dataout & wire_n1ll_dataout) & wire_n1li_dataout) & (~ wire_n1iO_dataout)) & (~ wire_n1il_dataout)),
		ni00Ol = (wire_n1iO_dataout & wire_n1il_dataout),
		ni00OO = ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)),
		ni01il = ((((((((((((((wire_nili1O_o[15] | wire_nili1O_o[14]) | wire_nili1O_o[13]) | wire_nili1O_o[12]) | wire_nili1O_o[11]) | wire_nili1O_o[10]) | wire_nili1O_o[9]) | wire_nili1O_o[8]) | wire_nili1O_o[7]) | wire_nili1O_o[6]) | wire_nili1O_o[5]) | wire_nili1O_o[4]) | wire_nili1O_o[3]) | wire_nili1O_o[2]) | wire_nili1O_o[1]),
		ni01iO = ((((((wire_nillli_o[15] | wire_nillli_o[14]) | wire_nillli_o[13]) | wire_nillli_o[12]) | wire_nillli_o[11]) | wire_nillli_o[10]) | wire_nillli_o[0]),
		ni01li = ((((((wire_nillli_o[7] | wire_nillli_o[6]) | wire_nillli_o[5]) | wire_nillli_o[4]) | wire_nillli_o[3]) | wire_nillli_o[2]) | wire_nillli_o[1]),
		ni01ll = (wire_n1iO_dataout & wire_n1il_dataout),
		ni01lO = ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)),
		ni01Oi = (wire_n1iO_dataout & (~ wire_n1il_dataout)),
		ni01Ol = ((~ wire_n1iO_dataout) & wire_n1il_dataout),
		ni01OO = (((((((~ wire_n1ll_dataout) & (wire_n1li_dataout & (wire_n1iO_dataout & wire_n1il_dataout))) | (wire_n1lO_dataout & ni00ll)) | (wire_n1lO_dataout & ni00li)) | (wire_n1lO_dataout & ni000i)) | ni001l) ^ ((~ wire_n0O1l_dataout) & (ni001l | ((ni00lO | ((~ wire_n1lO_dataout) & (((~ wire_n1ll_dataout) & ni000i) | ni00iO))) | ni001i)))),
		ni0i0i = ((((~ wire_niOlOi_dataout) & (wire_nl00ll_dataout & (~ ni0i0O))) | ni0i0l) ^ ((~ wire_niOlOi_dataout) & ni0i0O)),
		ni0i0l = (wire_n1Ol_dataout & wire_n1Oi_dataout),
		ni0i0O = (ni0i0l | ni0i1l),
		ni0i1i = ((~ wire_n1OO_dataout) & ni0i1l),
		ni0i1l = ((~ wire_n1Ol_dataout) & (~ wire_n1Oi_dataout)),
		ni0i1O = (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_n1Oi_dataout & ((((~ wire_niOlOi_dataout) & ((wire_n1lO_dataout & (~ wire_n1ll_dataout)) & (((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & (~ wire_n1il_dataout))))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni00OO))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni00OO))))) | (wire_niOlOi_dataout & (((~ wire_n1lO_dataout) & wire_n1ll_dataout) & (((((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni00Ol)) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni00Ol))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & wire_n1il_dataout)))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & (~ wire_n1il_dataout)))))))) | (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_nil_dataout & wire_n1Oi_dataout))))))),
		ni0iii = (wire_nil_dataout & ni00Oi),
		ni0iil = (wire_n01l_dataout & wire_n01i_dataout),
		ni0iiO = ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)),
		ni0ili = (wire_n01l_dataout & (~ wire_n01i_dataout)),
		ni0ill = ((~ wire_n01l_dataout) & wire_n01i_dataout),
		ni0ilO = (((((((~ wire_n00i_dataout) & (wire_n01O_dataout & (wire_n01l_dataout & wire_n01i_dataout))) | (wire_n00l_dataout & ni0lil)) | (wire_n00l_dataout & ni0lii)) | (wire_n00l_dataout & ni0l1i)) | ni0iOl) ^ ((~ wire_n0O1O_dataout) & (ni0iOl | ((ni0liO | ((~ wire_n00l_dataout) & (((~ wire_n00i_dataout) & ni0l1i) | ni0l0O))) | ni0iOi)))),
		ni0iOi = (wire_n00l_dataout & ((wire_n00i_dataout & ni0l0O) | ni0l1i)),
		ni0iOl = (wire_nliO1l_dataout & ni0l1l),
		ni0iOO = ((((~ wire_n00l_dataout) | wire_nliO1l_dataout) & ni0l1l) | (wire_n00l_dataout & (((~ ni0l1i) & (~ ni0l1l)) & ni0l0i))),
		ni0l0i = ((~ wire_n00i_dataout) | (wire_n01O_dataout | (wire_n01l_dataout | wire_n01i_dataout))),
		ni0l0l = ((~ wire_n00l_dataout) & ni0l0O),
		ni0l0O = (((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & (~ wire_n01i_dataout))))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0iiO))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0iiO))),
		ni0l1i = (((((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0iil)) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0iil))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & wire_n01i_dataout)))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & (~ wire_n01i_dataout))))),
		ni0l1l = (((((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0ill))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0ili))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0ill))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0ili))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout))))),
		ni0l1O = (ni0l0l | (wire_n00l_dataout & ni0l0i)),
		ni0lii = (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & wire_n01i_dataout))),
		ni0lil = ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)))),
		ni0liO = (ni0lii | ni0lil),
		ni0lli = ((((wire_n00l_dataout & wire_n00i_dataout) & wire_n01O_dataout) & (~ wire_n01l_dataout)) & (~ wire_n01i_dataout)),
		ni0lll = (wire_n01l_dataout & wire_n01i_dataout),
		ni0llO = ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)),
		ni0lOi = ((~ wire_n0il_dataout) & ni0lOl),
		ni0lOl = ((~ wire_n0ii_dataout) & (~ wire_n00O_dataout)),
		ni0lOO = (wire_n0il_dataout & (wire_n0ii_dataout & (wire_n00O_dataout & ((((~ wire_nli1il_dataout) & ((wire_n00l_dataout & (~ wire_n00i_dataout)) & (((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & (~ wire_n01i_dataout))))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0llO))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0llO))))) | (wire_nli1il_dataout & (((~ wire_n00l_dataout) & wire_n00i_dataout) & (((((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0lll)) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0lll))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & wire_n01i_dataout)))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & (~ wire_n01i_dataout)))))))) | (wire_n0il_dataout & (wire_n0ii_dataout & (wire_niO_dataout & wire_n00O_dataout))))))),
		ni0O0i = (wire_niO_dataout & ni0lli),
		ni0O1i = ((((~ wire_nli1il_dataout) & (wire_nlll0O_dataout & (~ ni0O1O))) | ni0O1l) ^ ((~ wire_nli1il_dataout) & ni0O1O)),
		ni0O1l = (wire_n0ii_dataout & wire_n00O_dataout),
		ni0O1O = (ni0O1l | ni0lOl),
		ni0Oil = 1'b1,
		nii00O = ((((((d21_5_eq_n & d2_2_eq_n) & (nii0iO2 ^ nii0iO1)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & (nii0ii4 ^ nii0ii3)) & k_det),
		nii1iO = (((((((d21_5_eq_n & d2_2_eq_n) & (nii1lO12 ^ nii1lO11)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & (nii1li14 ^ nii1li13)) & k_det) & (~ n01il)),
		nii1Ol = ((((((((d21_5_eq_n & d2_2_eq_n) & (nii00i6 ^ nii00i5)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & k_det) & (nii01l8 ^ nii01l7)) & n01il) & (nii1OO10 ^ nii1OO9)),
		pudr = {nii1i, ni0Ol, ni0lO, ni0ll, ni0li, ni0iO, ni0il, ni0ii, ni00O, ni00l, ni00i, ni01O, ni01l, ni01i, ni1OO, ni1Ol, ni1Oi, ni1lO, ni1ll, n0lOi},
		tx_ctl_pre_en = {n01OO, n01Ol},
		tx_data_9_pre_en = {n01Oi, n01lO},
		tx_data_pre_en = {n0i1i, n00OO, n00Ol, n00Oi, n00lO, n00ll, n00li, n00iO, n00il, n00ii, n000O, n000l, n000i, n001O, n001l, n001i},
		txlp20b = {n0l0O, n0l0l, n0l0i, n0l1O, n0l1l, n0l1i, n0iOO, n0iOl, n0iOi, n0ilO, n0ill, n0ili, n0iiO, n0iil, n0iii, n0i0O, n0i0l, n0i0i, n0i1O, n0i1l};
endmodule //cycloneiv_hssi_tx_digi_enc_chnl_top
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 12 mux21 13 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_tx_digi_iq_pipe_tx
	( 
	fifo_rd_clk_raw,
	fifo_select_in_centrl,
	fifo_select_in_pipe_quad_down,
	fifo_select_in_pipe_quad_up,
	fifo_select_out_pipe,
	rd_enable_in_centrl,
	rd_enable_in_pipe_quad_down,
	rd_enable_in_pipe_quad_up,
	rd_enable_out_pipe,
	refclk_b_raw,
	rfreerun_tx,
	rmaster_tx,
	rmaster_up_tx,
	rpipeline_bypass_tx,
	soft_reset_rclk1,
	soft_reset_wclk1,
	tx_div2_sync_in_centrl,
	tx_div2_sync_in_pipe_quad_down,
	tx_div2_sync_in_pipe_quad_up,
	tx_div2_sync_out_pipe,
	txrst,
	wr_clk_pos_raw,
	wr_enable_in_centrl,
	wr_enable_in_pipe_quad_down,
	wr_enable_in_pipe_quad_up,
	wr_enable_out_pipe) /* synthesis synthesis_clearbox=1 */;
	input   fifo_rd_clk_raw;
	input   fifo_select_in_centrl;
	input   fifo_select_in_pipe_quad_down;
	input   fifo_select_in_pipe_quad_up;
	output   fifo_select_out_pipe;
	input   rd_enable_in_centrl;
	input   rd_enable_in_pipe_quad_down;
	input   rd_enable_in_pipe_quad_up;
	output   rd_enable_out_pipe;
	input   refclk_b_raw;
	input   rfreerun_tx;
	input   rmaster_tx;
	input   rmaster_up_tx;
	input   rpipeline_bypass_tx;
	input   soft_reset_rclk1;
	input   soft_reset_wclk1;
	input   tx_div2_sync_in_centrl;
	input   tx_div2_sync_in_pipe_quad_down;
	input   tx_div2_sync_in_pipe_quad_up;
	output   tx_div2_sync_out_pipe;
	input   txrst;
	input   wr_clk_pos_raw;
	input   wr_enable_in_centrl;
	input   wr_enable_in_pipe_quad_down;
	input   wr_enable_in_pipe_quad_up;
	output   wr_enable_out_pipe;

	reg	n0ii7;
	reg	n0ii8;
	reg	n0il5;
	reg	n0il6;
	reg	n0li3;
	reg	n0li4;
	reg	n0Oi1;
	reg	n0Oi2;
	reg	n1l;
	reg	n1i_clk_prev;
	wire	wire_n1i_CLRN;
	reg	nO;
	wire	wire_nl_CLRN;
	reg	ni;
	reg	nlO_clk_prev;
	wire	wire_nlO_CLRN;
	reg	nlOO;
	reg	nlOl_clk_prev;
	wire	wire_nlOl_PRN;
	wire	wire_n0i_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nil_dataout;
	wire	wire_niO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nll_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nlOi_dataout;
	wire  n0ll;

	initial
		n0ii7 = 0;
	always @ ( posedge refclk_b_raw)
		  n0ii7 <= n0ii8;
	event n0ii7_event;
	initial
		#1 ->n0ii7_event;
	always @(n0ii7_event)
		n0ii7 <= {1{1'b1}};
	initial
		n0ii8 = 0;
	always @ ( posedge refclk_b_raw)
		  n0ii8 <= n0ii7;
	initial
		n0il5 = 0;
	always @ ( posedge refclk_b_raw)
		  n0il5 <= n0il6;
	event n0il5_event;
	initial
		#1 ->n0il5_event;
	always @(n0il5_event)
		n0il5 <= {1{1'b1}};
	initial
		n0il6 = 0;
	always @ ( posedge refclk_b_raw)
		  n0il6 <= n0il5;
	initial
		n0li3 = 0;
	always @ ( posedge refclk_b_raw)
		  n0li3 <= n0li4;
	event n0li3_event;
	initial
		#1 ->n0li3_event;
	always @(n0li3_event)
		n0li3 <= {1{1'b1}};
	initial
		n0li4 = 0;
	always @ ( posedge refclk_b_raw)
		  n0li4 <= n0li3;
	initial
		n0Oi1 = 0;
	always @ ( posedge refclk_b_raw)
		  n0Oi1 <= n0Oi2;
	event n0Oi1_event;
	initial
		#1 ->n0Oi1_event;
	always @(n0Oi1_event)
		n0Oi1 <= {1{1'b1}};
	initial
		n0Oi2 = 0;
	always @ ( posedge refclk_b_raw)
		  n0Oi2 <= n0Oi1;
	initial
	begin
		n1l = 0;
	end
	always @ (refclk_b_raw or wire_n1O_dataout or wire_n1i_CLRN)
	begin
		if (wire_n1O_dataout == 1'b1) 
		begin
			n1l <= 1;
		end
		else if  (wire_n1i_CLRN == 1'b0) 
		begin
			n1l <= 0;
		end
		else 
		if (refclk_b_raw != n1i_clk_prev && refclk_b_raw == 1'b1) 
		begin
			n1l <= wire_nli_dataout;
		end
		n1i_clk_prev <= refclk_b_raw;
	end
	assign
		wire_n1i_CLRN = (n0il6 ^ n0il5);
	initial
	begin
		nO = 0;
	end
	always @ ( posedge fifo_rd_clk_raw or  negedge wire_nl_CLRN)
	begin
		if (wire_nl_CLRN == 1'b0) 
		begin
			nO <= 0;
		end
		else 
		begin
			nO <= wire_n0i_dataout;
		end
	end
	assign
		wire_nl_CLRN = ((n0Oi2 ^ n0Oi1) & (~ soft_reset_rclk1));
	initial
	begin
		ni = 0;
	end
	always @ (refclk_b_raw or txrst or wire_nlO_CLRN)
	begin
		if (txrst == 1'b1) 
		begin
			ni <= 1;
		end
		else if  (wire_nlO_CLRN == 1'b0) 
		begin
			ni <= 0;
		end
		else 
		if (refclk_b_raw != nlO_clk_prev && refclk_b_raw == 1'b1) 
		begin
			ni <= wire_nil_dataout;
		end
		nlO_clk_prev <= refclk_b_raw;
	end
	assign
		wire_nlO_CLRN = (n0li4 ^ n0li3);
	initial
	begin
		nlOO = 0;
	end
	always @ (wr_clk_pos_raw or wire_nlOl_PRN or soft_reset_wclk1)
	begin
		if (wire_nlOl_PRN == 1'b0) 
		begin
			nlOO <= 1;
		end
		else if  (soft_reset_wclk1 == 1'b1) 
		begin
			nlOO <= 0;
		end
		else 
		if (wr_clk_pos_raw != nlOl_clk_prev && wr_clk_pos_raw == 1'b1) 
		begin
			nlOO <= wire_n0O_dataout;
		end
		nlOl_clk_prev <= wr_clk_pos_raw;
	end
	assign
		wire_nlOl_PRN = (n0ii8 ^ n0ii7);
	assign		wire_n0i_dataout = ((~ rmaster_tx) === 1'b1) ? wire_n0l_dataout : rd_enable_in_centrl;
	assign		wire_n0l_dataout = (rmaster_up_tx === 1'b1) ? rd_enable_in_pipe_quad_up : rd_enable_in_pipe_quad_down;
	assign		wire_n0O_dataout = ((~ rmaster_tx) === 1'b1) ? wire_nii_dataout : wr_enable_in_centrl;
	and(wire_n1O_dataout, txrst, ~(rfreerun_tx));
	assign		wire_nii_dataout = (rmaster_up_tx === 1'b1) ? wr_enable_in_pipe_quad_up : wr_enable_in_pipe_quad_down;
	assign		wire_nil_dataout = ((~ rmaster_tx) === 1'b1) ? wire_niO_dataout : fifo_select_in_centrl;
	assign		wire_niO_dataout = (rmaster_up_tx === 1'b1) ? fifo_select_in_pipe_quad_up : fifo_select_in_pipe_quad_down;
	assign		wire_nli_dataout = ((~ rmaster_tx) === 1'b1) ? wire_nll_dataout : tx_div2_sync_in_centrl;
	assign		wire_nll_dataout = (rmaster_up_tx === 1'b1) ? tx_div2_sync_in_pipe_quad_up : tx_div2_sync_in_pipe_quad_down;
	assign		wire_nlli_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_n0i_dataout : nO;
	assign		wire_nlll_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_n0O_dataout : nlOO;
	assign		wire_nllO_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_nil_dataout : ni;
	assign		wire_nlOi_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_nli_dataout : n1l;
	assign
		fifo_select_out_pipe = wire_nllO_dataout,
		n0ll = 1'b1,
		rd_enable_out_pipe = wire_nlli_dataout,
		tx_div2_sync_out_pipe = wire_nlOi_dataout,
		wr_enable_out_pipe = wire_nlll_dataout;
endmodule //cycloneiv_hssi_tx_digi_iq_pipe_tx
//synopsys translate_on
//VALID FILE


`timescale 1ps / 1ps

module cycloneiv_hssi_tx_digi (txpcs_rst, scan_mode, txd, 
		pld_tx_clk, polinv_tx, rev_loop_data, wrenable_tx, rddisable_tx, 
		phfifourst_tx, 
		txdetectrxloopback, powerdown, revloopback,
		txswing, pcs_txdeemph, pcs_txmargin,
		rxpolarity, polinv_rx,
		full_tx, empty_tx,
                tx_data_ts, tx_ctl_ts, refclk_pma, txpma_local_clk,
                tx_clk_out, tx_data_tc, tx_ctl_tc, pudr, 
                rd_enable_sync, refclk_b, txlp20b, tx_pipe_clk, encoder_testbus, tx_ctrl_testbus,
                tx_pipe_soft_reset, tx_pipe_electidle, 
 		txdetectrxloopback_int, powerdown_int, revloopback_int,
 		phfifo_txswing, phfifo_txdeemph, phfifo_txmargin,
		rxpolarity_int, polinv_rx_int,
                rrev_loopbk, rev_loopbk, eidleinfersel, gray_eidleinfersel,rbisten_tx, 
                rforce_disp, rib_force_disp, rforce_echar, rforce_kchar, rendec_tx, 
                rge_xaui_tx, 
                rdwidth_tx, rtxfifo_dis, rcascaded_8b10b_en_tx, 
                rprbsen_tx, rprbs_sel, rbist_sel, rcxpat_chnl_en, 
                renpolinv_tx, rphfifopldentx, rphfifoursttx,
                rfreerun_tx, rtxwrclksel, rtxrdclksel, renbitrev_tx, rensymswap_tx,
                r8b10b_enc_ibm_en, rtxfifo_lowlatency_en,
                rpmadwidth_tx, rpma_doublewidth_tx, rtx_pipe_enable,
                rindv_tx, rendec_data_sel_tx, 
                rtxpcsbypass_en,
		rtxpcsclkpwdn,
		rauto_speed_ena, 
                rfreq_sel, 
                gen2ngen1, 
                gen2ngen1_bundle,
		rcid_pattern_tx,
		rcid_len_tx,
		tx_div2_sync_in_centrl,
		tx_div2_sync_in_quad_up,
		tx_div2_sync_in_quad_down,
		wr_enable_in_centrl,
		wr_enable_in_quad_up,
		wr_enable_in_quad_down,
		rd_enable_in_centrl,
		rd_enable_in_quad_up,
		rd_enable_in_quad_down,
		fifo_select_in_centrl,
		fifo_select_in_quad_up,
		fifo_select_in_quad_down,
		dis_pc_byte,
		reset_pc_ptrs,
		reset_pc_ptrs_in_centrl,
		reset_pc_ptrs_in_quad_up,
		reset_pc_ptrs_in_quad_down,
		tx_div2_sync_in_pipe_quad_up,
		tx_div2_sync_in_pipe_quad_down,
		wr_enable_in_pipe_quad_up,
		wr_enable_in_pipe_quad_down,
		rd_enable_in_pipe_quad_up,
		rd_enable_in_pipe_quad_down,
		fifo_select_in_pipe_quad_up,
		fifo_select_in_pipe_quad_down,
		rmaster_tx,
		rmaster_up_tx,
		rself_sw_en_tx,
		rpipeline_bypass_tx,
		rphfifo_regmode_tx,
		rtxbitslip_en,
		tx_div2_sync_out_pipe_up,
		fifo_select_out_pipe_up,
		wr_enable_out_pipe_up,
		rd_enable_out_pipe_up,
		tx_div2_sync_out_pipe_down,
		fifo_select_out_pipe_down,
		wr_enable_out_pipe_down,
		rd_enable_out_pipe_down,
		prbs_cid_en,
		tx_boundary_sel
		);

// Reset inputs
input          txpcs_rst;             // TX PCS resets

// Scan inputs
input          scan_mode;             // 1'b1 = scan mode active; 
                                      // 1'b0 = normal mode
// TX PCS channel inputs/outputs
input   [43:0] txd;                   // TXD data bus from PLD
input          pld_tx_clk;            // XGMII tx clock for this lane from PLD
input          polinv_tx;             // TX polarity inversion dynamic control signal
input   [7:0]  tx_data_ts;            // 8-bit tx data from 10G ethernet 
                                      // tx state machine (tx_sm)
input          tx_ctl_ts;             // 1-bit tx control from 10G ethernet tx state machine (tx_sm)
input          refclk_pma;            // Global parallel clock from TX PLL
input          txpma_local_clk;       // Individual TX PMA clock from TX PMA Extension
input          rev_loopbk;	      // Dynamic signal causes reverse loopback
input   [19:0] rev_loop_data;	      // 10 bit data from RX rate matching FIFO, reverse loopback
input          wrenable_tx;           // TX phase comp. FIFO write enable control signal
input          rddisable_tx;          // TX phase comp. FIFO read disable control signal
input          phfifourst_tx;	      // TX phase comp. FIFO user reset

	// TX PIPE interface signals
input			txdetectrxloopback;
//input			txelecidle; 	txd[9]
//input			txcompliance;	txd[10] and txd[32]
input	[1:0]	powerdown;
	
input			revloopback;

// push through TX Phase Comp FIFO
input			txswing;
input			pcs_txdeemph;
input	[2:0]	pcs_txmargin;

	// RX PIPE interface signals
input			rxpolarity;
input			polinv_rx;
input	[2:0]	eidleinfersel;

input	       rtxpcsclkpwdn;
input	       rauto_speed_ena; 
input          rfreq_sel; 
input          gen2ngen1; 
input 	       gen2ngen1_bundle;
   
   
input 	       prbs_cid_en; //PRBS-CID dynamic signal

input   [4:0]  tx_boundary_sel;

output         full_tx;               // TX Phase comp. FIFO full flag
output         empty_tx;              // TX Phase comp. FIFO empty flag
output         tx_clk_out;
output  [7:0]  tx_data_tc;            // 8-bit tx data from tx_ctrl to XAUI TX SM
output         tx_ctl_tc;             // TX control/TX data bit 8 from tx_ctrl to XAUI TX SM
output  [19:0] pudr;                  // TX PCS 20-bit code group bus to TX PMA
output         rd_enable_sync;
output         refclk_b;              
output [19:0]  txlp20b;               // tx 20-bit code group bus to RX PCS for loopback
output         tx_pipe_clk;           // TX PIPE interface clock
output [9:0]   encoder_testbus;       // Test bus from 8B10B encoder
output [9:0]   tx_ctrl_testbus;       // Test bus from TX FIFO
output         tx_pipe_soft_reset;    // TX PIPE soft reset from TX FIFO
output         tx_pipe_electidle;     // TxElecIdle output from TX FIFO

	// TX PIPE interface signals
output			txdetectrxloopback_int;
//output			txelecidle; 	txd[9]
//output			txcompliance;	txd[10] and txd[32]
output	[1:0]	powerdown_int;
	
output			revloopback_int;

// push through TX Phase Comp FIFO
output			phfifo_txswing;
output			phfifo_txdeemph;
output	[2:0]	phfifo_txmargin;

	// RX PIPE interface signals
output			rxpolarity_int;
output			polinv_rx_int;
output	[2:0]		gray_eidleinfersel;

// TX PCS CRAMs
input          rrev_loopbk;	      // CRAM - Enable dynamic Reverse, PIPE mode
input          rbisten_tx;            // ENBIST CRAM
input 	       rforce_disp;	      // Acting with TXD[9, 19] forces current disparity to 1 or 0
input          rib_force_disp;        // Disparity force CRAM in IB mode
input          rforce_echar;          // Force /E/ char CRAM
input          rforce_kchar;          // Force /K/ char CRAM
input          rendec_tx;             // Enable 8B/10B encoder CRAM
input          rge_xaui_tx;           // GIGE Idle test enable CRAM
input          rdwidth_tx;            // TX parallel interface data width CRAM
input          rtxfifo_dis;           // TX FIFO disable CRAM
input          rcascaded_8b10b_en_tx; // Caascaded 8b/10b encoder enable CRAM
input          rprbsen_tx;            // PRBS generator enable CRAM
input   [2:0]  rprbs_sel;             // PRBS selection CRAM
input   [1:0]  rbist_sel;             // BIST selection CRAM
input   [1:0]  rcxpat_chnl_en;        // CRPAT or CJPAT selection CRAM
input          renpolinv_tx;          // TX Polarity inversion enable CRAM
input          rphfifopldentx;        // TX phase comp. FIFO PLD read/write enable CRAM
input          rphfifoursttx;         // TX phase comp. FIFO user reset enable CRAM
input          rfreerun_tx;           // TX_CLK out free running during TX PCS reset enable CRAM
input          rtxwrclksel;           // TX FIFO write clock selection CRAM
input          rtxrdclksel;           // TX FIFO read clock selection CRAM
input          renbitrev_tx;          // TX bit reversal enable CRAM
input          rensymswap_tx;         // TX symbol swap enable CRAM
input          r8b10b_enc_ibm_en;     // 8B10B Encoder fix enable CRAM
input          rtxfifo_lowlatency_en; // TX FIFO low latency enable CRAM
input          rpmadwidth_tx;         // TX PCS to TX PMA data width selection CRAM
input          rpma_doublewidth_tx;   // PCS/PMA double width (16/20) selection CRAM
input          rtx_pipe_enable;       // TX PIPE enable CRAM
input	       rcid_pattern_tx;       // CID pattern to be 0 or 1
input	[7:0]  rcid_len_tx;	      // Length of CID pattern in cycles

// Common PCS CRAMs
input          rindv_tx;              // TX SM bypassing CRAM
input          rendec_data_sel_tx;    // TX 8B10B encoder data in selection CRAM
input          rtxpcsbypass_en;       // CRAM for enable low-latency PCS bypass mode


   // new signal inputs for bundling
   input       tx_div2_sync_in_centrl;
   input       tx_div2_sync_in_quad_up;
   input       tx_div2_sync_in_quad_down;
   input       wr_enable_in_centrl;
   input       wr_enable_in_quad_up;
   input       wr_enable_in_quad_down;
   input       rd_enable_in_centrl;
   input       rd_enable_in_quad_up;
   input       rd_enable_in_quad_down;
   input       fifo_select_in_centrl;
   input       fifo_select_in_quad_up;
   input       fifo_select_in_quad_down;
   input       reset_pc_ptrs;
   input       reset_pc_ptrs_in_centrl;
   input       reset_pc_ptrs_in_quad_up;
   input       reset_pc_ptrs_in_quad_down;

   input       tx_div2_sync_in_pipe_quad_up;
   input       tx_div2_sync_in_pipe_quad_down;
   input       wr_enable_in_pipe_quad_up;
   input       wr_enable_in_pipe_quad_down;
   input       rd_enable_in_pipe_quad_up;
   input       rd_enable_in_pipe_quad_down;
   input       fifo_select_in_pipe_quad_up;
   input       fifo_select_in_pipe_quad_down;

   input        dis_pc_byte;
   
   // new MDIO inputs for bundling and auto speed
   input       rmaster_tx;
   input       rmaster_up_tx;
   input       rself_sw_en_tx;
   input       rpipeline_bypass_tx;
   input       rphfifo_regmode_tx;
      
   // new outputs for bundling and auto speed
   output      tx_div2_sync_out_pipe_up;
   output      fifo_select_out_pipe_up;
   output      wr_enable_out_pipe_up;
   output      rd_enable_out_pipe_up;   
   output      tx_div2_sync_out_pipe_down;
   output      fifo_select_out_pipe_down;
   output      wr_enable_out_pipe_down;
   output      rd_enable_out_pipe_down;
    
   // new signals in this module for bundling and auto speed
   wire        refclk_b_raw;
   wire        wr_clk_pos_raw;
   wire        fifo_rd_clk_raw;
   wire        nc_new_bundle1;
   wire        nc_new_bundle2;
   wire        nc_new_bundle3;
   wire        fifo_select_out_testbus;

  //CRAM for TX bitslip 
   input       rtxbitslip_en;
   // removed
   // txfifo_shared_sig_in_ch0
   // txfifo_shared_sig_in_q0_ch0
   // rphfifo_master_sel_tx
   // txfifo_shared_sig_out
      

// Wiring section
wire	       refclk_b;
wire           wr_clk_pos;
wire           fifo_rd_clk;
wire			soft_reset_wclk1;
wire    [7:0]  tx_data_tc_high;       // high 8-bit tx data from tx_ctrl
wire    [7:0]  tx_data_tc;            // low 8-bit tx data from tx_ctrl
wire           tx_ctl_tc_high;        // high tx control/tx data bit 8 from tx_ctrl
wire           tx_ctl_tc;             // low tx control/tx data bit 8 from tx_ctrl
wire	       rd_enable_sync;
wire	[1:0]  tx_ctl_pre_en;  
wire    [15:0] tx_data_pre_en;
wire    [1:0]  tx_data_9_pre_en;
wire    [15:0] tx_data_sg;            // 16-bit data sequence generated by bist_gen.
wire    [1:0]  tx_control_sg;         // 2-bit control sequence generated by selftest_gen.
wire    [1:0]  tx_data_9_tc;          // tx data bit 9 from tx_ctrl
wire    [19:0]  tx_data_pg;           // 20-bit tx code group generated by prbs_gen
wire           soft_reset_int;
wire    [1:0]  k_det, d21_5_eq_n, d2_2_eq_n;
wire 	[1:0]  txd_extend_tc;         // Extend txd by 2 bits. Used to force disparity. This will go to the encoder. 
				      // THis is input from the PLD Fabric
wire    [1:0]  disp_out_3b;           // Disparity output from encoder for testbus
wire 	       wr_enable2;
wire    [2:0]  wptr_bin;
wire 	       rd_enable2;
wire    [2:0]  rptr_bin;

wire [15:0] tx_data_tc_temp;
wire [1:0] tx_ctl_tc_temp;

// Gated soft reset by scan_mode signal
//assign soft_reset_int = (scan_mode) ? 1'b0 : txpcs_rst;
assign soft_reset_int =  txpcs_rst;

// TX PIPE interface clock
//assign tx_pipe_clk = wr_clk_pos;
assign tx_pipe_clk = fifo_rd_clk;

// Encoder testbus
assign encoder_testbus = {disp_out_3b, pudr[7:0]};

// TX FIFO testbus
assign tx_ctrl_testbus = {1'b0, fifo_select_out_testbus, wr_enable2, wptr_bin, rd_enable2, rptr_bin};
   
   
   // Clock selection module
   cycloneiv_hssi_tx_digi_txclk_ctl txclk_ctl_1 (
			  .pld_tx_clk(pld_tx_clk),
			  .refclk_pma(refclk_pma),             
			  .txpma_local_clk(txpma_local_clk),        
			  .txrst(txpcs_rst),                  
			  .scan_mode(scan_mode),              
			  .gen2ngen1(gen2ngen1),              
    			  .gen2ngen1_bundle(gen2ngen1_bundle),       
    			  .tx_div2_sync_centrl(tx_div2_sync_in_centrl),    
    			  .tx_div2_sync_quad_up(tx_div2_sync_in_quad_up),    
    			  .tx_div2_sync_quad_down(tx_div2_sync_in_quad_down),  
    			  .rindv_tx(rindv_tx),               
			  .rtxwrclksel(rtxwrclksel),            
			  .rtxrdclksel(rtxrdclksel),            
    			  .rdwidth_tx(rdwidth_tx),             
			  .rfreerun_tx(rfreerun_tx),            
    			  .rauto_speed_ena(rauto_speed_ena),        
    			  .rfreq_sel(rfreq_sel),              
    			  .rtxpcsclkpwdn(rtxpcsclkpwdn),          
    			  .rmaster_tx(rmaster_tx),              
    			  .rmaster_up_tx(rmaster_up_tx),           
			  .rself_sw_en_tx(rself_sw_en_tx),          
			  .refclk_b(refclk_b),               
			  .wr_clk_pos(wr_clk_pos),             
			  .fifo_rd_clk(fifo_rd_clk),            
			  .tx_clk_out(tx_clk_out),             
			  .refclk_b_raw(refclk_b_raw),            
			  .wr_clk_pos_raw(wr_clk_pos_raw),          
			  .fifo_rd_clk_raw(fifo_rd_clk_raw),         
			  .tx_div2_sync_out(nc_new_bundle1)  
			  );
   

// TX Phase compensation FIFO module
   cycloneiv_hssi_tx_digi_tx_ctrl           tx_ctrl_1 (
				.soft_reset (soft_reset_int),
				.fifo_wr_clk (wr_clk_pos),
				.fifo_rd_clk (fifo_rd_clk),
				.refclk_b_in (refclk_b),
				.scan_mode(scan_mode),
				.rindv_tx (rindv_tx),
				.p_rlpbk (1'b0),
				.selftest_en (rbisten_tx),
				.rdwidth_tx (rdwidth_tx),
				// S. Park 11/29/07 - Phase FIFO bypass feature removed
				// .txfifo_dis (rtxfifo_dis),
				.txfifo_dis (1'b0),
				.rtxfifo_urst_en(rphfifoursttx),
				.txfifo_urst(phfifourst_tx),
				.rtxfifo_lowlatency_en(rtxfifo_lowlatency_en),
				.rtxphfifopldctl_en(rphfifopldentx),
				.rtx_pipe_enable(rtx_pipe_enable),
				.pld_we(wrenable_tx),
				.pld_rd_dis(rddisable_tx),
				.txd ({txd[42:33],txd[31:22],txd[20:11],txd[9:0]}),
				.txd_extend ({txd[43],txd[32],txd[21],txd[10]}),               
				.rforce_disp (rforce_disp),
				.tx_data_sg ({16'h0000,tx_data_sg}),      
				.tx_control_sg ({2'b00,tx_control_sg}),   
				.rxd_lpbk (40'h0000000000),
				.redund_ctl (4'h0),
				.txd_redun (40'h0000000000),
				.rforce_kchar (rforce_kchar),
				.rforce_echar (rforce_echar),
				.rtxpcsbypass_en (rtxpcsbypass_en),
				// TX PIPE signals
				.txdetectrxloopback 	(txdetectrxloopback),
				.powerdown			(powerdown),
				.revloopback			(revloopback),
				.txswing				(txswing),
				.txdeemph				(pcs_txdeemph),
				.txmargin				(pcs_txmargin),
				// RX PIPE signals
				.rxpolarity			(rxpolarity),
				.polinv_rx			(polinv_rx),
				.eidleinfersel			(eidleinfersel),
				.reset_pc_ptrs(reset_pc_ptrs), 
    				.reset_pc_ptrs_centrl(reset_pc_ptrs_in_centrl), 
    				.reset_pc_ptrs_quad_up(reset_pc_ptrs_in_quad_up), 
    				.reset_pc_ptrs_quad_down(reset_pc_ptrs_in_quad_down), 
    				.gen2ngen1(gen2ngen1), 
    				.gen2ngen1_bundle(gen2ngen1_bundle), 
    				.dis_pc_byte(dis_pc_byte), 
    				.wr_enable_centrl(wr_enable_in_centrl), 
    				.wr_enable_quad_up(wr_enable_in_quad_up), 
    				.wr_enable_quad_down(wr_enable_in_quad_down), 
    				.rd_enable_centrl(rd_enable_in_centrl), 
    				.rd_enable_quad_up(rd_enable_in_quad_up), 
    				.rd_enable_quad_down(rd_enable_in_quad_down), 
				.fifo_select_in_centrl(fifo_select_in_centrl), 
    				.fifo_select_in_quad_up(fifo_select_in_quad_up), 
    				.fifo_select_in_quad_down(fifo_select_in_quad_down), 
    				.rauto_speed_ena(rauto_speed_ena), 
    				.rfreq_sel(rfreq_sel), 
    				.rphfifo_regmode_tx(rphfifo_regmode_tx), 
    				.rmaster_tx(rmaster_tx), 
    				.rmaster_up_tx(rmaster_up_tx), 
				.txd_extend_tc (txd_extend_tc),               
				.tx_data_tc (tx_data_tc_temp),             
				.tx_ctl_tc (tx_ctl_tc_temp),             
				.tx_data_9_tc (tx_data_9_tc),
				.rd_enable_sync (rd_enable_sync),
				.k_det (k_det),
				.d21_5_eq_n (d21_5_eq_n),
				.d2_2_eq_n (d2_2_eq_n),
				.wr_enable_out(nc_new_bundle2),  
				.rd_enable_out(nc_new_bundle3),  
				.fifo_select_out (fifo_select_out_testbus),  
				.ph_fifo_full(full_tx),
				.ph_fifo_empty(empty_tx),
				.soft_reset_wclk1(soft_reset_wclk1),
				.soft_reset_rclk1(tx_pipe_soft_reset),
				.pipe_electric_idle(tx_pipe_electidle),
				// TX PIPE signals
				.txdetectrxloopback_int		(txdetectrxloopback_int),
				.powerdown_int				(powerdown_int),
				.revloopback_int			(revloopback_int),
				.gray_eidleinfersel			(gray_eidleinfersel),
				
				.phfifo_txswing			(phfifo_txswing),
				.phfifo_txdeemph			(phfifo_txdeemph),
				.phfifo_txmargin			(phfifo_txmargin),
				
				// RX PIPE signals
				.rxpolarity_int			(rxpolarity_int),
				.polinv_rx_int				(polinv_rx_int),
				.wr_enable2(wr_enable2),
				.wptr_bin(wptr_bin),
				.rd_enable2(rd_enable2),
				.rptr_bin(rptr_bin)
				);           
assign tx_data_tc_high = tx_data_tc_temp[15:8];
assign tx_data_tc = tx_data_tc_temp[7:0];
assign tx_ctl_tc_high = tx_ctl_tc_temp[1];
assign tx_ctl_tc = tx_ctl_tc_temp[0];
// BIST generator module
cycloneiv_hssi_tx_digi_bist_gen selftest_gen_1  (
                          .tx_clk(wr_clk_pos),
                          .soft_reset(soft_reset_wclk1),
                          .rbisten_tx(rbisten_tx),
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx),
                          .rdwidth_tx(rdwidth_tx),
                          .rbist_sel(rbist_sel),
                          .rcxpat_chnl_sel(rcxpat_chnl_en),
                          .bist_data_sg(tx_data_sg),
                          .bist_ctl_sg(tx_control_sg)
                         );

// PRBS generator module
cycloneiv_hssi_tx_digi_prbs_gen prbs_gen_1      (
                          .tx_clk(refclk_b), 
                          .soft_reset(soft_reset_int), 
                          .rprbs_en_tx(rprbsen_tx), 
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx),
                          .cid_en(prbs_cid_en),
                          .rcid_len(rcid_len_tx),
                          .rcid_pattern(rcid_pattern_tx),
                          .rprbs_sel(rprbs_sel),
                          .prbs_out(tx_data_pg)
                         );

// 8B-10B Encoder module
cycloneiv_hssi_tx_digi_enc_chnl_top enc_chnl_top_1 (
                             .rst(soft_reset_int), 
                             .clk(refclk_b), 
                             .cascaded_8b10b_en(rcascaded_8b10b_en_tx),
                             .rendec_data_sel_tx(rendec_data_sel_tx), 
                             .rrev_loopbk(rrev_loopbk), 
                             .rev_loopbk(rev_loopbk),
                             .dwidth(rpmadwidth_tx),
                             .doublewidth(rpma_doublewidth_tx),
                             .endec(rendec_tx), 
                             .ge_xaui_sel(rge_xaui_tx), 
                             .rforce_disp(rforce_disp), 
                             .ib_force_disparity(rib_force_disp), 
                             .prbs_en(rprbsen_tx), 
                             .r8b10b_enc_ibm_en(r8b10b_enc_ibm_en),
                             .rev_loop_data(rev_loop_data),
                             .tx_ctl_ts(tx_ctl_ts),
                             .tx_ctl_tc({tx_ctl_tc_high,tx_ctl_tc}),
                             .tx_data_ts(tx_data_ts),
                             .txd_extend_tc(txd_extend_tc),
                             .tx_data_tc({tx_data_tc_high,tx_data_tc}), 
                             .tx_data_9_tc(tx_data_9_tc),
                             .tx_data_pg(tx_data_pg),
                             .k_det(k_det[0]),
                             .d21_5_eq_n(d21_5_eq_n[0]),
                             .d2_2_eq_n(d2_2_eq_n[0]),
                             .renpolinv_tx(renpolinv_tx),
                             .enpolinv_tx(polinv_tx),
                             .renbitrev_tx(renbitrev_tx),
                             .rensymswap_tx(rensymswap_tx),
                             .rtxbitslip_en(rtxbitslip_en),  
                             .tx_boundary_sel(tx_boundary_sel),
                             .pudr(pudr), 
                             .txlp20b(txlp20b),
                             .tx_data_pre_en(tx_data_pre_en),
                             .tx_data_9_pre_en(tx_data_9_pre_en), 
                             .tx_ctl_pre_en(tx_ctl_pre_en),
                             .disp_out_3b(disp_out_3b)
                             );

   
   cycloneiv_hssi_tx_digi_iq_pipe_tx iqp_out_up (
						      .refclk_b_raw(refclk_b_raw),
    						      .wr_clk_pos_raw(wr_clk_pos_raw),
						      .fifo_rd_clk_raw(fifo_rd_clk_raw),
    						      .txrst(txpcs_rst),
    						      .soft_reset_rclk1(tx_pipe_soft_reset),
    						      .soft_reset_wclk1(soft_reset_wclk1),
    						      .tx_div2_sync_in_centrl(tx_div2_sync_in_centrl),   
    						      .tx_div2_sync_in_pipe_quad_up(1'b0),  
    						      .tx_div2_sync_in_pipe_quad_down(tx_div2_sync_in_pipe_quad_down),
    						      .wr_enable_in_centrl(wr_enable_in_centrl),
    						      .wr_enable_in_pipe_quad_up(1'b0),
    						      .wr_enable_in_pipe_quad_down(wr_enable_in_pipe_quad_down),
    						      .rd_enable_in_centrl(rd_enable_in_centrl),
    						      .rd_enable_in_pipe_quad_up(1'b0),
    						      .rd_enable_in_pipe_quad_down(rd_enable_in_pipe_quad_down),
    						      .fifo_select_in_centrl(fifo_select_in_centrl),
    						      .fifo_select_in_pipe_quad_up(1'b0),
    						      .fifo_select_in_pipe_quad_down(fifo_select_in_pipe_quad_down),
						      .rmaster_tx(rmaster_tx),
    						      .rmaster_up_tx(rmaster_up_tx),
    						      .rpipeline_bypass_tx(rpipeline_bypass_tx),
    						      .rfreerun_tx(rfreerun_tx),
						      .tx_div2_sync_out_pipe(tx_div2_sync_out_pipe_up),
    						      .fifo_select_out_pipe(fifo_select_out_pipe_up),
    						      .wr_enable_out_pipe(wr_enable_out_pipe_up),
    						      .rd_enable_out_pipe(rd_enable_out_pipe_up)
						      );

   cycloneiv_hssi_tx_digi_iq_pipe_tx iqp_out_down (
							.refclk_b_raw(refclk_b_raw),
    							.wr_clk_pos_raw(wr_clk_pos_raw),
							.fifo_rd_clk_raw(fifo_rd_clk_raw),
    							.txrst(txpcs_rst),
    							.soft_reset_rclk1(tx_pipe_soft_reset),
    							.soft_reset_wclk1(soft_reset_wclk1),
    							.tx_div2_sync_in_centrl(tx_div2_sync_in_centrl),   
    							.tx_div2_sync_in_pipe_quad_up(tx_div2_sync_in_pipe_quad_up),  
    							.tx_div2_sync_in_pipe_quad_down(1'b0),
    							.wr_enable_in_centrl(wr_enable_in_centrl),
    							.wr_enable_in_pipe_quad_up(wr_enable_in_pipe_quad_up),
    							.wr_enable_in_pipe_quad_down(1'b0),
    							.rd_enable_in_centrl(rd_enable_in_centrl),
    							.rd_enable_in_pipe_quad_up(rd_enable_in_pipe_quad_up),
    							.rd_enable_in_pipe_quad_down(1'b0),
    							.fifo_select_in_centrl(fifo_select_in_centrl),
    							.fifo_select_in_pipe_quad_up(fifo_select_in_pipe_quad_up),
    							.fifo_select_in_pipe_quad_down(1'b0),
							.rmaster_tx(rmaster_tx),
    							.rmaster_up_tx(rmaster_up_tx),
    							.rpipeline_bypass_tx(rpipeline_bypass_tx),
    							.rfreerun_tx(rfreerun_tx),
							.tx_div2_sync_out_pipe(tx_div2_sync_out_pipe_down),
    							.fifo_select_out_pipe(fifo_select_out_pipe_down),
    							.wr_enable_out_pipe(wr_enable_out_pipe_down),
    							.rd_enable_out_pipe(rd_enable_out_pipe_down)
							);
   

endmodule // digi_tx


////////////////////////////////////////////////////////////////////////////////
// hssi_module: transmitter **************************************************//
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// DPRIO INDEX TABLE --------------------------------------------------------//
///////////////////////////////////////////////////////////////////////////////

// Table1: PCS Per Channel TX Control Register 1 for Channel 0
`define rforce_disp_TXPCS_IDX_0         0
`define rrev_loopbk_TXPCS_IDX_0         1
`define rtxrdclksel_TXPCS_IDX_0         2
`define rtxwrclksel_TXPCS_IDX_0         3
`define rfreerun_tx_TXPCS_IDX_0         4
`define rtxurstpcs_TXPCS_IDX_0         5
`define reserved_0_TB1_TXPCS_IDX_0         6
`define rphfifoursttx_TXPCS_IDX_0         7
`define rphfifopldentx_TXPCS_IDX_0         8
`define rge_xaui_tx_TXPCS_IDX_0         9
`define rdwidth_tx_TXPCS_IDX_0         10
`define rtxfifo_lowlatency_en_TXPCS_IDX_0         11
`define rib_force_disp_TXPCS_IDX_0         12
`define rtxfifo_dis_TXPCS_IDX_0         13
`define rforce_echar_TXPCS_IDX_0         14
`define rforce_kchar_TXPCS_IDX_0         15

// Table2: PCS Per Channel TX Control Register 2 for Channel 0
`define rtxpcsbypass_en_TXPCS_IDX_0         16
`define rcxpat_chnl_en_TXPCS_IDX_0         17
`define rcxpat_chnl_en_TXPCS_IDX_1         18
`define rbist_sel_TXPCS_IDX_0         19
`define rbist_sel_TXPCS_IDX_1         20
`define rbisten_tx_TXPCS_IDX_0         21
`define rprbs_sel_TXPCS_IDX_0         22
`define rprbs_sel_TXPCS_IDX_1         23
`define rprbs_sel_TXPCS_IDX_2         24
`define rprbsen_tx_TXPCS_IDX_0         25
`define renbitrev_tx_TXPCS_IDX_0         26
`define renpolinv_tx_TXPCS_IDX_0         27
`define rensymswap_tx_TXPCS_IDX_0         28
`define rcascaded_8b10b_en_tx_TXPCS_IDX_0         29
`define r8b10b_enc_ibm_en_TXPCS_IDX_0         30
`define rendec_tx_TXPCS_IDX_0         31

// Table3: PCS Per Channel TX Control Register 3 for Channel 0
`define reserved_0_TB3_TXPCS_IDX_0         32
`define rcid_len_tx_TXPCS_IDX_0         33
`define rcid_len_tx_TXPCS_IDX_1         34
`define rcid_len_tx_TXPCS_IDX_2         35
`define rcid_len_tx_TXPCS_IDX_3         36
`define rcid_len_tx_TXPCS_IDX_4         37
`define rcid_len_tx_TXPCS_IDX_5         38
`define rcid_len_tx_TXPCS_IDX_6         39
`define rcid_len_tx_TXPCS_IDX_7         40
`define rcid_pattern_tx_TXPCS_IDX_0         41
`define rtxpcsclkpwdn_TXPCS_IDX_0         42
`define rtxswing_sel_ena_TXPCS_IDX_0         43
`define rtx_elec_idle_delay_TXPCS_IDX_0         44
`define rtx_elec_idle_delay_TXPCS_IDX_1         45
`define rtx_elec_idle_delay_TXPCS_IDX_2         46
`define rtx_pipe_enable_TXPCS_IDX_0         47

// Table4: PCS Per Channel TX Control Register 4 for Channel 0
`define reserved_0_TB4_TXPCS_IDX_0         48
`define reserved_0_TB4_TXPCS_IDX_1         49
`define reserved_0_TB4_TXPCS_IDX_2         50
`define reserved_0_TB4_TXPCS_IDX_3         51
`define reserved_0_TB4_TXPCS_IDX_4         52
`define reserved_0_TB4_TXPCS_IDX_5         53
`define reserved_0_TB4_TXPCS_IDX_6         54
`define reserved_0_TB4_TXPCS_IDX_7         55
`define reserved_0_TB4_TXPCS_IDX_8         56
`define reserved_0_TB4_TXPCS_IDX_9         57
`define reserved_0_TB4_TXPCS_IDX_10         58
`define reserved_0_TB4_TXPCS_IDX_11         59
`define rtxbitslip_en_TXPCS_IDX_0         60
`define rphfifo_regmode_tx_TXPCS_IDX_0         61
`define rpipeline_bypass_tx_TXPCS_IDX_0         62
`define rself_sw_en_tx_TXPCS_IDX_0         63

// Existing
`define rauto_speed_ena_TX_IDX          64
`define rendec_data_sel_tx_TX_IDX       65
`define rfreq_sel_TX_IDX                66
`define rhip_ena_TX_IDX                 67
`define rindv_tx_TX_IDX                 68
`define rphfifo_master_sel_tx_TX_IDX    69
`define rpma_doublewidth_tx_TX_IDX      70
`define rpmadwidth_tx_TX_IDX            71
`define rtx_cmu_sel_TX_IDX              72

// begin Atom model header --------------------------------------------------
//         --- do not enter any manual created code until the end of header
// --------------------------------------------------------------------------

// ***********************************************************
// This WYSIWYG atom header was automatically generated by the
// Atmgen build tool. To change it, alter data stored in the 
// corresponding WYS file(s) in the tools/atmgen subdirectory.
// ***********************************************************

// *** Section 1 -- Header ***

// -----------------------------------------------------------
//
// Module Name : cycloneiv_hssi_tx_pcs
//
// Description : DEV_FAMILY_CYCLONEIV cycloneiv_hssi_tx_pcs Verilog simulation model
//
// -----------------------------------------------------------

`timescale 1 ps/1 ps

// *** End of Section 1 ***

// *** Section 3 -- Module declaration ***

module cycloneiv_hssi_tx_pcs(
			bitslipboundaryselect,
			coreclk,
			ctrlenable,
			datain,
			datainfull,
			detectrxloop,
			digitalreset,
			dispval,
			elecidleinfersel,
			enrevparallellpbk,
			forcedisp,
			forceelecidle,
			hipdatain,
			hipdetectrxloop,
			hipelecidleinfersel,
			hipforceelecidle,
			hippowerdn,
			invpol,
			localrefclk,
			phfiforddisable,
			phfiforeset,
			phfifowrenable,
			phfifox4bytesel,
			phfifox4rdclk,
			phfifox4rdenable,
			phfifox4wrenable,
			pipetxswing,
			powerdn,
			prbscidenable,
			quadreset,
			refclk,
			revparallelfdbk,

			clkout,
			coreclkout,
			dataout,
			forceelecidleout,
			grayelecidleinferselout,
			hiptxclkout,
			parallelfdbkout,
			phfifooverflow,
			phfiforddisableout,
			phfiforesetout,
			phfifounderflow,
			phfifowrenableout,
			pipeenrevparallellpbkout,
			pipepowerdownout,
			pipepowerstateout,
			txdetectrx 
		);

// *** End of Section 3 ***

// *** Section 4 -- Parameter declarations and default values ***

parameter lpm_type = "cycloneiv_hssi_tx_pcs";
parameter allow_polarity_inversion = "false";
parameter bitslip_enable = "false";
parameter channel_bonding = "none";
parameter channel_number =  0 ;
parameter channel_width =  8 ;
parameter datapath_low_latency_mode = "false";
parameter datapath_protocol = "basic";
parameter disable_ph_low_latency_mode = "false";
parameter disparity_mode = "none";
parameter elec_idle_delay =  3 ;
parameter enable_bit_reversal = "false";
parameter enable_idle_selection = "false";
parameter enable_phfifo_bypass = "false";
parameter enable_reverse_parallel_loopback = "false";
parameter enable_self_test_mode = "false";
parameter enc_8b_10b_compatibility_mode = "false";
parameter enc_8b_10b_mode = "none";
parameter force_echar = "false";
parameter force_kchar = "false";
parameter hip_enable = "false";
parameter logical_channel_address =  0 ;
parameter ph_fifo_reg_mode = "false";
parameter ph_fifo_reset_enable = "false";
parameter ph_fifo_user_ctrl_enable = "false";
parameter pipe_voltage_swing_control = "false";
parameter prbs_cid_pattern = "false";
parameter prbs_cid_pattern_length =  0 ;
parameter protocol_hint = "basic";
parameter refclk_select = "local";
parameter reset_clock_output_during_digital_reset = "false";
parameter self_test_mode = "crpat";
parameter use_double_data_mode = "false";
parameter wr_clk_mux_select = "int_clk";

// *** End of Section 4 ***

// *** Section 5 -- Port declarations ***

input  [4 : 0]        bitslipboundaryselect;			// Bitslip
input                 coreclk;			// Clock
input  [1 : 0]        ctrlenable;			// Data
input  [19 : 0]       datain;			// Data
input  [21 : 0]       datainfull;			// Data
input                 detectrxloop;			// PIPE
input                 digitalreset;			// Reset
input  [1 : 0]        dispval;			// Data
input  [2 : 0]        elecidleinfersel;			// PIPE
input                 enrevparallellpbk;			// Loopback
input  [1 : 0]        forcedisp;			// Data
input                 forceelecidle;			// PIPE
input  [9 : 0]        hipdatain;			// PIPE HIP
input                 hipdetectrxloop;			// PIPE HIP
input  [2 : 0]        hipelecidleinfersel;			// PIPE HIP
input                 hipforceelecidle;			// PIPE HIP
input  [1 : 0]        hippowerdn;			// PIPE HIP
input                 invpol;			// 8B10B
input                 localrefclk;			// Clock
input                 phfiforddisable;			// Ph Comp FIFO
input                 phfiforeset;			// Ph Comp FIFO
input                 phfifowrenable;			// Ph Comp FIFO
input                 phfifox4bytesel;			// PCS Bonding
input                 phfifox4rdclk;			// PCS Bonding
input                 phfifox4rdenable;			// PCS Bonding
input                 phfifox4wrenable;			// PCS Bonding
input                 pipetxswing;			// PIPE
input  [1 : 0]        powerdn;			// PIPE
input                 prbscidenable;			// Test
input                 quadreset;			// Reset
input                 refclk;			// Clock
input  [19 : 0]       revparallelfdbk;			// Loopback
output                clkout;			// Clock
output                coreclkout;			// PCS Bonding
output [9 : 0]        dataout;			// Data
output                forceelecidleout;			// PIPE
output [2 : 0]        grayelecidleinferselout;			// PIPE
output                hiptxclkout;			// HIP
output [19 : 0]       parallelfdbkout;			// Loopback
output                phfifooverflow;			// Ph Comp FIFO
output                phfiforddisableout;			// PCS Bonding
output                phfiforesetout;			// PCS Bonding
output                phfifounderflow;			// Ph Comp FIFO
output                phfifowrenableout;			// PCS Bonding
output                pipeenrevparallellpbkout;			// PIPE
output [1 : 0]        pipepowerdownout;			// PIPE
output [3 : 0]        pipepowerstateout;			// PIPE
output                txdetectrx;			// PIPE

// *** End of Section 5 ***

// *** Section 6 -- Port declarations with defaults, if any ***

// This section will always be empty for WYSIWYG atoms
// tri1 devclrn;		//sample

// *** End of Section 6 ***

// --------------------------------------------------------------------------
// end of Atom model header -------------------------------------------------
//         --- Enter any manual created code below                          -
// --------------------------------------------------------------------------

// --------------------------------------------------------------------------
// parameters in TgX but not in cycloneiv ------------------------------------
//         --- make them local with fixed value so maximally reuse TgX code -
//             to not modifying internal codes                              -
// --------------------------------------------------------------------------
localparam auto_spd_self_switch_enable = "false";
localparam core_clock_0ppm = "false";
localparam dprio_config_mode =  06'b000000 ;
localparam enable_symbol_swap = "false";
localparam iqp_bypass = "false";
localparam iqp_ph_fifo_xn_select =  0 ;
localparam ph_fifo_xn_mapping0 = "none";
localparam ph_fifo_xn_mapping1 = "none";
localparam ph_fifo_xn_mapping2 = "none";
localparam ph_fifo_xn_select =  0 ;
localparam pipe_auto_speed_nego_enable = "false";
localparam pipe_freq_scale_mode = "Frequency";
localparam prbs_all_one_detect = "false";
localparam use_serializer_double_data_mode = "false";

// --------------------------------------------------------------------------
// Input ports in TgX but not in cycloneiv -----------------------------------
//         --- make them wire with fixed value so maximally reuse TgX code  -
//             to not modifying internal codes                              -
// --------------------------------------------------------------------------
wire                 dpriodisable = 1'b1;
wire  [149 : 0]      dprioin;		
wire                 forcedispcompliance = 1'b0;
wire                 freezptr = 1'b0;
wire                 hiptxdeemph = 1'b0;
wire  [2 : 0]        hiptxmargin = 3'b000;
wire  [1 : 0]        iqpphfifoxnbytesel = 2'b00;
wire  [1 : 0]        iqpphfifoxnrdclk = 2'b00;
wire  [1 : 0]        iqpphfifoxnrdenable = 2'b00;
wire  [1 : 0]        iqpphfifoxnwrenable = 2'b00;
wire                 phfifobyteserdisable = 1'b0;
wire                 phfifoptrsreset = 1'b0;
wire                 phfifoxnbottombytesel = 1'b0;
wire                 phfifoxnbottomrdclk = 1'b0;
wire                 phfifoxnbottomrdenable = 1'b0;
wire                 phfifoxnbottomwrenable = 1'b0;
wire  [2 : 0]        phfifoxnbytesel = 3'b000;
wire  [2 : 0]        phfifoxnptrsreset = 3'b000;
wire  [2 : 0]        phfifoxnrdclk = 3'b000;
wire  [2 : 0]        phfifoxnrdenable = 3'b000;
wire                 phfifoxntopbytesel = 1'b0;
wire                 phfifoxntoprdclk = 1'b0;
wire                 phfifoxntoprdenable = 1'b0;
wire                 phfifoxntopwrenable = 1'b0;
wire  [2 : 0]        phfifoxnwrenable = 3'b000;
wire                 pipestatetransdone = 1'b0;
wire                 pipetxdeemph = 1'b0;			
wire  [2 : 0]        pipetxmargin = 3'b000;			
wire                 rateswitch = 1'b0;
wire                 rateswitchisdone = 1'b0;
wire                 rateswitchxndone = 1'b0;
wire                 xgmctrl = 1'b0;
wire  [7 : 0]        xgmdatain = 8'h00;

// --------------------------------------------------------------------------
// Output ports in TgX but not in cycloneiv ----------------------------------
//         --- make them wire to maximally reuse TgX code                   -
//             to not modifying internal codes                              -
// --------------------------------------------------------------------------
wire [149 : 0]      dprioout;
wire                iqpphfifobyteselout;
wire                iqpphfifordclkout;
wire                iqpphfifordenableout;
wire                iqpphfifowrenableout;
wire                phfifobyteselout;
wire                phfifordclkout;
wire                phfifordenableout;
wire                rateswitchout;
wire                rdenablesync;
wire                xgmctrlenable;
wire [7 : 0]        xgmdataout;

// --------------------------------------------------------------------------
// Ports width mismatches between TgX and Cyclone IV GX --------------------------
//         --- have to modify internal code                                 -
// --------------------------------------------------------------------------
//
// port_dir        port_name       TgX_width          Cyclone IV GX_width       
// --------------------------------------------------------------------------
// in              ctrlenable      4                  2
// in              datain          40                 20
// in              datainfull      44                 22
// in              dispval         4                  2
// in              forcedisp       4                  2
// --------------------------------------------------------------------------
// out             dataout         20                 10


// --------------------------------------------------------------------------
// Behavior TgX model starting here -----------------------------------------
// --------------------------------------------------------------------------

`define CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH 25

// LOCAL_PARAMETERS_BEGIN from cycloneiv

localparam mph_fifo_xn_mapping = (ph_fifo_xn_select == 0) ? ph_fifo_xn_mapping0 :(ph_fifo_xn_select == 1) ? ph_fifo_xn_mapping1 :(ph_fifo_xn_select == 2) ? ph_fifo_xn_mapping2 : "none";                               
localparam MPHFIFO_INDEX     = (ph_fifo_xn_select == 0 || ph_fifo_xn_select == 1 || ph_fifo_xn_select == 2) ? ph_fifo_xn_select : 0;
localparam MIQP_PHFIFO_INDEX = (ph_fifo_xn_select == 0 || ph_fifo_xn_select == 1) ? ph_fifo_xn_select : 0;
localparam DPRIO_CHANNEL_INTERFACE_BIT = 4;

// LOCAL_PARAMETERS_END

wire  [3  : 0]   tmp_ctrlenable;
wire  [39 : 0]   tmp_datain;
wire  [3  : 0]   tmp_dispval;
wire  [3  : 0]   tmp_forcedisp;

// ---------------------------------------------------------------------------
// Initial CRAM  
// ---------------------------------------------------------------------------
// atom level initial CRAM ---------------------------------------------------
// Existing
reg init_is_lane0;
reg init_rauto_speed_ena;
reg init_rclkcmpinsertpad;             // rx only ========= pipe ===========    
reg init_rendec_data_sel_tx;
reg init_rfreq_sel;
reg init_rhip_ena;
reg init_rindv_tx;
reg init_rmaster_tx;
reg init_rmaster_up_tx;
reg init_rphfifo_master_sel_tx;
reg init_rpma_doublewidth_tx;
reg init_rpmadwidth_tx;
reg init_rrdwidth_rx;                  // rx only
reg init_rrx_detect_bypass;            // rx only
reg init_rrx_pipe_enable;              // rx only
reg init_rtx_cmu_sel;          // added in 6.1
reg init_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
reg init_rforce_disp;
reg init_rrev_loopbk;
reg init_rtxrdclksel;
reg init_rtxwrclksel;
reg init_rfreerun_tx;
reg init_rtxurstpcs;
reg init_reserved_0_TB1;
reg init_rphfifoursttx;
reg init_rphfifopldentx;
reg init_rge_xaui_tx;
reg init_rdwidth_tx;
reg init_rtxfifo_lowlatency_en;
reg init_rib_force_disp;
reg init_rtxfifo_dis;
reg init_rforce_echar;
reg init_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
reg init_rtxpcsbypass_en;
reg [1:0] init_rcxpat_chnl_en;
reg [1:0] init_rbist_sel;
reg init_rbisten_tx;
reg [2:0] init_rprbs_sel;
reg init_rprbsen_tx;
reg init_renbitrev_tx;
reg init_renpolinv_tx;
reg init_rensymswap_tx;
reg init_rcascaded_8b10b_en_tx;
reg init_r8b10b_enc_ibm_en;
reg init_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
reg init_reserved_0_TB3;
reg [7:0] init_rcid_len_tx;
reg init_rcid_pattern_tx;
reg init_rtxpcsclkpwdn;
reg init_rtxswing_sel_ena;
reg [2:0] init_rtx_elec_idle_delay;
reg init_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
reg [11:0] init_reserved_0_TB4;
reg init_rtxbitslip_en;
reg init_rphfifo_regmode_tx;
reg init_rpipeline_bypass_tx;
reg init_rself_sw_en_tx;
                             
////////////////////////////////////////////////////////////////////////////////
// sub-block interface: pcs_reset     ----------------------------------------//
////////////////////////////////////////////////////////////////////////////////

wire   pr_in_hard_reset;
wire   pr_in_clk_2_b;
wire   pr_in_refclk_b_in;
wire   pr_in_scan_mode;
wire   pr_in_rxpcs_rst;
wire   pr_in_txpcs_rst;
wire   pr_out_txrst_int;

////////////////////////////////////////////////////////////////////////////////
// sub-block interface: chnl_hip_spt  ----------------------------------------//
////////////////////////////////////////////////////////////////////////////////

wire [2:0]  hs_in_eidleinfersel_ch;
wire [2:0]  hs_in_hip_eidleinfersel_ch;
wire [1:0]  hs_in_hip_powerdown_ch;
wire        hs_in_hip_rate;
wire        hs_in_hip_rxpolarity;
wire [9:0]  hs_in_hip_txd_ch;
wire        hs_in_hip_txdeemph;
wire        hs_in_hip_txdetectrxloopback;
wire        hs_in_hip_txelecidle;
wire [2:0]  hs_in_hip_txmargin_ch;
wire        hs_in_pcs_phystatus;
wire [8:0]  hs_in_pcs_rxd_ch;
wire        hs_in_pcs_rxelecidle;
wire [2:0]  hs_in_pcs_rxstatus_ch;
wire        hs_in_pcs_rxvalid;
wire [1:0]  hs_in_powerdown_ch;
wire        hs_in_rate;
wire        hs_in_rhip_ena;
wire        hs_in_rxpolarity;
wire [10:0] hs_in_txd_ch;
wire        hs_in_txdeemph;
wire        hs_in_txdetectrxloopback;
wire [2:0]  hs_in_txmargin_ch;
wire        hs_in_txpma_local_clk;

wire        hs_out_hip_phystatus;
wire [8:0]  hs_out_hip_rxd_ch;
wire        hs_out_hip_rxelecidle;
wire [2:0]  hs_out_hip_rxstatus_ch;
wire        hs_out_hip_rxvalid;
wire        hs_out_hip_tx_clk;
wire [2:0]  hs_out_pcs_eidleinfersel_ch;
wire [1:0]  hs_out_pcs_powerdown_ch;
wire        hs_out_pcs_rate;
wire        hs_out_pcs_rxpolarity;
wire [10:0] hs_out_pcs_txd_ch;
wire        hs_out_pcs_txdeemph;
wire        hs_out_pcs_txdetectrxloopback;
wire [2:0]  hs_out_pcs_txmargin_ch;
wire        hs_out_phystatus;
wire [8:0]  hs_out_rxd_ch;
wire        hs_out_rxelecidle;
wire [2:0]  hs_out_rxstatus_ch;
wire        hs_out_rxvalid;

////////////////////////////////////////////////////////////////////////////////
// sub-block interface: pipe_interface  --------------------------------------//
////////////////////////////////////////////////////////////////////////////////

// inputs
wire         pi_in_pipe_tx_clk;
wire  [1:0]  pi_in_powerdown;
wire         pi_in_refclk_b;
wire         pi_in_refclk_b_reset_n;
wire         pi_in_revloopback;
wire         pi_in_state_transition_done;
wire         pi_in_tx_elec_idle_comp;
wire         pi_in_tx_pipe_reset_n;
wire  [43:0] pi_in_txd_ch;
wire  [43:0] pi_in_txd_ch_dprio;             // new in 6.1
wire         pi_in_txdetectrxloopback;
wire         pi_in_txelecidle;
wire  [43:0] pi_in_txd_ch_tmp;               // before interleaving in dwidth_single PMA

// outputs
wire  [3:0]  pi_out_powerstate; // to top - both cmu and rx
wire         pi_out_rev_loopbk;       // to TD
wire         pi_out_tx_elec_idle;     // to tx PMA - TX sending electrical idle
wire  [43:0] pi_out_txd;
wire         pi_out_txdetectrx;       // to tx PMA - RX_DET

// new input in CYCLONEIV - ww26.5 =====================================
// from PLD
wire         pi_in_txdeemph;
wire  [2:0]  pi_in_txmargin;
wire         pi_in_txswing;

// new output in CYCLONEIV - ww26.5 ====================================
// exposed to digi_top
wire         pi_out_txdeemph_int;
wire  [2:0]  pi_out_txmargin_int;
wire         pi_out_txswing_int;

////////////////////////////////////////////////////////////////////////////////
// sub-block interface: tx digital  ------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

// inputs
wire         td_in_phfifourst_tx;
wire         td_in_pld_tx_clk;
wire         td_in_polinv_tx;
wire         td_in_rddisable_tx;
wire         td_in_refclk_pma;
wire  [19:0] td_in_rev_loop_data;
wire         td_in_rev_loopbk;
wire         td_in_tx_ctl_ts;
wire  [7:0]  td_in_tx_data_ts;
wire  [43:0] td_in_txd;
wire         td_in_txpcs_rst;
wire         td_in_txpma_local_clk;
wire         td_in_wrenable_tx;

// new input in CYCLONEIV - ww26.5 ======================================

// freeze pointer for TX/RX phase comp FIFO during freq negotiation
// to tx_ctrl from rx_digi (auto_speed_neg sub-block) 
wire         td_in_freeze_ptr; 
// to tx_ctrl from TX PMA local clock divider 
wire         td_in_gen2ngen1; 
// to tx_ctrl from central clock divider 
wire         td_in_gen2ngen1_bundle;
// to tx_ctrl from PLD (RX polarity inversion dynamic control)
//       paired with polinv_tx
// path: polinv_rx (pld) -> tx_digi (tx_ctrl after encoder) ->
//    (just a simple wire in tx_ctrl so leaving it out of tx)
//       rx_pipe (mux with rxpolarity) -> rx_digi (wordalign and decoder)
wire         td_in_polinv_rx;
// to tx_ctrl from PLD
// generating powerdown_int output feeding both rx_pipe and tx_pipe
wire [1:0]   td_in_powerdown;    
// to tx_ctrl from quad pcs top
// generating rate_int output feeding rx_digi (auto_speed_neg)
wire         td_in_rate;
// to tx_ctrl from quad pcs top
// generating revloopback_int output feeding tx_pipe
wire         td_in_revloopback;
// to tx_ctrl from quad pcs top (no functionality change)
// path: rxpolarity (pld) -> tx_digi (tx_ctrl)->
//       rx_pipe (muxing with polinv_rx) --> rx_digi
wire         td_in_rxpolarity;
// to tx_ctrl from quad pcs top
//    (just a simple wire in tx_ctrl so leaving it out of tx)
// generating txdetectrxloopback_int output feeding tx_pipe
wire         td_in_txdetectrxloopback;

// new output in CYCLONEIV - ww26.5 ===================================
// to rx_digi muxed with rxpolarity_int
wire         td_out_polinv_rx_int;
// to rx_pipe and tx_pipe
wire [1:0]   td_out_powerdown_int;
// to tx_pipe
wire         td_out_revloopback_int;
// to rx_digi (mux with polinv_rx_int)
wire         td_out_rxpolarity_int;
// to tx_pipe
wire         td_out_txdetectrxloopback_int;

// outputs
wire         td_out_empty_tx;
wire  [9:0]  td_out_encoder_testbus;
wire         td_out_full_tx;
wire  [19:0] td_out_pudr;
wire         td_out_rd_enable_sync;
wire         td_out_refclk_b;
wire         td_out_tx_clk_out;
wire         td_out_tx_ctl_tc;
wire  [9:0]  td_out_tx_ctrl_testbus;
wire  [7:0]  td_out_tx_data_tc;
wire         td_out_tx_pipe_clk;
wire         td_out_tx_pipe_electidle;
wire         td_out_tx_pipe_soft_reset;
wire  [3:0]  td_out_txfifo_shared_sig_out;
wire  [19:0] td_out_txlp20b;

wire         td_in_prbs_cid_en; //PRBS-CID dynamic signal
wire [4:0]   td_in_tx_boundary_sel;

// new signal inputs for bundling
wire td_in_tx_div2_sync_in_centrl;
wire td_in_tx_div2_sync_in_quad_up;
wire td_in_tx_div2_sync_in_quad_down;
wire td_in_wr_enable_in_centrl;
wire td_in_wr_enable_in_quad_up;
wire td_in_wr_enable_in_quad_down;
wire td_in_rd_enable_in_centrl;
wire td_in_rd_enable_in_quad_up;
wire td_in_rd_enable_in_quad_down;
wire td_in_fifo_select_in_centrl;
wire td_in_fifo_select_in_quad_up;
wire td_in_fifo_select_in_quad_down;
wire td_in_reset_pc_ptrs;
wire td_in_reset_pc_ptrs_in_centrl;
wire td_in_reset_pc_ptrs_in_quad_up;
wire td_in_reset_pc_ptrs_in_quad_down;

wire td_in_tx_div2_sync_in_pipe_quad_up;
wire td_in_tx_div2_sync_in_pipe_quad_down;
wire td_in_wr_enable_in_pipe_quad_up;
wire td_in_wr_enable_in_pipe_quad_down;
wire td_in_rd_enable_in_pipe_quad_up;
wire td_in_rd_enable_in_pipe_quad_down;
wire td_in_fifo_select_in_pipe_quad_up;
wire td_in_fifo_select_in_pipe_quad_down;

wire td_in_dis_pc_byte;
   
// new outputs for bundling and auto speed
wire td_out_tx_div2_sync_out_pipe;
wire td_out_fifo_select_out_pipe;
wire td_out_wr_enable_out_pipe;
wire td_out_rd_enable_out_pipe;

// push through TX Phase Comp FIFO
wire       td_in_txswing;
wire       td_in_pcs_txdeemph;
wire [2:0] td_in_pcs_txmargin;

// RX PIPE interface signals
wire [2:0] td_in_eidleinfersel;

// push through TX Phase Comp FIFO
wire       td_out_phfifo_txswing;
wire       td_out_phfifo_txdeemph;
wire [2:0] td_out_phfifo_txmargin;

// RX PIPE interface signals
wire [2:0] td_out_gray_eidleinfersel;

// new outputs for bundling and auto speed
// splitting _out_pipe into _up and _down
wire       td_out_tx_div2_sync_out_pipe_up;
wire       td_out_fifo_select_out_pipe_up;
wire       td_out_wr_enable_out_pipe_up;
wire       td_out_rd_enable_out_pipe_up;   
wire       td_out_tx_div2_sync_out_pipe_down;
wire       td_out_fifo_select_out_pipe_down;
wire       td_out_wr_enable_out_pipe_down;
wire       td_out_rd_enable_out_pipe_down;

// ---------------------------------------------------------------------------
// DPRIO input CRAM  
// ---------------------------------------------------------------------------
// atom level DPRIO input CRAM ------------------------------------------------
// Existing
wire dprioin_is_lane0;
wire dprioin_rauto_speed_ena;
wire dprioin_rclkcmpinsertpad;         // rx only ========= pipe ===========    
wire dprioin_rendec_data_sel_tx;
wire dprioin_rfreq_sel;
wire dprioin_rhip_ena;
wire dprioin_rindv_tx;
wire dprioin_rmaster_tx;
wire dprioin_rmaster_up_tx;
wire dprioin_rphfifo_master_sel_tx;
wire dprioin_rpma_doublewidth_tx;
wire dprioin_rpmadwidth_tx;
wire dprioin_rrdwidth_rx;              // rx only
wire dprioin_rrx_detect_bypass;        // rx only
wire dprioin_rrx_pipe_enable;          // rx only
wire dprioin_rtx_cmu_sel;                 // added in 6.1
wire dprioin_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
wire dprioin_rforce_disp;
wire dprioin_rrev_loopbk;
wire dprioin_rtxrdclksel;
wire dprioin_rtxwrclksel;
wire dprioin_rfreerun_tx;
wire dprioin_rtxurstpcs;
wire dprioin_reserved_0_TB1;
wire dprioin_rphfifoursttx;
wire dprioin_rphfifopldentx;
wire dprioin_rge_xaui_tx;
wire dprioin_rdwidth_tx;
wire dprioin_rtxfifo_lowlatency_en;
wire dprioin_rib_force_disp;
wire dprioin_rtxfifo_dis;
wire dprioin_rforce_echar;
wire dprioin_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
wire dprioin_rtxpcsbypass_en;
wire [1:0] dprioin_rcxpat_chnl_en;
wire [1:0] dprioin_rbist_sel;
wire dprioin_rbisten_tx;
wire [2:0] dprioin_rprbs_sel;
wire dprioin_rprbsen_tx;
wire dprioin_renbitrev_tx;
wire dprioin_renpolinv_tx;
wire dprioin_rensymswap_tx;
wire dprioin_rcascaded_8b10b_en_tx;
wire dprioin_r8b10b_enc_ibm_en;
wire dprioin_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
wire dprioin_reserved_0_TB3;
wire [7:0] dprioin_rcid_len_tx;
wire dprioin_rcid_pattern_tx;
wire dprioin_rtxpcsclkpwdn;
wire dprioin_rtxswing_sel_ena;
wire [2:0] dprioin_rtx_elec_idle_delay;
wire dprioin_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
wire [11:0] dprioin_reserved_0_TB4;
wire dprioin_rtxbitslip_en;
wire dprioin_rphfifo_regmode_tx;
wire dprioin_rpipeline_bypass_tx;
wire dprioin_rself_sw_en_tx;

// ---------------------------------------------------------------------------
// CRAM  
// ---------------------------------------------------------------------------
// Final CRAM to pass to RTL ------------------------------------------
// Existing
wire cram_is_lane0;
wire cram_rauto_speed_ena;
wire cram_rclkcmpinsertpad;             // rx only ========= pipe ===========    
wire cram_rendec_data_sel_tx;
wire cram_rfreq_sel;
wire cram_rhip_ena;
wire cram_rindv_tx;
wire cram_rmaster_tx;
wire cram_rmaster_up_tx;
wire cram_rphfifo_master_sel_tx;
wire cram_rpma_doublewidth_tx;
wire cram_rpmadwidth_tx;
wire cram_rrdwidth_rx;                  // rx only
wire cram_rrx_detect_bypass;            // rx only
wire cram_rrx_pipe_enable;              // rx only
wire cram_rtx_cmu_sel;          // added in 6.1
wire cram_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
wire cram_rforce_disp;
wire cram_rrev_loopbk;
wire cram_rtxrdclksel;
wire cram_rtxwrclksel;
wire cram_rfreerun_tx;
wire cram_rtxurstpcs;
wire cram_reserved_0_TB1;
wire cram_rphfifoursttx;
wire cram_rphfifopldentx;
wire cram_rge_xaui_tx;
wire cram_rdwidth_tx;
wire cram_rtxfifo_lowlatency_en;
wire cram_rib_force_disp;
wire cram_rtxfifo_dis;
wire cram_rforce_echar;
wire cram_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
wire cram_rtxpcsbypass_en;
wire [1:0] cram_rcxpat_chnl_en;
wire [1:0] cram_rbist_sel;
wire cram_rbisten_tx;
wire [2:0] cram_rprbs_sel;
wire cram_rprbsen_tx;
wire cram_renbitrev_tx;
wire cram_renpolinv_tx;
wire cram_rensymswap_tx;
wire cram_rcascaded_8b10b_en_tx;
wire cram_r8b10b_enc_ibm_en;
wire cram_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
wire cram_reserved_0_TB3;
wire [7:0] cram_rcid_len_tx;
wire cram_rcid_pattern_tx;
wire cram_rtxpcsclkpwdn;
wire cram_rtxswing_sel_ena;
wire [2:0] cram_rtx_elec_idle_delay;
wire cram_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
wire [11:0] cram_reserved_0_TB4;
wire cram_rtxbitslip_en;
wire cram_rphfifo_regmode_tx;
wire cram_rpipeline_bypass_tx;
wire cram_rself_sw_en_tx;

////////////////////////////////////////////////////////////////////////////////
// Internal Variables  -------------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

integer i;
integer j;
reg     rxdet_fixclk_reg;

////////////////////////////////////////////////////////////////////////////////
// Function 		   -------------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

function [2:0] compute_rprbs_sel;
input          pma_doublewidth;
input          pma_width;
input          test_mode;
reg [8*20:1]   test_mode;
reg [2:0]      res;

begin
    case ({pma_doublewidth, pma_width})
        2'b00 : 
                begin
                    if (test_mode == "prbs_8" || test_mode == "prbs8")
                        res = 3'b000;
                    else if (test_mode == "prbs7")
                        res = 3'b010;                     
                    else if (test_mode == "prbs23")
                        res = 3'b100;
                    else if (test_mode == "high frequency")
                        res = 3'b001;
                    else                        
                        res = 3'b000;     // PRBS_8
                end
        2'b01 :
                begin
                    if (test_mode == "prbs_10" || test_mode == "prbs10")
                        res = 3'b000;
                    else if (test_mode == "high frequency")
                        res = 3'b001;
                    else if (test_mode == "low frequency")
                        res = 3'b010;
                    else if (test_mode == "mixed frequency")
                        res = 3'b011;
                    else 
                        res = 3'b000;                     // PRBS_10
                end
        2'b10 : 
                begin
                    if (test_mode == "prbs_7" || test_mode == "prbs7")
                        res = 3'b000;
                    else if (test_mode == "PRBS_23" || test_mode == "prbs_23" || test_mode == "prbs23")
                        res = 3'b001;
                    else if (test_mode == "high frequency")
                        res = 3'b010;
                    else 
                        res = 3'b000;                     // PRBS_7
                end
        2'b11 :
                begin
                    if (test_mode == "prbs_7" || test_mode == "prbs7")
                        res = 3'b000;
                    else if (test_mode == "prbs_23" || test_mode == "prbs23")
                        res = 3'b001;                     
                    else if (test_mode == "high frequency")
                        res = 3'b010;
                    else if (test_mode == "low frequency")
                        res = 3'b011;
                    else if (test_mode == "mixed frequency")
                        res = 3'b100;
                    else 
                        res = 3'b000;     // default
                end

        default : begin
        			$display("Invalid pma_doublewidth and pma_width selection");
        			$display("Time: %0t  Instance: %m", $time);
        		  end
    endcase
    compute_rprbs_sel = res;
end
endfunction

function [8*`CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] alpha_tolower;
input [8*`CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] input_string;

reg [8*`CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] return_string;
reg [8*`CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] reg_string;
reg [8:1] tmp;
reg [8:1] conv_char;
integer byte_count;
begin
reg_string = input_string;
for (byte_count = `CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
begin
    tmp = reg_string[8*`CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:(8*(`CYCLONEIV_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH-1)+1)];
    reg_string = reg_string << 8;
    if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
    begin
	conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
	return_string = {return_string, conv_char};
    end
    else
	return_string = {return_string, tmp};
end

alpha_tolower = return_string;
end
endfunction

////////////////////////////////////////////////////////////////////////////////
// Timing - INPUT BUFFERS  ---------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

wire [3:0]      ctrlenable_ipd;
wire [39:0]     datain_ipd;
wire [3:0]      dispval_ipd;
wire [3:0]      forcedisp_ipd;
wire [1:0]      powerdn_ipd;
wire [43:0]     datainfull_ipd;   // cycloneiv_modify

wire coreclk_ipd;
wire detectrxloop_ipd;
wire enrevparallellpbk_ipd;
wire forcedispcompliance_ipd;
wire invpol_ipd;
wire phfifowrenable_ipd;
wire pipetxdeemph_ipd;
wire [2:0] pipetxmargin_ipd;
wire pipetxswing_ipd;
wire rateswitch_ipd;
wire refclk_ipd;
wire rxrst_int_wire;
wire phfiforeset_ipd;
wire phfiforddisable_ipd;

//ww47 new inputs
wire [4 : 0]   bitslipboundaryselect_in;  
wire           forceelecidle_ipd;      
wire  [9 : 0]  hipdatain_in;          
wire           hipdetectrxloop_in;    
wire           hipforceelecidle_in;   
wire  [1 : 0]  hippowerdn_in;         
wire           hiptxdeemph_in;        
wire  [2 : 0]  hiptxmargin_in;        
wire  [1 : 0]  iqpphfifoxnbytesel_in;    
wire  [1 : 0]  iqpphfifoxnrdclk_in;      
wire  [1 : 0]  iqpphfifoxnrdenable_in;   
wire  [1 : 0]  iqpphfifoxnwrenable_in;   
wire           phfifobyteserdisable_in;   
wire           phfifoptrsreset_in;        
wire  [2 : 0]  phfifoxnbytesel_in;     
wire  [2 : 0]  phfifoxnptrsreset_in;   
wire  [2 : 0]  phfifoxnrdclk_in;       
wire  [2 : 0]  phfifoxnrdenable_in;    
wire  [2 : 0]  phfifoxnwrenable_in;   
wire           prbscidenable_in;   

wire [2:0] elecidleinfersel_in;
wire [2:0] hipelecidleinfersel_in;

// cycloneiv only
wire          phfifox4bytesel_in;
wire          phfifox4rdenable_in;
wire          phfifox4rdclk_in; 
wire          phfifox4wrenable_in;

assign refclk_ipd               = refclk;
assign coreclk_ipd              = coreclk;
assign ctrlenable_ipd           = {2'b00, ctrlenable};        // cycloneiv_modify
assign datain_ipd               = {20'h00000, datain};        // cycloneiv_modify
assign dispval_ipd              = {2'b00, dispval};           // cycloneiv_modify
assign forcedisp_ipd            = {2'b00, forcedisp};         // cycloneiv_modify
assign datainfull_ipd           = {22'h000000, datainfull};   // cycloneiv_modify

assign forcedispcompliance_ipd  = forcedispcompliance;
assign phfifowrenable_ipd       = phfifowrenable;
assign detectrxloop_ipd         = detectrxloop;
assign forceelecidle_ipd        = forceelecidle;
assign powerdn_ipd              = powerdn;
assign pipetxdeemph_ipd         = pipetxdeemph;
assign pipetxmargin_ipd         = pipetxmargin;
assign pipetxswing_ipd          = pipetxswing;

assign invpol_ipd               = invpol;
assign phfiforddisable_ipd      = phfiforddisable;
assign enrevparallellpbk_ipd    = enrevparallellpbk;
assign phfiforeset_ipd          = phfiforeset;
assign rateswitch_ipd           = rateswitch;

assign bitslipboundaryselect_in[0] = (bitslipboundaryselect[0] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[1] = (bitslipboundaryselect[1] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[2] = (bitslipboundaryselect[2] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[3] = (bitslipboundaryselect[3] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[4] = (bitslipboundaryselect[4] === 1'b1) ? 1'b1 : 1'b0;  

assign hipdatain_in             = hipdatain;          
assign hipdetectrxloop_in       = hipdetectrxloop;    
assign hipforceelecidle_in      = hipforceelecidle;   
assign hippowerdn_in            = hippowerdn;         
assign hiptxdeemph_in           = hiptxdeemph;        
assign hiptxmargin_in           = hiptxmargin;        
assign iqpphfifoxnbytesel_in    = iqpphfifoxnbytesel;    
assign iqpphfifoxnrdclk_in      = iqpphfifoxnrdclk;      
assign iqpphfifoxnrdenable_in   = iqpphfifoxnrdenable;   
assign iqpphfifoxnwrenable_in   = iqpphfifoxnwrenable;   
assign phfifobyteserdisable_in  = phfifobyteserdisable;   
assign phfifoptrsreset_in       = phfifoptrsreset;        
assign phfifoxnbytesel_in       = phfifoxnbytesel;     
assign phfifoxnptrsreset_in     = phfifoxnptrsreset;   
assign phfifoxnrdclk_in         = phfifoxnrdclk;       
assign phfifoxnrdenable_in      = phfifoxnrdenable;    
assign phfifoxnwrenable_in      = phfifoxnwrenable;   
assign prbscidenable_in         = prbscidenable;   

assign elecidleinfersel_in[0] = (elecidleinfersel[0] === 1'b1)? 1'b1 : 1'b0;
assign elecidleinfersel_in[1] = (elecidleinfersel[1] === 1'b1)? 1'b1 : 1'b0;
assign elecidleinfersel_in[2] = (elecidleinfersel[2] === 1'b1)? 1'b1 : 1'b0;

assign hipelecidleinfersel_in[0] = (hipelecidleinfersel[0] === 1'b1)? 1'b1 : 1'b0;
assign hipelecidleinfersel_in[1] = (hipelecidleinfersel[1] === 1'b1)? 1'b1 : 1'b0;
assign hipelecidleinfersel_in[2] = (hipelecidleinfersel[2] === 1'b1)? 1'b1 : 1'b0;

// cycloneiv only
assign phfifox4bytesel_in = (phfifox4bytesel === 1'b1) ? 1'b1 : 1'b0;
assign phfifox4rdenable_in = (phfifox4rdenable === 1'b1)? 1'b1 : 1'b0;
assign phfifox4rdclk_in    = (phfifox4rdclk === 1'b1)   ? 1'b1 : 1'b0; 
assign phfifox4wrenable_in = (phfifox4wrenable === 1'b1) ? 1'b1 : 1'b0;

////////////////////////////////////////////////////////////////////////////////
// TIMING -- TCO/TSU/HOLD                                                     //
////////////////////////////////////////////////////////////////////////////////

specify

    $setuphold(posedge coreclk, ctrlenable,     0, 0);
    $setuphold(posedge coreclk, datain,         0, 0);
    $setuphold(posedge coreclk, detectrxloop,   0, 0);
    $setuphold(posedge coreclk, dispval,        0, 0);
    $setuphold(posedge coreclk, forcedisp,      0, 0);
    $setuphold(posedge coreclk, forcedispcompliance, 0, 0);
    $setuphold(posedge coreclk, phfifowrenable, 0, 0);
    $setuphold(posedge coreclk, forceelecidle,  0, 0);
    $setuphold(posedge coreclk, powerdn,        0, 0);
    $setuphold(posedge coreclk, pipetxdeemph,   0, 0);
    $setuphold(posedge coreclk, pipetxswing,    0, 0);
    $setuphold(posedge coreclk, pipetxmargin,   0, 0);

    (posedge coreclk => (phfifooverflow  +: td_out_full_tx))  = (0, 0);
    (posedge coreclk => (phfifounderflow +: td_out_empty_tx)) = (0, 0);

endspecify

////////////////////////////////////////////////////////////////////////////////
// dprio outputs
////////////////////////////////////////////////////////////////////////////////

wire [149:0]  dprioin_in;
assign dprioin_in = dprioin;

// inital CRAMs from parameters - CRAM_TABLE 1
initial begin
    init_r8b10b_enc_ibm_en     = (enc_8b_10b_compatibility_mode == "true") ? 1'b1 : 1'b0;
    init_rbist_sel             = (self_test_mode == "incremental") ? 2'b00 :        // to bist_gen
                                 (self_test_mode == "cjpat")        ? 2'b01 :
                                 (self_test_mode == "crpat")        ? 2'b10 : 2'b00;
    init_rbisten_tx            = ((enable_self_test_mode == "true") && 
                                  (self_test_mode == "incremental" || alpha_tolower(self_test_mode) == "cjpat" || alpha_tolower(self_test_mode) == "cjpat")) ? 1'b1 : 1'b0;  // bist_gen        
    init_rcascaded_8b10b_en_tx = (enc_8b_10b_mode == "cascaded") ? 1'b1 : 1'b0;
    init_rcxpat_chnl_en        = (channel_number == 1) ? 2'b01 :               // bist_gen
                                 (channel_number == 2) ? 2'b10 :
                                 (channel_number == 3) ? 2'b11 : 2'b00;
    init_rdwidth_tx            = (use_double_data_mode == "true") ? 1'b1 : 1'b0;
    init_renbitrev_tx          = (enable_bit_reversal == "true") ? 1'b1 : 1'b0;
    init_rendec_data_sel_tx    = (protocol_hint == "xaui") ? 1'b0 : 1'b1; // 0=ts_; 1=tc_ 
    init_rendec_tx             = (enc_8b_10b_mode != "none") ? 1'b1 : 1'b0;
    init_renpolinv_tx          = (allow_polarity_inversion == "true") ? 1'b1 : 1'b0;
    init_rensymswap_tx         = (enable_symbol_swap == "true") ? 1'b1 : 1'b0;
    init_rforce_disp           = (disparity_mode == "new") ? 1'b1 : 1'b0;
    init_rforce_echar          = (force_echar == "true") ? 1'b1 : 1'b0;
    init_rforce_kchar          = (force_kchar == "true") ? 1'b1 : 1'b0;
    init_rfreerun_tx           = (reset_clock_output_during_digital_reset == "false") ? 1'b1 : 1'b0;
    init_rge_xaui_tx           = (protocol_hint == "gige" || alpha_tolower(enable_idle_selection) == "true") ? 1'b1 : 1'b0;
    init_rib_force_disp        = (disparity_mode == "legacy") ? 1'b1 : 1'b0;
    init_rindv_tx              = (channel_bonding == "x4" || alpha_tolower(channel_bonding) == "x8" || alpha_tolower(protocol_hint) == "xaui") ? 1'b0 : 1'b1;
    init_rphfifo_master_sel_tx = (channel_bonding == "x8") ? 1'b0 : 1'b1;
    init_rphfifopldentx        = 1'b1;        // Altera Internal Mode - Enable PLD controlled write and read ** enabled to match ASM
    init_rphfifoursttx         = 1'b1;        // Altera Internal Mode - 0 = normal operation:                ** enabled for POF
    init_rpma_doublewidth_tx   = (use_serializer_double_data_mode == "true") ? 1'b1 : 1'b0; // 1 = 16/20, 0 = 8/10
    init_rpmadwidth_tx         = ((enc_8b_10b_mode == "none") && ((channel_width == 8) || (channel_width == 16) || (channel_width == 32))) ? 1'b0 : 1'b1; // 0 = 8 bit, 1 = 10 bit
    init_rprbs_sel             = compute_rprbs_sel(init_rpma_doublewidth_tx,init_rpmadwidth_tx,self_test_mode);
    init_rprbsen_tx            = ((enable_self_test_mode == "true") && (alpha_tolower(self_test_mode) != "incremental") &&
                                  (self_test_mode != "cjpat") && (alpha_tolower(self_test_mode) != "crpat")) ?
                                   1'b1 : 1'b0;  // prbs_gen
    init_rrev_loopbk           = (enable_reverse_parallel_loopback == "true") ? 1'b1 : 1'b0;
    init_rtx_pipe_enable       = (protocol_hint == "pcie" || alpha_tolower(protocol_hint) == "pcie2") ? 1'b1 : 1'b0;
    init_rtxfifo_dis           = (enable_phfifo_bypass == "true") ? 1'b1 : 1'b0;           // cannot bypass
    init_rtxfifo_lowlatency_en = (disable_ph_low_latency_mode == "false") ? 1'b1 : 1'b0; 
    init_rtxpcsbypass_en       = (datapath_low_latency_mode == "true") ? 1'b1 : 1'b0;
    init_rtxrdclksel           = (refclk_select == "central") ? 1'b1 : 1'b0;      // TxFifo Rd clock 1=refclk_pma, 0=local_refclk_pma  -- cycloneiv_modify
    init_rtxswing_sel_ena      = (pipe_voltage_swing_control == "true") ? 1'b1 : 1'b0;
    init_rtxwrclksel           = (wr_clk_mux_select == "int_clk" || alpha_tolower(wr_clk_mux_select) == "int clk" || alpha_tolower(wr_clk_mux_select) == "internal clock") ? 1'b1 : 1'b0;  // TxFifo Write clk. 1=int_clk; 0=pld_tx_clk
    init_rclkcmpinsertpad      = 1'b1;      // for rx only   ====== pipe section started ========    
    init_rrdwidth_rx           = 1'b1;      // for rx only extra r in pipe interface
    init_rrx_detect_bypass     = 1'b1;      // for rx only
    init_rrx_pipe_enable       = 1'b1;      // for rx only
    init_rtx_elec_idle_delay   = (elec_idle_delay == 0) ? 3'b011 : (elec_idle_delay - 3); // 3'b011 Engineering bits - delay numbers - on purpse seting 6 to compensate PMA model
    init_is_lane0              = (channel_number == 0) ? 1'b1 : 1'b0;
    init_scan_mode             = 1'b0;
    
    // NEW
    init_rauto_speed_ena       = (pipe_auto_speed_nego_enable == "true") ? 1'b1 : 1'b0;
    init_rfreq_sel             = (pipe_freq_scale_mode == "data width") ? 1'b0 : 1'b1;     // default is Frequency
    init_rtxpcsclkpwdn         = 1'b0; 
    init_rcid_pattern_tx       = (prbs_cid_pattern == "true") ? 1'b1 : 1'b0;
    init_rcid_len_tx           = prbs_cid_pattern_length;
    init_rmaster_tx            = (mph_fifo_xn_mapping == "central"  || alpha_tolower(channel_bonding) != "x8") ? 1'b1 : 1'b0;

// ----------------------------------------------------------------------------
// megafuncton gets rmaster_up opposite as input mux but still in simulation
// input as I connect the input (from master channel) into both in_up and
// in_down. The reason I care now is due to ww12 RTL: I use the cram to mux
// iqp <= (up, down)
// ----------------------------------------------------------------------------
    init_rmaster_up_tx         = (mph_fifo_xn_mapping == "down") ? 1'b1 : 1'b0;  //flip  
    init_rself_sw_en_tx        = (auto_spd_self_switch_enable == "true") ? 1'b1 : 1'b0;
    init_rpipeline_bypass_tx   = (iqp_bypass == "true") ? 1'b1 : 1'b0;
    init_rphfifo_regmode_tx    = (ph_fifo_reg_mode == "true") ? 1'b1 : 1'b0;    
    init_rtxbitslip_en         = (bitslip_enable == "true") ? 1'b1 : 1'b0;
    init_rhip_ena              = (hip_enable == "true") ? 1'b1 : 1'b0;
end

// Set DPRIO input CRAM from dprioin - CRAM_Table 2A -------------------------
// ---------------------------------------------------------------------------
// Set DPRIO CRAM input from dprioin  
// ---------------------------------------------------------------------------
// Table 2A needs to use def'ed INDEX for PCS
// Existing
assign dprioin_is_lane0              = init_is_lane0;
assign dprioin_rauto_speed_ena       = dprioin_in[`rauto_speed_ena_TX_IDX];
assign dprioin_rclkcmpinsertpad      = init_rclkcmpinsertpad;  // rx only ========= pipe ===========    
assign dprioin_rendec_data_sel_tx    = init_rendec_data_sel_tx; // disable reconfiguration for quad-level crams
assign dprioin_rfreq_sel             = dprioin_in[`rfreq_sel_TX_IDX];
assign dprioin_rhip_ena              = dprioin_in[`rhip_ena_TX_IDX];
assign dprioin_rmaster_tx            = init_rmaster_tx;
assign dprioin_rmaster_up_tx         = init_rmaster_up_tx;
assign dprioin_rindv_tx              = init_rindv_tx;       // disable reconfiguration for quad-level crams
assign dprioin_rphfifo_master_sel_tx = init_rphfifo_master_sel_tx;    // disable reconfiguration for quad-level crams
assign dprioin_rpma_doublewidth_tx   = dprioin_in[`rpma_doublewidth_tx_TX_IDX];    //dprioen
assign dprioin_rpmadwidth_tx         = dprioin_in[`rpmadwidth_tx_TX_IDX];          //dprioen
assign dprioin_rrdwidth_rx           = init_rrdwidth_rx;              // rx only
assign dprioin_rrx_detect_bypass     = init_rrx_detect_bypass;        // rx only
assign dprioin_rrx_pipe_enable       = init_rrx_pipe_enable;          // rx only
assign dprioin_rtx_cmu_sel           = dprioin_in[`rtx_cmu_sel_TX_IDX];
assign dprioin_scan_mode             = init_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
assign dprioin_rforce_disp    = dprioin[`rforce_disp_TXPCS_IDX_0];
assign dprioin_rrev_loopbk    = dprioin[`rrev_loopbk_TXPCS_IDX_0];
assign dprioin_rtxrdclksel    = dprioin[`rtxrdclksel_TXPCS_IDX_0];
assign dprioin_rtxwrclksel    = dprioin[`rtxwrclksel_TXPCS_IDX_0];
assign dprioin_rfreerun_tx    = dprioin[`rfreerun_tx_TXPCS_IDX_0];
assign dprioin_rtxurstpcs    = dprioin[`rtxurstpcs_TXPCS_IDX_0];
assign dprioin_reserved_0_TB1    = dprioin[`reserved_0_TB1_TXPCS_IDX_0];
assign dprioin_rphfifoursttx    = dprioin[`rphfifoursttx_TXPCS_IDX_0];
assign dprioin_rphfifopldentx    = dprioin[`rphfifopldentx_TXPCS_IDX_0];
assign dprioin_rge_xaui_tx    = dprioin[`rge_xaui_tx_TXPCS_IDX_0];
assign dprioin_rdwidth_tx    = dprioin[`rdwidth_tx_TXPCS_IDX_0];
assign dprioin_rtxfifo_lowlatency_en    = dprioin[`rtxfifo_lowlatency_en_TXPCS_IDX_0];
assign dprioin_rib_force_disp    = dprioin[`rib_force_disp_TXPCS_IDX_0];
assign dprioin_rtxfifo_dis    = dprioin[`rtxfifo_dis_TXPCS_IDX_0];
assign dprioin_rforce_echar    = dprioin[`rforce_echar_TXPCS_IDX_0];
assign dprioin_rforce_kchar    = dprioin[`rforce_kchar_TXPCS_IDX_0];

// PCS Per Channel TX Control Register 2 for Channel 0
assign dprioin_rtxpcsbypass_en    = dprioin[`rtxpcsbypass_en_TXPCS_IDX_0];
assign dprioin_rcxpat_chnl_en    = dprioin[`rcxpat_chnl_en_TXPCS_IDX_1 : `rcxpat_chnl_en_TXPCS_IDX_0];
assign dprioin_rbist_sel    = dprioin[`rbist_sel_TXPCS_IDX_1 : `rbist_sel_TXPCS_IDX_0];
assign dprioin_rbisten_tx    = dprioin[`rbisten_tx_TXPCS_IDX_0];
assign dprioin_rprbs_sel    = dprioin[`rprbs_sel_TXPCS_IDX_2 : `rprbs_sel_TXPCS_IDX_0];
assign dprioin_rprbsen_tx    = dprioin[`rprbsen_tx_TXPCS_IDX_0];
assign dprioin_renbitrev_tx    = dprioin[`renbitrev_tx_TXPCS_IDX_0];
assign dprioin_renpolinv_tx    = dprioin[`renpolinv_tx_TXPCS_IDX_0];
assign dprioin_rensymswap_tx    = dprioin[`rensymswap_tx_TXPCS_IDX_0];
assign dprioin_rcascaded_8b10b_en_tx    = dprioin[`rcascaded_8b10b_en_tx_TXPCS_IDX_0];
assign dprioin_r8b10b_enc_ibm_en    = dprioin[`r8b10b_enc_ibm_en_TXPCS_IDX_0];
assign dprioin_rendec_tx    = dprioin[`rendec_tx_TXPCS_IDX_0];

// PCS Per Channel TX Control Register 3 for Channel 0
assign dprioin_reserved_0_TB3    = dprioin[`reserved_0_TB3_TXPCS_IDX_0];
assign dprioin_rcid_len_tx    = dprioin[`rcid_len_tx_TXPCS_IDX_7 : `rcid_len_tx_TXPCS_IDX_0];
assign dprioin_rcid_pattern_tx    = dprioin[`rcid_pattern_tx_TXPCS_IDX_0];
assign dprioin_rtxpcsclkpwdn    = dprioin[`rtxpcsclkpwdn_TXPCS_IDX_0];
assign dprioin_rtxswing_sel_ena    = dprioin[`rtxswing_sel_ena_TXPCS_IDX_0];
assign dprioin_rtx_elec_idle_delay    = dprioin[`rtx_elec_idle_delay_TXPCS_IDX_2 : `rtx_elec_idle_delay_TXPCS_IDX_0];
assign dprioin_rtx_pipe_enable    = dprioin[`rtx_pipe_enable_TXPCS_IDX_0];

// PCS Per Channel TX Control Register 4 for Channel 0
assign dprioin_reserved_0_TB4    = dprioin[`reserved_0_TB4_TXPCS_IDX_11 : `reserved_0_TB4_TXPCS_IDX_0];
assign dprioin_rtxbitslip_en    = dprioin[`rtxbitslip_en_TXPCS_IDX_0];
assign dprioin_rphfifo_regmode_tx    = dprioin[`rphfifo_regmode_tx_TXPCS_IDX_0];
assign dprioin_rpipeline_bypass_tx    = dprioin[`rpipeline_bypass_tx_TXPCS_IDX_0];
assign dprioin_rself_sw_en_tx    = dprioin[`rself_sw_en_tx_TXPCS_IDX_0];

// ---------------------------------------------------------------------------
// Set DPRIO output from initial CRAM
// ---------------------------------------------------------------------------
// Set DPRIO reg with initial parameters - CRAM_Table 2B ---------------------------
// Existing
assign dprioout[`rauto_speed_ena_TX_IDX]       = init_rauto_speed_ena;           
assign dprioout[`rfreq_sel_TX_IDX]             = init_rfreq_sel;           
assign dprioout[`rhip_ena_TX_IDX]              = init_rhip_ena;
assign dprioout[`rpma_doublewidth_tx_TX_IDX]   = init_rpma_doublewidth_tx;   
assign dprioout[`rpmadwidth_tx_TX_IDX]         = init_rpmadwidth_tx;         
assign dprioout[`rtx_cmu_sel_TX_IDX]           = init_rtx_cmu_sel;           

// PCS Per Channel TX Control Register 1 for Channel 0
assign dprioout[`rforce_disp_TXPCS_IDX_0] = init_rforce_disp;
assign dprioout[`rrev_loopbk_TXPCS_IDX_0] = init_rrev_loopbk;
assign dprioout[`rtxrdclksel_TXPCS_IDX_0] = init_rtxrdclksel;
assign dprioout[`rtxwrclksel_TXPCS_IDX_0] = init_rtxwrclksel;
assign dprioout[`rfreerun_tx_TXPCS_IDX_0] = init_rfreerun_tx;
assign dprioout[`rtxurstpcs_TXPCS_IDX_0] = init_rtxurstpcs;
assign dprioout[`reserved_0_TB1_TXPCS_IDX_0] = init_reserved_0_TB1;
assign dprioout[`rphfifoursttx_TXPCS_IDX_0] = init_rphfifoursttx;
assign dprioout[`rphfifopldentx_TXPCS_IDX_0] = init_rphfifopldentx;
assign dprioout[`rge_xaui_tx_TXPCS_IDX_0] = init_rge_xaui_tx;
assign dprioout[`rdwidth_tx_TXPCS_IDX_0] = init_rdwidth_tx;
assign dprioout[`rtxfifo_lowlatency_en_TXPCS_IDX_0] = init_rtxfifo_lowlatency_en;
assign dprioout[`rib_force_disp_TXPCS_IDX_0] = init_rib_force_disp;
assign dprioout[`rtxfifo_dis_TXPCS_IDX_0] = init_rtxfifo_dis;
assign dprioout[`rforce_echar_TXPCS_IDX_0] = init_rforce_echar;
assign dprioout[`rforce_kchar_TXPCS_IDX_0] = init_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
assign dprioout[`rtxpcsbypass_en_TXPCS_IDX_0] = init_rtxpcsbypass_en;
assign dprioout[`rcxpat_chnl_en_TXPCS_IDX_1 : `rcxpat_chnl_en_TXPCS_IDX_0] = init_rcxpat_chnl_en;
assign dprioout[`rbist_sel_TXPCS_IDX_1 : `rbist_sel_TXPCS_IDX_0] = init_rbist_sel;
assign dprioout[`rbisten_tx_TXPCS_IDX_0] = init_rbisten_tx;
assign dprioout[`rprbs_sel_TXPCS_IDX_2 : `rprbs_sel_TXPCS_IDX_0] = init_rprbs_sel;
assign dprioout[`rprbsen_tx_TXPCS_IDX_0] = init_rprbsen_tx;
assign dprioout[`renbitrev_tx_TXPCS_IDX_0] = init_renbitrev_tx;
assign dprioout[`renpolinv_tx_TXPCS_IDX_0] = init_renpolinv_tx;
assign dprioout[`rensymswap_tx_TXPCS_IDX_0] = init_rensymswap_tx;
assign dprioout[`rcascaded_8b10b_en_tx_TXPCS_IDX_0] = init_rcascaded_8b10b_en_tx;
assign dprioout[`r8b10b_enc_ibm_en_TXPCS_IDX_0] = init_r8b10b_enc_ibm_en;
assign dprioout[`rendec_tx_TXPCS_IDX_0] = init_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
assign dprioout[`reserved_0_TB3_TXPCS_IDX_0] = init_reserved_0_TB3;
assign dprioout[`rcid_len_tx_TXPCS_IDX_7 : `rcid_len_tx_TXPCS_IDX_0] = init_rcid_len_tx;
assign dprioout[`rcid_pattern_tx_TXPCS_IDX_0] = init_rcid_pattern_tx;
assign dprioout[`rtxpcsclkpwdn_TXPCS_IDX_0] = init_rtxpcsclkpwdn;
assign dprioout[`rtxswing_sel_ena_TXPCS_IDX_0] = init_rtxswing_sel_ena;
assign dprioout[`rtx_elec_idle_delay_TXPCS_IDX_2 : `rtx_elec_idle_delay_TXPCS_IDX_0] = init_rtx_elec_idle_delay;
assign dprioout[`rtx_pipe_enable_TXPCS_IDX_0] = init_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
assign dprioout[`reserved_0_TB4_TXPCS_IDX_11 : `reserved_0_TB4_TXPCS_IDX_0] = init_reserved_0_TB4;
assign dprioout[`rtxbitslip_en_TXPCS_IDX_0] = init_rtxbitslip_en;
assign dprioout[`rphfifo_regmode_tx_TXPCS_IDX_0] = init_rphfifo_regmode_tx;
assign dprioout[`rpipeline_bypass_tx_TXPCS_IDX_0] = init_rpipeline_bypass_tx;
assign dprioout[`rself_sw_en_tx_TXPCS_IDX_0] = init_rself_sw_en_tx;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM
// ---------------------------------------------------------------------------
// select CRAMs between DPIRO vs. parameters ----------------------------------------------------------------
// Set DPRIO CRAM
wire dpriodisable_in;
assign dpriodisable_in  = (dpriodisable === 1'b0) ? 1'b0 : 1'b1;

// Existing
assign cram_is_lane0              = (dpriodisable_in == 1'b1) ? init_is_lane0 : dprioin_is_lane0;
assign cram_rauto_speed_ena       = (dpriodisable_in == 1'b1) ? init_rauto_speed_ena : dprioin_rauto_speed_ena;
assign cram_rclkcmpinsertpad      = (dpriodisable_in == 1'b1) ? init_rclkcmpinsertpad : dprioin_rclkcmpinsertpad;           // rx only     
assign cram_rendec_data_sel_tx    = (dpriodisable_in == 1'b1) ? init_rendec_data_sel_tx : dprioin_rendec_data_sel_tx;
assign cram_rfreq_sel             = (dpriodisable_in == 1'b1) ? init_rfreq_sel : dprioin_rfreq_sel;
assign cram_rhip_ena              = (dpriodisable_in == 1'b1) ?  init_rhip_ena            :  dprioin_rhip_ena;
assign cram_rindv_tx              = (dpriodisable_in == 1'b1) ? init_rindv_tx : dprioin_rindv_tx;
assign cram_rmaster_tx            = (dpriodisable_in == 1'b1) ?  init_rmaster_tx          :  dprioin_rmaster_tx;
assign cram_rmaster_up_tx         = (dpriodisable_in == 1'b1) ?  init_rmaster_up_tx       :  dprioin_rmaster_up_tx;
assign cram_rphfifo_master_sel_tx = (dpriodisable_in == 1'b1) ? init_rphfifo_master_sel_tx : dprioin_rphfifo_master_sel_tx;
assign cram_rpma_doublewidth_tx   = (dpriodisable_in == 1'b1) ? init_rpma_doublewidth_tx : dprioin_rpma_doublewidth_tx;
assign cram_rpmadwidth_tx         = (dpriodisable_in == 1'b1) ? init_rpmadwidth_tx       : dprioin_rpmadwidth_tx;      
assign cram_rrdwidth_rx           = (dpriodisable_in == 1'b1) ? init_rrdwidth_rx : dprioin_rrdwidth_rx;                     // rx only
assign cram_rrx_detect_bypass     = (dpriodisable_in == 1'b1) ? init_rrx_detect_bypass : dprioin_rrx_detect_bypass;         // rx only
assign cram_rrx_pipe_enable       = (dpriodisable_in == 1'b1) ? init_rrx_pipe_enable : dprioin_rrx_pipe_enable;             // rx only
assign cram_rtx_cmu_sel           = (dpriodisable_in == 1'b1) ? init_rtx_cmu_sel : dprioin_rtx_cmu_sel;
assign cram_scan_mode             = (dpriodisable_in == 1'b1) ? init_scan_mode : dprioin_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
assign cram_rforce_disp = (dpriodisable_in == 1'b1) ? init_rforce_disp : dprioin_rforce_disp;
assign cram_rrev_loopbk = (dpriodisable_in == 1'b1) ? init_rrev_loopbk : dprioin_rrev_loopbk;
assign cram_rtxrdclksel = (dpriodisable_in == 1'b1) ? init_rtxrdclksel : dprioin_rtxrdclksel;
assign cram_rtxwrclksel = (dpriodisable_in == 1'b1) ? init_rtxwrclksel : dprioin_rtxwrclksel;
assign cram_rfreerun_tx = (dpriodisable_in == 1'b1) ? init_rfreerun_tx : dprioin_rfreerun_tx;
assign cram_rtxurstpcs = (dpriodisable_in == 1'b1) ? init_rtxurstpcs : dprioin_rtxurstpcs;
assign cram_reserved_0_TB1 = (dpriodisable_in == 1'b1) ? init_reserved_0_TB1 : dprioin_reserved_0_TB1;
assign cram_rphfifoursttx = (dpriodisable_in == 1'b1) ? init_rphfifoursttx : dprioin_rphfifoursttx;
assign cram_rphfifopldentx = (dpriodisable_in == 1'b1) ? init_rphfifopldentx : dprioin_rphfifopldentx;
assign cram_rge_xaui_tx = (dpriodisable_in == 1'b1) ? init_rge_xaui_tx : dprioin_rge_xaui_tx;
assign cram_rdwidth_tx = (dpriodisable_in == 1'b1) ? init_rdwidth_tx : dprioin_rdwidth_tx;
assign cram_rtxfifo_lowlatency_en = (dpriodisable_in == 1'b1) ? init_rtxfifo_lowlatency_en : dprioin_rtxfifo_lowlatency_en;
assign cram_rib_force_disp = (dpriodisable_in == 1'b1) ? init_rib_force_disp : dprioin_rib_force_disp;
assign cram_rtxfifo_dis = (dpriodisable_in == 1'b1) ? init_rtxfifo_dis : dprioin_rtxfifo_dis;
assign cram_rforce_echar = (dpriodisable_in == 1'b1) ? init_rforce_echar : dprioin_rforce_echar;
assign cram_rforce_kchar = (dpriodisable_in == 1'b1) ? init_rforce_kchar : dprioin_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
assign cram_rtxpcsbypass_en = (dpriodisable_in == 1'b1) ? init_rtxpcsbypass_en : dprioin_rtxpcsbypass_en;
assign cram_rcxpat_chnl_en = (dpriodisable_in == 1'b1) ? init_rcxpat_chnl_en : dprioin_rcxpat_chnl_en;
assign cram_rbist_sel = (dpriodisable_in == 1'b1) ? init_rbist_sel : dprioin_rbist_sel;
assign cram_rbisten_tx = (dpriodisable_in == 1'b1) ? init_rbisten_tx : dprioin_rbisten_tx;
assign cram_rprbs_sel = (dpriodisable_in == 1'b1) ? init_rprbs_sel : dprioin_rprbs_sel;
assign cram_rprbsen_tx = (dpriodisable_in == 1'b1) ? init_rprbsen_tx : dprioin_rprbsen_tx;
assign cram_renbitrev_tx = (dpriodisable_in == 1'b1) ? init_renbitrev_tx : dprioin_renbitrev_tx;
assign cram_renpolinv_tx = (dpriodisable_in == 1'b1) ? init_renpolinv_tx : dprioin_renpolinv_tx;
assign cram_rensymswap_tx = (dpriodisable_in == 1'b1) ? init_rensymswap_tx : dprioin_rensymswap_tx;
assign cram_rcascaded_8b10b_en_tx = (dpriodisable_in == 1'b1) ? init_rcascaded_8b10b_en_tx : dprioin_rcascaded_8b10b_en_tx;
assign cram_r8b10b_enc_ibm_en = (dpriodisable_in == 1'b1) ? init_r8b10b_enc_ibm_en : dprioin_r8b10b_enc_ibm_en;
assign cram_rendec_tx = (dpriodisable_in == 1'b1) ? init_rendec_tx : dprioin_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
assign cram_reserved_0_TB3 = (dpriodisable_in == 1'b1) ? init_reserved_0_TB3 : dprioin_reserved_0_TB3;
assign cram_rcid_len_tx = (dpriodisable_in == 1'b1) ? init_rcid_len_tx : dprioin_rcid_len_tx;
assign cram_rcid_pattern_tx = (dpriodisable_in == 1'b1) ? init_rcid_pattern_tx : dprioin_rcid_pattern_tx;
assign cram_rtxpcsclkpwdn = (dpriodisable_in == 1'b1) ? init_rtxpcsclkpwdn : dprioin_rtxpcsclkpwdn;
assign cram_rtxswing_sel_ena = (dpriodisable_in == 1'b1) ? init_rtxswing_sel_ena : dprioin_rtxswing_sel_ena;
assign cram_rtx_elec_idle_delay = (dpriodisable_in == 1'b1) ? init_rtx_elec_idle_delay : dprioin_rtx_elec_idle_delay;
assign cram_rtx_pipe_enable = (dpriodisable_in == 1'b1) ? init_rtx_pipe_enable : dprioin_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
assign cram_reserved_0_TB4 = (dpriodisable_in == 1'b1) ? init_reserved_0_TB4 : dprioin_reserved_0_TB4;
assign cram_rtxbitslip_en = (dpriodisable_in == 1'b1) ? init_rtxbitslip_en : dprioin_rtxbitslip_en;
assign cram_rphfifo_regmode_tx = (dpriodisable_in == 1'b1) ? init_rphfifo_regmode_tx : dprioin_rphfifo_regmode_tx;
assign cram_rpipeline_bypass_tx = (dpriodisable_in == 1'b1) ? init_rpipeline_bypass_tx : dprioin_rpipeline_bypass_tx;
assign cram_rself_sw_en_tx = (dpriodisable_in == 1'b1) ? init_rself_sw_en_tx : dprioin_rself_sw_en_tx;

////////////////////////////////////////////////////////////////////////////////
// Connect Atom level input to appropriate RTL  - PORT_IN_Table ------------- //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////
// datain TXD mapping - datain[32/40], ctrlenable[4], forcedispacompliance, forcedisp[4], dispval[4]
////////////////////////////////////////////////////////////////////////////////////////////////////

assign tmp_ctrlenable[0] = (ctrlenable_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_ctrlenable[1] = (ctrlenable_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_ctrlenable[2] = (ctrlenable_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_ctrlenable[3] = (ctrlenable_ipd[3] === 1'b1) ? 1'b1 : 1'b0;

assign tmp_dispval[0] = (dispval_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_dispval[1] = (dispval_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_dispval[2] = (dispval_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_dispval[3] = (dispval_ipd[3] === 1'b1) ? 1'b1 : 1'b0;

assign tmp_forcedisp[0] = (forcedisp_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_forcedisp[1] = (forcedisp_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_forcedisp[2] = (forcedisp_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_forcedisp[3] = (forcedisp_ipd[3] === 1'b1) ? 1'b1 : 1'b0;

assign tmp_datain[0] = (datain_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[1] = (datain_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[2] = (datain_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[3] = (datain_ipd[3] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[4] = (datain_ipd[4] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[5] = (datain_ipd[5] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[6] = (datain_ipd[6] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[7] = (datain_ipd[7] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[8] = (datain_ipd[8] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[9] = (datain_ipd[9] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[10] = (datain_ipd[10] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[11] = (datain_ipd[11] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[12] = (datain_ipd[12] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[13] = (datain_ipd[13] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[14] = (datain_ipd[14] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[15] = (datain_ipd[15] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[16] = (datain_ipd[16] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[17] = (datain_ipd[17] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[18] = (datain_ipd[18] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[19] = (datain_ipd[19] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[20] = (datain_ipd[20] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[21] = (datain_ipd[21] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[22] = (datain_ipd[22] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[23] = (datain_ipd[23] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[24] = (datain_ipd[24] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[25] = (datain_ipd[25] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[26] = (datain_ipd[26] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[27] = (datain_ipd[27] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[28] = (datain_ipd[28] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[29] = (datain_ipd[29] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[30] = (datain_ipd[30] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[31] = (datain_ipd[31] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[32] = (datain_ipd[32] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[33] = (datain_ipd[33] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[34] = (datain_ipd[34] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[35] = (datain_ipd[35] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[36] = (datain_ipd[36] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[37] = (datain_ipd[37] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[38] = (datain_ipd[38] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[39] = (datain_ipd[39] === 1'b1) ? 1'b1 : 1'b0;

assign pi_in_txd_ch_tmp[7:0] = tmp_datain[7:0];
assign pi_in_txd_ch_tmp[8] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[0] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[8] : 1'bx;
assign pi_in_txd_ch_tmp[9] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[0] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[9] : 1'bx;
assign pi_in_txd_ch_tmp[10] = (cram_rendec_tx == 1'b1) ? tmp_dispval[0] : 1'bx;

assign pi_in_txd_ch_tmp[18:11] = (cram_rendec_tx == 1'b1 || cram_rpmadwidth_tx == 1'b0) ? tmp_datain[15:8] : tmp_datain[17:10];
assign pi_in_txd_ch_tmp[19] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[1] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[18] : 1'bx;
assign pi_in_txd_ch_tmp[20] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[1] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[19] : 1'bx;
assign pi_in_txd_ch_tmp[21] = (cram_rendec_tx == 1'b1) ? tmp_dispval[1] : 1'bx;

assign pi_in_txd_ch_tmp[29:22] = (cram_rendec_tx == 1'b1 || cram_rpmadwidth_tx == 1'b0) ? tmp_datain[23:16] : tmp_datain[27:20];
assign pi_in_txd_ch_tmp[30] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[2] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[28] : 1'bx;
assign pi_in_txd_ch_tmp[31] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[2] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[29] : 1'bx;
assign pi_in_txd_ch_tmp[32] = (cram_rendec_tx == 1'b1) ? tmp_dispval[2] : 1'bx;

assign pi_in_txd_ch_tmp[40:33] = (cram_rendec_tx == 1'b1 || cram_rpmadwidth_tx == 1'b0) ? tmp_datain[31:24] : tmp_datain[37:30];
assign pi_in_txd_ch_tmp[41] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[3] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[38] : 1'bx;
assign pi_in_txd_ch_tmp[42] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[3] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[39] : 1'bx;
assign pi_in_txd_ch_tmp[43] = (cram_rendec_tx == 1'b1) ? tmp_dispval[3] : 1'bx;

//interleaving
assign pi_in_txd_ch[10:0]  = pi_in_txd_ch_tmp[10:0];
assign pi_in_txd_ch[32:22] = (cram_rdwidth_tx == 1'b1 && cram_rpma_doublewidth_tx == 1'b0) ? pi_in_txd_ch_tmp[21:11] : pi_in_txd_ch_tmp[32:22];  
assign pi_in_txd_ch[21:11] = (cram_rdwidth_tx == 1'b1 && cram_rpma_doublewidth_tx == 1'b0) ? pi_in_txd_ch_tmp[32:22] : pi_in_txd_ch_tmp[21:11];  
assign pi_in_txd_ch[43:33]  = pi_in_txd_ch_tmp[43:33];

assign pi_in_txd_ch_dprio = ((dprio_config_mode & DPRIO_CHANNEL_INTERFACE_BIT) != 0) ? datainfull_ipd : pi_in_txd_ch;

////////////////////////////////////////////////////////////////////////////////
// Connect Atom level output to appropriate RTL  - PORT_OUT_Table ----------- //
////////////////////////////////////////////////////////////////////////////////

assign clkout            = td_out_tx_clk_out;
assign dataout           = td_out_pudr[9:0];        // cycloneiv_modify
assign parallelfdbkout   = td_out_txlp20b;
assign phfifooverflow    = td_out_full_tx;
assign phfifounderflow   = td_out_empty_tx;

assign pipepowerdownout  = td_out_powerdown_int;
assign pipepowerstateout = pi_out_powerstate[3:0];
assign rdenablesync      = td_out_rd_enable_sync;
assign txdetectrx        = pi_out_txdetectrx;
assign xgmctrlenable     = td_out_tx_ctl_tc;
assign xgmdataout        = td_out_tx_data_tc;

// ww47 output ----------------------------------------------------------------
assign coreclkout           = coreclk_ipd;
assign hiptxclkout          = hs_out_hip_tx_clk;
assign iqpphfifobyteselout  = td_out_fifo_select_out_pipe;
assign iqpphfifordclkout    = td_out_tx_div2_sync_out_pipe;
assign iqpphfifordenableout = td_out_rd_enable_out_pipe;
assign iqpphfifowrenableout = td_out_wr_enable_out_pipe;
assign phfiforddisableout   = phfiforddisable_ipd;
assign phfiforesetout       = phfiforeset_ipd;
assign phfifowrenableout    = phfifowrenable_ipd;

// ww12 output ----------------------------------------------------------------
assign grayelecidleinferselout = td_out_gray_eidleinfersel;

assign pipeenrevparallellpbkout = pi_out_rev_loopbk;  // to td and rd

// q90 ww47 fix ---------------------------------------------------------------
assign forceelecidleout     = pi_out_tx_elec_idle;

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: pcs_reset -------------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign pr_in_hard_reset  = (quadreset === 1'b1) ? 1'b1 : 1'b0;      // from top
assign pr_in_clk_2_b     = 1'b0;                           // for rx side 
assign pr_in_refclk_b_in = td_out_refclk_b;
assign pr_in_scan_mode   = 1'b0;
assign pr_in_rxpcs_rst   = 1'b0;                           // for rx side
assign pr_in_txpcs_rst   = (digitalreset === 1'b1) ? 1'b1 : 1'b0;  // from top

cycloneiv_hssi_pcs_reset  tx_pcs_reset_1 (
              .hard_reset  (pr_in_hard_reset), 
              .clk_2_b     (pr_in_clk_2_b), 
              .refclk_b_in (pr_in_refclk_b_in),
              .scan_mode   (pr_in_scan_mode),
              .rxpcs_rst   (pr_in_rxpcs_rst), 
              .txpcs_rst   (pr_in_txpcs_rst),
              .rxrst_int   (rxrst_int_wire), 
              .txrst_int   (pr_out_txrst_int)
);

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: chnl_hip_support ------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign hs_in_eidleinfersel_ch       = elecidleinfersel_in;    
assign hs_in_hip_eidleinfersel_ch   = hipelecidleinfersel_in;
assign hs_in_hip_powerdown_ch       = hippowerdn_in;
assign hs_in_hip_rate               = 1'bx;
assign hs_in_hip_rxpolarity         = 1'bx;
assign hs_in_hip_txd_ch             = hipdatain_in;
assign hs_in_hip_txdeemph           = hiptxdeemph_in;
assign hs_in_hip_txdetectrxloopback = (hipdetectrxloop_in === 1'b1) ? 1'b1 : 1'b0;
assign hs_in_hip_txelecidle         = hipforceelecidle_in;
assign hs_in_hip_txmargin_ch        = hiptxmargin_in;
assign hs_in_pcs_phystatus          = 1'bx;
assign hs_in_pcs_rxd_ch             = 9'bxxxxxxxxx;
assign hs_in_pcs_rxelecidle         = 1'bx;
assign hs_in_pcs_rxstatus_ch        = 1'bx;
assign hs_in_pcs_rxvalid            = 1'bx;
assign hs_in_powerdown_ch           = powerdn_ipd;
assign hs_in_rate                   = 1'bx;
assign hs_in_rhip_ena               = cram_rhip_ena;
assign hs_in_rxpolarity             = 1'bx;
assign hs_in_txd_ch                 = pi_in_txd_ch_dprio[10:0];
assign hs_in_txdeemph               = pipetxdeemph_ipd;
assign hs_in_txdetectrxloopback     = (detectrxloop_ipd === 1'b1) ? 1'b1 : 1'b0;
assign hs_in_txmargin_ch            = pipetxmargin_ipd;
assign hs_in_txpma_local_clk        = localrefclk;

cycloneiv_hssi_digi_chnl_hip_spt mtx_hs(

    .eidleinfersel_ch (  hs_in_eidleinfersel_ch),
    .hip_eidleinfersel_ch      (hs_in_hip_eidleinfersel_ch    ),
    .hip_powerdown_ch          (hs_in_hip_powerdown_ch        ),
    .hip_rate                  (hs_in_hip_rate                ),
    .hip_rxpolarity            (hs_in_hip_rxpolarity          ),
    .hip_txd_ch                (hs_in_hip_txd_ch              ),
    .hip_txdeemph              (hs_in_hip_txdeemph            ),
    .hip_txdetectrxloopback    (hs_in_hip_txdetectrxloopback  ),
    .hip_txelecidle            (hs_in_hip_txelecidle          ),
    .hip_txmargin_ch           (hs_in_hip_txmargin_ch         ),
    .pcs_phystatus             (hs_in_pcs_phystatus           ),
    .pcs_rxd_ch                (hs_in_pcs_rxd_ch              ),
    .pcs_rxelecidle            (hs_in_pcs_rxelecidle          ),
    .pcs_rxstatus_ch           (hs_in_pcs_rxstatus_ch         ),
    .pcs_rxvalid               (hs_in_pcs_rxvalid             ),
    .powerdown_ch              (hs_in_powerdown_ch            ),
    .rate                      (hs_in_rate                    ),
    .rhip_ena                  (hs_in_rhip_ena                ),
    .rxpolarity                (hs_in_rxpolarity              ),
    .txd_ch                    (hs_in_txd_ch                  ),
    .txdeemph                  (hs_in_txdeemph                ),
    .txdetectrxloopback        (hs_in_txdetectrxloopback      ),
    .txmargin_ch               (hs_in_txmargin_ch             ),
    .txpma_local_clk           (hs_in_txpma_local_clk         ),

    .hip_phystatus             (hs_out_hip_phystatus          ),
    .hip_rxd_ch                (hs_out_hip_rxd_ch             ),
    .hip_rxelecidle            (hs_out_hip_rxelecidle         ),
    .hip_rxstatus_ch           (hs_out_hip_rxstatus_ch        ),
    .hip_rxvalid               (hs_out_hip_rxvalid            ),
    .hip_tx_clk                (hs_out_hip_tx_clk             ),
    .pcs_eidleinfersel_ch      (hs_out_pcs_eidleinfersel_ch   ),
    .pcs_powerdown_ch          (hs_out_pcs_powerdown_ch       ),
    .pcs_rate                  (hs_out_pcs_rate               ),
    .pcs_rxpolarity            (hs_out_pcs_rxpolarity         ),
    .pcs_txd_ch                (hs_out_pcs_txd_ch             ),
    .pcs_txdeemph              (hs_out_pcs_txdeemph           ),
    .pcs_txdetectrxloopback    (hs_out_pcs_txdetectrxloopback ),
    .pcs_txmargin_ch           (hs_out_pcs_txmargin_ch        ),
    .phystatus                 (hs_out_phystatus              ),
    .rxd_ch                    (hs_out_rxd_ch                 ),
    .rxelecidle                (hs_out_rxelecidle             ),
    .rxstatus_ch               (hs_out_rxstatus_ch            ),
    .rxvalid                   (hs_out_rxvalid                )
);

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: pipe_interface --------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign pi_in_pipe_tx_clk        = (cram_rtx_pipe_enable === 1'b0) ? 1'b0 : td_out_tx_pipe_clk; 
assign pi_in_powerdown          = td_out_powerdown_int;
assign pi_in_refclk_b           = (cram_rtx_pipe_enable === 1'b0) ? 1'b0 : td_out_refclk_b;
assign pi_in_refclk_b_reset_n   = ~pr_out_txrst_int;
assign pi_in_revloopback        = td_out_revloopback_int; // (enrevparallellpbk_ipd === 1'b1) ? 1'b1 : 1'b0; 
assign pi_in_tx_elec_idle_comp  = td_out_tx_pipe_electidle;
assign pi_in_tx_pipe_reset_n    = ~td_out_tx_pipe_soft_reset;
assign pi_in_txdetectrxloopback = td_out_txdetectrxloopback_int;
assign pi_in_txelecidle         = forceelecidle_ipd;      
assign pi_in_state_transition_done = pipestatetransdone;

// new connection in ww12
assign pi_in_txdeemph           = td_out_phfifo_txdeemph;
assign pi_in_txmargin           = td_out_phfifo_txmargin;
assign pi_in_txswing            = td_out_phfifo_txswing;


cycloneiv_hssi_tx_pipe_interface tx_pipe_interface_inst (
    .clk                   (pi_in_pipe_tx_clk),
    .refclk_b              (pi_in_refclk_b),
    .refclk_b_reset_n      (pi_in_refclk_b_reset_n),
    .reset_n               (pi_in_tx_pipe_reset_n),
    .rtx_pipe_enable       (cram_rtx_pipe_enable),
    .rtx_elec_idle_delay   (cram_rtx_elec_idle_delay),
    .txdetectrxloopback    (pi_in_txdetectrxloopback),
    .txelecidle            (pi_in_txelecidle),
    .powerdown             (pi_in_powerdown),
    .txd_ch                (pi_in_txd_ch_dprio),
    .revloopback           (pi_in_revloopback),
    .txd                   (pi_out_txd),
    .rev_loopbk            (pi_out_rev_loopbk),
    .tx_elec_idle_comp     (pi_in_tx_elec_idle_comp),
    .tx_elec_idle          (pi_out_tx_elec_idle),
    .txdetectrx            (pi_out_txdetectrx),
    .powerstate            (pi_out_powerstate),
    
    // new interfaces in CYCLONEIV - ww26.5
    .rtxswing_sel_ena      (cram_rtxswing_sel_ena),
    .txdeemph              (pi_in_txdeemph),
    .txmargin              (pi_in_txmargin),
    .txswing               (pi_in_txswing),
    .txdeemph_int          (pi_out_txdeemph_int),
    .txmargin_int          (pi_out_txmargin_int),
    .txswing_int           (pi_out_txswing_int)
);

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: tx_digi ---------------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign td_in_phfifourst_tx  = (phfiforeset_ipd === 1'b1) ? 1'b1 : 1'b0;
assign td_in_pld_tx_clk     =  coreclk; // coreclk_ipd;
assign td_in_polinv_tx      = (invpol_ipd === 1'b1) ? 1'b1 : 1'b0;
assign td_in_rddisable_tx   = (phfiforddisable_ipd === 1'b1) ? 1'b1 : 1'b0; // enable by default
assign td_in_refclk_pma     = refclk_ipd;
assign td_in_rev_loop_data  = revparallelfdbk;
assign td_in_rev_loopbk     = pi_out_rev_loopbk;              
assign td_in_tx_data_ts     = xgmdatain;
assign td_in_tx_ctl_ts      = xgmctrl;
assign td_in_txd            = {pi_in_txd_ch_dprio[43:11], hs_out_pcs_txd_ch};//pi_in_txd_ch_dprio; // pi_out_txd - 44 bit
assign td_in_txpcs_rst       = pr_out_txrst_int;
assign td_in_txpma_local_clk = localrefclk;         
assign td_in_wrenable_tx     = (phfifowrenable_ipd === 1'b0) ? 1'b0 : 1'b1;  // enable by default 

// new input in CYCLONEIV - ww26.5 --------------------------------------------------
assign td_in_gen2ngen1            = (rateswitchisdone === 1'b1) ? 1'b1 : 1'b0;  //from tx_pma local clk divider
assign td_in_gen2ngen1_bundle     = (rateswitchxndone === 1'b1) ? 1'b1 : 1'b0;  //from central clk divider
assign td_in_polinv_rx            = 1'b0;  // leaving it out of tx as it is a simple wire in tx_ctrl 
assign td_in_powerdown            = hs_out_pcs_powerdown_ch;
assign td_in_revloopback          = (enrevparallellpbk_ipd === 1'b1) ? 1'b1 : 1'b0;
assign td_in_rxpolarity           = 1'b0;  //// leaving it out of tx as it is a simple wire in tx_ctrl
assign td_in_txdetectrxloopback   = hs_out_pcs_txdetectrxloopback;

assign td_in_prbs_cid_en     = prbscidenable_in;
assign td_in_tx_boundary_sel = bitslipboundaryselect_in;

// new signal inputs for bundling
// temporary disabled by forcing rindv_tx = 1'b0 todo
// SPR 311609
assign td_in_tx_div2_sync_in_centrl    = phfifox4rdclk_in;
assign td_in_tx_div2_sync_in_quad_up   = phfifox4rdclk_in;
assign td_in_tx_div2_sync_in_quad_down = phfifox4rdclk_in;
assign td_in_wr_enable_in_centrl       = phfifox4wrenable_in;
assign td_in_wr_enable_in_quad_up      = phfifox4wrenable_in;
assign td_in_wr_enable_in_quad_down    = phfifox4wrenable_in;
assign td_in_rd_enable_in_centrl       = phfifox4rdenable_in;
assign td_in_rd_enable_in_quad_up      = phfifox4rdenable_in;
assign td_in_rd_enable_in_quad_down    = phfifox4rdenable_in;
assign td_in_fifo_select_in_centrl     = phfifox4bytesel_in;
assign td_in_fifo_select_in_quad_up    = phfifox4bytesel_in;
assign td_in_fifo_select_in_quad_down  = phfifox4bytesel_in;
assign td_in_reset_pc_ptrs             = phfifoptrsreset_in;  // from rx
assign td_in_reset_pc_ptrs_in_centrl   = phfifoxnptrsreset_in[MPHFIFO_INDEX];
assign td_in_reset_pc_ptrs_in_quad_up  = phfifoxnptrsreset_in[MPHFIFO_INDEX];
assign td_in_reset_pc_ptrs_in_quad_down = phfifoxnptrsreset_in[MPHFIFO_INDEX];

assign td_in_tx_div2_sync_in_pipe_quad_up   = iqpphfifoxnrdclk_in[MIQP_PHFIFO_INDEX];
assign td_in_tx_div2_sync_in_pipe_quad_down = iqpphfifoxnrdclk_in[MIQP_PHFIFO_INDEX];
assign td_in_wr_enable_in_pipe_quad_up      = iqpphfifoxnwrenable_in[MIQP_PHFIFO_INDEX];
assign td_in_wr_enable_in_pipe_quad_down    = iqpphfifoxnwrenable_in[MIQP_PHFIFO_INDEX];
assign td_in_rd_enable_in_pipe_quad_up      = iqpphfifoxnrdenable_in[MIQP_PHFIFO_INDEX];
assign td_in_rd_enable_in_pipe_quad_down    = iqpphfifoxnrdenable_in[MIQP_PHFIFO_INDEX];
assign td_in_fifo_select_in_pipe_quad_up    = iqpphfifoxnbytesel_in[MIQP_PHFIFO_INDEX];
assign td_in_fifo_select_in_pipe_quad_down  = iqpphfifoxnbytesel_in[MIQP_PHFIFO_INDEX];

assign td_in_dis_pc_byte     = phfifobyteserdisable_in; // from rx
         
// push through TX Phase Comp FIFO
assign td_in_txswing       = pipetxswing_ipd;         
assign td_in_pcs_txdeemph  = hs_out_pcs_txdeemph;     
assign td_in_pcs_txmargin  = hs_out_pcs_txmargin_ch;  

// RX PIPE interface signals
assign td_in_eidleinfersel = hs_out_pcs_eidleinfersel_ch;

assign td_out_tx_div2_sync_out_pipe = (cram_rmaster_up_tx === 1'b0) ? td_out_tx_div2_sync_out_pipe_up : td_out_tx_div2_sync_out_pipe_down;
assign td_out_fifo_select_out_pipe  = (cram_rmaster_up_tx === 1'b0) ? td_out_fifo_select_out_pipe_up  : td_out_fifo_select_out_pipe_down;
assign td_out_wr_enable_out_pipe    = (cram_rmaster_up_tx === 1'b0) ? td_out_wr_enable_out_pipe_up    : td_out_wr_enable_out_pipe_down;
assign td_out_rd_enable_out_pipe    = (cram_rmaster_up_tx === 1'b0) ? td_out_rd_enable_out_pipe_up    : td_out_rd_enable_out_pipe_down;   

cycloneiv_hssi_tx_digi digi_tx_1 (
    .empty_tx                        (td_out_empty_tx),
    .encoder_testbus                 (td_out_encoder_testbus),
    .full_tx                         (td_out_full_tx),
    .phfifourst_tx                   (td_in_phfifourst_tx),
    .pld_tx_clk                      (td_in_pld_tx_clk),
    .polinv_tx                       (td_in_polinv_tx),
    .pudr                            (td_out_pudr),
    .r8b10b_enc_ibm_en               (cram_r8b10b_enc_ibm_en),
    .rbist_sel                       (cram_rbist_sel),
    .rbisten_tx                      (cram_rbisten_tx),
    .rcascaded_8b10b_en_tx           (cram_rcascaded_8b10b_en_tx),
    .rcxpat_chnl_en                  (cram_rcxpat_chnl_en),
    .rd_enable_sync                  (td_out_rd_enable_sync),
    .rddisable_tx                    (td_in_rddisable_tx),
    .rdwidth_tx                      (cram_rdwidth_tx),
    .refclk_b                        (td_out_refclk_b),
    .refclk_pma                      (td_in_refclk_pma),
    .renbitrev_tx                    (cram_renbitrev_tx),
    .rendec_data_sel_tx              (cram_rendec_data_sel_tx),
    .rendec_tx                       (cram_rendec_tx),
    .renpolinv_tx                    (cram_renpolinv_tx),
    .rensymswap_tx                   (cram_rensymswap_tx),
    .rev_loop_data                   (td_in_rev_loop_data),
    .rev_loopbk                      (td_in_rev_loopbk),
    .rforce_disp                     (cram_rforce_disp),
    .rforce_echar                    (cram_rforce_echar),
    .rforce_kchar                    (cram_rforce_kchar),
    .rfreerun_tx                     (cram_rfreerun_tx),
    .rge_xaui_tx                     (cram_rge_xaui_tx),
    .rib_force_disp                  (cram_rib_force_disp),
    .rindv_tx                        (cram_rindv_tx),
    .rphfifopldentx                  (cram_rphfifopldentx),
    .rphfifoursttx                   (cram_rphfifoursttx),
    .rpma_doublewidth_tx             (cram_rpma_doublewidth_tx),
    .rpmadwidth_tx                   (cram_rpmadwidth_tx),
    .rprbs_sel                       (cram_rprbs_sel),
    .rprbsen_tx                      (cram_rprbsen_tx),
    .rrev_loopbk                     (cram_rrev_loopbk),
    .rtx_pipe_enable                 (cram_rtx_pipe_enable),
    .rtxfifo_dis                     (cram_rtxfifo_dis),
    .rtxfifo_lowlatency_en           (cram_rtxfifo_lowlatency_en),
    .rtxrdclksel                     (cram_rtxrdclksel),
    .rtxwrclksel                     (cram_rtxwrclksel),
    .scan_mode                       (cram_scan_mode),
    .tx_clk_out                      (td_out_tx_clk_out),
    .tx_ctl_tc                       (td_out_tx_ctl_tc),
    .tx_ctl_ts                       (td_in_tx_ctl_ts),
    .tx_ctrl_testbus                 (td_out_tx_ctrl_testbus),
    .tx_data_tc                      (td_out_tx_data_tc),
    .tx_data_ts                      (td_in_tx_data_ts),
    .tx_pipe_clk                     (td_out_tx_pipe_clk),
    .tx_pipe_electidle               (td_out_tx_pipe_electidle),
    .tx_pipe_soft_reset              (td_out_tx_pipe_soft_reset),
    .txd                             (td_in_txd),
    .txlp20b                         (td_out_txlp20b),
    .txpcs_rst                       (td_in_txpcs_rst),
    .txpma_local_clk                 (td_in_txpma_local_clk),
    .wrenable_tx                     (td_in_wrenable_tx),
    
    .gen2ngen1                       (td_in_gen2ngen1),
    .gen2ngen1_bundle                (td_in_gen2ngen1_bundle),
    .polinv_rx                       (td_in_polinv_rx),
    .powerdown                       (td_in_powerdown),
    .revloopback                     (td_in_revloopback),
    .rxpolarity                      (td_in_rxpolarity),
    .txdetectrxloopback              (td_in_txdetectrxloopback),

    .rauto_speed_ena                 (cram_rauto_speed_ena),
    .rfreq_sel                       (cram_rfreq_sel),
    .rtxpcsbypass_en                 (cram_rtxpcsbypass_en),
    .rtxpcsclkpwdn                   (cram_rtxpcsclkpwdn),

    .polinv_rx_int                   (td_out_polinv_rx_int),
    .powerdown_int                   (td_out_powerdown_int),
    .revloopback_int                 (td_out_revloopback_int),
    .rxpolarity_int                  (td_out_rxpolarity_int),
    .txdetectrxloopback_int          (td_out_txdetectrxloopback_int),
    
    .prbs_cid_en                     (td_in_prbs_cid_en),
    .tx_boundary_sel                 (td_in_tx_boundary_sel),
    .rcid_pattern_tx                 (cram_rcid_pattern_tx),
    .rcid_len_tx                     (cram_rcid_len_tx),
    
    .tx_div2_sync_in_centrl          (td_in_tx_div2_sync_in_centrl),
    .tx_div2_sync_in_quad_up         (td_in_tx_div2_sync_in_quad_up),
    .tx_div2_sync_in_quad_down       (td_in_tx_div2_sync_in_quad_down),
    .wr_enable_in_centrl             (td_in_wr_enable_in_centrl),
    .wr_enable_in_quad_up            (td_in_wr_enable_in_quad_up),
    .wr_enable_in_quad_down          (td_in_wr_enable_in_quad_down),
    .rd_enable_in_centrl             (td_in_rd_enable_in_centrl),
    .rd_enable_in_quad_up            (td_in_rd_enable_in_quad_up),
    .rd_enable_in_quad_down          (td_in_rd_enable_in_quad_down),
    .fifo_select_in_centrl           (td_in_fifo_select_in_centrl),
    .fifo_select_in_quad_up          (td_in_fifo_select_in_quad_up),
    .fifo_select_in_quad_down        (td_in_fifo_select_in_quad_down),
    .reset_pc_ptrs                   (td_in_reset_pc_ptrs),
    .reset_pc_ptrs_in_centrl         (td_in_reset_pc_ptrs_in_centrl),
    .reset_pc_ptrs_in_quad_up        (td_in_reset_pc_ptrs_in_quad_up),
    .reset_pc_ptrs_in_quad_down      (td_in_reset_pc_ptrs_in_quad_down),
    .tx_div2_sync_in_pipe_quad_up    (td_in_tx_div2_sync_in_pipe_quad_up),
    .tx_div2_sync_in_pipe_quad_down  (td_in_tx_div2_sync_in_pipe_quad_down),
    .wr_enable_in_pipe_quad_up       (td_in_wr_enable_in_pipe_quad_up),
    .wr_enable_in_pipe_quad_down     (td_in_wr_enable_in_pipe_quad_down),
    .rd_enable_in_pipe_quad_up       (td_in_rd_enable_in_pipe_quad_up),
    .rd_enable_in_pipe_quad_down     (td_in_rd_enable_in_pipe_quad_down),
    .fifo_select_in_pipe_quad_up     (td_in_fifo_select_in_pipe_quad_up),
    .fifo_select_in_pipe_quad_down   (td_in_fifo_select_in_pipe_quad_down),
    
    .dis_pc_byte                     (td_in_dis_pc_byte),
    
    .rmaster_tx                      (cram_rmaster_tx),
    .rmaster_up_tx                   (cram_rmaster_up_tx),
    .rself_sw_en_tx                  (cram_rself_sw_en_tx),
    .rpipeline_bypass_tx             (cram_rpipeline_bypass_tx),
    .rphfifo_regmode_tx              (cram_rphfifo_regmode_tx),
    
    .tx_div2_sync_out_pipe_up        (td_out_tx_div2_sync_out_pipe_up),
    .fifo_select_out_pipe_up         (td_out_fifo_select_out_pipe_up),
    .wr_enable_out_pipe_up           (td_out_wr_enable_out_pipe_up),
    .rd_enable_out_pipe_up           (td_out_rd_enable_out_pipe_up),
    .tx_div2_sync_out_pipe_down      (td_out_tx_div2_sync_out_pipe_down),
    .fifo_select_out_pipe_down       (td_out_fifo_select_out_pipe_down),
    .wr_enable_out_pipe_down         (td_out_wr_enable_out_pipe_down),
    .rd_enable_out_pipe_down         (td_out_rd_enable_out_pipe_down),
    
    .txswing                         (td_in_txswing),
    .pcs_txdeemph                    (td_in_pcs_txdeemph),
    .pcs_txmargin                    (td_in_pcs_txmargin),
    .eidleinfersel                   (td_in_eidleinfersel),

    .phfifo_txswing                  (td_out_phfifo_txswing),
    .phfifo_txdeemph                 (td_out_phfifo_txdeemph),
    .phfifo_txmargin                 (td_out_phfifo_txmargin),
    .gray_eidleinfersel              (td_out_gray_eidleinfersel),
    
    .rtxbitslip_en                   (cram_rtxbitslip_en)
);

endmodule // stratixiigx_hssi_transmitter 


//Rev: 1.13   Tue Aug 12 10:38:50 PDT 2008 
//
`timescale 1 ps / 1 ps
 
module cycloneiv_hssi_rx_digis_ph_fifo (
		   // inputs
		   rst_wclk,
		   rst_rclk,
		   wr_clk,
		   rd_clk,
		   en,
		   lowlatency_en,
		   we,
		   re,
		   din,
		   rphfifo_regmode_rx,
		   rindv_rx,
		   rauto_speed_ena,
		   reset_pc_ptrs,
		   reset_pc_ptrs_centrl,
		   reset_pc_ptrs_quad_up,
		   reset_pc_ptrs_quad_down,	
		   rmaster_rx,
		   rmaster_up_rx,
		   // outputs
		   data_out,
		   ph_fifo_full,
		   ph_fifo_empty,
		   wptr_bin,
		   rptr_bin,
		   pcs_wrapback_in,
		   rpcs_wrapback_en,
		   scan_mode
		   );

   // =======
   // inputs 
   // =======
   input         rst_wclk;
   input         rst_rclk;
   input         wr_clk;           // Write Clock
   input         rd_clk;           // Read Clock
   input         en;            	// Disable FIFO or bypass - only for Altera internal debug
   input         lowlatency_en; 	// low latency enable
   input         we;	    	// PLD dynamic write pointer enable  
   input         re;	    	// PLD dynamic read pointer enable  
   input [69:0]  din;              // 10-bit code-group bus from deskew module.
   
   input 	 rphfifo_regmode_rx;
   input 	 rindv_rx;
   input 	 rmaster_rx;
   input 	 rmaster_up_rx;
   input 	 rauto_speed_ena;
   input 	 reset_pc_ptrs;
   input 	 reset_pc_ptrs_centrl;
   input 	 reset_pc_ptrs_quad_up;
   input 	 reset_pc_ptrs_quad_down;

   input [69:0]  pcs_wrapback_in;
   input 	rpcs_wrapback_en;
   input 	scan_mode;
   

   
   // =======
   // outputs 
   // =======
   output        ph_fifo_full;	// Indicates overflow (rd_clk)
   output        ph_fifo_empty;	// FIFO empty (rd_clk)
   output [69:0] data_out;		// output data (rd_clk synchronous if not FIFO bypass)
   output [2:0]  wptr_bin;		// test bus
   output [2:0]  rptr_bin;		// test bus
   
   // ===================
   // signal declaration
   // ===================
   reg [ 7:0] 	 wptr, rptr;
   reg [ 2:0] 	 wptr_gray;
   reg [ 2:0] 	 wptr_gray0;
   reg [ 2:0] 	 wptr0;
   reg [ 2:0] 	 wptr1;
   reg [ 7:0] 	 wptr1_onehot;
   reg [ 7:0] 	 rptr0_pre;
   reg [ 7:0] 	 rptr0;
   reg [ 7:0] 	 rptr1;
   reg 		 first_rd;
   reg [69:0] 	 ram_data_out;
   wire [69:0] 	 ram_data_out_pre;
   reg [2:0] 	 wptr_bin;		// test bus
   reg [2:0] 	 rptr_bin;		// test bus
   
   reg 		 ph_fifo_full, ph_fifo_empty;
   reg 		 ph_fifo_empty_pre;
   
   wire 	 rst_n;			// Invert rst for new FIFO     
   
   wire [3:0] 	 fifo_cnt;
   reg [3:0] 	 fifo_cnt_pre;
   reg [2:0] 	 rptr1_bin;
   reg [2:0] 	 wptr1_bin_rclk;

   wire 	 reset_ptrs_local;

   reg 		 reset_ptrs_local_sync1;
   reg 		 reset_ptrs_local_sync2;
   
      
   // =============
   // functionality
   // =============
   assign rst_n = ~rst_wclk;
   
   // bypass
   assign data_out[69:0] = en ? ram_data_out : din;

   assign reset_ptrs_local = rauto_speed_ena & (rmaster_rx ? (rindv_rx ? reset_pc_ptrs : reset_pc_ptrs_centrl) : (rmaster_up_rx ? reset_pc_ptrs_quad_up : reset_pc_ptrs_quad_down));
      
   // write pointer
   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
	  begin
	     wptr <= #1 8'h01;
	  end
	else if (rphfifo_regmode_rx)
	  begin
	     wptr <= #1 8'h01;
	  end
	else if (reset_ptrs_local)
	  begin
	     wptr <= #1 8'h01;
	  end
	else
	  begin
	     if (we == 1'b1)
               wptr <= #1 {wptr[6:0],wptr[7]};
	  end
     end // always @ (posedge rst_wclk or posedge wr_clk)
   
   
   //newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use
   assign fifo_cnt = (rptr1_bin == wptr1_bin_rclk) ?
                     //((rst_rclk != 1'b1) ? ((fifo_cnt_pre==4'd1)?4'd0:4'd8) : 4'd0) :
                     ((rst_rclk != 1'b1) ? (((fifo_cnt_pre==4'd7 || fifo_cnt_pre==4'd6||fifo_cnt_pre==4'd8))?4'd8:4'd0) : 4'd0) :
                     ((wptr1_bin_rclk > rptr1_bin) ?
                      (wptr1_bin_rclk - rptr1_bin) :
                      (4'd8 - (rptr1_bin - wptr1_bin_rclk)));
   
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end // if (rst_rclk == 1'b1)
	else if (rphfifo_regmode_rx)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end
	else 
	  begin
	     reset_ptrs_local_sync1 <= #1 reset_ptrs_local;
	     reset_ptrs_local_sync2 <= #1 reset_ptrs_local_sync1;
	  end
     end // always @ (posedge rst_rclk or posedge rd_clk)
   
//ECO for S4GX to fix metastability issue
// replace the 1st FF with new flop w/o reset
// replace the 2nd FF with an enhanced flop
always @ (posedge rd_clk)
begin
  if (reset_ptrs_local_sync2 || rphfifo_regmode_rx)
    wptr0 <= #1 3'b001;
  else
    wptr0 <= #1 wptr_gray;
end // always @ (posedge rst_rclk or posedge rd_clk)
   
always @ (posedge rst_rclk or posedge rd_clk)
begin
  if (rst_rclk == 1'b1)
    wptr1 <= #1 3'b001;
  else if (reset_ptrs_local_sync2 || rphfifo_regmode_rx)
    wptr1 <= #1 3'b001;
  else
    wptr1 <= #1 wptr0;
end // always @ (posedge rst_rclk or posedge rd_clk)
   
   // read pointer
   // full & empty
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
	  begin
	     rptr  <= #1 8'h20;
	     rptr0_pre <= #1 8'h10;
	     rptr0 <= #1 8'h10;
	     rptr1 <= #1 8'h10;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     ph_fifo_empty_pre <= #1 1'b0;
	     first_rd <= #1 1'b1;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (rst_rclk == 1'b1)
	else if (reset_ptrs_local_sync2 || rphfifo_regmode_rx)
	  begin
	     rptr  <= #1 8'h20;
	     rptr0_pre <= #1 8'h10;
	     rptr0 <= #1 8'h10;
	     rptr1 <= #1 8'h10;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     ph_fifo_empty_pre <= #1 1'b0;
	     first_rd <= #1 1'b1;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (reset_ptrs_local_sync2)
	else
	  begin
	     ph_fifo_empty <= #1 ph_fifo_empty_pre;
	     fifo_cnt_pre <= #1 fifo_cnt;
	     
	     rptr0_pre <= #1 rptr;
	     rptr0 <= #1 rptr0_pre;
	     rptr1 <= #1 rptr0;
	     
	     if (first_rd == 1'b1 && re == 1'b1)
               first_rd <= #1 1'b0;
	     
	     // advance by 2 on first read in low-latency mode
	     if (re == 1'b1)
               if (first_rd == 1'b1 && lowlatency_en == 1'b1)
		 rptr <= #1 {rptr[5:0],rptr[7:6]};
               else
		 rptr <= #1 {rptr[6:0],rptr[7]};
	     
	     // full condition
	     //$if ({wptr1_onehot[6:0],wptr1_onehot[7]} == rptr1)
	     //new full flag requirement
             if (({rptr1[6:0],rptr1[7]} == wptr1_onehot) && (fifo_cnt_pre==4'd7 || fifo_cnt_pre==4'd8) && (!ph_fifo_empty_pre)) 
               ph_fifo_full <= #1 1'b1;
             //else if (ph_fifo_full == 1'b1 && ({rptr1[6:0],rptr1[7]} != wptr1_onehot)) //become sticky until reset
               //ph_fifo_full <= #1 1'b0;
	     
	     // empty condition
	     //$if ({rptr1[6:0],rptr1[7]} == wptr1_onehot)
	     //new empty flag requirement
	     if (fifo_cnt==4'd0 && (!ph_fifo_full))
               ph_fifo_empty_pre <= #1 1'b1;
	     //else if (ph_fifo_empty_pre == 1'b1 && (rptr1 != wptr1_onehot)) // become sticky until reset
               //ph_fifo_empty_pre <= #1 1'b0;
	  end // else: !if(rst_rclk == 1'b1)
     end // always @ (posedge rst_rclk or posedge rd_clk)
   
   
   /*ram8x65_syn   ram8x65_syn_1 (
    .rst_l   (rst_n),
    .clk     (wr_clk),
    .fifo_wr (wptr),
    .data_in (din),
    .fifo_re (rptr),
    .data_out(ram_data_out_pre)
    ); 
    */
   
   cycloneiv_hssi_rx_digis_ram8x70_syn   ram8x70_syn_1 (
                                .rst_l   (rst_n),
                                .clk     (wr_clk),
                                .fifo_wr (wptr),
                                .data_in (din),
                                .fifo_re (rptr),
                                .data_out(ram_data_out_pre)
                                );

         
  always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk)
	  begin
	     ram_data_out <= #1 70'h000000000000000000;
	  end
	else if (rphfifo_regmode_rx)
	  begin
	     ram_data_out <= #1 din;
	  end
	else
	  begin
             ram_data_out <= #1 ram_data_out_pre;
	  end
  end // always @ (posedge rst_rclk or posedge rd_clk)

      
  always@(wptr)
     begin
	case(wptr)
	  8'h01: wptr_bin = 3'h0;
	  8'h02: wptr_bin = 3'h1;
	  8'h04: wptr_bin = 3'h2;
	  8'h08: wptr_bin = 3'h3;
	  8'h10: wptr_bin = 3'h4;
	  8'h20: wptr_bin = 3'h5;
	  8'h40: wptr_bin = 3'h6;
	  8'h80: wptr_bin = 3'h7;
	  default: wptr_bin = 3'h7;
	endcase // case(wptr)
     end // always@ (wptr)
   
   
   always@(rptr)
     begin
	case(rptr)
	  8'h01: rptr_bin = 3'h0;
	  8'h02: rptr_bin = 3'h1;
	  8'h04: rptr_bin = 3'h2;
	  8'h08: rptr_bin = 3'h3;
	  8'h10: rptr_bin = 3'h4;
	  8'h20: rptr_bin = 3'h5;
	  8'h40: rptr_bin = 3'h6;
	  8'h80: rptr_bin = 3'h7;
	  default: rptr_bin = 3'h7;
	endcase // case(rptr)
     end // always@ (rptr)
   
   
   always@(rptr1)
     begin
	case(rptr1)
	  8'h01: rptr1_bin = 3'h0;
	  8'h02: rptr1_bin = 3'h1;
	  8'h04: rptr1_bin = 3'h2;
	  8'h08: rptr1_bin = 3'h3;
	  8'h10: rptr1_bin = 3'h4;
	  8'h20: rptr1_bin = 3'h5;
	  8'h40: rptr1_bin = 3'h6;
	  8'h80: rptr1_bin = 3'h7;
	  default: rptr1_bin = 3'h7;
	endcase // case(rptr1)
     end // always@ (rptr1)
   
   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
          wptr_gray <= #1 3'h0;
        else
          wptr_gray <= #1 wptr_gray0;
     end
   
   always@(wptr)
     begin
	case(wptr)
	  8'h01: wptr_gray0 = 3'h0;
	  8'h02: wptr_gray0 = 3'h1;
	  8'h04: wptr_gray0 = 3'h3;
	  8'h08: wptr_gray0 = 3'h2;
	  8'h10: wptr_gray0 = 3'h6;
	  8'h20: wptr_gray0 = 3'h7;
	  8'h40: wptr_gray0 = 3'h5;
	  8'h80: wptr_gray0 = 3'h4;
	  default: wptr_gray0 = 3'h0;
	endcase // case(wptr)
     end // always@ (wptr)
   
   
   always@(wptr1)
     begin
	case(wptr1)
	  3'h0: wptr1_onehot = 8'h01;
	  3'h1: wptr1_onehot = 8'h02;
	  3'h3: wptr1_onehot = 8'h04;
	  3'h2: wptr1_onehot = 8'h08;
	  3'h6: wptr1_onehot = 8'h10;
	  3'h7: wptr1_onehot = 8'h20;
	  3'h5: wptr1_onehot = 8'h40;
	  3'h4: wptr1_onehot = 8'h80;
	  default: wptr1_onehot = 8'h80;
	endcase // case(wptr1)
     end // always@ (wptr1)
   
   
   always@(wptr1)
     begin
	case(wptr1)
	  3'h0: wptr1_bin_rclk = 3'h0;
	  3'h1: wptr1_bin_rclk = 3'h1;
	  3'h3: wptr1_bin_rclk = 3'h2;
	  3'h2: wptr1_bin_rclk = 3'h3;
	  3'h6: wptr1_bin_rclk = 3'h4;
	  3'h7: wptr1_bin_rclk = 3'h5;
	  3'h5: wptr1_bin_rclk = 3'h6;
	  3'h4: wptr1_bin_rclk = 3'h7;
	  default: wptr1_bin_rclk = 3'h0;
	endcase // case(wptr1)
     end // always@ (wptr1)
      
endmodule // ph_fifo_rx



`timescale 1ns / 1ps

module cycloneiv_hssi_rx_digis_ram16x14_syn (
    clk,
    rst_l, 
    addr_wr,
    addr_rd1,
    addr_rd2,
    data_in,
    we,
    re_l,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[15:0]	addr_wr;
input 	[15:0] 	addr_rd1;
input 	[15:0] 	addr_rd2;
input 	[13:0] 	data_in;
input 		we, re_l;
output 	[13:0] 	data_out1;
output 	[13:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 14;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, ram_array_d_3,
		    ram_array_d_4, ram_array_d_5, ram_array_d_6, ram_array_d_7,
		    ram_array_d_8, ram_array_d_9, ram_array_d_10, 
                    ram_array_d_11,
		    ram_array_d_12, ram_array_d_13, ram_array_d_14, 
                    ram_array_d_15,
		    ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3,
		    ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7,
		    ram_array_q_8, ram_array_q_9, ram_array_q_10, 
                    ram_array_q_11,
		    ram_array_q_12, ram_array_q_13, ram_array_q_14, 
                    ram_array_q_15;
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11,
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15;

 /* Modelling the read port */
 /* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( addr_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( addr_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( addr_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( addr_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( addr_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( addr_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( addr_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( addr_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( addr_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( addr_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( addr_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( addr_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( addr_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( addr_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( addr_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( addr_wr[15] == 1'b1 ) ? data_in : ram_array_q_15;


assign #read_access_time data_out1 = re_l ? 14'b00000000000000 : data_out1_i;
assign #read_access_time data_out2 = re_l ? 14'b00000000000000 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or 
    addr_rd1		or
    addr_rd2		)
begin
    case ( addr_rd1 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out1_i = ram_array_q_0;
    16'b0000000000000010 : data_out1_i = ram_array_q_1;
    16'b0000000000000100 : data_out1_i = ram_array_q_2;
    16'b0000000000001000 : data_out1_i = ram_array_q_3;
    16'b0000000000010000 : data_out1_i = ram_array_q_4;
    16'b0000000000100000 : data_out1_i = ram_array_q_5;
    16'b0000000001000000 : data_out1_i = ram_array_q_6;
    16'b0000000010000000 : data_out1_i = ram_array_q_7;
    16'b0000000100000000 : data_out1_i = ram_array_q_8;
    16'b0000001000000000 : data_out1_i = ram_array_q_9;
    16'b0000010000000000 : data_out1_i = ram_array_q_10;
    16'b0000100000000000 : data_out1_i = ram_array_q_11;
    16'b0001000000000000 : data_out1_i = ram_array_q_12;
    16'b0010000000000000 : data_out1_i = ram_array_q_13;
    16'b0100000000000000 : data_out1_i = ram_array_q_14;
    16'b1000000000000000 : data_out1_i = ram_array_q_15;
    endcase

    case ( addr_rd2 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out2_i = ram_array_q_0;
    16'b0000000000000010 : data_out2_i = ram_array_q_1;
    16'b0000000000000100 : data_out2_i = ram_array_q_2;
    16'b0000000000001000 : data_out2_i = ram_array_q_3;
    16'b0000000000010000 : data_out2_i = ram_array_q_4;
    16'b0000000000100000 : data_out2_i = ram_array_q_5;
    16'b0000000001000000 : data_out2_i = ram_array_q_6;
    16'b0000000010000000 : data_out2_i = ram_array_q_7;
    16'b0000000100000000 : data_out2_i = ram_array_q_8;
    16'b0000001000000000 : data_out2_i = ram_array_q_9;
    16'b0000010000000000 : data_out2_i = ram_array_q_10;
    16'b0000100000000000 : data_out2_i = ram_array_q_11;
    16'b0001000000000000 : data_out2_i = ram_array_q_12;
    16'b0010000000000000 : data_out2_i = ram_array_q_13;
    16'b0100000000000000 : data_out2_i = ram_array_q_14;
    16'b1000000000000000 : data_out2_i = ram_array_q_15;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
        ram_array_q_8 <= #write_access_time 0;
        ram_array_q_9 <= #write_access_time 0;
        ram_array_q_10 <= #write_access_time 0;
        ram_array_q_11 <= #write_access_time 0; 
        ram_array_q_12 <= #write_access_time 0;
        ram_array_q_13 <= #write_access_time 0;
        ram_array_q_14 <= #write_access_time 0;
        ram_array_q_15 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
    end
end
         

always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11	or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15	)
begin
    if(we) begin
	ram_array_d_0 <= #write_access_time data_reg_0;
	ram_array_d_1 <= #write_access_time data_reg_1;
	ram_array_d_2 <= #write_access_time data_reg_2;
	ram_array_d_3 <= #write_access_time data_reg_3;
        ram_array_d_4 <= #write_access_time data_reg_4;
        ram_array_d_5 <= #write_access_time data_reg_5;
        ram_array_d_6 <= #write_access_time data_reg_6;
        ram_array_d_7 <= #write_access_time data_reg_7; 
        ram_array_d_8 <= #write_access_time data_reg_8;
        ram_array_d_9 <= #write_access_time data_reg_9;
        ram_array_d_10 <= #write_access_time data_reg_10;
        ram_array_d_11 <= #write_access_time data_reg_11; 
        ram_array_d_12 <= #write_access_time data_reg_12;
        ram_array_d_13 <= #write_access_time data_reg_13;
        ram_array_d_14 <= #write_access_time data_reg_14;
        ram_array_d_15 <= #write_access_time data_reg_15; 
    end
    else begin
	ram_array_d_0 <= #write_access_time ram_array_q_0;
	ram_array_d_1 <= #write_access_time ram_array_q_1;
	ram_array_d_2 <= #write_access_time ram_array_q_2;
	ram_array_d_3 <= #write_access_time ram_array_q_3;
        ram_array_d_4 <= #write_access_time ram_array_q_4;
        ram_array_d_5 <= #write_access_time ram_array_q_5;
        ram_array_d_6 <= #write_access_time ram_array_q_6;
        ram_array_d_7 <= #write_access_time ram_array_q_7;
        ram_array_d_8 <= #write_access_time ram_array_q_8;
        ram_array_d_9 <= #write_access_time ram_array_q_9;
        ram_array_d_10 <= #write_access_time ram_array_q_10;
        ram_array_d_11 <= #write_access_time ram_array_q_11;
        ram_array_d_12 <= #write_access_time ram_array_q_12;
        ram_array_d_13 <= #write_access_time ram_array_q_13;
        ram_array_d_14 <= #write_access_time ram_array_q_14;
        ram_array_d_15 <= #write_access_time ram_array_q_15;

    end
end

endmodule


`timescale 1ps / 1ps

module cycloneiv_hssi_rx_digis_ram20x16_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re1,
    fifo_re2,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[19:0]	fifo_wr;
input 	[19:0] 	fifo_re1;
input 	[19:0] 	fifo_re2;
input 	[15:0] 	data_in;
output 	[15:0] 	data_out1;
output 	[15:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 16;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, ram_array_d_8, 
                    ram_array_d_9, ram_array_d_10, ram_array_d_11,
                    ram_array_d_12, ram_array_d_13, ram_array_d_14,
		    ram_array_d_15, ram_array_d_16, ram_array_d_17, 
		    ram_array_d_18, ram_array_d_19, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7, ram_array_q_8, 
                    ram_array_q_9, ram_array_q_10, ram_array_q_11,
                    ram_array_q_12, ram_array_q_13, ram_array_q_14,
		    ram_array_q_15, ram_array_q_16, ram_array_q_17, 
		    ram_array_q_18, ram_array_q_19; 
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11, 
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15, 
	             data_reg_16, data_reg_17, data_reg_18, data_reg_19;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( fifo_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( fifo_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( fifo_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( fifo_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( fifo_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( fifo_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( fifo_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( fifo_wr[15] == 1'b1 ) ? data_in : ram_array_q_15,
    data_reg_16 = ( fifo_wr[16] == 1'b1 ) ? data_in : ram_array_q_16,
    data_reg_17 = ( fifo_wr[17] == 1'b1 ) ? data_in : ram_array_q_17,
    data_reg_18 = ( fifo_wr[18] == 1'b1 ) ? data_in : ram_array_q_18,
    data_reg_19 = ( fifo_wr[19] == 1'b1 ) ? data_in : ram_array_q_19;


// 03/22/05 VC: LEDA fix: Remove delay on combinatorial statement
//                        and changed 15'b0 to 16'd0
//assign #read_access_time data_out1 = re_l ? 15'b0 : data_out1_i;
//assign #read_access_time data_out2 = re_l ? 15'b0 : data_out2_i;
assign data_out1 = re_l ? 16'd0 : data_out1_i;
assign data_out2 = re_l ? 16'd0 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or 
    ram_array_q_13      or 
    ram_array_q_14      or 
    ram_array_q_15      or 
    ram_array_q_16      or 
    ram_array_q_17      or 
    ram_array_q_18      or 
    ram_array_q_19      or 
    fifo_re1		or
    fifo_re2		)
begin
// 03/22/05 VC: Removed full case statement because
//              not all cases are listed
//    case ( fifo_re1 )  // synopsys parallel_case full_case
    case ( fifo_re1 )  // synopsys parallel_case
    20'b00000000000000000001 : data_out1_i = ram_array_q_0;
    20'b00000000000000000010 : data_out1_i = ram_array_q_1;
    20'b00000000000000000100 : data_out1_i = ram_array_q_2;
    20'b00000000000000001000 : data_out1_i = ram_array_q_3;
    20'b00000000000000010000 : data_out1_i = ram_array_q_4;
    20'b00000000000000100000 : data_out1_i = ram_array_q_5;
    20'b00000000000001000000 : data_out1_i = ram_array_q_6;
    20'b00000000000010000000 : data_out1_i = ram_array_q_7;
    20'b00000000000100000000 : data_out1_i = ram_array_q_8;
    20'b00000000001000000000 : data_out1_i = ram_array_q_9;
    20'b00000000010000000000 : data_out1_i = ram_array_q_10;
    20'b00000000100000000000 : data_out1_i = ram_array_q_11;
    20'b00000001000000000000 : data_out1_i = ram_array_q_12;
    20'b00000010000000000000 : data_out1_i = ram_array_q_13;
    20'b00000100000000000000 : data_out1_i = ram_array_q_14;
    20'b00001000000000000000 : data_out1_i = ram_array_q_15;
    20'b00010000000000000000 : data_out1_i = ram_array_q_16;
    20'b00100000000000000000 : data_out1_i = ram_array_q_17;
    20'b01000000000000000000 : data_out1_i = ram_array_q_18;
    20'b10000000000000000000 : data_out1_i = ram_array_q_19;
// 03/22/05 VC: LEDA fix: Added default clause to case statement
    default                  : data_out1_i = ram_array_q_0;
    endcase

// 03/22/05 VC: Removed full case statement because
//              not all cases are listed
//    case ( fifo_re2 )  // synopsys parallel_case full_case
    case ( fifo_re2 )  // synopsys parallel_case
    20'b00000000000000000001 : data_out2_i = ram_array_q_0;
    20'b00000000000000000010 : data_out2_i = ram_array_q_1;
    20'b00000000000000000100 : data_out2_i = ram_array_q_2;
    20'b00000000000000001000 : data_out2_i = ram_array_q_3;
    20'b00000000000000010000 : data_out2_i = ram_array_q_4;
    20'b00000000000000100000 : data_out2_i = ram_array_q_5;
    20'b00000000000001000000 : data_out2_i = ram_array_q_6;
    20'b00000000000010000000 : data_out2_i = ram_array_q_7;
    20'b00000000000100000000 : data_out2_i = ram_array_q_8;
    20'b00000000001000000000 : data_out2_i = ram_array_q_9;
    20'b00000000010000000000 : data_out2_i = ram_array_q_10;
    20'b00000000100000000000 : data_out2_i = ram_array_q_11;
    20'b00000001000000000000 : data_out2_i = ram_array_q_12;
    20'b00000010000000000000 : data_out2_i = ram_array_q_13;
    20'b00000100000000000000 : data_out2_i = ram_array_q_14;
    20'b00001000000000000000 : data_out2_i = ram_array_q_15;
    20'b00010000000000000000 : data_out2_i = ram_array_q_16;
    20'b00100000000000000000 : data_out2_i = ram_array_q_17;
    20'b01000000000000000000 : data_out2_i = ram_array_q_18;
    20'b10000000000000000000 : data_out2_i = ram_array_q_19;
// 03/22/05 VC: LEDA fix: Added default clause to case statement
    default                  : data_out2_i = ram_array_q_0;
    endcase
end


// 03/22/05 VC: LEDA fix: Change 0 to 16'd0
/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 16'd0;
	ram_array_q_1 <= #write_access_time 16'd0;
	ram_array_q_2 <= #write_access_time 16'd0; 
	ram_array_q_3 <= #write_access_time 16'd0; 
        ram_array_q_4 <= #write_access_time 16'd0;
        ram_array_q_5 <= #write_access_time 16'd0;
        ram_array_q_6 <= #write_access_time 16'd0;
        ram_array_q_7 <= #write_access_time 16'd0; 
        ram_array_q_8 <= #write_access_time 16'd0;
        ram_array_q_9 <= #write_access_time 16'd0;
        ram_array_q_10 <= #write_access_time 16'd0;
        ram_array_q_11 <= #write_access_time 16'd0; 
        ram_array_q_12 <= #write_access_time 16'd0; 
        ram_array_q_13 <= #write_access_time 16'd0; 
        ram_array_q_14 <= #write_access_time 16'd0; 
        ram_array_q_15 <= #write_access_time 16'd0; 
        ram_array_q_16 <= #write_access_time 16'd0; 
        ram_array_q_17 <= #write_access_time 16'd0; 
        ram_array_q_18 <= #write_access_time 16'd0; 
        ram_array_q_19 <= #write_access_time 16'd0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
        ram_array_q_16 <= #write_access_time ram_array_d_16;
        ram_array_q_17 <= #write_access_time ram_array_d_17;
        ram_array_q_18 <= #write_access_time ram_array_d_18;
        ram_array_q_19 <= #write_access_time ram_array_d_19;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    data_reg_16         or
    data_reg_17         or
    data_reg_18         or
    data_reg_19         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or
    ram_array_q_16      or
    ram_array_q_17      or
    ram_array_q_18      or
    ram_array_q_19	)
begin
    if(we) begin
	ram_array_d_0 = data_reg_0;
	ram_array_d_1 = data_reg_1;
	ram_array_d_2 = data_reg_2;
	ram_array_d_3 = data_reg_3;
        ram_array_d_4 = data_reg_4;
        ram_array_d_5 = data_reg_5;
        ram_array_d_6 = data_reg_6;
        ram_array_d_7 = data_reg_7; 
        ram_array_d_8 = data_reg_8;
        ram_array_d_9 = data_reg_9;
        ram_array_d_10 = data_reg_10;
        ram_array_d_11 = data_reg_11; 
        ram_array_d_12 = data_reg_12; 
        ram_array_d_13 = data_reg_13; 
        ram_array_d_14 = data_reg_14; 
        ram_array_d_15 = data_reg_15; 
        ram_array_d_16 = data_reg_16; 
        ram_array_d_17 = data_reg_17; 
        ram_array_d_18 = data_reg_18; 
        ram_array_d_19 = data_reg_19; 
    end
    else begin
	ram_array_d_0 = ram_array_q_0;
	ram_array_d_1 = ram_array_q_1;
	ram_array_d_2 = ram_array_q_2;
	ram_array_d_3 = ram_array_q_3;
        ram_array_d_4 = ram_array_q_4;
        ram_array_d_5 = ram_array_q_5;
        ram_array_d_6 = ram_array_q_6;
        ram_array_d_7 = ram_array_q_7;
        ram_array_d_8 = ram_array_q_8;
        ram_array_d_9 = ram_array_q_9;
        ram_array_d_10 = ram_array_q_10;
        ram_array_d_11 = ram_array_q_11;
        ram_array_d_12 = ram_array_q_12;
        ram_array_d_13 = ram_array_q_13;
        ram_array_d_14 = ram_array_q_14;
        ram_array_d_15 = ram_array_q_15;
        ram_array_d_16 = ram_array_q_16;
        ram_array_d_17 = ram_array_q_17;
        ram_array_d_18 = ram_array_q_18;
        ram_array_d_19 = ram_array_q_19;
    end
end

endmodule

`timescale 1 ps / 1 ps

module cycloneiv_hssi_rx_digis_ram8x70_syn (
    rst_l, 
    clk,
    fifo_wr,
    data_in,
    fifo_re,
    data_out
    );

input 		rst_l;
input 		clk;
input 	[7:0]	fifo_wr;
input 	[69:0] 	data_in;
input 	[7:0] 	fifo_re;
output 	[69:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 70;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 70'b0 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 70'h020000000000000000;
	ram_array_q_1 <= #write_access_time 70'h020000000000000000;
	ram_array_q_2 <= #write_access_time 70'h020000000000000000; 
	ram_array_q_3 <= #write_access_time 70'h020000000000000000; 
        ram_array_q_4 <= #write_access_time 70'h020000000000000000;
        ram_array_q_5 <= #write_access_time 70'h020000000000000000;
        ram_array_q_6 <= #write_access_time 70'h020000000000000000;
        ram_array_q_7 <= #write_access_time 70'h020000000000000000; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 =  data_reg_0;
	ram_array_d_1 =  data_reg_1;
	ram_array_d_2 =  data_reg_2;
	ram_array_d_3 =  data_reg_3;
        ram_array_d_4 =  data_reg_4;
        ram_array_d_5 =  data_reg_5;
        ram_array_d_6 =  data_reg_6;
        ram_array_d_7 =  data_reg_7; 
    end
    else begin
	ram_array_d_0 =  ram_array_q_0;
	ram_array_d_1 =  ram_array_q_1;
	ram_array_d_2 =  ram_array_q_2;
	ram_array_d_3 =  ram_array_q_3;
        ram_array_d_4 =  ram_array_q_4;
        ram_array_d_5 =  ram_array_q_5;
        ram_array_d_6 =  ram_array_q_6;
        ram_array_d_7 =  ram_array_q_7;
    end
end

endmodule

`timescale 1 ps / 1 ps

module cycloneiv_hssi_rx_digis_rxclk_gating (
		     select_n,
		     clk1,
		     clk2,
		     clk1out_n,
		     clk2out_n
		     );
   
   input select_n;
   input clk1;
   input clk2;
   output clk1out_n;
   output clk2out_n;
   
   assign clk1out_n = ~(select_n | clk1);
   assign clk2out_n = ~(~select_n | clk2);
   
endmodule // rxclk_gating


`timescale 1 ns /1 ps

module cycloneiv_hssi_rx_digi_rxclk_ctl (pld_rx_clk,	
		  rcvd_clk_pma,	          
    		  rcvd_clk0_pma,          
		  tx_pma_clk,	          
		  refclk_pma,             
    		  fref,                 
    		  clklow,
		  scan_mode,              
    		  gen2ngen1,              
    		  gen2ngen1_bundle,       
    		  rx_div2_sync_centrl,    
    		  rx_div2_sync_quad_up,   
    		  rx_div2_sync_quad_down, 
		  rrcvd_clk_sel,
     		  rclk_1_sel,
     		  rclk_2_sel,
		  rrx_rd_clk_sel,         
		  rxrst,                  
		  rindv_rx,               
    		  rdwidth_rx,             
		  rfreerun_rx,            
    		  rauto_speed_ena,        
    		  rfreq_sel,              
    		  rrxpcsclkpwdn,          
    		  rmaster_rx,             
    		  rmaster_up_rx,          
		  rself_sw_en_rx,         
    		  fref_muxed,
    		  clklow_muxed,       
		  rcvd_clk,
		  clk_1_b,
		  clk_2_b,
		  rx_wr_clk,              
		  rx_rd_clk,              
		  rx_clk,                 
		  rcvd_clk_pma_b,         
    		  clk_2_b_raw,            
    		  rx_wr_clk_raw,          
		  rx_rd_clk_raw,          
		  rx_div2_sync_out 
                  );

   // Clock Inputs
   input          pld_rx_clk;	          // PLD clock from PLD clock trees
   input          rcvd_clk_pma;	          // local recovered clock
   input 	  rcvd_clk0_pma;          // channel zero recovered clock
   input          tx_pma_clk;	          // local TX PMA clock
   input          refclk_pma;             // Quad based clk from TXPLL
   input 	  fref;                 
   input 	  clklow;

   // Control Inputs
   input          scan_mode;              // Scan mode enable signal
   input          rxrst;                  // This is the soft_reset for the RX_PCS

   // New Control Inputs
   input 	  gen2ngen1;              // from PMA for PCIexp Gen1/Gen2 datawidth scaling
   input 	  gen2ngen1_bundle;       // from PMA for PCIexp Gen1/Gen2 datawidth scaling in x4 and x8 
   input 	  rx_div2_sync_centrl;    // divided clock from the central channel (x2, x4 mode)
   input 	  rx_div2_sync_quad_up;   // divided clock from quad above (> x4 mode)
   input 	  rx_div2_sync_quad_down; // divided clock from quad below (> x4 mode)
   
   // MDIO Inputs
   input [1:0] 	  rrcvd_clk_sel;
   input [1:0] 	  rclk_1_sel;
   input [1:0] 	  rclk_2_sel;
   input          rrx_rd_clk_sel;         // Select clock for rx ph comp fifo read side
   input          rindv_rx;               // Select between XAUI mode or indiv  channel mode
   input 	  rdwidth_rx;             // divide by 1 or 2 before feeding to FIFO write clock
   input          rfreerun_rx;            // Select whether divider is permamently enabled (free -running) or divider should be enabled / reset by RX PCS reset

   // New MDIO Inputs
   input 	  rauto_speed_ena;        // auto speed negotiation enable
   input 	  rfreq_sel;              // freq scaling or data width scaling
   input 	  rrxpcsclkpwdn;          // RX clocking power down enable
   input 	  rmaster_rx;             // New bundle mode MDIO, selects master quad
   input 	  rmaster_up_rx;          // New bundle mode MDIO, selects master quad
   input          rself_sw_en_rx;         // enables self-switch to have correct /2 clock in all quads in bundle mode
   
   // Removed Inputs
   //    input          rphfifo_master_sel_rx;  // RX Phase comp. FIFO rx_div2_sync selection CRAM
   //    input          rx_div2_sync_in_ch0;    // Connect from channel zero rx_div2_sync_out
   //    input          rx_div2_sync_in_q0_ch0; // Connect from channel zero rx_div2_sync_out of Master Quad

 
   // Clock Outputs with CTS
   output 	  fref_muxed;
   output 	  clklow_muxed;       
   output         rcvd_clk;
   output         clk_1_b;
   output         clk_2_b;
   output         rx_wr_clk;              // drives the rx ph comp fifo write clock tree
   output         rx_rd_clk;              // drives the rx ph comp fifo read clock tree

   // Clock Outputs to PLD, no CTS
   output         rx_clk;                 // drives the PLD clock tree in x1 mode, logically same as rx_wr_clk
   output         rcvd_clk_pma_b;         // debug output clock to PLD

   // New Clock Outputs with CTS
   output 	  clk_2_b_raw;            // same as clk_2_b, but with no clock gating
   output 	  rx_wr_clk_raw;          // same as rx_wr_clk, but with no clock gating
   output         rx_rd_clk_raw;          // same as rx_rd_clk, but with no clock gating

   // Control Outputs
   output         rx_div2_sync_out;       // inverted /2 clock.  not used w/new bundling scheme. (left for safety)

   
   reg 		  rx_clk_2_by2;
   reg 		  gen2ngen1_local_sync;
   reg [1:0] 	  counter;
      
   wire 	  rx_div2_sync;
   wire 	  rx_div2_sync_out;
   wire 	  rx_rst_n;
   wire [1:0] 	  rrcvd_clk_sel_int;
   wire [1:0] 	  rclk_1_sel_int;
   wire [1:0] 	  rclk_2_sel_int;
   wire 	  dynamic_div2ndiv1;
   wire 	  gen2ngen1_local;
   wire 	  fref_muxed;
   wire 	  clklow_muxed;
   wire 	  rrxpcsclkpwdn_nscan;
   wire 	  rx_div2_this_quad;
   wire           rx_div2_this_channel;
   wire 	  rx_div2_other_quad;
   wire 	  force_master;

   wire 	  select_div1_n;
   wire 	  clk1out_n;
   wire 	  clk2out_n;
   
// shawn initial begin ------
initial begin
		rx_clk_2_by2 = 1'b1;
end             
// shawn initial end   ------
   
   // Old bundle logic:
   // Select between the local synchronization signal or the global synchronization signal
   //assign rx_div2_sync = rindv_rx ? rx_div2_sync_out : rx_div2_sync_in;
   // assign 	  rx_div2_sync = (rphfifo_master_sel_rx == 1'b0) ? rx_div2_sync_in_q0_ch0 :
   // 				 (rindv_rx == 1'b0) ? rx_div2_sync_in_ch0 : 
   // 				 (rauto_speed_ena & ~rfreq_sel) ? (rx_div2_sync_out | ~gen2ngen1_local_sync) : rx_div2_sync_out;

   always @(posedge rxrst or posedge clk_2_b_raw)
     begin
	if (rxrst)
	  counter <= #1 2'b00;
	else if ((rauto_speed_ena & ~rfreq_sel & rself_sw_en_rx) & ~force_master)
	  counter <= #1 counter + 1'b1;
     end

   assign force_master = ((counter == 2'b11) & (rauto_speed_ena & ~rfreq_sel & rself_sw_en_rx)) ? 1'b1 : 1'b0;
      
   assign rx_div2_sync = (rmaster_rx | force_master) ? rx_div2_this_quad : rx_div2_other_quad;
   assign rx_div2_this_quad = (rindv_rx | force_master) ? rx_div2_this_channel : rx_div2_sync_centrl;
   assign rx_div2_this_channel = (rauto_speed_ena & ~rfreq_sel) ? (rx_div2_sync_out | ~gen2ngen1_local_sync) : rx_div2_sync_out;
   assign rx_div2_other_quad = rmaster_up_rx ? rx_div2_sync_quad_up : rx_div2_sync_quad_down;
   
   assign gen2ngen1_local = (rindv_rx == 1'b0) ? gen2ngen1_bundle : gen2ngen1;
   

   always @(posedge rxrst or posedge clk_2_b_raw)
     begin
	if (rxrst)
	  gen2ngen1_local_sync <= #1 1'b0;
	else
	  gen2ngen1_local_sync <= #1 gen2ngen1_local;
     end
   
   assign dynamic_div2ndiv1 = rdwidth_rx | (gen2ngen1_local_sync & rauto_speed_ena & ~rfreq_sel);


   // Reset for Divide-by-2 FF and synchronization FF's for clock gating
   assign rx_rst_n = (rfreerun_rx) ? 1'b1 : ~rxrst;

   assign rrxpcsclkpwdn_nscan = rrxpcsclkpwdn & ~scan_mode;
   
  
   
   // clocks are assigned below in the order in which they appear in the out flowing data path
   // RCVD_CLK selection
   assign rrcvd_clk_sel_int = (scan_mode) ? 2'b01 : rrcvd_clk_sel;
   assign rcvd_clk = 	rrxpcsclkpwdn_nscan ? 1'b1 :
	                (rrcvd_clk_sel_int == 2'b00) ? rcvd_clk_pma  : 
	                (rrcvd_clk_sel_int == 2'b01) ? refclk_pma : 
	                (rrcvd_clk_sel_int == 2'b10) ? tx_pma_clk : 
	                (rrcvd_clk_sel_int == 2'b11) ? rcvd_clk_pma : rcvd_clk_pma; 
   
   // CLK_1 seleciton
   assign rclk_1_sel_int = (scan_mode) ? 2'b01 : rclk_1_sel;
   assign clk_1_b =     rrxpcsclkpwdn_nscan ? 1'b1 :
 	                (rclk_1_sel_int == 2'b00) ? rcvd_clk_pma  : 
	                (rclk_1_sel_int == 2'b01) ? refclk_pma : 
	                (rclk_1_sel_int == 2'b10) ? tx_pma_clk : 
	                (rclk_1_sel_int == 2'b11) ? rcvd_clk0_pma : rcvd_clk_pma; 
   
   // CLK_2 selection
   assign rclk_2_sel_int = (scan_mode) ? 2'b10 : rclk_2_sel;
   assign clk_2_b_raw =	(rclk_2_sel_int == 2'b00) ? rcvd_clk_pma : 
	                (rclk_2_sel_int == 2'b01) ? tx_pma_clk : 
	                (rclk_2_sel_int == 2'b10) ? refclk_pma : rcvd_clk_pma; 
   //change made for S3GX to remove pld_rx_clk from mux input 
   //(rclk_2_sel_int == 2'b10) ? refclk_pma : 
   //(rclk_2_sel_int == 2'b11) ? pld_rx_clk : rcvd_clk_pma;

   assign clk_2_b = rrxpcsclkpwdn_nscan ? 1'b1 : clk_2_b_raw;
   

   // This register is used to generate divided by two clock. Div by 2 clock starts off high after reset
   // No #1 on this FF as it generates a clock
   always @(negedge rx_rst_n or posedge clk_2_b_raw)
     begin
	if (~rx_rst_n)
	  rx_clk_2_by2 <= 1'b1;
	else
	  rx_clk_2_by2 <= rx_div2_sync;
     end
      
   assign rx_div2_sync_out = ~rx_clk_2_by2;

      

   // RX FIFO write clock: could be fast or divided by 2
   // old code:
   // assign rx_wr_clk = ((rdwidth_rx == 1'b0) || scan_mode) ? clk_2_b_raw : rx_clk_2_by2;
   
   assign select_div1_n = ~(scan_mode | ~dynamic_div2ndiv1);
   
   cycloneiv_hssi_rx_digis_rxclk_gating rxclk_gating (
			      .select_n(select_div1_n),
			      .clk1(clk_2_b_raw),
			      .clk2(rx_clk_2_by2),
			      .clk1out_n(clk1out_n),
			      .clk2out_n(clk2out_n)
			      );
   
   assign rx_wr_clk_raw = ~(clk1out_n | clk2out_n);

   
   assign rx_wr_clk = rrxpcsclkpwdn_nscan ? 1'b1 : rx_wr_clk_raw;

      
   // RX FIFO read clock
   assign rx_rd_clk_raw = (scan_mode | (rrx_rd_clk_sel == 1'b0)) ? rx_wr_clk_raw : pld_rx_clk;
   assign rx_rd_clk = rrxpcsclkpwdn_nscan ? 1'b1 : rx_rd_clk_raw;

   
   // RX clock out
   assign rx_clk = rx_wr_clk; // drives PLD clock tree
   
   // Recovered clock for debugging
   assign rcvd_clk_pma_b = rcvd_clk_pma; // Goes out to PLD as debug clock. This clock may or may not be routed out to PLD fabric. TBD

   
   assign fref_muxed = scan_mode ? refclk_pma : rrxpcsclkpwdn ? 1'b1 : fref;
   assign clklow_muxed = scan_mode ? refclk_pma : rrxpcsclkpwdn ? 1'b1 : clklow;
   
   
endmodule // rxclk_ctl

//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 74 mux21 44 oper_add 1 oper_decoder 1 oper_mux 4 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_rx_digi_auto_speed_neg
	( 
	config_sel,
	config_sel_centrl,
	config_sel_quad_down,
	config_sel_quad_up,
	cs,
	dis_pc_byte,
	gen2ngen1,
	pcie_switch,
	rate,
	rauto_deassert_pc_rst_cnt,
	rauto_pc_en_cnt,
	rauto_speed_ena,
	refclk,
	reset_pc_ptrs,
	rindv_rx,
	rmaster_rx,
	rmaster_up_rx,
	rphfifo_regmode_rx,
	rpma_done_count,
	rwait_for_phfifo_cnt,
	rxpcs_rst_int,
	singleorbundle,
	speed_change) /* synthesis synthesis_clearbox=1 */;
	output   config_sel;
	input   config_sel_centrl;
	input   config_sel_quad_down;
	input   config_sel_quad_up;
	output   [3:0]  cs;
	output   dis_pc_byte;
	input   gen2ngen1;
	output   pcie_switch;
	input   rate;
	input   [3:0]  rauto_deassert_pc_rst_cnt;
	input   [4:0]  rauto_pc_en_cnt;
	input   rauto_speed_ena;
	input   refclk;
	output   reset_pc_ptrs;
	input   rindv_rx;
	input   rmaster_rx;
	input   rmaster_up_rx;
	input   rphfifo_regmode_rx;
	input   [17:0]  rpma_done_count;
	input   [5:0]  rwait_for_phfifo_cnt;
	input   rxpcs_rst_int;
	input   singleorbundle;
	output   speed_change;

	reg	n000l43;
	reg	n000l44;
	reg	n00ii41;
	reg	n00ii42;
	reg	n00il39;
	reg	n00il40;
	reg	n00ll37;
	reg	n00ll38;
	reg	n00Ol35;
	reg	n00Ol36;
	reg	n0i0i31;
	reg	n0i0i32;
	reg	n0i0O29;
	reg	n0i0O30;
	reg	n0i1i33;
	reg	n0i1i34;
	reg	n0iil27;
	reg	n0iil28;
	reg	n0ili25;
	reg	n0ili26;
	reg	n0ilO23;
	reg	n0ilO24;
	reg	n0iOl21;
	reg	n0iOl22;
	reg	n0l0i17;
	reg	n0l0i18;
	reg	n0l0O15;
	reg	n0l0O16;
	reg	n0l1i19;
	reg	n0l1i20;
	reg	n0lli13;
	reg	n0lli14;
	reg	n0lOO11;
	reg	n0lOO12;
	reg	n0O0i3;
	reg	n0O0i4;
	reg	n0O0l1;
	reg	n0O0l2;
	reg	n0O1i10;
	reg	n0O1i9;
	reg	n0O1l7;
	reg	n0O1l8;
	reg	n0O1O5;
	reg	n0O1O6;
	reg	n11l;
	reg	n11i_clk_prev;
	wire	wire_n11i_PRN;
	wire	wire_n11i_ENA;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n01i;
	reg	n01l;
	reg	n01O;
	reg	n0ii;
	reg	n0il;
	reg	n0iO;
	reg	n0li;
	reg	n0ll;
	reg	n0lO;
	reg	n0Oi;
	reg	n0Ol;
	reg	n0OO;
	reg	n10i;
	reg	n10l;
	reg	n11O;
	reg	n1il;
	reg	n1iO;
	reg	n1li;
	reg	n1Ol;
	reg	n1OO;
	reg	ni1i;
	reg	ni1O;
	reg	nll0i;
	reg	nlOOi;
	reg	nlOOl;
	reg	nlOOO;
	wire	wire_ni1l_CLRN;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire  [18:0]   wire_nO_o;
	wire  [15:0]   wire_nllii_o;
	wire  wire_nliOO_o;
	wire  wire_nll1i_o;
	wire  wire_nll1l_o;
	wire  wire_nll1O_o;
	wire  n000i;
	wire  n001l;
	wire  n001O;
	wire  n00li;
	wire  n00lO;
	wire  n00Oi;
	wire  n0i1O;
	wire  n0l1O;
	wire  n0lil;
	wire  n0liO;
	wire  n0llO;

	initial
		n000l43 = 0;
	always @ ( posedge refclk)
		  n000l43 <= n000l44;
	event n000l43_event;
	initial
		#1 ->n000l43_event;
	always @(n000l43_event)
		n000l43 <= {1{1'b1}};
	initial
		n000l44 = 0;
	always @ ( posedge refclk)
		  n000l44 <= n000l43;
	initial
		n00ii41 = 0;
	always @ ( posedge refclk)
		  n00ii41 <= n00ii42;
	event n00ii41_event;
	initial
		#1 ->n00ii41_event;
	always @(n00ii41_event)
		n00ii41 <= {1{1'b1}};
	initial
		n00ii42 = 0;
	always @ ( posedge refclk)
		  n00ii42 <= n00ii41;
	initial
		n00il39 = 0;
	always @ ( posedge refclk)
		  n00il39 <= n00il40;
	event n00il39_event;
	initial
		#1 ->n00il39_event;
	always @(n00il39_event)
		n00il39 <= {1{1'b1}};
	initial
		n00il40 = 0;
	always @ ( posedge refclk)
		  n00il40 <= n00il39;
	initial
		n00ll37 = 0;
	always @ ( posedge refclk)
		  n00ll37 <= n00ll38;
	event n00ll37_event;
	initial
		#1 ->n00ll37_event;
	always @(n00ll37_event)
		n00ll37 <= {1{1'b1}};
	initial
		n00ll38 = 0;
	always @ ( posedge refclk)
		  n00ll38 <= n00ll37;
	initial
		n00Ol35 = 0;
	always @ ( posedge refclk)
		  n00Ol35 <= n00Ol36;
	event n00Ol35_event;
	initial
		#1 ->n00Ol35_event;
	always @(n00Ol35_event)
		n00Ol35 <= {1{1'b1}};
	initial
		n00Ol36 = 0;
	always @ ( posedge refclk)
		  n00Ol36 <= n00Ol35;
	initial
		n0i0i31 = 0;
	always @ ( posedge refclk)
		  n0i0i31 <= n0i0i32;
	event n0i0i31_event;
	initial
		#1 ->n0i0i31_event;
	always @(n0i0i31_event)
		n0i0i31 <= {1{1'b1}};
	initial
		n0i0i32 = 0;
	always @ ( posedge refclk)
		  n0i0i32 <= n0i0i31;
	initial
		n0i0O29 = 0;
	always @ ( posedge refclk)
		  n0i0O29 <= n0i0O30;
	event n0i0O29_event;
	initial
		#1 ->n0i0O29_event;
	always @(n0i0O29_event)
		n0i0O29 <= {1{1'b1}};
	initial
		n0i0O30 = 0;
	always @ ( posedge refclk)
		  n0i0O30 <= n0i0O29;
	initial
		n0i1i33 = 0;
	always @ ( posedge refclk)
		  n0i1i33 <= n0i1i34;
	event n0i1i33_event;
	initial
		#1 ->n0i1i33_event;
	always @(n0i1i33_event)
		n0i1i33 <= {1{1'b1}};
	initial
		n0i1i34 = 0;
	always @ ( posedge refclk)
		  n0i1i34 <= n0i1i33;
	initial
		n0iil27 = 0;
	always @ ( posedge refclk)
		  n0iil27 <= n0iil28;
	event n0iil27_event;
	initial
		#1 ->n0iil27_event;
	always @(n0iil27_event)
		n0iil27 <= {1{1'b1}};
	initial
		n0iil28 = 0;
	always @ ( posedge refclk)
		  n0iil28 <= n0iil27;
	initial
		n0ili25 = 0;
	always @ ( posedge refclk)
		  n0ili25 <= n0ili26;
	event n0ili25_event;
	initial
		#1 ->n0ili25_event;
	always @(n0ili25_event)
		n0ili25 <= {1{1'b1}};
	initial
		n0ili26 = 0;
	always @ ( posedge refclk)
		  n0ili26 <= n0ili25;
	initial
		n0ilO23 = 0;
	always @ ( posedge refclk)
		  n0ilO23 <= n0ilO24;
	event n0ilO23_event;
	initial
		#1 ->n0ilO23_event;
	always @(n0ilO23_event)
		n0ilO23 <= {1{1'b1}};
	initial
		n0ilO24 = 0;
	always @ ( posedge refclk)
		  n0ilO24 <= n0ilO23;
	initial
		n0iOl21 = 0;
	always @ ( posedge refclk)
		  n0iOl21 <= n0iOl22;
	event n0iOl21_event;
	initial
		#1 ->n0iOl21_event;
	always @(n0iOl21_event)
		n0iOl21 <= {1{1'b1}};
	initial
		n0iOl22 = 0;
	always @ ( posedge refclk)
		  n0iOl22 <= n0iOl21;
	initial
		n0l0i17 = 0;
	always @ ( posedge refclk)
		  n0l0i17 <= n0l0i18;
	event n0l0i17_event;
	initial
		#1 ->n0l0i17_event;
	always @(n0l0i17_event)
		n0l0i17 <= {1{1'b1}};
	initial
		n0l0i18 = 0;
	always @ ( posedge refclk)
		  n0l0i18 <= n0l0i17;
	initial
		n0l0O15 = 0;
	always @ ( posedge refclk)
		  n0l0O15 <= n0l0O16;
	event n0l0O15_event;
	initial
		#1 ->n0l0O15_event;
	always @(n0l0O15_event)
		n0l0O15 <= {1{1'b1}};
	initial
		n0l0O16 = 0;
	always @ ( posedge refclk)
		  n0l0O16 <= n0l0O15;
	initial
		n0l1i19 = 0;
	always @ ( posedge refclk)
		  n0l1i19 <= n0l1i20;
	event n0l1i19_event;
	initial
		#1 ->n0l1i19_event;
	always @(n0l1i19_event)
		n0l1i19 <= {1{1'b1}};
	initial
		n0l1i20 = 0;
	always @ ( posedge refclk)
		  n0l1i20 <= n0l1i19;
	initial
		n0lli13 = 0;
	always @ ( posedge refclk)
		  n0lli13 <= n0lli14;
	event n0lli13_event;
	initial
		#1 ->n0lli13_event;
	always @(n0lli13_event)
		n0lli13 <= {1{1'b1}};
	initial
		n0lli14 = 0;
	always @ ( posedge refclk)
		  n0lli14 <= n0lli13;
	initial
		n0lOO11 = 0;
	always @ ( posedge refclk)
		  n0lOO11 <= n0lOO12;
	event n0lOO11_event;
	initial
		#1 ->n0lOO11_event;
	always @(n0lOO11_event)
		n0lOO11 <= {1{1'b1}};
	initial
		n0lOO12 = 0;
	always @ ( posedge refclk)
		  n0lOO12 <= n0lOO11;
	initial
		n0O0i3 = 0;
	always @ ( posedge refclk)
		  n0O0i3 <= n0O0i4;
	event n0O0i3_event;
	initial
		#1 ->n0O0i3_event;
	always @(n0O0i3_event)
		n0O0i3 <= {1{1'b1}};
	initial
		n0O0i4 = 0;
	always @ ( posedge refclk)
		  n0O0i4 <= n0O0i3;
	initial
		n0O0l1 = 0;
	always @ ( posedge refclk)
		  n0O0l1 <= n0O0l2;
	event n0O0l1_event;
	initial
		#1 ->n0O0l1_event;
	always @(n0O0l1_event)
		n0O0l1 <= {1{1'b1}};
	initial
		n0O0l2 = 0;
	always @ ( posedge refclk)
		  n0O0l2 <= n0O0l1;
	initial
		n0O1i10 = 0;
	always @ ( posedge refclk)
		  n0O1i10 <= n0O1i9;
	initial
		n0O1i9 = 0;
	always @ ( posedge refclk)
		  n0O1i9 <= n0O1i10;
	event n0O1i9_event;
	initial
		#1 ->n0O1i9_event;
	always @(n0O1i9_event)
		n0O1i9 <= {1{1'b1}};
	initial
		n0O1l7 = 0;
	always @ ( posedge refclk)
		  n0O1l7 <= n0O1l8;
	event n0O1l7_event;
	initial
		#1 ->n0O1l7_event;
	always @(n0O1l7_event)
		n0O1l7 <= {1{1'b1}};
	initial
		n0O1l8 = 0;
	always @ ( posedge refclk)
		  n0O1l8 <= n0O1l7;
	initial
		n0O1O5 = 0;
	always @ ( posedge refclk)
		  n0O1O5 <= n0O1O6;
	event n0O1O5_event;
	initial
		#1 ->n0O1O5_event;
	always @(n0O1O5_event)
		n0O1O5 <= {1{1'b1}};
	initial
		n0O1O6 = 0;
	always @ ( posedge refclk)
		  n0O1O6 <= n0O1O5;
	initial
	begin
		n11l = 0;
	end
	always @ (refclk or wire_n11i_PRN or rxpcs_rst_int)
	begin
		if (wire_n11i_PRN == 1'b0) 
		begin
			n11l <= 1;
		end
		else if  (rxpcs_rst_int == 1'b1) 
		begin
			n11l <= 0;
		end
		else if  (wire_n11i_ENA == 1'b1) 
		if (refclk != n11i_clk_prev && refclk == 1'b1) 
		begin
			n11l <= n1il;
		end
		n11i_clk_prev <= refclk;
	end
	assign
		wire_n11i_ENA = wire_nllii_o[3],
		wire_n11i_PRN = (n00ii42 ^ n00ii41);
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n01i = 0;
		n01l = 0;
		n01O = 0;
		n0ii = 0;
		n0il = 0;
		n0iO = 0;
		n0li = 0;
		n0ll = 0;
		n0lO = 0;
		n0Oi = 0;
		n0Ol = 0;
		n0OO = 0;
		n10i = 0;
		n10l = 0;
		n11O = 0;
		n1il = 0;
		n1iO = 0;
		n1li = 0;
		n1Ol = 0;
		n1OO = 0;
		ni1i = 0;
		ni1O = 0;
		nll0i = 0;
		nlOOi = 0;
		nlOOl = 0;
		nlOOO = 0;
	end
	always @ ( posedge refclk or  negedge wire_ni1l_CLRN)
	begin
		if (wire_ni1l_CLRN == 1'b0) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n01i <= 0;
			n01l <= 0;
			n01O <= 0;
			n0ii <= 0;
			n0il <= 0;
			n0iO <= 0;
			n0li <= 0;
			n0ll <= 0;
			n0lO <= 0;
			n0Oi <= 0;
			n0Ol <= 0;
			n0OO <= 0;
			n10i <= 0;
			n10l <= 0;
			n11O <= 0;
			n1il <= 0;
			n1iO <= 0;
			n1li <= 0;
			n1Ol <= 0;
			n1OO <= 0;
			ni1i <= 0;
			ni1O <= 0;
			nll0i <= 0;
			nlOOi <= 0;
			nlOOl <= 0;
			nlOOO <= 0;
		end
		else 
		begin
			n00i <= wire_nili_dataout;
			n00l <= wire_nill_dataout;
			n00O <= wire_nilO_dataout;
			n01i <= wire_niii_dataout;
			n01l <= wire_niil_dataout;
			n01O <= wire_niiO_dataout;
			n0ii <= wire_niOi_dataout;
			n0il <= wire_niOl_dataout;
			n0iO <= wire_niOO_dataout;
			n0li <= wire_nl1i_dataout;
			n0ll <= wire_nl1l_dataout;
			n0lO <= wire_nl1O_dataout;
			n0Oi <= wire_nl0i_dataout;
			n0Ol <= wire_nl0l_dataout;
			n0OO <= wire_nl0O_dataout;
			n10i <= gen2ngen1;
			n10l <= n1il;
			n11O <= ((n10i ^ gen2ngen1) ^ (~ (n00il40 ^ n00il39)));
			n1il <= n1iO;
			n1iO <= rate;
			n1li <= wire_ni0i_dataout;
			n1Ol <= wire_ni0l_dataout;
			n1OO <= wire_ni0O_dataout;
			ni1i <= wire_nlii_dataout;
			ni1O <= wire_nlil_dataout;
			nll0i <= wire_nliOO_o;
			nlOOi <= wire_nll1i_o;
			nlOOl <= wire_nll1l_o;
			nlOOO <= wire_nll1O_o;
		end
	end
	assign
		wire_ni1l_CLRN = ((n00ll38 ^ n00ll37) & (~ rxpcs_rst_int));
	assign		wire_n1ll_dataout = (rmaster_rx === 1'b1) ? wire_n1Oi_dataout : wire_n1lO_dataout;
	assign		wire_n1lO_dataout = (rmaster_up_rx === 1'b1) ? config_sel_quad_up : config_sel_quad_down;
	assign		wire_n1Oi_dataout = (rindv_rx === 1'b1) ? n11l : config_sel_centrl;
	and(wire_ni0i_dataout, wire_nliO_dataout, ~((~ n00lO)));
	and(wire_ni0l_dataout, wire_nO_o[0], ~((~ n00lO)));
	and(wire_ni0O_dataout, wire_nO_o[1], ~((~ n00lO)));
	and(wire_niii_dataout, wire_nO_o[2], ~((~ n00lO)));
	and(wire_niil_dataout, wire_nO_o[3], ~((~ n00lO)));
	and(wire_niiO_dataout, wire_nO_o[4], ~((~ n00lO)));
	and(wire_nili_dataout, wire_nO_o[5], ~((~ n00lO)));
	and(wire_nill_dataout, wire_nO_o[6], ~((~ n00lO)));
	and(wire_nilO_dataout, wire_nO_o[7], ~((~ n00lO)));
	and(wire_niOi_dataout, wire_nO_o[8], ~((~ n00lO)));
	and(wire_niOl_dataout, wire_nO_o[9], ~((~ n00lO)));
	and(wire_niOO_dataout, wire_nO_o[10], ~((~ n00lO)));
	and(wire_nl0i_dataout, wire_nO_o[14], ~((~ n00lO)));
	and(wire_nl0l_dataout, wire_nO_o[15], ~((~ n00lO)));
	and(wire_nl0O_dataout, wire_nO_o[16], ~((~ n00lO)));
	and(wire_nl1i_dataout, wire_nO_o[11], ~((~ n00lO)));
	and(wire_nl1l_dataout, wire_nO_o[12], ~((~ n00lO)));
	and(wire_nl1O_dataout, wire_nO_o[13], ~((~ n00lO)));
	and(wire_nlii_dataout, wire_nO_o[17], ~((~ n00lO)));
	and(wire_nlil_dataout, wire_nO_o[18], ~((~ n00lO)));
	or(wire_nliO_dataout, wire_nlli_dataout, n1li);
	assign		wire_nlli_dataout = (wire_nllii_o[5] === 1'b1) ? (((((gen2ngen1 & n0i1O) & (n0i1i34 ^ n0i1i33)) & n1Ol) & (n00Ol36 ^ n00Ol35)) | ((~ gen2ngen1) & n00Oi)) : wire_nlll_dataout;
	assign		wire_nlll_dataout = (wire_nllii_o[7] === 1'b1) ? ((((gen2ngen1 & (((((~ ((n1OO ^ rauto_deassert_pc_rst_cnt[0]) ^ (~ (n0l1i20 ^ n0l1i19)))) & (~ (n01i ^ rauto_deassert_pc_rst_cnt[1]))) & (~ ((n01l ^ rauto_deassert_pc_rst_cnt[2]) ^ (~ (n0iOl22 ^ n0iOl21))))) & (~ ((n01O ^ rauto_deassert_pc_rst_cnt[3]) ^ (~ (n0ilO24 ^ n0ilO23))))) & (n0ili26 ^ n0ili25))) & n1Ol) & (n0iil28 ^ n0iil27)) | ((~ gen2ngen1) & (((((~ (n1Ol ^ rauto_deassert_pc_rst_cnt[0])) & (~ ((n1OO ^ rauto_deassert_pc_rst_cnt[1]) ^ (~ (n0i0O30 ^ n0i0O29))))) & (~ (n01i ^ rauto_deassert_pc_rst_cnt[2]))) & (~ (n01l ^ rauto_deassert_pc_rst_cnt[3]))) & (n0i0i32 ^ n0i0i31)))) : wire_nllO_dataout;
	and(wire_nllli_dataout, nll0i, ~(n1li));
	or(wire_nllll_dataout, nlOOi, n1li);
	and(wire_nlllO_dataout, nlOOl, ~(n1li));
	assign		wire_nllO_dataout = (wire_nllii_o[9] === 1'b1) ? (((((gen2ngen1 & n0lil) & (n0l0O16 ^ n0l0O15)) & n1Ol) & (n0l0i18 ^ n0l0i17)) | ((~ gen2ngen1) & n0l1O)) : wire_nlOi_dataout;
	or(wire_nllOi_dataout, nlOOO, n1li);
	and(wire_nllOl_dataout, nlOOi, ~(n1li));
	assign		wire_nllOO_dataout = (n1li === 1'b1) ? (~ rphfifo_regmode_rx) : nlOOl;
	or(wire_nlO0i_dataout, nlOOl, n11O);
	and(wire_nlO0l_dataout, nlOOO, ~(n11O));
	and(wire_nlO0O_dataout, nlOOO, ~(n1li));
	assign		wire_nlO1i_dataout = (n1li === 1'b1) ? rphfifo_regmode_rx : nlOOO;
	or(wire_nlO1l_dataout, nll0i, n11O);
	and(wire_nlO1O_dataout, nlOOi, ~(n11O));
	assign		wire_nlOi_dataout = (wire_nllii_o[1] === 1'b1) ? ((((gen2ngen1 & n0llO) & (n0lli14 ^ n0lli13)) & n1Ol) | ((~ gen2ngen1) & n0liO)) : n1li;
	or(wire_nlOii_dataout, nll0i, n000i);
	assign		wire_nlOil_dataout = (n000i === 1'b1) ? rphfifo_regmode_rx : nlOOi;
	and(wire_nlOiO_dataout, nlOOl, ~(n000i));
	and(wire_nlOli_dataout, nlOOO, ~(n000i));
	oper_add   nO
	( 
	.a({ni1O, ((n0lOO12 ^ n0lOO11) & ni1i), n0OO, n0Ol, n0Oi, n0lO, n0ll, ((n0O1i10 ^ n0O1i9) & n0li), n0iO, ((n0O1l8 ^ n0O1l7) & n0il), ((n0O1O6 ^ n0O1O5) & n0ii), n00O, n00l, ((n0O0i4 ^ n0O0i3) & n00i), n01O, n01l, n01i, n1OO, ((n0O0l2 ^ n0O0l1) & n1Ol)}),
	.b({{18{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nO_o));
	defparam
		nO.sgate_representation = 0,
		nO.width_a = 19,
		nO.width_b = 19,
		nO.width_o = 19;
	oper_decoder   nllii
	( 
	.i({nlOOO, nlOOl, nlOOi, nll0i}),
	.o(wire_nllii_o));
	defparam
		nllii.width_i = 4,
		nllii.width_o = 16;
	oper_mux   nliOO
	( 
	.data({{6{1'b0}}, wire_nllli_dataout, 1'b1, wire_nllli_dataout, 1'b1, wire_nllli_dataout, wire_nlO1l_dataout, 1'b0, 1'b1, wire_nllli_dataout, wire_nlOii_dataout}),
	.o(wire_nliOO_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nliOO.width_data = 16,
		nliOO.width_sel = 4;
	oper_mux   nll1i
	( 
	.data({{6{1'b0}}, wire_nllll_dataout, 1'b0, wire_nllOl_dataout, 1'b1, wire_nllll_dataout, wire_nlO1O_dataout, 1'b0, 1'b1, wire_nllll_dataout, wire_nlOil_dataout}),
	.o(wire_nll1i_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nll1i.width_data = 16,
		nll1i.width_sel = 4;
	oper_mux   nll1l
	( 
	.data({{6{1'b0}}, wire_nlllO_dataout, 1'b0, wire_nlllO_dataout, 1'b1, wire_nllOO_dataout, wire_nlO0i_dataout, 1'b1, 1'b0, wire_nlllO_dataout, wire_nlOiO_dataout}),
	.o(wire_nll1l_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nll1l.width_data = 16,
		nll1l.width_sel = 4;
	oper_mux   nll1O
	( 
	.data({{6{1'b0}}, wire_nllOi_dataout, 1'b1, wire_nllOi_dataout, 1'b0, wire_nlO1i_dataout, wire_nlO0l_dataout, {2{1'b0}}, wire_nlO0O_dataout, wire_nlOli_dataout}),
	.o(wire_nll1O_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nll1O.width_data = 16,
		nll1O.width_sel = 4;
	assign
		config_sel = n11l,
		cs = {nlOOO, nlOOl, nlOOi, nll0i},
		dis_pc_byte = n001O,
		n000i = ((((n1il ^ n10l) ^ (~ (n000l44 ^ n000l43))) & rauto_speed_ena) & singleorbundle),
		n001l = (((((((wire_nllii_o[15] | wire_nllii_o[14]) | wire_nllii_o[13]) | wire_nllii_o[12]) | wire_nllii_o[11]) | wire_nllii_o[10]) | wire_nllii_o[1]) | wire_nllii_o[0]),
		n001O = (((((wire_nllii_o[7] | wire_nllii_o[6]) | wire_nllii_o[5]) | wire_nllii_o[4]) | wire_nllii_o[2]) | wire_nllii_o[3]),
		n00li = 1'b1,
		n00lO = (((wire_nllii_o[7] | wire_nllii_o[5]) | wire_nllii_o[1]) | wire_nllii_o[9]),
		n00Oi = ((((((((((((((((((~ (n1Ol ^ rpma_done_count[0])) & (~ (n1OO ^ rpma_done_count[1]))) & (~ (n01i ^ rpma_done_count[2]))) & (~ (n01l ^ rpma_done_count[3]))) & (~ (n01O ^ rpma_done_count[4]))) & (~ (n00i ^ rpma_done_count[5]))) & (~ (n00l ^ rpma_done_count[6]))) & (~ (n00O ^ rpma_done_count[7]))) & (~ (n0ii ^ rpma_done_count[8]))) & (~ (n0il ^ rpma_done_count[9]))) & (~ (n0iO ^ rpma_done_count[10]))) & (~ (n0li ^ rpma_done_count[11]))) & (~ (n0ll ^ rpma_done_count[12]))) & (~ (n0lO ^ rpma_done_count[13]))) & (~ (n0Oi ^ rpma_done_count[14]))) & (~ (n0Ol ^ rpma_done_count[15]))) & (~ (n0OO ^ rpma_done_count[16]))) & (~ (ni1i ^ rpma_done_count[17]))),
		n0i1O = ((((((((((((((((((~ (n1OO ^ rpma_done_count[0])) & (~ (n01i ^ rpma_done_count[1]))) & (~ (n01l ^ rpma_done_count[2]))) & (~ (n01O ^ rpma_done_count[3]))) & (~ (n00i ^ rpma_done_count[4]))) & (~ (n00l ^ rpma_done_count[5]))) & (~ (n00O ^ rpma_done_count[6]))) & (~ (n0ii ^ rpma_done_count[7]))) & (~ (n0il ^ rpma_done_count[8]))) & (~ (n0iO ^ rpma_done_count[9]))) & (~ (n0li ^ rpma_done_count[10]))) & (~ (n0ll ^ rpma_done_count[11]))) & (~ (n0lO ^ rpma_done_count[12]))) & (~ (n0Oi ^ rpma_done_count[13]))) & (~ (n0Ol ^ rpma_done_count[14]))) & (~ (n0OO ^ rpma_done_count[15]))) & (~ (ni1i ^ rpma_done_count[16]))) & (~ (ni1O ^ rpma_done_count[17]))),
		n0l1O = (((((~ (n1Ol ^ rauto_pc_en_cnt[0])) & (~ (n1OO ^ rauto_pc_en_cnt[1]))) & (~ (n01i ^ rauto_pc_en_cnt[2]))) & (~ (n01l ^ rauto_pc_en_cnt[3]))) & (~ (n01O ^ rauto_pc_en_cnt[4]))),
		n0lil = (((((~ (n1OO ^ rauto_pc_en_cnt[0])) & (~ (n01i ^ rauto_pc_en_cnt[1]))) & (~ (n01l ^ rauto_pc_en_cnt[2]))) & (~ (n01O ^ rauto_pc_en_cnt[3]))) & (~ (n00i ^ rauto_pc_en_cnt[4]))),
		n0liO = ((((((~ (n1Ol ^ rwait_for_phfifo_cnt[0])) & (~ (n1OO ^ rwait_for_phfifo_cnt[1]))) & (~ (n01i ^ rwait_for_phfifo_cnt[2]))) & (~ (n01l ^ rwait_for_phfifo_cnt[3]))) & (~ (n01O ^ rwait_for_phfifo_cnt[4]))) & (~ (n00i ^ rwait_for_phfifo_cnt[5]))),
		n0llO = ((((((~ (n1OO ^ rwait_for_phfifo_cnt[0])) & (~ (n01i ^ rwait_for_phfifo_cnt[1]))) & (~ (n01l ^ rwait_for_phfifo_cnt[2]))) & (~ (n01O ^ rwait_for_phfifo_cnt[3]))) & (~ (n00i ^ rwait_for_phfifo_cnt[4]))) & (~ (n00l ^ rwait_for_phfifo_cnt[5]))),
		pcie_switch = wire_n1ll_dataout,
		reset_pc_ptrs = (((wire_nllii_o[5] | wire_nllii_o[4]) | wire_nllii_o[2]) | wire_nllii_o[3]),
		speed_change = (~ n001l);
endmodule //cycloneiv_hssi_rx_digi_auto_speed_neg
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 149 mux21 612 oper_add 8 oper_decoder 4 oper_mux 37 oper_selector 4 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_rx_digi_bist_ver
	( 
	bistdone,
	bisterr,
	clk_2,
	cur_state,
	err_ctl,
	err_data,
	prbs_done,
	prbs_err,
	rbist_clr_rx,
	rbist_sel,
	rbisten_rx,
	rcxpat_chnl_sel,
	rdwidth_rx,
	rpma_doublewidth_rx,
	rpmadwidth_rx,
	rxc,
	rxd,
	selftest_done,
	selftest_err,
	soft_reset,
	sync_status) /* synthesis synthesis_clearbox=1 */;
	output   bistdone;
	output   bisterr;
	input   clk_2;
	output   [4:0]  cur_state;
	output   [1:0]  err_ctl;
	output   [15:0]  err_data;
	input   prbs_done;
	input   prbs_err;
	input   rbist_clr_rx;
	input   [1:0]  rbist_sel;
	input   rbisten_rx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_rx;
	input   rpma_doublewidth_rx;
	input   rpmadwidth_rx;
	input   [3:0]  rxc;
	input   [63:0]  rxd;
	output   selftest_done;
	output   selftest_err;
	input   soft_reset;
	input   sync_status;

	reg	n0li1O47;
	reg	n0li1O48;
	reg	n0lOOi45;
	reg	n0lOOi46;
	reg	n0lOOl43;
	reg	n0lOOl44;
	reg	n0lOOO41;
	reg	n0lOOO42;
	reg	n0O10i33;
	reg	n0O10i34;
	reg	n0O10l31;
	reg	n0O10l32;
	reg	n0O10O29;
	reg	n0O10O30;
	reg	n0O11i39;
	reg	n0O11i40;
	reg	n0O11l37;
	reg	n0O11l38;
	reg	n0O11O35;
	reg	n0O11O36;
	reg	n0O1ii27;
	reg	n0O1ii28;
	reg	n0O1Ol25;
	reg	n0O1Ol26;
	reg	n0Oi0O21;
	reg	n0Oi0O22;
	reg	n0Oi1O23;
	reg	n0Oi1O24;
	reg	n0OiOi19;
	reg	n0OiOi20;
	reg	n0OiOO17;
	reg	n0OiOO18;
	reg	n0Ol0i11;
	reg	n0Ol0i12;
	reg	n0Ol0O10;
	reg	n0Ol0O9;
	reg	n0Ol1i15;
	reg	n0Ol1i16;
	reg	n0Ol1l13;
	reg	n0Ol1l14;
	reg	n0Olil7;
	reg	n0Olil8;
	reg	n0OlOO5;
	reg	n0OlOO6;
	reg	n0OO0i1;
	reg	n0OO0i2;
	reg	n0OO1l3;
	reg	n0OO1l4;
	reg	ni00i;
	reg	ni01l;
	reg	ni1lOl;
	reg	niiilO;
	reg	niiiOi;
	reg	niiiOl;
	reg	niiiOO;
	reg	niil0i;
	reg	niil0l;
	reg	niil0O;
	reg	niil1i;
	reg	niil1l;
	reg	niil1O;
	reg	niilii;
	reg	niilil;
	reg	niiliO;
	reg	niilli;
	reg	niilll;
	reg	niillO;
	reg	niilOi;
	reg	niilOl;
	reg	niiO1i;
	reg	niiO1l;
	reg	nll00O;
	reg	nll0ii;
	wire	wire_ni01O_CLRN;
	reg	n11Oi;
	reg	ni00l;
	reg	ni00O;
	reg	ni01i;
	reg	ni0ii;
	reg	ni0il;
	reg	ni0iO;
	reg	ni0li;
	reg	ni0ll;
	reg	ni0lO;
	reg	ni0Oi;
	reg	ni0Ol;
	reg	nii1i;
	reg	niilOO;
	reg	niiO0l;
	reg	niiO0O;
	reg	niiOii;
	reg	niiOil;
	reg	niiOiO;
	reg	niiOli;
	reg	niiOll;
	reg	niiOlO;
	reg	niiOOi;
	reg	niiOOl;
	reg	niiOOO;
	reg	nil00i;
	reg	nil00l;
	reg	nil00O;
	reg	nil01i;
	reg	nil01l;
	reg	nil01O;
	reg	nil10i;
	reg	nil10l;
	reg	nil10O;
	reg	nil11i;
	reg	nil11l;
	reg	nil11O;
	reg	nil1ii;
	reg	nil1il;
	reg	nil1iO;
	reg	nil1li;
	reg	nil1ll;
	reg	nil1lO;
	reg	nil1Oi;
	reg	nil1Ol;
	reg	nil1OO;
	reg	nl1Oll;
	reg	nll00l;
	reg	nll0il;
	reg	nll0iO;
	reg	nll0li;
	reg	nll0ll;
	reg	nll0lO;
	reg	nll0Oi;
	reg	nll0Ol;
	reg	nll0OO;
	reg	nlli0i;
	reg	nlli0l;
	reg	nlli0O;
	reg	nlli1i;
	reg	nlli1l;
	reg	nlli1O;
	reg	nlliii;
	reg	nlliil;
	reg	nlliiO;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	nlliOl;
	reg	nlliOO;
	reg	nlll0i;
	reg	nlll1i;
	reg	nlll1l;
	reg	nlll1O;
	reg	ni0OO_clk_prev;
	wire	wire_ni0OO_CLRN;
	wire	wire_ni0OO_PRN;
	reg	niiO0i;
	reg	niiO1O_clk_prev;
	wire	wire_niiO1O_CLRN;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni000i_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00iO_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01il_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0ili_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0lil_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0lll_dataout;
	wire	wire_ni0llO_dataout;
	wire	wire_ni0lOi_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni0O0O_dataout;
	wire	wire_ni0O1i_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0O1O_dataout;
	wire	wire_ni0OiO_dataout;
	wire	wire_ni0Oli_dataout;
	wire	wire_ni0Oll_dataout;
	wire	wire_ni0OlO_dataout;
	wire	wire_ni0OOi_dataout;
	wire	wire_ni0OOl_dataout;
	wire	wire_ni0OOO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1l1i_dataout;
	wire	wire_ni1l1l_dataout;
	wire	wire_ni1l1O_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1l_dataout;
	wire	wire_ni1O1O_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OlO_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii00i_dataout;
	wire	wire_nii00l_dataout;
	wire	wire_nii00O_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0ii_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0ll_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii0Oi_dataout;
	wire	wire_nii10i_dataout;
	wire	wire_nii10l_dataout;
	wire	wire_nii10O_dataout;
	wire	wire_nii11i_dataout;
	wire	wire_nii11l_dataout;
	wire	wire_nii11O_dataout;
	wire	wire_nii1ii_dataout;
	wire	wire_nii1il_dataout;
	wire	wire_nii1iO_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl00il_dataout;
	wire	wire_nl00iO_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00Oi_dataout;
	wire	wire_nl00Ol_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1i_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0iii_dataout;
	wire	wire_nl0iil_dataout;
	wire	wire_nl0iiO_dataout;
	wire	wire_nl0ili_dataout;
	wire	wire_nl0ill_dataout;
	wire	wire_nl0ilO_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l0i_dataout;
	wire	wire_nl0l0l_dataout;
	wire	wire_nl0l0O_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0l1l_dataout;
	wire	wire_nl0l1O_dataout;
	wire	wire_nl0lii_dataout;
	wire	wire_nl0lil_dataout;
	wire	wire_nl0liO_dataout;
	wire	wire_nl0lli_dataout;
	wire	wire_nl0lll_dataout;
	wire	wire_nl0llO_dataout;
	wire	wire_nl0lOi_dataout;
	wire	wire_nl0lOl_dataout;
	wire	wire_nl0lOO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0O0i_dataout;
	wire	wire_nl0O0l_dataout;
	wire	wire_nl0O0O_dataout;
	wire	wire_nl0O1i_dataout;
	wire	wire_nl0O1l_dataout;
	wire	wire_nl0O1O_dataout;
	wire	wire_nl0Oii_dataout;
	wire	wire_nl0Oil_dataout;
	wire	wire_nl0OiO_dataout;
	wire	wire_nl0Oli_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl0OlO_dataout;
	wire	wire_nl0OOi_dataout;
	wire	wire_nl0OOl_dataout;
	wire	wire_nl0OOO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli0Ol_dataout;
	wire	wire_nli0OO_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli11i_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli11O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlii0i_dataout;
	wire	wire_nlii0l_dataout;
	wire	wire_nlii0O_dataout;
	wire	wire_nlii1i_dataout;
	wire	wire_nlii1l_dataout;
	wire	wire_nlii1O_dataout;
	wire	wire_nliiii_dataout;
	wire	wire_nliiil_dataout;
	wire	wire_nliiiO_dataout;
	wire	wire_nliill_dataout;
	wire	wire_nliilO_dataout;
	wire	wire_nliiOi_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlil1i_dataout;
	wire	wire_nlil1l_dataout;
	wire	wire_nlil1O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilOi_dataout;
	wire	wire_nlilOl_dataout;
	wire	wire_nlilOO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliO0i_dataout;
	wire	wire_nliO0l_dataout;
	wire	wire_nliO0O_dataout;
	wire	wire_nliO1i_dataout;
	wire	wire_nliO1l_dataout;
	wire	wire_nliO1O_dataout;
	wire	wire_nliOii_dataout;
	wire	wire_nliOil_dataout;
	wire	wire_nliOiO_dataout;
	wire	wire_nliOli_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOlO_dataout;
	wire	wire_nliOOi_dataout;
	wire	wire_nliOOl_dataout;
	wire	wire_nliOOO_dataout;
	wire	wire_nll10i_dataout;
	wire	wire_nll10l_dataout;
	wire	wire_nll10O_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nll1ii_dataout;
	wire	wire_nll1il_dataout;
	wire	wire_nll1iO_dataout;
	wire	wire_nll1li_dataout;
	wire	wire_nll1ll_dataout;
	wire	wire_nll1lO_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nll1Ol_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nO_dataout;
	wire  [4:0]   wire_niiOl_o;
	wire  [6:0]   wire_niO0Ol_o;
	wire  [6:0]   wire_niO0OO_o;
	wire  [8:0]   wire_niOi1i_o;
	wire  [5:0]   wire_nllO0i_o;
	wire  [2:0]   wire_nllOil_o;
	wire  [8:0]   wire_nlO00O_o;
	wire  [3:0]   wire_nlO11l_o;
	wire  [31:0]   wire_n11li_o;
	wire  [15:0]   wire_ni1iii_o;
	wire  [15:0]   wire_nii0Ol_o;
	wire  [15:0]   wire_nl1OiO_o;
	wire  wire_n100i_o;
	wire  wire_n100l_o;
	wire  wire_n101i_o;
	wire  wire_n101l_o;
	wire  wire_n101O_o;
	wire  wire_n11Ol_o;
	wire  wire_n11OO_o;
	wire  wire_ni1iil_o;
	wire  wire_ni1iiO_o;
	wire  wire_ni1ili_o;
	wire  wire_ni1ill_o;
	wire  wire_ni1ilO_o;
	wire  wire_ni1iOi_o;
	wire  wire_ni1iOl_o;
	wire  wire_ni1iOO_o;
	wire  wire_nii0iO_o;
	wire  wire_nii0li_o;
	wire  wire_nii0lO_o;
	wire  wire_nii0OO_o;
	wire  wire_niii0i_o;
	wire  wire_niii0l_o;
	wire  wire_niii0O_o;
	wire  wire_niii1i_o;
	wire  wire_niii1l_o;
	wire  wire_niii1O_o;
	wire  wire_niiiii_o;
	wire  wire_niiiil_o;
	wire  wire_niiiiO_o;
	wire  wire_niiili_o;
	wire  wire_niiill_o;
	wire  wire_nl010i_o;
	wire  wire_nl010l_o;
	wire  wire_nl010O_o;
	wire  wire_nl011i_o;
	wire  wire_nl011l_o;
	wire  wire_nl011O_o;
	wire  wire_nl01ii_o;
	wire  wire_n11ii_o;
	wire  wire_n11il_o;
	wire  wire_n11ll_o;
	wire  wire_ni1i0l_o;
	wire  n0iO0i;
	wire  n0iO0l;
	wire  n0iO0O;
	wire  n0iO1i;
	wire  n0iO1l;
	wire  n0iO1O;
	wire  n0iOii;
	wire  n0iOil;
	wire  n0iOiO;
	wire  n0iOli;
	wire  n0iOll;
	wire  n0iOlO;
	wire  n0iOOi;
	wire  n0iOOl;
	wire  n0iOOO;
	wire  n0l00i;
	wire  n0l00l;
	wire  n0l00O;
	wire  n0l01i;
	wire  n0l01l;
	wire  n0l01O;
	wire  n0l0ii;
	wire  n0l0il;
	wire  n0l0iO;
	wire  n0l0li;
	wire  n0l0ll;
	wire  n0l0lO;
	wire  n0l0Oi;
	wire  n0l0Ol;
	wire  n0l0OO;
	wire  n0l10i;
	wire  n0l10l;
	wire  n0l10O;
	wire  n0l11i;
	wire  n0l11l;
	wire  n0l11O;
	wire  n0l1ii;
	wire  n0l1il;
	wire  n0l1iO;
	wire  n0l1li;
	wire  n0l1ll;
	wire  n0l1lO;
	wire  n0l1Oi;
	wire  n0l1Ol;
	wire  n0l1OO;
	wire  n0li0i;
	wire  n0li0l;
	wire  n0li0O;
	wire  n0li1i;
	wire  n0li1l;
	wire  n0liii;
	wire  n0liil;
	wire  n0liiO;
	wire  n0lili;
	wire  n0lill;
	wire  n0lilO;
	wire  n0liOi;
	wire  n0liOl;
	wire  n0liOO;
	wire  n0ll0i;
	wire  n0ll0l;
	wire  n0ll0O;
	wire  n0ll1i;
	wire  n0ll1l;
	wire  n0ll1O;
	wire  n0llii;
	wire  n0llil;
	wire  n0lliO;
	wire  n0llli;
	wire  n0llll;
	wire  n0lllO;
	wire  n0llOi;
	wire  n0llOl;
	wire  n0llOO;
	wire  n0lO0i;
	wire  n0lO0l;
	wire  n0lO0O;
	wire  n0lO1i;
	wire  n0lO1l;
	wire  n0lO1O;
	wire  n0lOii;
	wire  n0lOil;
	wire  n0lOiO;
	wire  n0lOli;
	wire  n0lOll;
	wire  n0lOlO;
	wire  n0O00i;
	wire  n0O00l;
	wire  n0O00O;
	wire  n0O01i;
	wire  n0O01l;
	wire  n0O01O;
	wire  n0O0ii;
	wire  n0O0il;
	wire  n0O0iO;
	wire  n0O0li;
	wire  n0O0ll;
	wire  n0O0lO;
	wire  n0O0Oi;
	wire  n0O0Ol;
	wire  n0O0OO;
	wire  n0O1il;
	wire  n0O1iO;
	wire  n0O1li;
	wire  n0O1ll;
	wire  n0O1lO;
	wire  n0O1Oi;
	wire  n0Oi0l;
	wire  n0Oi1i;
	wire  n0Oi1l;
	wire  n0Oiil;
	wire  n0OiiO;
	wire  n0Oili;
	wire  n0Oill;
	wire  n0OilO;
	wire  n0OiOl;
	wire  n0Olli;
	wire  n0Olll;
	wire  n0OllO;
	wire  n0OlOi;
	wire  n0OlOl;

	initial
		n0li1O47 = 0;
	always @ ( posedge clk_2)
		  n0li1O47 <= n0li1O48;
	event n0li1O47_event;
	initial
		#1 ->n0li1O47_event;
	always @(n0li1O47_event)
		n0li1O47 <= {1{1'b1}};
	initial
		n0li1O48 = 0;
	always @ ( posedge clk_2)
		  n0li1O48 <= n0li1O47;
	initial
		n0lOOi45 = 0;
	always @ ( posedge clk_2)
		  n0lOOi45 <= n0lOOi46;
	event n0lOOi45_event;
	initial
		#1 ->n0lOOi45_event;
	always @(n0lOOi45_event)
		n0lOOi45 <= {1{1'b1}};
	initial
		n0lOOi46 = 0;
	always @ ( posedge clk_2)
		  n0lOOi46 <= n0lOOi45;
	initial
		n0lOOl43 = 0;
	always @ ( posedge clk_2)
		  n0lOOl43 <= n0lOOl44;
	event n0lOOl43_event;
	initial
		#1 ->n0lOOl43_event;
	always @(n0lOOl43_event)
		n0lOOl43 <= {1{1'b1}};
	initial
		n0lOOl44 = 0;
	always @ ( posedge clk_2)
		  n0lOOl44 <= n0lOOl43;
	initial
		n0lOOO41 = 0;
	always @ ( posedge clk_2)
		  n0lOOO41 <= n0lOOO42;
	event n0lOOO41_event;
	initial
		#1 ->n0lOOO41_event;
	always @(n0lOOO41_event)
		n0lOOO41 <= {1{1'b1}};
	initial
		n0lOOO42 = 0;
	always @ ( posedge clk_2)
		  n0lOOO42 <= n0lOOO41;
	initial
		n0O10i33 = 0;
	always @ ( posedge clk_2)
		  n0O10i33 <= n0O10i34;
	event n0O10i33_event;
	initial
		#1 ->n0O10i33_event;
	always @(n0O10i33_event)
		n0O10i33 <= {1{1'b1}};
	initial
		n0O10i34 = 0;
	always @ ( posedge clk_2)
		  n0O10i34 <= n0O10i33;
	initial
		n0O10l31 = 0;
	always @ ( posedge clk_2)
		  n0O10l31 <= n0O10l32;
	event n0O10l31_event;
	initial
		#1 ->n0O10l31_event;
	always @(n0O10l31_event)
		n0O10l31 <= {1{1'b1}};
	initial
		n0O10l32 = 0;
	always @ ( posedge clk_2)
		  n0O10l32 <= n0O10l31;
	initial
		n0O10O29 = 0;
	always @ ( posedge clk_2)
		  n0O10O29 <= n0O10O30;
	event n0O10O29_event;
	initial
		#1 ->n0O10O29_event;
	always @(n0O10O29_event)
		n0O10O29 <= {1{1'b1}};
	initial
		n0O10O30 = 0;
	always @ ( posedge clk_2)
		  n0O10O30 <= n0O10O29;
	initial
		n0O11i39 = 0;
	always @ ( posedge clk_2)
		  n0O11i39 <= n0O11i40;
	event n0O11i39_event;
	initial
		#1 ->n0O11i39_event;
	always @(n0O11i39_event)
		n0O11i39 <= {1{1'b1}};
	initial
		n0O11i40 = 0;
	always @ ( posedge clk_2)
		  n0O11i40 <= n0O11i39;
	initial
		n0O11l37 = 0;
	always @ ( posedge clk_2)
		  n0O11l37 <= n0O11l38;
	event n0O11l37_event;
	initial
		#1 ->n0O11l37_event;
	always @(n0O11l37_event)
		n0O11l37 <= {1{1'b1}};
	initial
		n0O11l38 = 0;
	always @ ( posedge clk_2)
		  n0O11l38 <= n0O11l37;
	initial
		n0O11O35 = 0;
	always @ ( posedge clk_2)
		  n0O11O35 <= n0O11O36;
	event n0O11O35_event;
	initial
		#1 ->n0O11O35_event;
	always @(n0O11O35_event)
		n0O11O35 <= {1{1'b1}};
	initial
		n0O11O36 = 0;
	always @ ( posedge clk_2)
		  n0O11O36 <= n0O11O35;
	initial
		n0O1ii27 = 0;
	always @ ( posedge clk_2)
		  n0O1ii27 <= n0O1ii28;
	event n0O1ii27_event;
	initial
		#1 ->n0O1ii27_event;
	always @(n0O1ii27_event)
		n0O1ii27 <= {1{1'b1}};
	initial
		n0O1ii28 = 0;
	always @ ( posedge clk_2)
		  n0O1ii28 <= n0O1ii27;
	initial
		n0O1Ol25 = 0;
	always @ ( posedge clk_2)
		  n0O1Ol25 <= n0O1Ol26;
	event n0O1Ol25_event;
	initial
		#1 ->n0O1Ol25_event;
	always @(n0O1Ol25_event)
		n0O1Ol25 <= {1{1'b1}};
	initial
		n0O1Ol26 = 0;
	always @ ( posedge clk_2)
		  n0O1Ol26 <= n0O1Ol25;
	initial
		n0Oi0O21 = 0;
	always @ ( posedge clk_2)
		  n0Oi0O21 <= n0Oi0O22;
	event n0Oi0O21_event;
	initial
		#1 ->n0Oi0O21_event;
	always @(n0Oi0O21_event)
		n0Oi0O21 <= {1{1'b1}};
	initial
		n0Oi0O22 = 0;
	always @ ( posedge clk_2)
		  n0Oi0O22 <= n0Oi0O21;
	initial
		n0Oi1O23 = 0;
	always @ ( posedge clk_2)
		  n0Oi1O23 <= n0Oi1O24;
	event n0Oi1O23_event;
	initial
		#1 ->n0Oi1O23_event;
	always @(n0Oi1O23_event)
		n0Oi1O23 <= {1{1'b1}};
	initial
		n0Oi1O24 = 0;
	always @ ( posedge clk_2)
		  n0Oi1O24 <= n0Oi1O23;
	initial
		n0OiOi19 = 0;
	always @ ( posedge clk_2)
		  n0OiOi19 <= n0OiOi20;
	event n0OiOi19_event;
	initial
		#1 ->n0OiOi19_event;
	always @(n0OiOi19_event)
		n0OiOi19 <= {1{1'b1}};
	initial
		n0OiOi20 = 0;
	always @ ( posedge clk_2)
		  n0OiOi20 <= n0OiOi19;
	initial
		n0OiOO17 = 0;
	always @ ( posedge clk_2)
		  n0OiOO17 <= n0OiOO18;
	event n0OiOO17_event;
	initial
		#1 ->n0OiOO17_event;
	always @(n0OiOO17_event)
		n0OiOO17 <= {1{1'b1}};
	initial
		n0OiOO18 = 0;
	always @ ( posedge clk_2)
		  n0OiOO18 <= n0OiOO17;
	initial
		n0Ol0i11 = 0;
	always @ ( posedge clk_2)
		  n0Ol0i11 <= n0Ol0i12;
	event n0Ol0i11_event;
	initial
		#1 ->n0Ol0i11_event;
	always @(n0Ol0i11_event)
		n0Ol0i11 <= {1{1'b1}};
	initial
		n0Ol0i12 = 0;
	always @ ( posedge clk_2)
		  n0Ol0i12 <= n0Ol0i11;
	initial
		n0Ol0O10 = 0;
	always @ ( posedge clk_2)
		  n0Ol0O10 <= n0Ol0O9;
	initial
		n0Ol0O9 = 0;
	always @ ( posedge clk_2)
		  n0Ol0O9 <= n0Ol0O10;
	event n0Ol0O9_event;
	initial
		#1 ->n0Ol0O9_event;
	always @(n0Ol0O9_event)
		n0Ol0O9 <= {1{1'b1}};
	initial
		n0Ol1i15 = 0;
	always @ ( posedge clk_2)
		  n0Ol1i15 <= n0Ol1i16;
	event n0Ol1i15_event;
	initial
		#1 ->n0Ol1i15_event;
	always @(n0Ol1i15_event)
		n0Ol1i15 <= {1{1'b1}};
	initial
		n0Ol1i16 = 0;
	always @ ( posedge clk_2)
		  n0Ol1i16 <= n0Ol1i15;
	initial
		n0Ol1l13 = 0;
	always @ ( posedge clk_2)
		  n0Ol1l13 <= n0Ol1l14;
	event n0Ol1l13_event;
	initial
		#1 ->n0Ol1l13_event;
	always @(n0Ol1l13_event)
		n0Ol1l13 <= {1{1'b1}};
	initial
		n0Ol1l14 = 0;
	always @ ( posedge clk_2)
		  n0Ol1l14 <= n0Ol1l13;
	initial
		n0Olil7 = 0;
	always @ ( posedge clk_2)
		  n0Olil7 <= n0Olil8;
	event n0Olil7_event;
	initial
		#1 ->n0Olil7_event;
	always @(n0Olil7_event)
		n0Olil7 <= {1{1'b1}};
	initial
		n0Olil8 = 0;
	always @ ( posedge clk_2)
		  n0Olil8 <= n0Olil7;
	initial
		n0OlOO5 = 0;
	always @ ( posedge clk_2)
		  n0OlOO5 <= n0OlOO6;
	event n0OlOO5_event;
	initial
		#1 ->n0OlOO5_event;
	always @(n0OlOO5_event)
		n0OlOO5 <= {1{1'b1}};
	initial
		n0OlOO6 = 0;
	always @ ( posedge clk_2)
		  n0OlOO6 <= n0OlOO5;
	initial
		n0OO0i1 = 0;
	always @ ( posedge clk_2)
		  n0OO0i1 <= n0OO0i2;
	event n0OO0i1_event;
	initial
		#1 ->n0OO0i1_event;
	always @(n0OO0i1_event)
		n0OO0i1 <= {1{1'b1}};
	initial
		n0OO0i2 = 0;
	always @ ( posedge clk_2)
		  n0OO0i2 <= n0OO0i1;
	initial
		n0OO1l3 = 0;
	always @ ( posedge clk_2)
		  n0OO1l3 <= n0OO1l4;
	event n0OO1l3_event;
	initial
		#1 ->n0OO1l3_event;
	always @(n0OO1l3_event)
		n0OO1l3 <= {1{1'b1}};
	initial
		n0OO1l4 = 0;
	always @ ( posedge clk_2)
		  n0OO1l4 <= n0OO1l3;
	initial
	begin
		ni00i = 0;
		ni01l = 0;
		ni1lOl = 0;
		niiilO = 0;
		niiiOi = 0;
		niiiOl = 0;
		niiiOO = 0;
		niil0i = 0;
		niil0l = 0;
		niil0O = 0;
		niil1i = 0;
		niil1l = 0;
		niil1O = 0;
		niilii = 0;
		niilil = 0;
		niiliO = 0;
		niilli = 0;
		niilll = 0;
		niillO = 0;
		niilOi = 0;
		niilOl = 0;
		niiO1i = 0;
		niiO1l = 0;
		nll00O = 0;
		nll0ii = 0;
	end
	always @ ( posedge clk_2 or  negedge wire_ni01O_CLRN)
	begin
		if (wire_ni01O_CLRN == 1'b0) 
		begin
			ni00i <= 0;
			ni01l <= 0;
			ni1lOl <= 0;
			niiilO <= 0;
			niiiOi <= 0;
			niiiOl <= 0;
			niiiOO <= 0;
			niil0i <= 0;
			niil0l <= 0;
			niil0O <= 0;
			niil1i <= 0;
			niil1l <= 0;
			niil1O <= 0;
			niilii <= 0;
			niilil <= 0;
			niiliO <= 0;
			niilli <= 0;
			niilll <= 0;
			niillO <= 0;
			niilOi <= 0;
			niilOl <= 0;
			niiO1i <= 0;
			niiO1l <= 0;
			nll00O <= 0;
			nll0ii <= 0;
		end
		else 
		begin
			ni00i <= wire_nii1O_dataout;
			ni01l <= wire_nii1l_dataout;
			ni1lOl <= wire_nil0ii_dataout;
			niiilO <= wire_nil0il_dataout;
			niiiOi <= wire_nil0iO_dataout;
			niiiOl <= wire_nil0li_dataout;
			niiiOO <= wire_nil0ll_dataout;
			niil0i <= wire_nil0OO_dataout;
			niil0l <= wire_nili1i_dataout;
			niil0O <= wire_nili1l_dataout;
			niil1i <= wire_nil0lO_dataout;
			niil1l <= wire_nil0Oi_dataout;
			niil1O <= wire_nil0Ol_dataout;
			niilii <= wire_nili1O_dataout;
			niilil <= wire_nili0i_dataout;
			niiliO <= wire_nili0l_dataout;
			niilli <= wire_nili0O_dataout;
			niilll <= wire_niliii_dataout;
			niillO <= wire_niliil_dataout;
			niilOi <= wire_niliiO_dataout;
			niilOl <= wire_nilili_dataout;
			niiO1i <= wire_nilill_dataout;
			niiO1l <= wire_nililO_dataout;
			nll00O <= wire_nlll0l_dataout;
			nll0ii <= wire_nlll0O_dataout;
		end
	end
	assign
		wire_ni01O_CLRN = ((n0OiOi20 ^ n0OiOi19) & (~ soft_reset));
	initial
	begin
		n11Oi = 0;
		ni00l = 0;
		ni00O = 0;
		ni01i = 0;
		ni0ii = 0;
		ni0il = 0;
		ni0iO = 0;
		ni0li = 0;
		ni0ll = 0;
		ni0lO = 0;
		ni0Oi = 0;
		ni0Ol = 0;
		nii1i = 0;
		niilOO = 0;
		niiO0l = 0;
		niiO0O = 0;
		niiOii = 0;
		niiOil = 0;
		niiOiO = 0;
		niiOli = 0;
		niiOll = 0;
		niiOlO = 0;
		niiOOi = 0;
		niiOOl = 0;
		niiOOO = 0;
		nil00i = 0;
		nil00l = 0;
		nil00O = 0;
		nil01i = 0;
		nil01l = 0;
		nil01O = 0;
		nil10i = 0;
		nil10l = 0;
		nil10O = 0;
		nil11i = 0;
		nil11l = 0;
		nil11O = 0;
		nil1ii = 0;
		nil1il = 0;
		nil1iO = 0;
		nil1li = 0;
		nil1ll = 0;
		nil1lO = 0;
		nil1Oi = 0;
		nil1Ol = 0;
		nil1OO = 0;
		nl1Oll = 0;
		nll00l = 0;
		nll0il = 0;
		nll0iO = 0;
		nll0li = 0;
		nll0ll = 0;
		nll0lO = 0;
		nll0Oi = 0;
		nll0Ol = 0;
		nll0OO = 0;
		nlli0i = 0;
		nlli0l = 0;
		nlli0O = 0;
		nlli1i = 0;
		nlli1l = 0;
		nlli1O = 0;
		nlliii = 0;
		nlliil = 0;
		nlliiO = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
		nlliOl = 0;
		nlliOO = 0;
		nlll0i = 0;
		nlll1i = 0;
		nlll1l = 0;
		nlll1O = 0;
	end
	always @ (clk_2 or wire_ni0OO_PRN or wire_ni0OO_CLRN)
	begin
		if (wire_ni0OO_PRN == 1'b0) 
		begin
			n11Oi <= 1;
			ni00l <= 1;
			ni00O <= 1;
			ni01i <= 1;
			ni0ii <= 1;
			ni0il <= 1;
			ni0iO <= 1;
			ni0li <= 1;
			ni0ll <= 1;
			ni0lO <= 1;
			ni0Oi <= 1;
			ni0Ol <= 1;
			nii1i <= 1;
			niilOO <= 1;
			niiO0l <= 1;
			niiO0O <= 1;
			niiOii <= 1;
			niiOil <= 1;
			niiOiO <= 1;
			niiOli <= 1;
			niiOll <= 1;
			niiOlO <= 1;
			niiOOi <= 1;
			niiOOl <= 1;
			niiOOO <= 1;
			nil00i <= 1;
			nil00l <= 1;
			nil00O <= 1;
			nil01i <= 1;
			nil01l <= 1;
			nil01O <= 1;
			nil10i <= 1;
			nil10l <= 1;
			nil10O <= 1;
			nil11i <= 1;
			nil11l <= 1;
			nil11O <= 1;
			nil1ii <= 1;
			nil1il <= 1;
			nil1iO <= 1;
			nil1li <= 1;
			nil1ll <= 1;
			nil1lO <= 1;
			nil1Oi <= 1;
			nil1Ol <= 1;
			nil1OO <= 1;
			nl1Oll <= 1;
			nll00l <= 1;
			nll0il <= 1;
			nll0iO <= 1;
			nll0li <= 1;
			nll0ll <= 1;
			nll0lO <= 1;
			nll0Oi <= 1;
			nll0Ol <= 1;
			nll0OO <= 1;
			nlli0i <= 1;
			nlli0l <= 1;
			nlli0O <= 1;
			nlli1i <= 1;
			nlli1l <= 1;
			nlli1O <= 1;
			nlliii <= 1;
			nlliil <= 1;
			nlliiO <= 1;
			nllili <= 1;
			nllill <= 1;
			nllilO <= 1;
			nlliOi <= 1;
			nlliOl <= 1;
			nlliOO <= 1;
			nlll0i <= 1;
			nlll1i <= 1;
			nlll1l <= 1;
			nlll1O <= 1;
		end
		else if  (wire_ni0OO_CLRN == 1'b0) 
		begin
			n11Oi <= 0;
			ni00l <= 0;
			ni00O <= 0;
			ni01i <= 0;
			ni0ii <= 0;
			ni0il <= 0;
			ni0iO <= 0;
			ni0li <= 0;
			ni0ll <= 0;
			ni0lO <= 0;
			ni0Oi <= 0;
			ni0Ol <= 0;
			nii1i <= 0;
			niilOO <= 0;
			niiO0l <= 0;
			niiO0O <= 0;
			niiOii <= 0;
			niiOil <= 0;
			niiOiO <= 0;
			niiOli <= 0;
			niiOll <= 0;
			niiOlO <= 0;
			niiOOi <= 0;
			niiOOl <= 0;
			niiOOO <= 0;
			nil00i <= 0;
			nil00l <= 0;
			nil00O <= 0;
			nil01i <= 0;
			nil01l <= 0;
			nil01O <= 0;
			nil10i <= 0;
			nil10l <= 0;
			nil10O <= 0;
			nil11i <= 0;
			nil11l <= 0;
			nil11O <= 0;
			nil1ii <= 0;
			nil1il <= 0;
			nil1iO <= 0;
			nil1li <= 0;
			nil1ll <= 0;
			nil1lO <= 0;
			nil1Oi <= 0;
			nil1Ol <= 0;
			nil1OO <= 0;
			nl1Oll <= 0;
			nll00l <= 0;
			nll0il <= 0;
			nll0iO <= 0;
			nll0li <= 0;
			nll0ll <= 0;
			nll0lO <= 0;
			nll0Oi <= 0;
			nll0Ol <= 0;
			nll0OO <= 0;
			nlli0i <= 0;
			nlli0l <= 0;
			nlli0O <= 0;
			nlli1i <= 0;
			nlli1l <= 0;
			nlli1O <= 0;
			nlliii <= 0;
			nlliil <= 0;
			nlliiO <= 0;
			nllili <= 0;
			nllill <= 0;
			nllilO <= 0;
			nlliOi <= 0;
			nlliOl <= 0;
			nlliOO <= 0;
			nlll0i <= 0;
			nlll1i <= 0;
			nlll1l <= 0;
			nlll1O <= 0;
		end
		else if  (rbist_clr_rx == 1'b0) 
		if (clk_2 != ni0OO_clk_prev && clk_2 == 1'b1) 
		begin
			n11Oi <= ni01i;
			ni00l <= wire_n11ll_o;
			ni00O <= wire_nii0i_dataout;
			ni01i <= sync_status;
			ni0ii <= wire_nii0l_dataout;
			ni0il <= wire_nii0O_dataout;
			ni0iO <= wire_niiii_dataout;
			ni0li <= wire_niiil_dataout;
			ni0ll <= wire_n101i_o;
			ni0lO <= wire_n101l_o;
			ni0Oi <= wire_n101O_o;
			ni0Ol <= wire_n100i_o;
			nii1i <= wire_n100l_o;
			niilOO <= wire_ni1iiO_o;
			niiO0l <= wire_niO1Oi_dataout;
			niiO0O <= wire_niO1Ol_dataout;
			niiOii <= wire_niO1OO_dataout;
			niiOil <= wire_niO01i_dataout;
			niiOiO <= wire_niO01l_dataout;
			niiOli <= wire_niO01O_dataout;
			niiOll <= wire_niO00i_dataout;
			niiOlO <= wire_niO10i_dataout;
			niiOOi <= wire_niO10l_dataout;
			niiOOl <= wire_niO10O_dataout;
			niiOOO <= wire_niO1ii_dataout;
			nil00i <= wire_ni1iOi_o;
			nil00l <= wire_ni1iOl_o;
			nil00O <= wire_ni1iOO_o;
			nil01i <= nil00l;
			nil01l <= nil00O;
			nil01O <= wire_ni1ilO_o;
			nil10i <= wire_niO1ll_dataout;
			nil10l <= wire_niO00l_dataout;
			nil10O <= wire_niO00O_dataout;
			nil11i <= wire_niO1il_dataout;
			nil11l <= wire_niO1iO_dataout;
			nil11O <= wire_niO1li_dataout;
			nil1ii <= wire_niO0ii_dataout;
			nil1il <= wire_niO0il_dataout;
			nil1iO <= wire_niO0iO_dataout;
			nil1li <= wire_niO0li_dataout;
			nil1ll <= wire_niO0ll_dataout;
			nil1lO <= wire_niO0lO_dataout;
			nil1Oi <= wire_niO0Oi_dataout;
			nil1Ol <= nil01O;
			nil1OO <= nil00i;
			nl1Oll <= nll00l;
			nll00l <= sync_status;
			nll0il <= wire_nl011i_o;
			nll0iO <= wire_nlllii_dataout;
			nll0li <= wire_nlllil_dataout;
			nll0ll <= wire_nllliO_dataout;
			nll0lO <= wire_nlllli_dataout;
			nll0Oi <= wire_nlllll_dataout;
			nll0Ol <= wire_nllllO_dataout;
			nll0OO <= wire_nllO0l_dataout;
			nlli0i <= wire_nllOli_dataout;
			nlli0l <= wire_nllOll_dataout;
			nlli0O <= wire_nllOlO_dataout;
			nlli1i <= wire_nllO0O_dataout;
			nlli1l <= wire_nllOii_dataout;
			nlli1O <= wire_nllOiO_dataout;
			nlliii <= wire_nlO11O_dataout;
			nlliil <= wire_nlO10i_dataout;
			nlliiO <= wire_nlO10l_dataout;
			nllili <= wire_nlO10O_dataout;
			nllill <= wire_nlO1ii_dataout;
			nllilO <= wire_nlO1il_dataout;
			nlliOi <= wire_nlO1iO_dataout;
			nlliOl <= wire_nlO1li_dataout;
			nlliOO <= wire_nlO1ll_dataout;
			nlll0i <= wire_nl01ii_o;
			nlll1i <= wire_nl010i_o;
			nlll1l <= wire_nl010l_o;
			nlll1O <= wire_nl010O_o;
		end
		ni0OO_clk_prev <= clk_2;
	end
	assign
		wire_ni0OO_CLRN = ((n0Ol1i16 ^ n0Ol1i15) & (~ soft_reset)),
		wire_ni0OO_PRN = (n0OiOO18 ^ n0OiOO17);
	initial
	begin
		niiO0i = 0;
	end
	always @ (clk_2 or soft_reset or wire_niiO1O_CLRN)
	begin
		if (soft_reset == 1'b1) 
		begin
			niiO0i <= 1;
		end
		else if  (wire_niiO1O_CLRN == 1'b0) 
		begin
			niiO0i <= 0;
		end
		else if  (rbist_clr_rx == 1'b0) 
		if (clk_2 != niiO1O_clk_prev && clk_2 == 1'b1) 
		begin
			niiO0i <= wire_niO1lO_dataout;
		end
		niiO1O_clk_prev <= clk_2;
	end
	assign
		wire_niiO1O_CLRN = (n0li1O48 ^ n0li1O47);
	or(wire_n000i_dataout, ni01l, (~ n0O01O));
	or(wire_n000l_dataout, ni00i, (~ n0O01O));
	or(wire_n000O_dataout, wire_n00lO_dataout, (~ n0O01O));
	or(wire_n001i_dataout, nii1i, n0Oi1i);
	and(wire_n001l_dataout, wire_n00ll_dataout, ~((~ n0O01O)));
	and(wire_n001O_dataout, wire_n0i1l_dataout, ~((~ n0O01O)));
	assign		wire_n00i_dataout = (n0Olll === 1'b1) ? nlll0i : wire_n0iO_dataout;
	and(wire_n00ii_dataout, wire_n00Oi_dataout, ~((~ n0O01O)));
	or(wire_n00il_dataout, wire_n00Ol_dataout, (~ n0O01O));
	and(wire_n00iO_dataout, wire_n00OO_dataout, ~((~ n0O01O)));
	and(wire_n00l_dataout, wire_n0li_dataout, ~(n0Olll));
	or(wire_n00li_dataout, wire_n0i1i_dataout, (~ n0O01O));
	and(wire_n00ll_dataout, (~ n0O00i), n0OlOi);
	or(wire_n00lO_dataout, wire_n1Oii_dataout, ~(n0OlOi));
	and(wire_n00O_dataout, ni0ll, n0OllO);
	or(wire_n00Oi_dataout, wire_n1Oil_dataout, ~(n0OlOi));
	or(wire_n00Ol_dataout, wire_n1OiO_dataout, ~(n0OlOi));
	or(wire_n00OO_dataout, wire_n1Oli_dataout, ~(n0OlOi));
	and(wire_n010i_dataout, wire_n01iO_dataout, ~(n0OiiO));
	and(wire_n010l_dataout, wire_n01li_dataout, ~(n0OiiO));
	or(wire_n010O_dataout, wire_n01ll_dataout, n0OiiO);
	or(wire_n011i_dataout, wire_n010O_dataout, n0Oill);
	or(wire_n011l_dataout, wire_n01ii_dataout, n0OiiO);
	and(wire_n011O_dataout, wire_n01il_dataout, ~(n0OiiO));
	assign		wire_n01i_dataout = (n0Olll === 1'b1) ? nlll1i : wire_n00O_dataout;
	and(wire_n01ii_dataout, wire_n01lO_dataout, ~(n0Oiil));
	or(wire_n01il_dataout, wire_n01Oi_dataout, n0Oiil);
	and(wire_n01iO_dataout, wire_n01Ol_dataout, ~(n0Oiil));
	assign		wire_n01l_dataout = (n0Olll === 1'b1) ? nlll1l : wire_n0ii_dataout;
	and(wire_n01li_dataout, wire_n01OO_dataout, ~(n0Oiil));
	or(wire_n01ll_dataout, wire_n001i_dataout, n0Oiil);
	or(wire_n01lO_dataout, ni0ll, n0Oi1i);
	assign		wire_n01O_dataout = (n0Olll === 1'b1) ? nlll1O : wire_n0il_dataout;
	or(wire_n01Oi_dataout, ni0lO, n0Oi1i);
	and(wire_n01Ol_dataout, ni0Oi, ~(n0Oi1i));
	and(wire_n01OO_dataout, ni0Ol, ~(n0Oi1i));
	assign		wire_n0i_dataout = (n0OlOl === 1'b1) ? rxd[33] : rxd[17];
	or(wire_n0i0i_dataout, ni00i, (~ n0O00l));
	or(wire_n0i0l_dataout, ni01l, (~ n0O00O));
	or(wire_n0i0O_dataout, ni00i, (~ n0O00O));
	and(wire_n0i1i_dataout, wire_n1Oll_dataout, n0OlOi);
	and(wire_n0i1l_dataout, n0O00i, n0OlOi);
	or(wire_n0i1O_dataout, ni01l, (~ n0O00l));
	and(wire_n0ii_dataout, ni0lO, n0OllO);
	or(wire_n0iii_dataout, (~ n0OlOi), (~ n0O00O));
	and(wire_n0iil_dataout, n0OlOi, ~((~ n0O00O)));
	or(wire_n0iiO_dataout, ni01l, (~ n0O0ii));
	and(wire_n0il_dataout, ni0Oi, n0OllO);
	or(wire_n0ili_dataout, ni00i, (~ n0O0ii));
	or(wire_n0ill_dataout, ni01l, (~ n0O0il));
	or(wire_n0ilO_dataout, ni00i, (~ n0O0il));
	and(wire_n0iO_dataout, ni0Ol, n0OllO);
	or(wire_n0iOi_dataout, (~ n0OlOi), (~ n0O0il));
	and(wire_n0iOl_dataout, (~ n0OlOi), ~((~ n0O0il)));
	or(wire_n0iOO_dataout, n0OlOi, (~ n0O0il));
	assign		wire_n0l_dataout = (n0OlOl === 1'b1) ? rxd[34] : rxd[18];
	or(wire_n0l0i_dataout, ni00i, (~ n0O0li));
	or(wire_n0l0l_dataout, (~ n0OlOi), (~ n0O0li));
	and(wire_n0l0O_dataout, n0OlOi, ~((~ n0O0li)));
	or(wire_n0l1i_dataout, ni01l, (~ n0O0iO));
	or(wire_n0l1l_dataout, ni00i, (~ n0O0iO));
	or(wire_n0l1O_dataout, ni01l, (~ n0O0li));
	and(wire_n0li_dataout, nii1i, n0OllO);
	or(wire_n0lii_dataout, ni01l, (~ n0O0ll));
	or(wire_n0lil_dataout, ni00i, (~ n0O0ll));
	or(wire_n0liO_dataout, ni01l, (~ n0O0lO));
	or(wire_n0lli_dataout, ni00i, (~ n0O0lO));
	and(wire_n0lll_dataout, (~ n0OlOi), ~((~ n0O0lO)));
	or(wire_n0llO_dataout, (~ n0OlOi), (~ n0O0lO));
	and(wire_n0lOi_dataout, n0OlOi, ~((~ n0O0lO)));
	or(wire_n0lOl_dataout, ni01l, (~ n0O0Oi));
	or(wire_n0lOO_dataout, ni00i, (~ n0O0Oi));
	assign		wire_n0O_dataout = (n0OlOl === 1'b1) ? rxd[35] : rxd[19];
	and(wire_n0O0i_dataout, n0OlOi, ~((~ n0O0Ol)));
	and(wire_n0O0l_dataout, ni0ll, ~((~ n0Oi1i)));
	and(wire_n0O0O_dataout, ni0lO, ~((~ n0Oi1i)));
	or(wire_n0O1i_dataout, ni01l, (~ n0O0Ol));
	or(wire_n0O1l_dataout, ni00i, (~ n0O0Ol));
	or(wire_n0O1O_dataout, (~ n0OlOi), (~ n0O0Ol));
	and(wire_n0Oi_dataout, ni1lOl, n0Olli);
	or(wire_n0Oii_dataout, ni0Oi, (~ n0Oi1i));
	and(wire_n0Oil_dataout, ni0Ol, ~((~ n0Oi1i)));
	and(wire_n0OiO_dataout, nii1i, ~((~ n0Oi1i)));
	and(wire_n0Ol_dataout, niiilO, n0Olli);
	and(wire_n0Oli_dataout, wire_n0OOO_dataout, ~(n0Oili));
	assign		wire_n0Oll_dataout = (n0Oili === 1'b1) ? (~ n0OlOi) : wire_ni11i_dataout;
	assign		wire_n0OlO_dataout = (n0Oili === 1'b1) ? n0OlOi : wire_ni11l_dataout;
	and(wire_n0OO_dataout, niiiOi, n0Olli);
	and(wire_n0OOi_dataout, wire_ni11O_dataout, ~(n0Oili));
	and(wire_n0OOl_dataout, wire_ni10i_dataout, ~(n0Oili));
	and(wire_n0OOO_dataout, wire_ni10l_dataout, ~(n0Oi1l));
	and(wire_n100O_dataout, ni00i, ~((~ wire_ni_dataout)));
	and(wire_n10ii_dataout, ni01l, ~((~ wire_ni_dataout)));
	and(wire_n10il_dataout, ni0ll, ~((~ wire_ni_dataout)));
	and(wire_n10iO_dataout, ni0lO, ~((~ wire_ni_dataout)));
	and(wire_n10li_dataout, ni0Oi, ~((~ wire_ni_dataout)));
	and(wire_n10ll_dataout, ni0Ol, ~((~ wire_ni_dataout)));
	and(wire_n10lO_dataout, nii1i, ~((~ wire_ni_dataout)));
	or(wire_n10Oi_dataout, ni00l, ~(n0O1il));
	or(wire_n10Ol_dataout, wire_n1i1l_dataout, n0O1il);
	or(wire_n10OO_dataout, ni00i, n0O1il);
	or(wire_n1i0i_dataout, ni00l, ~((~ n0O1li)));
	or(wire_n1i0l_dataout, wire_n1i1l_dataout, (~ n0O1li));
	or(wire_n1i0O_dataout, ni00i, (~ n0O1li));
	or(wire_n1i1i_dataout, ni00l, n0O1il);
	or(wire_n1i1l_dataout, ni01l, ni00l);
	or(wire_n1iii_dataout, ni00l, (~ n0O1li));
	or(wire_n1iil_dataout, ni00l, ~((~ n0O1ll)));
	or(wire_n1iiO_dataout, wire_n1i1l_dataout, (~ n0O1ll));
	or(wire_n1ili_dataout, ni00i, (~ n0O1ll));
	or(wire_n1ill_dataout, ni00l, (~ n0O1ll));
	or(wire_n1ilO_dataout, ni00l, ~((~ n0O1lO)));
	or(wire_n1iOi_dataout, wire_n1i1l_dataout, (~ n0O1lO));
	or(wire_n1iOl_dataout, ni00i, (~ n0O1lO));
	or(wire_n1iOO_dataout, ni00l, (~ n0O1lO));
	assign		wire_n1l_dataout = (n0OlOl === 1'b1) ? rxc[2] : rxc[1];
	or(wire_n1l0i_dataout, (~ n0O01i), n0OlOi);
	or(wire_n1l0l_dataout, wire_n1lll_dataout, ~(n0OlOi));
	or(wire_n1l0O_dataout, ni01l, (~ n0O01i));
	assign		wire_n1l1i_dataout = (n0OlOi === 1'b1) ? wire_n1lil_dataout : ni00l;
	assign		wire_n1l1l_dataout = (n0OlOi === 1'b1) ? wire_n1liO_dataout : wire_n1l0O_dataout;
	assign		wire_n1l1O_dataout = (n0OlOi === 1'b1) ? wire_n1lli_dataout : wire_n1lii_dataout;
	or(wire_n1lii_dataout, ni00i, (~ n0O01i));
	or(wire_n1lil_dataout, ni00l, ~(n0O1Oi));
	or(wire_n1liO_dataout, wire_n1i1l_dataout, n0O1Oi);
	assign		wire_n1ll_dataout = (n0Olli === 1'b1) ? nil01O : wire_n01i_dataout;
	or(wire_n1lli_dataout, ni00i, n0O1Oi);
	or(wire_n1lll_dataout, ni00l, n0O1Oi);
	assign		wire_n1lO_dataout = (n0Olli === 1'b1) ? nil00i : wire_n01l_dataout;
	and(wire_n1lOi_dataout, (~ n0O00i), ~((~ n0O01l)));
	and(wire_n1lOl_dataout, n0O00i, ~((~ n0O01l)));
	or(wire_n1lOO_dataout, ni01l, (~ n0O01l));
	assign		wire_n1O_dataout = (n0OlOl === 1'b1) ? rxd[32] : rxd[16];
	or(wire_n1O0i_dataout, wire_n1OiO_dataout, (~ n0O01l));
	and(wire_n1O0l_dataout, wire_n1Oli_dataout, ~((~ n0O01l)));
	or(wire_n1O0O_dataout, wire_n1Oll_dataout, (~ n0O01l));
	or(wire_n1O1i_dataout, ni00i, (~ n0O01l));
	or(wire_n1O1l_dataout, wire_n1Oii_dataout, (~ n0O01l));
	and(wire_n1O1O_dataout, wire_n1Oil_dataout, ~((~ n0O01l)));
	assign		wire_n1Oi_dataout = (n0Olli === 1'b1) ? nil00l : wire_n01O_dataout;
	and(wire_n1Oii_dataout, wire_n1OlO_dataout, n0O00i);
	and(wire_n1Oil_dataout, wire_n1OOi_dataout, n0O00i);
	or(wire_n1OiO_dataout, wire_n1OOl_dataout, ~(n0O00i));
	assign		wire_n1Ol_dataout = (n0Olli === 1'b1) ? nil00O : wire_n00i_dataout;
	and(wire_n1Oli_dataout, wire_n1OOO_dataout, n0O00i);
	and(wire_n1Oll_dataout, wire_n011i_dataout, n0O00i);
	and(wire_n1OlO_dataout, wire_n011l_dataout, ~(n0Oill));
	and(wire_n1OO_dataout, wire_n00l_dataout, ~(n0Olli));
	and(wire_n1OOi_dataout, wire_n011O_dataout, ~(n0Oill));
	and(wire_n1OOl_dataout, wire_n010i_dataout, ~(n0Oill));
	and(wire_n1OOO_dataout, wire_n010l_dataout, ~(n0Oill));
	and(wire_ni_dataout, rbisten_rx, (((~ rbist_sel[0]) & rbist_sel[1]) & (n0OO1l4 ^ n0OO1l3)));
	assign		wire_ni000i_dataout = (n0OlOi === 1'b1) ? n0l11O : n0l11i;
	or(wire_ni000l_dataout, niiO1i, n0l11i);
	or(wire_ni000O_dataout, niiO1l, n0l11i);
	assign		wire_ni001i_dataout = (n0OlOi === 1'b1) ? wire_ni00il_dataout : wire_ni000l_dataout;
	assign		wire_ni001l_dataout = (n0OlOi === 1'b1) ? wire_ni00iO_dataout : wire_ni000O_dataout;
	or(wire_ni001O_dataout, n0l11i, n0OlOi);
	or(wire_ni00il_dataout, niiO1i, n0l11O);
	or(wire_ni00iO_dataout, niiO1l, n0l11O);
	or(wire_ni00ll_dataout, niiO1i, n0l10l);
	or(wire_ni00lO_dataout, niiO1l, n0l10l);
	assign		wire_ni00Ol_dataout = (n0OlOi === 1'b1) ? wire_ni0iii_dataout : wire_ni0i0i_dataout;
	assign		wire_ni00OO_dataout = (n0OlOi === 1'b1) ? wire_ni0iil_dataout : wire_ni0i0l_dataout;
	or(wire_ni010i_dataout, n0iOli, n0OlOi);
	assign		wire_ni010l_dataout = (n0OlOi === 1'b1) ? (~ n0iOlO) : (~ n0iOli);
	assign		wire_ni010O_dataout = (n0OlOi === 1'b1) ? n0iOlO : n0iOli;
	assign		wire_ni011l_dataout = (n0OlOi === 1'b1) ? wire_ni01li_dataout : wire_ni01ii_dataout;
	assign		wire_ni011O_dataout = (n0OlOi === 1'b1) ? wire_ni01ll_dataout : wire_ni01il_dataout;
	or(wire_ni01ii_dataout, niiO1i, n0iOli);
	or(wire_ni01il_dataout, niiO1l, n0iOli);
	or(wire_ni01li_dataout, niiO1i, n0iOlO);
	or(wire_ni01ll_dataout, niiO1l, n0iOlO);
	or(wire_ni01Oi_dataout, niiO1i, n0iOOl);
	or(wire_ni01Ol_dataout, niiO1l, n0iOOl);
	and(wire_ni0i_dataout, niil1l, n0Olli);
	or(wire_ni0i0i_dataout, niiO1i, n0l1ii);
	or(wire_ni0i0l_dataout, niiO1l, n0l1ii);
	or(wire_ni0i1i_dataout, n0l1ii, n0OlOi);
	assign		wire_ni0i1l_dataout = (n0OlOi === 1'b1) ? (~ n0l1iO) : (~ n0l1ii);
	assign		wire_ni0i1O_dataout = (n0OlOi === 1'b1) ? n0l1iO : n0l1ii;
	or(wire_ni0iii_dataout, niiO1i, n0l1iO);
	or(wire_ni0iil_dataout, niiO1l, n0l1iO);
	or(wire_ni0ili_dataout, niiO1i, n0l1ll);
	or(wire_ni0ill_dataout, niiO1l, n0l1ll);
	assign		wire_ni0iOi_dataout = (n0OlOi === 1'b1) ? wire_ni0l0l_dataout : wire_ni0l1l_dataout;
	assign		wire_ni0iOl_dataout = (n0OlOi === 1'b1) ? wire_ni0l0O_dataout : wire_ni0l1O_dataout;
	or(wire_ni0iOO_dataout, n0l1Oi, n0OlOi);
	and(wire_ni0l_dataout, niil1O, n0Olli);
	or(wire_ni0l0l_dataout, niiO1i, n0l01i);
	or(wire_ni0l0O_dataout, niiO1l, n0l01i);
	assign		wire_ni0l1i_dataout = (n0OlOi === 1'b1) ? n0l01i : n0l1Oi;
	or(wire_ni0l1l_dataout, niiO1i, n0l1Oi);
	or(wire_ni0l1O_dataout, niiO1l, n0l1Oi);
	or(wire_ni0lil_dataout, niiO1i, n0l0ii);
	or(wire_ni0liO_dataout, niiO1l, n0l0ii);
	or(wire_ni0lli_dataout, wire_ni0lOl_dataout, n0l0ii);
	and(wire_ni0lll_dataout, wire_ni0lOO_dataout, ~(n0l0ii));
	or(wire_ni0llO_dataout, wire_ni0O1i_dataout, n0l0ii);
	or(wire_ni0lOi_dataout, wire_ni0O1l_dataout, n0l0ii);
	or(wire_ni0lOl_dataout, wire_ni0O1O_dataout, n0l00l);
	or(wire_ni0lOO_dataout, wire_ni0O0i_dataout, n0l00l);
	and(wire_ni0O_dataout, niil0i, n0Olli);
	or(wire_ni0O0i_dataout, nil00i, n0l00i);
	and(wire_ni0O0l_dataout, nil00l, ~(n0l00i));
	and(wire_ni0O0O_dataout, nil00O, ~(n0l00i));
	and(wire_ni0O1i_dataout, wire_ni0O0l_dataout, ~(n0l00l));
	and(wire_ni0O1l_dataout, wire_ni0O0O_dataout, ~(n0l00l));
	or(wire_ni0O1O_dataout, nil01O, n0l00i);
	or(wire_ni0OiO_dataout, wire_nii11i_dataout, n0l0Ol);
	or(wire_ni0Oli_dataout, niiO1i, n0l0Ol);
	or(wire_ni0Oll_dataout, niiO1l, n0l0Ol);
	or(wire_ni0OlO_dataout, wire_nii11l_dataout, n0l0Ol);
	and(wire_ni0OOi_dataout, wire_nii11O_dataout, ~(n0l0Ol));
	or(wire_ni0OOl_dataout, wire_nii10i_dataout, n0l0Ol);
	or(wire_ni0OOO_dataout, wire_nii10l_dataout, n0l0Ol);
	and(wire_ni10i_dataout, wire_ni1iO_dataout, ~(n0Oi1l));
	assign		wire_ni10l_dataout = (n0O0OO === 1'b1) ? (~ n0OlOi) : ni0ll;
	assign		wire_ni10O_dataout = (n0O0OO === 1'b1) ? (~ n0OlOi) : ni0lO;
	assign		wire_ni11i_dataout = (n0Oi1l === 1'b1) ? (~ n0OlOi) : wire_ni10O_dataout;
	assign		wire_ni11l_dataout = (n0Oi1l === 1'b1) ? n0OlOi : wire_ni1ii_dataout;
	and(wire_ni11O_dataout, wire_ni1il_dataout, ~(n0Oi1l));
	and(wire_ni1i_dataout, niiiOl, n0Olli);
	assign		wire_ni1ii_dataout = (n0O0OO === 1'b1) ? n0OlOi : ni0Oi;
	and(wire_ni1il_dataout, ni0Ol, ~(n0O0OO));
	and(wire_ni1iO_dataout, nii1i, ~(n0O0OO));
	and(wire_ni1l_dataout, niiiOO, n0Olli);
	and(wire_ni1l0i_dataout, nil01O, ~((~ wire_nO_dataout)));
	and(wire_ni1l0l_dataout, nil00i, ~((~ wire_nO_dataout)));
	and(wire_ni1l0O_dataout, nil00l, ~((~ wire_nO_dataout)));
	and(wire_ni1l1i_dataout, niilOO, ~((~ wire_nO_dataout)));
	and(wire_ni1l1l_dataout, niiO1i, ~((~ wire_nO_dataout)));
	and(wire_ni1l1O_dataout, niiO1l, ~((~ wire_nO_dataout)));
	and(wire_ni1lii_dataout, nil00O, ~((~ wire_nO_dataout)));
	or(wire_ni1lil_dataout, niilOO, ~(n0iO1l));
	or(wire_ni1liO_dataout, niiO1i, n0iO1l);
	or(wire_ni1lli_dataout, wire_ni1llO_dataout, n0iO1l);
	or(wire_ni1lll_dataout, niilOO, n0iO1l);
	or(wire_ni1llO_dataout, niiO1l, niilOO);
	assign		wire_ni1lOO_dataout = (n0OlOi === 1'b1) ? wire_ni1OiO_dataout : niilOO;
	and(wire_ni1O_dataout, niil1i, n0Olli);
	or(wire_ni1O0i_dataout, n0iO0i, n0OlOi);
	or(wire_ni1O0l_dataout, wire_ni1OlO_dataout, ~(n0OlOi));
	or(wire_ni1O0O_dataout, niiO1i, n0iO0i);
	assign		wire_ni1O1i_dataout = (n0OlOi === 1'b1) ? n0iO0O : n0iO0i;
	assign		wire_ni1O1l_dataout = (n0OlOi === 1'b1) ? wire_ni1Oli_dataout : wire_ni1O0O_dataout;
	assign		wire_ni1O1O_dataout = (n0OlOi === 1'b1) ? wire_ni1Oll_dataout : wire_ni1Oii_dataout;
	or(wire_ni1Oii_dataout, niiO1l, n0iO0i);
	or(wire_ni1OiO_dataout, niilOO, ~(n0iO0O));
	or(wire_ni1Oli_dataout, niiO1i, n0iO0O);
	or(wire_ni1Oll_dataout, wire_ni1llO_dataout, n0iO0O);
	or(wire_ni1OlO_dataout, niilOO, n0iO0O);
	or(wire_ni1OOl_dataout, niiO1i, n0iOil);
	or(wire_ni1OOO_dataout, niiO1l, n0iOil);
	assign		wire_nii_dataout = (n0OlOl === 1'b1) ? rxd[36] : rxd[20];
	or(wire_nii00i_dataout, nil01O, n0li1l);
	and(wire_nii00l_dataout, nil00i, ~(n0li1l));
	and(wire_nii00O_dataout, nil00l, ~(n0li1l));
	assign		wire_nii0i_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[0] : wire_niiiO_dataout;
	and(wire_nii0ii_dataout, nil00O, ~(n0li1l));
	assign		wire_nii0l_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[1] : wire_niili_dataout;
	or(wire_nii0ll_dataout, wire_niOi0i_dataout, ~(wire_nii0Ol_o[2]));
	assign		wire_nii0O_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[2] : wire_niill_dataout;
	or(wire_nii0Oi_dataout, wire_niOi0O_dataout, ~(wire_nii0Ol_o[2]));
	and(wire_nii10i_dataout, wire_nii1il_dataout, ~(n0l0ll));
	and(wire_nii10l_dataout, wire_nii1iO_dataout, ~(n0l0ll));
	and(wire_nii10O_dataout, nil01O, ~(n0l0iO));
	and(wire_nii11i_dataout, (~ n0l0iO), ~(n0l0ll));
	and(wire_nii11l_dataout, wire_nii10O_dataout, ~(n0l0ll));
	or(wire_nii11O_dataout, wire_nii1ii_dataout, n0l0ll);
	or(wire_nii1ii_dataout, nil00i, n0l0iO);
	and(wire_nii1il_dataout, nil00l, ~(n0l0iO));
	and(wire_nii1iO_dataout, nil00O, ~(n0l0iO));
	and(wire_nii1l_dataout, wire_n11OO_o, ~(rbist_clr_rx));
	and(wire_nii1O_dataout, wire_n11Ol_o, ~(rbist_clr_rx));
	and(wire_niii_dataout, niil0l, n0Olli);
	assign		wire_niiii_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[3] : wire_niilO_dataout;
	assign		wire_niiil_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[4] : wire_niiOi_dataout;
	and(wire_niiiO_dataout, ni00O, ~(wire_n11il_o));
	and(wire_niil_dataout, niil0O, n0Olli);
	and(wire_niili_dataout, ni0ii, ~(wire_n11il_o));
	and(wire_niill_dataout, ni0il, ~(wire_n11il_o));
	and(wire_niilO_dataout, ni0iO, ~(wire_n11il_o));
	and(wire_niiO_dataout, niilii, n0Olli);
	and(wire_niiOi_dataout, ni0li, ~(wire_n11il_o));
	assign		wire_nil_dataout = (n0OlOl === 1'b1) ? rxd[37] : rxd[21];
	and(wire_nil0ii_dataout, wire_niliOi_dataout, ~(rbist_clr_rx));
	and(wire_nil0il_dataout, wire_niliOl_dataout, ~(rbist_clr_rx));
	and(wire_nil0iO_dataout, wire_niliOO_dataout, ~(rbist_clr_rx));
	and(wire_nil0li_dataout, wire_nill1i_dataout, ~(rbist_clr_rx));
	and(wire_nil0ll_dataout, wire_nill1l_dataout, ~(rbist_clr_rx));
	and(wire_nil0lO_dataout, wire_nill1O_dataout, ~(rbist_clr_rx));
	and(wire_nil0Oi_dataout, wire_nill0i_dataout, ~(rbist_clr_rx));
	and(wire_nil0Ol_dataout, wire_nill0l_dataout, ~(rbist_clr_rx));
	and(wire_nil0OO_dataout, wire_nill0O_dataout, ~(rbist_clr_rx));
	and(wire_nili_dataout, niilil, n0Olli);
	and(wire_nili0i_dataout, wire_nillli_dataout, ~(rbist_clr_rx));
	and(wire_nili0l_dataout, wire_nillll_dataout, ~(rbist_clr_rx));
	and(wire_nili0O_dataout, wire_nilllO_dataout, ~(rbist_clr_rx));
	and(wire_nili1i_dataout, wire_nillii_dataout, ~(rbist_clr_rx));
	and(wire_nili1l_dataout, wire_nillil_dataout, ~(rbist_clr_rx));
	and(wire_nili1O_dataout, wire_nilliO_dataout, ~(rbist_clr_rx));
	and(wire_niliii_dataout, wire_nillOi_dataout, ~(rbist_clr_rx));
	and(wire_niliil_dataout, wire_nillOl_dataout, ~(rbist_clr_rx));
	and(wire_niliiO_dataout, wire_nillOO_dataout, ~(rbist_clr_rx));
	and(wire_nilili_dataout, wire_ni1iil_o, ~(rbist_clr_rx));
	and(wire_nilill_dataout, wire_ni1ili_o, ~(rbist_clr_rx));
	and(wire_nililO_dataout, wire_ni1ill_o, ~(rbist_clr_rx));
	and(wire_niliOi_dataout, wire_nilO1i_dataout, ~((~ wire_nO_dataout)));
	and(wire_niliOl_dataout, wire_nilO1l_dataout, ~((~ wire_nO_dataout)));
	and(wire_niliOO_dataout, wire_nilO1O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill_dataout, niiliO, n0Olli);
	and(wire_nill0i_dataout, wire_nilOii_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill0l_dataout, wire_nilOil_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill0O_dataout, wire_nilOiO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1i_dataout, wire_nilO0i_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1l_dataout, wire_nilO0l_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1O_dataout, wire_nilO0O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillii_dataout, wire_nilOli_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillil_dataout, wire_nilOll_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilliO_dataout, wire_nilOlO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillli_dataout, wire_nilOOi_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillll_dataout, wire_nilOOl_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilllO_dataout, wire_nilOOO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOi_dataout, wire_niO11i_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOl_dataout, wire_niO11l_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOO_dataout, wire_niO11O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilO_dataout, niilli, n0Olli);
	assign		wire_nilO0i_dataout = (niilOl === 1'b1) ? wire_nii0lO_o : niiiOl;
	assign		wire_nilO0l_dataout = (niilOl === 1'b1) ? wire_nii0Oi_dataout : niiiOO;
	assign		wire_nilO0O_dataout = (niilOl === 1'b1) ? wire_nii0OO_o : niil1i;
	assign		wire_nilO1i_dataout = (niilOl === 1'b1) ? wire_nii0iO_o : ni1lOl;
	assign		wire_nilO1l_dataout = (niilOl === 1'b1) ? wire_nii0li_o : niiilO;
	assign		wire_nilO1O_dataout = (niilOl === 1'b1) ? wire_nii0ll_dataout : niiiOi;
	assign		wire_nilOii_dataout = (niilOl === 1'b1) ? wire_niii1i_o : niil1l;
	assign		wire_nilOil_dataout = (niilOl === 1'b1) ? wire_niii1l_o : niil1O;
	assign		wire_nilOiO_dataout = (niilOl === 1'b1) ? wire_niii1O_o : niil0i;
	assign		wire_nilOli_dataout = (niilOl === 1'b1) ? wire_niii0i_o : niil0l;
	assign		wire_nilOll_dataout = (niilOl === 1'b1) ? wire_niii0l_o : niil0O;
	assign		wire_nilOlO_dataout = (niilOl === 1'b1) ? wire_niii0O_o : niilii;
	assign		wire_nilOOi_dataout = (niilOl === 1'b1) ? wire_niiiii_o : niilil;
	assign		wire_nilOOl_dataout = (niilOl === 1'b1) ? wire_niiiil_o : niiliO;
	assign		wire_nilOOO_dataout = (niilOl === 1'b1) ? wire_niiiiO_o : niilli;
	assign		wire_niO_dataout = (n0OlOl === 1'b1) ? rxd[38] : rxd[22];
	and(wire_niO00i_dataout, wire_niO0OO_o[6], wire_ni1i0l_o);
	and(wire_niO00l_dataout, wire_niOi1i_o[0], wire_ni1i0l_o);
	and(wire_niO00O_dataout, wire_niOi1i_o[1], wire_ni1i0l_o);
	and(wire_niO01i_dataout, wire_niO0OO_o[3], wire_ni1i0l_o);
	and(wire_niO01l_dataout, wire_niO0OO_o[4], wire_ni1i0l_o);
	and(wire_niO01O_dataout, wire_niO0OO_o[5], wire_ni1i0l_o);
	and(wire_niO0ii_dataout, wire_niOi1i_o[2], wire_ni1i0l_o);
	and(wire_niO0il_dataout, wire_niOi1i_o[3], wire_ni1i0l_o);
	and(wire_niO0iO_dataout, wire_niOi1i_o[4], wire_ni1i0l_o);
	and(wire_niO0li_dataout, wire_niOi1i_o[5], wire_ni1i0l_o);
	and(wire_niO0ll_dataout, wire_niOi1i_o[6], wire_ni1i0l_o);
	and(wire_niO0lO_dataout, wire_niOi1i_o[7], wire_ni1i0l_o);
	and(wire_niO0Oi_dataout, wire_niOi1i_o[8], wire_ni1i0l_o);
	and(wire_niO10i_dataout, niiOlO, wire_ni1i0l_o);
	and(wire_niO10l_dataout, wire_niO0Ol_o[0], wire_ni1i0l_o);
	and(wire_niO10O_dataout, wire_niO0Ol_o[1], wire_ni1i0l_o);
	assign		wire_niO11i_dataout = (niilOl === 1'b1) ? wire_niiili_o : niilll;
	assign		wire_niO11l_dataout = (niilOl === 1'b1) ? (~ wire_nii0Ol_o[2]) : niillO;
	assign		wire_niO11O_dataout = (niilOl === 1'b1) ? wire_niiill_o : niilOi;
	and(wire_niO1ii_dataout, wire_niO0Ol_o[2], wire_ni1i0l_o);
	and(wire_niO1il_dataout, wire_niO0Ol_o[3], wire_ni1i0l_o);
	and(wire_niO1iO_dataout, wire_niO0Ol_o[4], wire_ni1i0l_o);
	and(wire_niO1li_dataout, wire_niO0Ol_o[5], wire_ni1i0l_o);
	and(wire_niO1ll_dataout, wire_niO0Ol_o[6], wire_ni1i0l_o);
	or(wire_niO1lO_dataout, niiO0i, ~(wire_ni1i0l_o));
	and(wire_niO1Oi_dataout, wire_niO0OO_o[0], wire_ni1i0l_o);
	and(wire_niO1Ol_dataout, wire_niO0OO_o[1], wire_ni1i0l_o);
	and(wire_niO1OO_dataout, wire_niO0OO_o[2], wire_ni1i0l_o);
	and(wire_niOi_dataout, niilll, n0Olli);
	assign		wire_niOi0i_dataout = (n0OlOi === 1'b1) ? niiOOl : nil1ii;
	assign		wire_niOi0l_dataout = (n0OlOi === 1'b1) ? niiOOO : nil1il;
	assign		wire_niOi0O_dataout = (n0OlOi === 1'b1) ? nil11i : nil1iO;
	assign		wire_niOi1l_dataout = (n0OlOi === 1'b1) ? niiOlO : nil10l;
	assign		wire_niOi1O_dataout = (n0OlOi === 1'b1) ? niiOOi : nil10O;
	assign		wire_niOiii_dataout = (n0OlOi === 1'b1) ? nil11l : nil1li;
	assign		wire_niOiil_dataout = (n0OlOi === 1'b1) ? nil11O : nil1ll;
	assign		wire_niOiiO_dataout = (n0OlOi === 1'b1) ? nil10i : nil1lO;
	and(wire_niOili_dataout, niiO0i, n0OlOi);
	and(wire_niOill_dataout, niiO0l, n0OlOi);
	and(wire_niOilO_dataout, niiO0O, n0OlOi);
	and(wire_niOiOi_dataout, niiOii, n0OlOi);
	and(wire_niOiOl_dataout, niiOil, n0OlOi);
	and(wire_niOiOO_dataout, niiOiO, n0OlOi);
	and(wire_niOl_dataout, niillO, n0Olli);
	and(wire_niOl1i_dataout, niiOli, n0OlOi);
	and(wire_niOl1l_dataout, niiOll, n0OlOi);
	and(wire_niOO_dataout, niilOi, n0Olli);
	and(wire_nl_dataout, rbisten_rx, (rbist_sel[0] & (~ rbist_sel[1])));
	or(wire_nl000l_dataout, nll0il, ~((~ n0li0O)));
	or(wire_nl000O_dataout, wire_nl001O_dataout, (~ n0li0O));
	or(wire_nl001i_dataout, nll0ii, n0li0i);
	or(wire_nl001l_dataout, nll0il, n0li0i);
	or(wire_nl001O_dataout, nll00O, nll0il);
	or(wire_nl00ii_dataout, nll0ii, (~ n0li0O));
	or(wire_nl00il_dataout, nll0il, (~ n0li0O));
	or(wire_nl00iO_dataout, nll0il, ~((~ n0liii)));
	or(wire_nl00li_dataout, wire_nl001O_dataout, (~ n0liii));
	or(wire_nl00ll_dataout, nll0ii, (~ n0liii));
	or(wire_nl00lO_dataout, nll0il, (~ n0liii));
	or(wire_nl00Oi_dataout, nll0il, ~((~ n0liil)));
	or(wire_nl00Ol_dataout, wire_nl001O_dataout, (~ n0liil));
	or(wire_nl00OO_dataout, nll0ii, (~ n0liil));
	and(wire_nl01il_dataout, nll0ii, ~((~ wire_nl_dataout)));
	and(wire_nl01iO_dataout, nll00O, ~((~ wire_nl_dataout)));
	and(wire_nl01li_dataout, nlll1i, ~((~ wire_nl_dataout)));
	and(wire_nl01ll_dataout, nlll1l, ~((~ wire_nl_dataout)));
	and(wire_nl01lO_dataout, nlll1O, ~((~ wire_nl_dataout)));
	and(wire_nl01Oi_dataout, nlll0i, ~((~ wire_nl_dataout)));
	or(wire_nl01Ol_dataout, nll0il, ~(n0li0i));
	or(wire_nl01OO_dataout, wire_nl001O_dataout, n0li0i);
	assign		wire_nl0i_dataout = (n0Olll === 1'b1) ? nll00O : wire_nl0O_dataout;
	assign		wire_nl0i0i_dataout = (n0OlOi === 1'b1) ? wire_nl0ill_dataout : wire_nl0iil_dataout;
	or(wire_nl0i0l_dataout, (~ n0lili), n0OlOi);
	or(wire_nl0i0O_dataout, wire_nl0ilO_dataout, ~(n0OlOi));
	or(wire_nl0i1i_dataout, nll0il, (~ n0liil));
	assign		wire_nl0i1l_dataout = (n0OlOi === 1'b1) ? wire_nl0iiO_dataout : nll0il;
	assign		wire_nl0i1O_dataout = (n0OlOi === 1'b1) ? wire_nl0ili_dataout : wire_nl0iii_dataout;
	or(wire_nl0iii_dataout, nll00O, (~ n0lili));
	or(wire_nl0iil_dataout, nll0ii, (~ n0lili));
	or(wire_nl0iiO_dataout, nll0il, ~(n0liiO));
	or(wire_nl0ili_dataout, wire_nl001O_dataout, n0liiO);
	or(wire_nl0ill_dataout, nll0ii, n0liiO);
	or(wire_nl0ilO_dataout, nll0il, n0liiO);
	and(wire_nl0iOl_dataout, wire_nl0l0O_dataout, ~((~ n0lill)));
	and(wire_nl0iOO_dataout, wire_nl0l0l_dataout, ~((~ n0lill)));
	and(wire_nl0l_dataout, ni00i, n0OllO);
	or(wire_nl0l0i_dataout, wire_nl0l0O_dataout, (~ n0lill));
	assign		wire_nl0l0l_dataout = (n0OlOi === 1'b1) ? n0lilO : n0liOi;
	assign		wire_nl0l0O_dataout = (n0OlOi === 1'b1) ? (~ n0lilO) : (~ n0liOi);
	or(wire_nl0l1i_dataout, nll00O, (~ n0lill));
	or(wire_nl0l1l_dataout, nll0ii, (~ n0lill));
	or(wire_nl0l1O_dataout, wire_nl0l0l_dataout, (~ n0lill));
	or(wire_nl0lii_dataout, nll00O, (~ n0liOl));
	or(wire_nl0lil_dataout, nll0ii, (~ n0liOl));
	and(wire_nl0liO_dataout, n0OlOi, ~((~ n0liOO)));
	or(wire_nl0lli_dataout, nll00O, (~ n0liOO));
	or(wire_nl0lll_dataout, nll0ii, (~ n0liOO));
	or(wire_nl0llO_dataout, wire_nl0O1i_dataout, (~ n0liOO));
	or(wire_nl0lOi_dataout, wire_nl0O1l_dataout, (~ n0liOO));
	or(wire_nl0lOl_dataout, wire_nl0O1O_dataout, (~ n0liOO));
	or(wire_nl0lOO_dataout, wire_nl0O0i_dataout, (~ n0liOO));
	and(wire_nl0O_dataout, ni01l, n0OllO);
	and(wire_nl0O0i_dataout, wire_nl0Oil_dataout, n0OlOi);
	or(wire_nl0O0l_dataout, wire_nl0OiO_dataout, n0ll1i);
	and(wire_nl0O0O_dataout, wire_nl0Oli_dataout, ~(n0ll1i));
	and(wire_nl0O1i_dataout, wire_nl0O0l_dataout, n0OlOi);
	or(wire_nl0O1l_dataout, wire_nl0O0O_dataout, ~(n0OlOi));
	or(wire_nl0O1O_dataout, wire_nl0Oii_dataout, ~(n0OlOi));
	or(wire_nl0Oii_dataout, wire_nl0Oll_dataout, n0ll1i);
	and(wire_nl0Oil_dataout, wire_nl0OlO_dataout, ~(n0ll1i));
	or(wire_nl0OiO_dataout, wire_nl0OOi_dataout, ~(n0ll1l));
	or(wire_nl0Oli_dataout, wire_nl0OOl_dataout, ~(n0ll1l));
	or(wire_nl0Oll_dataout, wire_nl0OOO_dataout, ~(n0ll1l));
	and(wire_nl0OlO_dataout, wire_nli11i_dataout, n0ll1l);
	and(wire_nl0OOi_dataout, wire_nli11l_dataout, ~(n0lOiO));
	or(wire_nl0OOl_dataout, wire_nli11O_dataout, n0lOiO);
	and(wire_nl0OOO_dataout, wire_nli10i_dataout, ~(n0lOiO));
	assign		wire_nl1i_dataout = (n0Olli === 1'b1) ? niiO1i : wire_nl1O_dataout;
	assign		wire_nl1l_dataout = (n0Olli === 1'b1) ? niiO1l : wire_nl0i_dataout;
	assign		wire_nl1O_dataout = (n0Olll === 1'b1) ? nll0ii : wire_nl0l_dataout;
	and(wire_nl1Oii_dataout, wire_nliill_dataout, wire_nl1OiO_o[5]);
	and(wire_nl1Oil_dataout, n0llil, wire_nl1OiO_o[5]);
	and(wire_nl1Oli_dataout, wire_nli1Ol_dataout, wire_nl1OiO_o[6]);
	and(wire_nl1OlO_dataout, wire_nli1OO_dataout, wire_nl1OiO_o[6]);
	and(wire_nl1OOi_dataout, wire_nl0liO_dataout, wire_nl1OiO_o[7]);
	and(wire_nl1OOl_dataout, wire_nl0iOl_dataout, wire_nl1OiO_o[8]);
	and(wire_nl1OOO_dataout, wire_nl0iOO_dataout, wire_nl1OiO_o[8]);
	assign		wire_nli_dataout = (n0OlOl === 1'b1) ? rxd[39] : rxd[23];
	or(wire_nli00i_dataout, wire_nli0li_dataout, (~ n0ll1O));
	or(wire_nli00l_dataout, wire_nli0ll_dataout, (~ n0ll1O));
	or(wire_nli00O_dataout, wire_nli0lO_dataout, (~ n0ll1O));
	or(wire_nli01i_dataout, nll00O, (~ n0ll1O));
	or(wire_nli01l_dataout, nll0ii, (~ n0ll1O));
	or(wire_nli01O_dataout, wire_nli0iO_dataout, (~ n0ll1O));
	or(wire_nli0ii_dataout, (~ n0ll0i), ~(n0OlOi));
	and(wire_nli0il_dataout, n0ll0i, n0OlOi);
	assign		wire_nli0iO_dataout = (n0OlOi === 1'b1) ? n0ll0i : wire_nli0Oi_dataout;
	assign		wire_nli0li_dataout = (n0OlOi === 1'b1) ? (~ n0ll0i) : wire_nli0Ol_dataout;
	assign		wire_nli0ll_dataout = (n0OlOi === 1'b1) ? (~ n0ll0i) : wire_nli0OO_dataout;
	assign		wire_nli0lO_dataout = (n0OlOi === 1'b1) ? n0ll0i : wire_nlii1i_dataout;
	or(wire_nli0Oi_dataout, wire_nlii1l_dataout, n0llii);
	and(wire_nli0Ol_dataout, wire_nlii1O_dataout, ~(n0llii));
	and(wire_nli0OO_dataout, wire_nlii0i_dataout, ~(n0llii));
	and(wire_nli10i_dataout, wire_nli1il_dataout, ~(n0lO1l));
	or(wire_nli10l_dataout, wire_nli1iO_dataout, n0lO1l);
	and(wire_nli10O_dataout, wire_nli1li_dataout, ~(n0lO1i));
	or(wire_nli11i_dataout, wire_nli10l_dataout, n0lOiO);
	or(wire_nli11l_dataout, wire_nli10O_dataout, n0lO1l);
	or(wire_nli11O_dataout, wire_nli1ii_dataout, n0lO1l);
	and(wire_nli1ii_dataout, wire_nli1ll_dataout, ~(n0lO1i));
	or(wire_nli1il_dataout, wire_nli1lO_dataout, n0lO1i);
	or(wire_nli1iO_dataout, wire_nli1Oi_dataout, n0lO1i);
	or(wire_nli1li_dataout, nlll1i, n0lO0i);
	and(wire_nli1ll_dataout, nlll1l, ~(n0lO0i));
	or(wire_nli1lO_dataout, nlll1O, n0lO0i);
	or(wire_nli1Oi_dataout, nlll0i, n0lO0i);
	and(wire_nli1Ol_dataout, wire_nli0ii_dataout, ~((~ n0ll1O)));
	and(wire_nli1OO_dataout, wire_nli0il_dataout, ~((~ n0ll1O)));
	and(wire_nlii_dataout, wire_n1l_dataout, n0OlOi);
	or(wire_nlii0i_dataout, wire_nliiil_dataout, n0ll0l);
	and(wire_nlii0l_dataout, wire_nliiiO_dataout, ~(n0ll0l));
	or(wire_nlii0O_dataout, wire_nl0OOi_dataout, ~(n0ll0O));
	or(wire_nlii1i_dataout, wire_nlii0l_dataout, n0llii);
	or(wire_nlii1l_dataout, wire_nlii0O_dataout, n0ll0l);
	and(wire_nlii1O_dataout, wire_nliiii_dataout, ~(n0ll0l));
	or(wire_nliiii_dataout, wire_nl0OOl_dataout, ~(n0ll0O));
	or(wire_nliiil_dataout, wire_nl0OOO_dataout, ~(n0ll0O));
	and(wire_nliiiO_dataout, wire_nli11i_dataout, n0ll0O);
	and(wire_nliill_dataout, wire_nlil1i_dataout, ~((~ n0llil)));
	or(wire_nliilO_dataout, nll00O, (~ n0llil));
	or(wire_nliiOi_dataout, nll0ii, (~ n0llil));
	or(wire_nliiOl_dataout, wire_nlil1l_dataout, (~ n0llil));
	or(wire_nliiOO_dataout, wire_nlil1O_dataout, (~ n0llil));
	and(wire_nlil_dataout, wire_n1O_dataout, n0OlOi);
	assign		wire_nlil0i_dataout = (n0OlOi === 1'b1) ? wire_nlilli_dataout : wire_nlilii_dataout;
	assign		wire_nlil0l_dataout = (n0OlOi === 1'b1) ? wire_nlilll_dataout : wire_nlilil_dataout;
	assign		wire_nlil0O_dataout = (n0OlOi === 1'b1) ? wire_nlillO_dataout : wire_nliliO_dataout;
	assign		wire_nlil1i_dataout = (n0lOiO === 1'b1) ? wire_nlilOi_dataout : wire_nlil0i_dataout;
	assign		wire_nlil1l_dataout = (n0lOiO === 1'b1) ? wire_nlilOl_dataout : wire_nlil0l_dataout;
	assign		wire_nlil1O_dataout = (n0lOiO === 1'b1) ? wire_nlilOO_dataout : wire_nlil0O_dataout;
	and(wire_nlilii_dataout, n0lliO, ~(n0llll));
	and(wire_nlilil_dataout, (~ n0lliO), ~(n0llll));
	or(wire_nliliO_dataout, n0lliO, n0llll);
	and(wire_nlilli_dataout, n0llll, ~(n0llli));
	and(wire_nlilll_dataout, (~ n0llll), ~(n0llli));
	or(wire_nlillO_dataout, n0llll, n0llli);
	assign		wire_nlilOi_dataout = (n0OlOi === 1'b1) ? wire_nliO0i_dataout : wire_nliO1i_dataout;
	assign		wire_nlilOl_dataout = (n0OlOi === 1'b1) ? wire_nliO0l_dataout : wire_nliO1l_dataout;
	assign		wire_nlilOO_dataout = (n0OlOi === 1'b1) ? wire_nliO0O_dataout : wire_nliO1O_dataout;
	and(wire_nliO_dataout, wire_n0i_dataout, n0OlOi);
	and(wire_nliO0i_dataout, n0llOl, ~(n0llOi));
	and(wire_nliO0l_dataout, (~ n0llOl), ~(n0llOi));
	or(wire_nliO0O_dataout, n0llOl, n0llOi);
	and(wire_nliO1i_dataout, n0lllO, ~(n0llOl));
	and(wire_nliO1l_dataout, (~ n0lllO), ~(n0llOl));
	or(wire_nliO1O_dataout, n0lllO, n0llOl);
	or(wire_nliOii_dataout, nll00O, (~ n0llOO));
	or(wire_nliOil_dataout, nll0ii, (~ n0llOO));
	and(wire_nliOiO_dataout, wire_nliOOi_dataout, ~(n0lOiO));
	and(wire_nliOli_dataout, wire_nliOOl_dataout, ~(n0lOiO));
	or(wire_nliOll_dataout, wire_nliOOO_dataout, n0lOiO);
	and(wire_nliOlO_dataout, wire_nll11i_dataout, ~(n0lOiO));
	or(wire_nliOOi_dataout, nlll1i, n0lOii);
	and(wire_nliOOl_dataout, nlll1l, ~(n0lOii));
	or(wire_nliOOO_dataout, nlll1O, n0lOii);
	assign		wire_nll10i_dataout = (n0lOil === 1'b1) ? (~ n0OlOi) : wire_nll1il_dataout;
	assign		wire_nll10l_dataout = (n0lOil === 1'b1) ? n0OlOi : wire_nll1iO_dataout;
	and(wire_nll10O_dataout, wire_nll1li_dataout, ~(n0lOil));
	and(wire_nll11i_dataout, nlll0i, ~(n0lOii));
	and(wire_nll11O_dataout, wire_nll1ii_dataout, ~(n0lOil));
	assign		wire_nll1ii_dataout = (n0lO0l === 1'b1) ? n0OlOi : wire_nll1ll_dataout;
	assign		wire_nll1il_dataout = (n0lO0l === 1'b1) ? (~ n0OlOi) : wire_nll1lO_dataout;
	assign		wire_nll1iO_dataout = (n0lO0l === 1'b1) ? n0OlOi : wire_nll1Oi_dataout;
	and(wire_nll1li_dataout, wire_nll1Ol_dataout, ~(n0lO0l));
	or(wire_nll1ll_dataout, nlll1i, n0lO1O);
	assign		wire_nll1lO_dataout = (n0lO1O === 1'b1) ? (~ n0OlOi) : nlll1l;
	assign		wire_nll1Oi_dataout = (n0lO1O === 1'b1) ? n0OlOi : nlll1O;
	and(wire_nll1Ol_dataout, nlll0i, ~(n0lO1O));
	and(wire_nlli_dataout, wire_n0l_dataout, n0OlOi);
	and(wire_nlll_dataout, wire_n0O_dataout, n0OlOi);
	and(wire_nlll0l_dataout, wire_nl011O_o, ~(rbist_clr_rx));
	and(wire_nlll0O_dataout, wire_nl011l_o, ~(rbist_clr_rx));
	assign		wire_nlllii_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[0] : wire_nlllOi_dataout;
	assign		wire_nlllil_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[1] : wire_nlllOl_dataout;
	assign		wire_nllliO_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[2] : wire_nlllOO_dataout;
	assign		wire_nlllli_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[3] : wire_nllO1i_dataout;
	assign		wire_nlllll_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[4] : wire_nllO1l_dataout;
	assign		wire_nllllO_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[5] : wire_nllO1O_dataout;
	and(wire_nlllOi_dataout, nll0iO, ~(wire_nl1OOO_dataout));
	and(wire_nlllOl_dataout, nll0li, ~(wire_nl1OOO_dataout));
	and(wire_nlllOO_dataout, nll0ll, ~(wire_nl1OOO_dataout));
	and(wire_nllO_dataout, wire_nii_dataout, n0OlOi);
	assign		wire_nllO0l_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[0] : nll0OO;
	assign		wire_nllO0O_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[1] : nlli1i;
	and(wire_nllO1i_dataout, nll0lO, ~(wire_nl1OOO_dataout));
	and(wire_nllO1l_dataout, nll0Oi, ~(wire_nl1OOO_dataout));
	and(wire_nllO1O_dataout, nll0Ol, ~(wire_nl1OOO_dataout));
	assign		wire_nllOii_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[2] : nlli1l;
	and(wire_nllOiO_dataout, wire_nllOOi_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOli_dataout, wire_nllOOl_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOll_dataout, wire_nllOOO_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOlO_dataout, wire_nlO11i_dataout, ~(wire_nl1OlO_dataout));
	assign		wire_nllOOi_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[0] : nlli1O;
	assign		wire_nllOOl_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[1] : nlli0i;
	assign		wire_nllOOO_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[2] : nlli0l;
	assign		wire_nlO00i_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[7] : nlliOl;
	assign		wire_nlO00l_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[8] : nlliOO;
	assign		wire_nlO01i_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[4] : nllill;
	assign		wire_nlO01l_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[5] : nllilO;
	assign		wire_nlO01O_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[6] : nlliOi;
	and(wire_nlO10i_dataout, wire_nlO1Oi_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO10l_dataout, wire_nlO1Ol_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO10O_dataout, wire_nlO1OO_dataout, ~(wire_nl1Oii_dataout));
	assign		wire_nlO11i_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[3] : nlli0O;
	and(wire_nlO11O_dataout, wire_nlO1lO_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1ii_dataout, wire_nlO01i_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1il_dataout, wire_nlO01l_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1iO_dataout, wire_nlO01O_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1li_dataout, wire_nlO00i_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1ll_dataout, wire_nlO00l_dataout, ~(wire_nl1Oii_dataout));
	assign		wire_nlO1lO_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[0] : nlliii;
	assign		wire_nlO1Oi_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[1] : nlliil;
	assign		wire_nlO1Ol_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[2] : nlliiO;
	assign		wire_nlO1OO_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[3] : nllili;
	and(wire_nlOi_dataout, wire_nil_dataout, n0OlOi);
	and(wire_nlOl_dataout, wire_niO_dataout, n0OlOi);
	and(wire_nlOO_dataout, wire_nli_dataout, n0OlOi);
	and(wire_nO_dataout, rbisten_rx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (n0OO0i2 ^ n0OO0i1)));
	oper_add   niiOl
	( 
	.a({ni0li, ni0iO, ni0il, ni0ii, ni00O}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niiOl_o));
	defparam
		niiOl.sgate_representation = 0,
		niiOl.width_a = 5,
		niiOl.width_b = 5,
		niiOl.width_o = 5;
	oper_add   niO0Ol
	( 
	.a({nil10i, nil11O, nil11l, nil11i, niiOOO, niiOOl, niiOOi}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO0Ol_o));
	defparam
		niO0Ol.sgate_representation = 0,
		niO0Ol.width_a = 7,
		niO0Ol.width_b = 7,
		niO0Ol.width_o = 7;
	oper_add   niO0OO
	( 
	.a({niiOll, niiOli, niiOiO, niiOil, niiOii, niiO0O, niiO0l}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO0OO_o));
	defparam
		niO0OO.sgate_representation = 0,
		niO0OO.width_a = 7,
		niO0OO.width_b = 7,
		niO0OO.width_o = 7;
	oper_add   niOi1i
	( 
	.a({nil1Oi, nil1lO, nil1ll, nil1li, nil1iO, nil1il, nil1ii, nil10O, nil10l}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niOi1i_o));
	defparam
		niOi1i.sgate_representation = 0,
		niOi1i.width_a = 9,
		niOi1i.width_b = 9,
		niOi1i.width_o = 9;
	oper_add   nllO0i
	( 
	.a({nll0Ol, nll0Oi, nll0lO, nll0ll, nll0li, nll0iO}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllO0i_o));
	defparam
		nllO0i.sgate_representation = 0,
		nllO0i.width_a = 6,
		nllO0i.width_b = 6,
		nllO0i.width_o = 6;
	oper_add   nllOil
	( 
	.a({nlli1l, nlli1i, nll0OO}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllOil_o));
	defparam
		nllOil.sgate_representation = 0,
		nllOil.width_a = 3,
		nllOil.width_b = 3,
		nllOil.width_o = 3;
	oper_add   nlO00O
	( 
	.a({nlliOO, nlliOl, nlliOi, nllilO, nllill, nllili, nlliiO, nlliil, nlliii}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO00O_o));
	defparam
		nlO00O.sgate_representation = 0,
		nlO00O.width_a = 9,
		nlO00O.width_b = 9,
		nlO00O.width_o = 9;
	oper_add   nlO11l
	( 
	.a({nlli0O, nlli0l, nlli0i, nlli1O}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO11l_o));
	defparam
		nlO11l.sgate_representation = 0,
		nlO11l.width_a = 4,
		nlO11l.width_b = 4,
		nlO11l.width_o = 4;
	oper_decoder   n11li
	( 
	.i({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}),
	.o(wire_n11li_o));
	defparam
		n11li.width_i = 5,
		n11li.width_o = 32;
	oper_decoder   ni1iii
	( 
	.i({nil00O, nil00l, nil00i, nil01O}),
	.o(wire_ni1iii_o));
	defparam
		ni1iii.width_i = 4,
		ni1iii.width_o = 16;
	oper_decoder   nii0Ol
	( 
	.i({nil01l, nil01i, nil1OO, nil1Ol}),
	.o(wire_nii0Ol_o));
	defparam
		nii0Ol.width_i = 4,
		nii0Ol.width_o = 16;
	oper_decoder   nl1OiO
	( 
	.i({nlll0i, nlll1O, nlll1l, nlll1i}),
	.o(wire_nl1OiO_o));
	defparam
		nl1OiO.width_i = 4,
		nl1OiO.width_o = 16;
	oper_mux   n100i
	( 
	.data({{10{1'b0}}, wire_n10ll_dataout, {5{1'b0}}, wire_n1O0l_dataout, wire_n00iO_dataout, n0O00l, n0O00O, ((n0O11l38 ^ n0O11l37) & n0O0ii), n0O0il, n0O0iO, n0O0li, n0O0ll, wire_n0lOi_dataout, {3{1'b0}}, wire_n0Oil_dataout, wire_n0OOi_dataout, 1'b0}),
	.o(wire_n100i_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n100i.width_data = 32,
		n100i.width_sel = 5;
	oper_mux   n100l
	( 
	.data({{10{1'b0}}, wire_n10lO_dataout, ((n0O11O36 ^ n0O11O35) & wire_n1i1i_dataout), wire_n1iii_dataout, wire_n1ill_dataout, ((n0O10i34 ^ n0O10i33) & wire_n1iOO_dataout), wire_n1l0l_dataout, wire_n1O0O_dataout, wire_n00li_dataout, (~ n0O00l), (~ n0O00O), (~ n0O0ii), ((n0O10l32 ^ n0O10l31) & (~ n0O0il)), ((n0O10O30 ^ n0O10O29) & (~ n0O0iO)), (~ n0O0li), (~ n0O0ll), (~ n0O0lO), (~ n0O0Oi), (~ n0O0Ol), 1'b0, wire_n0OiO_dataout, wire_n0OOl_dataout, 1'b0}),
	.o(wire_n100l_o),
	.sel({((n0O1ii28 ^ n0O1ii27) & nii1i), ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n100l.width_data = 32,
		n100l.width_sel = 5;
	oper_mux   n101i
	( 
	.data({{10{1'b0}}, wire_n10il_dataout, {4{1'b1}}, wire_n1l0i_dataout, wire_n1O1l_dataout, wire_n000O_dataout, (~ n0O00l), wire_n0iii_dataout, (~ n0O0ii), wire_n0iOi_dataout, (~ n0O0iO), wire_n0l0l_dataout, (~ n0O0ll), wire_n0llO_dataout, (~ n0O0Oi), wire_n0O1O_dataout, 1'b0, wire_n0O0l_dataout, wire_n0Oli_dataout, (wire_ni_dataout & n11Oi)}),
	.o(wire_n101i_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n101i.width_data = 32,
		n101i.width_sel = 5;
	oper_mux   n101l
	( 
	.data({{10{1'b0}}, wire_n10iO_dataout, {5{1'b0}}, wire_n1O1O_dataout, wire_n00ii_dataout, n0O00l, wire_n0iil_dataout, 1'b0, wire_n0iOl_dataout, n0O0iO, wire_n0l0O_dataout, 1'b0, wire_n0lll_dataout, n0O0Oi, wire_n0O0i_dataout, 1'b0, wire_n0O0O_dataout, wire_n0Oll_dataout, 1'b0}),
	.o(wire_n101l_o),
	.sel({nii1i, ni0Ol, ni0Oi, ((n0lOOi46 ^ n0lOOi45) & ni0lO), ni0ll}));
	defparam
		n101l.width_data = 32,
		n101l.width_sel = 5;
	oper_mux   n101O
	( 
	.data({{10{1'b0}}, ((n0lOOl44 ^ n0lOOl43) & wire_n10li_dataout), wire_n1i1i_dataout, wire_n1iii_dataout, ((n0lOOO42 ^ n0lOOO41) & wire_n1ill_dataout), wire_n1iOO_dataout, wire_n1l0l_dataout, wire_n1O0i_dataout, ((n0O11i40 ^ n0O11i39) & wire_n00il_dataout), {3{1'b1}}, wire_n0iOO_dataout, (~ n0O0iO), (~ n0O0li), (~ n0O0ll), wire_n0llO_dataout, {3{1'b1}}, wire_n0Oii_dataout, wire_n0OlO_dataout, 1'b0}),
	.o(wire_n101O_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n101O.width_data = 32,
		n101O.width_sel = 5;
	oper_mux   n11Ol
	( 
	.data({{10{ni00i}}, wire_n100O_dataout, wire_n10OO_dataout, wire_n1i0O_dataout, wire_n1ili_dataout, wire_n1iOl_dataout, wire_n1l1O_dataout, wire_n1O1i_dataout, wire_n000l_dataout, wire_n0i0i_dataout, wire_n0i0O_dataout, wire_n0ili_dataout, wire_n0ilO_dataout, wire_n0l1l_dataout, wire_n0l0i_dataout, wire_n0lil_dataout, wire_n0lli_dataout, wire_n0lOO_dataout, wire_n0O1l_dataout, {4{ni00i}}}),
	.o(wire_n11Ol_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n11Ol.width_data = 32,
		n11Ol.width_sel = 5;
	oper_mux   n11OO
	( 
	.data({{10{ni01l}}, wire_n10ii_dataout, wire_n10Ol_dataout, wire_n1i0l_dataout, wire_n1iiO_dataout, wire_n1iOi_dataout, wire_n1l1l_dataout, wire_n1lOO_dataout, wire_n000i_dataout, wire_n0i1O_dataout, wire_n0i0l_dataout, wire_n0iiO_dataout, wire_n0ill_dataout, wire_n0l1i_dataout, wire_n0l1O_dataout, wire_n0lii_dataout, wire_n0liO_dataout, wire_n0lOl_dataout, wire_n0O1i_dataout, {4{ni01l}}}),
	.o(wire_n11OO_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n11OO.width_data = 32,
		n11OO.width_sel = 5;
	oper_mux   ni1iil
	( 
	.data({{3{1'b0}}, n0iO1l, wire_ni1O1i_dataout, n0iOil, wire_ni010O_dataout, n0iOOl, wire_ni000i_dataout, 1'b0, wire_ni0i1O_dataout, n0l1ll, wire_ni0l1i_dataout, n0l0ii, n0l0Ol, 1'b0}),
	.o(wire_ni1iil_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iil.width_data = 16,
		ni1iil.width_sel = 4;
	oper_mux   ni1iiO
	( 
	.data({{2{niilOO}}, wire_ni1l1i_dataout, wire_ni1lil_dataout, wire_ni1lOO_dataout, {11{niilOO}}}),
	.o(wire_ni1iiO_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iiO.width_data = 16,
		ni1iiO.width_sel = 4;
	oper_mux   ni1ili
	( 
	.data({{2{niiO1i}}, wire_ni1l1l_dataout, wire_ni1liO_dataout, wire_ni1O1l_dataout, wire_ni1OOl_dataout, wire_ni011l_dataout, wire_ni01Oi_dataout, wire_ni001i_dataout, wire_ni00ll_dataout, wire_ni00Ol_dataout, wire_ni0ili_dataout, wire_ni0iOi_dataout, wire_ni0lil_dataout, wire_ni0Oli_dataout, niiO1i}),
	.o(wire_ni1ili_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1ili.width_data = 16,
		ni1ili.width_sel = 4;
	oper_mux   ni1ill
	( 
	.data({{2{niiO1l}}, wire_ni1l1O_dataout, wire_ni1lli_dataout, wire_ni1O1O_dataout, wire_ni1OOO_dataout, wire_ni011O_dataout, wire_ni01Ol_dataout, wire_ni001l_dataout, wire_ni00lO_dataout, wire_ni00OO_dataout, wire_ni0ill_dataout, wire_ni0iOl_dataout, wire_ni0liO_dataout, wire_ni0Oll_dataout, niiO1l}),
	.o(wire_ni1ill_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1ill.width_data = 16,
		ni1ill.width_sel = 4;
	oper_mux   ni1ilO
	( 
	.data({{2{1'b0}}, wire_ni1l0i_dataout, 1'b1, wire_ni1O0i_dataout, 1'b1, wire_ni010i_dataout, 1'b1, wire_ni001O_dataout, 1'b1, wire_ni0i1i_dataout, 1'b1, wire_ni0iOO_dataout, wire_ni0lli_dataout, wire_ni0OlO_dataout, wire_nii00i_dataout}),
	.o(wire_ni1ilO_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1ilO.width_data = 16,
		ni1ilO.width_sel = 4;
	oper_mux   ni1iOi
	( 
	.data({{2{1'b0}}, wire_ni1l0l_dataout, {2{1'b0}}, (~ n0iOil), wire_ni010l_dataout, {2{1'b0}}, (~ n0l10l), wire_ni0i1l_dataout, {2{1'b0}}, wire_ni0lll_dataout, wire_ni0OOi_dataout, wire_nii00l_dataout}),
	.o(wire_ni1iOi_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iOi.width_data = 16,
		ni1iOi.width_sel = 4;
	oper_mux   ni1iOl
	( 
	.data({{2{1'b0}}, wire_ni1l0O_dataout, wire_ni1lll_dataout, wire_ni1O0l_dataout, n0iOil, wire_ni010O_dataout, n0iOOl, wire_ni000i_dataout, {4{1'b1}}, wire_ni0llO_dataout, wire_ni0OOl_dataout, wire_nii00O_dataout}),
	.o(wire_ni1iOl_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iOl.width_data = 16,
		ni1iOl.width_sel = 4;
	oper_mux   ni1iOO
	( 
	.data({{2{1'b0}}, wire_ni1lii_dataout, wire_ni1lll_dataout, wire_ni1O0l_dataout, {4{1'b1}}, n0l10l, wire_ni0i1O_dataout, n0l1ll, wire_ni0l1i_dataout, wire_ni0lOi_dataout, wire_ni0OOO_dataout, wire_nii0ii_dataout}),
	.o(wire_ni1iOO_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iOO.width_data = 16,
		ni1iOO.width_sel = 4;
	oper_mux   nii0iO
	( 
	.data({{4{1'b1}}, 1'b0, 1'b1, {7{1'b0}}, wire_niOi1l_dataout, {2{1'b1}}}),
	.o(wire_nii0iO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0iO.width_data = 16,
		nii0iO.width_sel = 4;
	oper_mux   nii0li
	( 
	.data({{3{1'b1}}, 1'b0, {2{1'b1}}, {7{1'b0}}, wire_niOi1O_dataout, {2{1'b1}}}),
	.o(wire_nii0li_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0li.width_data = 16,
		nii0li.width_sel = 4;
	oper_mux   nii0lO
	( 
	.data({{5{1'b1}}, 1'b0, {7{1'b1}}, wire_niOi0l_dataout, {2{1'b1}}}),
	.o(wire_nii0lO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0lO.width_data = 16,
		nii0lO.width_sel = 4;
	oper_mux   nii0OO
	( 
	.data({{7{1'b1}}, {2{1'b0}}, 1'b1, 1'b0, 1'b1, 1'b0, wire_niOiii_dataout, {2{1'b1}}}),
	.o(wire_nii0OO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0OO.width_data = 16,
		nii0OO.width_sel = 4;
	oper_mux   niii0i
	( 
	.data({{3{n0OlOi}}, {3{1'b0}}, n0OlOi, {6{1'b0}}, wire_niOill_dataout, {2{n0OlOi}}}),
	.o(wire_niii0i_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii0i.width_data = 16,
		niii0i.width_sel = 4;
	oper_mux   niii0l
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, wire_niOilO_dataout, {2{n0OlOi}}}),
	.o(wire_niii0l_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii0l.width_data = 16,
		niii0l.width_sel = 4;
	oper_mux   niii0O
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, {3{1'b0}}, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, wire_niOiOi_dataout, {2{n0OlOi}}}),
	.o(wire_niii0O_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii0O.width_data = 16,
		niii0O.width_sel = 4;
	oper_mux   niii1i
	( 
	.data({{8{1'b1}}, 1'b0, {2{1'b1}}, {2{1'b0}}, wire_niOiil_dataout, {2{1'b1}}}),
	.o(wire_niii1i_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii1i.width_data = 16,
		niii1i.width_sel = 4;
	oper_mux   niii1l
	( 
	.data({{9{1'b1}}, {4{1'b0}}, wire_niOiiO_dataout, {2{1'b1}}}),
	.o(wire_niii1l_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii1l.width_data = 16,
		niii1l.width_sel = 4;
	oper_mux   niii1O
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, {6{1'b0}}, wire_niOili_dataout, {2{n0OlOi}}}),
	.o(wire_niii1O_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii1O.width_data = 16,
		niii1O.width_sel = 4;
	oper_mux   niiiii
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, wire_niOiOl_dataout, {2{n0OlOi}}}),
	.o(wire_niiiii_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiiii.width_data = 16,
		niiiii.width_sel = 4;
	oper_mux   niiiil
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, {3{1'b0}}, n0OlOi, 1'b0, n0OlOi, wire_niOiOO_dataout, {2{n0OlOi}}}),
	.o(wire_niiiil_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiiil.width_data = 16,
		niiiil.width_sel = 4;
	oper_mux   niiiiO
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, {2{1'b0}}, wire_niOl1i_dataout, {2{n0OlOi}}}),
	.o(wire_niiiiO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiiiO.width_data = 16,
		niiiiO.width_sel = 4;
	oper_mux   niiili
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, {4{1'b0}}, wire_niOl1l_dataout, {2{n0OlOi}}}),
	.o(wire_niiili_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiili.width_data = 16,
		niiili.width_sel = 4;
	oper_mux   niiill
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, {2{n0OlOi}}}),
	.o(wire_niiill_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiill.width_data = 16,
		niiill.width_sel = 4;
	oper_mux   nl010i
	( 
	.data({wire_nl01li_dataout, {4{1'b1}}, wire_nl0i0l_dataout, (~ n0liOl), wire_nl0l1O_dataout, wire_nl0llO_dataout, wire_nli01O_dataout, wire_nliiOl_dataout, {2{1'b1}}, wire_nliOiO_dataout, wire_nll11O_dataout, (wire_nl_dataout & nl1Oll)}),
	.o(wire_nl010i_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010i.width_data = 16,
		nl010i.width_sel = 4;
	oper_mux   nl010l
	( 
	.data({wire_nl01ll_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, (~ n0liOl), wire_nl0l1O_dataout, wire_nl0lOi_dataout, wire_nli00i_dataout, wire_nliiOO_dataout, (~ n0llOO), 1'b0, wire_nliOli_dataout, wire_nll10i_dataout, 1'b0}),
	.o(wire_nl010l_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010l.width_data = 16,
		nl010l.width_sel = 4;
	oper_mux   nl010O
	( 
	.data({wire_nl01lO_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, (~ n0liOl), wire_nl0l1O_dataout, wire_nl0lOl_dataout, wire_nli00l_dataout, {3{1'b1}}, wire_nliOll_dataout, wire_nll10l_dataout, 1'b0}),
	.o(wire_nl010O_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010O.width_data = 16,
		nl010O.width_sel = 4;
	oper_mux   nl011i
	( 
	.data({nll0il, wire_nl01Ol_dataout, wire_nl000l_dataout, wire_nl00iO_dataout, wire_nl00Oi_dataout, wire_nl0i1l_dataout, {10{nll0il}}}),
	.o(wire_nl011i_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011i.width_data = 16,
		nl011i.width_sel = 4;
	oper_mux   nl011l
	( 
	.data({wire_nl01il_dataout, wire_nl001i_dataout, wire_nl00ii_dataout, wire_nl00ll_dataout, wire_nl00OO_dataout, wire_nl0i0i_dataout, wire_nl0lil_dataout, wire_nl0l1l_dataout, wire_nl0lll_dataout, wire_nli01l_dataout, wire_nliiOi_dataout, wire_nliOil_dataout, {4{nll0ii}}}),
	.o(wire_nl011l_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011l.width_data = 16,
		nl011l.width_sel = 4;
	oper_mux   nl011O
	( 
	.data({wire_nl01iO_dataout, wire_nl01OO_dataout, wire_nl000O_dataout, wire_nl00li_dataout, wire_nl00Ol_dataout, wire_nl0i1O_dataout, wire_nl0lii_dataout, wire_nl0l1i_dataout, wire_nl0lli_dataout, wire_nli01i_dataout, wire_nliilO_dataout, wire_nliOii_dataout, {4{nll00O}}}),
	.o(wire_nl011O_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011O.width_data = 16,
		nl011O.width_sel = 4;
	oper_mux   nl01ii
	( 
	.data({wire_nl01Oi_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, 1'b1, wire_nl0l0i_dataout, wire_nl0lOO_dataout, wire_nli00O_dataout, (~ n0llil), (~ n0llOO), 1'b0, wire_nliOlO_dataout, wire_nll10O_dataout, 1'b0}),
	.o(wire_nl01ii_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl01ii.width_data = 16,
		nl01ii.width_sel = 4;
	oper_selector   n11ii
	( 
	.data({1'b0, wire_n1lOi_dataout, wire_n001l_dataout}),
	.o(wire_n11ii_o),
	.sel({n0lOll, wire_n11li_o[15:14]}));
	defparam
		n11ii.width_data = 3,
		n11ii.width_sel = 3;
	oper_selector   n11il
	( 
	.data({1'b0, wire_n1lOl_dataout, wire_n001O_dataout}),
	.o(wire_n11il_o),
	.sel({n0lOll, wire_n11li_o[15:14]}));
	defparam
		n11il.width_data = 3,
		n11il.width_sel = 3;
	oper_selector   n11ll
	( 
	.data({ni00l, wire_n10Oi_dataout, wire_n1i0i_dataout, wire_n1iil_dataout, wire_n1ilO_dataout, wire_n1l1i_dataout}),
	.o(wire_n11ll_o),
	.sel({n0lOlO, wire_n11li_o[20:16]}));
	defparam
		n11ll.width_data = 6,
		n11ll.width_sel = 6;
	oper_selector   ni1i0l
	( 
	.data({1'b0, 1'b1, wire_ni0OiO_dataout}),
	.o(wire_ni1i0l_o),
	.sel({n0iO1i, wire_ni1iii_o[2:1]}));
	defparam
		ni1i0l.width_data = 3,
		ni1i0l.width_sel = 3;
	assign
		bistdone = ((wire_nl1l_dataout | prbs_done) | (~ (n0Ol0O10 ^ n0Ol0O9))),
		bisterr = ((wire_nl1i_dataout | prbs_err) | (~ (n0Olil8 ^ n0Olil7))),
		cur_state = {wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout},
		err_ctl = {wire_niOO_dataout, wire_niOl_dataout},
		err_data = {wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout},
		n0iO0i = ((~ n0iO0l) | (~ n0l1Ol)),
		n0iO0l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iO0O = ((~ n0iOii) | (~ n0l01l)),
		n0iO1i = (((((((((((((wire_ni1iii_o[15] | wire_ni1iii_o[14]) | wire_ni1iii_o[13]) | wire_ni1iii_o[12]) | wire_ni1iii_o[11]) | wire_ni1iii_o[10]) | wire_ni1iii_o[9]) | wire_ni1iii_o[8]) | wire_ni1iii_o[7]) | wire_ni1iii_o[6]) | wire_ni1iii_o[5]) | wire_ni1iii_o[4]) | wire_ni1iii_o[3]) | wire_ni1iii_o[0]),
		n0iO1l = ((~ n0iO1O) | (~ n0l1Ol)),
		n0iO1O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOii = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & wire_nlil_dataout) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOil = ((~ n0iOiO) | (~ n0l1Ol)),
		n0iOiO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOli = ((~ n0iOll) | (~ n0l1Ol)),
		n0iOll = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOlO = ((~ n0iOOi) | (~ n0l01l)),
		n0iOOi = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & (~ wire_nlll_dataout)) & wire_nlli_dataout) & wire_nliO_dataout) & wire_nlil_dataout) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOOl = ((~ n0iOOO) | (~ n0l1Ol)),
		n0iOOO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & rxd[7]),
		n0l00i = (((((((nil1lO & nil1ll) & nil1li) & nil1iO) & nil1il) & nil1ii) & nil10O) & nil10l),
		n0l00l = (n0OlOi & n0l00O),
		n0l00O = (((((((niiOll & niiOli) & niiOiO) & niiOil) & niiOii) & niiO0O) & niiO0l) & niiO0i),
		n0l01i = ((~ n0l01O) | (~ n0l01l)),
		n0l01l = (wire_nlii_dataout & rxc[0]),
		n0l01O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0l0ii = ((~ n0l0il) | (~ ((~ wire_nlii_dataout) & (~ rxc[0])))),
		n0l0il = ((((((((((((((((~ (rxd[0] ^ wire_niOi1l_dataout)) & (~ (rxd[1] ^ wire_niOi1O_dataout))) & (~ (rxd[2] ^ wire_niOi0i_dataout))) & (~ (rxd[3] ^ wire_niOi0l_dataout))) & (~ (rxd[4] ^ wire_niOi0O_dataout))) & (~ (rxd[5] ^ wire_niOiii_dataout))) & (~ (rxd[6] ^ wire_niOiil_dataout))) & (~ (rxd[7] ^ wire_niOiiO_dataout))) & (~ (wire_nlil_dataout ^ wire_niOili_dataout))) & (~ (wire_nliO_dataout ^ wire_niOill_dataout))) & (~ (wire_nlli_dataout ^ wire_niOilO_dataout))) & (~ (wire_nlll_dataout ^ wire_niOiOi_dataout))) & (~ (wire_nllO_dataout ^ wire_niOiOl_dataout))) & (~ (wire_nlOi_dataout ^ wire_niOiOO_dataout))) & (~ (wire_nlOl_dataout ^ wire_niOl1i_dataout))) & (~ (wire_nlOO_dataout ^ wire_niOl1l_dataout))),
		n0l0iO = ((~ n0OlOi) & (rxc[0] & n0l0li)),
		n0l0li = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0l0ll = (n0OlOi & ((wire_nlii_dataout & n0l0Oi) & (rxc[0] & n0l0lO))),
		n0l0lO = ((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]),
		n0l0Oi = (((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & (~ wire_nlli_dataout)) & wire_nliO_dataout) & wire_nlil_dataout),
		n0l0Ol = (((~ n0OlOi) & n0li1i) | (n0OlOi & n0l0OO)),
		n0l0OO = ((((((((nil1Oi & (~ nil1lO)) & (~ nil1ll)) & (~ nil1li)) & (~ nil1iO)) & (~ nil1il)) & (~ nil1ii)) & (~ nil10O)) & (~ nil10l)),
		n0l10i = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & (~ wire_nlOi_dataout)) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0l10l = ((~ n0l10O) | (~ n0l1Ol)),
		n0l10O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])),
		n0l11i = ((~ n0l11l) | (~ n0l1Ol)),
		n0l11l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0l11O = ((~ n0l10i) | (~ n0l01l)),
		n0l1ii = ((~ n0l1il) | (~ n0l1Ol)),
		n0l1il = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0l1iO = ((~ n0l1li) | (~ n0l01l)),
		n0l1li = ((((((((((((((((~ wire_nlOO_dataout) & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0l1ll = ((~ n0l1lO) | (~ n0l1Ol)),
		n0l1lO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])),
		n0l1Oi = ((~ n0l1OO) | (~ n0l1Ol)),
		n0l1Ol = ((~ wire_nlii_dataout) & rxc[0]),
		n0l1OO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0li0i = ((~ rxc[0]) | (~ n0li0l)),
		n0li0l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0li0O = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0li1i = ((((((((nil1Oi & (~ nil1lO)) & (~ nil1ll)) & nil1li) & (~ nil1iO)) & (~ nil1il)) & (~ nil1ii)) & (~ nil10O)) & nil10l),
		n0li1l = (wire_nO_dataout & rxd[10]),
		n0liii = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0liil = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0liiO = ((~ n0lili) | (~ (wire_nlii_dataout & (~ rxc[0])))),
		n0lili = ((((((((((((((((~ wire_nliO_dataout) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0lill = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nlll_dataout)) & (~ wire_nliO_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0lilO = ((((((~ nll0Ol) & nll0Oi) & (~ nll0lO)) & (~ nll0ll)) & nll0li) & nll0iO),
		n0liOi = (((((nll0Ol & (~ nll0Oi)) & (~ nll0lO)) & nll0ll) & nll0li) & nll0iO),
		n0liOl = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nllO_dataout)) & (~ wire_nlli_dataout)) & rxd[5]) & rxd[7]) & (~ ((~ n0OlOi) ^ rxd[0]))) & (~ ((~ n0OlOi) ^ rxd[1]))) & (~ (n0OlOi ^ rxd[2]))) & (~ ((~ n0OlOi) ^ rxd[3]))) & (~ (n0OlOi ^ rxd[4]))) & (~ (n0OlOi ^ rxd[6]))) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0liOO = ((((((((((((((((~ wire_nlll_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0ll0i = ((((~ nlli0O) & (~ nlli0l)) & nlli0i) & (~ nlli1O)),
		n0ll0l = ((((~ nlli0O) & nlli0l) & nlli0i) & nlli1O),
		n0ll0O = (((nlli0O & nlli0l) & nlli0i) & nlli1O),
		n0ll1i = (((~ nlli1l) & nlli1i) & nll0OO),
		n0ll1l = ((nlli1l & nlli1i) & nll0OO),
		n0ll1O = ((((((((((((((((~ wire_nllO_dataout) & (~ wire_nlli_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0llii = (((((~ nlli0O) & (~ nlli0l)) & nlli0i) & nlli1O) | (((nlli0O & (~ nlli0l)) & nlli0i) & nlli1O)),
		n0llil = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))),
		n0lliO = ((((((((nlliOO & (~ nlliOl)) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & nlliiO) & nlliil) & nlliii),
		n0llli = (((((((((~ nlliOO) & (~ nlliOl)) & nlliOi) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & (~ nlliil)) & nlliii),
		n0llll = (((((((((~ nlliOO) & nlliOl) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & nlliil) & nlliii),
		n0lllO = ((((((((nlliOO & (~ nlliOl)) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & nlliiO) & nlliil) & (~ nlliii)),
		n0llOi = (((((((((~ nlliOO) & (~ nlliOl)) & nlliOi) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & (~ nlliil)) & (~ nlliii)),
		n0llOl = (((((((((~ nlliOO) & nlliOl) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & nlliil) & (~ nlliii)),
		n0llOO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))),
		n0lO0i = (rcxpat_chnl_sel[0] & rcxpat_chnl_sel[1]),
		n0lO0l = (n0lOii & n0lO0O),
		n0lO0O = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0lO1i = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		n0lO1l = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		n0lO1O = (n0lO0O & n0lO0i),
		n0lOii = (n0lO1l | n0lO1i),
		n0lOil = (rxc[0] & (n0lOli & n0lOiO)),
		n0lOiO = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		n0lOli = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0lOll = (((((((((((((((((((((((((((((wire_n11li_o[31] | wire_n11li_o[30]) | wire_n11li_o[29]) | wire_n11li_o[28]) | wire_n11li_o[27]) | wire_n11li_o[26]) | wire_n11li_o[25]) | wire_n11li_o[24]) | wire_n11li_o[23]) | wire_n11li_o[22]) | wire_n11li_o[21]) | wire_n11li_o[20]) | wire_n11li_o[19]) | wire_n11li_o[18]) | wire_n11li_o[17]) | wire_n11li_o[16]) | wire_n11li_o[13]) | wire_n11li_o[12]) | wire_n11li_o[11]) | wire_n11li_o[10]) | wire_n11li_o[9]) | wire_n11li_o[8]) | wire_n11li_o[7]) | wire_n11li_o[6]) | wire_n11li_o[5]) | wire_n11li_o[4]) | wire_n11li_o[3]) | wire_n11li_o[2]) | wire_n11li_o[1]) | wire_n11li_o[0]),
		n0lOlO = ((((((((((((((((((((((((((wire_n11li_o[31] | wire_n11li_o[30]) | wire_n11li_o[29]) | wire_n11li_o[28]) | wire_n11li_o[27]) | wire_n11li_o[26]) | wire_n11li_o[25]) | wire_n11li_o[24]) | wire_n11li_o[23]) | wire_n11li_o[22]) | wire_n11li_o[21]) | wire_n11li_o[15]) | wire_n11li_o[14]) | wire_n11li_o[13]) | wire_n11li_o[12]) | wire_n11li_o[11]) | wire_n11li_o[10]) | wire_n11li_o[9]) | wire_n11li_o[8]) | wire_n11li_o[7]) | wire_n11li_o[6]) | wire_n11li_o[5]) | wire_n11li_o[4]) | wire_n11li_o[3]) | wire_n11li_o[2]) | wire_n11li_o[1]) | wire_n11li_o[0]),
		n0O00i = ((((ni0li & ni0iO) & ni0il) & ni0ii) & (~ ni00O)),
		n0O00l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0O00O = ((((((((((((((((~ wire_nlli_dataout) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0O01i = ((((((((((((((((~ wire_nliO_dataout) & (~ rxd[0])) & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0O01l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0O01O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))),
		n0O0ii = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0O0il = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))),
		n0O0iO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0O0li = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0O0ll = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & (~ rxd[3])) & (~ rxd[4])) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0O0lO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & (~ rxd[3])) & (~ rxd[4])) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))),
		n0O0Oi = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & rxd[7]),
		n0O0Ol = ((((((((((((((((~ wire_nlOi_dataout) & (~ wire_nlll_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0O0OO = (n0Oi0l & n0Oi1i),
		n0O1il = ((~ rxc[0]) | (~ n0O1iO)),
		n0O1iO = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0O1li = (((((((rxd[0] & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0O1ll = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0O1lO = (((((((rxd[0] & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])),
		n0O1Oi = (((~ n0O01i) | (~ (wire_nlii_dataout & (~ rxc[0])))) | (~ (n0O1Ol26 ^ n0O1Ol25))),
		n0Oi0l = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0Oi1i = (rcxpat_chnl_sel[0] & rcxpat_chnl_sel[1]),
		n0Oi1l = ((((n0OiiO | n0Oiil) | (~ (n0Oi0O22 ^ n0Oi0O21))) & n0Oi0l) & (n0Oi1O24 ^ n0Oi1O23)),
		n0Oiil = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		n0OiiO = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		n0Oili = (rxc[0] & (n0OilO & n0Oill)),
		n0Oill = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		n0OilO = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0OiOl = 1'b1,
		n0Olli = (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (n0Ol0i12 ^ n0Ol0i11)),
		n0Olll = (rbist_sel[0] & (~ rbist_sel[1])),
		n0OllO = (((~ rbist_sel[0]) & rbist_sel[1]) & (n0Ol1l14 ^ n0Ol1l13)),
		n0OlOi = (n0OlOl | (rpmadwidth_rx & rpma_doublewidth_rx)),
		n0OlOl = (((rpmadwidth_rx & (~ rpma_doublewidth_rx)) & rdwidth_rx) & (n0OlOO6 ^ n0OlOO5)),
		selftest_done = wire_nl1l_dataout,
		selftest_err = wire_nl1i_dataout;
endmodule //cycloneiv_hssi_rx_digi_bist_ver
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 98 mux21 49 oper_add 3 oper_selector 7 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_rx_digi_cdr_ctrl
	( 
	adata,
	adata_valid,
	early_eios,
	eidle_exit,
	eiosdetect_int,
	gen2ngen1,
	gen2ngen1_bundle,
	inferred_rxvalid,
	ltr,
	pipe_loopbk,
	pld_ltr,
	rcdr_ctrl_en,
	rcid_en,
	rcvd_clk,
	rindv_rx,
	rmask_count,
	rrxvalid_mask,
	rwait_count,
	rxpcs_reset_int,
	sigdet) /* synthesis synthesis_clearbox=1 */;
	input   [9:0]  adata;
	input   adata_valid;
	output   early_eios;
	output   eidle_exit;
	output   eiosdetect_int;
	input   gen2ngen1;
	input   gen2ngen1_bundle;
	output   inferred_rxvalid;
	output   ltr;
	input   pipe_loopbk;
	input   pld_ltr;
	input   rcdr_ctrl_en;
	input   rcid_en;
	input   rcvd_clk;
	input   rindv_rx;
	input   [9:0]  rmask_count;
	input   rrxvalid_mask;
	input   [7:0]  rwait_count;
	input   rxpcs_reset_int;
	input   sigdet;

	reg	n0l0O43;
	reg	n0l0O44;
	reg	n0l1i45;
	reg	n0l1i46;
	reg	n0lli41;
	reg	n0lli42;
	reg	n0lOO39;
	reg	n0lOO40;
	reg	n0O0i35;
	reg	n0O0i36;
	reg	n0O0l33;
	reg	n0O0l34;
	reg	n0O0O31;
	reg	n0O0O32;
	reg	n0O1l37;
	reg	n0O1l38;
	reg	n0OiO29;
	reg	n0OiO30;
	reg	n0Oll27;
	reg	n0Oll28;
	reg	n0OOi25;
	reg	n0OOi26;
	reg	n0OOO23;
	reg	n0OOO24;
	reg	ni01i3;
	reg	ni01i4;
	reg	ni01O1;
	reg	ni01O2;
	reg	ni10i19;
	reg	ni10i20;
	reg	ni10l17;
	reg	ni10l18;
	reg	ni11O21;
	reg	ni11O22;
	reg	ni1ii15;
	reg	ni1ii16;
	reg	ni1iO13;
	reg	ni1iO14;
	reg	ni1lO11;
	reg	ni1lO12;
	reg	ni1Oi10;
	reg	ni1Oi9;
	reg	ni1Ol7;
	reg	ni1Ol8;
	reg	ni1OO5;
	reg	ni1OO6;
	reg	n10O;
	reg	n11O;
	reg	n1ii;
	reg	n1il;
	reg	n1iO;
	reg	n1li;
	reg	n1ll;
	reg	n1lO;
	reg	n1Oi;
	reg	n1Ol;
	reg	n1OO;
	reg	ni0li;
	reg	ni0Oi;
	reg	nii0i;
	reg	nii0O;
	reg	niili;
	reg	niOOO;
	reg	nl;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nli0O;
	reg	nli1i;
	reg	nll0l;
	reg	nll0O;
	reg	nll1l;
	reg	nllii;
	reg	nllil;
	reg	nlliO;
	reg	nllli;
	reg	nllll;
	reg	nlllO;
	reg	nlO;
	wire	wire_ni_CLRN;
	reg	nilil;
	reg	nilii_clk_prev;
	wire	wire_nilii_PRN;
	wire	wire_nilii_ENA;
	reg	niiii;
	reg	niiil;
	reg	niiiO;
	reg	nl10l;
	reg	nl10i_clk_prev;
	wire	wire_nl10i_CLRN;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_ni0ll_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nO_dataout;
	wire  [9:0]   wire_n0ll_o;
	wire  [4:0]   wire_nl0ii_o;
	wire  [7:0]   wire_nlO0O_o;
	wire  wire_niill_o;
	wire  wire_niiOi_o;
	wire  wire_niiOO_o;
	wire  wire_nil1i_o;
	wire  wire_nil1O_o;
	wire  wire_niliO_o;
	wire  wire_nilli_o;
	wire  n0ilO;
	wire  n0iOi;
	wire  n0iOl;
	wire  n0iOO;
	wire  n0l0i;
	wire  n0l0l;
	wire  n0l1l;
	wire  n0l1O;
	wire  n0lil;
	wire  n0liO;
	wire  n0llO;
	wire  n0lOi;
	wire  n0lOl;
	wire  n0Oil;
	wire  ni01l;
	wire  ni11l;
	wire  ni1ll;

	initial
		n0l0O43 = 0;
	always @ ( posedge rcvd_clk)
		  n0l0O43 <= n0l0O44;
	event n0l0O43_event;
	initial
		#1 ->n0l0O43_event;
	always @(n0l0O43_event)
		n0l0O43 <= {1{1'b1}};
	initial
		n0l0O44 = 0;
	always @ ( posedge rcvd_clk)
		  n0l0O44 <= n0l0O43;
	initial
		n0l1i45 = 0;
	always @ ( posedge rcvd_clk)
		  n0l1i45 <= n0l1i46;
	event n0l1i45_event;
	initial
		#1 ->n0l1i45_event;
	always @(n0l1i45_event)
		n0l1i45 <= {1{1'b1}};
	initial
		n0l1i46 = 0;
	always @ ( posedge rcvd_clk)
		  n0l1i46 <= n0l1i45;
	initial
		n0lli41 = 0;
	always @ ( posedge rcvd_clk)
		  n0lli41 <= n0lli42;
	event n0lli41_event;
	initial
		#1 ->n0lli41_event;
	always @(n0lli41_event)
		n0lli41 <= {1{1'b1}};
	initial
		n0lli42 = 0;
	always @ ( posedge rcvd_clk)
		  n0lli42 <= n0lli41;
	initial
		n0lOO39 = 0;
	always @ ( posedge rcvd_clk)
		  n0lOO39 <= n0lOO40;
	event n0lOO39_event;
	initial
		#1 ->n0lOO39_event;
	always @(n0lOO39_event)
		n0lOO39 <= {1{1'b1}};
	initial
		n0lOO40 = 0;
	always @ ( posedge rcvd_clk)
		  n0lOO40 <= n0lOO39;
	initial
		n0O0i35 = 0;
	always @ ( posedge rcvd_clk)
		  n0O0i35 <= n0O0i36;
	event n0O0i35_event;
	initial
		#1 ->n0O0i35_event;
	always @(n0O0i35_event)
		n0O0i35 <= {1{1'b1}};
	initial
		n0O0i36 = 0;
	always @ ( posedge rcvd_clk)
		  n0O0i36 <= n0O0i35;
	initial
		n0O0l33 = 0;
	always @ ( posedge rcvd_clk)
		  n0O0l33 <= n0O0l34;
	event n0O0l33_event;
	initial
		#1 ->n0O0l33_event;
	always @(n0O0l33_event)
		n0O0l33 <= {1{1'b1}};
	initial
		n0O0l34 = 0;
	always @ ( posedge rcvd_clk)
		  n0O0l34 <= n0O0l33;
	initial
		n0O0O31 = 0;
	always @ ( posedge rcvd_clk)
		  n0O0O31 <= n0O0O32;
	event n0O0O31_event;
	initial
		#1 ->n0O0O31_event;
	always @(n0O0O31_event)
		n0O0O31 <= {1{1'b1}};
	initial
		n0O0O32 = 0;
	always @ ( posedge rcvd_clk)
		  n0O0O32 <= n0O0O31;
	initial
		n0O1l37 = 0;
	always @ ( posedge rcvd_clk)
		  n0O1l37 <= n0O1l38;
	event n0O1l37_event;
	initial
		#1 ->n0O1l37_event;
	always @(n0O1l37_event)
		n0O1l37 <= {1{1'b1}};
	initial
		n0O1l38 = 0;
	always @ ( posedge rcvd_clk)
		  n0O1l38 <= n0O1l37;
	initial
		n0OiO29 = 0;
	always @ ( posedge rcvd_clk)
		  n0OiO29 <= n0OiO30;
	event n0OiO29_event;
	initial
		#1 ->n0OiO29_event;
	always @(n0OiO29_event)
		n0OiO29 <= {1{1'b1}};
	initial
		n0OiO30 = 0;
	always @ ( posedge rcvd_clk)
		  n0OiO30 <= n0OiO29;
	initial
		n0Oll27 = 0;
	always @ ( posedge rcvd_clk)
		  n0Oll27 <= n0Oll28;
	event n0Oll27_event;
	initial
		#1 ->n0Oll27_event;
	always @(n0Oll27_event)
		n0Oll27 <= {1{1'b1}};
	initial
		n0Oll28 = 0;
	always @ ( posedge rcvd_clk)
		  n0Oll28 <= n0Oll27;
	initial
		n0OOi25 = 0;
	always @ ( posedge rcvd_clk)
		  n0OOi25 <= n0OOi26;
	event n0OOi25_event;
	initial
		#1 ->n0OOi25_event;
	always @(n0OOi25_event)
		n0OOi25 <= {1{1'b1}};
	initial
		n0OOi26 = 0;
	always @ ( posedge rcvd_clk)
		  n0OOi26 <= n0OOi25;
	initial
		n0OOO23 = 0;
	always @ ( posedge rcvd_clk)
		  n0OOO23 <= n0OOO24;
	event n0OOO23_event;
	initial
		#1 ->n0OOO23_event;
	always @(n0OOO23_event)
		n0OOO23 <= {1{1'b1}};
	initial
		n0OOO24 = 0;
	always @ ( posedge rcvd_clk)
		  n0OOO24 <= n0OOO23;
	initial
		ni01i3 = 0;
	always @ ( posedge rcvd_clk)
		  ni01i3 <= ni01i4;
	event ni01i3_event;
	initial
		#1 ->ni01i3_event;
	always @(ni01i3_event)
		ni01i3 <= {1{1'b1}};
	initial
		ni01i4 = 0;
	always @ ( posedge rcvd_clk)
		  ni01i4 <= ni01i3;
	initial
		ni01O1 = 0;
	always @ ( posedge rcvd_clk)
		  ni01O1 <= ni01O2;
	event ni01O1_event;
	initial
		#1 ->ni01O1_event;
	always @(ni01O1_event)
		ni01O1 <= {1{1'b1}};
	initial
		ni01O2 = 0;
	always @ ( posedge rcvd_clk)
		  ni01O2 <= ni01O1;
	initial
		ni10i19 = 0;
	always @ ( posedge rcvd_clk)
		  ni10i19 <= ni10i20;
	event ni10i19_event;
	initial
		#1 ->ni10i19_event;
	always @(ni10i19_event)
		ni10i19 <= {1{1'b1}};
	initial
		ni10i20 = 0;
	always @ ( posedge rcvd_clk)
		  ni10i20 <= ni10i19;
	initial
		ni10l17 = 0;
	always @ ( posedge rcvd_clk)
		  ni10l17 <= ni10l18;
	event ni10l17_event;
	initial
		#1 ->ni10l17_event;
	always @(ni10l17_event)
		ni10l17 <= {1{1'b1}};
	initial
		ni10l18 = 0;
	always @ ( posedge rcvd_clk)
		  ni10l18 <= ni10l17;
	initial
		ni11O21 = 0;
	always @ ( posedge rcvd_clk)
		  ni11O21 <= ni11O22;
	event ni11O21_event;
	initial
		#1 ->ni11O21_event;
	always @(ni11O21_event)
		ni11O21 <= {1{1'b1}};
	initial
		ni11O22 = 0;
	always @ ( posedge rcvd_clk)
		  ni11O22 <= ni11O21;
	initial
		ni1ii15 = 0;
	always @ ( posedge rcvd_clk)
		  ni1ii15 <= ni1ii16;
	event ni1ii15_event;
	initial
		#1 ->ni1ii15_event;
	always @(ni1ii15_event)
		ni1ii15 <= {1{1'b1}};
	initial
		ni1ii16 = 0;
	always @ ( posedge rcvd_clk)
		  ni1ii16 <= ni1ii15;
	initial
		ni1iO13 = 0;
	always @ ( posedge rcvd_clk)
		  ni1iO13 <= ni1iO14;
	event ni1iO13_event;
	initial
		#1 ->ni1iO13_event;
	always @(ni1iO13_event)
		ni1iO13 <= {1{1'b1}};
	initial
		ni1iO14 = 0;
	always @ ( posedge rcvd_clk)
		  ni1iO14 <= ni1iO13;
	initial
		ni1lO11 = 0;
	always @ ( posedge rcvd_clk)
		  ni1lO11 <= ni1lO12;
	event ni1lO11_event;
	initial
		#1 ->ni1lO11_event;
	always @(ni1lO11_event)
		ni1lO11 <= {1{1'b1}};
	initial
		ni1lO12 = 0;
	always @ ( posedge rcvd_clk)
		  ni1lO12 <= ni1lO11;
	initial
		ni1Oi10 = 0;
	always @ ( posedge rcvd_clk)
		  ni1Oi10 <= ni1Oi9;
	initial
		ni1Oi9 = 0;
	always @ ( posedge rcvd_clk)
		  ni1Oi9 <= ni1Oi10;
	event ni1Oi9_event;
	initial
		#1 ->ni1Oi9_event;
	always @(ni1Oi9_event)
		ni1Oi9 <= {1{1'b1}};
	initial
		ni1Ol7 = 0;
	always @ ( posedge rcvd_clk)
		  ni1Ol7 <= ni1Ol8;
	event ni1Ol7_event;
	initial
		#1 ->ni1Ol7_event;
	always @(ni1Ol7_event)
		ni1Ol7 <= {1{1'b1}};
	initial
		ni1Ol8 = 0;
	always @ ( posedge rcvd_clk)
		  ni1Ol8 <= ni1Ol7;
	initial
		ni1OO5 = 0;
	always @ ( posedge rcvd_clk)
		  ni1OO5 <= ni1OO6;
	event ni1OO5_event;
	initial
		#1 ->ni1OO5_event;
	always @(ni1OO5_event)
		ni1OO5 <= {1{1'b1}};
	initial
		ni1OO6 = 0;
	always @ ( posedge rcvd_clk)
		  ni1OO6 <= ni1OO5;
	initial
	begin
		n10O = 0;
		n11O = 0;
		n1ii = 0;
		n1il = 0;
		n1iO = 0;
		n1li = 0;
		n1ll = 0;
		n1lO = 0;
		n1Oi = 0;
		n1Ol = 0;
		n1OO = 0;
		ni0li = 0;
		ni0Oi = 0;
		nii0i = 0;
		nii0O = 0;
		niili = 0;
		niOOO = 0;
		nl = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nli0O = 0;
		nli1i = 0;
		nll0l = 0;
		nll0O = 0;
		nll1l = 0;
		nllii = 0;
		nllil = 0;
		nlliO = 0;
		nllli = 0;
		nllll = 0;
		nlllO = 0;
		nlO = 0;
	end
	always @ ( posedge rcvd_clk or  negedge wire_ni_CLRN)
	begin
		if (wire_ni_CLRN == 1'b0) 
		begin
			n10O <= 0;
			n11O <= 0;
			n1ii <= 0;
			n1il <= 0;
			n1iO <= 0;
			n1li <= 0;
			n1ll <= 0;
			n1lO <= 0;
			n1Oi <= 0;
			n1Ol <= 0;
			n1OO <= 0;
			ni0li <= 0;
			ni0Oi <= 0;
			nii0i <= 0;
			nii0O <= 0;
			niili <= 0;
			niOOO <= 0;
			nl <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nli0O <= 0;
			nli1i <= 0;
			nll0l <= 0;
			nll0O <= 0;
			nll1l <= 0;
			nllii <= 0;
			nllil <= 0;
			nlliO <= 0;
			nllli <= 0;
			nllll <= 0;
			nlllO <= 0;
			nlO <= 0;
		end
		else 
		begin
			n10O <= wire_n10i_dataout;
			n11O <= wire_n01i_dataout;
			n1ii <= wire_n01l_dataout;
			n1il <= wire_n01O_dataout;
			n1iO <= wire_n00i_dataout;
			n1li <= wire_n00l_dataout;
			n1ll <= wire_n00O_dataout;
			n1lO <= wire_n0ii_dataout;
			n1Oi <= wire_n0il_dataout;
			n1Ol <= wire_n0iO_dataout;
			n1OO <= wire_n0li_dataout;
			ni0li <= wire_ni0ll_dataout;
			ni0Oi <= ni0li;
			nii0i <= nii0O;
			nii0O <= wire_nil0l_dataout;
			niili <= wire_niill_o;
			niOOO <= wire_niiOi_o;
			nl <= wire_nO_dataout;
			nl0il <= pipe_loopbk;
			nl0iO <= nl0li;
			nl0li <= nl0ll;
			nl0ll <= nl0lO;
			nl0lO <= nl0Oi;
			nl0Oi <= nl0Ol;
			nl0Ol <= nl0OO;
			nl0OO <= sigdet;
			nl10O <= wire_nl1lO_dataout;
			nl11i <= wire_niiOO_o;
			nl11l <= wire_nil1i_o;
			nl11O <= wire_nil1l_dataout;
			nl1ii <= wire_nl1Oi_dataout;
			nl1il <= wire_nl1Ol_dataout;
			nl1iO <= wire_nl1OO_dataout;
			nl1li <= wire_nl01i_dataout;
			nl1ll <= nl0il;
			nli0O <= wire_niliO_o;
			nli1i <= wire_nilli_o;
			nll0l <= wire_nll1O_dataout;
			nll0O <= wire_nllOl_dataout;
			nll1l <= wire_nllOi_dataout;
			nllii <= wire_nllOO_dataout;
			nllil <= wire_nlO1i_dataout;
			nlliO <= wire_nlO1l_dataout;
			nllli <= wire_nlO1O_dataout;
			nllll <= wire_nlO0i_dataout;
			nlllO <= wire_nlO0l_dataout;
			nlO <= nl;
		end
	end
	assign
		wire_ni_CLRN = ((ni01O2 ^ ni01O1) & (~ rxpcs_reset_int));
	initial
	begin
		nilil = 0;
	end
	always @ (rcvd_clk or wire_nilii_PRN or rxpcs_reset_int)
	begin
		if (wire_nilii_PRN == 1'b0) 
		begin
			nilil <= 1;
		end
		else if  (rxpcs_reset_int == 1'b1) 
		begin
			nilil <= 0;
		end
		else if  (wire_nilii_ENA == 1'b1) 
		if (rcvd_clk != nilii_clk_prev && rcvd_clk == 1'b1) 
		begin
			nilil <= ni01l;
		end
		nilii_clk_prev <= rcvd_clk;
	end
	assign
		wire_nilii_ENA = (nl0li & (~ nl0iO)),
		wire_nilii_PRN = (n0l1i46 ^ n0l1i45);
	initial
	begin
		niiii = 0;
		niiil = 0;
		niiiO = 0;
		nl10l = 0;
	end
	always @ (rcvd_clk or rxpcs_reset_int or wire_nl10i_CLRN)
	begin
		if (rxpcs_reset_int == 1'b1) 
		begin
			niiii <= 1;
			niiil <= 1;
			niiiO <= 1;
			nl10l <= 1;
		end
		else if  (wire_nl10i_CLRN == 1'b0) 
		begin
			niiii <= 0;
			niiil <= 0;
			niiiO <= 0;
			nl10l <= 0;
		end
		else 
		if (rcvd_clk != nl10i_clk_prev && rcvd_clk == 1'b1) 
		begin
			niiii <= niiil;
			niiil <= niiiO;
			niiiO <= (~ (nl11i | niOOO));
			nl10l <= wire_nil1O_o;
		end
		nl10i_clk_prev <= rcvd_clk;
	end
	assign
		wire_nl10i_CLRN = (n0O0i36 ^ n0O0i35);
	and(wire_n00i_dataout, wire_n0ll_o[3], ~((~ niOOO)));
	and(wire_n00l_dataout, wire_n0ll_o[4], ~((~ niOOO)));
	and(wire_n00O_dataout, wire_n0ll_o[5], ~((~ niOOO)));
	and(wire_n01i_dataout, wire_n0ll_o[0], ~((~ niOOO)));
	and(wire_n01l_dataout, wire_n0ll_o[1], ~((~ niOOO)));
	and(wire_n01O_dataout, wire_n0ll_o[2], ~((~ niOOO)));
	and(wire_n0ii_dataout, wire_n0ll_o[6], ~((~ niOOO)));
	and(wire_n0il_dataout, wire_n0ll_o[7], ~((~ niOOO)));
	and(wire_n0iO_dataout, wire_n0ll_o[8], ~((~ niOOO)));
	and(wire_n0li_dataout, wire_n0ll_o[9], ~((~ niOOO)));
	and(wire_n10i_dataout, wire_n10l_dataout, ~((~ niOOO)));
	or(wire_n10l_dataout, n10O, ni1ll);
	and(wire_ni0ll_dataout, adata_valid, (n0iOi | n0ilO));
	and(wire_nii1i_dataout, adata_valid, (n0iOO | n0iOl));
	and(wire_nil0l_dataout, wire_nii1i_dataout, (nl11O | nl11l));
	and(wire_nil1l_dataout, wire_niOil_dataout, nl10l);
	and(wire_nilOi_dataout, (~ n10O), ~(n0liO));
	and(wire_nilOl_dataout, n10O, ~(n0liO));
	and(wire_niO1i_dataout, (~ n0l0l), ~(n0lil));
	and(wire_niO1l_dataout, n0l0l, ~(n0lil));
	and(wire_niOii_dataout, wire_niOli_dataout, ~(n0lOl));
	and(wire_niOil_dataout, n0llO, ~(n0lOl));
	and(wire_niOiO_dataout, wire_niOll_dataout, ~(n0lOl));
	and(wire_niOli_dataout, n0lOi, ~(n0llO));
	and(wire_niOll_dataout, (~ n0lOi), ~(n0llO));
	assign		wire_nl00i_dataout = (niili === 1'b1) ? wire_nl0ii_o[2] : nl1il;
	assign		wire_nl00l_dataout = (niili === 1'b1) ? wire_nl0ii_o[3] : nl1iO;
	assign		wire_nl00O_dataout = (niili === 1'b1) ? wire_nl0ii_o[4] : nl1li;
	and(wire_nl01i_dataout, wire_nl00O_dataout, ~((~ niili)));
	assign		wire_nl01l_dataout = (niili === 1'b1) ? wire_nl0ii_o[0] : nl10O;
	assign		wire_nl01O_dataout = (niili === 1'b1) ? wire_nl0ii_o[1] : nl1ii;
	and(wire_nl1lO_dataout, wire_nl01l_dataout, ~((~ niili)));
	and(wire_nl1Oi_dataout, wire_nl01O_dataout, ~((~ niili)));
	and(wire_nl1Ol_dataout, wire_nl00i_dataout, ~((~ niili)));
	and(wire_nl1OO_dataout, wire_nl00l_dataout, ~((~ niili)));
	or(wire_nli1l_dataout, niiii, ~(rrxvalid_mask));
	and(wire_nli1O_dataout, nli1i, ((rcid_en & (~ n0Oil)) & (n0O0O32 ^ n0O0O31)));
	assign		wire_nliii_dataout = (rcdr_ctrl_en === 1'b1) ? nli0O : pld_ltr;
	or(wire_nll0i_dataout, nll0l, ni11l);
	and(wire_nll1O_dataout, wire_nll0i_dataout, ~((~ nl11i)));
	and(wire_nllOi_dataout, wire_nlO0O_o[0], ~((~ nl11i)));
	and(wire_nllOl_dataout, wire_nlO0O_o[1], ~((~ nl11i)));
	and(wire_nllOO_dataout, wire_nlO0O_o[2], ~((~ nl11i)));
	and(wire_nlO0i_dataout, wire_nlO0O_o[6], ~((~ nl11i)));
	and(wire_nlO0l_dataout, wire_nlO0O_o[7], ~((~ nl11i)));
	and(wire_nlO1i_dataout, wire_nlO0O_o[3], ~((~ nl11i)));
	and(wire_nlO1l_dataout, wire_nlO0O_o[4], ~((~ nl11i)));
	and(wire_nlO1O_dataout, wire_nlO0O_o[5], ~((~ nl11i)));
	assign		wire_nO_dataout = (rindv_rx === 1'b1) ? gen2ngen1 : gen2ngen1_bundle;
	oper_add   n0ll
	( 
	.a({((ni1lO12 ^ ni1lO11) & n1OO), n1Ol, ((ni1Oi10 ^ ni1Oi9) & n1Oi), ((ni1Ol8 ^ ni1Ol7) & n1lO), n1ll, n1li, ((ni1OO6 ^ ni1OO5) & n1iO), n1il, n1ii, ((ni01i4 ^ ni01i3) & n11O)}),
	.b({{9{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n0ll_o));
	defparam
		n0ll.sgate_representation = 0,
		n0ll.width_a = 10,
		n0ll.width_b = 10,
		n0ll.width_o = 10;
	oper_add   nl0ii
	( 
	.a({nl1li, nl1iO, nl1il, nl1ii, ((n0O0l34 ^ n0O0l33) & nl10O)}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nl0ii_o));
	defparam
		nl0ii.sgate_representation = 0,
		nl0ii.width_a = 5,
		nl0ii.width_b = 5,
		nl0ii.width_o = 5;
	oper_add   nlO0O
	( 
	.a({nlllO, nllll, nllli, nlliO, ((ni11O22 ^ ni11O21) & nllil), ((ni10i20 ^ ni10i19) & nllii), nll0O, nll1l}),
	.b({{7{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO0O_o));
	defparam
		nlO0O.sgate_representation = 0,
		nlO0O.width_a = 8,
		nlO0O.width_b = 8,
		nlO0O.width_o = 8;
	oper_selector   niill
	( 
	.data({1'b0, {2{wire_niO1l_dataout}}, (~ n0l1l)}),
	.o(wire_niill_o),
	.sel({((nl10l | nl11i) | niOOO), nl11O, nl11l, niili}));
	defparam
		niill.width_data = 4,
		niill.width_sel = 4;
	oper_selector   niiOi
	( 
	.data({1'b0, n0l0i, wire_nilOi_dataout}),
	.o(wire_niiOi_o),
	.sel({(((nl10l | nl11O) | nl11l) | niili), nl11i, niOOO}));
	defparam
		niiOi.width_data = 3,
		niiOi.width_sel = 3;
	oper_selector   niiOO
	( 
	.data({n0lOl, {2{n0lil}}, (~ n0l0i), n0liO, n0l1l}),
	.o(wire_niiOO_o),
	.sel({nl10l, nl11O, nl11l, nl11i, niOOO, niili}));
	defparam
		niiOO.width_data = 6,
		niiOO.width_sel = 6;
	oper_selector   nil1i
	( 
	.data({wire_niOii_dataout, wire_niO1i_dataout, 1'b0}),
	.o(wire_nil1i_o),
	.sel({nl10l, nl11O, n0l1O}));
	defparam
		nil1i.width_data = 3,
		nil1i.width_sel = 3;
	oper_selector   nil1O
	( 
	.data({wire_niOiO_dataout, 1'b0, wire_niO1i_dataout, wire_nilOl_dataout}),
	.o(wire_nil1O_o),
	.sel({nl10l, ((nl11O | nl11i) | niili), nl11l, niOOO}));
	defparam
		nil1O.width_data = 4,
		nil1O.width_sel = 4;
	oper_selector   niliO
	( 
	.data({n0lOl, {2{n0lil}}, (~ n0l0i), n0liO, n0l1l}),
	.o(wire_niliO_o),
	.sel({nl10l, nl11O, nl11l, nl11i, niOOO, niili}));
	defparam
		niliO.width_data = 6,
		niliO.width_sel = 6;
	oper_selector   nilli
	( 
	.data({(n0llO | n0lOi), wire_niO1i_dataout, 1'b0}),
	.o(wire_nilli_o),
	.sel({nl10l, nl11O, n0l1O}));
	defparam
		nilli.width_data = 3,
		nilli.width_sel = 3;
	assign
		early_eios = wire_nli1O_dataout,
		eidle_exit = niOOO,
		eiosdetect_int = nii0i,
		inferred_rxvalid = wire_nli1l_dataout,
		ltr = wire_nliii_dataout,
		n0ilO = (((((((((adata[0] & adata[1]) & (~ adata[2])) & (~ adata[3])) & (~ adata[4])) & (~ adata[5])) & (~ adata[6])) & adata[7]) & (~ adata[8])) & adata[9]),
		n0iOi = ((((((((((~ adata[0]) & (~ adata[1])) & adata[2]) & adata[3]) & adata[4]) & adata[5]) & adata[6]) & (~ adata[7])) & adata[8]) & (~ adata[9])),
		n0iOl = (((((((((adata[0] & adata[1]) & (~ adata[2])) & (~ adata[3])) & (~ adata[4])) & (~ adata[5])) & adata[6]) & adata[7]) & (~ adata[8])) & (~ adata[9])),
		n0iOO = ((((((((((~ adata[0]) & (~ adata[1])) & adata[2]) & adata[3]) & adata[4]) & adata[5]) & (~ adata[6])) & (~ adata[7])) & adata[8]) & adata[9]),
		n0l0i = (nl0iO & nll0l),
		n0l0l = ((wire_nii1i_dataout & n0Oil) & (n0l0O44 ^ n0l0O43)),
		n0l1l = ((((nl1li & nl1iO) & nl1il) & (~ nl1ii)) & nl10O),
		n0l1O = (((nl11l | nl11i) | niOOO) | niili),
		n0lil = (n0liO | (wire_nii1i_dataout & (~ nl1ll))),
		n0liO = (((~ nlO) & (~ nl0iO)) & (n0lli42 ^ n0lli41)),
		n0llO = (wire_nii1i_dataout & ni0li),
		n0lOi = (wire_nii1i_dataout & ni0Oi),
		n0lOl = (((~ nlO) & (((~ nl0iO) & nilil) & (n0O1l38 ^ n0O1l37))) & (n0lOO40 ^ n0lOO39)),
		n0Oil = (nlO & nl1ll),
		ni01l = 1'b1,
		ni11l = ((((((((~ ((rwait_count[0] ^ nll1l) ^ (~ (n0OOO24 ^ n0OOO23)))) & (~ (rwait_count[1] ^ nll0O))) & (~ ((rwait_count[2] ^ nllii) ^ (~ (n0OOi26 ^ n0OOi25))))) & (~ (rwait_count[3] ^ nllil))) & (~ ((rwait_count[4] ^ nlliO) ^ (~ (n0Oll28 ^ n0Oll27))))) & (~ (rwait_count[5] ^ nllli))) & (~ (rwait_count[6] ^ nllll))) & (~ ((rwait_count[7] ^ nlllO) ^ (~ (n0OiO30 ^ n0OiO29))))),
		ni1ll = ((((((((((~ (rmask_count[0] ^ n11O)) & (~ (rmask_count[1] ^ n1ii))) & (~ (rmask_count[2] ^ n1il))) & (~ ((rmask_count[3] ^ n1iO) ^ (~ (ni1iO14 ^ ni1iO13))))) & (~ (rmask_count[4] ^ n1li))) & (~ (rmask_count[5] ^ n1ll))) & (~ ((rmask_count[6] ^ n1lO) ^ (~ (ni1ii16 ^ ni1ii15))))) & (~ ((rmask_count[7] ^ n1Oi) ^ (~ (ni10l18 ^ ni10l17))))) & (~ (rmask_count[8] ^ n1Ol))) & (~ (rmask_count[9] ^ n1OO)));
endmodule //cycloneiv_hssi_rx_digi_cdr_ctrl
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 529 mux21 1169 oper_add 22 oper_decoder 15 oper_less_than 18 oper_mux 4 cycloneiv_hssi_rx_digis_ram20x16_syn 2 
`timescale 1 ps / 1 ps
module  cycloneiv_hssi_rx_digi_comp_chnl_top
	( 
	align_status,
	align_status_sync,
	align_status_sync_0,
	align_status_sync_2,
	audi,
	audi_pre,
	cg_comp_rd_d_ch0,
	cg_comp_rd_d_ch1,
	cg_comp_rd_d_ch2,
	cg_comp_rd_d_ch3,
	cg_comp_rd_d_out,
	cg_comp_wr_ch0,
	cg_comp_wr_ch1,
	cg_comp_wr_ch2,
	cg_comp_wr_ch3,
	cg_comp_wr_out,
	clk_1,
	clk_2,
	cmpfifourst,
	comp_curr_st,
	cudi,
	cudi_valid,
	del_cond_met_0,
	del_cond_met_out,
	dskwclksel,
	fifo_cnt,
	fifo_ovr_0,
	fifo_ovr_out,
	fifo_rd_in_comp_0,
	fifo_rd_in_comp_2,
	fifo_rd_out_comp,
	gen2ngen1,
	gen2ngen1_bundle,
	hard_reset,
	inferred_rxvalid,
	insert_incomplete_0,
	insert_incomplete_out,
	is_lane0,
	latency_comp_0,
	latency_comp_out,
	rauto_speed_ena,
	rclkcmpinsertpad,
	rclkcmpsq1n,
	rclkcmpsq1p,
	rclkcmpsqmd,
	rcmpfifourst,
	rdel_threshold,
	rdenable,
	rdfifo_almost_empty,
	rdfifo_almost_full,
	rdfifo_empty,
	rdfifo_full,
	rdwidth_rx,
	rempty_threshold,
	rev_loop_data,
	rfreq_sel,
	rfull_threshold,
	rgenericfifo,
	rindv_rx,
	rins_threshold,
	rmatchen,
	rrx_pipe_enable,
	rskpsetbased,
	rstart_threshold,
	rtruebac2bac,
	rwa_6g_en,
	scan_mode,
	skpos_det,
	soft_reset,
	sudi,
	sudi_pre,
	sync_status,
	wrenable) /* synthesis synthesis_clearbox=1 */;
	input   align_status;
	output   align_status_sync;
	input   align_status_sync_0;
	input   align_status_sync_2;
	input   [13:0]  audi;
	input   [13:0]  audi_pre;
	input   cg_comp_rd_d_ch0;
	input   cg_comp_rd_d_ch1;
	input   cg_comp_rd_d_ch2;
	input   cg_comp_rd_d_ch3;
	output   cg_comp_rd_d_out;
	input   cg_comp_wr_ch0;
	input   cg_comp_wr_ch1;
	input   cg_comp_wr_ch2;
	input   cg_comp_wr_ch3;
	output   cg_comp_wr_out;
	input   clk_1;
	input   clk_2;
	input   cmpfifourst;
	output   [1:0]  comp_curr_st;
	output   [31:0]  cudi;
	output   cudi_valid;
	input   del_cond_met_0;
	output   del_cond_met_out;
	input   [1:0]  dskwclksel;
	output   [4:0]  fifo_cnt;
	input   fifo_ovr_0;
	output   fifo_ovr_out;
	input   fifo_rd_in_comp_0;
	input   fifo_rd_in_comp_2;
	output   fifo_rd_out_comp;
	input   gen2ngen1;
	input   gen2ngen1_bundle;
	input   hard_reset;
	input   inferred_rxvalid;
	input   insert_incomplete_0;
	output   insert_incomplete_out;
	input   is_lane0;
	input   latency_comp_0;
	output   latency_comp_out;
	input   rauto_speed_ena;
	input   rclkcmpinsertpad;
	input   [19:0]  rclkcmpsq1n;
	input   [19:0]  rclkcmpsq1p;
	input   rclkcmpsqmd;
	input   rcmpfifourst;
	input   [4:0]  rdel_threshold;
	input   rdenable;
	output   rdfifo_almost_empty;
	output   rdfifo_almost_full;
	output   rdfifo_empty;
	output   rdfifo_full;
	input   rdwidth_rx;
	input   [2:0]  rempty_threshold;
	output   [19:0]  rev_loop_data;
	input   rfreq_sel;
	input   [4:0]  rfull_threshold;
	input   rgenericfifo;
	input   rindv_rx;
	input   [4:0]  rins_threshold;
	input   rmatchen;
	input   rrx_pipe_enable;
	input   rskpsetbased;
	input   [2:0]  rstart_threshold;
	input   rtruebac2bac;
	input   rwa_6g_en;
	input   scan_mode;
	output   skpos_det;
	input   soft_reset;
	input   [27:0]  sudi;
	input   [13:0]  sudi_pre;
	input   sync_status;
	input   wrenable;

	reg	nli0O0O61;
	reg	nli0O0O62;
	reg	nliil1i59;
	reg	nliil1i60;
	reg	nliil1l57;
	reg	nliil1l58;
	reg	nliiOOi55;
	reg	nliiOOi56;
	reg	nliiOOl53;
	reg	nliiOOl54;
	reg	nliiOOO51;
	reg	nliiOOO52;
	reg	nlil01l49;
	reg	nlil01l50;
	reg	nlil0li47;
	reg	nlil0li48;
	reg	nlil0Ol45;
	reg	nlil0Ol46;
	reg	nlili0l43;
	reg	nlili0l44;
	reg	nlilill41;
	reg	nlilill42;
	reg	nlililO39;
	reg	nlililO40;
	reg	nliliOi37;
	reg	nliliOi38;
	reg	nliliOl35;
	reg	nliliOl36;
	reg	nliliOO33;
	reg	nliliOO34;
	reg	nlill0l25;
	reg	nlill0l26;
	reg	nlill1i31;
	reg	nlill1i32;
	reg	nlill1l29;
	reg	nlill1l30;
	reg	nlill1O27;
	reg	nlill1O28;
	reg	nlilliO23;
	reg	nlilliO24;
	reg	nlillll21;
	reg	nlillll22;
	reg	nlilO0O15;
	reg	nlilO0O16;
	reg	nlilO1i19;
	reg	nlilO1i20;
	reg	nlilO1O17;
	reg	nlilO1O18;
	reg	nlilOli13;
	reg	nlilOli14;
	reg	nlilOlO11;
	reg	nlilOlO12;
	reg	nlilOOl10;
	reg	nlilOOl9;
	reg	nlilOOO7;
	reg	nlilOOO8;
	reg	nliO10i3;
	reg	nliO10i4;
	reg	nliO11l5;
	reg	nliO11l6;
	reg	nliO1iO1;
	reg	nliO1iO2;
	reg	n0111i;
	reg	n0111l;
	reg	n1000i;
	reg	n1000l;
	reg	n1000O;
	reg	n1001i;
	reg	n1001l;
	reg	n1001O;
	reg	n100ii;
	reg	n100il;
	reg	n100li;
	reg	n100ll;
	reg	n100lO;
	reg	n100Oi;
	reg	n100Ol;
	reg	n100OO;
	reg	n101Ol;
	reg	n101OO;
	reg	n10i0i;
	reg	n10i0l;
	reg	n10i0O;
	reg	n10i1i;
	reg	n10i1l;
	reg	n10i1O;
	reg	n10iii;
	reg	n10iil;
	reg	n10iiO;
	reg	n10ili;
	reg	n10ill;
	reg	n10ilO;
	reg	n10iOl;
	reg	n10iOO;
	reg	n10l0i;
	reg	n10l0l;
	reg	n10l0O;
	reg	n10l1i;
	reg	n10l1l;
	reg	n10l1O;
	reg	n10lii;
	reg	n10lil;
	reg	n10liO;
	reg	n10lli;
	reg	n10lll;
	reg	n10llO;
	reg	n10lOi;
	reg	n10lOl;
	reg	n10lOO;
	reg	n10O1i;
	reg	n10O1l;
	reg	n10O1O;
	reg	n110iO;
	reg	n110li;
	reg	n110ll;
	reg	n110lO;
	reg	n11iil;
	reg	n11iiO;
	reg	n11ili;
	reg	n11ill;
	reg	n11ilO;
	reg	n11iOi;
	reg	n11iOl;
	reg	n11iOO;
	reg	n11O0i;
	reg	n11O0l;
	reg	n11O0O;
	reg	n11O1i;
	reg	n11O1l;
	reg	n11O1O;
	reg	n1l;
	reg	n1liil;
	reg	n1liiO;
	reg	n1lili;
	reg	n1ll1i;
	reg	n1ll1l;
	reg	n1O00i;
	reg	n1O00l;
	reg	n1O01l;
	reg	n1O01O;
	reg	ni0OOi;
	reg	ni0OOl;
	reg	ni0OOO;
	reg	nii00i;
	reg	nii00l;
	reg	nii00O;
	reg	nii01i;
	reg	nii01l;
	reg	nii01O;
	reg	nii0ii;
	reg	nii0il;
	reg	nii0iO;
	reg	nii0ll;
	reg	nii0Ol;
	reg	nii0OO;
	reg	nii10i;
	reg	nii10l;
	reg	nii10O;
	reg	nii11i;
	reg	nii11l;
	reg	nii11O;
	reg	nii1ii;
	reg	nii1il;
	reg	nii1iO;
	reg	nii1li;
	reg	nii1ll;
	reg	nii1lO;
	reg	nii1Oi;
	reg	nii1Ol;
	reg	nii1OO;
	reg	niii1i;
	reg	niOlOl;
	reg	niOlOO;
	reg	niOO0i;
	reg	niOO0l;
	reg	niOO0O;
	reg	niOO1i;
	reg	niOO1l;
	reg	niOO1O;
	reg	niOOii;
	reg	niOOil;
	reg	niOOli;
	reg	niOOll;
	reg	niOOlO;
	reg	niOOOi;
	reg	niOOOl;
	reg	niOOOO;
	reg	nl100i;
	reg	nl100l;
	reg	nl100O;
	reg	nl101i;
	reg	nl101l;
	reg	nl101O;
	reg	nl10ii;
	reg	nl10il;
	reg	nl10iO;
	reg	nl10li;
	reg	nl10ll;
	reg	nl10lO;
	reg	nl10Oi;
	reg	nl10Ol;
	reg	nl10OO;
	reg	nl110i;
	reg	nl110l;
	reg	nl110O;
	reg	nl111i;
	reg	nl111l;
	reg	nl111O;
	reg	nl11ii;
	reg	nl11il;
	reg	nl11iO;
	reg	nl11li;
	reg	nl11ll;
	reg	nl11lO;
	reg	nl11OO;
	reg	nl1i0i;
	reg	nl1i1i;
	reg	nl1i1l;
	reg	nl1i1O;
	reg	nli0il;
	reg	nli0Ol;
	reg	nli0OO;
	reg	nli1ll;
	reg	nli1lO;
	reg	nli1Oi;
	reg	nli1Ol;
	reg	nlii0i;
	reg	nlii0l;
	reg	nlii0O;
	reg	nlii1i;
	reg	nlii1l;
	reg	nliilO;
	reg	nliiOi;
	reg	nlil0i;
	reg	nlil0l;
	reg	nlil0O;
	reg	nlil1O;
	reg	nlilOl;
	reg	nliO01l;
	reg	nliO01O;
	reg	nliO1i;
	reg	nlll;
	reg	nlO00OO;
	reg	nlOi1iO;
	reg	nlOiO0i;
	reg	nlOiO0l;
	reg	nlOiO0O;
	reg	nlOiO1O;
	reg	nlOiOii;
	reg	nlOl0OO;
	reg	nlOli0i;
	reg	nlOli0l;
	reg	nlOli0O;
	reg	nlOli1i;
	reg	nlOli1l;
	reg	nlOli1O;
	reg	nlOliii;
	reg	nlOliil;
	reg	nlOliiO;
	reg	nlOlili;
	reg	nlOlilO;
	reg	nlOliOO;
	reg	nlOll1i;
	reg	nlOll1l;
	reg	n1i_clk_prev;
	wire	wire_n1i_CLRN;
	wire	wire_n1i_PRN;
	reg	n0l0iO;
	reg	ni11ll;
	reg	ni11lO;
	reg	ni11Ol;
	reg	nlliiOO;
	reg	nllil1i;
	reg	nllil1l;
	reg	nlllO0l;
	reg	ni11Oi_clk_prev;
	wire	wire_ni11Oi_CLRN;
	wire	wire_ni11Oi_PRN;
	reg	n0111O;
	reg	n0l00l;
	reg	n0l00O;
	reg	n0l0ii;
	reg	n0l0il;
	reg	n0l0li;
	reg	n0l0ll;
	reg	n0l0lO;
	reg	n0l0Oi;
	reg	n0l0Ol;
	reg	n0l0OO;
	reg	n0li0i;
	reg	n0li0l;
	reg	n0li0O;
	reg	n0li1i;
	reg	n0li1l;
	reg	n0li1O;
	reg	n0liii;
	reg	n0liil;
	reg	n0liiO;
	reg	n0lili;
	reg	n0lill;
	reg	n0lilO;
	reg	n0liOi;
	reg	n0liOl;
	reg	n0O0ll;
	reg	n0O0lO;
	reg	n0O0Oi;
	reg	n0O0Ol;
	reg	n0O0OO;
	reg	n0Oiil;
	reg	n0OiOl;
	reg	n0OiOO;
	reg	n0Ol0i;
	reg	n0Ol0l;
	reg	n0Ol0O;
	reg	n0Ol1l;
	reg	n0Ol1O;
	reg	n0OO1O;
	reg	n0OOli;
	reg	n0OOll;
	reg	n1O;
	reg	ni000i;
	reg	ni000l;
	reg	ni00il;
	reg	ni00iO;
	reg	ni00Oi;
	reg	ni101i;
	reg	ni101l;
	reg	ni110i;
	reg	ni110l;
	reg	ni111i;
	reg	ni111l;
	reg	ni111O;
	reg	ni11OO;
	reg	ni1i0i;
	reg	ni1i0l;
	reg	ni1i0O;
	reg	ni1i1l;
	reg	ni1i1O;
	reg	ni1llO;
	reg	ni1O0i;
	reg	ni1O0l;
	reg	ni1O0O;
	reg	ni1O1l;
	reg	ni1O1O;
	reg	nil;
	reg	nliO00i;
	reg	nliO1l;
	reg	nlli00O;
	reg	nlli0Oi;
	reg	nlli0Ol;
	reg	nlli1ii;
	reg	nlli1il;
	reg	nlli1iO;
	reg	nlli1li;
	reg	nlli1ll;
	reg	nllii0l;
	reg	nllii0O;
	reg	nllii1O;
	reg	nlliiii;
	reg	nlliiil;
	reg	nlliiiO;
	reg	nlliiO;
	reg	nllil0i;
	reg	nllil0l;
	reg	nllil1O;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	nlliOl;
	reg	nlliOO;
	reg	nlll0i;
	reg	nlll0l;
	reg	nlll0O;
	reg	nlll10l;
	reg	nlll10O;
	reg	nlll1i;
	reg	nlll1ii;
	reg	nlll1il;
	reg	nlll1iO;
	reg	nlll1l;
	reg	nlll1li;
	reg	nlll1O;
	reg	nlllii;
	reg	nlllil;
	reg	nllliO;
	reg	nllll0O;
	reg	nlllli;
	reg	nllllii;
	reg	nlllliO;
	reg	nlllll;
	reg	nllllli;
	reg	nllllO;
	reg	nlllO0i;
	reg	nlllO0O;
	reg	nlllO1i;
	reg	nlllO1l;
	reg	nlllO1O;
	reg	nlllOi;
	reg	nlllOii;
	reg	nlllOil;
	reg	nlllOiO;
	reg	nlllOl;
	reg	nlllOli;
	reg	nlllOll;
	reg	nlllOlO;
	reg	nlllOO;
	reg	nlllOOi;
	reg	nlllOOl;
	reg	nlllOOO;
	reg	nllO0i;
	reg	nllO0l;
	reg	nllO10i;
	reg	nllO10l;
	reg	nllO10O;
	reg	nllO11i;
	reg	nllO11l;
	reg	nllO11O;
	reg	nllO1i;
	reg	nllO1ii;
	reg	nllO1il;
	reg	nllO1iO;
	reg	nllO1l;
	reg	nllO1li;
	reg	nllO1O;
	reg	nllOOi;
	reg	nllOOl;
	reg	nlO00ii;
	reg	nlO00li;
	reg	nlO00ll;
	reg	nlO00lO;
	reg	nlO00Oi;
	reg	nlO00Ol;
	reg	nlO011i;
	reg	nlO011l;
	reg	nlO01l;
	reg	nlO01O;
	reg	nlO10li;
	reg	nlO10ll;
	reg	nlO10lO;
	reg	nlO10Oi;
	reg	nlO1i0O;
	reg	nlO1Oii;
	reg	nlO1OiO;
	reg	nlO1OOi;
	reg	nlO1OOl;
	reg	nlO1OOO;
	wire	wire_nii_CLRN;
	reg	ni00Ol;
	reg	ni0liO;
	reg	ni0lli;
	reg	ni0lll;
	reg	ni0llO;
	reg	ni0lOi;
	reg	ni0lOl;
	reg	ni0lOO;
	reg	ni0O0i;
	reg	ni0O0l;
	reg	ni0O0O;
	reg	ni0O1i;
	reg	ni0O1l;
	reg	ni0O1O;
	reg	ni0Oii;
	reg	ni0Oil;
	reg	ni0OiO;
	reg	ni0Oli;
	reg	ni0Oll;
	reg	ni0OlO;
	reg	nii0li;
	reg	nii0Oi;
	wire	wire_nii0lO_CLRN;
	reg	n0Oi1i;
	reg	n0Oi1l;
	reg	niiOlO;
	reg	niiOOi;
	reg	niiOOO;
	reg	nlli10i;
	reg	nlli10l;
	reg	nlli10O;
	reg	nlO10Ol;
	reg	nlO10OO;
	reg	niiOOl_clk_prev;
	wire	wire_niiOOl_CLRN;
	wire	wire_niiOOl_PRN;
	reg	nl0l;
	reg	nO;
	reg	nl_clk_prev;
	wire	wire_nl_CLRN;
	reg	n100iO;
	reg	n10iOi;
	reg	niOOiO;
	reg	nl11Ol;
	reg	n0l00i;
	reg	n0l01l;
	reg	n0l01O;
	reg	n1O00O;
	reg	n1O0ii;
	reg	nli01l;
	reg	nli1OO;
	reg	nlli11i;
	reg	nlli11l;
	reg	nlli11O;
	wire	wire_nli01i_PRN;
	reg	nl0O;
	reg	nlli;
	reg	nlOiOil;
	reg	nlOiOli;
	reg	nlOiOll;
	reg	nlOiOlO;
	reg	nlOiOOi;
	reg	nlOiOOl;
	reg	nlOiOOO;
	reg	nlOl00i;
	reg	nlOl00l;
	reg	nlOl00O;
	reg	nlOl01i;
	reg	nlOl01l;
	reg	nlOl01O;
	reg	nlOl0ii;
	reg	nlOl0il;
	reg	nlOl0iO;
	reg	nlOl0li;
	reg	nlOl0ll;
	reg	nlOl0lO;
	reg	nlOl0Oi;
	reg	nlOl0Ol;
	reg	nlOl10i;
	reg	nlOl10l;
	reg	nlOl10O;
	reg	nlOl11i;
	reg	nlOl11l;
	reg	nlOl11O;
	reg	nlOl1ii;
	reg	nlOl1il;
	reg	nlOl1iO;
	reg	nlOl1li;
	reg	nlOl1ll;
	reg	nlOl1lO;
	reg	nlOl1Oi;
	reg	nlOl1Ol;
	reg	nlOl1OO;
	reg	nlOlill;
	reg	nlOliOl;
	reg	nlOliOi_clk_prev;
	wire	wire_nlOliOi_PRN;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n0110i_dataout;
	wire	wire_n0110l_dataout;
	wire	wire_n0110O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0liOO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0ll0i_dataout;
	wire	wire_n0ll0l_dataout;
	wire	wire_n0ll0O_dataout;
	wire	wire_n0ll1i_dataout;
	wire	wire_n0ll1l_dataout;
	wire	wire_n0ll1O_dataout;
	wire	wire_n0llii_dataout;
	wire	wire_n0llil_dataout;
	wire	wire_n0lliO_dataout;
	wire	wire_n0llli_dataout;
	wire	wire_n0llll_dataout;
	wire	wire_n0lllO_dataout;
	wire	wire_n0llOi_dataout;
	wire	wire_n0llOl_dataout;
	wire	wire_n0llOO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lO0i_dataout;
	wire	wire_n0lO0l_dataout;
	wire	wire_n0lO0O_dataout;
	wire	wire_n0lO1i_dataout;
	wire	wire_n0lO1l_dataout;
	wire	wire_n0lO1O_dataout;
	wire	wire_n0lOii_dataout;
	wire	wire_n0lOil_dataout;
	wire	wire_n0lOiO_dataout;
	wire	wire_n0lOli_dataout;
	wire	wire_n0lOll_dataout;
	wire	wire_n0lOlO_dataout;
	wire	wire_n0lOOi_dataout;
	wire	wire_n0lOOl_dataout;
	wire	wire_n0lOOO_dataout;
	wire	wire_n0O00i_dataout;
	wire	wire_n0O00l_dataout;
	wire	wire_n0O00O_dataout;
	wire	wire_n0O01i_dataout;
	wire	wire_n0O01l_dataout;
	wire	wire_n0O01O_dataout;
	wire	wire_n0O0ii_dataout;
	wire	wire_n0O0il_dataout;
	wire	wire_n0O0iO_dataout;
	wire	wire_n0O10i_dataout;
	wire	wire_n0O10l_dataout;
	wire	wire_n0O10O_dataout;
	wire	wire_n0O11i_dataout;
	wire	wire_n0O11l_dataout;
	wire	wire_n0O11O_dataout;
	wire	wire_n0O1ii_dataout;
	wire	wire_n0O1il_dataout;
	wire	wire_n0O1iO_dataout;
	wire	wire_n0O1li_dataout;
	wire	wire_n0O1ll_dataout;
	wire	wire_n0O1lO_dataout;
	wire	wire_n0O1Oi_dataout;
	wire	wire_n0O1Ol_dataout;
	wire	wire_n0O1OO_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oi0i_dataout;
	wire	wire_n0Oi0l_dataout;
	wire	wire_n0Oi0O_dataout;
	wire	wire_n0Oi1O_dataout;
	wire	wire_n0Oiii_dataout;
	wire	wire_n0OiiO_dataout;
	wire	wire_n0Oili_dataout;
	wire	wire_n0Oill_dataout;
	wire	wire_n0OilO_dataout;
	wire	wire_n0OiOi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Olii_dataout;
	wire	wire_n0Olil_dataout;
	wire	wire_n0OliO_dataout;
	wire	wire_n0Olli_dataout;
	wire	wire_n0Olll_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OO0i_dataout;
	wire	wire_n0OO0l_dataout;
	wire	wire_n0OOii_dataout;
	wire	wire_n1011i_dataout;
	wire	wire_n1011l_dataout;
	wire	wire_n1011O_dataout;
	wire	wire_n101iO_dataout;
	wire	wire_n101li_dataout;
	wire	wire_n101ll_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10O0i_dataout;
	wire	wire_n10O0l_dataout;
	wire	wire_n10O0O_dataout;
	wire	wire_n10Oii_dataout;
	wire	wire_n10Oil_dataout;
	wire	wire_n10OiO_dataout;
	wire	wire_n10Oli_dataout;
	wire	wire_n10Oll_dataout;
	wire	wire_n10OlO_dataout;
	wire	wire_n10OOi_dataout;
	wire	wire_n10OOl_dataout;
	wire	wire_n10OOO_dataout;
	wire	wire_n1100i_dataout;
	wire	wire_n1100l_dataout;
	wire	wire_n1100O_dataout;
	wire	wire_n1101i_dataout;
	wire	wire_n110Oi_dataout;
	wire	wire_n110Ol_dataout;
	wire	wire_n1110i_dataout;
	wire	wire_n1110l_dataout;
	wire	wire_n1110O_dataout;
	wire	wire_n1111i_dataout;
	wire	wire_n1111l_dataout;
	wire	wire_n1111O_dataout;
	wire	wire_n111ii_dataout;
	wire	wire_n111il_dataout;
	wire	wire_n111iO_dataout;
	wire	wire_n111li_dataout;
	wire	wire_n111ll_dataout;
	wire	wire_n111lO_dataout;
	wire	wire_n111Oi_dataout;
	wire	wire_n111Ol_dataout;
	wire	wire_n111OO_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11l0i_dataout;
	wire	wire_n11l0l_dataout;
	wire	wire_n11l0O_dataout;
	wire	wire_n11l1i_dataout;
	wire	wire_n11l1l_dataout;
	wire	wire_n11l1O_dataout;
	wire	wire_n11lii_dataout;
	wire	wire_n11lil_dataout;
	wire	wire_n11liO_dataout;
	wire	wire_n11lli_dataout;
	wire	wire_n11lll_dataout;
	wire	wire_n11llO_dataout;
	wire	wire_n11lOi_dataout;
	wire	wire_n11lOl_dataout;
	wire	wire_n11lOO_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n11Oii_dataout;
	wire	wire_n11Oil_dataout;
	wire	wire_n11OiO_dataout;
	wire	wire_n11Oli_dataout;
	wire	wire_n11Oll_dataout;
	wire	wire_n11OlO_dataout;
	wire	wire_n11OOi_dataout;
	wire	wire_n11OOl_dataout;
	wire	wire_n11OOO_dataout;
	wire	wire_n1i00i_dataout;
	wire	wire_n1i00l_dataout;
	wire	wire_n1i00O_dataout;
	wire	wire_n1i01i_dataout;
	wire	wire_n1i01l_dataout;
	wire	wire_n1i01O_dataout;
	wire	wire_n1i0ii_dataout;
	wire	wire_n1i0il_dataout;
	wire	wire_n1i0iO_dataout;
	wire	wire_n1i0li_dataout;
	wire	wire_n1i0ll_dataout;
	wire	wire_n1i0lO_dataout;
	wire	wire_n1i0Oi_dataout;
	wire	wire_n1i0Ol_dataout;
	wire	wire_n1i0OO_dataout;
	wire	wire_n1i10i_dataout;
	wire	wire_n1i10l_dataout;
	wire	wire_n1i10O_dataout;
	wire	wire_n1i11i_dataout;
	wire	wire_n1i11l_dataout;
	wire	wire_n1i11O_dataout;
	wire	wire_n1i1ii_dataout;
	wire	wire_n1i1il_dataout;
	wire	wire_n1i1iO_dataout;
	wire	wire_n1i1li_dataout;
	wire	wire_n1i1ll_dataout;
	wire	wire_n1i1lO_dataout;
	wire	wire_n1i1Oi_dataout;
	wire	wire_n1i1Ol_dataout;
	wire	wire_n1i1OO_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1ii0i_dataout;
	wire	wire_n1ii0l_dataout;
	wire	wire_n1ii0O_dataout;
	wire	wire_n1ii1i_dataout;
	wire	wire_n1ii1l_dataout;
	wire	wire_n1ii1O_dataout;
	wire	wire_n1iiii_dataout;
	wire	wire_n1iiil_dataout;
	wire	wire_n1iiiO_dataout;
	wire	wire_n1iili_dataout;
	wire	wire_n1iill_dataout;
	wire	wire_n1iilO_dataout;
	wire	wire_n1iiOi_dataout;
	wire	wire_n1iiOl_dataout;
	wire	wire_n1iiOO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1il0i_dataout;
	wire	wire_n1il0l_dataout;
	wire	wire_n1il0O_dataout;
	wire	wire_n1il1i_dataout;
	wire	wire_n1il1l_dataout;
	wire	wire_n1il1O_dataout;
	wire	wire_n1ilii_dataout;
	wire	wire_n1ilil_dataout;
	wire	wire_n1iliO_dataout;
	wire	wire_n1illi_dataout;
	wire	wire_n1illl_dataout;
	wire	wire_n1illO_dataout;
	wire	wire_n1ilOi_dataout;
	wire	wire_n1ilOl_dataout;
	wire	wire_n1ilOO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iO0i_dataout;
	wire	wire_n1iO0l_dataout;
	wire	wire_n1iO0O_dataout;
	wire	wire_n1iO1i_dataout;
	wire	wire_n1iO1l_dataout;
	wire	wire_n1iO1O_dataout;
	wire	wire_n1iOii_dataout;
	wire	wire_n1iOil_dataout;
	wire	wire_n1iOiO_dataout;
	wire	wire_n1iOli_dataout;
	wire	wire_n1iOll_dataout;
	wire	wire_n1iOlO_dataout;
	wire	wire_n1iOOi_dataout;
	wire	wire_n1iOOl_dataout;
	wire	wire_n1iOOO_dataout;
	wire	wire_n1l0ii_dataout;
	wire	wire_n1l0il_dataout;
	wire	wire_n1l0iO_dataout;
	wire	wire_n1l0li_dataout;
	wire	wire_n1l0ll_dataout;
	wire	wire_n1l10i_dataout;
	wire	wire_n1l10l_dataout;
	wire	wire_n1l10O_dataout;
	wire	wire_n1l11i_dataout;
	wire	wire_n1l11l_dataout;
	wire	wire_n1l11O_dataout;
	wire	wire_n1l1ii_dataout;
	wire	wire_n1l1il_dataout;
	wire	wire_n1l1iO_dataout;
	wire	wire_n1l1li_dataout;
	wire	wire_n1l1ll_dataout;
	wire	wire_n1l1lO_dataout;
	wire	wire_n1l1Oi_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1li0i_dataout;
	wire	wire_n1li1O_dataout;
	wire	wire_n1lill_dataout;
	wire	wire_n1lilO_dataout;
	wire	wire_n1liOi_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1O0il_dataout;
	wire	wire_n1O0iO_dataout;
	wire	wire_n1O0li_dataout;
	wire	wire_n1O0ll_dataout;
	wire	wire_n1O0lO_dataout;
	wire	wire_n1O0Oi_dataout;
	wire	wire_n1O0Ol_dataout;
	wire	wire_n1O0OO_dataout;
	wire	wire_n1O1ll_dataout;
	wire	wire_n1O1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oi1i_dataout;
	wire	wire_n1Oi1l_dataout;
	wire	wire_n1Oi1O_dataout;
	wire	wire_n1Oiil_dataout;
	wire	wire_n1OiOi_dataout;
	wire	wire_n1OiOl_dataout;
	wire	wire_n1OiOO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Ol0i_dataout;
	wire	wire_n1Ol0l_dataout;
	wire	wire_n1Ol0O_dataout;
	wire	wire_n1Ol1i_dataout;
	wire	wire_n1Ol1l_dataout;
	wire	wire_n1Ol1O_dataout;
	wire	wire_n1Olii_dataout;
	wire	wire_n1Olli_dataout;
	wire	wire_n1Olll_dataout;
	wire	wire_n1OlOl_dataout;
	wire	wire_n1OlOO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OO0i_dataout;
	wire	wire_n1OO0l_dataout;
	wire	wire_n1OO0O_dataout;
	wire	wire_n1OO1i_dataout;
	wire	wire_n1OO1l_dataout;
	wire	wire_n1OO1O_dataout;
	wire	wire_n1OOii_dataout;
	wire	wire_n1OOil_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0iiO_dataout;
	wire	wire_ni0ili_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni100i_dataout;
	wire	wire_ni100l_dataout;
	wire	wire_ni100O_dataout;
	wire	wire_ni101O_dataout;
	wire	wire_ni10ii_dataout;
	wire	wire_ni10il_dataout;
	wire	wire_ni10iO_dataout;
	wire	wire_ni10lO_dataout;
	wire	wire_ni110O_dataout;
	wire	wire_ni11ii_dataout;
	wire	wire_ni11il_dataout;
	wire	wire_ni11iO_dataout;
	wire	wire_ni11li_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1iii_dataout;
	wire	wire_ni1iil_dataout;
	wire	wire_ni1iiO_dataout;
	wire	wire_ni1ili_dataout;
	wire	wire_ni1ill_dataout;
	wire	wire_ni1ilO_dataout;
	wire	wire_ni1iOi_dataout;
	wire	wire_ni1iOl_dataout;
	wire	wire_ni1iOO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1l1i_dataout;
	wire	wire_ni1l1l_dataout;
	wire	wire_ni1l1O_dataout;
	wire	wire_ni1lOi_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1Oil_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OlO_dataout;
	wire	wire_ni1OOi_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_niii_dataout;
	wire	wire_niii0i_dataout;
	wire	wire_niii0l_dataout;
	wire	wire_niii0O_dataout;
	wire	wire_niii1l_dataout;
	wire	wire_niii1O_dataout;
	wire	wire_niiiii_dataout;
	wire	wire_niiiil_dataout;
	wire	wire_niiiiO_dataout;
	wire	wire_niiili_dataout;
	wire	wire_niiill_dataout;
	wire	wire_niiilO_dataout;
	wire	wire_niiiOi_dataout;
	wire	wire_niiiOl_dataout;
	wire	wire_niiiOO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niil0i_dataout;
	wire	wire_niil0l_dataout;
	wire	wire_niil0O_dataout;
	wire	wire_niil1i_dataout;
	wire	wire_niil1l_dataout;
	wire	wire_niil1O_dataout;
	wire	wire_niilii_dataout;
	wire	wire_niilil_dataout;
	wire	wire_niiliO_dataout;
	wire	wire_niilli_dataout;
	wire	wire_niilll_dataout;
	wire	wire_niillO_dataout;
	wire	wire_niilOi_dataout;
	wire	wire_niilOl_dataout;
	wire	wire_niilOO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiO0i_dataout;
	wire	wire_niiO0l_dataout;
	wire	wire_niiO0O_dataout;
	wire	wire_niiO1i_dataout;
	wire	wire_niiO1l_dataout;
	wire	wire_niiO1O_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOii_dataout;
	wire	wire_niiOil_dataout;
	wire	wire_niiOiO_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOli_dataout;
	wire	wire_niiOll_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil00i_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil01i_dataout;
	wire	wire_nil01l_dataout;
	wire	wire_nil01O_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil10i_dataout;
	wire	wire_nil10l_dataout;
	wire	wire_nil10O_dataout;
	wire	wire_nil11i_dataout;
	wire	wire_nil11l_dataout;
	wire	wire_nil11O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1ii_dataout;
	wire	wire_nil1il_dataout;
	wire	wire_nil1iO_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1li_dataout;
	wire	wire_nil1ll_dataout;
	wire	wire_nil1lO_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nil1Oi_dataout;
	wire	wire_nil1Ol_dataout;
	wire	wire_nil1OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilil_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO0OO_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1i_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOlil_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOllO_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl00il_dataout;
	wire	wire_nl00iO_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl00Oi_dataout;
	wire	wire_nl00Ol_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1i_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0iii_dataout;
	wire	wire_nl0iil_dataout;
	wire	wire_nl0iiO_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0ili_dataout;
	wire	wire_nl0ill_dataout;
	wire	wire_nl0ilO_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0iOi_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l0i_dataout;
	wire	wire_nl0l0l_dataout;
	wire	wire_nl0l0O_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0l1l_dataout;
	wire	wire_nl0l1O_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0lii_dataout;
	wire	wire_nl0lil_dataout;
	wire	wire_nl0liO_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lli_dataout;
	wire	wire_nl0lll_dataout;
	wire	wire_nl0llO_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0lOi_dataout;
	wire	wire_nl0lOl_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Oil_dataout;
	wire	wire_nl0OiO_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0Oli_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl0OlO_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0l_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1iil_dataout;
	wire	wire_nl1iiO_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1ili_dataout;
	wire	wire_nl1ill_dataout;
	wire	wire_nl1ilO_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1iOi_dataout;
	wire	wire_nl1iOl_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0i_dataout;
	wire	wire_nl1l0l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1l1l_dataout;
	wire	wire_nl1l1O_dataout;
	wire	wire_nl1li_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1ll_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O0i_dataout;
	wire	wire_nl1O0l_dataout;
	wire	wire_nl1O0O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliiii_dataout;
	wire	wire_nliiil_dataout;
	wire	wire_nliiiO_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nlilOO_dataout;
	wire	wire_nliO00l_dataout;
	wire	wire_nliO00O_dataout;
	wire	wire_nliO0i_dataout;
	wire	wire_nliO0ii_dataout;
	wire	wire_nliO0l_dataout;
	wire	wire_nliO0O_dataout;
	wire	wire_nliO1O_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOlO_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nliOOi_dataout;
	wire	wire_nliOOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll00i_dataout;
	wire	wire_nll00l_dataout;
	wire	wire_nll00O_dataout;
	wire	wire_nll01i_dataout;
	wire	wire_nll01l_dataout;
	wire	wire_nll01O_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0ii_dataout;
	wire	wire_nll0il_dataout;
	wire	wire_nll0iO_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0li_dataout;
	wire	wire_nll0ll_dataout;
	wire	wire_nll0lO_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll0Oi_dataout;
	wire	wire_nll0Ol_dataout;
	wire	wire_nll0OO_dataout;
	wire	wire_nll10i_dataout;
	wire	wire_nll10l_dataout;
	wire	wire_nll10O_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll11l_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1ii_dataout;
	wire	wire_nll1il_dataout;
	wire	wire_nll1iO_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1li_dataout;
	wire	wire_nll1ll_dataout;
	wire	wire_nll1lO_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nll1Ol_dataout;
	wire	wire_nll1OO_dataout;
	wire	wire_nlli01i_dataout;
	wire	wire_nlli0li_dataout;
	wire	wire_nlli1i_dataout;
	wire	wire_nlli1l_dataout;
	wire	wire_nlli1lO_dataout;
	wire	wire_nlli1Oi_dataout;
	wire	wire_nlli1Ol_dataout;
	wire	wire_nlli1OO_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllii0i_dataout;
	wire	wire_nlliili_dataout;
	wire	wire_nlliill_dataout;
	wire	wire_nlliilO_dataout;
	wire	wire_nlliiOi_dataout;
	wire	wire_nlliiOl_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nllil0O_dataout;
	wire	wire_nllilii_dataout;
	wire	wire_nllilil_dataout;
	wire	wire_nlliliO_dataout;
	wire	wire_nllilli_dataout;
	wire	wire_nllilll_dataout;
	wire	wire_nllillO_dataout;
	wire	wire_nllilOO_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll00i_dataout;
	wire	wire_nlll00l_dataout;
	wire	wire_nlll00O_dataout;
	wire	wire_nlll01i_dataout;
	wire	wire_nlll01l_dataout;
	wire	wire_nlll01O_dataout;
	wire	wire_nlll0ii_dataout;
	wire	wire_nlll0il_dataout;
	wire	wire_nlll0iO_dataout;
	wire	wire_nlll0li_dataout;
	wire	wire_nlll0ll_dataout;
	wire	wire_nlll0lO_dataout;
	wire	wire_nlll0Oi_dataout;
	wire	wire_nlll0Ol_dataout;
	wire	wire_nlll0OO_dataout;
	wire	wire_nlll1ll_dataout;
	wire	wire_nlll1lO_dataout;
	wire	wire_nlll1Oi_dataout;
	wire	wire_nlll1Ol_dataout;
	wire	wire_nlll1OO_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllli0i_dataout;
	wire	wire_nllli0l_dataout;
	wire	wire_nllli0O_dataout;
	wire	wire_nllli1i_dataout;
	wire	wire_nllli1l_dataout;
	wire	wire_nllli1O_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nllllll_dataout;
	wire	wire_nlllllO_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO00i_dataout;
	wire	wire_nllO00l_dataout;
	wire	wire_nllO00O_dataout;
	wire	wire_nllO01i_dataout;
	wire	wire_nllO01l_dataout;
	wire	wire_nllO01O_dataout;
	wire	wire_nllO0ii_dataout;
	wire	wire_nllO0il_dataout;
	wire	wire_nllO0iO_dataout;
	wire	wire_nllO0li_dataout;
	wire	wire_nllO0ll_dataout;
	wire	wire_nllO0lO_dataout;
	wire	wire_nllO0Oi_dataout;
	wire	wire_nllO0Ol_dataout;
	wire	wire_nllO0OO_dataout;
	wire	wire_nllO1ll_dataout;
	wire	wire_nllO1lO_dataout;
	wire	wire_nllO1Oi_dataout;
	wire	wire_nllO1Ol_dataout;
	wire	wire_nllO1OO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOi0i_dataout;
	wire	wire_nllOi0l_dataout;
	wire	wire_nllOi0O_dataout;
	wire	wire_nllOi1i_dataout;
	wire	wire_nllOi1l_dataout;
	wire	wire_nllOi1O_dataout;
	wire	wire_nllOiii_dataout;
	wire	wire_nllOiil_dataout;
	wire	wire_nllOiiO_dataout;
	wire	wire_nllOili_dataout;
	wire	wire_nllOill_dataout;
	wire	wire_nllOilO_dataout;
	wire	wire_nllOiOi_dataout;
	wire	wire_nllOiOl_dataout;
	wire	wire_nllOiOO_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOl0i_dataout;
	wire	wire_nllOl0l_dataout;
	wire	wire_nllOl0O_dataout;
	wire	wire_nllOl1i_dataout;
	wire	wire_nllOl1l_dataout;
	wire	wire_nllOl1O_dataout;
	wire	wire_nllOlii_dataout;
	wire	wire_nllOlil_dataout;
	wire	wire_nllOliO_dataout;
	wire	wire_nllOlli_dataout;
	wire	wire_nllOlll_dataout;
	wire	wire_nllOllO_dataout;
	wire	wire_nllOlOi_dataout;
	wire	wire_nllOlOl_dataout;
	wire	wire_nllOlOO_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nllOO0i_dataout;
	wire	wire_nllOO0l_dataout;
	wire	wire_nllOO0O_dataout;
	wire	wire_nllOO1i_dataout;
	wire	wire_nllOO1l_dataout;
	wire	wire_nllOO1O_dataout;
	wire	wire_nllOOii_dataout;
	wire	wire_nllOOil_dataout;
	wire	wire_nllOOiO_dataout;
	wire	wire_nllOOli_dataout;
	wire	wire_nllOOll_dataout;
	wire	wire_nllOOlO_dataout;
	wire	wire_nllOOOi_dataout;
	wire	wire_nllOOOl_dataout;
	wire	wire_nllOOOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO001i_dataout;
	wire	wire_nlO001l_dataout;
	wire	wire_nlO00il_dataout;
	wire	wire_nlO010i_dataout;
	wire	wire_nlO010l_dataout;
	wire	wire_nlO010O_dataout;
	wire	wire_nlO011O_dataout;
	wire	wire_nlO01ii_dataout;
	wire	wire_nlO01il_dataout;
	wire	wire_nlO01iO_dataout;
	wire	wire_nlO01li_dataout;
	wire	wire_nlO01ll_dataout;
	wire	wire_nlO01lO_dataout;
	wire	wire_nlO01Oi_dataout;
	wire	wire_nlO01Ol_dataout;
	wire	wire_nlO01OO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0i0l_dataout;
	wire	wire_nlO0i1i_dataout;
	wire	wire_nlO0i1O_dataout;
	wire	wire_nlO0iiO_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0l1O_dataout;
	wire	wire_nlO0lOi_dataout;
	wire	wire_nlO0lOl_dataout;
	wire	wire_nlO0lOO_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO0O0i_dataout;
	wire	wire_nlO0O0l_dataout;
	wire	wire_nlO0O0O_dataout;
	wire	wire_nlO0O1i_dataout;
	wire	wire_nlO0O1l_dataout;
	wire	wire_nlO0O1O_dataout;
	wire	wire_nlO0Oii_dataout;
	wire	wire_nlO0Oil_dataout;
	wire	wire_nlO0OiO_dataout;
	wire	wire_nlO0Oli_dataout;
	wire	wire_nlO0Oll_dataout;
	wire	wire_nlO0OlO_dataout;
	wire	wire_nlO100i_dataout;
	wire	wire_nlO100l_dataout;
	wire	wire_nlO100O_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10ii_dataout;
	wire	wire_nlO10il_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO110i_dataout;
	wire	wire_nlO110l_dataout;
	wire	wire_nlO110O_dataout;
	wire	wire_nlO111i_dataout;
	wire	wire_nlO111l_dataout;
	wire	wire_nlO111O_dataout;
	wire	wire_nlO11ii_dataout;
	wire	wire_nlO11il_dataout;
	wire	wire_nlO11iO_dataout;
	wire	wire_nlO11li_dataout;
	wire	wire_nlO11ll_dataout;
	wire	wire_nlO11lO_dataout;
	wire	wire_nlO11Oi_dataout;
	wire	wire_nlO11Ol_dataout;
	wire	wire_nlO11OO_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1i0i_dataout;
	wire	wire_nlO1i0l_dataout;
	wire	wire_nlO1i1i_dataout;
	wire	wire_nlO1i1l_dataout;
	wire	wire_nlO1i1O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1iii_dataout;
	wire	wire_nlO1iil_dataout;
	wire	wire_nlO1iiO_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1ili_dataout;
	wire	wire_nlO1ill_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Oil_dataout;
	wire	wire_nlO1Oli_dataout;
	wire	wire_nlO1Oll_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi00i_dataout;
	wire	wire_nlOi00l_dataout;
	wire	wire_nlOi00O_dataout;
	wire	wire_nlOi01i_dataout;
	wire	wire_nlOi01l_dataout;
	wire	wire_nlOi01O_dataout;
	wire	wire_nlOi0ii_dataout;
	wire	wire_nlOi0il_dataout;
	wire	wire_nlOi0iO_dataout;
	wire	wire_nlOi0li_dataout;
	wire	wire_nlOi0ll_dataout;
	wire	wire_nlOi0lO_dataout;
	wire	wire_nlOi0Oi_dataout;
	wire	wire_nlOi0Ol_dataout;
	wire	wire_nlOi0OO_dataout;
	wire	wire_nlOi10i_dataout;
	wire	wire_nlOi10l_dataout;
	wire	wire_nlOi10O_dataout;
	wire	wire_nlOi11i_dataout;
	wire	wire_nlOi11l_dataout;
	wire	wire_nlOi11O_dataout;
	wire	wire_nlOi1il_dataout;
	wire	wire_nlOi1li_dataout;
	wire	wire_nlOi1ll_dataout;
	wire	wire_nlOi1lO_dataout;
	wire	wire_nlOi1Oi_dataout;
	wire	wire_nlOi1Ol_dataout;
	wire	wire_nlOi1OO_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOii0i_dataout;
	wire	wire_nlOii0l_dataout;
	wire	wire_nlOii0O_dataout;
	wire	wire_nlOii1i_dataout;
	wire	wire_nlOii1l_dataout;
	wire	wire_nlOii1O_dataout;
	wire	wire_nlOiiii_dataout;
	wire	wire_nlOiiil_dataout;
	wire	wire_nlOiiiO_dataout;
	wire	wire_nlOiili_dataout;
	wire	wire_nlOiill_dataout;
	wire	wire_nlOiilO_dataout;
	wire	wire_nlOiiOi_dataout;
	wire	wire_nlOiiOl_dataout;
	wire	wire_nlOiiOO_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOil0i_dataout;
	wire	wire_nlOil0l_dataout;
	wire	wire_nlOil0O_dataout;
	wire	wire_nlOil1i_dataout;
	wire	wire_nlOil1l_dataout;
	wire	wire_nlOil1O_dataout;
	wire	wire_nlOilii_dataout;
	wire	wire_nlOilil_dataout;
	wire	wire_nlOiliO_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOll0i_dataout;
	wire	wire_nlOll0l_dataout;
	wire	wire_nlOll0O_dataout;
	wire	wire_nlOll1O_dataout;
	wire	wire_nlOllii_dataout;
	wire	wire_nlOllil_dataout;
	wire	wire_nlOlliO_dataout;
	wire	wire_nlOllli_dataout;
	wire	wire_nlOllll_dataout;
	wire	wire_nlOlllO_dataout;
	wire	wire_nlOllOi_dataout;
	wire	wire_nlOllOl_dataout;
	wire	wire_nlOllOO_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOlO0i_dataout;
	wire	wire_nlOlO0l_dataout;
	wire	wire_nlOlO0O_dataout;
	wire	wire_nlOlO1i_dataout;
	wire	wire_nlOlO1l_dataout;
	wire	wire_nlOlO1O_dataout;
	wire	wire_nlOlOii_dataout;
	wire	wire_nlOlOil_dataout;
	wire	wire_nlOlOiO_dataout;
	wire	wire_nlOlOli_dataout;
	wire	wire_nlOlOll_dataout;
	wire	wire_nlOlOlO_dataout;
	wire	wire_nlOlOOi_dataout;
	wire	wire_nlOlOOl_dataout;
	wire	wire_nlOlOOO_dataout;
	wire	wire_nlOO00i_dataout;
	wire	wire_nlOO00l_dataout;
	wire	wire_nlOO00O_dataout;
	wire	wire_nlOO01i_dataout;
	wire	wire_nlOO01l_dataout;
	wire	wire_nlOO01O_dataout;
	wire	wire_nlOO0ii_dataout;
	wire	wire_nlOO0il_dataout;
	wire	wire_nlOO0iO_dataout;
	wire	wire_nlOO0li_dataout;
	wire	wire_nlOO0ll_dataout;
	wire	wire_nlOO0lO_dataout;
	wire	wire_nlOO0Oi_dataout;
	wire	wire_nlOO0Ol_dataout;
	wire	wire_nlOO0OO_dataout;
	wire	wire_nlOO10i_dataout;
	wire	wire_nlOO10l_dataout;
	wire	wire_nlOO10O_dataout;
	wire	wire_nlOO11i_dataout;
	wire	wire_nlOO11l_dataout;
	wire	wire_nlOO11O_dataout;
	wire	wire_nlOO1ii_dataout;
	wire	wire_nlOO1il_dataout;
	wire	wire_nlOO1iO_dataout;
	wire	wire_nlOO1li_dataout;
	wire	wire_nlOO1ll_dataout;
	wire	wire_nlOO1lO_dataout;
	wire	wire_nlOO1Oi_dataout;
	wire	wire_nlOO1Ol_dataout;
	wire	wire_nlOO1OO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOi0i_dataout;
	wire	wire_nlOOi0l_dataout;
	wire	wire_nlOOi0O_dataout;
	wire	wire_nlOOi1i_dataout;
	wire	wire_nlOOi1l_dataout;
	wire	wire_nlOOi1O_dataout;
	wire	wire_nlOOiii_dataout;
	wire	wire_nlOOiil_dataout;
	wire	wire_nlOOiiO_dataout;
	wire	wire_nlOOili_dataout;
	wire	wire_nlOOill_dataout;
	wire	wire_nlOOilO_dataout;
	wire	wire_nlOOiOi_dataout;
	wire	wire_nlOOiOl_dataout;
	wire	wire_nlOOiOO_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOl0i_dataout;
	wire	wire_nlOOl0l_dataout;
	wire	wire_nlOOl0O_dataout;
	wire	wire_nlOOl1i_dataout;
	wire	wire_nlOOl1l_dataout;
	wire	wire_nlOOl1O_dataout;
	wire	wire_nlOOlii_dataout;
	wire	wire_nlOOlil_dataout;
	wire	wire_nlOOliO_dataout;
	wire	wire_nlOOlli_dataout;
	wire	wire_nlOOlll_dataout;
	wire	wire_nlOOllO_dataout;
	wire	wire_nlOOlOi_dataout;
	wire	wire_nlOOlOO_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nlOOO0i_dataout;
	wire	wire_nlOOO0l_dataout;
	wire	wire_nlOOO0O_dataout;
	wire	wire_nlOOO1i_dataout;
	wire	wire_nlOOO1l_dataout;
	wire	wire_nlOOO1O_dataout;
	wire	wire_nlOOOii_dataout;
	wire	wire_nlOOOil_dataout;
	wire	wire_nlOOOiO_dataout;
	wire	wire_nlOOOli_dataout;
	wire	wire_nlOOOll_dataout;
	wire	wire_nlOOOlO_dataout;
	wire	wire_nlOOOOi_dataout;
	wire	wire_nlOOOOl_dataout;
	wire	wire_nlOOOOO_dataout;
	wire  [4:0]   wire_n0O0li_o;
	wire  [6:0]   wire_n0OOOO_o;
	wire  [2:0]   wire_n1010i_o;
	wire  [4:0]   wire_n1l0lO_o;
	wire  [6:0]   wire_n1O1OO_o;
	wire  [5:0]   wire_ni01ii_o;
	wire  [4:0]   wire_ni01il_o;
	wire  [5:0]   wire_ni1lii_o;
	wire  [5:0]   wire_ni1lil_o;
	wire  [5:0]   wire_ni1liO_o;
	wire  [4:0]   wire_nl0OOi_o;
	wire  [6:0]   wire_nli1iO_o;
	wire  [5:0]   wire_nllliii_o;
	wire  [4:0]   wire_nllliil_o;
	wire  [3:0]   wire_nllliOl_o;
	wire  [4:0]   wire_nllll1i_o;
	wire  [5:0]   wire_nlO000i_o;
	wire  [5:0]   wire_nlO000l_o;
	wire  [5:0]   wire_nlO001O_o;
	wire  [6:0]   wire_nlO0lli_o;
	wire  [5:0]   wire_nlO101i_o;
	wire  [4:0]   wire_nlO10iO_o;
	wire  [15:0]   wire_n011iO_o;
	wire  [3:0]   wire_n011ll_o;
	wire  [31:0]   wire_n011Oi_o;
	wire  [31:0]   wire_n0OO1l_o;
	wire  [31:0]   wire_n1l00O_o;
	wire  [15:0]   wire_n1l01l_o;
	wire  [15:0]   wire_n1l1OO_o;
	wire  [3:0]   wire_n1OliO_o;
	wire  [15:0]   wire_nl0O1i_o;
	wire  [15:0]   wire_nl0O1O_o;
	wire  [31:0]   wire_nl0Oii_o;
	wire  [31:0]   wire_nliO01i_o;
	wire  [15:0]   wire_nliO1lO_o;
	wire  [3:0]   wire_nliO1Ol_o;
	wire  [31:0]   wire_nlli01O_o;
	wire  wire_n11iii_o;
	wire  wire_n1O01i_o;
	wire  wire_n1O10l_o;
	wire  wire_n1O11l_o;
	wire  wire_n1OllO_o;
	wire  wire_n1OlOi_o;
	wire  wire_n1OOlO_o;
	wire  wire_n1OOOi_o;
	wire  wire_ni1i1i_o;
	wire  wire_ni1lli_o;
	wire  wire_nli1li_o;
	wire  wire_nlilOi_o;
	wire  wire_nlli0iO_o;
	wire  wire_nllOii_o;
	wire  wire_nllOil_o;
	wire  wire_nllOiO_o;
	wire  wire_nllOli_o;
	wire  wire_nlO000O_o;
	wire  wire_nllOOO_o;
	wire  wire_nlO11i_o;
	wire  wire_nlO11l_o;
	wire  wire_nlO11O_o;
	wire  [15:0]   wire_nllOll_data_out1;
	wire  [15:0]   wire_nllOll_data_out2;
	wire  [15:0]   wire_nllOlO_data_out1;
	wire  [15:0]   wire_nllOlO_data_out2;
	wire  nli00ll;
	wire  nli00lO;
	wire  nli00Oi;
	wire  nli00Ol;
	wire  nli00OO;
	wire  nli0i0i;
	wire  nli0i0l;
	wire  nli0i0O;
	wire  nli0i1i;
	wire  nli0i1l;
	wire  nli0i1O;
	wire  nli0iii;
	wire  nli0iil;
	wire  nli0iiO;
	wire  nli0ili;
	wire  nli0ill;
	wire  nli0ilO;
	wire  nli0iOi;
	wire  nli0iOl;
	wire  nli0iOO;
	wire  nli0l0i;
	wire  nli0l0l;
	wire  nli0l0O;
	wire  nli0l1i;
	wire  nli0l1l;
	wire  nli0l1O;
	wire  nli0lii;
	wire  nli0lil;
	wire  nli0liO;
	wire  nli0lli;
	wire  nli0lll;
	wire  nli0llO;
	wire  nli0lOi;
	wire  nli0lOl;
	wire  nli0lOO;
	wire  nli0O0i;
	wire  nli0O0l;
	wire  nli0O1i;
	wire  nli0O1l;
	wire  nli0O1O;
	wire  nli0Oii;
	wire  nli0Oil;
	wire  nli0OiO;
	wire  nli0Oli;
	wire  nli0Oll;
	wire  nli0OlO;
	wire  nli0OOi;
	wire  nli0OOl;
	wire  nli0OOO;
	wire  nlii00i;
	wire  nlii00l;
	wire  nlii00O;
	wire  nlii01i;
	wire  nlii01l;
	wire  nlii01O;
	wire  nlii0ii;
	wire  nlii0il;
	wire  nlii0iO;
	wire  nlii0li;
	wire  nlii0ll;
	wire  nlii0lO;
	wire  nlii0Oi;
	wire  nlii0Ol;
	wire  nlii0OO;
	wire  nlii10i;
	wire  nlii10l;
	wire  nlii10O;
	wire  nlii11i;
	wire  nlii11l;
	wire  nlii11O;
	wire  nlii1ii;
	wire  nlii1il;
	wire  nlii1iO;
	wire  nlii1li;
	wire  nlii1ll;
	wire  nlii1lO;
	wire  nlii1Oi;
	wire  nlii1Ol;
	wire  nlii1OO;
	wire  nliii0i;
	wire  nliii0l;
	wire  nliii0O;
	wire  nliii1i;
	wire  nliii1l;
	wire  nliii1O;
	wire  nliiiii;
	wire  nliiiil;
	wire  nliiiiO;
	wire  nliiili;
	wire  nliiill;
	wire  nliiilO;
	wire  nliiiOi;
	wire  nliiiOl;
	wire  nliiiOO;
	wire  nliil0i;
	wire  nliil0l;
	wire  nliil0O;
	wire  nliil1O;
	wire  nliilii;
	wire  nliilil;
	wire  nliiliO;
	wire  nliilli;
	wire  nliilll;
	wire  nliillO;
	wire  nliilOi;
	wire  nliilOl;
	wire  nliilOO;
	wire  nliiO0i;
	wire  nliiO0l;
	wire  nliiO0O;
	wire  nliiO1i;
	wire  nliiO1l;
	wire  nliiO1O;
	wire  nliiOii;
	wire  nliiOil;
	wire  nliiOiO;
	wire  nliiOli;
	wire  nliiOll;
	wire  nliiOlO;
	wire  nlil00i;
	wire  nlil00l;
	wire  nlil00O;
	wire  nlil01i;
	wire  nlil01O;
	wire  nlil0ii;
	wire  nlil0il;
	wire  nlil0iO;
	wire  nlil0lO;
	wire  nlil0Oi;
	wire  nlil10i;
	wire  nlil10l;
	wire  nlil10O;
	wire  nlil11i;
	wire  nlil11l;
	wire  nlil11O;
	wire  nlil1ii;
	wire  nlil1il;
	wire  nlil1iO;
	wire  nlil1li;
	wire  nlil1ll;
	wire  nlil1lO;
	wire  nlil1Oi;
	wire  nlil1Ol;
	wire  nlil1OO;
	wire  nlili0i;
	wire  nlili1i;
	wire  nlili1l;
	wire  nlili1O;
	wire  nliliii;
	wire  nliliil;
	wire  nliliiO;
	wire  nlilili;
	wire  nlill0O;
	wire  nlillii;
	wire  nlillil;
	wire  nlillOi;
	wire  nlillOl;
	wire  nlillOO;
	wire  nlilO0l;
	wire  nlilOil;
	wire  nlilOiO;
	wire  nliO10l;
	wire  nliO11i;
	wire  nliO1il;

	initial
		nli0O0O61 = 0;
	always @ ( posedge clk_2)
		  nli0O0O61 <= nli0O0O62;
	event nli0O0O61_event;
	initial
		#1 ->nli0O0O61_event;
	always @(nli0O0O61_event)
		nli0O0O61 <= {1{1'b1}};
	initial
		nli0O0O62 = 0;
	always @ ( posedge clk_2)
		  nli0O0O62 <= nli0O0O61;
	initial
		nliil1i59 = 0;
	always @ ( posedge clk_2)
		  nliil1i59 <= nliil1i60;
	event nliil1i59_event;
	initial
		#1 ->nliil1i59_event;
	always @(nliil1i59_event)
		nliil1i59 <= {1{1'b1}};
	initial
		nliil1i60 = 0;
	always @ ( posedge clk_2)
		  nliil1i60 <= nliil1i59;
	initial
		nliil1l57 = 0;
	always @ ( posedge clk_2)
		  nliil1l57 <= nliil1l58;
	event nliil1l57_event;
	initial
		#1 ->nliil1l57_event;
	always @(nliil1l57_event)
		nliil1l57 <= {1{1'b1}};
	initial
		nliil1l58 = 0;
	always @ ( posedge clk_2)
		  nliil1l58 <= nliil1l57;
	initial
		nliiOOi55 = 0;
	always @ ( posedge clk_2)
		  nliiOOi55 <= nliiOOi56;
	event nliiOOi55_event;
	initial
		#1 ->nliiOOi55_event;
	always @(nliiOOi55_event)
		nliiOOi55 <= {1{1'b1}};
	initial
		nliiOOi56 = 0;
	always @ ( posedge clk_2)
		  nliiOOi56 <= nliiOOi55;
	initial
		nliiOOl53 = 0;
	always @ ( posedge clk_2)
		  nliiOOl53 <= nliiOOl54;
	event nliiOOl53_event;
	initial
		#1 ->nliiOOl53_event;
	always @(nliiOOl53_event)
		nliiOOl53 <= {1{1'b1}};
	initial
		nliiOOl54 = 0;
	always @ ( posedge clk_2)
		  nliiOOl54 <= nliiOOl53;
	initial
		nliiOOO51 = 0;
	always @ ( posedge clk_2)
		  nliiOOO51 <= nliiOOO52;
	event nliiOOO51_event;
	initial
		#1 ->nliiOOO51_event;
	always @(nliiOOO51_event)
		nliiOOO51 <= {1{1'b1}};
	initial
		nliiOOO52 = 0;
	always @ ( posedge clk_2)
		  nliiOOO52 <= nliiOOO51;
	initial
		nlil01l49 = 0;
	always @ ( posedge clk_2)
		  nlil01l49 <= nlil01l50;
	event nlil01l49_event;
	initial
		#1 ->nlil01l49_event;
	always @(nlil01l49_event)
		nlil01l49 <= {1{1'b1}};
	initial
		nlil01l50 = 0;
	always @ ( posedge clk_2)
		  nlil01l50 <= nlil01l49;
	initial
		nlil0li47 = 0;
	always @ ( posedge clk_2)
		  nlil0li47 <= nlil0li48;
	event nlil0li47_event;
	initial
		#1 ->nlil0li47_event;
	always @(nlil0li47_event)
		nlil0li47 <= {1{1'b1}};
	initial
		nlil0li48 = 0;
	always @ ( posedge clk_2)
		  nlil0li48 <= nlil0li47;
	initial
		nlil0Ol45 = 0;
	always @ ( posedge clk_2)
		  nlil0Ol45 <= nlil0Ol46;
	event nlil0Ol45_event;
	initial
		#1 ->nlil0Ol45_event;
	always @(nlil0Ol45_event)
		nlil0Ol45 <= {1{1'b1}};
	initial
		nlil0Ol46 = 0;
	always @ ( posedge clk_2)
		  nlil0Ol46 <= nlil0Ol45;
	initial
		nlili0l43 = 0;
	always @ ( posedge clk_2)
		  nlili0l43 <= nlili0l44;
	event nlili0l43_event;
	initial
		#1 ->nlili0l43_event;
	always @(nlili0l43_event)
		nlili0l43 <= {1{1'b1}};
	initial
		nlili0l44 = 0;
	always @ ( posedge clk_2)
		  nlili0l44 <= nlili0l43;
	initial
		nlilill41 = 0;
	always @ ( posedge clk_2)
		  nlilill41 <= nlilill42;
	event nlilill41_event;
	initial
		#1 ->nlilill41_event;
	always @(nlilill41_event)
		nlilill41 <= {1{1'b1}};
	initial
		nlilill42 = 0;
	always @ ( posedge clk_2)
		  nlilill42 <= nlilill41;
	initial
		nlililO39 = 0;
	always @ ( posedge clk_2)
		  nlililO39 <= nlililO40;
	event nlililO39_event;
	initial
		#1 ->nlililO39_event;
	always @(nlililO39_event)
		nlililO39 <= {1{1'b1}};
	initial
		nlililO40 = 0;
	always @ ( posedge clk_2)
		  nlililO40 <= nlililO39;
	initial
		nliliOi37 = 0;
	always @ ( posedge clk_2)
		  nliliOi37 <= nliliOi38;
	event nliliOi37_event;
	initial
		#1 ->nliliOi37_event;
	always @(nliliOi37_event)
		nliliOi37 <= {1{1'b1}};
	initial
		nliliOi38 = 0;
	always @ ( posedge clk_2)
		  nliliOi38 <= nliliOi37;
	initial
		nliliOl35 = 0;
	always @ ( posedge clk_2)
		  nliliOl35 <= nliliOl36;
	event nliliOl35_event;
	initial
		#1 ->nliliOl35_event;
	always @(nliliOl35_event)
		nliliOl35 <= {1{1'b1}};
	initial
		nliliOl36 = 0;
	always @ ( posedge clk_2)
		  nliliOl36 <= nliliOl35;
	initial
		nliliOO33 = 0;
	always @ ( posedge clk_2)
		  nliliOO33 <= nliliOO34;
	event nliliOO33_event;
	initial
		#1 ->nliliOO33_event;
	always @(nliliOO33_event)
		nliliOO33 <= {1{1'b1}};
	initial
		nliliOO34 = 0;
	always @ ( posedge clk_2)
		  nliliOO34 <= nliliOO33;
	initial
		nlill0l25 = 0;
	always @ ( posedge clk_2)
		  nlill0l25 <= nlill0l26;
	event nlill0l25_event;
	initial
		#1 ->nlill0l25_event;
	always @(nlill0l25_event)
		nlill0l25 <= {1{1'b1}};
	initial
		nlill0l26 = 0;
	always @ ( posedge clk_2)
		  nlill0l26 <= nlill0l25;
	initial
		nlill1i31 = 0;
	always @ ( posedge clk_2)
		  nlill1i31 <= nlill1i32;
	event nlill1i31_event;
	initial
		#1 ->nlill1i31_event;
	always @(nlill1i31_event)
		nlill1i31 <= {1{1'b1}};
	initial
		nlill1i32 = 0;
	always @ ( posedge clk_2)
		  nlill1i32 <= nlill1i31;
	initial
		nlill1l29 = 0;
	always @ ( posedge clk_2)
		  nlill1l29 <= nlill1l30;
	event nlill1l29_event;
	initial
		#1 ->nlill1l29_event;
	always @(nlill1l29_event)
		nlill1l29 <= {1{1'b1}};
	initial
		nlill1l30 = 0;
	always @ ( posedge clk_2)
		  nlill1l30 <= nlill1l29;
	initial
		nlill1O27 = 0;
	always @ ( posedge clk_2)
		  nlill1O27 <= nlill1O28;
	event nlill1O27_event;
	initial
		#1 ->nlill1O27_event;
	always @(nlill1O27_event)
		nlill1O27 <= {1{1'b1}};
	initial
		nlill1O28 = 0;
	always @ ( posedge clk_2)
		  nlill1O28 <= nlill1O27;
	initial
		nlilliO23 = 0;
	always @ ( posedge clk_2)
		  nlilliO23 <= nlilliO24;
	event nlilliO23_event;
	initial
		#1 ->nlilliO23_event;
	always @(nlilliO23_event)
		nlilliO23 <= {1{1'b1}};
	initial
		nlilliO24 = 0;
	always @ ( posedge clk_2)
		  nlilliO24 <= nlilliO23;
	initial
		nlillll21 = 0;
	always @ ( posedge clk_2)
		  nlillll21 <= nlillll22;
	event nlillll21_event;
	initial
		#1 ->nlillll21_event;
	always @(nlillll21_event)
		nlillll21 <= {1{1'b1}};
	initial
		nlillll22 = 0;
	always @ ( posedge clk_2)
		  nlillll22 <= nlillll21;
	initial
		nlilO0O15 = 0;
	always @ ( posedge clk_2)
		  nlilO0O15 <= nlilO0O16;
	event nlilO0O15_event;
	initial
		#1 ->nlilO0O15_event;
	always @(nlilO0O15_event)
		nlilO0O15 <= {1{1'b1}};
	initial
		nlilO0O16 = 0;
	always @ ( posedge clk_2)
		  nlilO0O16 <= nlilO0O15;
	initial
		nlilO1i19 = 0;
	always @ ( posedge clk_2)
		  nlilO1i19 <= nlilO1i20;
	event nlilO1i19_event;
	initial
		#1 ->nlilO1i19_event;
	always @(nlilO1i19_event)
		nlilO1i19 <= {1{1'b1}};
	initial
		nlilO1i20 = 0;
	always @ ( posedge clk_2)
		  nlilO1i20 <= nlilO1i19;
	initial
		nlilO1O17 = 0;
	always @ ( posedge clk_2)
		  nlilO1O17 <= nlilO1O18;
	event nlilO1O17_event;
	initial
		#1 ->nlilO1O17_event;
	always @(nlilO1O17_event)
		nlilO1O17 <= {1{1'b1}};
	initial
		nlilO1O18 = 0;
	always @ ( posedge clk_2)
		  nlilO1O18 <= nlilO1O17;
	initial
		nlilOli13 = 0;
	always @ ( posedge clk_2)
		  nlilOli13 <= nlilOli14;
	event nlilOli13_event;
	initial
		#1 ->nlilOli13_event;
	always @(nlilOli13_event)
		nlilOli13 <= {1{1'b1}};
	initial
		nlilOli14 = 0;
	always @ ( posedge clk_2)
		  nlilOli14 <= nlilOli13;
	initial
		nlilOlO11 = 0;
	always @ ( posedge clk_2)
		  nlilOlO11 <= nlilOlO12;
	event nlilOlO11_event;
	initial
		#1 ->nlilOlO11_event;
	always @(nlilOlO11_event)
		nlilOlO11 <= {1{1'b1}};
	initial
		nlilOlO12 = 0;
	always @ ( posedge clk_2)
		  nlilOlO12 <= nlilOlO11;
	initial
		nlilOOl10 = 0;
	always @ ( posedge clk_2)
		  nlilOOl10 <= nlilOOl9;
	initial
		nlilOOl9 = 0;
	always @ ( posedge clk_2)
		  nlilOOl9 <= nlilOOl10;
	event nlilOOl9_event;
	initial
		#1 ->nlilOOl9_event;
	always @(nlilOOl9_event)
		nlilOOl9 <= {1{1'b1}};
	initial
		nlilOOO7 = 0;
	always @ ( posedge clk_2)
		  nlilOOO7 <= nlilOOO8;
	event nlilOOO7_event;
	initial
		#1 ->nlilOOO7_event;
	always @(nlilOOO7_event)
		nlilOOO7 <= {1{1'b1}};
	initial
		nlilOOO8 = 0;
	always @ ( posedge clk_2)
		  nlilOOO8 <= nlilOOO7;
	initial
		nliO10i3 = 0;
	always @ ( posedge clk_2)
		  nliO10i3 <= nliO10i4;
	event nliO10i3_event;
	initial
		#1 ->nliO10i3_event;
	always @(nliO10i3_event)
		nliO10i3 <= {1{1'b1}};
	initial
		nliO10i4 = 0;
	always @ ( posedge clk_2)
		  nliO10i4 <= nliO10i3;
	initial
		nliO11l5 = 0;
	always @ ( posedge clk_2)
		  nliO11l5 <= nliO11l6;
	event nliO11l5_event;
	initial
		#1 ->nliO11l5_event;
	always @(nliO11l5_event)
		nliO11l5 <= {1{1'b1}};
	initial
		nliO11l6 = 0;
	always @ ( posedge clk_2)
		  nliO11l6 <= nliO11l5;
	initial
		nliO1iO1 = 0;
	always @ ( posedge clk_2)
		  nliO1iO1 <= nliO1iO2;
	event nliO1iO1_event;
	initial
		#1 ->nliO1iO1_event;
	always @(nliO1iO1_event)
		nliO1iO1 <= {1{1'b1}};
	initial
		nliO1iO2 = 0;
	always @ ( posedge clk_2)
		  nliO1iO2 <= nliO1iO1;
	initial
	begin
		n0111i = 0;
		n0111l = 0;
		n1000i = 0;
		n1000l = 0;
		n1000O = 0;
		n1001i = 0;
		n1001l = 0;
		n1001O = 0;
		n100ii = 0;
		n100il = 0;
		n100li = 0;
		n100ll = 0;
		n100lO = 0;
		n100Oi = 0;
		n100Ol = 0;
		n100OO = 0;
		n101Ol = 0;
		n101OO = 0;
		n10i0i = 0;
		n10i0l = 0;
		n10i0O = 0;
		n10i1i = 0;
		n10i1l = 0;
		n10i1O = 0;
		n10iii = 0;
		n10iil = 0;
		n10iiO = 0;
		n10ili = 0;
		n10ill = 0;
		n10ilO = 0;
		n10iOl = 0;
		n10iOO = 0;
		n10l0i = 0;
		n10l0l = 0;
		n10l0O = 0;
		n10l1i = 0;
		n10l1l = 0;
		n10l1O = 0;
		n10lii = 0;
		n10lil = 0;
		n10liO = 0;
		n10lli = 0;
		n10lll = 0;
		n10llO = 0;
		n10lOi = 0;
		n10lOl = 0;
		n10lOO = 0;
		n10O1i = 0;
		n10O1l = 0;
		n10O1O = 0;
		n110iO = 0;
		n110li = 0;
		n110ll = 0;
		n110lO = 0;
		n11iil = 0;
		n11iiO = 0;
		n11ili = 0;
		n11ill = 0;
		n11ilO = 0;
		n11iOi = 0;
		n11iOl = 0;
		n11iOO = 0;
		n11O0i = 0;
		n11O0l = 0;
		n11O0O = 0;
		n11O1i = 0;
		n11O1l = 0;
		n11O1O = 0;
		n1l = 0;
		n1liil = 0;
		n1liiO = 0;
		n1lili = 0;
		n1ll1i = 0;
		n1ll1l = 0;
		n1O00i = 0;
		n1O00l = 0;
		n1O01l = 0;
		n1O01O = 0;
		ni0OOi = 0;
		ni0OOl = 0;
		ni0OOO = 0;
		nii00i = 0;
		nii00l = 0;
		nii00O = 0;
		nii01i = 0;
		nii01l = 0;
		nii01O = 0;
		nii0ii = 0;
		nii0il = 0;
		nii0iO = 0;
		nii0ll = 0;
		nii0Ol = 0;
		nii0OO = 0;
		nii10i = 0;
		nii10l = 0;
		nii10O = 0;
		nii11i = 0;
		nii11l = 0;
		nii11O = 0;
		nii1ii = 0;
		nii1il = 0;
		nii1iO = 0;
		nii1li = 0;
		nii1ll = 0;
		nii1lO = 0;
		nii1Oi = 0;
		nii1Ol = 0;
		nii1OO = 0;
		niii1i = 0;
		niOlOl = 0;
		niOlOO = 0;
		niOO0i = 0;
		niOO0l = 0;
		niOO0O = 0;
		niOO1i = 0;
		niOO1l = 0;
		niOO1O = 0;
		niOOii = 0;
		niOOil = 0;
		niOOli = 0;
		niOOll = 0;
		niOOlO = 0;
		niOOOi = 0;
		niOOOl = 0;
		niOOOO = 0;
		nl100i = 0;
		nl100l = 0;
		nl100O = 0;
		nl101i = 0;
		nl101l = 0;
		nl101O = 0;
		nl10ii = 0;
		nl10il = 0;
		nl10iO = 0;
		nl10li = 0;
		nl10ll = 0;
		nl10lO = 0;
		nl10Oi = 0;
		nl10Ol = 0;
		nl10OO = 0;
		nl110i = 0;
		nl110l = 0;
		nl110O = 0;
		nl111i = 0;
		nl111l = 0;
		nl111O = 0;
		nl11ii = 0;
		nl11il = 0;
		nl11iO = 0;
		nl11li = 0;
		nl11ll = 0;
		nl11lO = 0;
		nl11OO = 0;
		nl1i0i = 0;
		nl1i1i = 0;
		nl1i1l = 0;
		nl1i1O = 0;
		nli0il = 0;
		nli0Ol = 0;
		nli0OO = 0;
		nli1ll = 0;
		nli1lO = 0;
		nli1Oi = 0;
		nli1Ol = 0;
		nlii0i = 0;
		nlii0l = 0;
		nlii0O = 0;
		nlii1i = 0;
		nlii1l = 0;
		nliilO = 0;
		nliiOi = 0;
		nlil0i = 0;
		nlil0l = 0;
		nlil0O = 0;
		nlil1O = 0;
		nlilOl = 0;
		nliO01l = 0;
		nliO01O = 0;
		nliO1i = 0;
		nlll = 0;
		nlO00OO = 0;
		nlOi1iO = 0;
		nlOiO0i = 0;
		nlOiO0l = 0;
		nlOiO0O = 0;
		nlOiO1O = 0;
		nlOiOii = 0;
		nlOl0OO = 0;
		nlOli0i = 0;
		nlOli0l = 0;
		nlOli0O = 0;
		nlOli1i = 0;
		nlOli1l = 0;
		nlOli1O = 0;
		nlOliii = 0;
		nlOliil = 0;
		nlOliiO = 0;
		nlOlili = 0;
		nlOlilO = 0;
		nlOliOO = 0;
		nlOll1i = 0;
		nlOll1l = 0;
	end
	always @ (clk_2 or wire_n1i_PRN or wire_n1i_CLRN)
	begin
		if (wire_n1i_PRN == 1'b0) 
		begin
			n0111i <= 1;
			n0111l <= 1;
			n1000i <= 1;
			n1000l <= 1;
			n1000O <= 1;
			n1001i <= 1;
			n1001l <= 1;
			n1001O <= 1;
			n100ii <= 1;
			n100il <= 1;
			n100li <= 1;
			n100ll <= 1;
			n100lO <= 1;
			n100Oi <= 1;
			n100Ol <= 1;
			n100OO <= 1;
			n101Ol <= 1;
			n101OO <= 1;
			n10i0i <= 1;
			n10i0l <= 1;
			n10i0O <= 1;
			n10i1i <= 1;
			n10i1l <= 1;
			n10i1O <= 1;
			n10iii <= 1;
			n10iil <= 1;
			n10iiO <= 1;
			n10ili <= 1;
			n10ill <= 1;
			n10ilO <= 1;
			n10iOl <= 1;
			n10iOO <= 1;
			n10l0i <= 1;
			n10l0l <= 1;
			n10l0O <= 1;
			n10l1i <= 1;
			n10l1l <= 1;
			n10l1O <= 1;
			n10lii <= 1;
			n10lil <= 1;
			n10liO <= 1;
			n10lli <= 1;
			n10lll <= 1;
			n10llO <= 1;
			n10lOi <= 1;
			n10lOl <= 1;
			n10lOO <= 1;
			n10O1i <= 1;
			n10O1l <= 1;
			n10O1O <= 1;
			n110iO <= 1;
			n110li <= 1;
			n110ll <= 1;
			n110lO <= 1;
			n11iil <= 1;
			n11iiO <= 1;
			n11ili <= 1;
			n11ill <= 1;
			n11ilO <= 1;
			n11iOi <= 1;
			n11iOl <= 1;
			n11iOO <= 1;
			n11O0i <= 1;
			n11O0l <= 1;
			n11O0O <= 1;
			n11O1i <= 1;
			n11O1l <= 1;
			n11O1O <= 1;
			n1l <= 1;
			n1liil <= 1;
			n1liiO <= 1;
			n1lili <= 1;
			n1ll1i <= 1;
			n1ll1l <= 1;
			n1O00i <= 1;
			n1O00l <= 1;
			n1O01l <= 1;
			n1O01O <= 1;
			ni0OOi <= 1;
			ni0OOl <= 1;
			ni0OOO <= 1;
			nii00i <= 1;
			nii00l <= 1;
			nii00O <= 1;
			nii01i <= 1;
			nii01l <= 1;
			nii01O <= 1;
			nii0ii <= 1;
			nii0il <= 1;
			nii0iO <= 1;
			nii0ll <= 1;
			nii0Ol <= 1;
			nii0OO <= 1;
			nii10i <= 1;
			nii10l <= 1;
			nii10O <= 1;
			nii11i <= 1;
			nii11l <= 1;
			nii11O <= 1;
			nii1ii <= 1;
			nii1il <= 1;
			nii1iO <= 1;
			nii1li <= 1;
			nii1ll <= 1;
			nii1lO <= 1;
			nii1Oi <= 1;
			nii1Ol <= 1;
			nii1OO <= 1;
			niii1i <= 1;
			niOlOl <= 1;
			niOlOO <= 1;
			niOO0i <= 1;
			niOO0l <= 1;
			niOO0O <= 1;
			niOO1i <= 1;
			niOO1l <= 1;
			niOO1O <= 1;
			niOOii <= 1;
			niOOil <= 1;
			niOOli <= 1;
			niOOll <= 1;
			niOOlO <= 1;
			niOOOi <= 1;
			niOOOl <= 1;
			niOOOO <= 1;
			nl100i <= 1;
			nl100l <= 1;
			nl100O <= 1;
			nl101i <= 1;
			nl101l <= 1;
			nl101O <= 1;
			nl10ii <= 1;
			nl10il <= 1;
			nl10iO <= 1;
			nl10li <= 1;
			nl10ll <= 1;
			nl10lO <= 1;
			nl10Oi <= 1;
			nl10Ol <= 1;
			nl10OO <= 1;
			nl110i <= 1;
			nl110l <= 1;
			nl110O <= 1;
			nl111i <= 1;
			nl111l <= 1;
			nl111O <= 1;
			nl11ii <= 1;
			nl11il <= 1;
			nl11iO <= 1;
			nl11li <= 1;
			nl11ll <= 1;
			nl11lO <= 1;
			nl11OO <= 1;
			nl1i0i <= 1;
			nl1i1i <= 1;
			nl1i1l <= 1;
			nl1i1O <= 1;
			nli0il <= 1;
			nli0Ol <= 1;
			nli0OO <= 1;
			nli1ll <= 1;
			nli1lO <= 1;
			nli1Oi <= 1;
			nli1Ol <= 1;
			nlii0i <= 1;
			nlii0l <= 1;
			nlii0O <= 1;
			nlii1i <= 1;
			nlii1l <= 1;
			nliilO <= 1;
			nliiOi <= 1;
			nlil0i <= 1;
			nlil0l <= 1;
			nlil0O <= 1;
			nlil1O <= 1;
			nlilOl <= 1;
			nliO01l <= 1;
			nliO01O <= 1;
			nliO1i <= 1;
			nlll <= 1;
			nlO00OO <= 1;
			nlOi1iO <= 1;
			nlOiO0i <= 1;
			nlOiO0l <= 1;
			nlOiO0O <= 1;
			nlOiO1O <= 1;
			nlOiOii <= 1;
			nlOl0OO <= 1;
			nlOli0i <= 1;
			nlOli0l <= 1;
			nlOli0O <= 1;
			nlOli1i <= 1;
			nlOli1l <= 1;
			nlOli1O <= 1;
			nlOliii <= 1;
			nlOliil <= 1;
			nlOliiO <= 1;
			nlOlili <= 1;
			nlOlilO <= 1;
			nlOliOO <= 1;
			nlOll1i <= 1;
			nlOll1l <= 1;
		end
		else if  (wire_n1i_CLRN == 1'b0) 
		begin
			n0111i <= 0;
			n0111l <= 0;
			n1000i <= 0;
			n1000l <= 0;
			n1000O <= 0;
			n1001i <= 0;
			n1001l <= 0;
			n1001O <= 0;
			n100ii <= 0;
			n100il <= 0;
			n100li <= 0;
			n100ll <= 0;
			n100lO <= 0;
			n100Oi <= 0;
			n100Ol <= 0;
			n100OO <= 0;
			n101Ol <= 0;
			n101OO <= 0;
			n10i0i <= 0;
			n10i0l <= 0;
			n10i0O <= 0;
			n10i1i <= 0;
			n10i1l <= 0;
			n10i1O <= 0;
			n10iii <= 0;
			n10iil <= 0;
			n10iiO <= 0;
			n10ili <= 0;
			n10ill <= 0;
			n10ilO <= 0;
			n10iOl <= 0;
			n10iOO <= 0;
			n10l0i <= 0;
			n10l0l <= 0;
			n10l0O <= 0;
			n10l1i <= 0;
			n10l1l <= 0;
			n10l1O <= 0;
			n10lii <= 0;
			n10lil <= 0;
			n10liO <= 0;
			n10lli <= 0;
			n10lll <= 0;
			n10llO <= 0;
			n10lOi <= 0;
			n10lOl <= 0;
			n10lOO <= 0;
			n10O1i <= 0;
			n10O1l <= 0;
			n10O1O <= 0;
			n110iO <= 0;
			n110li <= 0;
			n110ll <= 0;
			n110lO <= 0;
			n11iil <= 0;
			n11iiO <= 0;
			n11ili <= 0;
			n11ill <= 0;
			n11ilO <= 0;
			n11iOi <= 0;
			n11iOl <= 0;
			n11iOO <= 0;
			n11O0i <= 0;
			n11O0l <= 0;
			n11O0O <= 0;
			n11O1i <= 0;
			n11O1l <= 0;
			n11O1O <= 0;
			n1l <= 0;
			n1liil <= 0;
			n1liiO <= 0;
			n1lili <= 0;
			n1ll1i <= 0;
			n1ll1l <= 0;
			n1O00i <= 0;
			n1O00l <= 0;
			n1O01l <= 0;
			n1O01O <= 0;
			ni0OOi <= 0;
			ni0OOl <= 0;
			ni0OOO <= 0;
			nii00i <= 0;
			nii00l <= 0;
			nii00O <= 0;
			nii01i <= 0;
			nii01l <= 0;
			nii01O <= 0;
			nii0ii <= 0;
			nii0il <= 0;
			nii0iO <= 0;
			nii0ll <= 0;
			nii0Ol <= 0;
			nii0OO <= 0;
			nii10i <= 0;
			nii10l <= 0;
			nii10O <= 0;
			nii11i <= 0;
			nii11l <= 0;
			nii11O <= 0;
			nii1ii <= 0;
			nii1il <= 0;
			nii1iO <= 0;
			nii1li <= 0;
			nii1ll <= 0;
			nii1lO <= 0;
			nii1Oi <= 0;
			nii1Ol <= 0;
			nii1OO <= 0;
			niii1i <= 0;
			niOlOl <= 0;
			niOlOO <= 0;
			niOO0i <= 0;
			niOO0l <= 0;
			niOO0O <= 0;
			niOO1i <= 0;
			niOO1l <= 0;
			niOO1O <= 0;
			niOOii <= 0;
			niOOil <= 0;
			niOOli <= 0;
			niOOll <= 0;
			niOOlO <= 0;
			niOOOi <= 0;
			niOOOl <= 0;
			niOOOO <= 0;
			nl100i <= 0;
			nl100l <= 0;
			nl100O <= 0;
			nl101i <= 0;
			nl101l <= 0;
			nl101O <= 0;
			nl10ii <= 0;
			nl10il <= 0;
			nl10iO <= 0;
			nl10li <= 0;
			nl10ll <= 0;
			nl10lO <= 0;
			nl10Oi <= 0;
			nl10Ol <= 0;
			nl10OO <= 0;
			nl110i <= 0;
			nl110l <= 0;
			nl110O <= 0;
			nl111i <= 0;
			nl111l <= 0;
			nl111O <= 0;
			nl11ii <= 0;
			nl11il <= 0;
			nl11iO <= 0;
			nl11li <= 0;
			nl11ll <= 0;
			nl11lO <= 0;
			nl11OO <= 0;
			nl1i0i <= 0;
			nl1i1i <= 0;
			nl1i1l <= 0;
			nl1i1O <= 0;
			nli0il <= 0;
			nli0Ol <= 0;
			nli0OO <= 0;
			nli1ll <= 0;
			nli1lO <= 0;
			nli1Oi <= 0;
			nli1Ol <= 0;
			nlii0i <= 0;
			nlii0l <= 0;
			nlii0O <= 0;
			nlii1i <= 0;
			nlii1l <= 0;
			nliilO <= 0;
			nliiOi <= 0;
			nlil0i <= 0;
			nlil0l <= 0;
			nlil0O <= 0;
			nlil1O <= 0;
			nlilOl <= 0;
			nliO01l <= 0;
			nliO01O <= 0;
			nliO1i <= 0;
			nlll <= 0;
			nlO00OO <= 0;
			nlOi1iO <= 0;
			nlOiO0i <= 0;
			nlOiO0l <= 0;
			nlOiO0O <= 0;
			nlOiO1O <= 0;
			nlOiOii <= 0;
			nlOl0OO <= 0;
			nlOli0i <= 0;
			nlOli0l <= 0;
			nlOli0O <= 0;
			nlOli1i <= 0;
			nlOli1l <= 0;
			nlOli1O <= 0;
			nlOliii <= 0;
			nlOliil <= 0;
			nlOliiO <= 0;
			nlOlili <= 0;
			nlOlilO <= 0;
			nlOliOO <= 0;
			nlOll1i <= 0;
			nlOll1l <= 0;
		end
		else 
		if (clk_2 != n1i_clk_prev && clk_2 == 1'b1) 
		begin
			n0111i <= wire_n0110i_dataout;
			n0111l <= wire_n0110l_dataout;
			n1000i <= wire_n10Oli_dataout;
			n1000l <= wire_n10Oll_dataout;
			n1000O <= wire_n10OlO_dataout;
			n1001i <= wire_n10Oii_dataout;
			n1001l <= wire_n10Oil_dataout;
			n1001O <= wire_n10OiO_dataout;
			n100ii <= wire_n10OOi_dataout;
			n100il <= wire_n10OOl_dataout;
			n100li <= wire_n1i11i_dataout;
			n100ll <= wire_n1i11l_dataout;
			n100lO <= wire_n1i11O_dataout;
			n100Oi <= wire_n1i10i_dataout;
			n100Ol <= wire_n1i10l_dataout;
			n100OO <= wire_n1i10O_dataout;
			n101Ol <= wire_n10O0l_dataout;
			n101OO <= wire_n10O0O_dataout;
			n10i0i <= wire_n1i1li_dataout;
			n10i0l <= wire_n1i1ll_dataout;
			n10i0O <= wire_n1i1lO_dataout;
			n10i1i <= wire_n1i1ii_dataout;
			n10i1l <= wire_n1i1il_dataout;
			n10i1O <= wire_n1i1iO_dataout;
			n10iii <= wire_n1i1Oi_dataout;
			n10iil <= wire_n1i1Ol_dataout;
			n10iiO <= wire_n1i1OO_dataout;
			n10ili <= wire_n1i01i_dataout;
			n10ill <= wire_n1i01l_dataout;
			n10ilO <= wire_n1i01O_dataout;
			n10iOl <= wire_n1i00l_dataout;
			n10iOO <= wire_n1i00O_dataout;
			n10l0i <= wire_n1i0li_dataout;
			n10l0l <= wire_n1i0ll_dataout;
			n10l0O <= wire_n1i0lO_dataout;
			n10l1i <= wire_n1i0ii_dataout;
			n10l1l <= wire_n1i0il_dataout;
			n10l1O <= wire_n1i0iO_dataout;
			n10lii <= wire_n1i0Oi_dataout;
			n10lil <= wire_n1i0Ol_dataout;
			n10liO <= wire_n1i0OO_dataout;
			n10lli <= wire_n1ii1i_dataout;
			n10lll <= wire_n1ii1l_dataout;
			n10llO <= wire_n1ii1O_dataout;
			n10lOi <= wire_n1ii0i_dataout;
			n10lOl <= wire_n1ii0l_dataout;
			n10lOO <= wire_n1ii0O_dataout;
			n10O1i <= wire_n1iiii_dataout;
			n10O1l <= wire_n1iiil_dataout;
			n10O1O <= wire_n1lill_dataout;
			n110iO <= n110ll;
			n110li <= wire_n110Oi_dataout;
			n110ll <= wire_n110Ol_dataout;
			n110lO <= wire_n11l1i_dataout;
			n11iil <= wire_n11l1l_dataout;
			n11iiO <= wire_n11l1O_dataout;
			n11ili <= wire_n11l0i_dataout;
			n11ill <= wire_n11l0l_dataout;
			n11ilO <= wire_n11l0O_dataout;
			n11iOi <= wire_n11lii_dataout;
			n11iOl <= wire_n11lil_dataout;
			n11iOO <= wire_n101iO_dataout;
			n11O0i <= wire_n11Oil_dataout;
			n11O0l <= wire_n11OiO_dataout;
			n11O0O <= wire_n10O0i_dataout;
			n11O1i <= wire_n101ll_dataout;
			n11O1l <= wire_n101li_dataout;
			n11O1O <= wire_n11Oii_dataout;
			n1l <= wire_niO_dataout;
			n1liil <= wire_n1lilO_dataout;
			n1liiO <= wire_n1liOi_dataout;
			n1lili <= n1ll1i;
			n1ll1i <= ((~ rgenericfifo) & nlO1Oii);
			n1ll1l <= wire_n1O0il_dataout;
			n1O00i <= wire_n1O0ll_dataout;
			n1O00l <= wire_n1O0lO_dataout;
			n1O01l <= wire_n1O0iO_dataout;
			n1O01O <= wire_n1O0li_dataout;
			ni0OOi <= wire_niii1l_dataout;
			ni0OOl <= wire_niii1O_dataout;
			ni0OOO <= wire_niii0i_dataout;
			nii00i <= wire_niilil_dataout;
			nii00l <= wire_niiliO_dataout;
			nii00O <= wire_niilli_dataout;
			nii01i <= wire_niil0l_dataout;
			nii01l <= wire_niil0O_dataout;
			nii01O <= wire_niilii_dataout;
			nii0ii <= wire_niilll_dataout;
			nii0il <= wire_niillO_dataout;
			nii0iO <= wire_niilOi_dataout;
			nii0ll <= wire_niilOl_dataout;
			nii0Ol <= wire_niilOO_dataout;
			nii0OO <= wire_niiO1i_dataout;
			nii10i <= wire_niiiil_dataout;
			nii10l <= wire_niiiiO_dataout;
			nii10O <= wire_niiili_dataout;
			nii11i <= wire_niii0l_dataout;
			nii11l <= wire_niii0O_dataout;
			nii11O <= wire_niiiii_dataout;
			nii1ii <= wire_niiill_dataout;
			nii1il <= wire_niiilO_dataout;
			nii1iO <= wire_niiiOi_dataout;
			nii1li <= wire_niiiOl_dataout;
			nii1ll <= wire_niiiOO_dataout;
			nii1lO <= wire_niil1i_dataout;
			nii1Oi <= wire_niil1l_dataout;
			nii1Ol <= wire_niil1O_dataout;
			nii1OO <= wire_niil0i_dataout;
			niii1i <= wire_nl1i0l_dataout;
			niOlOl <= wire_nl1i0O_dataout;
			niOlOO <= wire_nl1iii_dataout;
			niOO0i <= wire_nl1ill_dataout;
			niOO0l <= wire_nl1ilO_dataout;
			niOO0O <= wire_nl1iOi_dataout;
			niOO1i <= wire_nl1iil_dataout;
			niOO1l <= wire_nl1iiO_dataout;
			niOO1O <= wire_nl1ili_dataout;
			niOOii <= wire_nl1iOl_dataout;
			niOOil <= wire_nl1iOO_dataout;
			niOOli <= wire_nl1l1l_dataout;
			niOOll <= wire_nl1l1O_dataout;
			niOOlO <= wire_nl1l0i_dataout;
			niOOOi <= wire_nl1l0l_dataout;
			niOOOl <= wire_nl1l0O_dataout;
			niOOOO <= wire_nl1lii_dataout;
			nl100i <= wire_nl1Oli_dataout;
			nl100l <= wire_nl1Oll_dataout;
			nl100O <= wire_nl1OlO_dataout;
			nl101i <= wire_nl1Oii_dataout;
			nl101l <= wire_nl1Oil_dataout;
			nl101O <= wire_nl1OiO_dataout;
			nl10ii <= wire_nl1OOi_dataout;
			nl10il <= wire_nl1OOl_dataout;
			nl10iO <= wire_nl1OOO_dataout;
			nl10li <= wire_nl011i_dataout;
			nl10ll <= wire_nl011l_dataout;
			nl10lO <= wire_nl011O_dataout;
			nl10Oi <= wire_nl010i_dataout;
			nl10Ol <= wire_nl010l_dataout;
			nl10OO <= wire_nl010O_dataout;
			nl110i <= wire_nl1lll_dataout;
			nl110l <= wire_nl1llO_dataout;
			nl110O <= wire_nl1lOi_dataout;
			nl111i <= wire_nl1lil_dataout;
			nl111l <= wire_nl1liO_dataout;
			nl111O <= wire_nl1lli_dataout;
			nl11ii <= wire_nl1lOl_dataout;
			nl11il <= wire_nl1lOO_dataout;
			nl11iO <= wire_nl1O1i_dataout;
			nl11li <= wire_nl1O1l_dataout;
			nl11ll <= wire_nl1O1O_dataout;
			nl11lO <= wire_nl1O0i_dataout;
			nl11OO <= wire_nl1O0O_dataout;
			nl1i0i <= wire_nli01O_dataout;
			nl1i1i <= wire_nl01ii_dataout;
			nl1i1l <= wire_nl01il_dataout;
			nl1i1O <= wire_nl01iO_dataout;
			nli0il <= nli0Ol;
			nli0Ol <= (rgenericfifo & rdenable);
			nli0OO <= nlii1i;
			nli1ll <= wire_nli00i_dataout;
			nli1lO <= wire_nli00l_dataout;
			nli1Oi <= wire_nli00O_dataout;
			nli1Ol <= wire_nli0ii_dataout;
			nlii0i <= wire_nliiil_dataout;
			nlii0l <= wire_nliiiO_dataout;
			nlii0O <= nliilO;
			nlii1i <= sync_status;
			nlii1l <= wire_nliiii_dataout;
			nliilO <= ((~ rgenericfifo) & n0Ol0O);
			nliiOi <= nlil1O;
			nlil0i <= wire_nlilii_dataout;
			nlil0l <= wire_nlilil_dataout;
			nlil0O <= wire_nlilOO_dataout;
			nlil1O <= nlil0l;
			nlilOl <= wire_nliO0i_dataout;
			nliO01l <= wire_nliO00l_dataout;
			nliO01O <= wire_nliO00O_dataout;
			nliO1i <= wire_nliO1O_dataout;
			nlll <= n1l;
			nlO00OO <= wire_nlOi1li_dataout;
			nlOi1iO <= nlOiO1O;
			nlOiO0i <= nlOiO0l;
			nlOiO0l <= sync_status;
			nlOiO0O <= nlOiOii;
			nlOiO1O <= (rgenericfifo & rdenable);
			nlOiOii <= align_status;
			nlOl0OO <= wire_nlOll1O_dataout;
			nlOli0i <= wire_nlOllii_dataout;
			nlOli0l <= wire_nlOllil_dataout;
			nlOli0O <= wire_nlOlliO_dataout;
			nlOli1i <= wire_nlOll0i_dataout;
			nlOli1l <= wire_nlOll0l_dataout;
			nlOli1O <= wire_nlOll0O_dataout;
			nlOliii <= wire_nlOllli_dataout;
			nlOliil <= wire_nlOllll_dataout;
			nlOliiO <= wire_nlOlllO_dataout;
			nlOlili <= wire_nlOllOi_dataout;
			nlOlilO <= wire_nlOllOl_dataout;
			nlOliOO <= wire_nlOllOO_dataout;
			nlOll1i <= wire_nlOlO1i_dataout;
			nlOll1l <= n110iO;
		end
		n1i_clk_prev <= clk_2;
	end
	assign
		wire_n1i_CLRN = ((nlilOOO8 ^ nlilOOO7) & (~ nliO1il)),
		wire_n1i_PRN = (nlilOOl10 ^ nlilOOl9);
	initial
	begin
		n0l0iO = 0;
		ni11ll = 0;
		ni11lO = 0;
		ni11Ol = 0;
		nlliiOO = 0;
		nllil1i = 0;
		nllil1l = 0;
		nlllO0l = 0;
	end
	always @ (clk_1 or wire_ni11Oi_PRN or wire_ni11Oi_CLRN)
	begin
		if (wire_ni11Oi_PRN == 1'b0) 
		begin
			n0l0iO <= 1;
			ni11ll <= 1;
			ni11lO <= 1;
			ni11Ol <= 1;
			nlliiOO <= 1;
			nllil1i <= 1;
			nllil1l <= 1;
			nlllO0l <= 1;
		end
		else if  (wire_ni11Oi_CLRN == 1'b0) 
		begin
			n0l0iO <= 0;
			ni11ll <= 0;
			ni11lO <= 0;
			ni11Ol <= 0;
			nlliiOO <= 0;
			nllil1i <= 0;
			nllil1l <= 0;
			nlllO0l <= 0;
		end
		else 
		if (clk_1 != ni11Oi_clk_prev && clk_1 == 1'b1) 
		begin
			n0l0iO <= wire_n0ll0l_dataout;
			ni11ll <= wire_ni100i_dataout;
			ni11lO <= wire_ni100l_dataout;
			ni11Ol <= wire_ni100O_dataout;
			nlliiOO <= wire_nllilii_dataout;
			nllil1i <= wire_nllilil_dataout;
			nllil1l <= wire_nlliliO_dataout;
			nlllO0l <= wire_nllO01i_dataout;
		end
		ni11Oi_clk_prev <= clk_1;
	end
	assign
		wire_ni11Oi_CLRN = (nliil1l58 ^ nliil1l57),
		wire_ni11Oi_PRN = ((nliil1i60 ^ nliil1i59) & (~ wire_nl0i_dataout));
	initial
	begin
		n0111O = 0;
		n0l00l = 0;
		n0l00O = 0;
		n0l0ii = 0;
		n0l0il = 0;
		n0l0li = 0;
		n0l0ll = 0;
		n0l0lO = 0;
		n0l0Oi = 0;
		n0l0Ol = 0;
		n0l0OO = 0;
		n0li0i = 0;
		n0li0l = 0;
		n0li0O = 0;
		n0li1i = 0;
		n0li1l = 0;
		n0li1O = 0;
		n0liii = 0;
		n0liil = 0;
		n0liiO = 0;
		n0lili = 0;
		n0lill = 0;
		n0lilO = 0;
		n0liOi = 0;
		n0liOl = 0;
		n0O0ll = 0;
		n0O0lO = 0;
		n0O0Oi = 0;
		n0O0Ol = 0;
		n0O0OO = 0;
		n0Oiil = 0;
		n0OiOl = 0;
		n0OiOO = 0;
		n0Ol0i = 0;
		n0Ol0l = 0;
		n0Ol0O = 0;
		n0Ol1l = 0;
		n0Ol1O = 0;
		n0OO1O = 0;
		n0OOli = 0;
		n0OOll = 0;
		n1O = 0;
		ni000i = 0;
		ni000l = 0;
		ni00il = 0;
		ni00iO = 0;
		ni00Oi = 0;
		ni101i = 0;
		ni101l = 0;
		ni110i = 0;
		ni110l = 0;
		ni111i = 0;
		ni111l = 0;
		ni111O = 0;
		ni11OO = 0;
		ni1i0i = 0;
		ni1i0l = 0;
		ni1i0O = 0;
		ni1i1l = 0;
		ni1i1O = 0;
		ni1llO = 0;
		ni1O0i = 0;
		ni1O0l = 0;
		ni1O0O = 0;
		ni1O1l = 0;
		ni1O1O = 0;
		nil = 0;
		nliO00i = 0;
		nliO1l = 0;
		nlli00O = 0;
		nlli0Oi = 0;
		nlli0Ol = 0;
		nlli1ii = 0;
		nlli1il = 0;
		nlli1iO = 0;
		nlli1li = 0;
		nlli1ll = 0;
		nllii0l = 0;
		nllii0O = 0;
		nllii1O = 0;
		nlliiii = 0;
		nlliiil = 0;
		nlliiiO = 0;
		nlliiO = 0;
		nllil0i = 0;
		nllil0l = 0;
		nllil1O = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
		nlliOl = 0;
		nlliOO = 0;
		nlll0i = 0;
		nlll0l = 0;
		nlll0O = 0;
		nlll10l = 0;
		nlll10O = 0;
		nlll1i = 0;
		nlll1ii = 0;
		nlll1il = 0;
		nlll1iO = 0;
		nlll1l = 0;
		nlll1li = 0;
		nlll1O = 0;
		nlllii = 0;
		nlllil = 0;
		nllliO = 0;
		nllll0O = 0;
		nlllli = 0;
		nllllii = 0;
		nlllliO = 0;
		nlllll = 0;
		nllllli = 0;
		nllllO = 0;
		nlllO0i = 0;
		nlllO0O = 0;
		nlllO1i = 0;
		nlllO1l = 0;
		nlllO1O = 0;
		nlllOi = 0;
		nlllOii = 0;
		nlllOil = 0;
		nlllOiO = 0;
		nlllOl = 0;
		nlllOli = 0;
		nlllOll = 0;
		nlllOlO = 0;
		nlllOO = 0;
		nlllOOi = 0;
		nlllOOl = 0;
		nlllOOO = 0;
		nllO0i = 0;
		nllO0l = 0;
		nllO10i = 0;
		nllO10l = 0;
		nllO10O = 0;
		nllO11i = 0;
		nllO11l = 0;
		nllO11O = 0;
		nllO1i = 0;
		nllO1ii = 0;
		nllO1il = 0;
		nllO1iO = 0;
		nllO1l = 0;
		nllO1li = 0;
		nllO1O = 0;
		nllOOi = 0;
		nllOOl = 0;
		nlO00ii = 0;
		nlO00li = 0;
		nlO00ll = 0;
		nlO00lO = 0;
		nlO00Oi = 0;
		nlO00Ol = 0;
		nlO011i = 0;
		nlO011l = 0;
		nlO01l = 0;
		nlO01O = 0;
		nlO10li = 0;
		nlO10ll = 0;
		nlO10lO = 0;
		nlO10Oi = 0;
		nlO1i0O = 0;
		nlO1Oii = 0;
		nlO1OiO = 0;
		nlO1OOi = 0;
		nlO1OOl = 0;
		nlO1OOO = 0;
	end
	always @ ( posedge clk_1 or  negedge wire_nii_CLRN)
	begin
		if (wire_nii_CLRN == 1'b0) 
		begin
			n0111O <= 0;
			n0l00l <= 0;
			n0l00O <= 0;
			n0l0ii <= 0;
			n0l0il <= 0;
			n0l0li <= 0;
			n0l0ll <= 0;
			n0l0lO <= 0;
			n0l0Oi <= 0;
			n0l0Ol <= 0;
			n0l0OO <= 0;
			n0li0i <= 0;
			n0li0l <= 0;
			n0li0O <= 0;
			n0li1i <= 0;
			n0li1l <= 0;
			n0li1O <= 0;
			n0liii <= 0;
			n0liil <= 0;
			n0liiO <= 0;
			n0lili <= 0;
			n0lill <= 0;
			n0lilO <= 0;
			n0liOi <= 0;
			n0liOl <= 0;
			n0O0ll <= 0;
			n0O0lO <= 0;
			n0O0Oi <= 0;
			n0O0Ol <= 0;
			n0O0OO <= 0;
			n0Oiil <= 0;
			n0OiOl <= 0;
			n0OiOO <= 0;
			n0Ol0i <= 0;
			n0Ol0l <= 0;
			n0Ol0O <= 0;
			n0Ol1l <= 0;
			n0Ol1O <= 0;
			n0OO1O <= 0;
			n0OOli <= 0;
			n0OOll <= 0;
			n1O <= 0;
			ni000i <= 0;
			ni000l <= 0;
			ni00il <= 0;
			ni00iO <= 0;
			ni00Oi <= 0;
			ni101i <= 0;
			ni101l <= 0;
			ni110i <= 0;
			ni110l <= 0;
			ni111i <= 0;
			ni111l <= 0;
			ni111O <= 0;
			ni11OO <= 0;
			ni1i0i <= 0;
			ni1i0l <= 0;
			ni1i0O <= 0;
			ni1i1l <= 0;
			ni1i1O <= 0;
			ni1llO <= 0;
			ni1O0i <= 0;
			ni1O0l <= 0;
			ni1O0O <= 0;
			ni1O1l <= 0;
			ni1O1O <= 0;
			nil <= 0;
			nliO00i <= 0;
			nliO1l <= 0;
			nlli00O <= 0;
			nlli0Oi <= 0;
			nlli0Ol <= 0;
			nlli1ii <= 0;
			nlli1il <= 0;
			nlli1iO <= 0;
			nlli1li <= 0;
			nlli1ll <= 0;
			nllii0l <= 0;
			nllii0O <= 0;
			nllii1O <= 0;
			nlliiii <= 0;
			nlliiil <= 0;
			nlliiiO <= 0;
			nlliiO <= 0;
			nllil0i <= 0;
			nllil0l <= 0;
			nllil1O <= 0;
			nllili <= 0;
			nllill <= 0;
			nllilO <= 0;
			nlliOi <= 0;
			nlliOl <= 0;
			nlliOO <= 0;
			nlll0i <= 0;
			nlll0l <= 0;
			nlll0O <= 0;
			nlll10l <= 0;
			nlll10O <= 0;
			nlll1i <= 0;
			nlll1ii <= 0;
			nlll1il <= 0;
			nlll1iO <= 0;
			nlll1l <= 0;
			nlll1li <= 0;
			nlll1O <= 0;
			nlllii <= 0;
			nlllil <= 0;
			nllliO <= 0;
			nllll0O <= 0;
			nlllli <= 0;
			nllllii <= 0;
			nlllliO <= 0;
			nlllll <= 0;
			nllllli <= 0;
			nllllO <= 0;
			nlllO0i <= 0;
			nlllO0O <= 0;
			nlllO1i <= 0;
			nlllO1l <= 0;
			nlllO1O <= 0;
			nlllOi <= 0;
			nlllOii <= 0;
			nlllOil <= 0;
			nlllOiO <= 0;
			nlllOl <= 0;
			nlllOli <= 0;
			nlllOll <= 0;
			nlllOlO <= 0;
			nlllOO <= 0;
			nlllOOi <= 0;
			nlllOOl <= 0;
			nlllOOO <= 0;
			nllO0i <= 0;
			nllO0l <= 0;
			nllO10i <= 0;
			nllO10l <= 0;
			nllO10O <= 0;
			nllO11i <= 0;
			nllO11l <= 0;
			nllO11O <= 0;
			nllO1i <= 0;
			nllO1ii <= 0;
			nllO1il <= 0;
			nllO1iO <= 0;
			nllO1l <= 0;
			nllO1li <= 0;
			nllO1O <= 0;
			nllOOi <= 0;
			nllOOl <= 0;
			nlO00ii <= 0;
			nlO00li <= 0;
			nlO00ll <= 0;
			nlO00lO <= 0;
			nlO00Oi <= 0;
			nlO00Ol <= 0;
			nlO011i <= 0;
			nlO011l <= 0;
			nlO01l <= 0;
			nlO01O <= 0;
			nlO10li <= 0;
			nlO10ll <= 0;
			nlO10lO <= 0;
			nlO10Oi <= 0;
			nlO1i0O <= 0;
			nlO1Oii <= 0;
			nlO1OiO <= 0;
			nlO1OOi <= 0;
			nlO1OOl <= 0;
			nlO1OOO <= 0;
		end
		else 
		begin
			n0111O <= wire_n0110O_dataout;
			n0l00l <= wire_n0ll1i_dataout;
			n0l00O <= wire_n0ll1l_dataout;
			n0l0ii <= wire_n0ll1O_dataout;
			n0l0il <= wire_n0ll0i_dataout;
			n0l0li <= wire_n0ll0O_dataout;
			n0l0ll <= wire_n0llii_dataout;
			n0l0lO <= wire_n0llil_dataout;
			n0l0Oi <= wire_n0lliO_dataout;
			n0l0Ol <= wire_n0llli_dataout;
			n0l0OO <= wire_n0llll_dataout;
			n0li0i <= wire_n0llOO_dataout;
			n0li0l <= wire_n0lO1i_dataout;
			n0li0O <= wire_n0lO1l_dataout;
			n0li1i <= wire_n0lllO_dataout;
			n0li1l <= wire_n0llOi_dataout;
			n0li1O <= wire_n0llOl_dataout;
			n0liii <= wire_n0lO1O_dataout;
			n0liil <= wire_n0lO0i_dataout;
			n0liiO <= wire_n0lO0l_dataout;
			n0lili <= wire_n0lO0O_dataout;
			n0lill <= wire_n0lOii_dataout;
			n0lilO <= wire_n0lOil_dataout;
			n0liOi <= wire_n0lOiO_dataout;
			n0liOl <= wire_n0Oi1O_dataout;
			n0O0ll <= wire_n0liOO_dataout;
			n0O0lO <= wire_n0Oi0i_dataout;
			n0O0Oi <= wire_n0Oi0l_dataout;
			n0O0Ol <= wire_n0Oi0O_dataout;
			n0O0OO <= wire_n0Oiii_dataout;
			n0Oiil <= n0OiOl;
			n0OiOl <= (rgenericfifo & wrenable);
			n0OiOO <= wire_n0Olii_dataout;
			n0Ol0i <= wire_n0Olli_dataout;
			n0Ol0l <= wire_n0Olll_dataout;
			n0Ol0O <= wire_n0OO0i_dataout;
			n0Ol1l <= wire_n0Olil_dataout;
			n0Ol1O <= wire_n0OliO_dataout;
			n0OO1O <= n0OOli;
			n0OOli <= nliiO0O;
			n0OOll <= wire_ni110O_dataout;
			n1O <= nil;
			ni000i <= wire_ni00ii_dataout;
			ni000l <= wire_ni00li_dataout;
			ni00il <= wire_ni00ll_dataout;
			ni00iO <= wire_ni00OO_dataout;
			ni00Oi <= wire_ni0iiO_dataout;
			ni101i <= wire_ni10il_dataout;
			ni101l <= wire_ni1iii_dataout;
			ni110i <= wire_ni11li_dataout;
			ni110l <= wire_ni101O_dataout;
			ni111i <= wire_ni11ii_dataout;
			ni111l <= wire_ni11il_dataout;
			ni111O <= wire_ni11iO_dataout;
			ni11OO <= wire_ni10ii_dataout;
			ni1i0i <= wire_ni1ili_dataout;
			ni1i0l <= wire_ni1ill_dataout;
			ni1i0O <= wire_ni1lOi_dataout;
			ni1i1l <= wire_ni1iil_dataout;
			ni1i1O <= wire_ni1iiO_dataout;
			ni1llO <= wire_ni1Oii_dataout;
			ni1O0i <= wire_ni1Oli_dataout;
			ni1O0l <= wire_ni1Oll_dataout;
			ni1O0O <= wire_ni000O_dataout;
			ni1O1l <= wire_ni1Oil_dataout;
			ni1O1O <= wire_ni1OiO_dataout;
			nil <= wire_niO_dataout;
			nliO00i <= wire_nliO0ii_dataout;
			nliO1l <= sudi[0];
			nlli00O <= wire_nlli1lO_dataout;
			nlli0Oi <= nli0l0i;
			nlli0Ol <= wire_nllii0i_dataout;
			nlli1ii <= wire_nlli1Oi_dataout;
			nlli1il <= wire_nlli1Ol_dataout;
			nlli1iO <= wire_nlli1OO_dataout;
			nlli1li <= wire_nlli01i_dataout;
			nlli1ll <= nlli0Oi;
			nllii0l <= wire_nlliill_dataout;
			nllii0O <= wire_nlliilO_dataout;
			nllii1O <= wire_nlliili_dataout;
			nlliiii <= wire_nlliiOi_dataout;
			nlliiil <= wire_nlliiOl_dataout;
			nlliiiO <= wire_nllil0O_dataout;
			nlliiO <= sudi[1];
			nllil0i <= wire_nllilll_dataout;
			nllil0l <= wire_nlll1ll_dataout;
			nllil1O <= wire_nllilli_dataout;
			nllili <= sudi[2];
			nllill <= sudi[3];
			nllilO <= sudi[4];
			nlliOi <= sudi[5];
			nlliOl <= sudi[6];
			nlliOO <= sudi[7];
			nlll0i <= sudi[11];
			nlll0l <= sudi[12];
			nlll0O <= sudi[13];
			nlll10l <= wire_nlll1lO_dataout;
			nlll10O <= wire_nlll1Oi_dataout;
			nlll1i <= sudi[8];
			nlll1ii <= wire_nlll1Ol_dataout;
			nlll1il <= wire_nlll1OO_dataout;
			nlll1iO <= wire_nlll01i_dataout;
			nlll1l <= sudi[9];
			nlll1li <= nllll0O;
			nlll1O <= sudi[10];
			nlllii <= sudi[14];
			nlllil <= sudi[15];
			nllliO <= sudi[16];
			nllll0O <= (rgenericfifo & wrenable);
			nlllli <= sudi[17];
			nllllii <= wire_nllllll_dataout;
			nlllliO <= wire_nlllllO_dataout;
			nlllll <= sudi[18];
			nllllli <= wire_nllO1ll_dataout;
			nllllO <= sudi[19];
			nlllO0i <= wire_nllO1OO_dataout;
			nlllO0O <= wire_nllO01l_dataout;
			nlllO1i <= wire_nllO1lO_dataout;
			nlllO1l <= wire_nllO1Oi_dataout;
			nlllO1O <= wire_nllO1Ol_dataout;
			nlllOi <= sudi[20];
			nlllOii <= wire_nllO01O_dataout;
			nlllOil <= wire_nllO00i_dataout;
			nlllOiO <= wire_nllO00l_dataout;
			nlllOl <= sudi[21];
			nlllOli <= wire_nllO00O_dataout;
			nlllOll <= wire_nllO0ii_dataout;
			nlllOlO <= wire_nllO0il_dataout;
			nlllOO <= sudi[22];
			nlllOOi <= wire_nllO0iO_dataout;
			nlllOOl <= wire_nllO0li_dataout;
			nlllOOO <= wire_nllO0ll_dataout;
			nllO0i <= sudi[26];
			nllO0l <= sudi[27];
			nllO10i <= wire_nllO0OO_dataout;
			nllO10l <= wire_nllOi1i_dataout;
			nllO10O <= wire_nllOi1l_dataout;
			nllO11i <= wire_nllO0lO_dataout;
			nllO11l <= wire_nllO0Oi_dataout;
			nllO11O <= wire_nllO0Ol_dataout;
			nllO1i <= sudi[23];
			nllO1ii <= wire_nllOi1O_dataout;
			nllO1il <= wire_nllOi0i_dataout;
			nllO1iO <= wire_nllOi0l_dataout;
			nllO1l <= sudi[24];
			nllO1li <= wire_nlO1i1i_dataout;
			nllO1O <= sudi[25];
			nllOOi <= wire_nlO11i_o;
			nllOOl <= wire_nlO11l_o;
			nlO00ii <= (rclkcmpsqmd & (wire_nlOi10l_dataout & (((nlillil | nlO00Oi) | nlO00lO) | nlO00ll)));
			nlO00li <= wire_nlO0i1i_dataout;
			nlO00ll <= wire_nlO0i1O_dataout;
			nlO00lO <= wire_nlO0i0l_dataout;
			nlO00Oi <= wire_nlO0iiO_dataout;
			nlO00Ol <= wire_nlO0l1O_dataout;
			nlO011i <= wire_nlO01ii_dataout;
			nlO011l <= wire_nlO00il_dataout;
			nlO01l <= wire_nlO11O_o;
			nlO01O <= wire_nllOOO_o;
			nlO10li <= wire_nlO1i1l_dataout;
			nlO10ll <= wire_nlO1i1O_dataout;
			nlO10lO <= wire_nlO1i0i_dataout;
			nlO10Oi <= wire_nlO1i0l_dataout;
			nlO1i0O <= wire_nlO1Oil_dataout;
			nlO1Oii <= wire_nlO1Oli_dataout;
			nlO1OiO <= wire_nlO011O_dataout;
			nlO1OOi <= wire_nlO010i_dataout;
			nlO1OOl <= wire_nlO010l_dataout;
			nlO1OOO <= wire_nlO010O_dataout;
		end
	end
	assign
		wire_nii_CLRN = ((nliO10i4 ^ nliO10i3) & (~ wire_nl0i_dataout));
	initial
	begin
		ni00Ol = 0;
		ni0liO = 0;
		ni0lli = 0;
		ni0lll = 0;
		ni0llO = 0;
		ni0lOi = 0;
		ni0lOl = 0;
		ni0lOO = 0;
		ni0O0i = 0;
		ni0O0l = 0;
		ni0O0O = 0;
		ni0O1i = 0;
		ni0O1l = 0;
		ni0O1O = 0;
		ni0Oii = 0;
		ni0Oil = 0;
		ni0OiO = 0;
		ni0Oli = 0;
		ni0Oll = 0;
		ni0OlO = 0;
		nii0li = 0;
		nii0Oi = 0;
	end
	always @ ( posedge clk_2 or  negedge wire_nii0lO_CLRN)
	begin
		if (wire_nii0lO_CLRN == 1'b0) 
		begin
			ni00Ol <= 0;
			ni0liO <= 0;
			ni0lli <= 0;
			ni0lll <= 0;
			ni0llO <= 0;
			ni0lOi <= 0;
			ni0lOl <= 0;
			ni0lOO <= 0;
			ni0O0i <= 0;
			ni0O0l <= 0;
			ni0O0O <= 0;
			ni0O1i <= 0;
			ni0O1l <= 0;
			ni0O1O <= 0;
			ni0Oii <= 0;
			ni0Oil <= 0;
			ni0OiO <= 0;
			ni0Oli <= 0;
			ni0Oll <= 0;
			ni0OlO <= 0;
			nii0li <= 0;
			nii0Oi <= 0;
		end
		else if  (nlil0l == 1'b0) 
		begin
			ni00Ol <= wire_niiO1l_dataout;
			ni0liO <= wire_niiO1O_dataout;
			ni0lli <= wire_niiO0i_dataout;
			ni0lll <= wire_niiO0l_dataout;
			ni0llO <= wire_niiO0O_dataout;
			ni0lOi <= wire_niiOii_dataout;
			ni0lOl <= wire_niiOil_dataout;
			ni0lOO <= wire_niiOiO_dataout;
			ni0O0i <= wire_nil11l_dataout;
			ni0O0l <= wire_nil11O_dataout;
			ni0O0O <= wire_nil10i_dataout;
			ni0O1i <= wire_niiOli_dataout;
			ni0O1l <= wire_niiOll_dataout;
			ni0O1O <= wire_nil11i_dataout;
			ni0Oii <= wire_nil10l_dataout;
			ni0Oil <= wire_nil10O_dataout;
			ni0OiO <= wire_nil1ii_dataout;
			ni0Oli <= wire_nil1il_dataout;
			ni0Oll <= wire_nil1iO_dataout;
			ni0OlO <= wire_nil1li_dataout;
			nii0li <= wire_niliil_dataout;
			nii0Oi <= wire_nilili_dataout;
		end
	end
	assign
		wire_nii0lO_CLRN = ((nliiOOi56 ^ nliiOOi55) & (~ nliO1il));
	initial
	begin
		n0Oi1i = 0;
		n0Oi1l = 0;
		niiOlO = 0;
		niiOOi = 0;
		niiOOO = 0;
		nlli10i = 0;
		nlli10l = 0;
		nlli10O = 0;
		nlO10Ol = 0;
		nlO10OO = 0;
	end
	always @ (clk_1 or wire_niiOOl_PRN or wire_niiOOl_CLRN)
	begin
		if (wire_niiOOl_PRN == 1'b0) 
		begin
			n0Oi1i <= 1;
			n0Oi1l <= 1;
			niiOlO <= 1;
			niiOOi <= 1;
			niiOOO <= 1;
			nlli10i <= 1;
			nlli10l <= 1;
			nlli10O <= 1;
			nlO10Ol <= 1;
			nlO10OO <= 1;
		end
		else if  (wire_niiOOl_CLRN == 1'b0) 
		begin
			n0Oi1i <= 0;
			n0Oi1l <= 0;
			niiOlO <= 0;
			niiOOi <= 0;
			niiOOO <= 0;
			nlli10i <= 0;
			nlli10l <= 0;
			nlli10O <= 0;
			nlO10Ol <= 0;
			nlO10OO <= 0;
		end
		else 
		if (clk_1 != niiOOl_clk_prev && clk_1 == 1'b1) 
		begin
			n0Oi1i <= wire_n0Oili_dataout;
			n0Oi1l <= wire_n0OiiO_dataout;
			niiOlO <= wire_n0Oill_dataout;
			niiOOi <= wire_n0OilO_dataout;
			niiOOO <= wire_n0OiOi_dataout;
			nlli10i <= wire_nlO1ill_dataout;
			nlli10l <= wire_nlO1ili_dataout;
			nlli10O <= wire_nlO1iiO_dataout;
			nlO10Ol <= wire_nlO1iil_dataout;
			nlO10OO <= wire_nlO1iii_dataout;
		end
		niiOOl_clk_prev <= clk_1;
	end
	assign
		wire_niiOOl_CLRN = (nliiOOO52 ^ nliiOOO51),
		wire_niiOOl_PRN = (nliiOOl54 ^ nliiOOl53);
	initial
	begin
		nl0l = 0;
		nO = 0;
	end
	always @ (clk_1 or nliO1il or wire_nl_CLRN)
	begin
		if (nliO1il == 1'b1) 
		begin
			nl0l <= 1;
			nO <= 1;
		end
		else if  (wire_nl_CLRN == 1'b0) 
		begin
			nl0l <= 0;
			nO <= 0;
		end
		else 
		if (clk_1 != nl_clk_prev && clk_1 == 1'b1) 
		begin
			nl0l <= nlilOil;
			nO <= nl0l;
		end
		nl_clk_prev <= clk_1;
	end
	assign
		wire_nl_CLRN = (nliO1iO2 ^ nliO1iO1);
	initial
	begin
		n100iO = 0;
		n10iOi = 0;
		niOOiO = 0;
		nl11Ol = 0;
	end
	always @ ( posedge clk_2 or  posedge nliO1il)
	begin
		if (nliO1il == 1'b1) 
		begin
			n100iO <= 1;
			n10iOi <= 1;
			niOOiO <= 1;
			nl11Ol <= 1;
		end
		else 
		begin
			n100iO <= wire_n10OOO_dataout;
			n10iOi <= wire_n1i00i_dataout;
			niOOiO <= wire_nl1l1i_dataout;
			nl11Ol <= wire_nl1O0l_dataout;
		end
	end
	initial
	begin
		n0l00i = 0;
		n0l01l = 0;
		n0l01O = 0;
		n1O00O = 0;
		n1O0ii = 0;
		nli01l = 0;
		nli1OO = 0;
		nlli11i = 0;
		nlli11l = 0;
		nlli11O = 0;
	end
	always @ ( posedge clk_2 or  negedge wire_nli01i_PRN)
	begin
		if (wire_nli01i_PRN == 1'b0) 
		begin
			n0l00i <= 1;
			n0l01l <= 1;
			n0l01O <= 1;
			n1O00O <= 1;
			n1O0ii <= 1;
			nli01l <= 1;
			nli1OO <= 1;
			nlli11i <= 1;
			nlli11l <= 1;
			nlli11O <= 1;
		end
		else 
		begin
			n0l00i <= wire_nli0ll_dataout;
			n0l01l <= wire_nli0Oi_dataout;
			n0l01O <= wire_nli0lO_dataout;
			n1O00O <= wire_n1O0Ol_dataout;
			n1O0ii <= wire_n1O0Oi_dataout;
			nli01l <= wire_nli0iO_dataout;
			nli1OO <= wire_nli0li_dataout;
			nlli11i <= wire_n1Oi1l_dataout;
			nlli11l <= wire_n1Oi1i_dataout;
			nlli11O <= wire_n1O0OO_dataout;
		end
	end
	assign
		wire_nli01i_PRN = (nlil01l50 ^ nlil01l49);
	initial
	begin
		nl0O = 0;
		nlli = 0;
	end
	always @ ( posedge clk_2 or  posedge hard_reset)
	begin
		if (hard_reset == 1'b1) 
		begin
			nl0O <= 1;
			nlli <= 1;
		end
		else 
		begin
			nl0O <= wire_nllO_dataout;
			nlli <= nl0O;
		end
	end
	initial
	begin
		nlOiOil = 0;
		nlOiOli = 0;
		nlOiOll = 0;
		nlOiOlO = 0;
		nlOiOOi = 0;
		nlOiOOl = 0;
		nlOiOOO = 0;
		nlOl00i = 0;
		nlOl00l = 0;
		nlOl00O = 0;
		nlOl01i = 0;
		nlOl01l = 0;
		nlOl01O = 0;
		nlOl0ii = 0;
		nlOl0il = 0;
		nlOl0iO = 0;
		nlOl0li = 0;
		nlOl0ll = 0;
		nlOl0lO = 0;
		nlOl0Oi = 0;
		nlOl0Ol = 0;
		nlOl10i = 0;
		nlOl10l = 0;
		nlOl10O = 0;
		nlOl11i = 0;
		nlOl11l = 0;
		nlOl11O = 0;
		nlOl1ii = 0;
		nlOl1il = 0;
		nlOl1iO = 0;
		nlOl1li = 0;
		nlOl1ll = 0;
		nlOl1lO = 0;
		nlOl1Oi = 0;
		nlOl1Ol = 0;
		nlOl1OO = 0;
		nlOlill = 0;
		nlOliOl = 0;
	end
	always @ (clk_2 or wire_nlOliOi_PRN or nliO1il)
	begin
		if (wire_nlOliOi_PRN == 1'b0) 
		begin
			nlOiOil <= 1;
			nlOiOli <= 1;
			nlOiOll <= 1;
			nlOiOlO <= 1;
			nlOiOOi <= 1;
			nlOiOOl <= 1;
			nlOiOOO <= 1;
			nlOl00i <= 1;
			nlOl00l <= 1;
			nlOl00O <= 1;
			nlOl01i <= 1;
			nlOl01l <= 1;
			nlOl01O <= 1;
			nlOl0ii <= 1;
			nlOl0il <= 1;
			nlOl0iO <= 1;
			nlOl0li <= 1;
			nlOl0ll <= 1;
			nlOl0lO <= 1;
			nlOl0Oi <= 1;
			nlOl0Ol <= 1;
			nlOl10i <= 1;
			nlOl10l <= 1;
			nlOl10O <= 1;
			nlOl11i <= 1;
			nlOl11l <= 1;
			nlOl11O <= 1;
			nlOl1ii <= 1;
			nlOl1il <= 1;
			nlOl1iO <= 1;
			nlOl1li <= 1;
			nlOl1ll <= 1;
			nlOl1lO <= 1;
			nlOl1Oi <= 1;
			nlOl1Ol <= 1;
			nlOl1OO <= 1;
			nlOlill <= 1;
			nlOliOl <= 1;
		end
		else if  (nliO1il == 1'b1) 
		begin
			nlOiOil <= 0;
			nlOiOli <= 0;
			nlOiOll <= 0;
			nlOiOlO <= 0;
			nlOiOOi <= 0;
			nlOiOOl <= 0;
			nlOiOOO <= 0;
			nlOl00i <= 0;
			nlOl00l <= 0;
			nlOl00O <= 0;
			nlOl01i <= 0;
			nlOl01l <= 0;
			nlOl01O <= 0;
			nlOl0ii <= 0;
			nlOl0il <= 0;
			nlOl0iO <= 0;
			nlOl0li <= 0;
			nlOl0ll <= 0;
			nlOl0lO <= 0;
			nlOl0Oi <= 0;
			nlOl0Ol <= 0;
			nlOl10i <= 0;
			nlOl10l <= 0;
			nlOl10O <= 0;
			nlOl11i <= 0;
			nlOl11l <= 0;
			nlOl11O <= 0;
			nlOl1ii <= 0;
			nlOl1il <= 0;
			nlOl1iO <= 0;
			nlOl1li <= 0;
			nlOl1ll <= 0;
			nlOl1lO <= 0;
			nlOl1Oi <= 0;
			nlOl1Ol <= 0;
			nlOl1OO <= 0;
			nlOlill <= 0;
			nlOliOl <= 0;
		end
		else if  (nlii1Oi == 1'b0) 
		if (clk_2 != nlOliOi_clk_prev && clk_2 == 1'b1) 
		begin
			nlOiOil <= wire_nlOlOOl_dataout;
			nlOiOli <= wire_nlOlOOO_dataout;
			nlOiOll <= wire_nlOO11i_dataout;
			nlOiOlO <= wire_nlOO11l_dataout;
			nlOiOOi <= wire_nlOO11O_dataout;
			nlOiOOl <= wire_nlOO10i_dataout;
			nlOiOOO <= wire_nlOO10l_dataout;
			nlOl00i <= wire_nlOlO1O_dataout;
			nlOl00l <= wire_nlOlO0i_dataout;
			nlOl00O <= wire_nlOlO0l_dataout;
			nlOl01i <= wire_nlOO00O_dataout;
			nlOl01l <= wire_nlOO0ii_dataout;
			nlOl01O <= wire_nlOlO1l_dataout;
			nlOl0ii <= wire_nlOlO0O_dataout;
			nlOl0il <= wire_nlOlOii_dataout;
			nlOl0iO <= wire_nlOlOil_dataout;
			nlOl0li <= wire_nlOlOiO_dataout;
			nlOl0ll <= wire_nlOlOli_dataout;
			nlOl0lO <= wire_nlOlOll_dataout;
			nlOl0Oi <= wire_nlOlOlO_dataout;
			nlOl0Ol <= wire_nlOlOOi_dataout;
			nlOl10i <= wire_nlOO1iO_dataout;
			nlOl10l <= wire_nlOO1li_dataout;
			nlOl10O <= wire_nlOO1ll_dataout;
			nlOl11i <= wire_nlOO10O_dataout;
			nlOl11l <= wire_nlOO1ii_dataout;
			nlOl11O <= wire_nlOO1il_dataout;
			nlOl1ii <= wire_nlOO1lO_dataout;
			nlOl1il <= wire_nlOO1Oi_dataout;
			nlOl1iO <= wire_nlOO1Ol_dataout;
			nlOl1li <= wire_nlOO1OO_dataout;
			nlOl1ll <= wire_nlOO01i_dataout;
			nlOl1lO <= wire_nlOO01l_dataout;
			nlOl1Oi <= wire_nlOO01O_dataout;
			nlOl1Ol <= wire_nlOO00i_dataout;
			nlOl1OO <= wire_nlOO00l_dataout;
			nlOlill <= wire_nlOOi0i_dataout;
			nlOliOl <= wire_nlOOi0O_dataout;
		end
		nlOliOi_clk_prev <= clk_2;
	end
	assign
		wire_nlOliOi_PRN = (nli0O0O62 ^ nli0O0O61);
	assign		wire_n00i_dataout = (rwa_6g_en === 1'b1) ? wire_nll1il_dataout : wire_nlOi01O_dataout;
	assign		wire_n00l_dataout = (rwa_6g_en === 1'b1) ? wire_nll1iO_dataout : wire_nlOi00i_dataout;
	assign		wire_n00O_dataout = (rwa_6g_en === 1'b1) ? wire_nll1li_dataout : wire_nlOi00l_dataout;
	and(wire_n0110i_dataout, n0111l, ~((~ nlil00O)));
	and(wire_n0110l_dataout, n0111O, ~((~ nlil00O)));
	and(wire_n0110O_dataout, wire_nlilOi_o, (rgenericfifo | wire_nliOOi_dataout));
	assign		wire_n01i_dataout = (rwa_6g_en === 1'b1) ? wire_nll10l_dataout : wire_nlOi1OO_dataout;
	assign		wire_n01l_dataout = (rwa_6g_en === 1'b1) ? wire_nll10O_dataout : wire_nlOi01i_dataout;
	assign		wire_n01O_dataout = (rwa_6g_en === 1'b1) ? wire_nll1ii_dataout : wire_nlOi01l_dataout;
	assign		wire_n0ii_dataout = (rwa_6g_en === 1'b1) ? wire_nll1ll_dataout : wire_nlOi00O_dataout;
	assign		wire_n0il_dataout = (rwa_6g_en === 1'b1) ? wire_nll1lO_dataout : wire_nlOi0ii_dataout;
	assign		wire_n0iO_dataout = (rwa_6g_en === 1'b1) ? wire_nll1Oi_dataout : wire_nlOi0il_dataout;
	assign		wire_n0li_dataout = (rwa_6g_en === 1'b1) ? wire_nll1Ol_dataout : wire_nlOi0iO_dataout;
	and(wire_n0liOO_dataout, wire_n0lOli_dataout, ~(nliiO1i));
	assign		wire_n0ll_dataout = (rwa_6g_en === 1'b1) ? wire_nll1OO_dataout : wire_nlOi0li_dataout;
	and(wire_n0ll0i_dataout, wire_n0lOOl_dataout, ~(nliiO1i));
	or(wire_n0ll0l_dataout, wire_n0lOOO_dataout, nliiO1i);
	and(wire_n0ll0O_dataout, wire_n0O11i_dataout, ~(nliiO1i));
	and(wire_n0ll1i_dataout, wire_n0lOll_dataout, ~(nliiO1i));
	and(wire_n0ll1l_dataout, wire_n0lOlO_dataout, ~(nliiO1i));
	and(wire_n0ll1O_dataout, wire_n0lOOi_dataout, ~(nliiO1i));
	and(wire_n0llii_dataout, wire_n0O11l_dataout, ~(nliiO1i));
	and(wire_n0llil_dataout, wire_n0O11O_dataout, ~(nliiO1i));
	and(wire_n0lliO_dataout, wire_n0O10i_dataout, ~(nliiO1i));
	and(wire_n0llli_dataout, wire_n0O10l_dataout, ~(nliiO1i));
	and(wire_n0llll_dataout, wire_n0O10O_dataout, ~(nliiO1i));
	and(wire_n0lllO_dataout, wire_n0O1ii_dataout, ~(nliiO1i));
	and(wire_n0llOi_dataout, wire_n0O1il_dataout, ~(nliiO1i));
	and(wire_n0llOl_dataout, wire_n0O1iO_dataout, ~(nliiO1i));
	and(wire_n0llOO_dataout, wire_n0O1li_dataout, ~(nliiO1i));
	assign		wire_n0lO_dataout = (rwa_6g_en === 1'b1) ? wire_nll01i_dataout : wire_nlOi0ll_dataout;
	and(wire_n0lO0i_dataout, wire_n0O1Ol_dataout, ~(nliiO1i));
	and(wire_n0lO0l_dataout, wire_n0O1OO_dataout, ~(nliiO1i));
	and(wire_n0lO0O_dataout, wire_n0O01i_dataout, ~(nliiO1i));
	and(wire_n0lO1i_dataout, wire_n0O1ll_dataout, ~(nliiO1i));
	and(wire_n0lO1l_dataout, wire_n0O1lO_dataout, ~(nliiO1i));
	and(wire_n0lO1O_dataout, wire_n0O1Oi_dataout, ~(nliiO1i));
	and(wire_n0lOii_dataout, wire_n0O01l_dataout, ~(nliiO1i));
	and(wire_n0lOil_dataout, wire_n0O01O_dataout, ~(nliiO1i));
	and(wire_n0lOiO_dataout, wire_n0O00i_dataout, ~(nliiO1i));
	assign		wire_n0lOli_dataout = (nliilOl === 1'b1) ? wire_n0O00l_dataout : n0O0ll;
	assign		wire_n0lOll_dataout = (nliilOl === 1'b1) ? wire_n0O00O_dataout : n0l00l;
	assign		wire_n0lOlO_dataout = (nliilOl === 1'b1) ? wire_n0O0ii_dataout : n0l00O;
	assign		wire_n0lOOi_dataout = (nliilOl === 1'b1) ? wire_n0O0il_dataout : n0l0ii;
	assign		wire_n0lOOl_dataout = (nliilOl === 1'b1) ? wire_n0O0iO_dataout : n0l0il;
	assign		wire_n0lOOO_dataout = (nliilOl === 1'b1) ? n0liOi : n0l0iO;
	assign		wire_n0O00i_dataout = (nliilOl === 1'b1) ? n0lilO : n0liOi;
	and(wire_n0O00l_dataout, wire_n0O0li_o[0], ~(nliii0O));
	and(wire_n0O00O_dataout, wire_n0O0li_o[1], ~(nliii0O));
	assign		wire_n0O01i_dataout = (nliilOl === 1'b1) ? n0liiO : n0lili;
	assign		wire_n0O01l_dataout = (nliilOl === 1'b1) ? n0lili : n0lill;
	assign		wire_n0O01O_dataout = (nliilOl === 1'b1) ? n0lill : n0lilO;
	and(wire_n0O0ii_dataout, wire_n0O0li_o[2], ~(nliii0O));
	and(wire_n0O0il_dataout, wire_n0O0li_o[3], ~(nliii0O));
	and(wire_n0O0iO_dataout, wire_n0O0li_o[4], ~(nliii0O));
	assign		wire_n0O10i_dataout = (nliilOl === 1'b1) ? n0l0lO : n0l0Oi;
	assign		wire_n0O10l_dataout = (nliilOl === 1'b1) ? n0l0Oi : n0l0Ol;
	assign		wire_n0O10O_dataout = (nliilOl === 1'b1) ? n0l0Ol : n0l0OO;
	assign		wire_n0O11i_dataout = (nliilOl === 1'b1) ? n0l0iO : n0l0li;
	assign		wire_n0O11l_dataout = (nliilOl === 1'b1) ? n0l0li : n0l0ll;
	assign		wire_n0O11O_dataout = (nliilOl === 1'b1) ? n0l0ll : n0l0lO;
	assign		wire_n0O1ii_dataout = (nliilOl === 1'b1) ? n0l0OO : n0li1i;
	assign		wire_n0O1il_dataout = (nliilOl === 1'b1) ? n0li1i : n0li1l;
	assign		wire_n0O1iO_dataout = (nliilOl === 1'b1) ? n0li1l : n0li1O;
	assign		wire_n0O1li_dataout = (nliilOl === 1'b1) ? n0li1O : n0li0i;
	assign		wire_n0O1ll_dataout = (nliilOl === 1'b1) ? n0li0i : n0li0l;
	assign		wire_n0O1lO_dataout = (nliilOl === 1'b1) ? n0li0l : n0li0O;
	assign		wire_n0O1Oi_dataout = (nliilOl === 1'b1) ? n0li0O : n0liii;
	assign		wire_n0O1Ol_dataout = (nliilOl === 1'b1) ? n0liii : n0liil;
	assign		wire_n0O1OO_dataout = (nliilOl === 1'b1) ? n0liil : n0liiO;
	and(wire_n0Oi_dataout, wire_nll01l_dataout, rwa_6g_en);
	and(wire_n0Oi0i_dataout, n0Oi1i, ~(nliiO1i));
	and(wire_n0Oi0l_dataout, niiOlO, ~(nliiO1i));
	and(wire_n0Oi0O_dataout, niiOOi, ~(nliiO1i));
	and(wire_n0Oi1O_dataout, n0Oi1l, ~(nliiO1i));
	and(wire_n0Oiii_dataout, niiOOO, ~(nliiO1i));
	and(wire_n0OiiO_dataout, niii1i, ~(nliiO1i));
	and(wire_n0Oili_dataout, niOlOl, ~(nliiO1i));
	and(wire_n0Oill_dataout, niOlOO, ~(nliiO1i));
	and(wire_n0OilO_dataout, niOO1i, ~(nliiO1i));
	and(wire_n0OiOi_dataout, niOO1l, ~(nliiO1i));
	and(wire_n0Ol_dataout, wire_nll01O_dataout, rwa_6g_en);
	and(wire_n0Olii_dataout, nliiiii, ~(nliiO1i));
	and(wire_n0Olil_dataout, nliiiil, ~(nliiO1i));
	and(wire_n0OliO_dataout, nliiiiO, ~(nliiO1i));
	and(wire_n0Olli_dataout, nliiili, ~(nliiO1i));
	and(wire_n0Olll_dataout, nliiill, ~(nliiO1i));
	and(wire_n0OO_dataout, wire_nll00i_dataout, rwa_6g_en);
	and(wire_n0OO0i_dataout, wire_n0OO0l_dataout, wire_nliOOi_dataout);
	or(wire_n0OO0l_dataout, n0Ol0O, ((~ n0Ol0O) & nliiilO));
	assign		wire_n0OOii_dataout = (nliO11i === 1'b1) ? (nliiiOi | n0OO1O) : nliiiOi;
	and(wire_n1011i_dataout, wire_n1010i_o[0], nli0OOi);
	and(wire_n1011l_dataout, wire_n1010i_o[1], nli0OOi);
	and(wire_n1011O_dataout, wire_n1010i_o[2], nli0OOi);
	and(wire_n101iO_dataout, n11O1l, wire_nlOi11i_dataout);
	and(wire_n101li_dataout, (rclkcmpsqmd & (nlii1li & (~ n11O1l))), wire_nlOi11i_dataout);
	and(wire_n101ll_dataout, nlii1li, wire_nlOi11i_dataout);
	assign		wire_n10i_dataout = (rwa_6g_en === 1'b1) ? nl10OO : n10lOl;
	assign		wire_n10l_dataout = (rwa_6g_en === 1'b1) ? nl1i1i : n10lOO;
	assign		wire_n10O_dataout = (rwa_6g_en === 1'b1) ? nl1i1l : n10O1i;
	and(wire_n10O0i_dataout, wire_n1iiiO_dataout, ~(nlii00O));
	and(wire_n10O0l_dataout, wire_n1iili_dataout, ~(nlii00O));
	and(wire_n10O0O_dataout, wire_n1iill_dataout, ~(nlii00O));
	and(wire_n10Oii_dataout, wire_n1iilO_dataout, ~(nlii00O));
	and(wire_n10Oil_dataout, wire_n1iiOi_dataout, ~(nlii00O));
	and(wire_n10OiO_dataout, wire_n1iiOl_dataout, ~(nlii00O));
	and(wire_n10Oli_dataout, wire_n1iiOO_dataout, ~(nlii00O));
	and(wire_n10Oll_dataout, wire_n1il1i_dataout, ~(nlii00O));
	and(wire_n10OlO_dataout, wire_n1il1l_dataout, ~(nlii00O));
	and(wire_n10OOi_dataout, wire_n1il1O_dataout, ~(nlii00O));
	and(wire_n10OOl_dataout, wire_n1il0i_dataout, ~(nlii00O));
	or(wire_n10OOO_dataout, wire_n1il0l_dataout, nlii00O);
	assign		wire_n1100i_dataout = (rclkcmpinsertpad === 1'b1) ? (~ nlOliOl) : nlOliOl;
	assign		wire_n1100l_dataout = (rclkcmpinsertpad === 1'b1) ? nlOliOl : (~ nlOliOl);
	assign		wire_n1100O_dataout = (nlilOiO === 1'b1) ? (nli0OiO | nlOll1l) : nli0OiO;
	or(wire_n1101i_dataout, nlOll1i, nlii1li);
	and(wire_n110Oi_dataout, nliO01l, ~(nlii00O));
	and(wire_n110Ol_dataout, ((((n1lili & nliO01l) & (~ n110li)) & (rskpsetbased | nli0Oll)) & (~ nli0Oli)), ~(nlii00O));
	assign		wire_n1110i_dataout = (nlii1li === 1'b1) ? nlOiOlO : nlOli1O;
	assign		wire_n1110l_dataout = (nlii1li === 1'b1) ? nlOiOOi : nlOli0i;
	assign		wire_n1110O_dataout = (nlii1li === 1'b1) ? nlOiOOl : nlOli0l;
	assign		wire_n1111i_dataout = (nlii1li === 1'b1) ? nlOiOil : nlOl0OO;
	assign		wire_n1111l_dataout = (nlii1li === 1'b1) ? nlOiOli : nlOli1i;
	assign		wire_n1111O_dataout = (nlii1li === 1'b1) ? nlOiOll : nlOli1l;
	assign		wire_n111ii_dataout = (nlii1li === 1'b1) ? nlOiOOO : nlOli0O;
	assign		wire_n111il_dataout = (nlii1li === 1'b1) ? nlOl11i : nlOliii;
	assign		wire_n111iO_dataout = (nlii1li === 1'b1) ? nlOl11l : nlOliil;
	assign		wire_n111li_dataout = (nlii1li === 1'b1) ? nlOl11O : nlOliiO;
	and(wire_n111ll_dataout, nlOlili, ~(nlii1li));
	assign		wire_n111lO_dataout = (nlii1li === 1'b1) ? nlOl10i : nlOlill;
	and(wire_n111Oi_dataout, nlOlilO, ~(nlii1li));
	assign		wire_n111Ol_dataout = (nlii1li === 1'b1) ? nlOl10l : nlOliOl;
	and(wire_n111OO_dataout, nlOliOO, ~(nlii1li));
	assign		wire_n11i_dataout = (rwa_6g_en === 1'b1) ? nl10lO : n10lll;
	assign		wire_n11l_dataout = (rwa_6g_en === 1'b1) ? nl10Oi : n10llO;
	and(wire_n11l0i_dataout, wire_n11lll_dataout, ~(nlii00O));
	and(wire_n11l0l_dataout, wire_n11llO_dataout, ~(nlii00O));
	and(wire_n11l0O_dataout, wire_n11lOi_dataout, ~(nlii00O));
	and(wire_n11l1i_dataout, nlii1li, ~(nlii00O));
	and(wire_n11l1l_dataout, wire_n11liO_dataout, ~(nlii00O));
	and(wire_n11l1O_dataout, wire_n11lli_dataout, ~(nlii00O));
	and(wire_n11lii_dataout, wire_n11lOl_dataout, ~(nlii00O));
	and(wire_n11lil_dataout, wire_n11lOO_dataout, ~(nlii00O));
	and(wire_n11liO_dataout, n110lO, ~(nlii1li));
	and(wire_n11lli_dataout, n11iil, ~(nlii1li));
	and(wire_n11lll_dataout, n11iiO, ~(nlii1li));
	and(wire_n11llO_dataout, n11ili, ~(nlii1li));
	and(wire_n11lOi_dataout, n11ill, ~(nlii1li));
	and(wire_n11lOl_dataout, n11ilO, ~(nlii1li));
	and(wire_n11lOO_dataout, n11iOi, ~(nlii1li));
	assign		wire_n11O_dataout = (rwa_6g_en === 1'b1) ? nl10Ol : n10lOi;
	and(wire_n11Oii_dataout, wire_n11Oli_dataout, wire_nlOi11i_dataout);
	and(wire_n11Oil_dataout, wire_n11Oll_dataout, wire_nlOi11i_dataout);
	and(wire_n11OiO_dataout, wire_n11OlO_dataout, wire_nlOi11i_dataout);
	or(wire_n11Oli_dataout, wire_n11OOi_dataout, nli0OOO);
	and(wire_n11Oll_dataout, wire_n11OOl_dataout, ~(nli0OOO));
	and(wire_n11OlO_dataout, wire_n11OOO_dataout, ~(nli0OOO));
	assign		wire_n11OOi_dataout = (nli0OOl === 1'b1) ? wire_n1010i_o[0] : wire_n1011i_dataout;
	assign		wire_n11OOl_dataout = (nli0OOl === 1'b1) ? wire_n1010i_o[1] : wire_n1011l_dataout;
	assign		wire_n11OOO_dataout = (nli0OOl === 1'b1) ? wire_n1010i_o[2] : wire_n1011O_dataout;
	or(wire_n1i00i_dataout, wire_n1iOiO_dataout, nlii00O);
	and(wire_n1i00l_dataout, wire_n1iOli_dataout, ~(nlii00O));
	and(wire_n1i00O_dataout, wire_n1iOll_dataout, ~(nlii00O));
	and(wire_n1i01i_dataout, wire_n1iO0O_dataout, ~(nlii00O));
	and(wire_n1i01l_dataout, wire_n1iOii_dataout, ~(nlii00O));
	and(wire_n1i01O_dataout, wire_n1iOil_dataout, ~(nlii00O));
	and(wire_n1i0ii_dataout, wire_n1iOlO_dataout, ~(nlii00O));
	and(wire_n1i0il_dataout, wire_n1iOOi_dataout, ~(nlii00O));
	and(wire_n1i0iO_dataout, wire_n1iOOl_dataout, ~(nlii00O));
	and(wire_n1i0li_dataout, wire_n1iOOO_dataout, ~(nlii00O));
	and(wire_n1i0ll_dataout, wire_n1l11i_dataout, ~(nlii00O));
	and(wire_n1i0lO_dataout, wire_n1l11l_dataout, ~(nlii00O));
	and(wire_n1i0Oi_dataout, wire_n1l11O_dataout, ~(nlii00O));
	and(wire_n1i0Ol_dataout, wire_n1l10i_dataout, ~(nlii00O));
	and(wire_n1i0OO_dataout, wire_n1l10l_dataout, ~(nlii00O));
	and(wire_n1i10i_dataout, wire_n1iliO_dataout, ~(nlii00O));
	and(wire_n1i10l_dataout, wire_n1illi_dataout, ~(nlii00O));
	and(wire_n1i10O_dataout, wire_n1illl_dataout, ~(nlii00O));
	and(wire_n1i11i_dataout, wire_n1il0O_dataout, ~(nlii00O));
	and(wire_n1i11l_dataout, wire_n1ilii_dataout, ~(nlii00O));
	and(wire_n1i11O_dataout, wire_n1ilil_dataout, ~(nlii00O));
	and(wire_n1i1ii_dataout, wire_n1illO_dataout, ~(nlii00O));
	and(wire_n1i1il_dataout, wire_n1ilOi_dataout, ~(nlii00O));
	and(wire_n1i1iO_dataout, wire_n1ilOl_dataout, ~(nlii00O));
	and(wire_n1i1li_dataout, wire_n1ilOO_dataout, ~(nlii00O));
	and(wire_n1i1ll_dataout, wire_n1iO1i_dataout, ~(nlii00O));
	and(wire_n1i1lO_dataout, wire_n1iO1l_dataout, ~(nlii00O));
	and(wire_n1i1Oi_dataout, wire_n1iO1O_dataout, ~(nlii00O));
	and(wire_n1i1Ol_dataout, wire_n1iO0i_dataout, ~(nlii00O));
	and(wire_n1i1OO_dataout, wire_n1iO0l_dataout, ~(nlii00O));
	assign		wire_n1ii_dataout = (rwa_6g_en === 1'b1) ? nl1i1O : n10O1l;
	and(wire_n1ii0i_dataout, wire_n1l1iO_dataout, ~(nlii00O));
	and(wire_n1ii0l_dataout, wire_n1l1li_dataout, ~(nlii00O));
	and(wire_n1ii0O_dataout, wire_n1l1ll_dataout, ~(nlii00O));
	and(wire_n1ii1i_dataout, wire_n1l10O_dataout, ~(nlii00O));
	and(wire_n1ii1l_dataout, wire_n1l1ii_dataout, ~(nlii00O));
	and(wire_n1ii1O_dataout, wire_n1l1il_dataout, ~(nlii00O));
	and(wire_n1iiii_dataout, wire_n1l1lO_dataout, ~(nlii00O));
	and(wire_n1iiil_dataout, wire_n1l1Oi_dataout, ~(nlii00O));
	assign		wire_n1iiiO_dataout = (nlii10l === 1'b1) ? nlii11i : n11O0O;
	assign		wire_n1iili_dataout = (nlii10l === 1'b1) ? (((wire_n1l01l_o[4] | wire_n1l01l_o[3]) | wire_n1l01l_o[2]) | wire_n1l01l_o[1]) : n101Ol;
	assign		wire_n1iill_dataout = (nlii10l === 1'b1) ? nlii11l : n101OO;
	assign		wire_n1iilO_dataout = (nlii10l === 1'b1) ? nlii11O : n1001i;
	assign		wire_n1iiOi_dataout = (nlii10l === 1'b1) ? (((wire_n1l00O_o[18] | wire_n1l00O_o[17]) | wire_n1l00O_o[16]) | wire_n1l00O_o[15]) : n1001l;
	assign		wire_n1iiOl_dataout = (nlii10l === 1'b1) ? wire_n1l0ii_dataout : n1001O;
	assign		wire_n1iiOO_dataout = (nlii10l === 1'b1) ? wire_n1l0il_dataout : n1000i;
	assign		wire_n1il_dataout = (rwa_6g_en === 1'b1) ? wire_ni1i1i_o : wire_nlli0iO_o;
	assign		wire_n1il0i_dataout = (nlii10l === 1'b1) ? n10ilO : n100il;
	assign		wire_n1il0l_dataout = (nlii10l === 1'b1) ? n100il : n100iO;
	assign		wire_n1il0O_dataout = (nlii10l === 1'b1) ? n100iO : n100li;
	assign		wire_n1il1i_dataout = (nlii10l === 1'b1) ? wire_n1l0iO_dataout : n1000l;
	assign		wire_n1il1l_dataout = (nlii10l === 1'b1) ? wire_n1l0li_dataout : n1000O;
	assign		wire_n1il1O_dataout = (nlii10l === 1'b1) ? wire_n1l0ll_dataout : n100ii;
	assign		wire_n1ilii_dataout = (nlii10l === 1'b1) ? n100li : n100ll;
	assign		wire_n1ilil_dataout = (nlii10l === 1'b1) ? n100ll : n100lO;
	assign		wire_n1iliO_dataout = (nlii10l === 1'b1) ? n100lO : n100Oi;
	assign		wire_n1illi_dataout = (nlii10l === 1'b1) ? n100Oi : n100Ol;
	assign		wire_n1illl_dataout = (nlii10l === 1'b1) ? n100Ol : n100OO;
	assign		wire_n1illO_dataout = (nlii10l === 1'b1) ? n100OO : n10i1i;
	assign		wire_n1ilOi_dataout = (nlii10l === 1'b1) ? n10i1i : n10i1l;
	assign		wire_n1ilOl_dataout = (nlii10l === 1'b1) ? n10i1l : n10i1O;
	assign		wire_n1ilOO_dataout = (nlii10l === 1'b1) ? n10i1O : n10i0i;
	assign		wire_n1iO_dataout = (rwa_6g_en === 1'b1) ? wire_nllOiO_o : wire_n1OllO_o;
	assign		wire_n1iO0i_dataout = (nlii10l === 1'b1) ? n10iii : n10iil;
	assign		wire_n1iO0l_dataout = (nlii10l === 1'b1) ? n10iil : n10iiO;
	assign		wire_n1iO0O_dataout = (nlii10l === 1'b1) ? n10iiO : n10ili;
	assign		wire_n1iO1i_dataout = (nlii10l === 1'b1) ? n10i0i : n10i0l;
	assign		wire_n1iO1l_dataout = (nlii10l === 1'b1) ? n10i0l : n10i0O;
	assign		wire_n1iO1O_dataout = (nlii10l === 1'b1) ? n10i0O : n10iii;
	assign		wire_n1iOii_dataout = (nlii10l === 1'b1) ? n10ili : n10ill;
	assign		wire_n1iOil_dataout = (nlii10l === 1'b1) ? n10ill : n10ilO;
	assign		wire_n1iOiO_dataout = (nlii10l === 1'b1) ? n10O1l : n10iOi;
	assign		wire_n1iOli_dataout = (nlii10l === 1'b1) ? n10iOi : n10iOl;
	assign		wire_n1iOll_dataout = (nlii10l === 1'b1) ? n10iOl : n10iOO;
	assign		wire_n1iOlO_dataout = (nlii10l === 1'b1) ? n10iOO : n10l1i;
	assign		wire_n1iOOi_dataout = (nlii10l === 1'b1) ? n10l1i : n10l1l;
	assign		wire_n1iOOl_dataout = (nlii10l === 1'b1) ? n10l1l : n10l1O;
	assign		wire_n1iOOO_dataout = (nlii10l === 1'b1) ? n10l1O : n10l0i;
	and(wire_n1l0ii_dataout, wire_n1l0lO_o[0], ~(nlii10i));
	and(wire_n1l0il_dataout, wire_n1l0lO_o[1], ~(nlii10i));
	and(wire_n1l0iO_dataout, wire_n1l0lO_o[2], ~(nlii10i));
	and(wire_n1l0li_dataout, wire_n1l0lO_o[3], ~(nlii10i));
	and(wire_n1l0ll_dataout, wire_n1l0lO_o[4], ~(nlii10i));
	assign		wire_n1l10i_dataout = (nlii10l === 1'b1) ? n10lii : n10lil;
	assign		wire_n1l10l_dataout = (nlii10l === 1'b1) ? n10lil : n10liO;
	assign		wire_n1l10O_dataout = (nlii10l === 1'b1) ? n10liO : n10lli;
	assign		wire_n1l11i_dataout = (nlii10l === 1'b1) ? n10l0i : n10l0l;
	assign		wire_n1l11l_dataout = (nlii10l === 1'b1) ? n10l0l : n10l0O;
	assign		wire_n1l11O_dataout = (nlii10l === 1'b1) ? n10l0O : n10lii;
	assign		wire_n1l1ii_dataout = (nlii10l === 1'b1) ? n10lli : n10lll;
	assign		wire_n1l1il_dataout = (nlii10l === 1'b1) ? n10lll : n10llO;
	assign		wire_n1l1iO_dataout = (nlii10l === 1'b1) ? n10llO : n10lOi;
	assign		wire_n1l1li_dataout = (nlii10l === 1'b1) ? n10lOi : n10lOl;
	assign		wire_n1l1ll_dataout = (nlii10l === 1'b1) ? n10lOl : n10lOO;
	assign		wire_n1l1lO_dataout = (nlii10l === 1'b1) ? n10lOO : n10O1i;
	assign		wire_n1l1Oi_dataout = (nlii10l === 1'b1) ? n10O1i : n10O1l;
	assign		wire_n1li_dataout = (rwa_6g_en === 1'b1) ? wire_nllOli_o : wire_n1OlOi_o;
	assign		wire_n1li0i_dataout = (nlii10O === 1'b1) ? fifo_rd_in_comp_2 : n1lili;
	assign		wire_n1li1O_dataout = (nlii1ii === 1'b1) ? fifo_rd_in_comp_0 : wire_n1li0i_dataout;
	and(wire_n1lill_dataout, (((~ rgenericfifo) & n1lili) | nlii1iO), ~(nlii00O));
	and(wire_n1lilO_dataout, n1liiO, ~(nlii00O));
	and(wire_n1liOi_dataout, nllOOi, ~(nlii00O));
	assign		wire_n1ll_dataout = (rwa_6g_en === 1'b1) ? (wire_nllOil_o & wire_nllOii_o) : ((wire_n1OOOi_o & wire_n1OOlO_o) & (nlilO0O16 ^ nlilO0O15));
	assign		wire_n1lO_dataout = (rwa_6g_en === 1'b1) ? wire_nll11i_dataout : wire_nlOi1ll_dataout;
	and(wire_n1O0il_dataout, n1O0ii, ~(nlii00O));
	and(wire_n1O0iO_dataout, n1O00O, ~(nlii00O));
	and(wire_n1O0li_dataout, nlli11O, ~(nlii00O));
	and(wire_n1O0ll_dataout, nlli11l, ~(nlii00O));
	and(wire_n1O0lO_dataout, nlli11i, ~(nlii00O));
	and(wire_n1O0Oi_dataout, nlli00O, ~(nlii00O));
	and(wire_n1O0Ol_dataout, nlli1ii, ~(nlii00O));
	and(wire_n1O0OO_dataout, nlli1il, ~(nlii00O));
	assign		wire_n1O1ll_dataout = (nlilO0l === 1'b1) ? insert_incomplete_0 : n1liil;
	assign		wire_n1O1lO_dataout = (nlilO0l === 1'b1) ? latency_comp_0 : (~ nlillii);
	assign		wire_n1Oi_dataout = (rwa_6g_en === 1'b1) ? wire_nll11l_dataout : wire_nlOi1lO_dataout;
	and(wire_n1Oi1i_dataout, nlli1iO, ~(nlii00O));
	and(wire_n1Oi1l_dataout, nlli1li, ~(nlii00O));
	or(wire_n1Oi1O_dataout, (rskpsetbased & (nlii0li | nlii0iO)), ((~ rskpsetbased) & (nlii0il | nlii0ii)));
	assign		wire_n1Oiil_dataout = (rskpsetbased === 1'b1) ? (nlii0lO | nlii0ll) : (nlii0Ol | nlii0Oi);
	assign		wire_n1OiOi_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[0] : rclkcmpsq1n[10];
	assign		wire_n1OiOl_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[1] : rclkcmpsq1n[11];
	assign		wire_n1OiOO_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[2] : rclkcmpsq1n[12];
	assign		wire_n1Ol_dataout = (rwa_6g_en === 1'b1) ? wire_nll11O_dataout : wire_nlOi1Oi_dataout;
	assign		wire_n1Ol0i_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[6] : rclkcmpsq1n[16];
	assign		wire_n1Ol0l_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[7] : rclkcmpsq1n[17];
	assign		wire_n1Ol0O_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[8] : rclkcmpsq1n[18];
	assign		wire_n1Ol1i_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[3] : rclkcmpsq1n[13];
	assign		wire_n1Ol1l_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[4] : rclkcmpsq1n[14];
	assign		wire_n1Ol1O_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[5] : rclkcmpsq1n[15];
	assign		wire_n1Olii_dataout = (nliii1O === 1'b1) ? rclkcmpsq1n[9] : rclkcmpsq1n[19];
	assign		wire_n1Olli_dataout = (nlilO0l === 1'b1) ? fifo_ovr_0 : nlO01O;
	assign		wire_n1Olll_dataout = (nlilO0l === 1'b1) ? del_cond_met_0 : wire_n1OllO_o;
	assign		wire_n1OlOl_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[10] : rclkcmpsq1p[0];
	assign		wire_n1OlOO_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[11] : rclkcmpsq1p[1];
	assign		wire_n1OO_dataout = (rwa_6g_en === 1'b1) ? wire_nll10i_dataout : wire_nlOi1Ol_dataout;
	assign		wire_n1OO0i_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[15] : rclkcmpsq1p[5];
	assign		wire_n1OO0l_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[16] : rclkcmpsq1p[6];
	assign		wire_n1OO0O_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[17] : rclkcmpsq1p[7];
	assign		wire_n1OO1i_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[12] : rclkcmpsq1p[2];
	assign		wire_n1OO1l_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[13] : rclkcmpsq1p[3];
	assign		wire_n1OO1O_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[14] : rclkcmpsq1p[4];
	assign		wire_n1OOii_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[18] : rclkcmpsq1p[8];
	assign		wire_n1OOil_dataout = (nliii0i === 1'b1) ? rclkcmpsq1p[19] : rclkcmpsq1p[9];
	assign		wire_ni_dataout = (rwa_6g_en === 1'b1) ? ni101i : nllil0i;
	and(wire_ni000O_dataout, nliiO0O, ~(nliiO1i));
	and(wire_ni00ii_dataout, nliiO0O, ~(nliiO1i));
	and(wire_ni00li_dataout, (nliiOii & (nliiO1O | nliiO1l)), wire_nliOOi_dataout);
	and(wire_ni00ll_dataout, (nliiO0l | nliiO0i), wire_nliOOi_dataout);
	or(wire_ni00OO_dataout, ((nliiOli & (nliiOii & (wire_nliOOi_dataout & ni000l))) & (~ nliiO0O)), (rtruebac2bac & (nliiOli & (nliiOii & (wire_nliOOi_dataout & ni00iO)))));
	assign		wire_ni010i_dataout = ((~ nliilll) === 1'b1) ? wire_ni01ii_o[3] : ni1O1O;
	assign		wire_ni010l_dataout = ((~ nliilll) === 1'b1) ? wire_ni01ii_o[4] : ni1O0i;
	assign		wire_ni010O_dataout = ((~ nliilll) === 1'b1) ? wire_ni01ii_o[5] : ni1O0l;
	assign		wire_ni011i_dataout = (nliillO === 1'b1) ? wire_ni01il_o[4] : wire_ni010O_dataout;
	assign		wire_ni011l_dataout = ((~ nliilll) === 1'b1) ? wire_ni01ii_o[1] : ni1llO;
	assign		wire_ni011O_dataout = ((~ nliilll) === 1'b1) ? wire_ni01ii_o[2] : ni1O1l;
	and(wire_ni0i_dataout, wire_nll0il_dataout, rwa_6g_en);
	or(wire_ni0iiO_dataout, wire_ni0ili_dataout, (rtruebac2bac & (nliiOii & (nliiOli & (wire_nliOOi_dataout & ni00Oi)))));
	and(wire_ni0ili_dataout, ((nliiOli & nliiOii) & (~ nliiO0O)), (wire_nliOOi_dataout & ni00il));
	and(wire_ni0l_dataout, wire_nll0iO_dataout, rwa_6g_en);
	and(wire_ni0O_dataout, wire_nll0li_dataout, rwa_6g_en);
	or(wire_ni100i_dataout, ni11lO, nliiO1i);
	or(wire_ni100l_dataout, wire_nllOli_o, nliiO1i);
	or(wire_ni100O_dataout, wire_ni10iO_dataout, nliiO1i);
	and(wire_ni101O_dataout, ni11OO, ~(nliiO1i));
	and(wire_ni10ii_dataout, wire_nllOiO_o, ~(nliiO1i));
	and(wire_ni10il_dataout, wire_ni10lO_dataout, ~(nliiO1i));
	assign		wire_ni10iO_dataout = (nliO11i === 1'b1) ? (nliil1O | ni11ll) : nliil1O;
	assign		wire_ni10lO_dataout = (nliO11i === 1'b1) ? (nliil0i | ni110l) : nliil0i;
	and(wire_ni110O_dataout, ni101l, ~(nliiO1i));
	and(wire_ni11ii_dataout, ni1i1l, ~(nliiO1i));
	and(wire_ni11il_dataout, ni1i1O, ~(nliiO1i));
	and(wire_ni11iO_dataout, ni1i0i, ~(nliiO1i));
	and(wire_ni11li_dataout, ni1i0l, ~(nliiO1i));
	and(wire_ni1i_dataout, wire_nll00l_dataout, rwa_6g_en);
	and(wire_ni1iii_dataout, wire_ni1ilO_dataout, ~(nliiO1i));
	and(wire_ni1iil_dataout, wire_ni1iOi_dataout, ~(nliiO1i));
	and(wire_ni1iiO_dataout, wire_ni1iOl_dataout, ~(nliiO1i));
	and(wire_ni1ili_dataout, wire_ni1iOO_dataout, ~(nliiO1i));
	and(wire_ni1ill_dataout, wire_ni1l1i_dataout, ~(nliiO1i));
	and(wire_ni1ilO_dataout, wire_ni1l1l_dataout, ~(nliil0l));
	and(wire_ni1iOi_dataout, wire_ni1l1O_dataout, ~(nliil0l));
	assign		wire_ni1iOl_dataout = (nliil0l === 1'b1) ? n0Ol0O : wire_ni1l0i_dataout;
	and(wire_ni1iOO_dataout, wire_ni1l0l_dataout, ~(nliil0l));
	and(wire_ni1l_dataout, wire_nll00O_dataout, rwa_6g_en);
	assign		wire_ni1l0i_dataout = (wire_ni1lli_o === 1'b1) ? wire_ni1liO_o[3] : wire_ni1lii_o[3];
	assign		wire_ni1l0l_dataout = (wire_ni1lli_o === 1'b1) ? wire_ni1liO_o[4] : wire_ni1lii_o[4];
	assign		wire_ni1l0O_dataout = (wire_ni1lli_o === 1'b1) ? wire_ni1liO_o[5] : wire_ni1lii_o[5];
	assign		wire_ni1l1i_dataout = (nliil0l === 1'b1) ? n0Ol0O : wire_ni1l0O_dataout;
	assign		wire_ni1l1l_dataout = (wire_ni1lli_o === 1'b1) ? wire_ni1liO_o[1] : wire_ni1lii_o[1];
	assign		wire_ni1l1O_dataout = (wire_ni1lli_o === 1'b1) ? wire_ni1liO_o[2] : wire_ni1lii_o[2];
	and(wire_ni1lOi_dataout, nliilli, ~(nliiO1i));
	and(wire_ni1O_dataout, wire_nll0ii_dataout, rwa_6g_en);
	and(wire_ni1Oii_dataout, wire_ni1OlO_dataout, ~(nliiO1i));
	and(wire_ni1Oil_dataout, wire_ni1OOi_dataout, ~(nliiO1i));
	and(wire_ni1OiO_dataout, wire_ni1OOl_dataout, ~(nliiO1i));
	and(wire_ni1Oli_dataout, wire_ni1OOO_dataout, ~(nliiO1i));
	and(wire_ni1Oll_dataout, wire_ni011i_dataout, ~(nliiO1i));
	assign		wire_ni1OlO_dataout = (nliillO === 1'b1) ? wire_ni01il_o[0] : wire_ni011l_dataout;
	assign		wire_ni1OOi_dataout = (nliillO === 1'b1) ? wire_ni01il_o[1] : wire_ni011O_dataout;
	assign		wire_ni1OOl_dataout = (nliillO === 1'b1) ? wire_ni01il_o[2] : wire_ni010i_dataout;
	assign		wire_ni1OOO_dataout = (nliillO === 1'b1) ? wire_ni01il_o[3] : wire_ni010l_dataout;
	and(wire_niii_dataout, wire_nll0ll_dataout, rwa_6g_en);
	assign		wire_niii0i_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nil1Oi_dataout;
	assign		wire_niii0l_dataout = (nlil0l === 1'b1) ? wire_niOlOi_dataout : wire_nil1Ol_dataout;
	assign		wire_niii0O_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nil1OO_dataout;
	assign		wire_niii1l_dataout = (nlil0l === 1'b1) ? wire_niOllO_dataout : wire_nil1ll_dataout;
	assign		wire_niii1O_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nil1lO_dataout;
	assign		wire_niiiii_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nil01i_dataout;
	assign		wire_niiiil_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nil01l_dataout;
	assign		wire_niiiiO_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nil01O_dataout;
	assign		wire_niiili_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nil00i_dataout;
	assign		wire_niiill_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nil00l_dataout;
	and(wire_niiilO_dataout, wire_nil00O_dataout, ~(nlil0l));
	assign		wire_niiiOi_dataout = (nlil0l === 1'b1) ? nii0li : wire_nil0ii_dataout;
	and(wire_niiiOl_dataout, wire_nil0il_dataout, ~(nlil0l));
	assign		wire_niiiOO_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nil0iO_dataout;
	and(wire_niil_dataout, wire_nll0lO_dataout, rwa_6g_en);
	assign		wire_niil0i_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nil0Oi_dataout;
	assign		wire_niil0l_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nil0Ol_dataout;
	assign		wire_niil0O_dataout = (nlil0l === 1'b1) ? wire_niOlOi_dataout : wire_nil0OO_dataout;
	and(wire_niil1i_dataout, wire_nil0li_dataout, ~(nlil0l));
	or(wire_niil1l_dataout, wire_nil0ll_dataout, nlil0l);
	assign		wire_niil1O_dataout = (nlil0l === 1'b1) ? wire_niOllO_dataout : wire_nil0lO_dataout;
	assign		wire_niilii_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nili1i_dataout;
	assign		wire_niilil_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nili1l_dataout;
	assign		wire_niiliO_dataout = (nlil0l === 1'b1) ? (~ nii0Oi) : wire_nili1O_dataout;
	assign		wire_niilli_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nili0i_dataout;
	assign		wire_niilll_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nili0l_dataout;
	assign		wire_niillO_dataout = (nlil0l === 1'b1) ? nii0Oi : wire_nili0O_dataout;
	and(wire_niilOi_dataout, wire_niliii_dataout, ~(nlil0l));
	and(wire_niilOl_dataout, wire_niliiO_dataout, ~(nlil0l));
	and(wire_niilOO_dataout, wire_nilill_dataout, ~(nlil0l));
	and(wire_niiO_dataout, wire_nll0Oi_dataout, rwa_6g_en);
	assign		wire_niiO0i_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[2] : ni0lli;
	assign		wire_niiO0l_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[3] : ni0lll;
	assign		wire_niiO0O_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[4] : ni0llO;
	or(wire_niiO1i_dataout, wire_nililO_dataout, nlil0l);
	assign		wire_niiO1l_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[0] : ni00Ol;
	assign		wire_niiO1O_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[1] : ni0liO;
	assign		wire_niiOi_dataout = (rwa_6g_en === 1'b1) ? wire_nliOOO_dataout : wire_nlOi1il_dataout;
	assign		wire_niiOii_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[5] : ni0lOi;
	assign		wire_niiOil_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[6] : ni0lOl;
	assign		wire_niiOiO_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[7] : ni0lOO;
	assign		wire_niiOl_dataout = (rwa_6g_en === 1'b1) ? wire_nll11i_dataout : wire_nlOi1ll_dataout;
	assign		wire_niiOli_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[8] : ni0O1i;
	assign		wire_niiOll_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out2[9] : ni0O1l;
	assign		wire_niiOO_dataout = (rwa_6g_en === 1'b1) ? wire_nll11l_dataout : wire_nlOi1lO_dataout;
	assign		wire_nil00i_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[8] : wire_nill0O_dataout;
	assign		wire_nil00l_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[9] : wire_nillii_dataout;
	assign		wire_nil00O_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[10] : wire_nillil_dataout;
	assign		wire_nil01i_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[5] : wire_nill1O_dataout;
	assign		wire_nil01l_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[6] : wire_nill0i_dataout;
	assign		wire_nil01O_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[7] : wire_nill0l_dataout;
	assign		wire_nil0i_dataout = (rwa_6g_en === 1'b1) ? wire_nll10O_dataout : wire_nlOi01i_dataout;
	assign		wire_nil0ii_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[11] : wire_nilliO_dataout;
	assign		wire_nil0il_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[12] : wire_nillli_dataout;
	assign		wire_nil0iO_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[13] : wire_nillll_dataout;
	assign		wire_nil0l_dataout = (rwa_6g_en === 1'b1) ? wire_nll1ii_dataout : wire_nlOi01l_dataout;
	and(wire_nil0li_dataout, wire_nllOll_data_out1[14], nlil10O);
	or(wire_nil0ll_dataout, wire_nllOll_data_out1[15], ~(nlil10O));
	assign		wire_nil0lO_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[0] : wire_nilllO_dataout;
	assign		wire_nil0O_dataout = (rwa_6g_en === 1'b1) ? wire_nll1il_dataout : wire_nlOi01O_dataout;
	assign		wire_nil0Oi_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[1] : wire_nillOi_dataout;
	assign		wire_nil0Ol_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[2] : wire_nillOl_dataout;
	assign		wire_nil0OO_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[3] : wire_nillOO_dataout;
	assign		wire_nil10i_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[3] : ni0O0O;
	assign		wire_nil10l_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[4] : ni0Oii;
	assign		wire_nil10O_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[5] : ni0Oil;
	assign		wire_nil11i_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[0] : ni0O1O;
	assign		wire_nil11l_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[1] : ni0O0i;
	assign		wire_nil11O_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[2] : ni0O0l;
	assign		wire_nil1i_dataout = (rwa_6g_en === 1'b1) ? wire_nll11O_dataout : wire_nlOi1Oi_dataout;
	assign		wire_nil1ii_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[6] : ni0OiO;
	assign		wire_nil1il_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[7] : ni0Oli;
	assign		wire_nil1iO_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[8] : ni0Oll;
	assign		wire_nil1l_dataout = (rwa_6g_en === 1'b1) ? wire_nll10i_dataout : wire_nlOi1Ol_dataout;
	assign		wire_nil1li_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out2[9] : ni0OlO;
	assign		wire_nil1ll_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[0] : wire_niliOi_dataout;
	assign		wire_nil1lO_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[1] : wire_niliOl_dataout;
	assign		wire_nil1O_dataout = (rwa_6g_en === 1'b1) ? wire_nll10l_dataout : wire_nlOi1OO_dataout;
	assign		wire_nil1Oi_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[2] : wire_niliOO_dataout;
	assign		wire_nil1Ol_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[3] : wire_nill1i_dataout;
	assign		wire_nil1OO_dataout = (nlil10O === 1'b1) ? wire_nllOll_data_out1[4] : wire_nill1l_dataout;
	and(wire_nili_dataout, wire_nll0Ol_dataout, rwa_6g_en);
	assign		wire_nili0i_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[7] : wire_nilO0i_dataout;
	assign		wire_nili0l_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[8] : wire_nilO0l_dataout;
	assign		wire_nili0O_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[9] : wire_nilO0O_dataout;
	assign		wire_nili1i_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[4] : wire_nilO1i_dataout;
	assign		wire_nili1l_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[5] : wire_nilO1l_dataout;
	assign		wire_nili1O_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[6] : wire_nilO1O_dataout;
	assign		wire_nilii_dataout = (rwa_6g_en === 1'b1) ? wire_nll1iO_dataout : wire_nlOi00i_dataout;
	assign		wire_niliii_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[10] : wire_nilOii_dataout;
	assign		wire_niliil_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[11] : nii0li;
	assign		wire_niliiO_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[12] : wire_nilOil_dataout;
	assign		wire_nilil_dataout = (rwa_6g_en === 1'b1) ? wire_nll1li_dataout : wire_nlOi00l_dataout;
	assign		wire_nilili_dataout = (nlil10O === 1'b1) ? wire_nllOlO_data_out1[13] : nii0Oi;
	and(wire_nilill_dataout, wire_nllOlO_data_out1[14], nlil10O);
	or(wire_nililO_dataout, wire_nllOlO_data_out1[15], ~(nlil10O));
	and(wire_niliO_dataout, wire_nll01l_dataout, rwa_6g_en);
	assign		wire_niliOi_dataout = (nlil10l === 1'b1) ? ni0OOi : wire_nilOiO_dataout;
	assign		wire_niliOl_dataout = (nlil10l === 1'b1) ? ni0OOl : wire_nilOli_dataout;
	assign		wire_niliOO_dataout = (nlil10l === 1'b1) ? ni0OOO : wire_nilOll_dataout;
	and(wire_nill_dataout, wire_nll0OO_dataout, rwa_6g_en);
	assign		wire_nill0i_dataout = (nlil10l === 1'b1) ? nii10i : wire_nilOOO_dataout;
	assign		wire_nill0l_dataout = (nlil10l === 1'b1) ? nii10l : wire_niO11i_dataout;
	assign		wire_nill0O_dataout = (nlil10l === 1'b1) ? nii10O : wire_niO11l_dataout;
	assign		wire_nill1i_dataout = (nlil10l === 1'b1) ? nii11i : wire_nilOlO_dataout;
	assign		wire_nill1l_dataout = (nlil10l === 1'b1) ? nii11l : wire_nilOOi_dataout;
	assign		wire_nill1O_dataout = (nlil10l === 1'b1) ? nii11O : wire_nilOOl_dataout;
	and(wire_nilli_dataout, wire_nll01O_dataout, rwa_6g_en);
	assign		wire_nillii_dataout = (nlil10l === 1'b1) ? nii1ii : wire_niO11O_dataout;
	and(wire_nillil_dataout, nii1il, nlil10l);
	assign		wire_nilliO_dataout = (nlil10l === 1'b1) ? nii1iO : nii0li;
	and(wire_nilll_dataout, wire_nll00i_dataout, rwa_6g_en);
	and(wire_nillli_dataout, nii1li, nlil10l);
	assign		wire_nillll_dataout = (nlil10l === 1'b1) ? nii1ll : nii0Oi;
	assign		wire_nilllO_dataout = (nlil10l === 1'b1) ? nii1Ol : wire_niO0iO_dataout;
	and(wire_nillO_dataout, wire_nll00l_dataout, rwa_6g_en);
	assign		wire_nillOi_dataout = (nlil10l === 1'b1) ? nii1OO : wire_niO0li_dataout;
	assign		wire_nillOl_dataout = (nlil10l === 1'b1) ? nii01i : wire_niO0ll_dataout;
	assign		wire_nillOO_dataout = (nlil10l === 1'b1) ? nii01l : wire_niO0lO_dataout;
	and(wire_nilO_dataout, wire_nlli1i_dataout, rwa_6g_en);
	assign		wire_nilO0i_dataout = (nlil10l === 1'b1) ? nii00O : wire_niOi1i_dataout;
	assign		wire_nilO0l_dataout = (nlil10l === 1'b1) ? nii0ii : wire_niOi1l_dataout;
	assign		wire_nilO0O_dataout = (nlil10l === 1'b1) ? nii0il : wire_niOi1O_dataout;
	assign		wire_nilO1i_dataout = (nlil10l === 1'b1) ? nii01O : wire_niO0Oi_dataout;
	assign		wire_nilO1l_dataout = (nlil10l === 1'b1) ? nii00i : wire_niO0Ol_dataout;
	assign		wire_nilO1O_dataout = (nlil10l === 1'b1) ? nii00l : wire_niO0OO_dataout;
	and(wire_nilOi_dataout, wire_nll00O_dataout, rwa_6g_en);
	and(wire_nilOii_dataout, nii0iO, nlil10l);
	and(wire_nilOil_dataout, nii0ll, nlil10l);
	assign		wire_nilOiO_dataout = (nii0Oi === 1'b1) ? wire_niO1Ol_dataout : wire_niO10i_dataout;
	and(wire_nilOl_dataout, wire_nll0ii_dataout, rwa_6g_en);
	assign		wire_nilOli_dataout = (nii0Oi === 1'b1) ? wire_niO1OO_dataout : wire_niO10l_dataout;
	assign		wire_nilOll_dataout = (nii0Oi === 1'b1) ? wire_niO01i_dataout : wire_niO10O_dataout;
	assign		wire_nilOlO_dataout = (nii0Oi === 1'b1) ? wire_niO01l_dataout : wire_niO1ii_dataout;
	and(wire_nilOO_dataout, wire_nll0il_dataout, rwa_6g_en);
	assign		wire_nilOOi_dataout = (nii0Oi === 1'b1) ? wire_niO01O_dataout : wire_niO1il_dataout;
	assign		wire_nilOOl_dataout = (nii0Oi === 1'b1) ? wire_niO00i_dataout : wire_niO1iO_dataout;
	assign		wire_nilOOO_dataout = (nii0Oi === 1'b1) ? wire_niO00l_dataout : wire_niO1li_dataout;
	assign		wire_niO_dataout = (rindv_rx === 1'b1) ? gen2ngen1 : gen2ngen1_bundle;
	or(wire_niO00i_dataout, rclkcmpsq1p[15], nlil11l);
	and(wire_niO00l_dataout, rclkcmpsq1p[16], ~(nlil11l));
	or(wire_niO00O_dataout, rclkcmpsq1p[17], nlil11l);
	and(wire_niO01i_dataout, rclkcmpsq1p[12], ~(nlil11l));
	assign		wire_niO01l_dataout = (nlil11l === 1'b1) ? rclkcmpinsertpad : rclkcmpsq1p[13];
	and(wire_niO01O_dataout, rclkcmpsq1p[14], ~(nlil11l));
	assign		wire_niO0i_dataout = (rwa_6g_en === 1'b1) ? nliO1l : wire_nlOiiOi_dataout;
	or(wire_niO0ii_dataout, rclkcmpsq1p[18], nlil11l);
	or(wire_niO0il_dataout, rclkcmpsq1p[19], nlil11l);
	assign		wire_niO0iO_dataout = (nii0Oi === 1'b1) ? wire_niOiOl_dataout : wire_niOi0i_dataout;
	assign		wire_niO0l_dataout = (rwa_6g_en === 1'b1) ? nlliiO : wire_nlOiiOl_dataout;
	assign		wire_niO0li_dataout = (nii0Oi === 1'b1) ? wire_niOiOO_dataout : wire_niOi0l_dataout;
	assign		wire_niO0ll_dataout = (nii0Oi === 1'b1) ? wire_niOl1i_dataout : wire_niOi0O_dataout;
	assign		wire_niO0lO_dataout = (nii0Oi === 1'b1) ? wire_niOl1l_dataout : wire_niOiii_dataout;
	assign		wire_niO0O_dataout = (rwa_6g_en === 1'b1) ? nllili : wire_nlOiiOO_dataout;
	assign		wire_niO0Oi_dataout = (nii0Oi === 1'b1) ? wire_niOl1O_dataout : wire_niOiil_dataout;
	assign		wire_niO0Ol_dataout = (nii0Oi === 1'b1) ? wire_niOl0i_dataout : wire_niOiiO_dataout;
	assign		wire_niO0OO_dataout = (nii0Oi === 1'b1) ? wire_niOl0l_dataout : wire_niOili_dataout;
	assign		wire_niO10i_dataout = (nlil11i === 1'b1) ? rclkcmpinsertpad : rclkcmpsq1n[10];
	or(wire_niO10l_dataout, rclkcmpsq1n[11], nlil11i);
	or(wire_niO10O_dataout, rclkcmpsq1n[12], nlil11i);
	assign		wire_niO11i_dataout = (nii0Oi === 1'b1) ? wire_niO00O_dataout : wire_niO1ll_dataout;
	assign		wire_niO11l_dataout = (nii0Oi === 1'b1) ? wire_niO0ii_dataout : wire_niO1lO_dataout;
	assign		wire_niO11O_dataout = (nii0Oi === 1'b1) ? wire_niO0il_dataout : wire_niO1Oi_dataout;
	and(wire_niO1i_dataout, wire_nll0iO_dataout, rwa_6g_en);
	assign		wire_niO1ii_dataout = (nlil11i === 1'b1) ? (~ rclkcmpinsertpad) : rclkcmpsq1n[13];
	or(wire_niO1il_dataout, rclkcmpsq1n[14], nlil11i);
	and(wire_niO1iO_dataout, rclkcmpsq1n[15], ~(nlil11i));
	and(wire_niO1l_dataout, wire_nll0li_dataout, rwa_6g_en);
	or(wire_niO1li_dataout, rclkcmpsq1n[16], nlil11i);
	and(wire_niO1ll_dataout, rclkcmpsq1n[17], ~(nlil11i));
	and(wire_niO1lO_dataout, rclkcmpsq1n[18], ~(nlil11i));
	and(wire_niO1O_dataout, wire_nll0ll_dataout, rwa_6g_en);
	and(wire_niO1Oi_dataout, rclkcmpsq1n[19], ~(nlil11i));
	assign		wire_niO1Ol_dataout = (nlil11l === 1'b1) ? (~ rclkcmpinsertpad) : rclkcmpsq1p[10];
	and(wire_niO1OO_dataout, rclkcmpsq1p[11], ~(nlil11l));
	and(wire_niOi_dataout, wire_nlli1l_dataout, rwa_6g_en);
	assign		wire_niOi0i_dataout = (nlil11O === 1'b1) ? rclkcmpinsertpad : rclkcmpsq1n[10];
	or(wire_niOi0l_dataout, rclkcmpsq1n[11], nlil11O);
	or(wire_niOi0O_dataout, rclkcmpsq1n[12], nlil11O);
	assign		wire_niOi1i_dataout = (nii0Oi === 1'b1) ? wire_niOl0O_dataout : wire_niOill_dataout;
	assign		wire_niOi1l_dataout = (nii0Oi === 1'b1) ? wire_niOlii_dataout : wire_niOilO_dataout;
	assign		wire_niOi1O_dataout = (nii0Oi === 1'b1) ? wire_niOlil_dataout : wire_niOiOi_dataout;
	assign		wire_niOii_dataout = (rwa_6g_en === 1'b1) ? nllill : wire_nlOil1i_dataout;
	assign		wire_niOiii_dataout = (nlil11O === 1'b1) ? (~ rclkcmpinsertpad) : rclkcmpsq1n[13];
	or(wire_niOiil_dataout, rclkcmpsq1n[14], nlil11O);
	and(wire_niOiiO_dataout, rclkcmpsq1n[15], ~(nlil11O));
	assign		wire_niOil_dataout = (rwa_6g_en === 1'b1) ? nllilO : wire_nlOil1l_dataout;
	or(wire_niOili_dataout, rclkcmpsq1n[16], nlil11O);
	and(wire_niOill_dataout, rclkcmpsq1n[17], ~(nlil11O));
	and(wire_niOilO_dataout, rclkcmpsq1n[18], ~(nlil11O));
	assign		wire_niOiO_dataout = (rwa_6g_en === 1'b1) ? nlliOi : wire_nlOil1O_dataout;
	and(wire_niOiOi_dataout, rclkcmpsq1n[19], ~(nlil11O));
	assign		wire_niOiOl_dataout = (nlil10i === 1'b1) ? (~ rclkcmpinsertpad) : rclkcmpsq1p[10];
	and(wire_niOiOO_dataout, rclkcmpsq1p[11], ~(nlil10i));
	assign		wire_niOl_dataout = (rwa_6g_en === 1'b1) ? ni101l : nlO1OiO;
	or(wire_niOl0i_dataout, rclkcmpsq1p[15], nlil10i);
	and(wire_niOl0l_dataout, rclkcmpsq1p[16], ~(nlil10i));
	or(wire_niOl0O_dataout, rclkcmpsq1p[17], nlil10i);
	and(wire_niOl1i_dataout, rclkcmpsq1p[12], ~(nlil10i));
	assign		wire_niOl1l_dataout = (nlil10i === 1'b1) ? rclkcmpinsertpad : rclkcmpsq1p[13];
	and(wire_niOl1O_dataout, rclkcmpsq1p[14], ~(nlil10i));
	assign		wire_niOli_dataout = (rwa_6g_en === 1'b1) ? nlliOl : wire_nlOil0i_dataout;
	or(wire_niOlii_dataout, rclkcmpsq1p[18], nlil10i);
	or(wire_niOlil_dataout, rclkcmpsq1p[19], nlil10i);
	assign		wire_niOll_dataout = (rwa_6g_en === 1'b1) ? nlliOO : wire_nlOil0l_dataout;
	assign		wire_niOllO_dataout = (rclkcmpinsertpad === 1'b1) ? (~ nii0Oi) : nii0Oi;
	assign		wire_niOlO_dataout = (rwa_6g_en === 1'b1) ? nlll1i : wire_nlOil0O_dataout;
	assign		wire_niOlOi_dataout = (rclkcmpinsertpad === 1'b1) ? nii0Oi : (~ nii0Oi);
	assign		wire_niOO_dataout = (rwa_6g_en === 1'b1) ? ni1i1l : nlO1OOi;
	assign		wire_niOOi_dataout = (rwa_6g_en === 1'b1) ? nlll1l : wire_nlOilii_dataout;
	assign		wire_niOOl_dataout = (rwa_6g_en === 1'b1) ? nlll1O : wire_nlO0Oli_dataout;
	assign		wire_niOOO_dataout = (rwa_6g_en === 1'b1) ? nlll0i : wire_nlO0Oll_dataout;
	assign		wire_nl000i_dataout = (nlil1ll === 1'b1) ? wire_nl0OlO_dataout : niOOii;
	assign		wire_nl000l_dataout = (nlil1ll === 1'b1) ? nl11lO : niOOil;
	assign		wire_nl000O_dataout = (nlil1ll === 1'b1) ? niOOil : niOOiO;
	assign		wire_nl001i_dataout = (nlil1ll === 1'b1) ? wire_nl0OiO_dataout : niOO0i;
	assign		wire_nl001l_dataout = (nlil1ll === 1'b1) ? wire_nl0Oli_dataout : niOO0l;
	assign		wire_nl001O_dataout = (nlil1ll === 1'b1) ? wire_nl0Oll_dataout : niOO0O;
	and(wire_nl00i_dataout, (nlillOO | ni1O0O), rwa_6g_en);
	assign		wire_nl00ii_dataout = (nlil1ll === 1'b1) ? niOOiO : niOOli;
	assign		wire_nl00il_dataout = (nlil1ll === 1'b1) ? niOOli : niOOll;
	assign		wire_nl00iO_dataout = (nlil1ll === 1'b1) ? niOOll : niOOlO;
	and(wire_nl00l_dataout, ni000i, rwa_6g_en);
	assign		wire_nl00li_dataout = (nlil1ll === 1'b1) ? niOOlO : niOOOi;
	assign		wire_nl00ll_dataout = (nlil1ll === 1'b1) ? niOOOi : niOOOl;
	assign		wire_nl00lO_dataout = (nlil1ll === 1'b1) ? niOOOl : niOOOO;
	assign		wire_nl00O_dataout = (rwa_6g_en === 1'b1) ? wire_nliOOi_dataout : wire_nlOi10l_dataout;
	assign		wire_nl00Oi_dataout = (nlil1ll === 1'b1) ? niOOOO : nl111i;
	assign		wire_nl00Ol_dataout = (nlil1ll === 1'b1) ? nl111i : nl111l;
	assign		wire_nl00OO_dataout = (nlil1ll === 1'b1) ? nl111l : nl111O;
	and(wire_nl010i_dataout, wire_nl0liO_dataout, ~(nlil00l));
	and(wire_nl010l_dataout, wire_nl0lli_dataout, ~(nlil00l));
	and(wire_nl010O_dataout, wire_nl0lll_dataout, ~(nlil00l));
	and(wire_nl011i_dataout, wire_nl0l0O_dataout, ~(nlil00l));
	and(wire_nl011l_dataout, wire_nl0lii_dataout, ~(nlil00l));
	and(wire_nl011O_dataout, wire_nl0lil_dataout, ~(nlil00l));
	and(wire_nl01i_dataout, nllO1O, rwa_6g_en);
	and(wire_nl01ii_dataout, wire_nl0llO_dataout, ~(nlil00l));
	and(wire_nl01il_dataout, wire_nl0lOi_dataout, ~(nlil00l));
	and(wire_nl01iO_dataout, wire_nl0lOl_dataout, ~(nlil00l));
	and(wire_nl01l_dataout, nllO0i, rwa_6g_en);
	assign		wire_nl01li_dataout = (nlil1ll === 1'b1) ? nlil1ii : niii1i;
	assign		wire_nl01ll_dataout = (nlil1ll === 1'b1) ? (((wire_nl0O1O_o[4] | wire_nl0O1O_o[3]) | wire_nl0O1O_o[2]) | wire_nl0O1O_o[1]) : niOlOl;
	assign		wire_nl01lO_dataout = (nlil1ll === 1'b1) ? nlil1il : niOlOO;
	and(wire_nl01O_dataout, nllO0l, rwa_6g_en);
	assign		wire_nl01Oi_dataout = (nlil1ll === 1'b1) ? nlil1iO : niOO1i;
	assign		wire_nl01Ol_dataout = (nlil1ll === 1'b1) ? (((wire_nl0Oii_o[18] | wire_nl0Oii_o[17]) | wire_nl0Oii_o[16]) | wire_nl0Oii_o[15]) : niOO1l;
	assign		wire_nl01OO_dataout = (nlil1ll === 1'b1) ? wire_nl0Oil_dataout : niOO1O;
	and(wire_nl0i_dataout, nO, ~(scan_mode));
	assign		wire_nl0i0i_dataout = (nlil1ll === 1'b1) ? nl110O : nl11ii;
	assign		wire_nl0i0l_dataout = (nlil1ll === 1'b1) ? nl11ii : nl11il;
	assign		wire_nl0i0O_dataout = (nlil1ll === 1'b1) ? nl11il : nl11iO;
	assign		wire_nl0i1i_dataout = (nlil1ll === 1'b1) ? nl111O : nl110i;
	assign		wire_nl0i1l_dataout = (nlil1ll === 1'b1) ? nl110i : nl110l;
	assign		wire_nl0i1O_dataout = (nlil1ll === 1'b1) ? nl110l : nl110O;
	assign		wire_nl0ii_dataout = (rwa_6g_en === 1'b1) ? (rmatchen & (~ rgenericfifo)) : (((~ rgenericfifo) & ((((~ dskwclksel[1]) & rmatchen) | nlilO0l) | (~ (nlilO1O18 ^ nlilO1O17)))) & (nlilO1i20 ^ nlilO1i19));
	assign		wire_nl0iii_dataout = (nlil1ll === 1'b1) ? nl11iO : nl11li;
	assign		wire_nl0iil_dataout = (nlil1ll === 1'b1) ? nl11li : nl11ll;
	assign		wire_nl0iiO_dataout = (nlil1ll === 1'b1) ? nl11ll : nl11lO;
	assign		wire_nl0il_dataout = (rwa_6g_en === 1'b1) ? n0l0iO : nlllO0l;
	assign		wire_nl0ili_dataout = (nlil1ll === 1'b1) ? nl1i1O : nl11Ol;
	assign		wire_nl0ill_dataout = (nlil1ll === 1'b1) ? nl11Ol : nl11OO;
	assign		wire_nl0ilO_dataout = (nlil1ll === 1'b1) ? nl11OO : nl101i;
	assign		wire_nl0iO_dataout = (rwa_6g_en === 1'b1) ? n0l0li : nlllO0O;
	assign		wire_nl0iOi_dataout = (nlil1ll === 1'b1) ? nl101i : nl101l;
	assign		wire_nl0iOl_dataout = (nlil1ll === 1'b1) ? nl101l : nl101O;
	assign		wire_nl0iOO_dataout = (nlil1ll === 1'b1) ? nl101O : nl100i;
	assign		wire_nl0l0i_dataout = (nlil1ll === 1'b1) ? nl10ii : nl10il;
	assign		wire_nl0l0l_dataout = (nlil1ll === 1'b1) ? nl10il : nl10iO;
	assign		wire_nl0l0O_dataout = (nlil1ll === 1'b1) ? nl10iO : nl10li;
	assign		wire_nl0l1i_dataout = (nlil1ll === 1'b1) ? nl100i : nl100l;
	assign		wire_nl0l1l_dataout = (nlil1ll === 1'b1) ? nl100l : nl100O;
	assign		wire_nl0l1O_dataout = (nlil1ll === 1'b1) ? nl100O : nl10ii;
	assign		wire_nl0li_dataout = (rwa_6g_en === 1'b1) ? n0l0ll : nlllOii;
	assign		wire_nl0lii_dataout = (nlil1ll === 1'b1) ? nl10li : nl10ll;
	assign		wire_nl0lil_dataout = (nlil1ll === 1'b1) ? nl10ll : nl10lO;
	assign		wire_nl0liO_dataout = (nlil1ll === 1'b1) ? nl10lO : nl10Oi;
	assign		wire_nl0ll_dataout = (rwa_6g_en === 1'b1) ? n0l0lO : nlllOil;
	assign		wire_nl0lli_dataout = (nlil1ll === 1'b1) ? nl10Oi : nl10Ol;
	assign		wire_nl0lll_dataout = (nlil1ll === 1'b1) ? nl10Ol : nl10OO;
	assign		wire_nl0llO_dataout = (nlil1ll === 1'b1) ? nl10OO : nl1i1i;
	assign		wire_nl0lO_dataout = (rwa_6g_en === 1'b1) ? n0l0Oi : nlllOiO;
	assign		wire_nl0lOi_dataout = (nlil1ll === 1'b1) ? nl1i1i : nl1i1l;
	assign		wire_nl0lOl_dataout = (nlil1ll === 1'b1) ? nl1i1l : nl1i1O;
	assign		wire_nl0Oi_dataout = (rwa_6g_en === 1'b1) ? n0l0Ol : nlllOli;
	and(wire_nl0Oil_dataout, wire_nl0OOi_o[0], ~(nlil1li));
	and(wire_nl0OiO_dataout, wire_nl0OOi_o[1], ~(nlil1li));
	assign		wire_nl0Ol_dataout = (rwa_6g_en === 1'b1) ? n0l0OO : nlllOll;
	and(wire_nl0Oli_dataout, wire_nl0OOi_o[2], ~(nlil1li));
	and(wire_nl0Oll_dataout, wire_nl0OOi_o[3], ~(nlil1li));
	and(wire_nl0OlO_dataout, wire_nl0OOi_o[4], ~(nlil1li));
	assign		wire_nl0OO_dataout = (rwa_6g_en === 1'b1) ? n0li1i : nlllOlO;
	assign		wire_nl10i_dataout = (rwa_6g_en === 1'b1) ? ni000i : nlllliO;
	and(wire_nl10l_dataout, nlllii, rwa_6g_en);
	and(wire_nl10O_dataout, nlllil, rwa_6g_en);
	assign		wire_nl11i_dataout = (rwa_6g_en === 1'b1) ? nlll0l : wire_nlO0OlO_dataout;
	assign		wire_nl11l_dataout = (rwa_6g_en === 1'b1) ? nlll0O : wire_nlOiliO_dataout;
	assign		wire_nl11O_dataout = (rwa_6g_en === 1'b1) ? ((nlillOO | ni1O0O) | (~ (nlilliO24 ^ nlilliO23))) : (((nllllii | nlillOl) | nlillOi) | (~ (nlillll22 ^ nlillll21)));
	assign		wire_nl1i_dataout = (rwa_6g_en === 1'b1) ? ni1i1O : nlO1OOl;
	and(wire_nl1i0l_dataout, wire_nl01li_dataout, ~(nlil00l));
	and(wire_nl1i0O_dataout, wire_nl01ll_dataout, ~(nlil00l));
	and(wire_nl1ii_dataout, nllliO, rwa_6g_en);
	and(wire_nl1iii_dataout, wire_nl01lO_dataout, ~(nlil00l));
	and(wire_nl1iil_dataout, wire_nl01Oi_dataout, ~(nlil00l));
	and(wire_nl1iiO_dataout, wire_nl01Ol_dataout, ~(nlil00l));
	and(wire_nl1il_dataout, nlllli, rwa_6g_en);
	and(wire_nl1ili_dataout, wire_nl01OO_dataout, ~(nlil00l));
	and(wire_nl1ill_dataout, wire_nl001i_dataout, ~(nlil00l));
	and(wire_nl1ilO_dataout, wire_nl001l_dataout, ~(nlil00l));
	and(wire_nl1iO_dataout, nlllll, rwa_6g_en);
	and(wire_nl1iOi_dataout, wire_nl001O_dataout, ~(nlil00l));
	and(wire_nl1iOl_dataout, wire_nl000i_dataout, ~(nlil00l));
	and(wire_nl1iOO_dataout, wire_nl000l_dataout, ~(nlil00l));
	assign		wire_nl1l_dataout = (rwa_6g_en === 1'b1) ? ni1i0i : nlO1OOO;
	and(wire_nl1l0i_dataout, wire_nl00iO_dataout, ~(nlil00l));
	and(wire_nl1l0l_dataout, wire_nl00li_dataout, ~(nlil00l));
	and(wire_nl1l0O_dataout, wire_nl00ll_dataout, ~(nlil00l));
	or(wire_nl1l1i_dataout, wire_nl000O_dataout, nlil00l);
	and(wire_nl1l1l_dataout, wire_nl00ii_dataout, ~(nlil00l));
	and(wire_nl1l1O_dataout, wire_nl00il_dataout, ~(nlil00l));
	and(wire_nl1li_dataout, nllllO, rwa_6g_en);
	and(wire_nl1lii_dataout, wire_nl00lO_dataout, ~(nlil00l));
	and(wire_nl1lil_dataout, wire_nl00Oi_dataout, ~(nlil00l));
	and(wire_nl1liO_dataout, wire_nl00Ol_dataout, ~(nlil00l));
	and(wire_nl1ll_dataout, nlllOi, rwa_6g_en);
	and(wire_nl1lli_dataout, wire_nl00OO_dataout, ~(nlil00l));
	and(wire_nl1lll_dataout, wire_nl0i1i_dataout, ~(nlil00l));
	and(wire_nl1llO_dataout, wire_nl0i1l_dataout, ~(nlil00l));
	and(wire_nl1lO_dataout, nlllOl, rwa_6g_en);
	and(wire_nl1lOi_dataout, wire_nl0i1O_dataout, ~(nlil00l));
	and(wire_nl1lOl_dataout, wire_nl0i0i_dataout, ~(nlil00l));
	and(wire_nl1lOO_dataout, wire_nl0i0l_dataout, ~(nlil00l));
	assign		wire_nl1O_dataout = (rwa_6g_en === 1'b1) ? ni1i0l : nlO011i;
	and(wire_nl1O0i_dataout, wire_nl0iiO_dataout, ~(nlil00l));
	or(wire_nl1O0l_dataout, wire_nl0ili_dataout, nlil00l);
	and(wire_nl1O0O_dataout, wire_nl0ill_dataout, ~(nlil00l));
	and(wire_nl1O1i_dataout, wire_nl0i0O_dataout, ~(nlil00l));
	and(wire_nl1O1l_dataout, wire_nl0iii_dataout, ~(nlil00l));
	and(wire_nl1O1O_dataout, wire_nl0iil_dataout, ~(nlil00l));
	and(wire_nl1Oi_dataout, nlllOO, rwa_6g_en);
	and(wire_nl1Oii_dataout, wire_nl0ilO_dataout, ~(nlil00l));
	and(wire_nl1Oil_dataout, wire_nl0iOi_dataout, ~(nlil00l));
	and(wire_nl1OiO_dataout, wire_nl0iOl_dataout, ~(nlil00l));
	and(wire_nl1Ol_dataout, nllO1i, rwa_6g_en);
	and(wire_nl1Oli_dataout, wire_nl0iOO_dataout, ~(nlil00l));
	and(wire_nl1Oll_dataout, wire_nl0l1i_dataout, ~(nlil00l));
	and(wire_nl1OlO_dataout, wire_nl0l1l_dataout, ~(nlil00l));
	and(wire_nl1OO_dataout, nllO1l, rwa_6g_en);
	and(wire_nl1OOi_dataout, wire_nl0l1O_dataout, ~(nlil00l));
	and(wire_nl1OOl_dataout, wire_nl0l0i_dataout, ~(nlil00l));
	and(wire_nl1OOO_dataout, wire_nl0l0l_dataout, ~(nlil00l));
	assign		wire_nli_dataout = (rwa_6g_en === 1'b1) ? wire_nliiOO_dataout : wire_n1100O_dataout;
	and(wire_nli00i_dataout, nli1OO, ~(nlil00l));
	and(wire_nli00l_dataout, n0l00i, ~(nlil00l));
	and(wire_nli00O_dataout, n0l01O, ~(nlil00l));
	and(wire_nli01O_dataout, nli01l, ~(nlil00l));
	assign		wire_nli0i_dataout = (rwa_6g_en === 1'b1) ? n0li0l : nllO11i;
	and(wire_nli0ii_dataout, n0l01l, ~(nlil00l));
	and(wire_nli0iO_dataout, n0OiOO, ~(nlil00l));
	assign		wire_nli0l_dataout = (rwa_6g_en === 1'b1) ? n0li0O : nllO11l;
	and(wire_nli0li_dataout, n0Ol1l, ~(nlil00l));
	and(wire_nli0ll_dataout, n0Ol1O, ~(nlil00l));
	and(wire_nli0lO_dataout, n0Ol0i, ~(nlil00l));
	assign		wire_nli0O_dataout = (rwa_6g_en === 1'b1) ? n0liii : nllO11O;
	and(wire_nli0Oi_dataout, n0Ol0l, ~(nlil00l));
	assign		wire_nli1i_dataout = (rwa_6g_en === 1'b1) ? n0li1l : nlllOOi;
	assign		wire_nli1l_dataout = (rwa_6g_en === 1'b1) ? n0li1O : nlllOOl;
	assign		wire_nli1O_dataout = (rwa_6g_en === 1'b1) ? n0li0i : nlllOOO;
	assign		wire_nliii_dataout = (rwa_6g_en === 1'b1) ? n0liil : nllO10i;
	and(wire_nliiii_dataout, (((~ rgenericfifo) & nlii0O) | nlil01O), ~(nlil00l));
	and(wire_nliiil_dataout, nlii0l, ~(nlil00l));
	and(wire_nliiiO_dataout, nllOOi, ~(nlil00l));
	assign		wire_nliil_dataout = (rwa_6g_en === 1'b1) ? n0liiO : nllO10l;
	assign		wire_nliiO_dataout = (rwa_6g_en === 1'b1) ? n0lili : nllO10O;
	assign		wire_nliiOO_dataout = (nlilOiO === 1'b1) ? (nlil00i | nliiOi) : nlil00i;
	and(wire_nlil_dataout, nlli, ~(scan_mode));
	assign		wire_nlili_dataout = (rwa_6g_en === 1'b1) ? n0lill : nllO1ii;
	and(wire_nlilii_dataout, n0111i, ~(nlil00l));
	and(wire_nlilil_dataout, ((nlii0O & n0111i) & (~ nlil0i)), ~(nlil00l));
	assign		wire_nlill_dataout = (rwa_6g_en === 1'b1) ? n0lilO : nllO1il;
	assign		wire_nlilO_dataout = (rwa_6g_en === 1'b1) ? n0liOi : nllO1iO;
	and(wire_nlilOO_dataout, (nlil0il | nlil0ii), wire_nliOlO_dataout);
	and(wire_nliO00l_dataout, nliO01O, ~((~ nli0OlO)));
	and(wire_nliO00O_dataout, nliO00i, ~((~ nli0OlO)));
	and(wire_nliO0i_dataout, nlil0iO, wire_nliOlO_dataout);
	and(wire_nliO0ii_dataout, wire_n11iii_o, (rgenericfifo | wire_nlOi10l_dataout));
	assign		wire_nliO0l_dataout = ((((~ nlilOl) & nlil0O) & (~ nliliii)) === 1'b1) ? ((nlil0Oi | nlil0lO) | (~ (nlil0li48 ^ nlil0li47))) : wire_nliO0O_dataout;
	or(wire_nliO0O_dataout, (rtruebac2bac & (((~ nliliil) & nliliii) & (nlili0l44 ^ nlili0l43))), ((nlili0i | nlili1O) & ((nlili1l | nlili1i) | (~ (nlil0Ol46 ^ nlil0Ol45)))));
	and(wire_nliO1O_dataout, wire_nliO0l_dataout, wire_nliOlO_dataout);
	assign		wire_nliOi_dataout = (rwa_6g_en === 1'b1) ? niOOil : n100il;
	assign		wire_nliOl_dataout = (rwa_6g_en === 1'b1) ? niOOiO : n100iO;
	and(wire_nliOlO_dataout, nli0OO, ~(nliliiO));
	assign		wire_nliOO_dataout = (rwa_6g_en === 1'b1) ? niOOli : n100li;
	and(wire_nliOOi_dataout, sync_status, ~(nliliiO));
	assign		wire_nliOOO_dataout = (nlilili === 1'b1) ? nlii1l : sync_status;
	assign		wire_nll_dataout = (rwa_6g_en === 1'b1) ? ni11Ol : nllil1l;
	assign		wire_nll00i_dataout = (nlilili === 1'b1) ? nii01i : sudi[16];
	assign		wire_nll00l_dataout = (nlilili === 1'b1) ? nii01l : sudi[17];
	assign		wire_nll00O_dataout = (nlilili === 1'b1) ? nii01O : sudi[18];
	and(wire_nll01i_dataout, nii1Oi, nlilili);
	assign		wire_nll01l_dataout = (nlilili === 1'b1) ? nii1Ol : sudi[14];
	assign		wire_nll01O_dataout = (nlilili === 1'b1) ? nii1OO : sudi[15];
	assign		wire_nll0i_dataout = (rwa_6g_en === 1'b1) ? niOOOl : n100Ol;
	assign		wire_nll0ii_dataout = (nlilili === 1'b1) ? nii00i : sudi[19];
	assign		wire_nll0il_dataout = (nlilili === 1'b1) ? nii00l : sudi[20];
	assign		wire_nll0iO_dataout = (nlilili === 1'b1) ? nii00O : sudi[21];
	assign		wire_nll0l_dataout = (rwa_6g_en === 1'b1) ? niOOOO : n100OO;
	assign		wire_nll0li_dataout = (nlilili === 1'b1) ? nii0ii : sudi[22];
	assign		wire_nll0ll_dataout = (nlilili === 1'b1) ? nii0il : sudi[23];
	assign		wire_nll0lO_dataout = (nlilili === 1'b1) ? nii0iO : sudi[24];
	assign		wire_nll0O_dataout = (rwa_6g_en === 1'b1) ? nl111i : n10i1i;
	assign		wire_nll0Oi_dataout = (nlilili === 1'b1) ? nii0li : sudi[25];
	assign		wire_nll0Ol_dataout = (nlilili === 1'b1) ? nii0ll : sudi[26];
	assign		wire_nll0OO_dataout = (nlilili === 1'b1) ? nii0Oi : sudi[27];
	assign		wire_nll10i_dataout = (nlilili === 1'b1) ? nii11i : sudi[3];
	assign		wire_nll10l_dataout = (nlilili === 1'b1) ? nii11l : sudi[4];
	assign		wire_nll10O_dataout = (nlilili === 1'b1) ? nii11O : sudi[5];
	assign		wire_nll11i_dataout = (nlilili === 1'b1) ? ni0OOi : sudi[0];
	assign		wire_nll11l_dataout = (nlilili === 1'b1) ? ni0OOl : sudi[1];
	assign		wire_nll11O_dataout = (nlilili === 1'b1) ? ni0OOO : sudi[2];
	assign		wire_nll1i_dataout = (rwa_6g_en === 1'b1) ? niOOll : n100ll;
	assign		wire_nll1ii_dataout = (nlilili === 1'b1) ? nii10i : sudi[6];
	assign		wire_nll1il_dataout = (nlilili === 1'b1) ? nii10l : sudi[7];
	assign		wire_nll1iO_dataout = (nlilili === 1'b1) ? nii10O : sudi[8];
	assign		wire_nll1l_dataout = (rwa_6g_en === 1'b1) ? niOOlO : n100lO;
	assign		wire_nll1li_dataout = (nlilili === 1'b1) ? nii1ii : sudi[9];
	assign		wire_nll1ll_dataout = (nlilili === 1'b1) ? nii1il : sudi[10];
	assign		wire_nll1lO_dataout = (nlilili === 1'b1) ? nii1iO : sudi[11];
	assign		wire_nll1O_dataout = (rwa_6g_en === 1'b1) ? niOOOi : n100Oi;
	assign		wire_nll1Oi_dataout = (nlilili === 1'b1) ? nii1li : sudi[12];
	assign		wire_nll1Ol_dataout = (nlilili === 1'b1) ? nii1ll : sudi[13];
	and(wire_nll1OO_dataout, nii1lO, nlilili);
	and(wire_nlli01i_dataout, nli0i1i, ~(nli0lii));
	assign		wire_nlli0li_dataout = (nliO11i === 1'b1) ? (nli0i1l | nlli1ll) : nli0i1l;
	and(wire_nlli1i_dataout, nii0Ol, nlilili);
	and(wire_nlli1l_dataout, nii0OO, nlilili);
	and(wire_nlli1lO_dataout, nli00lO, ~(nli0lii));
	and(wire_nlli1Oi_dataout, nli00Oi, ~(nli0lii));
	and(wire_nlli1Ol_dataout, nli00Ol, ~(nli0lii));
	and(wire_nlli1OO_dataout, nli00OO, ~(nli0lii));
	assign		wire_nllii_dataout = (rwa_6g_en === 1'b1) ? nl111l : n10i1l;
	and(wire_nllii0i_dataout, nli0l0l, ~(nli0lii));
	and(wire_nlliili_dataout, nlO1OiO, ~(nli0lii));
	and(wire_nlliill_dataout, nlO1OOi, ~(nli0lii));
	and(wire_nlliilO_dataout, nlO1OOl, ~(nli0lii));
	and(wire_nlliiOi_dataout, nlO1OOO, ~(nli0lii));
	and(wire_nlliiOl_dataout, nlO011i, ~(nli0lii));
	assign		wire_nllil_dataout = (rwa_6g_en === 1'b1) ? nl111O : n10i1O;
	and(wire_nllil0O_dataout, nllil1O, ~(nli0lii));
	or(wire_nllilii_dataout, nllil1i, nli0lii);
	or(wire_nllilil_dataout, wire_n1OlOi_o, nli0lii);
	or(wire_nlliliO_dataout, wire_nllillO_dataout, nli0lii);
	and(wire_nllilli_dataout, wire_n1OllO_o, ~(nli0lii));
	and(wire_nllilll_dataout, wire_nllilOO_dataout, ~(nli0lii));
	assign		wire_nllillO_dataout = (nliO11i === 1'b1) ? (nli0i0i | nlliiOO) : nli0i0i;
	assign		wire_nllilOO_dataout = (nliO11i === 1'b1) ? (nli0i0l | nlliiiO) : nli0i0l;
	assign		wire_nlliO_dataout = (rwa_6g_en === 1'b1) ? nl110i : n10i0i;
	assign		wire_nlll00i_dataout = (nli0ili === 1'b1) ? wire_nllll1i_o[2] : wire_nlll0iO_dataout;
	assign		wire_nlll00l_dataout = (nli0ili === 1'b1) ? wire_nllll1i_o[3] : wire_nlll0li_dataout;
	assign		wire_nlll00O_dataout = (nli0ili === 1'b1) ? wire_nllll1i_o[4] : wire_nlll0ll_dataout;
	and(wire_nlll01i_dataout, wire_nlll00O_dataout, ~(nli0lii));
	assign		wire_nlll01l_dataout = (nli0ili === 1'b1) ? wire_nllll1i_o[0] : wire_nlll0ii_dataout;
	assign		wire_nlll01O_dataout = (nli0ili === 1'b1) ? wire_nllll1i_o[1] : wire_nlll0il_dataout;
	assign		wire_nlll0ii_dataout = (nli0iiO === 1'b1) ? nlll10l : wire_nlll0lO_dataout;
	assign		wire_nlll0il_dataout = (nli0iiO === 1'b1) ? wire_nllliOl_o[0] : wire_nlll0Oi_dataout;
	assign		wire_nlll0iO_dataout = (nli0iiO === 1'b1) ? wire_nllliOl_o[1] : wire_nlll0Ol_dataout;
	assign		wire_nlll0li_dataout = (nli0iiO === 1'b1) ? wire_nllliOl_o[2] : wire_nlll0OO_dataout;
	assign		wire_nlll0ll_dataout = (nli0iiO === 1'b1) ? wire_nllliOl_o[3] : wire_nllli1i_dataout;
	assign		wire_nlll0lO_dataout = (nli0iil === 1'b1) ? wire_nllliil_o[0] : wire_nllli1l_dataout;
	assign		wire_nlll0Oi_dataout = (nli0iil === 1'b1) ? wire_nllliil_o[1] : wire_nllli1O_dataout;
	assign		wire_nlll0Ol_dataout = (nli0iil === 1'b1) ? wire_nllliil_o[2] : wire_nllli0i_dataout;
	assign		wire_nlll0OO_dataout = (nli0iil === 1'b1) ? wire_nllliil_o[3] : wire_nllli0l_dataout;
	and(wire_nlll1ll_dataout, nlillOl, ~(nli0lii));
	and(wire_nlll1lO_dataout, wire_nlll01l_dataout, ~(nli0lii));
	and(wire_nlll1Oi_dataout, wire_nlll01O_dataout, ~(nli0lii));
	and(wire_nlll1Ol_dataout, wire_nlll00i_dataout, ~(nli0lii));
	and(wire_nlll1OO_dataout, wire_nlll00l_dataout, ~(nli0lii));
	assign		wire_nllli_dataout = (rwa_6g_en === 1'b1) ? nl110l : n10i0l;
	assign		wire_nllli0i_dataout = ((~ nli0iii) === 1'b1) ? wire_nllliii_o[3] : nlll1ii;
	assign		wire_nllli0l_dataout = ((~ nli0iii) === 1'b1) ? wire_nllliii_o[4] : nlll1il;
	assign		wire_nllli0O_dataout = ((~ nli0iii) === 1'b1) ? wire_nllliii_o[5] : nlll1iO;
	assign		wire_nllli1i_dataout = (nli0iil === 1'b1) ? wire_nllliil_o[4] : wire_nllli0O_dataout;
	assign		wire_nllli1l_dataout = ((~ nli0iii) === 1'b1) ? wire_nllliii_o[1] : nlll10l;
	assign		wire_nllli1O_dataout = ((~ nli0iii) === 1'b1) ? wire_nllliii_o[2] : nlll10O;
	assign		wire_nllll_dataout = (rwa_6g_en === 1'b1) ? nl110O : n10i0O;
	and(wire_nllllll_dataout, nli0ilO, ~(nli0lii));
	and(wire_nlllllO_dataout, nli0ilO, ~(nli0lii));
	assign		wire_nlllO_dataout = (rwa_6g_en === 1'b1) ? nl11ii : n10iii;
	and(wire_nllO_dataout, cmpfifourst, rcmpfifourst);
	and(wire_nllO00i_dataout, wire_nllOiOl_dataout, ~(nli0lii));
	and(wire_nllO00l_dataout, wire_nllOiOO_dataout, ~(nli0lii));
	and(wire_nllO00O_dataout, wire_nllOl1i_dataout, ~(nli0lii));
	or(wire_nllO01i_dataout, wire_nllOill_dataout, nli0lii);
	and(wire_nllO01l_dataout, wire_nllOilO_dataout, ~(nli0lii));
	and(wire_nllO01O_dataout, wire_nllOiOi_dataout, ~(nli0lii));
	and(wire_nllO0ii_dataout, wire_nllOl1l_dataout, ~(nli0lii));
	and(wire_nllO0il_dataout, wire_nllOl1O_dataout, ~(nli0lii));
	and(wire_nllO0iO_dataout, wire_nllOl0i_dataout, ~(nli0lii));
	and(wire_nllO0li_dataout, wire_nllOl0l_dataout, ~(nli0lii));
	and(wire_nllO0ll_dataout, wire_nllOl0O_dataout, ~(nli0lii));
	and(wire_nllO0lO_dataout, wire_nllOlii_dataout, ~(nli0lii));
	and(wire_nllO0Oi_dataout, wire_nllOlil_dataout, ~(nli0lii));
	and(wire_nllO0Ol_dataout, wire_nllOliO_dataout, ~(nli0lii));
	and(wire_nllO0OO_dataout, wire_nllOlli_dataout, ~(nli0lii));
	and(wire_nllO1ll_dataout, wire_nllOi0O_dataout, ~(nli0lii));
	and(wire_nllO1lO_dataout, wire_nllOiii_dataout, ~(nli0lii));
	and(wire_nllO1Oi_dataout, wire_nllOiil_dataout, ~(nli0lii));
	and(wire_nllO1Ol_dataout, wire_nllOiiO_dataout, ~(nli0lii));
	and(wire_nllO1OO_dataout, wire_nllOili_dataout, ~(nli0lii));
	assign		wire_nllOi_dataout = (rwa_6g_en === 1'b1) ? nl11il : n10iil;
	and(wire_nllOi0i_dataout, wire_nllOlOl_dataout, ~(nli0lii));
	and(wire_nllOi0l_dataout, wire_nllOlOO_dataout, ~(nli0lii));
	assign		wire_nllOi0O_dataout = (nli0iOi === 1'b1) ? wire_nlO100i_dataout : wire_nllOO1i_dataout;
	and(wire_nllOi1i_dataout, wire_nllOlll_dataout, ~(nli0lii));
	and(wire_nllOi1l_dataout, wire_nllOllO_dataout, ~(nli0lii));
	and(wire_nllOi1O_dataout, wire_nllOlOi_dataout, ~(nli0lii));
	assign		wire_nllOiii_dataout = (nli0iOi === 1'b1) ? wire_nlO100l_dataout : wire_nllOO1l_dataout;
	assign		wire_nllOiil_dataout = (nli0iOi === 1'b1) ? wire_nlO100O_dataout : wire_nllOO1O_dataout;
	assign		wire_nllOiiO_dataout = (nli0iOi === 1'b1) ? wire_nlO10ii_dataout : wire_nllOO0i_dataout;
	assign		wire_nllOili_dataout = (nli0iOi === 1'b1) ? wire_nlO10il_dataout : wire_nllOO0l_dataout;
	assign		wire_nllOill_dataout = (nli0iOi === 1'b1) ? nllO1iO : wire_nllOO0O_dataout;
	assign		wire_nllOilO_dataout = (nli0iOi === 1'b1) ? nlllO0l : wire_nllOOii_dataout;
	assign		wire_nllOiOi_dataout = (nli0iOi === 1'b1) ? nlllO0O : wire_nllOOil_dataout;
	assign		wire_nllOiOl_dataout = (nli0iOi === 1'b1) ? nlllOii : wire_nllOOiO_dataout;
	assign		wire_nllOiOO_dataout = (nli0iOi === 1'b1) ? nlllOil : wire_nllOOli_dataout;
	assign		wire_nllOl_dataout = (rwa_6g_en === 1'b1) ? nl11iO : n10iiO;
	assign		wire_nllOl0i_dataout = (nli0iOi === 1'b1) ? nlllOlO : wire_nllOOOl_dataout;
	assign		wire_nllOl0l_dataout = (nli0iOi === 1'b1) ? nlllOOi : wire_nllOOOO_dataout;
	assign		wire_nllOl0O_dataout = (nli0iOi === 1'b1) ? nlllOOl : wire_nlO111i_dataout;
	assign		wire_nllOl1i_dataout = (nli0iOi === 1'b1) ? nlllOiO : wire_nllOOll_dataout;
	assign		wire_nllOl1l_dataout = (nli0iOi === 1'b1) ? nlllOli : wire_nllOOlO_dataout;
	assign		wire_nllOl1O_dataout = (nli0iOi === 1'b1) ? nlllOll : wire_nllOOOi_dataout;
	assign		wire_nllOlii_dataout = (nli0iOi === 1'b1) ? nlllOOO : wire_nlO111l_dataout;
	assign		wire_nllOlil_dataout = (nli0iOi === 1'b1) ? nllO11i : wire_nlO111O_dataout;
	assign		wire_nllOliO_dataout = (nli0iOi === 1'b1) ? nllO11l : wire_nlO110i_dataout;
	assign		wire_nllOlli_dataout = (nli0iOi === 1'b1) ? nllO11O : wire_nlO110l_dataout;
	assign		wire_nllOlll_dataout = (nli0iOi === 1'b1) ? nllO10i : wire_nlO110O_dataout;
	assign		wire_nllOllO_dataout = (nli0iOi === 1'b1) ? nllO10l : wire_nlO11ii_dataout;
	assign		wire_nllOlOi_dataout = (nli0iOi === 1'b1) ? nllO10O : wire_nlO11il_dataout;
	assign		wire_nllOlOl_dataout = (nli0iOi === 1'b1) ? nllO1ii : wire_nlO11iO_dataout;
	assign		wire_nllOlOO_dataout = (nli0iOi === 1'b1) ? nllO1il : wire_nlO11li_dataout;
	assign		wire_nllOO_dataout = (rwa_6g_en === 1'b1) ? nl11li : n10ili;
	assign		wire_nllOO0i_dataout = (nli0iOO === 1'b1) ? wire_nlO11Ol_dataout : nlllO1O;
	assign		wire_nllOO0l_dataout = (nli0iOO === 1'b1) ? wire_nlO11OO_dataout : nlllO0i;
	assign		wire_nllOO0O_dataout = (nli0iOO === 1'b1) ? nlllO0O : nlllO0l;
	assign		wire_nllOO1i_dataout = (nli0iOO === 1'b1) ? wire_nlO11ll_dataout : nllllli;
	assign		wire_nllOO1l_dataout = (nli0iOO === 1'b1) ? wire_nlO11lO_dataout : nlllO1i;
	assign		wire_nllOO1O_dataout = (nli0iOO === 1'b1) ? wire_nlO11Oi_dataout : nlllO1l;
	assign		wire_nllOOii_dataout = (nli0iOO === 1'b1) ? nlllOii : nlllO0O;
	assign		wire_nllOOil_dataout = (nli0iOO === 1'b1) ? nlllOil : nlllOii;
	assign		wire_nllOOiO_dataout = (nli0iOO === 1'b1) ? nlllOiO : nlllOil;
	assign		wire_nllOOli_dataout = (nli0iOO === 1'b1) ? nlllOli : nlllOiO;
	assign		wire_nllOOll_dataout = (nli0iOO === 1'b1) ? nlllOll : nlllOli;
	assign		wire_nllOOlO_dataout = (nli0iOO === 1'b1) ? nlllOlO : nlllOll;
	assign		wire_nllOOOi_dataout = (nli0iOO === 1'b1) ? nlllOOi : nlllOlO;
	assign		wire_nllOOOl_dataout = (nli0iOO === 1'b1) ? nlllOOl : nlllOOi;
	assign		wire_nllOOOO_dataout = (nli0iOO === 1'b1) ? nlllOOO : nlllOOl;
	assign		wire_nlO_dataout = (rwa_6g_en === 1'b1) ? wire_n0OOii_dataout : wire_nlli0li_dataout;
	assign		wire_nlO001i_dataout = (wire_nlO000O_o === 1'b1) ? wire_nlO000l_o[4] : wire_nlO001O_o[4];
	assign		wire_nlO001l_dataout = (wire_nlO000O_o === 1'b1) ? wire_nlO000l_o[5] : wire_nlO001O_o[5];
	and(wire_nlO00il_dataout, (nli0lOl | nli0lOi), (wire_nlOi10l_dataout & nliii0i));
	and(wire_nlO010i_dataout, wire_nlO01iO_dataout, ~(nli0lii));
	and(wire_nlO010l_dataout, wire_nlO01li_dataout, ~(nli0lii));
	and(wire_nlO010O_dataout, wire_nlO01ll_dataout, ~(nli0lii));
	and(wire_nlO011O_dataout, wire_nlO01il_dataout, ~(nli0lii));
	and(wire_nlO01ii_dataout, wire_nlO01lO_dataout, ~(nli0lii));
	and(wire_nlO01il_dataout, wire_nlO01Oi_dataout, ~(nli0lil));
	and(wire_nlO01iO_dataout, wire_nlO01Ol_dataout, ~(nli0lil));
	assign		wire_nlO01li_dataout = (nli0lil === 1'b1) ? nlO1Oii : wire_nlO01OO_dataout;
	and(wire_nlO01ll_dataout, wire_nlO001i_dataout, ~(nli0lil));
	assign		wire_nlO01lO_dataout = (nli0lil === 1'b1) ? nlO1Oii : wire_nlO001l_dataout;
	assign		wire_nlO01Oi_dataout = (wire_nlO000O_o === 1'b1) ? wire_nlO000l_o[1] : wire_nlO001O_o[1];
	assign		wire_nlO01Ol_dataout = (wire_nlO000O_o === 1'b1) ? wire_nlO000l_o[2] : wire_nlO001O_o[2];
	assign		wire_nlO01OO_dataout = (wire_nlO000O_o === 1'b1) ? wire_nlO000l_o[3] : wire_nlO001O_o[3];
	assign		wire_nlO0i_dataout = (rwa_6g_en === 1'b1) ? nl11OO : n10iOl;
	and(wire_nlO0i0l_dataout, nli0lOO, (wire_nlOi10l_dataout & nlO00Oi));
	and(wire_nlO0i1i_dataout, nli0lOO, (wire_nlOi10l_dataout & nlO00ll));
	and(wire_nlO0i1O_dataout, nli0lOO, (wire_nlOi10l_dataout & nlO00lO));
	and(wire_nlO0iiO_dataout, nlii0OO, (wire_nlOi10l_dataout & (((~ rclkcmpsqmd) & nlillil) | nlO00ii)));
	assign		wire_nlO0l_dataout = (rwa_6g_en === 1'b1) ? nl101i : n10iOO;
	and(wire_nlO0l1O_dataout, nlii0OO, (wire_nlOi10l_dataout & (nli0O1i | (~ nliii0i))));
	assign		wire_nlO0lOi_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[0] : sudi_pre[0];
	assign		wire_nlO0lOl_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[1] : sudi_pre[1];
	assign		wire_nlO0lOO_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[2] : sudi_pre[2];
	assign		wire_nlO0O_dataout = (rwa_6g_en === 1'b1) ? nl101l : n10l1i;
	assign		wire_nlO0O0i_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[6] : sudi_pre[6];
	assign		wire_nlO0O0l_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[7] : sudi_pre[7];
	assign		wire_nlO0O0O_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[8] : sudi_pre[8];
	assign		wire_nlO0O1i_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[3] : sudi_pre[3];
	assign		wire_nlO0O1l_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[4] : sudi_pre[4];
	assign		wire_nlO0O1O_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[5] : sudi_pre[5];
	assign		wire_nlO0Oii_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[9] : sudi_pre[9];
	assign		wire_nlO0Oil_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[10] : sudi_pre[10];
	assign		wire_nlO0OiO_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[12] : sudi_pre[12];
	assign		wire_nlO0Oli_dataout = (dskwclksel[1] === 1'b1) ? audi[10] : sudi[10];
	assign		wire_nlO0Oll_dataout = (dskwclksel[1] === 1'b1) ? audi[11] : (sudi[11] & inferred_rxvalid);
	assign		wire_nlO0OlO_dataout = (dskwclksel[1] === 1'b1) ? audi[12] : sudi[12];
	and(wire_nlO100i_dataout, wire_nlO10iO_o[0], ~(nli0l1l));
	and(wire_nlO100l_dataout, wire_nlO10iO_o[1], ~(nli0l1l));
	and(wire_nlO100O_dataout, wire_nlO10iO_o[2], ~(nli0l1l));
	and(wire_nlO10i_dataout, wire_n1ll_dataout, ~((~ wire_nl00O_dataout)));
	and(wire_nlO10ii_dataout, wire_nlO10iO_o[3], ~(nli0l1l));
	and(wire_nlO10il_dataout, wire_nlO10iO_o[4], ~(nli0l1l));
	and(wire_nlO10l_dataout, wire_nlO1ii_dataout, ~((~ wire_nl00O_dataout)));
	and(wire_nlO10O_dataout, wire_nlO1il_dataout, ~((~ wire_nl00O_dataout)));
	assign		wire_nlO110i_dataout = (nli0iOO === 1'b1) ? nllO10i : nllO11O;
	assign		wire_nlO110l_dataout = (nli0iOO === 1'b1) ? nllO10l : nllO10i;
	assign		wire_nlO110O_dataout = (nli0iOO === 1'b1) ? nllO10O : nllO10l;
	assign		wire_nlO111i_dataout = (nli0iOO === 1'b1) ? nllO11i : nlllOOO;
	assign		wire_nlO111l_dataout = (nli0iOO === 1'b1) ? nllO11l : nllO11i;
	assign		wire_nlO111O_dataout = (nli0iOO === 1'b1) ? nllO11O : nllO11l;
	assign		wire_nlO11ii_dataout = (nli0iOO === 1'b1) ? nllO1ii : nllO10O;
	assign		wire_nlO11il_dataout = (nli0iOO === 1'b1) ? nllO1il : nllO1ii;
	assign		wire_nlO11iO_dataout = (nli0iOO === 1'b1) ? nllO1iO : nllO1il;
	assign		wire_nlO11li_dataout = (nli0iOO === 1'b1) ? nlllO0l : nllO1iO;
	or(wire_nlO11ll_dataout, wire_nlO101i_o[1], nli0iOl);
	or(wire_nlO11lO_dataout, wire_nlO101i_o[2], nli0iOl);
	and(wire_nlO11Oi_dataout, wire_nlO101i_o[3], ~(nli0iOl));
	and(wire_nlO11Ol_dataout, wire_nlO101i_o[4], ~(nli0iOl));
	or(wire_nlO11OO_dataout, wire_nlO101i_o[5], nli0iOl);
	assign		wire_nlO1i_dataout = (rwa_6g_en === 1'b1) ? nl11ll : n10ill;
	and(wire_nlO1i0i_dataout, nlli10l, ~(nli0lii));
	and(wire_nlO1i0l_dataout, nlli10i, ~(nli0lii));
	and(wire_nlO1i1i_dataout, nlO10OO, ~(nli0lii));
	and(wire_nlO1i1l_dataout, nlO10Ol, ~(nli0lii));
	and(wire_nlO1i1O_dataout, nlli10O, ~(nli0lii));
	and(wire_nlO1ii_dataout, nllOOi, ~(wire_n1ll_dataout));
	and(wire_nlO1iii_dataout, n11O0O, ~(nli0lii));
	and(wire_nlO1iil_dataout, n101Ol, ~(nli0lii));
	and(wire_nlO1iiO_dataout, n101OO, ~(nli0lii));
	and(wire_nlO1il_dataout, nlO01O, ~(wire_n1ll_dataout));
	and(wire_nlO1ili_dataout, n1001i, ~(nli0lii));
	and(wire_nlO1ill_dataout, n1001l, ~(nli0lii));
	assign		wire_nlO1iO_dataout = ((~ wire_nl00O_dataout) === 1'b1) ? nlO01O : wire_nlO1lO_dataout;
	assign		wire_nlO1l_dataout = (rwa_6g_en === 1'b1) ? nl11lO : n10ilO;
	assign		wire_nlO1li_dataout = ((~ wire_nl00O_dataout) === 1'b1) ? nllOOi : wire_nlO1Oi_dataout;
	and(wire_nlO1ll_dataout, (~ nlill0O), ~((~ wire_nl00O_dataout)));
	assign		wire_nlO1lO_dataout = (nlill0O === 1'b1) ? wire_n1iO_dataout : nlO01O;
	assign		wire_nlO1O_dataout = (rwa_6g_en === 1'b1) ? nl11Ol : n10iOi;
	assign		wire_nlO1Oi_dataout = (nlill0O === 1'b1) ? wire_n1li_dataout : nllOOi;
	and(wire_nlO1Oil_dataout, nlillOi, wire_nlOi10l_dataout);
	and(wire_nlO1Oli_dataout, wire_nlO1Oll_dataout, wire_nlOi10l_dataout);
	or(wire_nlO1Oll_dataout, nlO1Oii, ((~ nlO1Oii) & nli0l0O));
	and(wire_nlO1OO_dataout, wire_n1il_dataout, wire_nl00O_dataout);
	assign		wire_nlOi00i_dataout = (nli0Oli === 1'b1) ? nlOliil : wire_nlOii0l_dataout;
	assign		wire_nlOi00l_dataout = (nli0Oli === 1'b1) ? nlOliiO : wire_nlOii0O_dataout;
	assign		wire_nlOi00O_dataout = (nli0Oli === 1'b1) ? nlOlili : wire_nlOiiii_dataout;
	assign		wire_nlOi01i_dataout = (nli0Oli === 1'b1) ? nlOli0l : wire_nlOii1l_dataout;
	assign		wire_nlOi01l_dataout = (nli0Oli === 1'b1) ? nlOli0O : wire_nlOii1O_dataout;
	assign		wire_nlOi01O_dataout = (nli0Oli === 1'b1) ? nlOliii : wire_nlOii0i_dataout;
	assign		wire_nlOi0ii_dataout = (nli0Oli === 1'b1) ? nlOlill : wire_nlOiiil_dataout;
	assign		wire_nlOi0il_dataout = (nli0Oli === 1'b1) ? nlOlilO : wire_nlOiiiO_dataout;
	assign		wire_nlOi0iO_dataout = (nli0Oli === 1'b1) ? nlOliOl : wire_nlOiili_dataout;
	and(wire_nlOi0li_dataout, wire_nlOiill_dataout, ~(nli0Oli));
	or(wire_nlOi0ll_dataout, wire_nlOiilO_dataout, nli0Oli);
	assign		wire_nlOi0lO_dataout = (nli0O0l === 1'b1) ? nlOl0OO : wire_nlOiiOi_dataout;
	assign		wire_nlOi0Oi_dataout = (nli0O0l === 1'b1) ? nlOli1i : wire_nlOiiOl_dataout;
	assign		wire_nlOi0Ol_dataout = (nli0O0l === 1'b1) ? nlOli1l : wire_nlOiiOO_dataout;
	assign		wire_nlOi0OO_dataout = (nli0O0l === 1'b1) ? nlOli1O : wire_nlOil1i_dataout;
	assign		wire_nlOi10i_dataout = (dskwclksel[1] === 1'b1) ? nlOiO0O : nlOiO0i;
	and(wire_nlOi10l_dataout, wire_nlOi10O_dataout, ~(nli0O0i));
	assign		wire_nlOi10O_dataout = (dskwclksel[1] === 1'b1) ? align_status : sync_status;
	and(wire_nlOi11i_dataout, wire_nlOi11l_dataout, ~(nli0O0i));
	assign		wire_nlOi11l_dataout = (nlii1ii === 1'b1) ? align_status_sync_0 : wire_nlOi11O_dataout;
	assign		wire_nlOi11O_dataout = (nlii10O === 1'b1) ? align_status_sync_2 : wire_nlOi10i_dataout;
	assign		wire_nlOi1il_dataout = (nli0O0l === 1'b1) ? n10O1O : wire_nlOi10O_dataout;
	and(wire_nlOi1li_dataout, nli0Oli, wire_nlOi11i_dataout);
	assign		wire_nlOi1ll_dataout = (nli0Oli === 1'b1) ? nlOl0OO : wire_nlOi0lO_dataout;
	assign		wire_nlOi1lO_dataout = (nli0Oli === 1'b1) ? nlOli1i : wire_nlOi0Oi_dataout;
	assign		wire_nlOi1Oi_dataout = (nli0Oli === 1'b1) ? nlOli1l : wire_nlOi0Ol_dataout;
	assign		wire_nlOi1Ol_dataout = (nli0Oli === 1'b1) ? nlOli1O : wire_nlOi0OO_dataout;
	assign		wire_nlOi1OO_dataout = (nli0Oli === 1'b1) ? nlOli0i : wire_nlOii1i_dataout;
	assign		wire_nlOii_dataout = (rwa_6g_en === 1'b1) ? nl101O : n10l1l;
	assign		wire_nlOii0i_dataout = (nli0O0l === 1'b1) ? nlOliii : wire_nlOil0l_dataout;
	assign		wire_nlOii0l_dataout = (nli0O0l === 1'b1) ? nlOliil : wire_nlOil0O_dataout;
	assign		wire_nlOii0O_dataout = (nli0O0l === 1'b1) ? nlOliiO : wire_nlOilii_dataout;
	assign		wire_nlOii1i_dataout = (nli0O0l === 1'b1) ? nlOli0i : wire_nlOil1l_dataout;
	assign		wire_nlOii1l_dataout = (nli0O0l === 1'b1) ? nlOli0l : wire_nlOil1O_dataout;
	assign		wire_nlOii1O_dataout = (nli0O0l === 1'b1) ? nlOli0O : wire_nlOil0i_dataout;
	assign		wire_nlOiiii_dataout = (nli0O0l === 1'b1) ? nlOlili : wire_nlO0Oli_dataout;
	assign		wire_nlOiiil_dataout = (nli0O0l === 1'b1) ? nlOlill : wire_nlOilil_dataout;
	assign		wire_nlOiiiO_dataout = (nli0O0l === 1'b1) ? nlOlilO : wire_nlO0OlO_dataout;
	assign		wire_nlOiili_dataout = (nli0O0l === 1'b1) ? nlOliOl : wire_nlOiliO_dataout;
	and(wire_nlOiill_dataout, nlOliOO, nli0O0l);
	and(wire_nlOiilO_dataout, nlOll1i, nli0O0l);
	assign		wire_nlOiiOi_dataout = (dskwclksel[1] === 1'b1) ? audi[0] : sudi[0];
	assign		wire_nlOiiOl_dataout = (dskwclksel[1] === 1'b1) ? audi[1] : sudi[1];
	assign		wire_nlOiiOO_dataout = (dskwclksel[1] === 1'b1) ? audi[2] : sudi[2];
	assign		wire_nlOil_dataout = (rwa_6g_en === 1'b1) ? nl100i : n10l1O;
	assign		wire_nlOil0i_dataout = (dskwclksel[1] === 1'b1) ? audi[6] : sudi[6];
	assign		wire_nlOil0l_dataout = (dskwclksel[1] === 1'b1) ? audi[7] : sudi[7];
	assign		wire_nlOil0O_dataout = (dskwclksel[1] === 1'b1) ? audi[8] : sudi[8];
	assign		wire_nlOil1i_dataout = (dskwclksel[1] === 1'b1) ? audi[3] : sudi[3];
	assign		wire_nlOil1l_dataout = (dskwclksel[1] === 1'b1) ? audi[4] : sudi[4];
	assign		wire_nlOil1O_dataout = (dskwclksel[1] === 1'b1) ? audi[5] : sudi[5];
	assign		wire_nlOilii_dataout = (dskwclksel[1] === 1'b1) ? audi[9] : sudi[9];
	assign		wire_nlOilil_dataout = (dskwclksel[1] === 1'b1) ? audi[11] : sudi[11];
	assign		wire_nlOiliO_dataout = (dskwclksel[1] === 1'b1) ? audi[13] : sudi[13];
	assign		wire_nlOiO_dataout = (rwa_6g_en === 1'b1) ? nl100l : n10l0i;
	assign		wire_nlOli_dataout = (rwa_6g_en === 1'b1) ? nl100O : n10l0l;
	assign		wire_nlOll_dataout = (rwa_6g_en === 1'b1) ? nl10ii : n10l0O;
	assign		wire_nlOll0i_dataout = (nlii1Oi === 1'b1) ? (~ nlOliOl) : wire_nlOO0iO_dataout;
	assign		wire_nlOll0l_dataout = (nlii1Oi === 1'b1) ? (~ nlOliOl) : wire_nlOO0li_dataout;
	assign		wire_nlOll0O_dataout = (nlii1Oi === 1'b1) ? wire_n1100l_dataout : wire_nlOO0ll_dataout;
	assign		wire_nlOll1O_dataout = (nlii1Oi === 1'b1) ? wire_n1100i_dataout : wire_nlOO0il_dataout;
	assign		wire_nlOllii_dataout = (nlii1Oi === 1'b1) ? (~ nlOliOl) : wire_nlOO0lO_dataout;
	assign		wire_nlOllil_dataout = (nlii1Oi === 1'b1) ? nlOliOl : wire_nlOO0Oi_dataout;
	assign		wire_nlOlliO_dataout = (nlii1Oi === 1'b1) ? (~ nlOliOl) : wire_nlOO0Ol_dataout;
	assign		wire_nlOllli_dataout = (nlii1Oi === 1'b1) ? nlOliOl : wire_nlOO0OO_dataout;
	assign		wire_nlOllll_dataout = (nlii1Oi === 1'b1) ? nlOliOl : wire_nlOOi1i_dataout;
	assign		wire_nlOlllO_dataout = (nlii1Oi === 1'b1) ? nlOliOl : wire_nlOOi1l_dataout;
	and(wire_nlOllOi_dataout, wire_nlOOi1O_dataout, ~(nlii1Oi));
	and(wire_nlOllOl_dataout, wire_nlOOi0l_dataout, ~(nlii1Oi));
	and(wire_nlOllOO_dataout, wire_nlOOiii_dataout, ~(nlii1Oi));
	assign		wire_nlOlO_dataout = (rwa_6g_en === 1'b1) ? nl10il : n10lii;
	assign		wire_nlOlO0i_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[2] : nlOl00l;
	assign		wire_nlOlO0l_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[3] : nlOl00O;
	assign		wire_nlOlO0O_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[4] : nlOl0ii;
	or(wire_nlOlO1i_dataout, wire_nlOOiil_dataout, nlii1Oi);
	assign		wire_nlOlO1l_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[0] : nlOl01O;
	assign		wire_nlOlO1O_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[1] : nlOl00i;
	assign		wire_nlOlOii_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[5] : nlOl0il;
	assign		wire_nlOlOil_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[6] : nlOl0iO;
	assign		wire_nlOlOiO_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[7] : nlOl0li;
	assign		wire_nlOlOli_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[8] : nlOl0ll;
	assign		wire_nlOlOll_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[9] : nlOl0lO;
	assign		wire_nlOlOlO_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[11] : nlOl0Oi;
	assign		wire_nlOlOOi_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out2[13] : nlOl0Ol;
	assign		wire_nlOlOOl_dataout = (nli0Oil === 1'b1) ? nlOl10O : nlOiOil;
	assign		wire_nlOlOOO_dataout = (nli0Oil === 1'b1) ? nlOl1ii : nlOiOli;
	assign		wire_nlOO00i_dataout = (nli0Oil === 1'b1) ? nlOl0ll : nlOl1Ol;
	assign		wire_nlOO00l_dataout = (nli0Oil === 1'b1) ? nlOl0lO : nlOl1OO;
	assign		wire_nlOO00O_dataout = (nli0Oil === 1'b1) ? nlOl0Oi : nlOl01i;
	assign		wire_nlOO01i_dataout = (nli0Oil === 1'b1) ? nlOl0il : nlOl1ll;
	assign		wire_nlOO01l_dataout = (nli0Oil === 1'b1) ? nlOl0iO : nlOl1lO;
	assign		wire_nlOO01O_dataout = (nli0Oil === 1'b1) ? nlOl0li : nlOl1Oi;
	assign		wire_nlOO0ii_dataout = (nli0Oil === 1'b1) ? nlOl0Ol : nlOl01l;
	assign		wire_nlOO0il_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[0] : wire_nlOOiiO_dataout;
	assign		wire_nlOO0iO_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[1] : wire_nlOOili_dataout;
	assign		wire_nlOO0li_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[2] : wire_nlOOill_dataout;
	assign		wire_nlOO0ll_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[3] : wire_nlOOilO_dataout;
	assign		wire_nlOO0lO_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[4] : wire_nlOOiOi_dataout;
	assign		wire_nlOO0Oi_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[5] : wire_nlOOiOl_dataout;
	assign		wire_nlOO0Ol_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[6] : wire_nlOOiOO_dataout;
	assign		wire_nlOO0OO_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[7] : wire_nlOOl1i_dataout;
	assign		wire_nlOO10i_dataout = (nli0Oil === 1'b1) ? nlOl1ll : nlOiOOl;
	assign		wire_nlOO10l_dataout = (nli0Oil === 1'b1) ? nlOl1lO : nlOiOOO;
	assign		wire_nlOO10O_dataout = (nli0Oil === 1'b1) ? nlOl1Oi : nlOl11i;
	assign		wire_nlOO11i_dataout = (nli0Oil === 1'b1) ? nlOl1il : nlOiOll;
	assign		wire_nlOO11l_dataout = (nli0Oil === 1'b1) ? nlOl1iO : nlOiOlO;
	assign		wire_nlOO11O_dataout = (nli0Oil === 1'b1) ? nlOl1li : nlOiOOi;
	assign		wire_nlOO1ii_dataout = (nli0Oil === 1'b1) ? nlOl1Ol : nlOl11l;
	assign		wire_nlOO1il_dataout = (nli0Oil === 1'b1) ? nlOl1OO : nlOl11O;
	assign		wire_nlOO1iO_dataout = (nli0Oil === 1'b1) ? nlOl01i : nlOl10i;
	assign		wire_nlOO1li_dataout = (nli0Oil === 1'b1) ? nlOl01l : nlOl10l;
	assign		wire_nlOO1ll_dataout = (nli0Oil === 1'b1) ? nlOl01O : nlOl10O;
	assign		wire_nlOO1lO_dataout = (nli0Oil === 1'b1) ? nlOl00i : nlOl1ii;
	assign		wire_nlOO1Oi_dataout = (nli0Oil === 1'b1) ? nlOl00l : nlOl1il;
	assign		wire_nlOO1Ol_dataout = (nli0Oil === 1'b1) ? nlOl00O : nlOl1iO;
	assign		wire_nlOO1OO_dataout = (nli0Oil === 1'b1) ? nlOl0ii : nlOl1li;
	assign		wire_nlOOi_dataout = (rwa_6g_en === 1'b1) ? nl10iO : n10lil;
	assign		wire_nlOOi0i_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[11] : wire_nlOOl0l_dataout;
	assign		wire_nlOOi0l_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[12] : wire_nlOOl0O_dataout;
	assign		wire_nlOOi0O_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[13] : wire_nlOOlii_dataout;
	assign		wire_nlOOi1i_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[8] : wire_nlOOl1l_dataout;
	assign		wire_nlOOi1l_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[9] : wire_nlOOl1O_dataout;
	assign		wire_nlOOi1O_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[10] : wire_nlOOl0i_dataout;
	assign		wire_nlOOiii_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[14] : wire_nlOOlil_dataout;
	assign		wire_nlOOiil_dataout = (nli0Oil === 1'b1) ? wire_nllOll_data_out1[15] : wire_nlOOliO_dataout;
	assign		wire_nlOOiiO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOlOO_dataout : nlOl0OO;
	assign		wire_nlOOili_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOO1i_dataout : nlOli1i;
	assign		wire_nlOOill_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOO1l_dataout : nlOli1l;
	assign		wire_nlOOilO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOO1O_dataout : nlOli1O;
	assign		wire_nlOOiOi_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOO0i_dataout : nlOli0i;
	assign		wire_nlOOiOl_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOO0l_dataout : nlOli0l;
	assign		wire_nlOOiOO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOO0O_dataout : nlOli0O;
	assign		wire_nlOOl_dataout = (rwa_6g_en === 1'b1) ? nl10li : n10liO;
	assign		wire_nlOOl0i_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOli_dataout : wire_nlOOlli_dataout;
	assign		wire_nlOOl0l_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOll_dataout : nlOlill;
	assign		wire_nlOOl0O_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOlO_dataout : wire_nlOOlll_dataout;
	assign		wire_nlOOl1i_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOii_dataout : nlOliii;
	assign		wire_nlOOl1l_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOil_dataout : nlOliil;
	assign		wire_nlOOl1O_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOiO_dataout : nlOliiO;
	assign		wire_nlOOlii_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOOi_dataout : nlOliOl;
	and(wire_nlOOlil_dataout, wire_nlOOOOl_dataout, rclkcmpsqmd);
	assign		wire_nlOOliO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlOOOOO_dataout : (~ rrx_pipe_enable);
	and(wire_nlOOlli_dataout, wire_nlOOllO_dataout, ~(rrx_pipe_enable));
	and(wire_nlOOlll_dataout, wire_nlOOlOi_dataout, ~(rrx_pipe_enable));
	and(wire_nlOOllO_dataout, nlOlili, nli0Oii);
	and(wire_nlOOlOi_dataout, nlOlilO, nli0Oii);
	assign		wire_nlOOlOO_dataout = (n11O1l === 1'b1) ? nlOl10O : wire_n1111i_dataout;
	assign		wire_nlOOO_dataout = (rwa_6g_en === 1'b1) ? nl10ll : n10lli;
	assign		wire_nlOOO0i_dataout = (n11O1l === 1'b1) ? nlOl1li : wire_n1110l_dataout;
	assign		wire_nlOOO0l_dataout = (n11O1l === 1'b1) ? nlOl1ll : wire_n1110O_dataout;
	assign		wire_nlOOO0O_dataout = (n11O1l === 1'b1) ? nlOl1lO : wire_n111ii_dataout;
	assign		wire_nlOOO1i_dataout = (n11O1l === 1'b1) ? nlOl1ii : wire_n1111l_dataout;
	assign		wire_nlOOO1l_dataout = (n11O1l === 1'b1) ? nlOl1il : wire_n1111O_dataout;
	assign		wire_nlOOO1O_dataout = (n11O1l === 1'b1) ? nlOl1iO : wire_n1110i_dataout;
	assign		wire_nlOOOii_dataout = (n11O1l === 1'b1) ? nlOl1Oi : wire_n111il_dataout;
	assign		wire_nlOOOil_dataout = (n11O1l === 1'b1) ? nlOl1Ol : wire_n111iO_dataout;
	assign		wire_nlOOOiO_dataout = (n11O1l === 1'b1) ? nlOl1OO : wire_n111li_dataout;
	and(wire_nlOOOli_dataout, wire_n111ll_dataout, ~(n11O1l));
	assign		wire_nlOOOll_dataout = (n11O1l === 1'b1) ? nlOl01i : wire_n111lO_dataout;
	and(wire_nlOOOlO_dataout, wire_n111Oi_dataout, ~(n11O1l));
	assign		wire_nlOOOOi_dataout = (n11O1l === 1'b1) ? nlOl01l : wire_n111Ol_dataout;
	and(wire_nlOOOOl_dataout, wire_n111OO_dataout, ~(n11O1l));
	or(wire_nlOOOOO_dataout, wire_n1101i_dataout, n11O1l);
	oper_add   n0O0li
	( 
	.a({n0l0il, n0l0ii, n0l00O, n0l00l, n0O0ll}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n0O0li_o));
	defparam
		n0O0li.sgate_representation = 0,
		n0O0li.width_a = 5,
		n0O0li.width_b = 5,
		n0O0li.width_o = 5;
	oper_add   n0OOOO
	( 
	.a({1'b0, rfull_threshold[4:0], 1'b1}),
	.b({1'b0, {4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n0OOOO_o));
	defparam
		n0OOOO.sgate_representation = 0,
		n0OOOO.width_a = 7,
		n0OOOO.width_b = 7,
		n0OOOO.width_o = 7;
	oper_add   n1010i
	( 
	.a({n11O0l, n11O0i, n11O1O}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1010i_o));
	defparam
		n1010i.sgate_representation = 0,
		n1010i.width_a = 3,
		n1010i.width_b = 3,
		n1010i.width_o = 3;
	oper_add   n1l0lO
	( 
	.a({n100ii, n1000O, n1000l, n1000i, n1001O}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1l0lO_o));
	defparam
		n1l0lO.sgate_representation = 0,
		n1l0lO.width_a = 5,
		n1l0lO.width_b = 5,
		n1l0lO.width_o = 5;
	oper_add   n1O1OO
	( 
	.a({1'b0, rins_threshold[4:0], 1'b1}),
	.b({1'b0, {4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1O1OO_o));
	defparam
		n1O1OO.sgate_representation = 0,
		n1O1OO.width_a = 7,
		n1O1OO.width_b = 7,
		n1O1OO.width_o = 7;
	oper_add   ni01ii
	( 
	.a({ni1O0l, ni1O0i, ni1O1O, ni1O1l, ni1llO, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni01ii_o));
	defparam
		ni01ii.sgate_representation = 0,
		ni01ii.width_a = 6,
		ni01ii.width_b = 6,
		ni01ii.width_o = 6;
	oper_add   ni01il
	( 
	.a({ni1O0l, ni1O0i, ni1O1O, ni1O1l, ni1llO}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni01il_o));
	defparam
		ni01il.sgate_representation = 0,
		ni01il.width_a = 5,
		ni01il.width_b = 5,
		ni01il.width_o = 5;
	oper_add   ni1lii
	( 
	.a({(~ wire_ni1lil_o[5]), (~ wire_ni1lil_o[4]), (~ wire_ni1lil_o[3]), (~ wire_ni1lil_o[2]), (~ wire_ni1lil_o[1]), 1'b1}),
	.b({1'b1, 1'b0, 1'b1, {2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni1lii_o));
	defparam
		ni1lii.sgate_representation = 0,
		ni1lii.width_a = 6,
		ni1lii.width_b = 6,
		ni1lii.width_o = 6;
	oper_add   ni1lil
	( 
	.a({n0O0OO, nliil0O, nliilii, nliilil, nliiliO, 1'b1}),
	.b({(~ n0l0il), (~ n0l0ii), (~ n0l00O), (~ n0l00l), (~ n0O0ll), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni1lil_o));
	defparam
		ni1lil.sgate_representation = 0,
		ni1lil.width_a = 6,
		ni1lil.width_b = 6,
		ni1lil.width_o = 6;
	oper_add   ni1liO
	( 
	.a({n0l0il, n0l0ii, n0l00O, n0l00l, n0O0ll, 1'b1}),
	.b({(~ n0O0OO), (~ nliil0O), (~ nliilii), (~ nliilil), (~ nliiliO), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni1liO_o));
	defparam
		ni1liO.sgate_representation = 0,
		ni1liO.width_a = 6,
		ni1liO.width_b = 6,
		ni1liO.width_o = 6;
	oper_add   nl0OOi
	( 
	.a({niOOii, niOO0O, niOO0l, niOO0i, niOO1O}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nl0OOi_o));
	defparam
		nl0OOi.sgate_representation = 0,
		nl0OOi.width_a = 5,
		nl0OOi.width_b = 5,
		nl0OOi.width_o = 5;
	oper_add   nli1iO
	( 
	.a({1'b0, rins_threshold[4:0], 1'b1}),
	.b({1'b0, {4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli1iO_o));
	defparam
		nli1iO.sgate_representation = 0,
		nli1iO.width_a = 7,
		nli1iO.width_b = 7,
		nli1iO.width_o = 7;
	oper_add   nllliii
	( 
	.a({nlll1iO, nlll1il, nlll1ii, nlll10O, nlll10l, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllliii_o));
	defparam
		nllliii.sgate_representation = 0,
		nllliii.width_a = 6,
		nllliii.width_b = 6,
		nllliii.width_o = 6;
	oper_add   nllliil
	( 
	.a({nlll1iO, nlll1il, nlll1ii, nlll10O, nlll10l}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllliil_o));
	defparam
		nllliil.sgate_representation = 0,
		nllliil.width_a = 5,
		nllliil.width_b = 5,
		nllliil.width_o = 5;
	oper_add   nllliOl
	( 
	.a({nlll1iO, nlll1il, nlll1ii, nlll10O}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllliOl_o));
	defparam
		nllliOl.sgate_representation = 0,
		nllliOl.width_a = 4,
		nllliOl.width_b = 4,
		nllliOl.width_o = 4;
	oper_add   nllll1i
	( 
	.a({nlll1iO, nlll1il, nlll1ii, nlll10O, nlll10l}),
	.b({{3{1'b0}}, {2{1'b1}}}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllll1i_o));
	defparam
		nllll1i.sgate_representation = 0,
		nllll1i.width_a = 5,
		nllll1i.width_b = 5,
		nllll1i.width_o = 5;
	oper_add   nlO000i
	( 
	.a({nlO10Oi, nli0liO, nli0lli, nli0lll, nli0llO, 1'b1}),
	.b({(~ nlllO0i), (~ nlllO1O), (~ nlllO1l), (~ nlllO1i), (~ nllllli), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO000i_o));
	defparam
		nlO000i.sgate_representation = 0,
		nlO000i.width_a = 6,
		nlO000i.width_b = 6,
		nlO000i.width_o = 6;
	oper_add   nlO000l
	( 
	.a({nlllO0i, nlllO1O, nlllO1l, nlllO1i, nllllli, 1'b1}),
	.b({(~ nlO10Oi), (~ nli0liO), (~ nli0lli), (~ nli0lll), (~ nli0llO), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO000l_o));
	defparam
		nlO000l.sgate_representation = 0,
		nlO000l.width_a = 6,
		nlO000l.width_b = 6,
		nlO000l.width_o = 6;
	oper_add   nlO001O
	( 
	.a({(~ wire_nlO000i_o[5]), (~ wire_nlO000i_o[4]), (~ wire_nlO000i_o[3]), (~ wire_nlO000i_o[2]), (~ wire_nlO000i_o[1]), 1'b1}),
	.b({1'b1, 1'b0, 1'b1, {2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO001O_o));
	defparam
		nlO001O.sgate_representation = 0,
		nlO001O.width_a = 6,
		nlO001O.width_b = 6,
		nlO001O.width_o = 6;
	oper_add   nlO0lli
	( 
	.a({1'b0, rfull_threshold[4:0], 1'b1}),
	.b({1'b0, {4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO0lli_o));
	defparam
		nlO0lli.sgate_representation = 0,
		nlO0lli.width_a = 7,
		nlO0lli.width_b = 7,
		nlO0lli.width_o = 7;
	oper_add   nlO101i
	( 
	.a({nlllO0i, nlllO1O, nlllO1l, nlllO1i, nllllli, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO101i_o));
	defparam
		nlO101i.sgate_representation = 0,
		nlO101i.width_a = 6,
		nlO101i.width_b = 6,
		nlO101i.width_o = 6;
	oper_add   nlO10iO
	( 
	.a({nlllO0i, nlllO1O, nlllO1l, nlllO1i, nllllli}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO10iO_o));
	defparam
		nlO10iO.sgate_representation = 0,
		nlO10iO.width_a = 5,
		nlO10iO.width_b = 5,
		nlO10iO.width_o = 5;
	oper_decoder   n011iO
	( 
	.i({nli1Ol, nli1Oi, nli1lO, nli1ll}),
	.o(wire_n011iO_o));
	defparam
		n011iO.width_i = 4,
		n011iO.width_o = 16;
	oper_decoder   n011ll
	( 
	.i({nli1Ol, nli1Oi}),
	.o(wire_n011ll_o));
	defparam
		n011ll.width_i = 2,
		n011ll.width_o = 4;
	oper_decoder   n011Oi
	( 
	.i({nli1Ol, nli1Oi, nli1lO, nli1ll, nl1i0i}),
	.o(wire_n011Oi_o));
	defparam
		n011Oi.width_i = 5,
		n011Oi.width_o = 32;
	oper_decoder   n0OO1l
	( 
	.i({wire_ni1l1i_dataout, wire_ni1iOO_dataout, wire_ni1iOl_dataout, wire_ni1iOi_dataout, wire_ni1ilO_dataout}),
	.o(wire_n0OO1l_o));
	defparam
		n0OO1l.width_i = 5,
		n0OO1l.width_o = 32;
	oper_decoder   n1l00O
	( 
	.i({n100ii, n1000O, n1000l, n1000i, n1001O}),
	.o(wire_n1l00O_o));
	defparam
		n1l00O.width_i = 5,
		n1l00O.width_o = 32;
	oper_decoder   n1l01l
	( 
	.i({n100ii, n1000l, n1000i, n1001O}),
	.o(wire_n1l01l_o));
	defparam
		n1l01l.width_i = 4,
		n1l01l.width_o = 16;
	oper_decoder   n1l1OO
	( 
	.i({n100ii, n1000O, n1000l, n1000i}),
	.o(wire_n1l1OO_o));
	defparam
		n1l1OO.width_i = 4,
		n1l1OO.width_o = 16;
	oper_decoder   n1OliO
	( 
	.i({rskpsetbased, rclkcmpsqmd}),
	.o(wire_n1OliO_o));
	defparam
		n1OliO.width_i = 2,
		n1OliO.width_o = 4;
	oper_decoder   nl0O1i
	( 
	.i({niOOii, niOO0O, niOO0l, niOO0i}),
	.o(wire_nl0O1i_o));
	defparam
		nl0O1i.width_i = 4,
		nl0O1i.width_o = 16;
	oper_decoder   nl0O1O
	( 
	.i({niOOii, niOO0l, niOO0i, niOO1O}),
	.o(wire_nl0O1O_o));
	defparam
		nl0O1O.width_i = 4,
		nl0O1O.width_o = 16;
	oper_decoder   nl0Oii
	( 
	.i({niOOii, niOO0O, niOO0l, niOO0i, niOO1O}),
	.o(wire_nl0Oii_o));
	defparam
		nl0Oii.width_i = 5,
		nl0Oii.width_o = 32;
	oper_decoder   nliO01i
	( 
	.i({n1O00l, n1O00i, n1O01O, n1O01l, n1ll1l}),
	.o(wire_nliO01i_o));
	defparam
		nliO01i.width_i = 5,
		nliO01i.width_o = 32;
	oper_decoder   nliO1lO
	( 
	.i({n1O00l, n1O00i, n1O01O, n1O01l}),
	.o(wire_nliO1lO_o));
	defparam
		nliO1lO.width_i = 4,
		nliO1lO.width_o = 16;
	oper_decoder   nliO1Ol
	( 
	.i({n1O00l, n1O00i}),
	.o(wire_nliO1Ol_o));
	defparam
		nliO1Ol.width_i = 2,
		nliO1Ol.width_o = 4;
	oper_decoder   nlli01O
	( 
	.i({wire_nlO01lO_dataout, wire_nlO01ll_dataout, wire_nlO01li_dataout, wire_nlO01iO_dataout, wire_nlO01il_dataout}),
	.o(wire_nlli01O_o));
	defparam
		nlli01O.width_i = 5,
		nlli01O.width_o = 32;
	oper_less_than   n11iii
	( 
	.a({nlO011i, nlO1OOO, nlO1OOl, nlO1OOi, nlO1OiO}),
	.b({{2{1'b0}}, rempty_threshold[2:0]}),
	.cin(1'b0),
	.o(wire_n11iii_o));
	defparam
		n11iii.sgate_representation = 0,
		n11iii.width_a = 5,
		n11iii.width_b = 5;
	oper_less_than   n1O01i
	( 
	.a({rins_threshold[4:0]}),
	.b({nlii01l, wire_nliO1Ol_o[1], nlii01O, nlii00i, nlii00l}),
	.cin(1'b1),
	.o(wire_n1O01i_o));
	defparam
		n1O01i.sgate_representation = 0,
		n1O01i.width_a = 5,
		n1O01i.width_b = 5;
	oper_less_than   n1O10l
	( 
	.a({3{1'b0}}),
	.b({n11O0l, n11O0i, n11O1O}),
	.cin(1'b0),
	.o(wire_n1O10l_o));
	defparam
		n1O10l.sgate_representation = 0,
		n1O10l.width_a = 3,
		n1O10l.width_b = 3;
	oper_less_than   n1O11l
	( 
	.a({n11O0l, n11O0i, n11O1O}),
	.b({1'b1, 1'b0, 1'b1}),
	.cin(1'b0),
	.o(wire_n1O11l_o));
	defparam
		n1O11l.sgate_representation = 0,
		n1O11l.width_a = 3,
		n1O11l.width_b = 3;
	oper_less_than   n1OllO
	( 
	.a({rdel_threshold[4:0]}),
	.b({nlO011i, nlO1OOO, nlO1OOl, nlO1OOi, nlO1OiO}),
	.cin(1'b0),
	.o(wire_n1OllO_o));
	defparam
		n1OllO.sgate_representation = 0,
		n1OllO.width_a = 5,
		n1OllO.width_b = 5;
	oper_less_than   n1OlOi
	( 
	.a({nlO011i, nlO1OOO, nlO1OOl, nlO1OOi, nlO1OiO}),
	.b({rins_threshold[4:0]}),
	.cin(1'b0),
	.o(wire_n1OlOi_o));
	defparam
		n1OlOi.sgate_representation = 0,
		n1OlOi.width_a = 5,
		n1OlOi.width_b = 5;
	oper_less_than   n1OOlO
	( 
	.a({nlO011i, nlO1OOO, nlO1OOl, nlO1OOi, nlO1OiO}),
	.b({rdel_threshold[4:0]}),
	.cin(1'b1),
	.o(wire_n1OOlO_o));
	defparam
		n1OOlO.sgate_representation = 0,
		n1OOlO.width_a = 5,
		n1OOlO.width_b = 5;
	oper_less_than   n1OOOi
	( 
	.a({rins_threshold[4:0]}),
	.b({nlO011i, nlO1OOO, nlO1OOl, nlO1OOi, nlO1OiO}),
	.cin(1'b1),
	.o(wire_n1OOOi_o));
	defparam
		n1OOOi.sgate_representation = 0,
		n1OOOi.width_a = 5,
		n1OOOi.width_b = 5;
	oper_less_than   ni1i1i
	( 
	.a({5{1'b0}}),
	.b({n0O0OO, nliil0O, nliilii, nliilil, nliiliO}),
	.cin(1'b0),
	.o(wire_ni1i1i_o));
	defparam
		ni1i1i.sgate_representation = 0,
		ni1i1i.width_a = 5,
		ni1i1i.width_b = 5;
	oper_less_than   ni1lli
	( 
	.a({n0O0OO, nliil0O, nliilii, nliilil, nliiliO}),
	.b({n0l0il, n0l0ii, n0l00O, n0l00l, n0O0ll}),
	.cin(1'b0),
	.o(wire_ni1lli_o));
	defparam
		ni1lli.sgate_representation = 0,
		ni1lli.width_a = 5,
		ni1lli.width_b = 5;
	oper_less_than   nli1li
	( 
	.a({rins_threshold[4:0]}),
	.b({nlil1Oi, wire_n011ll_o[1], nlil1Ol, nlil1OO, nlil01i}),
	.cin(1'b1),
	.o(wire_nli1li_o));
	defparam
		nli1li.sgate_representation = 0,
		nli1li.width_a = 5,
		nli1li.width_b = 5;
	oper_less_than   nlilOi
	( 
	.a({ni1i0l, ni1i0i, ni1i1O, ni1i1l, ni101l}),
	.b({{2{1'b0}}, rempty_threshold[2:0]}),
	.cin(1'b0),
	.o(wire_nlilOi_o));
	defparam
		nlilOi.sgate_representation = 0,
		nlilOi.width_a = 5,
		nlilOi.width_b = 5;
	oper_less_than   nlli0iO
	( 
	.a({5{1'b0}}),
	.b({nlO10Oi, nli0liO, nli0lli, nli0lll, nli0llO}),
	.cin(1'b0),
	.o(wire_nlli0iO_o));
	defparam
		nlli0iO.sgate_representation = 0,
		nlli0iO.width_a = 5,
		nlli0iO.width_b = 5;
	oper_less_than   nllOii
	( 
	.a({((nlililO40 ^ nlililO39) & ni1i0l), ni1i0i, ni1i1O, ni1i1l, ni101l}),
	.b({rdel_threshold[4], ((nlilill42 ^ nlilill41) & rdel_threshold[3]), rdel_threshold[2:0]}),
	.cin(1'b1),
	.o(wire_nllOii_o));
	defparam
		nllOii.sgate_representation = 0,
		nllOii.width_a = 5,
		nllOii.width_b = 5;
	oper_less_than   nllOil
	( 
	.a({rins_threshold[4:0]}),
	.b({ni1i0l, ni1i0i, ni1i1O, ni1i1l, ni101l}),
	.cin(1'b1),
	.o(wire_nllOil_o));
	defparam
		nllOil.sgate_representation = 0,
		nllOil.width_a = 5,
		nllOil.width_b = 5;
	oper_less_than   nllOiO
	( 
	.a({rdel_threshold[4:0]}),
	.b({ni1i0l, ni1i0i, ni1i1O, ((nliliOi38 ^ nliliOi37) & ni1i1l), ni101l}),
	.cin(1'b0),
	.o(wire_nllOiO_o));
	defparam
		nllOiO.sgate_representation = 0,
		nllOiO.width_a = 5,
		nllOiO.width_b = 5;
	oper_less_than   nllOli
	( 
	.a({ni1i0l, ni1i0i, ((nliliOl36 ^ nliliOl35) & ni1i1O), ni1i1l, ni101l}),
	.b({rins_threshold[4:0]}),
	.cin(1'b0),
	.o(wire_nllOli_o));
	defparam
		nllOli.sgate_representation = 0,
		nllOli.width_a = 5,
		nllOli.width_b = 5;
	oper_less_than   nlO000O
	( 
	.a({nlO10Oi, nli0liO, nli0lli, nli0lll, nli0llO}),
	.b({nlllO0i, nlllO1O, nlllO1l, nlllO1i, nllllli}),
	.cin(1'b0),
	.o(wire_nlO000O_o));
	defparam
		nlO000O.sgate_representation = 0,
		nlO000O.width_a = 5,
		nlO000O.width_b = 5;
	oper_mux   nllOOO
	( 
	.data({((nliliOO34 ^ nliliOO33) & wire_nlO1iO_dataout), wire_nlO10O_dataout, {2{nlO01O}}}),
	.o(wire_nllOOO_o),
	.sel({nlO01l, nllOOl}));
	defparam
		nllOOO.width_data = 4,
		nllOOO.width_sel = 2;
	oper_mux   nlO11i
	( 
	.data({wire_nlO1li_dataout, ((nlill1i32 ^ nlill1i31) & wire_nlO10l_dataout), ((nlill1l30 ^ nlill1l29) & nllOOi), nllOOi}),
	.o(wire_nlO11i_o),
	.sel({nlO01l, nllOOl}));
	defparam
		nlO11i.width_data = 4,
		nlO11i.width_sel = 2;
	oper_mux   nlO11l
	( 
	.data({wire_nlO1ll_dataout, wire_nlO10i_dataout, wire_nl00O_dataout, ((wire_nl0ii_dataout & wire_nl00O_dataout) & (nlill1O28 ^ nlill1O27))}),
	.o(wire_nlO11l_o),
	.sel({nlO01l, nllOOl}));
	defparam
		nlO11l.width_data = 4,
		nlO11l.width_sel = 2;
	oper_mux   nlO11O
	( 
	.data({{2{wire_nl00O_dataout}}, wire_nlO1OO_dataout, 1'b0}),
	.o(wire_nlO11O_o),
	.sel({nlO01l, ((nlill0l26 ^ nlill0l25) & nllOOl)}));
	defparam
		nlO11O.width_data = 4,
		nlO11O.width_sel = 2;
	cycloneiv_hssi_rx_digis_ram20x16_syn   nllOll
	( 
	.clk(clk_1),
	.data_in({wire_nl10i_dataout, wire_nl11O_dataout, wire_nl11l_dataout, wire_nl11i_dataout, wire_niOOO_dataout, wire_niOOl_dataout, wire_niOOi_dataout, wire_niOlO_dataout, wire_niOll_dataout, wire_niOli_dataout, wire_niOiO_dataout, wire_niOil_dataout, wire_niOii_dataout, wire_niO0O_dataout, wire_niO0l_dataout, wire_niO0i_dataout}),
	.data_out1(wire_nllOll_data_out1),
	.data_out2(wire_nllOll_data_out2),
	.fifo_re1({wire_n1ii_dataout, wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout, wire_n11O_dataout, wire_n11l_dataout, wire_n11i_dataout, wire_nlOOO_dataout, wire_nlOOl_dataout, wire_nlOOi_dataout, wire_nlOlO_dataout, wire_nlOll_dataout, wire_nlOli_dataout, wire_nlOiO_dataout, wire_nlOil_dataout, wire_nlOii_dataout, wire_nlO0O_dataout, wire_nlO0l_dataout, wire_nlO0i_dataout, wire_nlO1O_dataout}),
	.fifo_re2({wire_nlO1l_dataout, wire_nlO1i_dataout, wire_nllOO_dataout, wire_nllOl_dataout, wire_nllOi_dataout, wire_nlllO_dataout, wire_nllll_dataout, wire_nllli_dataout, wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout, wire_nll0O_dataout, wire_nll0l_dataout, wire_nll0i_dataout, wire_nll1O_dataout, wire_nll1l_dataout, wire_nll1i_dataout, wire_nliOO_dataout, wire_nliOl_dataout, wire_nliOi_dataout}),
	.fifo_wr({wire_nlilO_dataout, wire_nlill_dataout, wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout, wire_nli0l_dataout, wire_nli0i_dataout, wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_nl0iO_dataout, wire_nl0il_dataout}),
	.rst_l((~ wire_nl0i_dataout)));
	defparam
		nllOll.ram_width = 16,
		nllOll.read_access_time = 0,
		nllOll.write_access_time = 0;
	cycloneiv_hssi_rx_digis_ram20x16_syn   nllOlO
	( 
	.clk(clk_1),
	.data_in({wire_nl00l_dataout, wire_nl00i_dataout, wire_nl01O_dataout, wire_nl01l_dataout, wire_nl01i_dataout, wire_nl1OO_dataout, wire_nl1Ol_dataout, wire_nl1Oi_dataout, wire_nl1lO_dataout, wire_nl1ll_dataout, wire_nl1li_dataout, wire_nl1iO_dataout, wire_nl1il_dataout, wire_nl1ii_dataout, wire_nl10O_dataout, wire_nl10l_dataout}),
	.data_out1(wire_nllOlO_data_out1),
	.data_out2(wire_nllOlO_data_out2),
	.fifo_re1({wire_n1ii_dataout, wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout, wire_n11O_dataout, wire_n11l_dataout, wire_n11i_dataout, wire_nlOOO_dataout, wire_nlOOl_dataout, wire_nlOOi_dataout, wire_nlOlO_dataout, wire_nlOll_dataout, wire_nlOli_dataout, wire_nlOiO_dataout, wire_nlOil_dataout, wire_nlOii_dataout, wire_nlO0O_dataout, wire_nlO0l_dataout, wire_nlO0i_dataout, wire_nlO1O_dataout}),
	.fifo_re2({wire_nlO1l_dataout, wire_nlO1i_dataout, wire_nllOO_dataout, wire_nllOl_dataout, wire_nllOi_dataout, wire_nlllO_dataout, wire_nllll_dataout, wire_nllli_dataout, wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout, wire_nll0O_dataout, wire_nll0l_dataout, wire_nll0i_dataout, wire_nll1O_dataout, wire_nll1l_dataout, wire_nll1i_dataout, wire_nliOO_dataout, wire_nliOl_dataout, wire_nliOi_dataout}),
	.fifo_wr({wire_nlilO_dataout, wire_nlill_dataout, wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout, wire_nli0l_dataout, wire_nli0i_dataout, wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_nl0iO_dataout, wire_nl0il_dataout}),
	.rst_l((~ wire_nl0i_dataout)));
	defparam
		nllOlO.ram_width = 16,
		nllOlO.read_access_time = 0,
		nllOlO.write_access_time = 0;
	assign
		align_status_sync = nlOiO0O,
		cg_comp_rd_d_out = wire_n1Oiil_dataout,
		cg_comp_wr_out = nlillil,
		comp_curr_st = {nlO01l, nllOOl},
		cudi = {wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout},
		cudi_valid = wire_niiOi_dataout,
		del_cond_met_out = wire_n1OllO_o,
		fifo_cnt = {wire_nl1O_dataout, wire_nl1l_dataout, wire_nl1i_dataout, wire_niOO_dataout, wire_niOl_dataout},
		fifo_ovr_out = nlO01O,
		fifo_rd_out_comp = n1lili,
		insert_incomplete_out = n1liil,
		latency_comp_out = (~ nlillii),
		nli00ll = (nlO10lO ^ nlO10li),
		nli00lO = (((((((((wire_nlli01O_o[18] | wire_nlli01O_o[17]) | wire_nlli01O_o[14]) | wire_nlli01O_o[13]) | wire_nlli01O_o[10]) | wire_nlli01O_o[9]) | wire_nlli01O_o[6]) | wire_nlli01O_o[5]) | wire_nlli01O_o[2]) | wire_nlli01O_o[1]),
		nli00Oi = ((((((((((wire_nlli01O_o[20] | wire_nlli01O_o[19]) | wire_nlli01O_o[12]) | wire_nlli01O_o[11]) | wire_nlli01O_o[4]) | wire_nlli01O_o[3]) | wire_nlli01O_o[18]) | wire_nlli01O_o[13]) | wire_nlli01O_o[10]) | wire_nlli01O_o[5]) | wire_nlli01O_o[2]),
		nli00Ol = ((((((((wire_nlli01O_o[20] | wire_nlli01O_o[11]) | wire_nlli01O_o[8]) | wire_nlli01O_o[7]) | wire_nlli01O_o[4]) | wire_nlli01O_o[10]) | wire_nlli01O_o[9]) | wire_nlli01O_o[6]) | wire_nlli01O_o[5]),
		nli00OO = ((((((((((((wire_nlli01O_o[20] | wire_nlli01O_o[19]) | wire_nlli01O_o[16]) | wire_nlli01O_o[15]) | wire_nlli01O_o[12]) | wire_nlli01O_o[11]) | wire_nlli01O_o[8]) | wire_nlli01O_o[18]) | wire_nlli01O_o[17]) | wire_nlli01O_o[14]) | wire_nlli01O_o[13]) | wire_nlli01O_o[10]) | wire_nlli01O_o[9]),
		nli0i0i = (wire_n1OlOi_o | nllil1i),
		nli0i0l = (wire_n1OllO_o | nllil1O),
		nli0i0O = ((((nlll1iO | nlll1il) | nlll1ii) | nlll10O) | nlll10l),
		nli0i1i = ((((wire_nlli01O_o[20] | wire_nlli01O_o[19]) | wire_nlli01O_o[16]) | wire_nlli01O_o[18]) | wire_nlli01O_o[17]),
		nli0i1l = (nli0l0i | nlli0Oi),
		nli0i1O = (((((wire_nlO0lli_o[6] & (~ (wire_nlO0lli_o[1] ^ nllii1O))) & (~ (wire_nlO0lli_o[2] ^ nllii0l))) & (~ (wire_nlO0lli_o[3] ^ nllii0O))) & (~ (wire_nlO0lli_o[4] ^ nlliiii))) & (~ (wire_nlO0lli_o[5] ^ nlliiil))),
		nli0iii = (((((~ nlll1iO) & (~ nlll1il)) & (~ nlll1ii)) & (~ nlll10O)) & (~ nlll10l)),
		nli0iil = (((~ rclkcmpsqmd) & (((~ rgenericfifo) & nli0l1O) | (rgenericfifo & (~ nlll1li)))) & nli0ill),
		nli0iiO = (nli0l1i & nli0ill),
		nli0ili = ((rclkcmpsqmd & (nli0l1O & (nlillOl | nllil0l))) & nli0ill),
		nli0ill = ((~ rskpsetbased) | (~ nli0l0i)),
		nli0ilO = ((rskpsetbased | ((~ rskpsetbased) & (~ nli0l1O))) & nli0l0i),
		nli0iOi = (((~ rgenericfifo) & (~ nli0l1O)) | (rgenericfifo & nlll1li)),
		nli0iOl = (((((~ nlllO0i) & (~ nlllO1O)) & (~ nlllO1l)) & (~ nlllO1i)) & (~ nllllli)),
		nli0iOO = ((~ rgenericfifo) & nli0l1i),
		nli0l0i = (((~ nli0l0l) & (nli0O1O & nli0i1O)) & (~ nlli0Ol)),
		nli0l0l = ((((~ rskpsetbased) & (wire_n1Olll_dataout & (wire_n1Olli_dataout & (nlillil & (((~ nlilO0l) | nliii0i) | (cg_comp_wr_ch3 & (cg_comp_wr_ch2 & (cg_comp_wr_ch0 & cg_comp_wr_ch1)))))))) | nlO1i0O) | (wire_n1OllO_o & (((rskpsetbased & (rtruebac2bac & (nlO00Oi | (nlO00lO | (nlO00ll | nlO00li))))) | ((~ rrx_pipe_enable) & (rskpsetbased & ((~ rtruebac2bac) & nlO00Oi)))) & nlO01O))),
		nli0l0O = (((((~ nlO011i) & (~ nlO1OOO)) & (~ (rstart_threshold[0] ^ nlO1OiO))) & (~ (rstart_threshold[1] ^ nlO1OOi))) & (~ (rstart_threshold[2] ^ nlO1OOl))),
		nli0l1i = (rclkcmpsqmd & nli0l1O),
		nli0l1l = ((((nlllO0i & (~ nlllO1O)) & (~ nlllO1l)) & nlllO1i) & nllllli),
		nli0l1O = (nli0l0l | (rskpsetbased & nli0l0i)),
		nli0lii = ((~ rgenericfifo) & (~ wire_nlOi10l_dataout)),
		nli0lil = (((((~ (nllllli ^ nli0llO)) & (~ (nlllO1i ^ nli0lll))) & (~ (nlllO1l ^ nli0lli))) & (~ (nlllO1O ^ nli0liO))) & (~ (nlO10Oi ^ nlllO0i))),
		nli0liO = ((~ nlO10Oi) & nlO10lO),
		nli0lli = ((~ nlO10Oi) & (nlO10lO ^ nlO10ll)),
		nli0lll = (nlO10Oi ^ (nlO10ll ^ nli00ll)),
		nli0llO = (nlO10Oi ^ (nli00ll ^ (nlO10ll ^ nllO1li))),
		nli0lOi = ((((((((((~ (rclkcmpsq1n[0] ^ wire_nlO0lOi_dataout)) & (~ (rclkcmpsq1n[1] ^ wire_nlO0lOl_dataout))) & (~ (rclkcmpsq1n[2] ^ wire_nlO0lOO_dataout))) & (~ (rclkcmpsq1n[3] ^ wire_nlO0O1i_dataout))) & (~ (rclkcmpsq1n[4] ^ wire_nlO0O1l_dataout))) & (~ (rclkcmpsq1n[5] ^ wire_nlO0O1O_dataout))) & (~ (rclkcmpsq1n[6] ^ wire_nlO0O0i_dataout))) & (~ (rclkcmpsq1n[7] ^ wire_nlO0O0l_dataout))) & (~ (rclkcmpsq1n[8] ^ wire_nlO0O0O_dataout))) & (~ (rclkcmpsq1n[9] ^ wire_nlO0Oii_dataout))),
		nli0lOl = ((((((((((~ (rclkcmpsq1p[0] ^ wire_nlO0lOi_dataout)) & (~ (rclkcmpsq1p[1] ^ wire_nlO0lOl_dataout))) & (~ (rclkcmpsq1p[2] ^ wire_nlO0lOO_dataout))) & (~ (rclkcmpsq1p[3] ^ wire_nlO0O1i_dataout))) & (~ (rclkcmpsq1p[4] ^ wire_nlO0O1l_dataout))) & (~ (rclkcmpsq1p[5] ^ wire_nlO0O1O_dataout))) & (~ (rclkcmpsq1p[6] ^ wire_nlO0O0i_dataout))) & (~ (rclkcmpsq1p[7] ^ wire_nlO0O0l_dataout))) & (~ (rclkcmpsq1p[8] ^ wire_nlO0O0O_dataout))) & (~ (rclkcmpsq1p[9] ^ wire_nlO0Oii_dataout))),
		nli0lOO = (nlii0OO & ((~ rclkcmpsqmd) | nlO00ii)),
		nli0O0i = ((~ rmatchen) | rgenericfifo),
		nli0O0l = (rmatchen | rgenericfifo),
		nli0O1i = ((~ wire_nlO0OlO_dataout) & ((~ wire_nlO0Oli_dataout) & nlO011l)),
		nli0O1l = (((((wire_nlO0lli_o[6] & (~ (wire_nlO0lli_o[1] ^ nllii1O))) & (~ (wire_nlO0lli_o[2] ^ nllii0l))) & (~ (wire_nlO0lli_o[3] ^ nllii0O))) & (~ (wire_nlO0lli_o[4] ^ nlliiii))) & (~ (wire_nlO0lli_o[5] ^ nlliiil))),
		nli0O1O = (((((~ (rfull_threshold[0] ^ nlO1OiO)) & (~ (rfull_threshold[1] ^ nlO1OOi))) & (~ (rfull_threshold[2] ^ nlO1OOl))) & (~ (rfull_threshold[3] ^ nlO1OOO))) & (~ (rfull_threshold[4] ^ nlO011i))),
		nli0Oii = (rgenericfifo & (~ nlOi1iO)),
		nli0Oil = (((~ rgenericfifo) & (~ nlii1li)) | nlOi1iO),
		nli0OiO = (n110ll | n110iO),
		nli0Oli = ((~ n110iO) & ((~ n110ll) & (n1liil & ((~ nlillii) & (wire_n1Oiil_dataout & (wire_n1Oi1O_dataout & (rmatchen & rrx_pipe_enable))))))),
		nli0Oll = ((((((((~ n11iOl) & (~ n11iOi)) & (~ n11ilO)) & (~ n11ill)) & (~ n11ili)) & (~ n11iiO)) & (~ n11iil)) & (~ n110lO)),
		nli0OlO = (rgenericfifo | wire_nlOi11i_dataout),
		nli0OOi = (wire_n1O11l_o & (wire_n1Oiil_dataout & (~ (((~ n11O0l) & (~ n11O0i)) & (~ n11O1O))))),
		nli0OOl = (wire_n1O11l_o & nlii1Ol),
		nli0OOO = (wire_n1Oiil_dataout & wire_n1Oi1O_dataout),
		nlii00i = ((((wire_nliO1lO_o[13] | wire_nliO1lO_o[7]) | wire_nliO1lO_o[4]) | wire_nliO1lO_o[2]) | wire_nliO1lO_o[1]),
		nlii00l = (((((((((wire_nliO01i_o[26] | wire_nliO01i_o[25]) | wire_nliO01i_o[11]) | wire_nliO01i_o[8]) | wire_nliO01i_o[7]) | wire_nliO01i_o[4]) | wire_nliO01i_o[14]) | wire_nliO01i_o[13]) | wire_nliO01i_o[2]) | wire_nliO01i_o[1]),
		nlii00O = ((~ rgenericfifo) & (~ wire_nlOi11i_dataout)),
		nlii01i = (((((wire_n1O1OO_o[6] & (~ (wire_n1O1OO_o[1] ^ nlii00l))) & (~ (wire_n1O1OO_o[2] ^ nlii00i))) & (~ (wire_n1O1OO_o[3] ^ nlii01O))) & (~ (wire_n1O1OO_o[4] ^ wire_nliO1Ol_o[1]))) & (~ (wire_n1O1OO_o[5] ^ nlii01l))),
		nlii01l = ((((wire_nliO01i_o[30] | wire_nliO01i_o[27]) | wire_nliO01i_o[26]) | wire_nliO01i_o[25]) | wire_nliO01i_o[24]),
		nlii01O = ((((((((wire_nliO01i_o[30] | wire_nliO01i_o[11]) | wire_nliO01i_o[10]) | wire_nliO01i_o[9]) | wire_nliO01i_o[8]) | wire_nliO01i_o[7]) | wire_nliO01i_o[6]) | wire_nliO01i_o[5]) | wire_nliO01i_o[4]),
		nlii0ii = ((((((((((~ (rclkcmpsq1n[0] ^ nlOl01O)) & (~ (rclkcmpsq1n[1] ^ nlOl00i))) & (~ (rclkcmpsq1n[2] ^ nlOl00l))) & (~ (rclkcmpsq1n[3] ^ nlOl00O))) & (~ (rclkcmpsq1n[4] ^ nlOl0ii))) & (~ (rclkcmpsq1n[5] ^ nlOl0il))) & (~ (rclkcmpsq1n[6] ^ nlOl0iO))) & (~ (rclkcmpsq1n[7] ^ nlOl0li))) & (~ (rclkcmpsq1n[8] ^ nlOl0ll))) & (~ (rclkcmpsq1n[9] ^ nlOl0lO))),
		nlii0il = ((((((((((~ (rclkcmpsq1p[0] ^ nlOl01O)) & (~ (rclkcmpsq1p[1] ^ nlOl00i))) & (~ (rclkcmpsq1p[2] ^ nlOl00l))) & (~ (rclkcmpsq1p[3] ^ nlOl00O))) & (~ (rclkcmpsq1p[4] ^ nlOl0ii))) & (~ (rclkcmpsq1p[5] ^ nlOl0il))) & (~ (rclkcmpsq1p[6] ^ nlOl0iO))) & (~ (rclkcmpsq1p[7] ^ nlOl0li))) & (~ (rclkcmpsq1p[8] ^ nlOl0ll))) & (~ (rclkcmpsq1p[9] ^ nlOl0lO))),
		nlii0iO = ((((((((((~ (rclkcmpsq1n[0] ^ nlOl10O)) & (~ (rclkcmpsq1n[1] ^ nlOl1ii))) & (~ (rclkcmpsq1n[2] ^ nlOl1il))) & (~ (rclkcmpsq1n[3] ^ nlOl1iO))) & (~ (rclkcmpsq1n[4] ^ nlOl1li))) & (~ (rclkcmpsq1n[5] ^ nlOl1ll))) & (~ (rclkcmpsq1n[6] ^ nlOl1lO))) & (~ (rclkcmpsq1n[7] ^ nlOl1Oi))) & (~ (rclkcmpsq1n[8] ^ nlOl1Ol))) & (~ (rclkcmpsq1n[9] ^ nlOl1OO))),
		nlii0li = ((((((((((~ (rclkcmpsq1p[0] ^ nlOl10O)) & (~ (rclkcmpsq1p[1] ^ nlOl1ii))) & (~ (rclkcmpsq1p[2] ^ nlOl1il))) & (~ (rclkcmpsq1p[3] ^ nlOl1iO))) & (~ (rclkcmpsq1p[4] ^ nlOl1li))) & (~ (rclkcmpsq1p[5] ^ nlOl1ll))) & (~ (rclkcmpsq1p[6] ^ nlOl1lO))) & (~ (rclkcmpsq1p[7] ^ nlOl1Oi))) & (~ (rclkcmpsq1p[8] ^ nlOl1Ol))) & (~ (rclkcmpsq1p[9] ^ nlOl1OO))),
		nlii0ll = ((((((((((~ (wire_n1OiOi_dataout ^ nlOl01O)) & (~ (wire_n1OiOl_dataout ^ nlOl00i))) & (~ (wire_n1OiOO_dataout ^ nlOl00l))) & (~ (wire_n1Ol1i_dataout ^ nlOl00O))) & (~ (wire_n1Ol1l_dataout ^ nlOl0ii))) & (~ (wire_n1Ol1O_dataout ^ nlOl0il))) & (~ (wire_n1Ol0i_dataout ^ nlOl0iO))) & (~ (wire_n1Ol0l_dataout ^ nlOl0li))) & (~ (wire_n1Ol0O_dataout ^ nlOl0ll))) & (~ (wire_n1Olii_dataout ^ nlOl0lO))),
		nlii0lO = ((((((((((~ (wire_n1OlOl_dataout ^ nlOl01O)) & (~ (wire_n1OlOO_dataout ^ nlOl00i))) & (~ (wire_n1OO1i_dataout ^ nlOl00l))) & (~ (wire_n1OO1l_dataout ^ nlOl00O))) & (~ (wire_n1OO1O_dataout ^ nlOl0ii))) & (~ (wire_n1OO0i_dataout ^ nlOl0il))) & (~ (wire_n1OO0l_dataout ^ nlOl0iO))) & (~ (wire_n1OO0O_dataout ^ nlOl0li))) & (~ (wire_n1OOii_dataout ^ nlOl0ll))) & (~ (wire_n1OOil_dataout ^ nlOl0lO))),
		nlii0Oi = ((((((((((~ (wire_n1OiOi_dataout ^ nlOl10O)) & (~ (wire_n1OiOl_dataout ^ nlOl1ii))) & (~ (wire_n1OiOO_dataout ^ nlOl1il))) & (~ (wire_n1Ol1i_dataout ^ nlOl1iO))) & (~ (wire_n1Ol1l_dataout ^ nlOl1li))) & (~ (wire_n1Ol1O_dataout ^ nlOl1ll))) & (~ (wire_n1Ol0i_dataout ^ nlOl1lO))) & (~ (wire_n1Ol0l_dataout ^ nlOl1Oi))) & (~ (wire_n1Ol0O_dataout ^ nlOl1Ol))) & (~ (wire_n1Olii_dataout ^ nlOl1OO))),
		nlii0Ol = ((((((((((~ (wire_n1OlOl_dataout ^ nlOl10O)) & (~ (wire_n1OlOO_dataout ^ nlOl1ii))) & (~ (wire_n1OO1i_dataout ^ nlOl1il))) & (~ (wire_n1OO1l_dataout ^ nlOl1iO))) & (~ (wire_n1OO1O_dataout ^ nlOl1li))) & (~ (wire_n1OO0i_dataout ^ nlOl1ll))) & (~ (wire_n1OO0l_dataout ^ nlOl1lO))) & (~ (wire_n1OO0O_dataout ^ nlOl1Oi))) & (~ (wire_n1OOii_dataout ^ nlOl1Ol))) & (~ (wire_n1OOil_dataout ^ nlOl1OO))),
		nlii0OO = (nliii1l | nliii1i),
		nlii10i = ((((n100ii & (~ n1000O)) & (~ n1000l)) & n1000i) & n1001O),
		nlii10l = (((~ rgenericfifo) & ((~ nlii1li) & wire_n1li1O_dataout)) | nlii1iO),
		nlii10O = (dskwclksel[0] & nlii1il),
		nlii11i = ((((wire_n1l1OO_o[8] | wire_n1l1OO_o[6]) | wire_n1l1OO_o[4]) | wire_n1l1OO_o[2]) | wire_n1l1OO_o[0]),
		nlii11l = (((((((wire_n1l00O_o[10] | wire_n1l00O_o[9]) | wire_n1l00O_o[8]) | wire_n1l00O_o[7]) | wire_n1l00O_o[6]) | wire_n1l00O_o[5]) | wire_n1l00O_o[4]) | wire_n1l00O_o[3]),
		nlii11O = (((((((((wire_n1l00O_o[16] | wire_n1l00O_o[15]) | wire_n1l00O_o[14]) | wire_n1l00O_o[13]) | wire_n1l00O_o[12]) | wire_n1l00O_o[11]) | wire_n1l00O_o[10]) | wire_n1l00O_o[9]) | wire_n1l00O_o[8]) | wire_n1l00O_o[7]),
		nlii1ii = ((~ dskwclksel[0]) & nlii1il),
		nlii1il = ((~ is_lane0) & nlilO0l),
		nlii1iO = (rgenericfifo & nlOi1iO),
		nlii1li = ((((~ nlilO0l) | (cg_comp_rd_d_ch3 & (cg_comp_rd_d_ch2 & (cg_comp_rd_d_ch0 & cg_comp_rd_d_ch1)))) & (wire_n1Oiil_dataout & (wire_n1O1ll_dataout & ((~ rskpsetbased) & (((~ rclkcmpsqmd) & wire_n1O1lO_dataout) & nlii1OO))))) | ((((((rclkcmpsqmd & (~ nlillii)) & (rtruebac2bac | ((~ rtruebac2bac) & (~ n11iOO)))) & n1liil) & ((nlii0Ol & nlii1lO) | (nlii0Oi & nlii1ll))) | n11O1l) | (nlii1Ol | (nlii1Oi | nlO00OO)))),
		nlii1ll = ((((((((((~ (rclkcmpsq1n[0] ^ nlOiOil)) & (~ (rclkcmpsq1n[1] ^ nlOiOli))) & (~ (rclkcmpsq1n[2] ^ nlOiOll))) & (~ (rclkcmpsq1n[3] ^ nlOiOlO))) & (~ (rclkcmpsq1n[4] ^ nlOiOOi))) & (~ (rclkcmpsq1n[5] ^ nlOiOOl))) & (~ (rclkcmpsq1n[6] ^ nlOiOOO))) & (~ (rclkcmpsq1n[7] ^ nlOl11i))) & (~ (rclkcmpsq1n[8] ^ nlOl11l))) & (~ (rclkcmpsq1n[9] ^ nlOl11O))),
		nlii1lO = ((((((((((~ (rclkcmpsq1p[0] ^ nlOiOil)) & (~ (rclkcmpsq1p[1] ^ nlOiOli))) & (~ (rclkcmpsq1p[2] ^ nlOiOll))) & (~ (rclkcmpsq1p[3] ^ nlOiOlO))) & (~ (rclkcmpsq1p[4] ^ nlOiOOi))) & (~ (rclkcmpsq1p[5] ^ nlOiOOl))) & (~ (rclkcmpsq1p[6] ^ nlOiOOO))) & (~ (rclkcmpsq1p[7] ^ nlOl11i))) & (~ (rclkcmpsq1p[8] ^ nlOl11l))) & (~ (rclkcmpsq1p[9] ^ nlOl11O))),
		nlii1Oi = (rskpsetbased & n110ll),
		nlii1Ol = (((~ wire_n1Oiil_dataout) & (((rskpsetbased & ((~ rrx_pipe_enable) & (((~ rclkcmpsqmd) & (~ nlillii)) & nlii1OO))) & n1liil) & wire_n1O10l_o)) & wire_n1O11l_o),
		nlii1OO = (rtruebac2bac | ((~ rtruebac2bac) & (~ n11O1i))),
		nliii0i = (rskpsetbased | rclkcmpsqmd),
		nliii0l = (n0O0Ol ^ n0O0lO),
		nliii0O = ((((n0O0ll & n0l0il) & (~ n0l0ii)) & (~ n0l00O)) & n0l00l),
		nliii1i = ((((((((((~ (wire_n1OiOi_dataout ^ wire_nlO0lOi_dataout)) & (~ (wire_n1OiOl_dataout ^ wire_nlO0lOl_dataout))) & (~ (wire_n1OiOO_dataout ^ wire_nlO0lOO_dataout))) & (~ (wire_n1Ol1i_dataout ^ wire_nlO0O1i_dataout))) & (~ (wire_n1Ol1l_dataout ^ wire_nlO0O1l_dataout))) & (~ (wire_n1Ol1O_dataout ^ wire_nlO0O1O_dataout))) & (~ (wire_n1Ol0i_dataout ^ wire_nlO0O0i_dataout))) & (~ (wire_n1Ol0l_dataout ^ wire_nlO0O0l_dataout))) & (~ (wire_n1Ol0O_dataout ^ wire_nlO0O0O_dataout))) & (~ (wire_n1Olii_dataout ^ wire_nlO0Oii_dataout))),
		nliii1l = ((((((((((~ (wire_n1OlOl_dataout ^ wire_nlO0lOi_dataout)) & (~ (wire_n1OlOO_dataout ^ wire_nlO0lOl_dataout))) & (~ (wire_n1OO1i_dataout ^ wire_nlO0lOO_dataout))) & (~ (wire_n1OO1l_dataout ^ wire_nlO0O1i_dataout))) & (~ (wire_n1OO1O_dataout ^ wire_nlO0O1l_dataout))) & (~ (wire_n1OO0i_dataout ^ wire_nlO0O1O_dataout))) & (~ (wire_n1OO0l_dataout ^ wire_nlO0O0i_dataout))) & (~ (wire_n1OO0O_dataout ^ wire_nlO0O0l_dataout))) & (~ (wire_n1OOii_dataout ^ wire_nlO0O0O_dataout))) & (~ (wire_n1OOil_dataout ^ wire_nlO0Oii_dataout))),
		nliii1O = (wire_n1OliO_o[3] | wire_n1OliO_o[0]),
		nliiiii = (((((((((wire_n0OO1l_o[18] | wire_n0OO1l_o[17]) | wire_n0OO1l_o[14]) | wire_n0OO1l_o[13]) | wire_n0OO1l_o[10]) | wire_n0OO1l_o[9]) | wire_n0OO1l_o[6]) | wire_n0OO1l_o[5]) | wire_n0OO1l_o[2]) | wire_n0OO1l_o[1]),
		nliiiil = ((((((((((wire_n0OO1l_o[20] | wire_n0OO1l_o[19]) | wire_n0OO1l_o[18]) | wire_n0OO1l_o[13]) | wire_n0OO1l_o[12]) | wire_n0OO1l_o[11]) | wire_n0OO1l_o[10]) | wire_n0OO1l_o[5]) | wire_n0OO1l_o[4]) | wire_n0OO1l_o[3]) | wire_n0OO1l_o[2]),
		nliiiiO = ((((((((wire_n0OO1l_o[20] | wire_n0OO1l_o[11]) | wire_n0OO1l_o[10]) | wire_n0OO1l_o[9]) | wire_n0OO1l_o[8]) | wire_n0OO1l_o[7]) | wire_n0OO1l_o[6]) | wire_n0OO1l_o[5]) | wire_n0OO1l_o[4]),
		nliiili = ((((((((((((wire_n0OO1l_o[20] | wire_n0OO1l_o[19]) | wire_n0OO1l_o[18]) | wire_n0OO1l_o[17]) | wire_n0OO1l_o[16]) | wire_n0OO1l_o[15]) | wire_n0OO1l_o[14]) | wire_n0OO1l_o[13]) | wire_n0OO1l_o[12]) | wire_n0OO1l_o[11]) | wire_n0OO1l_o[10]) | wire_n0OO1l_o[9]) | wire_n0OO1l_o[8]),
		nliiill = ((((wire_n0OO1l_o[20] | wire_n0OO1l_o[19]) | wire_n0OO1l_o[18]) | wire_n0OO1l_o[17]) | wire_n0OO1l_o[16]),
		nliiilO = (((((~ ni1i0l) & (~ ni1i0i)) & (~ (rstart_threshold[0] ^ ni101l))) & (~ (rstart_threshold[1] ^ ni1i1l))) & (~ (rstart_threshold[2] ^ ni1i1O))),
		nliiiOi = (nliiO0O | n0OOli),
		nliiiOl = (((((wire_n0OOOO_o[6] & (~ (wire_n0OOOO_o[1] ^ n0OOll))) & (~ (ni111i ^ wire_n0OOOO_o[2]))) & (~ (ni111l ^ wire_n0OOOO_o[3]))) & (~ (ni111O ^ wire_n0OOOO_o[4]))) & (~ (ni110i ^ wire_n0OOOO_o[5]))),
		nliiiOO = (((((~ (rfull_threshold[0] ^ ni101l)) & (~ (rfull_threshold[1] ^ ni1i1l))) & (~ (rfull_threshold[2] ^ ni1i1O))) & (~ (rfull_threshold[3] ^ ni1i0i))) & (~ (rfull_threshold[4] ^ ni1i0l))),
		nliil0i = (wire_nllOiO_o | ni11OO),
		nliil0l = (((((~ (n0O0ll ^ nliiliO)) & (~ (n0l00l ^ nliilil))) & (~ (n0l00O ^ nliilii))) & (~ (n0l0ii ^ nliil0O))) & (~ (n0O0OO ^ n0l0il))),
		nliil0O = ((~ n0O0OO) & n0O0Ol),
		nliil1O = (wire_nllOli_o | ni11lO),
		nliilii = ((~ n0O0OO) & (n0O0Ol ^ n0O0Oi)),
		nliilil = (n0O0OO ^ (n0O0Oi ^ nliii0l)),
		nliiliO = (n0O0OO ^ (nliii0l ^ (n0O0Oi ^ n0liOl))),
		nliilli = (wire_nllOiO_o & ((ni00Oi | ni00iO) & nlO01O)),
		nliilll = (((((~ ni1O0l) & (~ ni1O0i)) & (~ ni1O1O)) & (~ ni1O1l)) & (~ ni1llO)),
		nliillO = ((((~ rgenericfifo) & nliilOO) | (rgenericfifo & (~ n0Oiil))) & (~ nliiO0O)),
		nliilOi = ((((ni1O0l | ni1O0i) | ni1O1O) | ni1O1l) | ni1llO),
		nliilOl = (((~ rgenericfifo) & (~ nliilOO)) | (rgenericfifo & n0Oiil)),
		nliilOO = (nliilli | nliiO0O),
		nliiO0i = ((((((((((~ (sudi[14] ^ rclkcmpsq1n[0])) & (~ (sudi[15] ^ rclkcmpsq1n[1]))) & (~ (sudi[16] ^ rclkcmpsq1n[2]))) & (~ (sudi[17] ^ rclkcmpsq1n[3]))) & (~ (sudi[18] ^ rclkcmpsq1n[4]))) & (~ (sudi[19] ^ rclkcmpsq1n[5]))) & (~ (sudi[20] ^ rclkcmpsq1n[6]))) & (~ (sudi[21] ^ rclkcmpsq1n[7]))) & (~ (sudi[22] ^ rclkcmpsq1n[8]))) & (~ (sudi[23] ^ rclkcmpsq1n[9]))),
		nliiO0l = ((((((((((~ (sudi[14] ^ rclkcmpsq1p[0])) & (~ (sudi[15] ^ rclkcmpsq1p[1]))) & (~ (sudi[16] ^ rclkcmpsq1p[2]))) & (~ (sudi[17] ^ rclkcmpsq1p[3]))) & (~ (sudi[18] ^ rclkcmpsq1p[4]))) & (~ (sudi[19] ^ rclkcmpsq1p[5]))) & (~ (sudi[20] ^ rclkcmpsq1p[6]))) & (~ (sudi[21] ^ rclkcmpsq1p[7]))) & (~ (sudi[22] ^ rclkcmpsq1p[8]))) & (~ (sudi[23] ^ rclkcmpsq1p[9]))),
		nliiO0O = ((~ ni1i0O) & ((~ nliilli) & (nliiiOO & nliiiOl))),
		nliiO1i = ((~ rgenericfifo) & (~ wire_nliOOi_dataout)),
		nliiO1l = ((((((((((~ (sudi[0] ^ rclkcmpsq1n[0])) & (~ (sudi[1] ^ rclkcmpsq1n[1]))) & (~ (sudi[2] ^ rclkcmpsq1n[2]))) & (~ (sudi[3] ^ rclkcmpsq1n[3]))) & (~ (sudi[4] ^ rclkcmpsq1n[4]))) & (~ (sudi[5] ^ rclkcmpsq1n[5]))) & (~ (sudi[6] ^ rclkcmpsq1n[6]))) & (~ (sudi[7] ^ rclkcmpsq1n[7]))) & (~ (sudi[8] ^ rclkcmpsq1n[8]))) & (~ (sudi[9] ^ rclkcmpsq1n[9]))),
		nliiO1O = ((((((((((~ (sudi[0] ^ rclkcmpsq1p[0])) & (~ (sudi[1] ^ rclkcmpsq1p[1]))) & (~ (sudi[2] ^ rclkcmpsq1p[2]))) & (~ (sudi[3] ^ rclkcmpsq1p[3]))) & (~ (sudi[4] ^ rclkcmpsq1p[4]))) & (~ (sudi[5] ^ rclkcmpsq1p[5]))) & (~ (sudi[6] ^ rclkcmpsq1p[6]))) & (~ (sudi[7] ^ rclkcmpsq1p[7]))) & (~ (sudi[8] ^ rclkcmpsq1p[8]))) & (~ (sudi[9] ^ rclkcmpsq1p[9]))),
		nliiOii = (nliiOiO | nliiOil),
		nliiOil = ((((((((((~ (sudi[14] ^ rclkcmpsq1n[10])) & (~ (sudi[15] ^ rclkcmpsq1n[11]))) & (~ (sudi[16] ^ rclkcmpsq1n[12]))) & (~ (sudi[17] ^ rclkcmpsq1n[13]))) & (~ (sudi[18] ^ rclkcmpsq1n[14]))) & (~ (sudi[19] ^ rclkcmpsq1n[15]))) & (~ (sudi[20] ^ rclkcmpsq1n[16]))) & (~ (sudi[21] ^ rclkcmpsq1n[17]))) & (~ (sudi[22] ^ rclkcmpsq1n[18]))) & (~ (sudi[23] ^ rclkcmpsq1n[19]))),
		nliiOiO = ((((((((((~ (sudi[14] ^ rclkcmpsq1p[10])) & (~ (sudi[15] ^ rclkcmpsq1p[11]))) & (~ (sudi[16] ^ rclkcmpsq1p[12]))) & (~ (sudi[17] ^ rclkcmpsq1p[13]))) & (~ (sudi[18] ^ rclkcmpsq1p[14]))) & (~ (sudi[19] ^ rclkcmpsq1p[15]))) & (~ (sudi[20] ^ rclkcmpsq1p[16]))) & (~ (sudi[21] ^ rclkcmpsq1p[17]))) & (~ (sudi[22] ^ rclkcmpsq1p[18]))) & (~ (sudi[23] ^ rclkcmpsq1p[19]))),
		nliiOli = (nliiOlO | nliiOll),
		nliiOll = ((((((((((~ (sudi[0] ^ rclkcmpsq1n[10])) & (~ (sudi[1] ^ rclkcmpsq1n[11]))) & (~ (sudi[2] ^ rclkcmpsq1n[12]))) & (~ (sudi[3] ^ rclkcmpsq1n[13]))) & (~ (sudi[4] ^ rclkcmpsq1n[14]))) & (~ (sudi[5] ^ rclkcmpsq1n[15]))) & (~ (sudi[6] ^ rclkcmpsq1n[16]))) & (~ (sudi[7] ^ rclkcmpsq1n[17]))) & (~ (sudi[8] ^ rclkcmpsq1n[18]))) & (~ (sudi[9] ^ rclkcmpsq1n[19]))),
		nliiOlO = ((((((((((~ (sudi[0] ^ rclkcmpsq1p[10])) & (~ (sudi[1] ^ rclkcmpsq1p[11]))) & (~ (sudi[2] ^ rclkcmpsq1p[12]))) & (~ (sudi[3] ^ rclkcmpsq1p[13]))) & (~ (sudi[4] ^ rclkcmpsq1p[14]))) & (~ (sudi[5] ^ rclkcmpsq1p[15]))) & (~ (sudi[6] ^ rclkcmpsq1p[16]))) & (~ (sudi[7] ^ rclkcmpsq1p[17]))) & (~ (sudi[8] ^ rclkcmpsq1p[18]))) & (~ (sudi[9] ^ rclkcmpsq1p[19]))),
		nlil00i = (nlil0l | nlil1O),
		nlil00l = ((~ rgenericfifo) & (~ wire_nliOlO_dataout)),
		nlil00O = (rgenericfifo | wire_nliOlO_dataout),
		nlil01i = (((((((((wire_n011Oi_o[26] | wire_n011Oi_o[25]) | wire_n011Oi_o[11]) | wire_n011Oi_o[8]) | wire_n011Oi_o[7]) | wire_n011Oi_o[4]) | wire_n011Oi_o[14]) | wire_n011Oi_o[13]) | wire_n011Oi_o[2]) | wire_n011Oi_o[1]),
		nlil01O = (rgenericfifo & nli0il),
		nlil0ii = ((((((((((~ (rclkcmpsq1n[0] ^ wire_nllOlO_data_out2[0])) & (~ (rclkcmpsq1n[1] ^ wire_nllOlO_data_out2[1]))) & (~ (rclkcmpsq1n[2] ^ wire_nllOlO_data_out2[2]))) & (~ (rclkcmpsq1n[3] ^ wire_nllOlO_data_out2[3]))) & (~ (rclkcmpsq1n[4] ^ wire_nllOlO_data_out2[4]))) & (~ (rclkcmpsq1n[5] ^ wire_nllOlO_data_out2[5]))) & (~ (rclkcmpsq1n[6] ^ wire_nllOlO_data_out2[6]))) & (~ (rclkcmpsq1n[7] ^ wire_nllOlO_data_out2[7]))) & (~ (rclkcmpsq1n[8] ^ wire_nllOlO_data_out2[8]))) & (~ (rclkcmpsq1n[9] ^ wire_nllOlO_data_out2[9]))),
		nlil0il = ((((((((((~ (rclkcmpsq1p[0] ^ wire_nllOlO_data_out2[0])) & (~ (rclkcmpsq1p[1] ^ wire_nllOlO_data_out2[1]))) & (~ (rclkcmpsq1p[2] ^ wire_nllOlO_data_out2[2]))) & (~ (rclkcmpsq1p[3] ^ wire_nllOlO_data_out2[3]))) & (~ (rclkcmpsq1p[4] ^ wire_nllOlO_data_out2[4]))) & (~ (rclkcmpsq1p[5] ^ wire_nllOlO_data_out2[5]))) & (~ (rclkcmpsq1p[6] ^ wire_nllOlO_data_out2[6]))) & (~ (rclkcmpsq1p[7] ^ wire_nllOlO_data_out2[7]))) & (~ (rclkcmpsq1p[8] ^ wire_nllOlO_data_out2[8]))) & (~ (rclkcmpsq1p[9] ^ wire_nllOlO_data_out2[9]))),
		nlil0iO = (nlil0l | nliliii),
		nlil0lO = ((((((((((~ (rclkcmpsq1n[10] ^ wire_nllOll_data_out2[0])) & (~ (rclkcmpsq1n[11] ^ wire_nllOll_data_out2[1]))) & (~ (rclkcmpsq1n[12] ^ wire_nllOll_data_out2[2]))) & (~ (rclkcmpsq1n[13] ^ wire_nllOll_data_out2[3]))) & (~ (rclkcmpsq1n[14] ^ wire_nllOll_data_out2[4]))) & (~ (rclkcmpsq1n[15] ^ wire_nllOll_data_out2[5]))) & (~ (rclkcmpsq1n[16] ^ wire_nllOll_data_out2[6]))) & (~ (rclkcmpsq1n[17] ^ wire_nllOll_data_out2[7]))) & (~ (rclkcmpsq1n[18] ^ wire_nllOll_data_out2[8]))) & (~ (rclkcmpsq1n[19] ^ wire_nllOll_data_out2[9]))),
		nlil0Oi = ((((((((((~ (rclkcmpsq1p[10] ^ wire_nllOll_data_out2[0])) & (~ (rclkcmpsq1p[11] ^ wire_nllOll_data_out2[1]))) & (~ (rclkcmpsq1p[12] ^ wire_nllOll_data_out2[2]))) & (~ (rclkcmpsq1p[13] ^ wire_nllOll_data_out2[3]))) & (~ (rclkcmpsq1p[14] ^ wire_nllOll_data_out2[4]))) & (~ (rclkcmpsq1p[15] ^ wire_nllOll_data_out2[5]))) & (~ (rclkcmpsq1p[16] ^ wire_nllOll_data_out2[6]))) & (~ (rclkcmpsq1p[17] ^ wire_nllOll_data_out2[7]))) & (~ (rclkcmpsq1p[18] ^ wire_nllOll_data_out2[8]))) & (~ (rclkcmpsq1p[19] ^ wire_nllOll_data_out2[9]))),
		nlil10i = (((((((((nii0il & nii0ii) & nii00O) & (~ nii00l)) & nii00i) & (~ nii01O)) & (~ nii01i)) & (~ nii1OO)) & (~ ((~ rclkcmpinsertpad) ^ nii1Ol))) & (~ (rclkcmpinsertpad ^ nii01l))),
		nlil10l = (rgenericfifo & (~ nli0il)),
		nlil10O = (nli0il | ((~ rgenericfifo) & (~ nlil0iO))),
		nlil11i = ((((((((((~ nii1ii) & (~ nii10O)) & (~ nii10l)) & nii10i) & (~ nii11O)) & nii11l) & ni0OOO) & ni0OOl) & (~ (rclkcmpinsertpad ^ ni0OOi))) & (~ ((~ rclkcmpinsertpad) ^ nii11i))),
		nlil11l = (((((((((nii1ii & nii10O) & nii10l) & (~ nii10i)) & nii11O) & (~ nii11l)) & (~ ni0OOO)) & (~ ni0OOl)) & (~ ((~ rclkcmpinsertpad) ^ ni0OOi))) & (~ (rclkcmpinsertpad ^ nii11i))),
		nlil11O = ((((((((((~ nii0il) & (~ nii0ii)) & (~ nii00O)) & nii00l) & (~ nii00i)) & nii01O) & nii01i) & nii1OO) & (~ (rclkcmpinsertpad ^ nii1Ol))) & (~ ((~ rclkcmpinsertpad) ^ nii01l))),
		nlil1ii = ((((wire_nl0O1i_o[8] | wire_nl0O1i_o[6]) | wire_nl0O1i_o[4]) | wire_nl0O1i_o[2]) | wire_nl0O1i_o[0]),
		nlil1il = (((((((wire_nl0Oii_o[10] | wire_nl0Oii_o[9]) | wire_nl0Oii_o[8]) | wire_nl0Oii_o[7]) | wire_nl0Oii_o[6]) | wire_nl0Oii_o[5]) | wire_nl0Oii_o[4]) | wire_nl0Oii_o[3]),
		nlil1iO = (((((((((wire_nl0Oii_o[16] | wire_nl0Oii_o[15]) | wire_nl0Oii_o[14]) | wire_nl0Oii_o[13]) | wire_nl0Oii_o[12]) | wire_nl0Oii_o[11]) | wire_nl0Oii_o[10]) | wire_nl0Oii_o[9]) | wire_nl0Oii_o[8]) | wire_nl0Oii_o[7]),
		nlil1li = ((((niOOii & (~ niOO0O)) & (~ niOO0l)) & niOO0i) & niOO1O),
		nlil1ll = (((~ rgenericfifo) & (nlii0O & (~ nlil0iO))) | nlil01O),
		nlil1lO = (((((wire_nli1iO_o[6] & (~ (wire_nli1iO_o[1] ^ nlil01i))) & (~ (wire_nli1iO_o[2] ^ nlil1OO))) & (~ (wire_nli1iO_o[3] ^ nlil1Ol))) & (~ (wire_nli1iO_o[4] ^ wire_n011ll_o[1]))) & (~ (wire_nli1iO_o[5] ^ nlil1Oi))),
		nlil1Oi = ((((wire_n011Oi_o[30] | wire_n011Oi_o[27]) | wire_n011Oi_o[26]) | wire_n011Oi_o[25]) | wire_n011Oi_o[24]),
		nlil1Ol = ((((((((wire_n011Oi_o[30] | wire_n011Oi_o[11]) | wire_n011Oi_o[10]) | wire_n011Oi_o[9]) | wire_n011Oi_o[8]) | wire_n011Oi_o[7]) | wire_n011Oi_o[6]) | wire_n011Oi_o[5]) | wire_n011Oi_o[4]),
		nlil1OO = ((((wire_n011iO_o[13] | wire_n011iO_o[7]) | wire_n011iO_o[4]) | wire_n011iO_o[2]) | wire_n011iO_o[1]),
		nlili0i = ((((((((((~ (rclkcmpsq1p[10] ^ ni0O1O)) & (~ (rclkcmpsq1p[11] ^ ni0O0i))) & (~ (rclkcmpsq1p[12] ^ ni0O0l))) & (~ (rclkcmpsq1p[13] ^ ni0O0O))) & (~ (rclkcmpsq1p[14] ^ ni0Oii))) & (~ (rclkcmpsq1p[15] ^ ni0Oil))) & (~ (rclkcmpsq1p[16] ^ ni0OiO))) & (~ (rclkcmpsq1p[17] ^ ni0Oli))) & (~ (rclkcmpsq1p[18] ^ ni0Oll))) & (~ (rclkcmpsq1p[19] ^ ni0OlO))),
		nlili1i = ((((((((((~ (rclkcmpsq1n[0] ^ ni00Ol)) & (~ (rclkcmpsq1n[1] ^ ni0liO))) & (~ (rclkcmpsq1n[2] ^ ni0lli))) & (~ (rclkcmpsq1n[3] ^ ni0lll))) & (~ (rclkcmpsq1n[4] ^ ni0llO))) & (~ (rclkcmpsq1n[5] ^ ni0lOi))) & (~ (rclkcmpsq1n[6] ^ ni0lOl))) & (~ (rclkcmpsq1n[7] ^ ni0lOO))) & (~ (rclkcmpsq1n[8] ^ ni0O1i))) & (~ (rclkcmpsq1n[9] ^ ni0O1l))),
		nlili1l = ((((((((((~ (rclkcmpsq1p[0] ^ ni00Ol)) & (~ (rclkcmpsq1p[1] ^ ni0liO))) & (~ (rclkcmpsq1p[2] ^ ni0lli))) & (~ (rclkcmpsq1p[3] ^ ni0lll))) & (~ (rclkcmpsq1p[4] ^ ni0llO))) & (~ (rclkcmpsq1p[5] ^ ni0lOi))) & (~ (rclkcmpsq1p[6] ^ ni0lOl))) & (~ (rclkcmpsq1p[7] ^ ni0lOO))) & (~ (rclkcmpsq1p[8] ^ ni0O1i))) & (~ (rclkcmpsq1p[9] ^ ni0O1l))),
		nlili1O = ((((((((((~ (rclkcmpsq1n[10] ^ ni0O1O)) & (~ (rclkcmpsq1n[11] ^ ni0O0i))) & (~ (rclkcmpsq1n[12] ^ ni0O0l))) & (~ (rclkcmpsq1n[13] ^ ni0O0O))) & (~ (rclkcmpsq1n[14] ^ ni0Oii))) & (~ (rclkcmpsq1n[15] ^ ni0Oil))) & (~ (rclkcmpsq1n[16] ^ ni0OiO))) & (~ (rclkcmpsq1n[17] ^ ni0Oli))) & (~ (rclkcmpsq1n[18] ^ ni0Oll))) & (~ (rclkcmpsq1n[19] ^ ni0OlO))),
		nliliii = (nliO1i & (nlii0i & (~ nliliil))),
		nliliil = (wire_nli1li_o | (nlilOl & nlil1lO)),
		nliliiO = ((~ rmatchen) | rgenericfifo),
		nlilili = (rmatchen | rgenericfifo),
		nlill0O = (wire_n1li_dataout | wire_n1iO_dataout),
		nlillii = (wire_n1O01i_o | (n11O1i & nlii01i)),
		nlillil = (((~ wire_nlO0OlO_dataout) & ((~ wire_nlO0Oli_dataout) & nlO00Ol)) & (~ (nli0O1O & nli0O1l))),
		nlillOi = ((wire_n1OllO_o & (nli0O1i & (((~ wire_nlO0OiO_dataout) & ((~ wire_nlO0Oil_dataout) & (rrx_pipe_enable & nlii0OO))) & nlO01O))) & ((~ nli0l0i) & (~ nlli0Oi))),
		nlillOl = ((((~ rrx_pipe_enable) & nli0ill) & nli0iOi) & nli0i0O),
		nlillOO = ((nliilOl & (~ nliiO0O)) & nliilOi),
		nlilO0l = (dskwclksel[1] & rmatchen),
		nlilOil = 1'b0,
		nlilOiO = (((((rauto_speed_ena & (~ rfreq_sel)) & (nlilOlO12 ^ nlilOlO11)) & nlll) | rdwidth_rx) | (~ (nlilOli14 ^ nlilOli13))),
		nliO10l = 1'b1,
		nliO11i = ((((rauto_speed_ena & (~ rfreq_sel)) & (nliO11l6 ^ nliO11l5)) & n1O) | rdwidth_rx),
		nliO1il = (wire_nlil_dataout | soft_reset),
		rdfifo_almost_empty = wire_nll_dataout,
		rdfifo_almost_full = wire_ni_dataout,
		rdfifo_empty = wire_nli_dataout,
		rdfifo_full = wire_nlO_dataout,
		rev_loop_data = {wire_niO1O_dataout, wire_niO1l_dataout, wire_niO1i_dataout, wire_nilOO_dataout, wire_nilOl_dataout, wire_nilOi_dataout, wire_nillO_dataout, wire_nilll_dataout, wire_nilli_dataout, wire_niliO_dataout, wire_nilil_dataout, wire_nilii_dataout, wire_nil0O_dataout, wire_nil0l_dataout, wire_nil0i_dataout, wire_nil1O_dataout, wire_nil1l_dataout, wire_nil1i_dataout, wire_niiOO_dataout, wire_niiOl_dataout},
		skpos_det = nlillil;
endmodule //cycloneiv_hssi_rx_digi_comp_chnl_top
//synopsys translate_on
//VALID FILE

//Rev: 1.37   Fri May 23 09:56:18 PDT 2008

`timescale 1 ps / 1 ps

module cycloneiv_hssi_rx_digi_rx_ctrl (
		// inputs
		//hard_reset,
		soft_reset,
		clk_2,
		rx_wr_clk, 
		rx_rd_clk, 
		scan_mode,
		rrxfifo_dis,
		//is_lane0,
		rindv_rx,
		rendec_data_sel_rx,
		rwa_6g_en,
		rrxfifo_lowlatency_en,	
		//indv_tx,
		endec_rx,
		//endec_tx,
		rinvalid_code_err_only,
		rrx_pipe_enable,
		rpmadatawidth,
		//renpolinv,
		rdwidth,
		rautoinsdis,
		rbytorden,
		rbytord_2sym_en,
		rbytordpat,
		rbytordpadval,
		rbytordplden,
		bytordplden,
		rsync_comp_size,
		rsync_comp_pat,
		rsync_comp_porn,
		rsync_sm_dis,
		//phfifo_wren_rx,
		//phfifo_rden_rx,
		rclkcmpinsertpad,
		rbytord_6g_mask_en,
		rbytord_s2gx,
		invalid_code_delay,
		sigdetni,
		dec_data_valid_pre, 
		dec_data_valid, 
		rx_data_rs,
		rx_control_rs, 
		rx_data_dt,
		rx_control_dt,
		tenb_data,
		sync_resync_pre,
		sync_resync_delay,
		disp_err_delay, 
		disp_val_delay,
		//rgenericfifo,
		//rdfifo_full,
		ovr_undflow,
		rrxfifo_urst_en,
		rxfifo_urst,
		rrxphfifopldctl_en,
		pld_wr_dis,
		pld_re,
		rrxpcsbypass_en,
		
		//PIPE Status signals
		phystatus_int,
		rxvalid_int,
		rxstatus_int,
		powerdown,

		// New inputs for new bundling scheme and new PCIE features like autospeed
    		reset_pc_ptrs,
    		reset_pc_ptrs_centrl,
    		reset_pc_ptrs_quad_up,
    		reset_pc_ptrs_quad_down,
    		gen2ngen1,
    		gen2ngen1_bundle,
    		dis_pc_byte,
    		wr_enable_centrl,
    		wr_enable_quad_up,
    		wr_enable_quad_down,
    		rd_enable_centrl,
    		rd_enable_quad_up,
    		rd_enable_quad_down,
		rx_we_in_centrl,
    		rx_we_in_quad_up,
    		rx_we_in_quad_down,
		
		// New MDIO for new bundling scheme and new PCIE features like autospeed
    		rauto_speed_ena,
    		rfreq_sel,
    		rphfifo_regmode_rx,
    		rmaster_rx,
    		rmaster_up_rx,
		
		// outputs
		rxd,
		rxd_9,
		rxd_19,
		rxc, 
		running_disp,
		signal_detect_out,
		rxd_lpbk, 
		rx_we_out,
		//full,
		ph_fifo_empty,
		ph_fifo_full,
		wr_enable_out,
		rd_enable_out,
		bytord_valid_out,
		soft_reset_rclk1,
		soft_reset_wclk1,
		
		// PIPE status signals
		phystatus,
		rxvalid,
		rxstatus,
		pipe_data,
		
		// test bus
		// rx_we_out,	// testbus[8], re-used
		wr_enable2,	// testbus[7]
		wptr_bin,	// testbus[6:4]
		rd_enable2,	// testbus[3]
		rptr_bin,	// testbus[2:0]
		
		pcs_wrapback_in,
		rpcs_wrapback_en
		); 
   
   // =======
   // inputs
   // =======
   input [1:0]   rbytorden;	// enable byte ordering block
   // 00: disable byte ordering on sync_status (auto byte ordering)
   // 01: 8-bit match, auto byte ordering or pld control byte ordering
   // 10: 9-bit match, auto byte ordering or pld control byte ordering
   // 11: 10-bit match, auto byte ordering or pld control byte ordering
   input         rbytord_2sym_en;	// enable 2 symbol longer byte ordering
   input [19:0]  rbytordpat;	// searched byte ordering pattern for byte ordering block, 
   // upper bits[19:10] is shared with
   // rsync_comp_pat[39:32]
   input [9:0] 	 rbytordpadval;	// Padded pattern for byte ordering block
   input 	 rbytordplden;	// enable byteordpld - dynamic signal
   input 	 bytordplden;	// byteordpld - dynamic signal. Positive Edge of 
   // this signal triggers new byte ordering
   input 	 rautoinsdis;	// disable automatic insertion of 8'h9c when invalid data
   
   //input  	      hard_reset;	// From MDIO_REG.V Complex function of NPOR, ENTEST etc.,
   input         soft_reset;
   
   input         clk_2;
   input         rx_rd_clk;      	// This replaces PLD_RX_CLK
   input 	 rx_wr_clk;      	// divided by 1 or 2 write clock.
   
   input         scan_mode;	// scan enable
   input         rrxfifo_dis; 	// (CRAM = 1) bypass phase comp fifo
   //input         is_lane0;    	// ch0
   input         rindv_rx;			// For non P_LPBK mode
   input         rendec_data_sel_rx;	// RX 8B10B decoder data out selection CRAM (1: indv; 0: sel SM)
   input         rwa_6g_en;		// decoder cascaded enable, indicating it is 6G or 3G
   input         rrxfifo_lowlatency_en;	// low latency enable
   //input         indv_tx;		// For P_LPBK mode
   input         endec_rx;		// Enable 8B/10B decoder for non P_LPBK mode
   //input         endec_tx;		// Enable 8B/10B encoder for P_LPBK mode
   input         rinvalid_code_err_only;	// treat only invalid code as errors
   input		rrx_pipe_enable;	// PIPE mode: treat 19C replacement as invalid code
   
   //input         renpolinv;	// Enable polarity inversion CRAM
   input         rdwidth;
   input         rpmadatawidth;
   input [2:0] 	 rsync_comp_size;
   input [39:0]  rsync_comp_pat;
   input         rsync_comp_porn;
   input         rsync_sm_dis;
   input         rclkcmpinsertpad;	// CRAM for PCI-E PAD value selection if an error occurs
   input 	 rbytord_6g_mask_en; //CRAM to enabled upper byte of 6G DW B.O. to be masked out
   input 	 rbytord_s2gx;	//CRAM to enable byte ordering to behave like S2GX byte ordering
   input [1:0] 	 invalid_code_delay;
   
   input         sigdetni; 		// from PMA directly
   input [1:0] 	 dec_data_valid_pre;	// decoded data valid 1 cycle ahead, for 3G BO enable
   input [1:0] 	 dec_data_valid;		// decoded data valid
   input [7:0] 	 rx_data_rs;		// data from rcv_sm
   input         rx_control_rs;		// control bits from rcv_sm
   input [15:0]  rx_data_dt;		// data from 8b10b decoder
   input [1:0] 	 rx_control_dt;		// control bits from 8b10b decoder
   input [19:0]  tenb_data;		// pre-decoded data
   input [1:0] 	 sync_resync_pre;		// sync_resync flag 1 cycle ahead, for A1A1A2A2 3G BO
   input [1:0] 	 sync_resync_delay;	// sync_resync flag
   input [1:0] 	 disp_err_delay;		// RD error flag
   input [1:0] 	 disp_val_delay;		// RD value flag
   //input         rgenericfifo;		// Select genericfifo mode
   //input         rdfifo_full;		// from comp_fifo
   input [3:0] 	 ovr_undflow;		// from dec_chnl_top

   // rx_we_out
   // Connect from channel zero rx_we_out 
   
   input         rrxfifo_urst_en;		// Enable rxfifo_urst
   input         rxfifo_urst;		// User reset exclusive to rx_ctrl & below
   input 	 rrxphfifopldctl_en;	// CRAM to enable PLD controlled write/read enable
   input         pld_wr_dis;		// PLD write disable
   input         pld_re;			// PLD read eanble
   
   input         rrxpcsbypass_en;    // CRAM for enable low-latency PCS bypass mode
   // PIPE status input
   input 	 phystatus_int;
   input 	 rxvalid_int;
   input [2:0] 	 rxstatus_int;
   input [1:0] 	 powerdown;
   
   // New Inputs for new bundling scheme and new PCIE features like autospeed
   input 	 reset_pc_ptrs;
   input 	 reset_pc_ptrs_centrl;
   input 	 reset_pc_ptrs_quad_up;
   input 	 reset_pc_ptrs_quad_down;
   input 	 gen2ngen1;
   input 	 gen2ngen1_bundle;
   input 	 dis_pc_byte;
   input 	 wr_enable_centrl;
   input 	 wr_enable_quad_up;
   input 	 wr_enable_quad_down;
   input 	 rd_enable_centrl;
   input 	 rd_enable_quad_up;
   input 	 rd_enable_quad_down;
   input 	 rx_we_in_centrl;
   input 	 rx_we_in_quad_up;
   input 	 rx_we_in_quad_down;
   
   // New MDIO for new bundling scheme and new PCIE features like autospeed
   input 	 rauto_speed_ena;
   input 	 rfreq_sel;
   input 	 rphfifo_regmode_rx;
   input 	 rmaster_rx;
   input 	 rmaster_up_rx;


   input [69:0]  pcs_wrapback_in;
   input 	 rpcs_wrapback_en;
      
         
   // =======
   // outputs
   // =======
   output [63:0] rxd;
   output [1:0]  rxd_9;
   output [1:0]  rxd_19;
   output [3:0]  rxc;
   output [1:0]  running_disp;	// Only used in XAUI receive state machine , only bit[0] is used
   output        signal_detect_out;// To control pin/bit
   output [39:0] rxd_lpbk;
   
   output        rx_we_out;	// connect channel zero rx_we_out 05/15/02 VC
   //output        full;		// Mux between rdfifo_full and ovr_undflow
   output        ph_fifo_full;	// phase comp. FIFO full flag
   output        ph_fifo_empty;	// phase comp. FIFO empty flag
   output        wr_enable_out;
   output        rd_enable_out;
   output        bytord_valid_out;	// byte ordering valid flag
   output        soft_reset_rclk1;	// reset output for PIPE interface module
   output 	 soft_reset_wclk1;
   
   // PIPE
   output 	 phystatus;
   output 	 rxvalid;
   output [2:0]  rxstatus;
   
   output [63:0] pipe_data;
   // ========
   // test bus
   // ========
   output        wr_enable2;
   output        rd_enable2;
   output [2:0]  wptr_bin;
   output [2:0]  rptr_bin;
   
   // ====================
   // signal declarations
   // ====================
   parameter 	 delay = 0;		// ensure hold time between
   // deserializer and fifo for RTL simulation
   
   wire [39:0] 	 rxd_lpbk; 
   wire [63:0] 	 rxd;
   wire [1:0] 	 rxd_9;
   wire [3:0] 	 rxc;
   wire [1:0] 	 running_disp;
   reg [1:0] 	 sync_resync_d;
   reg [1:0] 	 disp_err_d;
   reg [1:0] 	 disp_val_d;
   
   // reset signals
   wire 	 rrxfifo_urst_en;
   wire 	 local_soft_reset;		// OR of local & global resets. 
   wire 	 local_soft_reset_low;	// Inverted soft reset for active low fifo reset
   reg 		 soft_reset_wclk0;		
   reg 		 soft_reset_wclk1_b4scan;
   wire 	 soft_reset_wclk1;		// reset for fifo_wr_clk
   reg 		 soft_reset_rclk0;
   reg 		 soft_reset_rclk1_b4scan;
   wire 	 soft_reset_rclk1;		// reset for pld_rx_clk
   
   // flags
   reg [1:0] 	 sync_resync_delay_1;
   reg [1:0] 	 sync_resync_delay_2;
   reg [1:0] 	 disp_err_delay_1;
   reg [1:0] 	 disp_err_delay_2;
   reg [1:0] 	 disp_val_delay_1;
   reg [1:0] 	 disp_val_delay_2;
   reg [3:0] 	 ovr_undflow_d;	// pre-register value
   reg [3:0] 	 ovr_undflow0;	// delayed overflow/underflow flags in XAUI
   reg [3:0] 	 ovr_undflow1;	// delayed overflow/underflow flags in XAUI
   
   // pattern detection signals
   reg [1:0] 	 pattern_det_1_latch;
   reg [1:0] 	 pattern_det_int;
   reg [1:0] 	 pattern_det_int_delay_1;
   reg [1:0] 	 pattern_det_int_delay_2;
   reg           pd_16bit_high;
   reg           pd_20bit_high;
   reg           pd_32bit_low;
   reg           pd_40bit_low;
   reg           pd_32bit_high0;
   reg           pd_32bit_high1;
   reg           pd_40bit_high0;
   reg           pd_40bit_high1;
   reg [1:0] 	 pattern_det_d;
   reg [1:0] 	 pattern_det_2_latch;// Detection of second A1 for A1A1A2A2
   reg [1:0] 	 pattern_det_3_latch;// Detection of first A2 for A1A1A2A2
   
   // byte de-serializer signals
   reg [31:0] 	 data_lt_0_sync;
   reg [31:0] 	 data_lt_0;
   reg [31:0] 	 data_lt_1;
   wire [31:0] 	 data_lt_0_sync_aftermux;
   reg [19:0] 	 rx_data_int;
   reg           rx_we_out;	// Channel zero output should all channel rx_we_in of rx_ctrl
   
   // PMA signal detect output to PLD
   wire          signal_detect_out;
   
   // fifo IO
   reg [63:0] 	 fifo_data_in;
   wire [63:0] 	 fifo_data_out;	// Data out from the fifo
   
   reg 		 rd_enable0;
   reg 		 rd_enable0p5;
   reg 		 rd_enable1;
   reg 		 rd_enable2;
   reg 		 pld_wr_dis0;
   reg 		 pld_wr_dis1;
   reg 		 pld_wr_dis2;
   reg 		 pld_wr_dis_edge;
   reg 		 wr_enable0;
   reg 		 wr_enable0p5;
   reg 		 wr_enable1;
   reg 		 wr_enable2;
   reg 		 rxfifo_en_clk2_0;
   reg 		 rxfifo_en_clk2_1;
   reg 		 wr_enable_clk2;
   
   // byte ordering signals
   wire [63:0] 	 din0;
   reg [63:0] 	 din1;
   reg [47:0] 	 din1_d;
   reg [63:0] 	 din2;
   
   reg 		 bytordpaten0;
   reg 		 bytordpaten1;
   reg 		 bytordpaten2;
   reg 		 bytordpaten3;
   wire [1:0] 	 bytordpaten4;
   reg [1:0] 	 bytordpaten5;
   reg 		 bytord_valid;
   reg [3:0] 	 bytordpat_det;
   reg [3:0] 	 bytordpat_det0;
   wire 	 bytord_valid0;	
   
   wire 	 bytord_valid_fifoout;
   
   // debug signals
   wire [2:0] 	 wptr_bin;
   wire [2:0] 	 rptr_bin;
   
   // misc.
   wire 	 din_6g;
   wire [1:0] 	 false_rd_error;
   reg [1:0] 	 dec_data_valid_d0_int;
   wire [1:0] 	 dec_data_valid_d0;
   
   
   // PIPE
   wire [4:0] 	 pipe_status_in;
   wire [4:0] 	 pipe_status_out;
   
   wire 	 phystatus;
   wire 	 phystatus_sync;
   
   wire 	 rxvalid;
   wire [2:0] 	 rxstatus;
   
   wire [63:0] 	 pipe_data;
   
   wire 	 decode_p2;
   reg 		 decode_p2_reg;
   reg 		 decode_p2_reg1;
   
   reg 		 phystatus_out_reg;
   reg 		 phystatus_out_reg1;
   reg 		 phystatus_gap_filler;
   
   reg 		 wa_lock_achieved;
   reg		 wa_lock_achieved_s2gx;

   wire 	 rdwidth_or_auto;
   wire 	 gen2ngen1_int;
   reg 		 gen2ngen1_reg;
   reg 		 gen2ngen1_sync;
      
   
   reg bytord_valid0_d1; //ML 11-19-07
   reg bytord_valid0_d2; //ML 01-17-08
 
 //------------------------------------------
 // Used for 3G SYNC SM Enabled cases only
 // K.Kankipati 02/29/2008
 //------------------------------------------
  wire din_3g_sync_sm_en;
  assign  din_3g_sync_sm_en =  ~din_6g & ~rsync_sm_dis ;

// signal detect is taken directly from PMA and only buffered here
assign signal_detect_out = sigdetni;
//---------
   
   always @ (posedge rx_rd_clk or posedge soft_reset_rclk1)
     begin
	if (soft_reset_rclk1)
	  begin
	     decode_p2_reg			<= #1 1'b0;
	     decode_p2_reg1			<= #1 1'b0;
	  end
	else
	  begin
	     decode_p2_reg		<= #1  decode_p2;
	     decode_p2_reg1		<= #1  decode_p2_reg;
	  end
     end
   
   always @ (posedge rx_rd_clk or posedge soft_reset_rclk1)
     begin
	if (soft_reset_rclk1)
	  begin
	     phystatus_out_reg		<= #1  1'b0;
	     phystatus_out_reg1		<= #1  1'b0;
	     phystatus_gap_filler	<= #1  1'b1;
	  end
	else
	  begin
	     phystatus_out_reg		<= #1  pipe_status_out[0];
	     phystatus_out_reg1		<= #1  phystatus_out_reg;
	     
	     if ((phystatus_gap_filler == 1'b1) && phystatus_out_reg && ~phystatus_out_reg1)
	       phystatus_gap_filler <= #1  1'b0;
	  end			
     end
   
   // =============
   // functionality
   // =============
   assign din_6g = rwa_6g_en;
   
   assign local_soft_reset = soft_reset | (rrxfifo_urst_en && rxfifo_urst) ;
   
   // delay underflow/overflow flags by 2 clks if RX SM is used. This aligns flags and data
   //assign ovr_undflow_d = (rendec_data_sel_rx)? ovr_undflow : ovr_undflow1;
   
   // Error Replacement condition
   // XAUI or GiGE: RD Error Or Invalid Code
   // Else: Invalid Code Only
   assign running_disp = (rinvalid_code_err_only)? invalid_code_delay : disp_err_delay | invalid_code_delay;
   
   // bypass FIFO
   assign rxd    = (rrxfifo_dis)? din2[63:0] : fifo_data_out[63:0];  
   
   // bypass FIFO
   assign rxc    = (rrxfifo_dis)? 
                     {din2[56], din2[40], din2[24], din2[8]}  
                     : {fifo_data_out[56], fifo_data_out[40], fifo_data_out[24], fifo_data_out[8]};  // 8b 10b control bits
   // bypass FIFO
   assign rxd_9  = (rrxfifo_dis)? 
                     {din2[25], din2[9]}  
                     : {fifo_data_out[25], fifo_data_out[9]};   
   // bypass FIFO
   assign rxd_19 =  (rrxfifo_dis)?
                      {din2[57], din2[41]}  
                      : {fifo_data_out[57], fifo_data_out[41]}; 
   
   // bypass FIFO
   assign bytord_valid_out = (rrxfifo_dis)? bytord_valid0 : bytord_valid_fifoout;
   
   // bypass FIFO
   
   assign pipe_status_in = {rxstatus_int,rxvalid_int, phystatus_int};
   
   //assign phystatus_sync = (rrxfifo_dis)? pipe_status_in[0]: pipe_status_out[0] | phystatus_gap_filler;
   assign phystatus = (rrxfifo_dis)? pipe_status_in[0]: pipe_status_out[0];
   //assign phystatus = (~decode_p2 && decode_p2_reg1)? 1'b1: phystatus_sync;
   //assign decode_p2 = (powerdown == 2'b11)? 1'b1: 1'b0;


   assign rxvalid = (rrxfifo_dis)? pipe_status_in[1]: pipe_status_out[1];
   assign rxstatus = (rrxfifo_dis)? pipe_status_in[4:2]: pipe_status_out[4:2];
   
   assign pipe_data = din2;
   
   assign wr_enable_out = wr_enable1;
   assign rd_enable_out = rd_enable1;
   
   // pattern detection[0]
   // In A1A2 mode, tenB_data[8] is A1A2_SIZE 
   always @ (rwa_6g_en or rpmadatawidth or rsync_comp_size or tenb_data or rsync_comp_pat or 
             pattern_det_1_latch or pattern_det_3_latch or pd_16bit_high or pd_20bit_high or
             pd_32bit_high1 or pd_40bit_high1 or rsync_comp_porn)
     begin
	casex ({rwa_6g_en, rpmadatawidth,rsync_comp_size, tenb_data[8]})
	  // 6G 7-bit pattern detection
	  6'b11000x: pattern_det_int[0] = (tenb_data[6:0] == rsync_comp_pat[6:0]) || 
					  (rsync_comp_porn && (tenb_data[6:0] == ~rsync_comp_pat[6:0]));
	  // 6G 8-bit pattern detection
	  6'b10001x: pattern_det_int[0] = (tenb_data[7:0] == rsync_comp_pat[7:0]) || 
					  (rsync_comp_porn && (tenb_data[7:0] == ~rsync_comp_pat[7:0]));
	  // 6G 10-bit pattern detection
	  6'b11010x: pattern_det_int[0] = (tenb_data[9:0] == rsync_comp_pat[9:0]) || 
					  (rsync_comp_porn && (tenb_data[9:0] == ~rsync_comp_pat[9:0]));
	  // 6G 16-bit pattern detection
	  6'b10011x: pattern_det_int[0] = ((tenb_data[ 7:0] == rsync_comp_pat[15:8]) || 
					   (rsync_comp_porn && (tenb_data[ 7:0] == ~rsync_comp_pat[15:8]))) && pd_16bit_high;
	  // 6G 20-bit pattern detection
	  6'b11100x: pattern_det_int[0] = ((tenb_data[9:0] == rsync_comp_pat[19:10]) || 
					   (rsync_comp_porn && (tenb_data[9:0] == ~rsync_comp_pat[19:10]))) && pd_20bit_high;
	  // 6G 32-bit pattern detection 
	  6'b10101x: pattern_det_int[0] = ((tenb_data[ 7:0] == rsync_comp_pat[31:24]) || 
					   (rsync_comp_porn && (tenb_data[ 7:0] == ~rsync_comp_pat[ 31:24]))) && pd_32bit_high1;
	  // 6G 40-bit pattern detection 
	  6'b11110x: pattern_det_int[0] = ((tenb_data[ 9:0] == rsync_comp_pat[39:30]) || 
					   (rsync_comp_porn && (tenb_data[ 9:0] == ~rsync_comp_pat[ 39:30]))) && pd_40bit_high1;
	  // 3G 7-bit
	  6'b01000x: pattern_det_int[0] = (tenb_data[6:0] == rsync_comp_pat[6:0]) || (tenb_data[6:0] == ~rsync_comp_pat[6:0]);
	  // 3G 10-bit
	  6'b01010x: pattern_det_int[0] = (tenb_data[9:0] == rsync_comp_pat[9:0]) || (tenb_data[9:0] == ~rsync_comp_pat[9:0]);
	  // 3G 16/32-bit
	  default: if (tenb_data[8])
            pattern_det_int[0] = (tenb_data[7:0] == rsync_comp_pat[15:8]) && pattern_det_3_latch[0];
          else 
            pattern_det_int[0] = (tenb_data[7:0] == rsync_comp_pat[15:8]) && pattern_det_1_latch[0];                 
	endcase
     end
   
   // pattern detection[1]
   // In A1A2 mode, tenB_data[18] is A1A2_SIZE 
   always @ (rwa_6g_en or rpmadatawidth or rsync_comp_size or tenb_data or rsync_comp_pat or 
             pattern_det_1_latch or pattern_det_3_latch or pd_32bit_low or pd_40bit_low or rsync_comp_porn)
     begin
	casex ({rwa_6g_en, rpmadatawidth,rsync_comp_size, tenb_data[18]})
	  // 6G 7-bit pattern detection
	  6'b11000x: pattern_det_int[1] = (tenb_data[16:10] == rsync_comp_pat[6:0]) || 
					  (rsync_comp_porn && (tenb_data[16:10] == ~rsync_comp_pat[6:0]));
	  // 6G 8-bit pattern detection
	  6'b10001x: pattern_det_int[1] = (tenb_data[17:10] == rsync_comp_pat[7:0]) || 
					  (rsync_comp_porn && (tenb_data[17:10] == ~rsync_comp_pat[7:0]));
	  // 6G 10-bit pattern detection
	  6'b11010x: pattern_det_int[1] = (tenb_data[19:10] == rsync_comp_pat[9:0]) || 
					  (rsync_comp_porn && (tenb_data[19:10] == ~rsync_comp_pat[9:0]));
	  // 6G 16-bit pattern detection
	  6'b10011x: pattern_det_int[1] = ({tenb_data[17:10],tenb_data[7:0]} == rsync_comp_pat[15:0]) || 
					  (rsync_comp_porn && 
					   ((tenb_data[ 7: 0] == rsync_comp_pat[ 7:0]) | (tenb_data[ 7: 0] == ~rsync_comp_pat[ 7:0])) &&
					   ((tenb_data[17:10] == rsync_comp_pat[15:8]) | (tenb_data[17:10] == ~rsync_comp_pat[15:8])));
	  // 6G 20-bit pattern detection
	  6'b11100x: pattern_det_int[1] = (tenb_data[19:0] == rsync_comp_pat[19:0]) || 
					  (rsync_comp_porn && 
					   ((tenb_data[ 9: 0] == rsync_comp_pat[ 9: 0]) | (tenb_data[ 9: 0] == ~rsync_comp_pat[ 9: 0])) &&
					   ((tenb_data[19:10] == rsync_comp_pat[19:10]) | (tenb_data[19:10] == ~rsync_comp_pat[19:10])));
	  // 6G 32-bit pattern detection 
	  6'b10101x: pattern_det_int[1] = (({tenb_data[17:10],tenb_data[7:0]} == rsync_comp_pat[31:16]) || 
					   (rsync_comp_porn && 
                                            ((tenb_data[ 7: 0] == rsync_comp_pat[23:16]) | (tenb_data[ 7: 0] == ~rsync_comp_pat[23:16])) &&
                                            ((tenb_data[17:10] == rsync_comp_pat[31:24]) | (tenb_data[17:10] == ~rsync_comp_pat[31:24])))) 
                                            && pd_32bit_low; 
	  
	  // 6G 40-bit pattern detection 
	  6'b11110x: pattern_det_int[1] = ((tenb_data[19:0] == rsync_comp_pat[39:20]) || 
					   (rsync_comp_porn && 
                                            ((tenb_data[ 9: 0] == rsync_comp_pat[29:20]) | (tenb_data[ 9: 0] == ~rsync_comp_pat[29:20])) &&
                                            ((tenb_data[19:10] == rsync_comp_pat[39:30]) | (tenb_data[19:10] == ~rsync_comp_pat[39:30])))) 
                                            && pd_40bit_low; 
	  
	  // 3G 7-bit pattern detection
      6'b01000x: pattern_det_int[1] = (tenb_data[16:10] == rsync_comp_pat[6:0]) || (tenb_data[16:10] == ~rsync_comp_pat[6:0]);
	  // 3G 10-bit pattern detection
	  6'b01010x: pattern_det_int[1] = (tenb_data[19:10] == rsync_comp_pat[9:0]) || (tenb_data[19:10] == ~rsync_comp_pat[9:0]);
	  // 3G 16/32-bit pattern detection
	  default: if (tenb_data[18])
            pattern_det_int[1] = (tenb_data[17:10] == rsync_comp_pat[15:8]) && pattern_det_3_latch[1];
          else 
            pattern_det_int[1] = (tenb_data[17:10] == rsync_comp_pat[15:8]) && pattern_det_1_latch[1];                 
	endcase
     end
   
   
   assign rxd_lpbk = {fifo_data_out[57:48], fifo_data_out[41:32], fifo_data_out[25:16], fifo_data_out[9:0]};
   
   
   // the first cycle sync_status goes high: 
   // if RD error  occurs but not invalid code, it is false RD error because
   // it is between last un-aligned code and the first aligned code
   // need to ignore it, else error replacement will replace the first aligned code
   assign false_rd_error[0] = din_6g && ~rinvalid_code_err_only && ~invalid_code_delay[0] && disp_err_delay[0] && 
          sync_resync_delay[0] && ~sync_resync_delay_1[0];
   assign false_rd_error[1] = din_6g && ~rinvalid_code_err_only && ~invalid_code_delay[1] && disp_err_delay[1] && 
          sync_resync_delay[1] && ~sync_resync_delay_1[1];
   
   always @ (endec_rx or rendec_data_sel_rx or
	     rx_data_rs or rx_data_dt or tenb_data or
	     rx_control_rs or rx_control_dt or dec_data_valid_d0 or 
	     running_disp or sync_resync_delay or sync_resync_pre or disp_err_delay or disp_val_delay or
	     rsync_sm_dis or pattern_det_int or rautoinsdis or rclkcmpinsertpad or
	     sync_resync_delay_2 or disp_err_delay_2 or disp_val_delay_2 or pattern_det_int_delay_2 
	     or ovr_undflow or ovr_undflow1 or false_rd_error or rrx_pipe_enable or din_3g_sync_sm_en
	     )
     
     begin
	if (endec_rx)	// decoded 8b10b code
	  begin
	     if (rendec_data_sel_rx)	// select decoder dout
	       begin
                  //------------------------------------------------------------------------- 
                  //sync_resync_d pulled ahead by one clock cycle for 3G SYNC SM enabled cases
                  //K.Kankipati 02/29/2008
                  //------------------------------------------------------------------------- 
		  sync_resync_d = din_3g_sync_sm_en ?sync_resync_pre:sync_resync_delay;
		  //sync_resync_d = sync_resync_delay;
		  disp_err_d = disp_err_delay;
		  disp_val_d = disp_val_delay;
		  ovr_undflow_d = ovr_undflow;
		  
		  // Begin Low byte processing
		  if (dec_data_valid_d0[0] == 1'b0)	// initial data
		    begin
		       //rx_data_int[9] = (rsync_sm_dis)? running_disp[0] : 1'b0; // Not error
// LMC: 03/26/08 PIPE modes: when 19c replacement occurs, treat as invalid code error
//		    rx_data_int[9] = running_disp[0]; // keep error flag, recommended by PIPE, XAUI/GIGE are ok

		       if(!rsync_sm_dis && !rautoinsdis)	// Non-PIPE or PIPE, both use 19C as filler cell
                         begin
// LMC: 03/26/08 PIPE modes: when 19c replacement occurs, treat as invalid code error and stuff with EDB instead
//			    rx_data_int[8:0] = 9'h19C;	// 9'h19C = /Q/
			    pattern_det_d[0] = 1'b0;	// Not idle
// LMC: 03/26/08 PIPE modes: when 19c replacement occurs, treat as invalid code error
				if (rrx_pipe_enable)
				begin
			     	rx_data_int[9] = 1'b1;
			     	rx_data_int[8:0] = 9'h1FE;	// 9'h1FE = EDB
			     end
			    	else
			    	begin
			    		rx_data_int[9] = running_disp[0]; // keep error flag
				     rx_data_int[8:0] = 9'h19C;	// 9'h19C = /Q/
			    	end
                 end
		       else
                         begin
			    rx_data_int[8:0] = {rx_control_dt[0], rx_data_dt[7:0]};
			    pattern_det_d[0] = pattern_det_int[0];

// LMC: 04/04/08 For non PIPE modes keep rxd[9] as running_disp 
			    		rx_data_int[9] = running_disp[0]; // keep error flag

                         end
		    end
		  else 	// valid data
		    begin
		       rx_data_int[9] = running_disp[0]; 
		       pattern_det_d[0] = pattern_det_int[0];
		       //SYNC SM enabled and error happens
		       if (dec_data_valid_d0[0] && !rautoinsdis && ~rsync_sm_dis && running_disp[0] && ~false_rd_error[0]) // Non-PIPE or PIPE, diff. running_disp
			 rx_data_int[8:0] = (rclkcmpi